// BME main definitions header file

#define GFX_SCANLINES 1
#define GFX_DOUBLESIZE 2
#define GFX_USE1PAGE 0
#define GFX_USE2PAGES 4
#define GFX_USE3PAGES 8
#define GFX_WAITVBLANK 16
#define GFX_FULLSCREEN 32
#define GFX_WINDOW 64
#define GFX_NOSWITCHING 128
#define GFX_USEDIBSECTION 256

#define MOUSE_ALWAYS_VISIBLE 0
#define MOUSE_FULLSCREEN_HIDDEN 1
#define MOUSE_ALWAYS_HIDDEN 2

#define MOUSEB_LEFT 1
#define MOUSEB_RIGHT 2
#define MOUSEB_MIDDLE 4

#define JOY_LEFT 1
#define JOY_RIGHT 2
#define JOY_UP 4
#define JOY_DOWN 8
#define JOY_FIRE1 16
#define JOY_FIRE2 32
#define JOY_FIRE3 64
#define JOY_FIRE4 128

#define LEFT 0
#define MIDDLE 128
#define RIGHT 255

#define B_OFF 0
#define B_SOLID 1
#define B_NOTSOLID 2

#define MONO 0
#define STEREO 1
#define EIGHTBIT 0
#define SIXTEENBIT 2

#define VM_OFF 0
#define VM_ON 1
#define VM_ONESHOT 0
#define VM_LOOP 2
#define VM_16BIT 4

#define KEY_BACKSPACE           0x0E
#define KEY_CAPSLOCK            0x3A
#define KEY_ENTER               0x1C
#define KEY_ESC                 0x01
#define KEY_ALT                 0x38
#define KEY_CTRL                0x1D
#define KEY_LEFTSHIFT           0x2A
#define KEY_RIGHTSHIFT          0x36
#define KEY_NUMLOCK             0x45
#define KEY_SCROLLLOCK          0x46
#define KEY_SPACE               0x39
#define KEY_TAB                 0x0F
#define KEY_F1                  0x3B
#define KEY_F2                  0x3C
#define KEY_F3                  0x3D
#define KEY_F4                  0x3E
#define KEY_F5                  0x3F
#define KEY_F6                  0x40
#define KEY_F7                  0x41
#define KEY_F8                  0x42
#define KEY_F9                  0x43
#define KEY_F10                 0x44
#define KEY_F11                 0x57
#define KEY_F12                 0x58
#define KEY_A                   0x1E
#define KEY_N                   0x31
#define KEY_B                   0x30
#define KEY_O                   0x18
#define KEY_C                   0x2E
#define KEY_P                   0x19
#define KEY_D                   0x20
#define KEY_Q                   0x10
#define KEY_E                   0x12
#define KEY_R                   0x13
#define KEY_F                   0x21
#define KEY_S                   0x1F
#define KEY_G                   0x22
#define KEY_T                   0x14
#define KEY_H                   0x23
#define KEY_U                   0x16
#define KEY_I                   0x17
#define KEY_V                   0x2F
#define KEY_J                   0x24
#define KEY_W                   0x11
#define KEY_K                   0x25
#define KEY_X                   0x2D
#define KEY_L                   0x26
#define KEY_Y                   0x15
#define KEY_M                   0x32
#define KEY_Z                   0x2C
#define KEY_1                   0x02
#define KEY_2                   0x03
#define KEY_3                   0x04
#define KEY_4                   0x05
#define KEY_5                   0x06
#define KEY_6                   0x07
#define KEY_7                   0x08
#define KEY_8                   0x09
#define KEY_9                   0x0A
#define KEY_0                   0x0B
#define KEY_MINUS               0x0C
#define KEY_EQUAL               0x0D
#define KEY_BRACKETL            0x1A
#define KEY_BRACKETR            0x1B
#define KEY_SEMICOLON           0x27
#define KEY_APOST1              0x28
#define KEY_APOST2              0x29
#define KEY_COMMA               0x33
#define KEY_COLON               0x34
#define KEY_SLASH               0x35
#define KEY_BACKSLASH           0x2B
#define KEY_SLASH2              0x35
#define KEY_DEL                 0x53
#define KEY_DOWN                0x50
#define KEY_END                 0x4F
#define KEY_HOME                0x47
#define KEY_INS                 0x52
#define KEY_LEFT                0x4B
#define KEY_PGDN                0x51
#define KEY_PGUP                0x49
#define KEY_RIGHT               0x4D
#define KEY_UP                  0x48
#define KEY_WINDOWSL            0x5B
#define KEY_WINDOWSR            0x5C
#define KEY_MENU                0x5D
#define KEY_PAUSE               0xFF

typedef struct
{
	char *start;
	char *repeat;
	char *end;
	unsigned char voicemode;
} SAMPLE;

typedef struct
{
	volatile char *pos;
	char *repeat;
	char *end;
	SAMPLE *smp;
	unsigned freq;
	volatile unsigned fractpos;
	int vol;
	int mastervol;
	unsigned panning;
	volatile unsigned voicemode;
} CHANNEL;

typedef struct
{
  unsigned char rawcode;
  char *name;
} KEY;

typedef struct
{
  unsigned short xsize;
  unsigned short ysize;
  short xhot;
  short yhot;
  unsigned offset;
} SPRITEHEADER;

typedef struct
{
  unsigned type;
  unsigned offset;
} BLOCKHEADER;

typedef struct
{
  char blocksname[13];
  char palettename[13];
} MAPHEADER;

typedef struct
{
  int xsize;
  int ysize;
  char xdivisor;
  char ydivisor;
  char xwrap;
  char ywrap;
} LAYERHEADER;

extern int bme_error;
