; HIMEM-Erweiterung auf UMBs fr DOS 5 .. 7 ;
; Original (c) Peter Siering, erschienen in c't 8/91
; Erweiterte Version von as (Schpers), 15-AUG-91.
; Erweiterte Version von as (Stiller), c't 11/95
; Assemblieren/Linken mit  TASM + Tlink  + Exe2bin
; Fr Saturn, Mercury, Neptun, (C000h-EFFFh)
; Triton (mit DMA nur E000-EFFFh !)
; Aufruf mit:

; DEVICE=UMBPCI.SYS /I=aaaa-bbbb /I=cccc-dddd....

; Beispiel: DEVICE=UMBPCI.SYS /I=CC00-CFFF /I=E000-EFFF

          .MODEL SMALL
          .CODE
          .386

INITREQUEST STRUC   ; Parameterblock fr INIT
  irLength        db ?    ; Gesamtumfang des Parameterblocks
  irUnit          db ?    ; nicht verwendet
  irFunction      db ?    ; Funktion $00, d.h. Init
  irStatus        dw ?    ; Ergebniscode der Initialisierung
  irReserved      db 8 dup (?) ; "reserviert", nicht verwendet
  irUnits         db ?    ; Zahl der vom Treiber bedienten Gerte
  irEndAddress    dd ?    ; hchste verfgbare/belegte Speicheradr.
  irParamAddress  dd ?    ; Adresse der Kommandozeile (device=...)
  irDriveNumber   db ?    ; erste nicht belegte Laufwerks-Kennz.
  irMessageFlag   db ?    ; Flag fr Fehlermeldungen
INITREQUEST ENDS

; Gertetreiberkopf
DNext     dd -1           ; Adresse des nchsten Treibers: FFFF:FFFF
DAttr     dw 0E000h       ; Attribute
DStrat    dw OFFSET Strat ; Offset der "Strategie"-Routine
DIntr     dw OFFSET Intr  ; Offset der "Interrupt"-Routine
DName     db 'UMBADDXX'   ; Name (oder Units)

ParamAddr    dd ?         ; Zwischenspeicher fr INIT-Parameterblock

; Strategie-Routine, speichert ES:BX (Parameterblock-Adresse)
Strat     PROC FAR
          mov Word Ptr [ParamAddr],bx
          mov Word Ptr [ParamAddr+2],es
          retf
Strat     ENDP

; Interrupt-Routine, definiert nur die INIT-Funktion
Intr      PROC FAR
          push ax         ; mehr als diese drei Register
          push bx         ; werden momentan nicht gebraucht
          push es
          pushf
          les  bx,[ParamAddr] ; ES:BX = Parameterblock
          mov  es:[bx+irStatus],8103h ; pessimistischer Ansatz
          mov  al,es:[bx+irFunction] ; Funktionsnummer
          or   al,al      ; Init?
          jnz  OtherCmd   ; Code "Befehl unbekannt" gesetzt
          call InitFunc   ; INIT - liefert Status in AX
          les  bx,[ParamAddr]
          mov  es:[bx+irStatus],ax
OtherCmd:
	  popf
          pop  es
          pop  bx
          pop  ax
          retf
Intr      ENDP

UMBEntry STRUC
Start     dw ?      ; Startadresse (Paragraphs)
Len       dw ?      ; Lnge Paragraphs
UMBEntry ENDS

UMBList  dw 22 dup(0) ; maximal 10 Eintrge

; wird von IntFunc in die Kette eingesetzt und von DOS
; zum Belegen der UMBs aufgerufen.
; Aufruf: DX = gewnschte Gre (Bytes), Flags auf dem Stack
; Zurck: DX = Gre gefundener Block, BX = Segment, AX = 1
;         bzw. AX = 0 und BL = $B1 fr "berhaupt kein Block"
;         bzw. AX = 0 und BL = $B0 fr "Block zu klein"
UMBRequest PROC NEAR
          push ds
          push si
          push cx
          push bx

          push cs
          pop  ds     ; DS aufs Codesegment
          mov  si,OFFSET UMBList
          xor  cx,cx  ; fr Grenvergleich
          cld         ; aufsteigende Richtung
UMBSearch:
          lodsw       ; ein Eintrag der UMB-Liste
          or   ax,ax  ; Listenende?
          jz   UMBEnd ; -> ja, nicht gefunden
          mov  bx,ax  ; Startsegment festhalten
          lodsw
          cmp  bx,-1  ; bereits besetzt?
          jz   UMBSearch ; -> ja, nchster Eintrag
          cmp  ax,cx  ; bis dato grter Block?
          jb   ChkSize
          mov  cx,ax  ; ja, Gre festhalten
ChkSize:  cmp  ax,dx  ; reicht die Gre?
          jb   UMBSearch ; -> nein, nchster Block
UMBFound: mov Word Ptr[si-4],-1 ; Block als vergeben markieren
          mov  dx,ax  ; Gre in DX, Segment in BX
          pop  ax     ; altes BX vom Stack
          mov  ax,1   ; Signal fr Erfolg
          jmp  Short UMBDone
UMBEnd:   xor  ax,ax
          pop  bx     ; BX-Original (BH)
          mov  bl,0B0h ; Annahme: Block nur zu klein
          mov  dx,cx   ; zurckzuliefernde Blockgre
          or   dx,dx  ; irgendetwas gefunden?
          jnz  UMBDone ; -> ja, nur zu klein
          inc  bl     ; gar nichts gefunden: BL = $B1
UMBDone:  pop  cx
          pop  si
          pop  ds
          popf
          retf
UMBRequest ENDP

; Kette von HIMEM.SYS
XMSOrgJmp dd ?       ; Originalwert
NewChain: jmp short NewCtrl
          nop        ; an dieser Stelle wrde der nchste
          nop        ; Handler seinen Sprung einsetzen
          nop
NewCtrl:  pushf
          cmp  ah,10h  ; UMB request?
          jz  UMBRequest ; Flags auf dem Stack!
          popf
          jmp  [XMSOrgJmp] ; sonst Weitergabe

;
END_RESIDENT LABEL   BYTE   ; hier endet der residente Teil
;
; *** Beginn des nicht residenten Teils ***
CRLF      db 13,10,'$'

PrintString:
          push dx
          mov  dx,OFFSET CRLF
          call DoPrint
          pop  dx
          call DoPrint
          mov  dx,OFFSET CRLF
DoPrint:  mov  ah,09h
          int  21h
          ret

; Ausgabe einer Hex-Zahl mit vier Stellen (AX)
HDigits   db '0123456789ABCDEF'
PrHex:    mov  cx,0Ch   ; beim ersten Mal 12 Bit schieben
PrDig:    push ax
          shr  ax,cl
          and  ax,000Fh
          mov  bx,ax
          mov  dl,[HDigits+bx]
          mov  ah,2     ; "Display Output"
          int  21h
          pop  ax
          sub  cl,4
          jnb  PrDig
          ret

; Ausgabe einer Fehlermeldung ber die DOS-Funktion $09 und Abbruch
; Aufruf mit DS:DX = Text der Meldung
ErrOut:   call PrintString               ; Textausgabe
          mov  ax,0
          int  16h
          les  bx,[ParamAddr]
          mov  Word Ptr es:[bx+irEndAddress],0 ; 0 Bytes Platzbedarf
          mov  ax,8100h  ; Fehler (unspezifisch)
          jmp  InitEnd

; Initialisierung - wird mit ES:DI = Parameterblock und
; ES,BX,AX/Flags auf dem Stack aufgerufen, d.h. mu sich um
; diese Register nicht mehr kmmern
InitFunc  PROC NEAR
          push cx
          push dx
          push si
          push di
          push ds

          push cs
          pop  ds          ; DS aufs Codesegment

          mov  Word Ptr es:[bx+irEndAddress],OFFSET CRLF
          mov  Word Ptr es:[bx+irEndAddress+2],cs ; Endaddr eintragen
          mov  dx,OFFSET Copyright$  ; "Gr Gott"
          call PrintString

; HIMEM installiert?
chkHimem:
          mov  ax,4300h    ; Installationsprfung von HIMEM
          int  2Fh
          cmp  al,80h      ; vorhanden?
          jz   GetXMSCall  ; -> ja
          mov  dx,OFFSET NoXMS$
          jmp  ErrOut
; Kette ermitteln
GetXMSCall:
          mov  ax,4310h    ; HIMEM: Einsprungadresse
          int  2Fh
          mov  Word Ptr [XMSOrgJmp],bx
          mov  Word Ptr [XMSOrgJmp+2],es
; Existiert bereits ein UMB Server?
          mov  ah,16
          mov  dx,0FFFh    ; Anfordern eines Blocks mit 64 KByte
          call [XMSOrgJmp]
          cmp  bl,80h      ; nicht installiert?
          jz   GetCmdLine  ; -> OK
          mov  dx,OFFSET UMBPresent$
          jmp  ErrOut      ; da ist schon wer!
; Kommandozeile auswerten
GetCmdLine:
          les  di,[ParamAddr]  ; Parameterblock
          les  di,es:[di+irParamAddress] ; ES:DI auf Kommandozeile
          call SetList     ; Auswerten und Liste setzen
          jnc  TestAreas   ; -> OK
          mov  dx,OFFSET BadCmd$
          jmp  ErrOut      ; Kommandozeile ausgeben

TestAreas:CALL INITChipset
          JC   chipseterr

          mov  si,OFFSET UMBList
          cld
NextUMB:  lodsw            ; Startadresse
          or  ax,ax        ; Ende der Liste erreicht?
          jz  AreasTested
          mov es,ax        ; Startadresse in ES
          lodsw            ; Gre (Paragraphs)
          mov  cl,10       ; Umrechnung in 16K-Blocks
          shr  ax,cl       ; => Anzahl der 16-K-Blcke
TstBlocks: xor  di,di
          Call setchipset   ; Segment ES, Gre 16 freischalten
          jc   Chipseterr
          mov  bx,es:[di]   ; momentanen Inhalt lesen
          mov  dx,bx
          xor  dx,0FFFFh    ; Umdrehen
          mov  es:[di],dx   ; und Schreiben
          mov  cx,80h       ; einen Moment warten, falls die
          loop $            ; Operation ins Leere gehen sollte
          cmp  es:[di],dx   ; haben wir einen konstanten Wert?
          mov  es:[di],bx   ; alten Inhalt zurck
          jnz  NoRAM        ; -> kein RAM an dieser Stelle!
          dec  ax
          jz   NextUMB      ; -> nchster UMB-Bereich
          mov  di,es
          add  di,0400h     ; sonst ES 16K aufwrts
          mov  es,di
          jmp  TstBlocks    ; und nchsten 16K-Block prfen

NoRAM:    push es           ; Segmentadresse des Blocks
          mov  dx,OFFSET RAMFail1$
          call DoPrint      ; Ausgabe ohne CRLF
          pop  ax
          call PrHex        ; Segmentadresse ausgeben
          mov  dx,OFFSET RAMFail2$
          jmp  ErrOut

chipseterr:mov dx,OFFSET SetErr$
           jmp ErrOut

; Hier geht es nach einem erfolgreichen RAM-Test mit dem Einsetzen
; des eigenen "Hook" in die HIMEM.SYS-Sprungkette weiter
AreasTested:
           les di,[XMSOrgJmp]
ScanHooks: mov  al,Byte Ptr es:[di]
          cmp  al,0EBh      ; JMP SHORT?
          jz   HookFound    ; OK - momentanes Kettenende
          les  di,DWord Ptr es:[di+1] ; sonst nchstes Element
          cmp  al,0EAh      ; war das berhaupt ein JMP FAR?
          jz   ScanHooks
          mov  dx,OFFSET HookErr$  ; Hook-Kette beschdigt
          jmp  ErrOut
HookFound: cli               ; *keine* Strungen hier, bitte!
          dec  Byte Ptr es:[di] ; JMP SHORT -> JMP FAR
          mov  Word Ptr es:[di+1], OFFSET NewChain ; eigene Routine
          mov  Word Ptr es:[di+3], cs   ; einsetzen
          add  di,5         ; echte Originaladresse (hinter den NOPS)
          mov  Word Ptr [XMSOrgJmp],di
          mov  Word Ptr [XMSOrgJmp+2],es
          sti

showinst:
          mov  dx,OFFSET Installed$
          call PrintString
          mov  ax,0100h    ; Initialisierung fehlerfrei
InitEnd:  pop  ds
          pop  di
          pop  si
          pop  dx
          pop  cx
          ret
InitFunc  ENDP

Copyright$  db 'UMBADD c''t 11/95 - Siering/Schpers/Stiller$'
NoXMS$      db 'Kein XMS-Treiber vorhanden!$'
UMBPresent$ db 'UMB Server bereits installiert!$'
BadCmd$    db 'Probleme mit den Bereichsangaben in CONFIG.SYS!',13,10
           db 'Format: DEVICE=UMBADD.SYS /Iaaaa-bbbb /Icccc-dddd ...$'
RAMFail1$   db 13,10,'Kein RAM im Segment (hex) $'
RAMFail2$   db '- Installation abgebrochen -$'
HookErr$    db 'Hook-Chain von HIMEM.SYS beschdigt bzw. unbekannt !$'
Installed$  db 'Programm installiert.$'
SetErr$     db 'Problem mit PCI-Chipsatz-Programmierung!$'

; Aufruf mit ES:DI als Index in die Kommandozeile
; zurck mit DI+4, Wert bzw. 0 in DX und gelschtem/gesetzten Z-Flag
HexToVal: push cx
          mov  cx,0404h     ; Zhler, Shift-Zhler
          xor  dx,dx        ; Wert
DoDigit:  shl  dx,cl        ; eine Stelle nach links
          mov  al,es:[di]   ; ein Zeichen
          inc  di
          cmp  al,'9'
          jbe  IsDigit
          and  al,0DFh      ; Grobuchstaben
          cmp  al,'A'
          jb   NoChar       ; Fehler
          cmp  al,'F'
          ja   NoChar       ; dito
          sub  al,55        ; 'A'..'F' -> 10..16
          jmp  short SetDig ; Einsetzen
IsDigit:  cmp  al,'0'
          jb   NoChar       ; Fehler
          sub  al,'0'       ; '0'..'9' -> 0..9
SetDig:   or   dl,al        ; Einsetzen
          dec  ch
          jnz  DoDigit
          jmp  Short DigDone
NoChar:   xor  dx,dx        ; Fehleranzeige: dx = 0
DigDone:  pop  cx
          or   dx,dx
          ret

; Auswertung der Kommandozeile. Aufruf mit ES:DI = Kommandozeile,
; zurck mit gesetzter UMBList und gesetztem/gelschten Carry
SetList   PROC NEAR
          xor  bx,bx        ; Index in UMBList
DoElem:   mov  al,es:[di]
          inc  di
          cmp  al,13        ; CR?
          jz   ListSet      ; -> ja, Ende
          cmp  al,10        ; LF?
          jz   ListSet      ; -> dito
          cmp  al,'/'       ; Schrgstrich von "/I=..."?
          jnz  DoElem
          mov  ax,es:[di]
          and  al,0DFh      ; Umsetzung 'i' -> 'I'
          cmp  ax,'=I'      ; ist "I="? (verkehrtherum)
          jnz  listerr       ; -> nein, TestC
          add  di,2         ; Ok, berspringen
          call HexToVal     ; Hexzahl auswerten -> DX
          jz   ListErr      ; -> war nichts
          mov  al,es:[di]
          cmp  al,'-'       ; Trennstrich?
          inc  di
          mov  cx,dx        ; Startadresse festhalten
          call HexToVal     ; Endadresse ermitteln
          jz   ListErr      ; -> war nichts
          mov  Word Ptr[UMBList+bx],cx  ; Eintrag Startadresse
          mov  ax,dx
          sub  ax,cx        ; Gre in Paragraphs
          inc  ax           ; B000-B7FF sind $800 Paragraphs!
          mov  Word Ptr[UMBList+bx+2],ax
          add  bx,4
          cmp  bx,40        ; mehr als 10 Eintrge?
          jb   DoElem       ; -> nein, weiter

ListErr:  stc
          ret
ListSet:  sub  bx,1         ; setzt Carry, wenn BX = 0
          ret
SetList   ENDP

;************* Ab hier PCI-Chipsatz-Programmierung *******

PCI      Macro n
         MOV   AH,0B1h
         MOV   AL,n
         INT   1Ah
         endm

Liste     DW SIOlist;
BUSDEV    DW 0;

RWC_Lo  EQU  0F0Fh
RWC_Hi  EQU 0F0F0h

SIOlist:  ; Segmente und Registerwerte fr Saturn, Mercury, Neptun
 dw 0C000h, 12h, 5Ah,RWC_lo, 154h,0303h,  149h,0101h, 0
 dw 0C400h, 12h, 5Ah,RWC_hi, 154h,0C0Ch,  149h,0202h, 0
 dw 0C800h, 12h, 5Bh,RWC_lo, 154h,3030h,  149h,0404h, 0
 dw 0CC00h, 12h, 5Bh,RWC_hi, 154h,0C0C0h, 149h,0808h, 0
 dw 0D000h, 12h, 5Ch,RWC_lo, 155h,0303h,  149h,1010h, 0
 dw 0D400h, 12h, 5Ch,RWC_hi, 155h,0C0Ch,  149h,2020h, 0
 dw 0D800h, 12h, 5Dh,RWC_lo, 155h,3030h,  149h,4040h, 0
 dw 0DC00h, 12h, 5Dh,RWC_hi, 155h,0C0C0h, 149h,8080h, 0
 dw 0E000h, 16h, 5Eh,RWC_lo, 156h,0303h,  148h,0808h, 14Eh,0040h, 0
 dw 0E400h, 16h, 5Eh,RWC_hi, 156h,0C0Ch,  148h,0808h, 14Eh,0040h, 0
 dw 0E800h, 16h, 5Fh,RWC_lo, 156h,3030h,  148h,0808h, 14Eh,0040h, 0
 dw 0EC00h, 16h, 5Fh,RWC_hi, 156h,0C0C0h, 148h,0808h, 14Eh,0040h, 0
 Dw 00000h

PIIXlist:   ; Segmente und Registerwerte Fr Triton
 dw 0C000h, 0Ah, 5Ah,RWC_lo, 0   ; kein ISA-DMA mglich !!!
 dw 0C400h, 0Ah, 5Ah,RWC_hi, 0   ; kein ISA-DMA mglich !!!
 dw 0C800h, 9Ah, 5Bh,RWC_lo, 0   ; kein ISA-DMA mglich !!!
 dw 0CC00h, 0Ah, 5Bh,RWC_hi, 0   ; kein ISA-DMA mglich !!!
 dw 0D000h, 0Ah, 5Ch,RWC_lo, 0   ; kein ISA-DMA mglich !!!
 dw 0D400h, 0Ah, 5Ch,RWC_hi, 0   ; kein ISA-DMA mglich !!!
 dw 0D800h, 0Ah, 5Dh,RWC_lo, 0   ; kein ISA-DMA mglich !!!
 dw 0DC00h, 0Ah, 5Dh,RWC_hi, 0   ; kein ISA-DMA mglich !!!
 dw 0E000h, 12h, 5Eh,RWC_lo, 169h,0808h, 14Eh,0040h, 0
 dw 0E400h, 12h, 5Eh,RWC_hi, 169h,0808h, 14Eh,0040h, 0
 dw 0E800h, 12h, 5Fh,RWC_lo, 169h,0808h, 14Eh,0040h, 0
 dw 0EC00h, 12h, 5Fh,RWC_hi, 169h,0808h, 14Eh,0040h, 0
 Dw 00000h

setpci    Proc near              ; SI=>Liste, BX= BUSDEV
          MOV  SI,liste          ; Register-Liste
 @Sloop:  MOV  AX,Word Ptr [SI]
      	  OR   AX,AX
          STC
          JZ   @fertig            ; Exit mit Carry
          MOV  DX,ES
          CMP  DX,AX
          JZ   @found
          ADD  SI,Word PTR [SI+2]
          JMP  @Sloop
 @found:
          MOV DI,44h              ; Master Enable
          MOV CL,17h              ; PCIMaster: BIOS:Ro, 8000-A000:rw
          MOV BX,BUSDEV
          PCI 0Bh                 ; Schreiben
 @floop:  ADD  SI,4
	  MOV  AX, word ptr [SI]  ; DEV+Func+Register nach AX
          OR   AX,AX
          JZ   @fertig
          XOR  BX,BX               ;
	  XCHG BL,AH               ;
          MOV  DI,AX               ; Register nach DI
          CMP  BL,1                ; Kennung fr: Nimm [BUSDEV]
          JNZ  @set1               ;
          MOV  BX,BUSDEV           ; Bus+DEV+Func
@set1:    PCI  08h                 ; Inhalt nach CL
          JC   @fertig
          MOV  AL, Byte Ptr [SI+2] ; Andmaske = Not Lobyte
          NOT  AL
          AND  CL, AL
	  OR   CL, Byte Ptr [SI+3] ; Ormaske  = HiByte
          PCI  0Bh
          JNC  @floop
@fertig:  RET
setpci    endp

InitChipset PROC Near
@CheckSIO:MOV DX,8086h             ; INTEL
          MOV CX,0484h             ; SIO-Baustein
          MOV SI,0
          PCI 02
          JNC @InitExit
          MOV Liste, offset SIOList
@CheckPIIX:MOV DX,122Eh              ; Triton-PIIX
          PCI 02
          JC  @Initexit
          MOV Liste, offset PIIXlist
@Initexit:MOV BUSDEV,BX
          RET
InitChipset Endp

SetChipset proc near
          pusha
	  CALL SetPCI
          JC   @setexit
;Speicher initialisieren, falls Borad mit Paritt arbeitet
          mov di,0       ; Parittsprfung abschalten
          mov dx,61h
          in  al,dx      ; alte Einstellung merken
          push ax
	  or  al,0Ch
          out dx,al
          mov cx,1000h   ; Speicher mit 0 fllen
          mov eax,0
          rep stosd
          in  al,dx      ; Reset Pararity-Flipflop
          pop ax
          out dx,al      ; wieder alte Einstellung
	  popa
          clc
@Setexit: ret
Setchipset endp

  	  END

