







          NAME
               RanDOOM - A smart object placement randomization utility for
          DOOM. 

          SYNOPSIS
               RanDOOM [WAD_file_name][-C<seed>][-M<n>][-W<filename>][-D]
          [-G]

          DESCRIPTION
               RanDOOM is a utility which will randomize the placement of
          objects in the DOOM playfield. Additionally, RanDOOM has some
          smarts about the manner in which it will randomize things - it's
          designed to never leave you with a pillar blocking the exit, or a
          keycard on the opposite side of the door from where you start, or
          to erase all the DEATHMATCH warp-in spots with other objects
          (preventing DEATHMATCH network play), or to replace the endgame
          bosses with other objects (thus preventing the completion of an
          episode). In short, RanDOOM will always leave you with a playable
          level. RanDOOM is also user configurable - it allows you to
          specify the proportion of total objects a given object will
          comprise via a customizable object weighting scheme. This allows
          you to tailor RanDOOM's randomizing to your personal taste
          (and/or masochism ;-).


          OPTIONS
               WAD_file_name - Use this path to the WAD file. If no
          filename is specified, doom.wad in the current directory is used.

               -D - Restores the WAD file to its default state. When the -D
          switch is specified, all other switches are ignored. NOTE: The
          restoration function can only restore changes made by RanDOOM. If
          you have made changes with another randomizing or map editing
          utility, RanDOOM will probably be unable to undo those changes.
          Mix and match WAD utilities at your own risk!

               -C<seed> - Use a single ASCII character as the seed value
          for the pseudorandom number generator. The character is
          case-sensitive, so 'K' and 'k' yield different seed values.
          Alternatively, -C accepts a positive integer number [0..65535] as
          the seed value. If no -C parameter is specified, a seed value is
          taken based on the current system time.

               -G - Produce a graphic display of the item randomization
          process on the screen (VGA required). This switch was added to
          aid in debugging the first fit selection algorithm. It won't mean
          much to you, but you may find it interesting to watch. The color
          coding is as follows:

               * Walls and other area boundaries are drawn in blue,
               * Switches, doors, and other special wall segments are

                                          1














                 yellow,
               * Attempted object placements appear as red circles, with
                 the circle's radius proportional to the size of the object
               * As each wall segment is checked for collisions it is
                 highlighted in white
               * Cyan lines are drawn between the object's center and the
                 closest point on certain nearby line segments
               * Successful monster placements are marked by magenta
                 circles, again proportional to monster size.

               -M<n> - Use randomization mode n, where n is a single digit
          [0-9]. Currently only three randomization modes (0, 1 and 2) are
          supported. If no -M parameter is specified, mode 0 is used by
          default. 

               All three randomization modes attempt to avoid potential
          problems which would arise if a completely random replacement of
          objects were made. Such problems include immovable objects, such
          as a pillar or tree root, blocking a switch or doorway; monsters
          becoming "stuck in the wall" (or tangled up in each other!) and
          unable to move or fight; the replacement of player warp-in spots
          with other objects, preventing one or both forms of network play;
          the movement of keycards or skulls to new locations which then
          become inaccessible; etc. To achieve this, RanDOOM maintains lots
          of data about the objects and the DOOM level maps, such as the
          locations of objects, their relative sizes in three dimensions,
          their types, whether the player can move them, kill them, or pick
          them up, the locations of walls, the amount of "headroom" in a
          given area, and so forth. From this information, RanDOOM is able,
          in most cases, to calculate whether or not a given object will
          "fit" into a given location in the map without conflicts. 

               Randomization mode 0 takes the objects currently placed on
          each level and rearranges them. No objects are added, subtracted,
          or replaced - if a given level contains 2 Barons of Hell, 12
          Imps, 32 blue health vials, and a chainsaw, then the modified
          level will also contain 2 Barons of Hell, 12 Imps, 32 blue health
          vials, and one chainsaw, rearranged in random order. 

               Randomization mode 1 replaces "nonessential" objects with
          other randomly selected objects from the entire range of
          available objects. This randomization mode may place objects into
          a level which would not normally appear there, e.g. M1 may place
          Cacodemons in the Hangar level. Those items which are needed to
          complete the level, such as keycards or level bosses, remain in
          their original locations.

               Randomization mode 2 does the same things as mode 1 with the
          addition of weight factors for replaceable objects. These weights
          are user adjustable (via the weight file specified using the -W
          switch) to allow a relative increase or decrease in the number of
          a given item inserted in the game. Thus, items with higher

                                          2














          weights have a higher probability of being selected. NOTE: If the
          -M2 switch is specified, the -W switch must also be specified.

               NOTE: With randomization modes 1 and 2 ALL objects will
          appear at ALL FOUR skill levels - e.g. there will be no variation
          between "Hey, Not Too Rough" and "Ultra Violence." This may be
          addressed in future versions of RanDOOM. 

               -W<filename> - Use item weight factors from file <filename>
          in place of the default weights in randomization mode 2. The
          weight file is a flat ASCII text file consisting of a series of
          <itemname> <weight> pairs, one pair per line. <itemname> must be
          one of the predefined names listed in the sample weight file
          (randoom.w), while <weight> must be a floating point value
          greater than or equal to 0.0. In general, the larger the weight
          value, the more occurrences of that object RanDOOM will put into
          the game. There are some exceptions, most notably with the larger
          objects. Because RanDOOM will only place an item if it will
          "fit," some hard-to-place items will have a lower effective
          weight than that specified in the weight file. Take the Spider
          Demon, for example. This sucker is so large it gets stuck just
          about anywhere. Out of the hundreds of available item spots,
          there may be only one or two locations where the Spider would be
          able to function. Thus, even though it's number may come up via
          the weighted selection scheme, its placement may still be
          prevented. If an object is chosen which is too large for the
          available space, another item is chosen until one is found which
          can be safely placed into the current location. Future versions
          of RanDOOM may incorporate a "best fit" selection algorithm to
          minimize the effects of individual object size on the overall
          object distribution.

               Some comments about speed: Those of you who have used
          earlier versions of RanDOOM will notice that 1.4 takes longer to
          process the WAD file than did its predecessors. This is due to
          the fact that 1.4 does a lot more work than earlier versions,
          most of it 2-D geometric calculations (such as the distances from
          objects to walls for collision detection). After trying several
          different approaches to the "monster stuck in the wall" problem,
          the method currently employed was the best tradeoff in terms of
          speed and accuracy I've found so far. Although RanDOOM 1.4 makes
          extensive use of integer and fixed-point math and '386-specific
          instructions to speed the many calculations, it still takes time
          to run (several minutes on my 20MHz 386SX test-dog system). Of
          course, any system capable of running DOOM adequately will have
          absolutely no problems with RanDOOM - it breezes right along on
          my 486/33. 

          EXAMPLES
               RanDOOM
                    Display a brief usage synopsis.


                                          3














               RanDOOM -Ck -M1 
                    Rearrange levels using randomization mode 1 and random
                    seed character 'k'.

               RanDOOM -M0
                    Rearrange levels using randomization mode 0 and random
                    seed based on the system time.

               RanDOOM -D
                    Restore all objects in the WAD file to their default
                    positions. 

               RanDOOM -M2 -Wc:\doom\randoom.w -C23456
                    Rearrange levels using mode 2 with weights given in the
                    file "c:\doom\randoom.w" and using the integer 23456 as
                    the random number seed value.

               RanDOOM c:\doom\doom.wad -CT -G
                    Rearrange levels in WAD file c:\doom\doom.wad using
                    randomization mode 0, seed character 'T', and display
                    the object placements graphically.

          NOTICES
               This software is copyright 1994 ASRE. You are free to use
          and distribute this software provided that no modifications or
          derivative works are produced from it and that no fees are
          charged for its distribution or use. Although RanDOOM has been
          thoroughly tested, it is not guaranteed to be completely free of
          bugs. Do I even need to mention that you should back up your WAD
          file before running this program?

          BUGS
               I welcome your comments, suggestions, and bug reports. Input
          from users like you has made RanDOOM into the fun and useful
          utility you see before you today, so don't please don't hesitate
          to let your virtual voice be heard. Please email any bug reports
          and/or comments to tmkk@uiuc.edu. For bug reports, please include
          the following information in your message: 

                 The version of RanDOOM you're running,
                 The version of DOOM you're running,
                 The command line switches you used,
                 The random number seed value you used,
                 And a description of the problem.

               The object placement algorithm may still occasionally
          misplace objects, allowing them to become stuck either in a wall
          or in each other. Also, as noted earlier, RanDOOM is currently
          using a "first fit" algorithm to place objects; future versions
          may employ a "best fit" algorithm to insure optimal placements.



                                          4







