/***************************************************************************
 *                                                                         *
 *   WEBDIR.C                                                              *
 *                                                                         *
 *   Copyright (c) 1996 Galacticomm, Inc.  Freeware source code.           *
 *                                                                         *
 *   Please feel free to use this source code as a starting point to       *
 *   creating a World-Wide Web add-on product, for use with a Worldgroup   *
 *   server.                                                               *
 *                                                                         *
 *   Web page default directory feature.                                   *
 *                                                                         *
 *                                              - R. Stein  4/4/96         *
 *                                                                         *
 ***************************************************************************/

#define FILREV "$Revision$"

typedef unsigned char uchar;

#include "gcomm.h"
#include "majorbbs.h"
#include "tcpip.h"
#include "webd.h"

STATIC short (*oldwebget)(         /* Web GET request vector               */
     char *uri);                   /*   URI following method in req line   */

static short wdrwebget(char *uri);
static char *sdftfil;

void EXPORT
init__webdir(void)
{
     init__webd();
     if (dftfil[0] == '/' || dftfil[0] == '\\') {
          sdftfil=dftfil;
     }
     else {
          sdftfil=alcmem(1+strlen(dftfil)+1);
          sprintf(sdftfil,"/%s",dftfil);
     }
     oldwebget=hdlwebget;
     hdlwebget=wdrwebget;
}

STATIC short
wdrwebget(                         /* Web dir-default (*hdlwebreq)() vector*/
char *uri)                         /*   URI from request line              */
{                                  /*   (corrupts vdatmp)                  */
     int n;
     short rc;

     if ((rc=(*oldwebget)(uri)) == 0) {
          stlcpy(vdatmp,uri,vdasiz);
          if ((n=strlen(vdatmp)) > 0 && n+1+strlen(sdftfil)+1 <= vdasiz) {
               if (vdatmp[n-1] == '/' || vdatmp[n-1] == '\\') {
                    n--;
               }
               strcpy(vdatmp+n,sdftfil);
               return((*oldwebget)(vdatmp));
          }
     }
     return(rc);
}

