// StatDlg.cpp : implementation file
// Copyright (c) 1996, Galacticomm, Inc.
//
//                       - Joe Delekto  11/12/96

#include "stdafx.h"
#include "galstat.h"
#include "StatDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define ID_TIMER_MYTIME  1    // Internal timer ID

//   The definitions below are taken from MAJORBBS.H

#define MTXSIZ        400     // Maximum message text string size
#define NCOMTY          8     // Number of computer type codes
#define NAGEBK          5     // Number of tallied age brackets

// Note:  The structures below are declared with external "C" linkage
//        to ensure that the function names are not decorated.  Entire
//        blocks of code (symbols, structures and functions) can be
//        declared within an extern "C" {} block.
//
//   The structures below are taken directly from MAJORBBS.H.

extern "C" {
     struct sysvbl {
          CHAR key[4];
          CHAR dspopt[6];
          LONG calls[8];
          CHAR lonmsg[MTXSIZ];
          LONG dwnlds;
          LONG uplds;
          LONG msgtot;
          USHORT emlopn;
          USHORT sigopn;
          SHORT hisign;
          CHAR monmal;
          CHAR savmin;
     };

     struct sysvb2 {
          CHAR ky2[4];
          USHORT matrix[NCOMTY][NAGEBK];
          SHORT nliniu[48];
          SHORT lstzer;
          LONG x25kps;
          USHORT x25ps;
          LONG x25mbs;
          LONG x25bs;
          ULONG numact;
          ULONG numfem;
          ULONG numcor;
          ULONG numans;
          ULONG paidpst;
          ULONG freepst;
          LONG totcalls;
          SHORT lastmcu;
     };

     // Note:  The structures are defined, but below is the actual
     //        declaration for the imported system variable structures.
     //        These symbols will be resolved when linked with the
     //        WGSERVER.LIB that was generated from your Worldgroup Server
     //        Executable.  (WGSERVER.EXE)

     DllImport struct sysvb2 sv2;
     DllImport struct sysvbl sv;
}

/////////////////////////////////////////////////////////////////////////////
// CStatDlg dialog


CStatDlg::CStatDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CStatDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CStatDlg)
	//}}AFX_DATA_INIT
}


void CStatDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStatDlg)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CStatDlg, CDialog)
	//{{AFX_MSG_MAP(CStatDlg)
	ON_WM_TIMER()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStatDlg message handlers

VOID CStatDlg::UpdateVars(VOID)
{
     CString tstr;

     // Note:  The variables accessed below are being done
     //        in a non-thread safe manner.  However, since
     //        they are only being "read" from for display
     //        purposes, they will cause no ill-effects on 
     //        the server.

     // The code below formats (using printf() style formatting)
     // each variable into the temporary CString.  Then
     // the static control's text is updated by a call to
     // SetWindowText().

     tstr.Format("%d",sv.dwnlds);
     GetDlgItem(IDC_DNLS)->SetWindowText((LPCTSTR)tstr);
     tstr.Format("%d",sv.uplds);
     GetDlgItem(IDC_UPLS)->SetWindowText((LPCTSTR)tstr);
     tstr.Format("%d",sv.msgtot);
     GetDlgItem(IDC_MSGS)->SetWindowText((LPCTSTR)tstr);
     tstr.Format("%u",sv.emlopn);
     GetDlgItem(IDC_OMSGS)->SetWindowText((LPCTSTR)tstr);
     tstr.Format("%u",sv.sigopn);
     GetDlgItem(IDC_OSIGS)->SetWindowText((LPCTSTR)tstr);
     tstr.Format("%d",sv.hisign);
     GetDlgItem(IDC_FCNT)->SetWindowText((LPCTSTR)tstr);
     tstr.Format("%u",sv2.numact);
     GetDlgItem(IDC_ACTS)->SetWindowText((LPCTSTR)tstr);
     UpdateWindow();
}

BOOL CStatDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	UpdateVars();
	SetTimer(ID_TIMER_MYTIME,3000,NULL);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CStatDlg::OnTimer(UINT nIDEvent) 
{
	UpdateVars();

     // Note:  I chose not to call the base calss OnTimer() function.

     // CDialog::OnTimer(nIDEvent);
}

void CStatDlg::OnClose() 
{
	KillTimer(ID_TIMER_MYTIME);   // Kill the timer when the dialog is closed
	
	CDialog::OnClose();
}

BOOL CStatDlg::PreTranslateMessage(MSG* pMsg) 
{
     BOOL result=FALSE;

     // Note:  The code here is used to keep the "Escape" key from
     //        prematurely closing the dialog.

     if ((pMsg->message == WM_KEYDOWN)
          || (pMsg->message == WM_KEYDOWN)
          || (pMsg->message == WM_KEYDOWN)) {
               if (pMsg->wParam == VK_ESCAPE) {
                    result=TRUE;
               }
     }
     if (!result) {
          result=CDialog::PreTranslateMessage(pMsg);
     }
     return(result);
}