/***************************************************************************
 *                                                                         *
 *   GALDNX2.C                                                             *
 *                                                                         *
 *   Copyright (C) 1994 GALACTICOMM, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   Downloading example.                                                  *
 *                                                                         *
 *                                              - R. Stein  12/6/93        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "filexfer.h"
#include "galdnx2.h"

STATIC int dnlinp(void);
STATIC int fllist(void);
STATIC int tshdnl(int tshcod);
STATIC void dnlfin(void);

int dnlstt;                        /* Downloading module state number      */
static FILE *dnlmb;                /* file pointer for GALDNX2.MCV         */
char *dnldir;                      /* DNLDIR download directory            */

struct module dnlmodule={          /* module interface block               */
     "",                           /*    name used to refer to this module */
     NULL,                         /*    user logon supplemental routine   */
     dnlinp,                       /*    input routine if selected         */
     dfsthn,                       /*    status-input routine if selected  */
     NULL,                         /*    "injoth" routine for this module  */
     NULL,                         /*    user logoff supplemental routine  */
     NULL,                         /*    hangup (lost carrier) routine     */
     NULL,                         /*    midnight cleanup routine          */
     NULL,                         /*    delete-account routine            */
     dnlfin                        /*    finish-up (sys shutdown) routine  */
};

void EXPORT
init__downloader(void)                  /* Downloader initialization       */
{
     stzcpy(dnlmodule.descrp,gmdnam("GALDNX2.MDF"),MNMSIZ);
     dnlstt=register_module(&dnlmodule);
     dnlmb=opnmsg("GALDNX2.MCV");
     dnldir=stgopt(DNLDIR);
}

STATIC int
dnlinp(void)                            /* Downloader input handler        */
{
     int rc=1;

     setmbk(dnlmb);
     if (margc == 1 && sameas(margv[0],"X")) {
          return(0);
     }
     do {
          bgncnc();
          switch (usrptr->substt) {
          case 0:
               cncchr();
               if (!fllist()) {
                    cncall();
                    rc=0;
               }
               prfmsg(usrptr->substt=FLNAME);
               break;
          case FLNAME:
               cncall();
               parsin();
               if (margc == 0 || sameas(margv[0],"?")) {
                    fllist();
                    prfmsg(FLNAME);
               }
               else if (rsvnam(margv[0])
                     || strchr(margv[0],':') != NULL
                     || strchr(margv[0],'\\') != NULL
                     || strstr(margv[0],"..") != NULL) {
                    prfmsg(FLRSV);
                    prfmsg(FLNAME);
               }
               else if (ftgnew() == 0) {
                    ftgsbm("");         /* use ftgsbm() to say out-of-tags */
                    rc=0;
               }
               else {
                    stzcpy(ftgptr->tagspc,margv[0],TSLENG);
                    ftgptr->tshndl=tshdnl;
                    ftgptr->flags=FTGABL;
                    if (strchr(margv[0],'?') != NULL
                     || strchr(margv[0],'*') != NULL) {
                         ftgptr->flags|=FTGWLD;
                    }
                    rc=ftgsbm(margc > 1 ? margv[1] : "?");
               }
          }
     } while (!endcnc());
     outprf(usrnum);
     return(rc);
}

STATIC int
fllist(void)                            /* Display listing of files        */
{
     struct fndblk fb;

     if (!fnd1st(&fb,spr("%s*.*",dnldir),0)) {
          prfmsg(FLNONE);
          return(0);
     }
     prfmsg(FLHEAD);
     do {
          prfmsg(FLLINE,fb.name,l2as(fb.size),ncdate(fb.date),nctime(fb.time));
     } while (fndnxt(&fb));
     return(1);
}

int
tshdnl(                                 /* Handle the application-specific */
int tshcod)                             /* aspects of your downloads       */
{                                       /* (tshcod=code for each aspect)   */
     int rc=0;
     FILE *fp;

     setmbk(dnlmb);
     switch(tshcod) {
     case TSHDSC:                       /* Describe the file(s) in English */
          sprintf(tshmsg,"file %s",ftgptr->tagspc);
          break;
     case TSHVIS:                       /* Visible to this user?           */
          if (ftgptr->flags&FTGWLD) {
               rc=fnd1st(&ftuptr->fb,ftgptr->tagspc,0);
               break;
          }
          if ((fp=fopen(spr("%s%s",dnldir,ftgptr->tagspc),FOPRB)) != NULL) {
               fread(tshmsg,1,TSHLEN,fp);
               rc=1;
          }
          break;
     case TSHSCN:                       /* Break down multiple filespec    */
          if (fnd1st(&ftuptr->fb,spr("%s%s",dnldir,ftgptr->tagspc),0)) {
               strcpy(tshmsg,ftuptr->fb.name);
               rc=1;
          }
          break;
     case TSHNXT:                       /* Next file in multi-file spec    */
          if (fndnxt(&ftuptr->fb)) {
               strcpy(tshmsg,ftuptr->fb.name);
               rc=1;
          }
          break;
     case TSHBEG:                       /* Begin downloading this file     */
          sprintf(tshmsg,"%s%s",dnldir,ftgptr->tagspc);
          strcpy(ftfscb->fname,ftgptr->tagspc);
          rc=1;
          break;
     case TSHFIN:                       /* End of downloading session      */
          usrptr->state=dnlstt;
     }
     return(rc);
}

STATIC void
dnlfin(void)                            /* Finalize downloading example    */
{
     clsmsg(dnlmb);
}
