/***************************************************************************
 *                                                                         *
 *   GALEAGT.C                                                             *
 *                                                                         *
 *   Copyright (c) 1995 Galacticomm, Inc.         All rights reserved.     *
 *                                                                         *
 *   This is the BBSCON '95 example agent.                                 *
 *                                                                         *
 *                                                 - C. Robert 8/19/95     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"

#define FILREV "$Revision$"

STATIC void exaread(int direction,struct saunam *dpknam);
STATIC void exawrite(struct saunam *dpknam,unsigned length,void *value);
STATIC void exaxdone(void);
STATIC void exaabort(void);

struct agent exaagt={              /* agent information structure          */
     "GALEAGT",                    /*   App-ID                             */
     exaread,                      /*   dynapak read handler               */
     exawrite,                     /*   dynapak write handler              */
     exaxdone,                     /*   file transfer done handler         */
     exaabort                      /*   request abort handler              */
};

struct myprmem {                   /* my per-request memory layout         */
     int count;                    /*   counter                            */
};

#define prmemp ((struct myprmem *)mrqptr)

STATIC void cycrou(void);

void EXPORT
init__galeagt(void)                /* initialize the example agent         */
{
     register_agent(&exaagt);
}

STATIC void
exaread(                           /* dynapak read handler                 */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     char *digptr;
     int dig;
     struct saunam newnam;

     shocst("got a read","dir == %d, suffix == %s",direction,dpknam->suffix);
     switch (direction) {
     case 0:
          if (dpknam->flags&FLGFIL) {
               rsp2read(NULL,STGLEN,"BBSUSER.DOC");
          }
          else
          {
               prmemp->count=0;
               cycleme(cycrou);
          }
          return;
     case 1:
          movmem(dpknam,&newnam,sizeof(struct saunam));
          digptr=skpwht(skpwrd(newnam.suffix));
          dig=atoi(digptr);
          if (strlen(digptr) == 1 && dig >= 0 && dig < 9) {
               itoa(dig+1,digptr,10);
               rsp2read(&newnam,STGLEN,spr("(value for %s)",cnvs2d(&newnam)));
               return;
          }
          break;
     }
     rejectreq();
}

STATIC void
exawrite(                          /* dynapak write handler                */
struct saunam *dpknam,             /*   dynapak name to write              */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value to write             */
{
     (void)value;
     shocst("got a write","suffix == %s, length == %d",dpknam->suffix,length);
     if (samend(dpknam->suffix,"1")) {
          rsp2write(TRUE,STGLEN,spr("(response for %s)",cnvs2d(dpknam)));
          return;
     }
     rejectreq();
}

STATIC void
exaxdone(void)                     /* file transfer done handler           */
{
     shocst("got an xferdone","");
}

STATIC void
exaabort(void)                     /* request abort handler                */
{
     shocst("got an abort","");
}

STATIC void
cycrou(void)                       /* example cycle routine                */
{
     if (prmemp->count++ > 3) {
          rsp2read(NULL,STGLEN,spr("(cycled value)"));
     }
     else {
          shocst("cycling","count == %d",prmemp->count);
     }
}
