// putusr -- restores user to module they were in before call to getusr();
//           putusr has no effect unless you have called getusr() before;
STATIC
void putusr(void)
  {
  if(OCNFLAGS&SNATCHD) {
    //unset SNATCHD flag
    OCNFLAGS&=~SNATCHD;
    //restore state and substate information
    usrptr->state=ocnuarr[usrnum].savestate;
    usrptr->substt=ocnuarr[usrnum].savesubstt;

    //make sure flags are off now if they were off before
    if (!(OCNFLAGS&PREVBUS))//if it wasn't on before
       usrptr->flags&=~NOINJO;        //make it not on now

    if (!(OCNFLAGS&PREVGLO))//if it wasn't on before
       usrptr->flags&=~NOGLOB;        //make it not on now

    //reset user 'in memory' flags
    OCNFLAGS&=~PREVBUS; //reset previous busy flag..
    OCNFLAGS&=~PREVGLO; //reset prevglo flag

    //sets flag for a reprompt by module user was snached away from
    usrptr->flags|=INJOIP;
    btuoes(usrnum,1);
    }
  }
