/*
***************************************************************************
*  OCNGLO.C
*                             THE OCEAN GLOBALS
*
***************************************************************************
*/
#include "gcomm.h"
#include "majorbbs.h"
#include "ocnglo.h"
/*
****************************************************************************
*                          ALL FUNCTION PROTOTYPES
****************************************************************************
*/
 void EXPORT init__ocnglo(void);
  int        globalrou(void);
  int        xxxlonrou(void);
  int        xxxlofrou(void);
  int        xxxsttrou(void);
  void       xxxfinrou(void);
  void       xxxhuprou(void);
  void       xxxdlarou(char *);
  void       dedincred(void);

  //text variables
  char *  tv_ocnchatn(void);   char *  tv_ocngmins(void);
  char *  tv_ocnghrs(void);    char *  tv_ocngdat(void);
  char *  tv_ocngfla(void);    char *  tv_ocnguolc(void);
  char *  tv_ocngtt(void);     char *  tv_ocngsex(void);
  char *  tv_ocngage(void);    char *  tv_ocngbau(void);
  char *  tv_ocngmin(void);    char *  tv_ocngcla(void);
  char *  tv_ocngch(void);     char *  tv_ocngloc(void);
  char *  tv_ocnguid(void);    char *  tv_ocngcc(void);
  char *  tv_ocnccc(void);     char *  tv_ocnglogn(void);
  char *  tv_ocnglogf(void);   char *  tv_ocngcred(void);
  char *  tv_ocntuser(void);   char *  tv_ocngsdat(void);
  char *  tv_ocnglast(void);   char *  tv_ocngpw(void);
  char *  tv_ocnrname(void);   char *  tv_ocngphon(void);
  char *  tv_ocngsyst(void);   char *  tv_ocngedit(void);
  char *  tv_ocngansi(void);   char *  tv_ocngbday(void);
  char *  tv_ocnadd1(void);    char *  tv_ocnadd2(void);
  char *  tv_ocnadd3(void);    char *  tv_ocnadd4(void);
  char *  tv_ocnswid(void);    char *  tv_ocnslen(void);
  char *  tv_ocngdcl(void);    char *  tv_ocncpaid(void);
  char *  tv_ocncfree(void);   char *  tv_ocnfinvs(void);
  char *  tv_ocnfprot(void);   char *  tv_ocnfsusp(void);
  char *  tv_ocnfdel(void);    char *  tv_ocnfmast(void);


//ROUTINES ONLY USED IN THIS FUNCTION
STATIC  int     typedx(void);      //User typed 'x' handler
STATIC  void    ocnguol(char);     //Ocean Globals user online list
STATIC  int     getusr(int);       //snatches user into "The Ocean Globals"
STATIC  void    putusr(void);      //puts user back to where they came from
STATIC  int     reprompt(void);    //reprompting or default answer handler
STATIC  void    updusr(char);      //updates ocndisk info 2 disk
STATIC  void    inputmask(char);   //maskes off input
STATIC  char    hdluido(char *);   //matches string against users online
STATIC  char    hdluidq(char *,int,char);//if not right put user in state (int)
STATIC  void    setothusn(char *); //sets ocnothusn = othusn
STATIC  void    prfclr(char,char,char); //prf's a color change to prfbuf
STATIC  void    strclr(char *,char);//takes strings & calls prfclr
STATIC  void    iniopt(void);      //reads in all options from msg file
STATIC  int     regrou(void);      //checks registration code
STATIC  void    setuserdefault(void);  //sets user default values
STATIC  char    sendtoall(char,int);   //sends a message to specific user(s)
STATIC  char    checkchatter(int,int); //checks chatter channels
STATIC  char    getaccount(char *,char);  //get account information from disk
STATIC  void    updaccount(void); //update account from accountdisk
STATIC  char *  systype(char,int);//returns system type in a string
STATIC  char *  birthday(char *); //returns birthday as "June 12, 1972"
STATIC  void    dspkys(char *,int);//display users keys
/*
****************************************************************************
*                   MODULE ENTRY POINT DEFINITION STRUCTURE
****************************************************************************
*/
struct module mibocnglo = {     /* module interface block               */
    "",                         /* name used to refer to this module    */
    xxxlonrou,                  /* user logon supplemental routine      */
    xxxsttrou,                  /* input routine if selected            */
    dfsthn,                     /* status-input routine if selected     */
    NULL,                       /* "injoth" routine for this module     */
    xxxlofrou,                  /* user logoff supplemental routine     */
    xxxhuprou,                  /* hangup (lost carrier) routine        */
    NULL,                       /* midnight cleanup routine             */
    xxxdlarou,                  /* delete-account routine               */
    xxxfinrou                   /* finish-up (sys shutdown) routine     */
};
/*
****************************************************************************
*                   DECLARATION OF ALL NEEDED VARIABLES
****************************************************************************
*/

//
//  GLOBAL INFOMATION SAME TO ALL USERS STRUCTURES
//

struct demonames {
   char names[7][30];
   unsigned lastpublic;  //what is the last public chatter channel ?
   unsigned lastprivate; //what is the last private chatter channel ?
   } demonames;

struct demodisk {
   char key[15];
   char modnam[20];
   struct demonames data;
   } demodisk;

//
//  USER STRUCTURES
//
struct ocnuser {
   int flags;              //flags for this user (see above)
   char ocngcc;            //what this users global command char is
   signed char tempchar;   //for saving temp char info about this user
   int tempint;            //for saving temp int info about this user
   int savesubstt;         //used to 'save' the users state
   int savestate;          //used to 'save' the users substate
   long templong;          //used to hold various longs for this user
   char string[30];        //various uses, keeps strings for specific users
   int channel[26];        //chatter channels (A-Z)
   char chatchar;          //this users chatter channel character
   char chatname[21];
   } *ocnuarr; //117 bytes

struct ocndisk {
   char userid[UIDSIZ];
   char modnam[MNMSIZ];
   char logonmsg[80];      //users logon message
   char logoffmsg[80];     //users logoff message
   char macros[10][80];    //users macros
   struct ocnuser userd;
   } ocndisk;


struct usracc accountdisk; //one in memory for updating offline accounts


//ALL DEFINES THAT ARE USED WITH OCNUSER.FLAGS
#define SHOWUOL 1       //show users online at logon?
#define PREVBUS 2       //did this user have his busy flag already set
#define PREVGLO 4       //did this user have the "no globals" already set
#define SNATCHD 8       //User was snatched into this module by getusr()
#define RECVINV 16      //Is this user invisible in chatter channels?
#define NOTOTH  32      //Notify others of logons and logoffs?
#define NOTYOU  64      //Notify you of logons and logoffs?
#define ECHOMSG 128     //Does this user want his messages echo'ed to him?
			//256 & 512 used for the uol list prefrence
#define DEDICRD 1024    //Deduct credits for being invisible?
#define SYSMCHA 2048    //Sysop monitor all chatters flag
#define CHATON  4096    //Does this user have his chatters on ?
//free flags left
//#define 8192
//#define 16384
//#define 32768

//this user macros
#define TEMPINT ocnuarr[usrnum].tempint
#define TEMPLONG ocnuarr[usrnum].templong
#define TEMPCHAR ocnuarr[usrnum].tempchar
#define TEMPSTRING ocnuarr[usrnum].string
#define OCNFLAGS ocnuarr[usrnum].flags
#define CHANNEL ocnuarr[usrnum].channel
#define CHATCHAR ocnuarr[usrnum].chatchar
#define GLOBCHAR ocnuarr[usrnum].ocngcc
#define UOLLIST (ocnuarr[usrnum].flags&768)>>8

static
char *ansiset[] =
{
"Auto\0","Auto\0","Off\0","On\0"
};
static
char *months[] =
{
"Zero\0","January\0","February\0","March\0","April\0","May\0","June\0",
"July\0","August\0","September\0","October\0","November\0","December\0"
};

static
char    showpass;        /* show passwords in (Detail on user(det)) list? */
static
char    tv_what=1;        /* Keeps track of what should be sent as a text var */
static
char    handeluidq;       /* What is hdluidq() currently doing? */
static
FILE    *ocnglomb;        /* Message file  */
static
BTVFILE *accdiskbtv;      /* Btrieve account file */
static
BTVFILE *usrkeybb;        /* Btrieve file pointer */
static
BTVFILE *ocnglogen;       /* clone of BBSGEN */
static
char    *usrkey;          /* users keys in memory */
static
char    demo;             /* 1=demo  2=Registerd */
static
char    inviscred;        /* number of credits to charge invisible users */
static
int     ocnglostt;        /* module state number   */
static
int     ocnothusn=0;      /* our own Special Other user number */
static
char    ctrlchr='=';      /* Default Globals control char */
static
char    optuolch='#';     /* Optional users online char */
static
char    chatchar='`';     /* Default chatter character */
static
char    *masked;          /* What inputmask sets the string to */
static
char    ismasked=0;       /* is there already a masked ? */
static
char    *nocolor;         /* What strclr sets argument 1 to */
static
char    isnocolor=0;      /* is there already a nocolor ? */
static
char    *colored;         /* What strclr sets argument 2 to */
static
char    iscolor=0;        /* is there already a color ? */
static
int     coloredpos=0;     /* global between strclr & prfclr for *colored */
static
char    *optk1;           /* Key required for: ? (help screen)*/
static
char    *optk2;           /* Key required for: si (system information) */
static
char    *optk3;           /* Key required for: (users on line list) */
static
char    *optk4;           /* Key required for: (busy toggle) */
static
char    *optk5;           /* Key required for: =sw */
static
char    *optk6;           /* Key required for: =n */
static
char    *optk7;           /* Key required for: (info on user) */
static
char    *optk8;           /* Key required for: (set logoff message) */
static
char    *optk9;           /* Key required for: (notify you of logons & offs)*/
static
char    *optk10;          /* Key required for: =re */
static
char    *optk11;          /* Key required for: =rd */
static
char    *optk12;          /* Key required for: =ps */
static
char    *optk13;          /* Key required for: ! (color on input) */
static
char    *optk14;          /* Key required for: - (quick logoff)*/
static
char    *optk15;          /* Key required for: # */
static
char    *optk16;          /* Key required for: =td */
static
char    *optk17;          /* Key required for: =ul */
static
char    *optk18;          /* Key required for: pw (change password) */
static
char    *optk19;          /* Key required for: =ur */
static
char    *optk20;          /* Key required for: (set logon message) */
static
char    *optk21;          /* Key required for: =rc */
static
char    *optk22;          /* Key required for: (set chat-name) */
static
char    *optk23;          /* Key required for: =ed */
static
char    *optk24;          /* Key required for: =/ */
static
char    *optk25;          /* Key required for: =cs */
static
char    *optk26;          /* Key required for: =ch */
static
char    *optk27;          /* Key required for: =tr */
static
char    *optk28;          /* Key required for: =a */
static
char    *optk29;          /* Key required for: =sl */
static
char    *optk30;          /* Key required for: (account information) */
static
char    *optk32;          /* Key required for: (macros) */
static
char    *optk33;          /* Key required for:(notify others logons & offs)*/
static
char    *optk34;          /* Key required for: (send graphic to user) */
static
char    *optk35;          /* Key required for: =nt */
static
char    *optk36;          /* Key required for: =rt */
static
char    *optk37;          /* Key required for: =// */
static
char    *optk38;          /* Key required for: chatter channel help */
static
char    *optk39;          /* Key required for: k (kick user offline)*/
static
char    *optk40;          /* Key required for: in (invisibility) */
static
char    *optk41;          /* Key required for: pd */
static
char    *optk42;          /* Key required for: su (suspend user) */
static
char    *optk43;          /* Key required for: (post credits) */
static
char    *optk44;          /* Key required for: =da */
static
char    *optk45;          /* Key required for: us (switch user class) */
static
char    *optk46;          /* Key required for: =dc */
static
char    *optk47;          /* Key required for: (issue key to user) */
static
char    *optk49;          /* Key required for: em (echo messages) */
static
char    *optk50;          /* Key required for: ` */
static
char    *optk51;          /* Key required for: `ch x */
static
char    *optk52;          /* Key required for: (see who's on chatter)*/
static
char    *optk53;          /* Key required for: change chatter x to # */
static
char    *optk54;          /* Key required for: chatter channel scan */
static
char    *optk55;          /* Key required for: (set last public chat) spu */
static
char    *optk56;          /* Key required for: (set last private chat) spr */
static
char    *optk57;          /* Key required for: s! (un-suspend user) */
static
char    *optk58;          /* Key required for: ri (receive invisible) */
static
char    *optk59;          /* Key required for: det (detail on user) */
static
char    *optk60;          /* Key required for: rk (remove key from user) */
static
char    *optk61;          /* Key required for: `mon (monitor all chatters) */
static
char    *optk62;          /* Key required for: `off (turn all chatters on)*/
static
char    *optk63;          /* Key required for: `on (turn all chatters on) */
static
char    *gopkey;          /* Key required for: ? op (op's help screen) */
static
char    *suolky;          /* Key required for sysop UOL list */
static
char    *lstkey;          /* (demo version) Key required for: =list  */
static
char    *scanpu;          /* Key required to scan public chat channels */
static
char    *scanpr;          /* Key required to scan private chat channels */
static
char    *scansy;          /* Key required to scan sysop chat channels */
static
char    *chatpr;          /* Key required to enter PRIVATE chatter chan */
static
char    *chatsy;          /* Key required to enter SYSOP chatter chan */
static
char    *sendch;          /* Key required to send message on chat chan */
static
char    *actcod;          /* Activation code from msg file */
/*
****************************************************************************
* INITIALIZATION ROUTINE:
*      Open all message files, allocate any needed memory...
*      Read in options, register text variables...
****************************************************************************
*/

void EXPORT init__ocnglo(void)
{
    int i;
    stzcpy(mibocnglo.descrp, gmdnam("ocnglo.MDF"), MNMSIZ);
    ocnglostt = register_module(&mibocnglo);

    ocnglomb  =opnmsg("ocnglo.mcv");
    accdiskbtv=opnbtv("bbsusr.dat",sizeof(struct usracc));
    usrkeybb  =opnbtv("bbsk.dat",RINGSZ);
    ocnglogen =opnbtv("ocnglo.dat",GENSIZ);

    //INITILIZE OR POSSIBLY READ IN VARIABLES FROM MCV FILE..
    //SEE DEV-65 THROUGH DEV-68 FOR DETAILS.
    iniopt(); //reads in all variables from the msg file.

    //ALLOCATE NEEDED MEMORY FOR THIS MODULE
    ocnuarr=(struct ocnuser *)alczer(nterms*sizeof(struct ocnuser));
    usrkey =(char *)alcmem(RINGSZ);

    //REGISTER ANY GLOBAL COMMANDS OR TEXT VARIABLE ROUTINES
    globalcmd(globalrou);

    demo=1;
    regrou(); //registers module with activation code from msg file
    setbtv(ocnglogen);

    //
    //READ IN DEMO NAMES FROM DISK
    //

    strcpy(demodisk.key,"2063039615");
    strcpy(demodisk.modnam,"The Ocean Globals");

    //if sight does not already have a record of who can use this package
    //as a demo version then make them a blank record..
    if(!(acqbtv(&demodisk,&demodisk,0))) //if not record on disk
       {
       strcpy(demodisk.key,"2063039615");
       strcpy(demodisk.modnam,"The Ocean Globals");
       for (i=0 ; i<7 ; i++)
	   demodisk.data.names[i][0]='\0';
       demodisk.data.lastpublic=9999;
       demodisk.data.lastprivate=19999;
       invbtv(&demodisk,sizeof(struct demodisk));
       }
    //now if they had a previous record on disk then update the memory
    //structure with that information...
     for(i=0 ; i<7 ; i++)
       strcpy(demonames.names[i],demodisk.data.names[i]);
    demonames.lastpublic=demodisk.data.lastpublic;
    demonames.lastprivate=demodisk.data.lastprivate;

    //
    //OUR LITTLE MESSAGE IN THE AUDIT TRAIL
    //

    if (demo==1)
       shocst("THE OCEAN GLOBALS (demo copy)",__DATE__);
    else
       shocst("The Ocean Globals !",__DATE__);

   if (inviscred) rtkick(60,dedincred);
}

//iniopt -- initilize options (read in from msg file)
//          register all text vars..
void iniopt(void)
{
    optk1=stgopt(OPTK1);    optk2=stgopt(OPTK2);      optk3=stgopt(OPTK3);
    optk4=stgopt(OPTK4);    optk5=stgopt(OPTK5);      optk6=stgopt(OPTK6);
    optk7=stgopt(OPTK7);    optk8=stgopt(OPTK8);      optk9=stgopt(OPTK9);
   optk10=stgopt(OPTK10);   optk11=stgopt(OPTK11);   optk12=stgopt(OPTK12);
   optk13=stgopt(OPTK13);   optk14=stgopt(OPTK14);   optk15=stgopt(OPTK15);
   optk16=stgopt(OPTK16);   optk17=stgopt(OPTK17);   optk18=stgopt(OPTK18);
   optk19=stgopt(OPTK19);   optk20=stgopt(OPTK20);   optk21=stgopt(OPTK21);
   optk22=stgopt(OPTK22);   optk23=stgopt(OPTK23);   optk24=stgopt(OPTK24);
   optk25=stgopt(OPTK25);   optk26=stgopt(OPTK26);   optk27=stgopt(OPTK27);
   optk28=stgopt(OPTK28);   optk29=stgopt(OPTK29);   optk30=stgopt(OPTK30);
			    optk32=stgopt(OPTK32);   optk33=stgopt(OPTK33);
   optk34=stgopt(OPTK34);   optk35=stgopt(OPTK35);   optk36=stgopt(OPTK36);
   optk37=stgopt(OPTK37);   optk38=stgopt(OPTK38);   optk39=stgopt(OPTK39);
   optk40=stgopt(OPTK40);   optk41=stgopt(OPTK41);   optk42=stgopt(OPTK42);
   optk43=stgopt(OPTK43);   optk44=stgopt(OPTK44);   optk45=stgopt(OPTK45);
   optk46=stgopt(OPTK46);   optk47=stgopt(OPTK47);
   optk49=stgopt(OPTK49);   optk50=stgopt(OPTK50);   optk51=stgopt(OPTK51);
   optk52=stgopt(OPTK52);   optk53=stgopt(OPTK53);   optk54=stgopt(OPTK54);
   optk55=stgopt(OPTK55);   optk56=stgopt(OPTK56);   optk57=stgopt(OPTK57);
   optk58=stgopt(OPTK58);   optk59=stgopt(OPTK59);   optk60=stgopt(OPTK60);
   optk61=stgopt(OPTK61);   optk62=stgopt(OPTK62);   optk63=stgopt(OPTK63);

 optuolch=chropt(L4OPTUOL);
  ctrlchr=chropt(L4SELCHR);
 chatchar=chropt(L40001);
   scanpu=stgopt(L3SCANPU);
   scanpr=stgopt(L3SCANPR);
   scansy=stgopt(L3SCANSY);
   gopkey=stgopt(L3GOPKEY);
   suolky=stgopt(L3SUOLKY);
   sendch=stgopt(L3SENDCH);
   actcod=stgopt(L3ACTCOD);
   lstkey=stgopt(L3LSTKEY);
 showpass=ynopt(L40002);
   chatpr=stgopt(L3CHATPR);
   chatsy=stgopt(L3CHATSY);
inviscred=numopt(OPT40CRD,0,32000);

register_textvar("OCNGCRED",tv_ocngcred); //users credits
register_textvar("OCNGMINS",tv_ocngmins); //minutes left in credits
register_textvar("OCNGHRS",tv_ocnghrs);   //hours left in credits
register_textvar("OCNGDAT",tv_ocngdat);   //current date (all numeric)
register_textvar("OCNGFLA",tv_ocngfla);   //users flags
register_textvar("OCNGUOLC",tv_ocnguolc); //alternate UOL char
register_textvar("OCNGTT",tv_ocngtt);     //users total time on today
register_textvar("OCNGSEX",tv_ocngsex);   //users sex
register_textvar("OCNGAGE",tv_ocngage);   //users age
register_textvar("OCNGBAU",tv_ocngbau);   //users baud rate
register_textvar("OCNGMIN",tv_ocngmin);   //minutes online this call
register_textvar("OCNGCLA",tv_ocngcla);   //users class
register_textvar("OCNGCH",tv_ocngch);     //users channel #
register_textvar("OCNGLOC",tv_ocngloc);   //users location on bbs
register_textvar("OCNGCC",tv_ocngcc);     //what is the global cmd char?
register_textvar("OCNCCC",tv_ocnccc);     //Chatter channel character
register_textvar("OCNGUID",tv_ocnguid);   //user ID
register_textvar("OCNCHATN",tv_ocnchatn); //chat name
register_textvar("OCNGLOGF",tv_ocnglogf); //logoff message
register_textvar("OCNGLOGN",tv_ocnglogn); //logon message
register_textvar("OCNTUSER",tv_ocntuser); //Number of users online -invis
register_textvar("OCNGSDAT",tv_ocngsdat); //Sign up date
register_textvar("OCNGLAST",tv_ocnglast); //Date of last use of account
register_textvar("OCNGPW",tv_ocngpw);     //password
register_textvar("OCNRNAME",tv_ocnrname); //real name
register_textvar("OCNGPHON",tv_ocngphon); //phone #
register_textvar("OCNGSYST",tv_ocngsyst); //system type
register_textvar("OCNGEDIT",tv_ocngedit); //editor type (fse or line)
register_textvar("OCNGANSI",tv_ocngansi); //ansi "on" "off" or "auto"
register_textvar("OCNGBDAY",tv_ocngbday); //Users birthday "January 1, 1994"
register_textvar("OCNADD1",tv_ocnadd1);   //address line 1
register_textvar("OCNADD2",tv_ocnadd2);   //address line 2
register_textvar("OCNADD3",tv_ocnadd3);   //address line 3
register_textvar("OCNADD4",tv_ocnadd4);   //address line 4
register_textvar("OCNSWID",tv_ocnswid);   //users screen width
register_textvar("OCNSLEN",tv_ocnslen);   //users screen length
register_textvar("OCNGDCL",tv_ocngdcl);   //Days left in class
register_textvar("OCNCPAID",tv_ocncpaid); //Total paid credits
register_textvar("OCNCFREE",tv_ocncfree); //Total free credits
register_textvar("OCNFINVS",tv_ocnfinvs); //flag: Invisibility
register_textvar("OCNFPROT",tv_ocnfprot); //flag: Protected
register_textvar("OCNFSUSP",tv_ocnfsusp); //flag: Suspended
register_textvar("OCNFDEL",tv_ocnfdel);   //flag: Deletion
register_textvar("OCNFMAST",tv_ocnfmast); //flag: Master
} //end initilazation routine

/*
****************************************************************************
* INCLUDE ALL STATIC ROUTINES (ROUTINES USED IN THIS MODULE ONLY)
****************************************************************************
*/

#include "other\inputmsk.c"
#include "other\regrou.c"
#include "other\dspkeys.c"
#include "other\chkchat.c"
#include "other\systype.c"
#include "other\birthday.c"
#include "other\hdluidq.c"
#include "other\setoth.c"
#include "other\getusr.c"
#include "other\putusr.c"

//dedincred -- handles deducting credits from a user once a minute for
//             invisibility

void dedincred(void)
{
  for (othusn=0 ; othusn < nterms ; othusn++) {
       switch(user[othusn].class) {
	   case VACANT:
		break;
	   case ONLINE:
		break;
	   case SUPIPG:
		break;
	  default:
		if (ocnuarr[othusn].flags&DEDICRD)
		    odedcrd(othusn,inviscred,0,1);
		//this is where we have an actual user
		break;
		} //end switch
	  } //end for loop (cycling through all channels)

rtkick(60,dedincred);
}


// updusr -- updates the users info to disk
//
//
//             1 - update logon message from value in masked
//             2 - update logoff message from value in masked
//            10 - update macro 0
//            11 - update macro 1    \
//            12 - update macro 2     \
//            13 - update macro 3      \
//            14 - update macro 4       \
//            15 - update macro 5        All from value in masked
//            16 - update macro 6       /
//            17 - update macro 7      /
//            18 - update macro 8     /
//            19 - update macro 9    /
STATIC
void updusr (char field)
{
  int loop;
  setbtv(ocnglogen);
  setmem(&ocndisk,sizeof(ocndisk),0);
  strcpy(ocndisk.userid,usaptr->userid);
  strcpy(ocndisk.modnam,"The Ocean Globals");
  //now read in values from disk to ocndisk structure
  if(!(acqbtv(&ocndisk,&ocndisk,0))) //if user not on disk
    {
    setuserdefault();
    invbtv(&ocndisk,sizeof(struct ocndisk));
    }
  //now update ocndisk with the information that's in memory
  ocndisk.userd.flags=OCNFLAGS;
  ocndisk.userd.ocngcc=GLOBCHAR;
  ocndisk.userd.chatchar=CHATCHAR;
  for (loop=0;loop<26;loop++) {
      ocndisk.userd.channel[loop]=CHANNEL[loop];
      }
  if (field==1 && strlen(masked)<80)
     strcpy(ocndisk.logonmsg,masked);

  if (field==2 && strlen(masked)<80)
     strcpy(ocndisk.logoffmsg,masked);

  if (field >9 && field <20)
     strcpy(ocndisk.macros[field-10],masked);

  //now update this users info to disk
  upvbtv(&ocndisk,sizeof(struct ocndisk));
  rstbtv();
}

//setuserdefault -- sets defaults for a new users account
void setuserdefault(void)
   {
   strcpy(ocndisk.userid,usaptr->userid);
   strcpy(ocndisk.modnam,"The Ocean Globals");
   ocndisk.userd.flags=1;
   ocndisk.userd.ocngcc=ctrlchr;
   ocndisk.userd.tempchar=0;
   ocndisk.userd.tempint=0;
   ocndisk.userd.savesubstt=0;
   ocndisk.userd.savestate=0;
   ocndisk.userd.templong=0;
   strcpy(ocndisk.userd.string,"");
   for (TEMPCHAR=0;TEMPCHAR<26;TEMPCHAR++)
	ocndisk.userd.channel[TEMPCHAR]=0;
   ocndisk.userd.channel[0]=100; //set channel A to 100 by default
   ocndisk.userd.chatchar=chatchar;
   strcpy(ocndisk.logonmsg,"Hey Everybody!");
   strcpy(ocndisk.logoffmsg,"See ya all later!");
   ocndisk.userd.flags&=~NOTOTH;
   ocndisk.userd.flags&=~NOTYOU;
   ocndisk.userd.flags|=ECHOMSG;
   ocndisk.userd.flags|=CHATON;
   ocndisk.userd.flags|=256;    //set default =# list to 1
   for (TEMPCHAR=0;TEMPCHAR<10;TEMPCHAR++)
       ocndisk.macros[TEMPCHAR][0]='\0';
   strcpy(ocndisk.userd.chatname,"[5]None set");
 }

//getaccount -- Reads in an account from disk into the accountdisk struct
//    RETURN VALUES:
//        0 - Error reading account (does not exist).
//        1 - account read into structure successfully
//            accountdisk & ocndisk set for this user
//        2 - user is already online!
//            ocndisk set for this user
//
//      values of penetrate:
//           0 - do not penetrate invisibility
//           1 - penetrate invisibility

char getaccount(char *user,char penetrate)
{
char rv=0;
if (onsysn(user,penetrate)) { //if other user is already online...
   setothusn(user);
   setbtv(ocnglogen);
   setuserdefault();
   strcpy(ocndisk.userid,user);
   if(!(acqbtv(&ocndisk,&ocndisk,0))) //if user not on disk
      {
      setuserdefault();
      strcpy(ocndisk.userid,user);
      }
   rstbtv();
   tv_what=2;
   return(2);
   }

strcpy(accountdisk.userid,user);

setbtv(accdiskbtv);
if (acqbtv(&accountdisk,&accountdisk,0)) {
   rv=1;
   }
rstbtv();

if (rv) {
  setbtv(ocnglogen);
  setuserdefault();
  strcpy(ocndisk.userid,user);
  if(!(acqbtv(&ocndisk,&ocndisk,0))) //if user not on disk
     {
     setuserdefault();
     strcpy(ocndisk.userid,user);
     }
  rstbtv();
  tv_what=3;
  return(1); //valid account read from disk
  }
else return(0); //invalid account name
}


//updaccount -- updates a user account from the info in accountdisk
//
//              Note: do not call this function without first calling
//              getaccount to fill in the account structure..

void updaccount(void)
{
 setbtv(accdiskbtv);
 dupdbtv(&accountdisk);
 rstbtv();
}

//hdluido -- This takes a string, and tries to match it against all other
//           online, looking to see if the string is the start of there name.
//
//           Return values:
//
//
//                0 - No match at all
//                1 - Can only apply to 1 user, name is copied to
//                    TEMPSTRING
//                2 - More than 1 User-ID matches this

STATIC
char hdluido(char *match)
 {
  int loop;
  int numofmat=0;
  char string[30];

  strcpy(string,match);
  // First go through and get how many users we are dealing with
  for (loop=0 ; loop < nterms ; loop++) {
       switch(user[loop].class) {
	   case VACANT:
		break;
	   case ONLINE:
		break;
	   case SUPIPG:
		break;
	  default:
		//this is where we have an actual user
		if (sameto(string,uacoff(loop)->userid))
		    {
		    numofmat++;
		    strcpy(TEMPSTRING,uacoff(loop)->userid);
		    ocnothusn=loop;
		    }
		break;
		} //end switch
	  } //end for loop (cycling through all channels)

  // Now do the apropriate action according to how many matches there were
  if(numofmat >1) return(2);
  else return(numofmat);
 } //end routine


//prfclr -- prf's an ansi color code change sequence to the prfbuf
//          Works hand in hand with strclr()
STATIC
void prfclr(char fore, char back, char special)
{
 // You must set TEMPINT=256 before calling this each time
 // you start translating a new string or else it will fail miserbly
 //
 //a value of 100 is passed if you dont want to change back or fore
 // Special uses these following values:
 //
 //    1 - Toggle intensity off and on  [+]
 //    2 - Toggle flashing  off and on  [!]
 //    3 - Toggle Both intensity and flashing [+!]
 //
 //        Note: add a value of 128 to special to have prfclr append it's
 //              color codes to the string *color.
 //
 // information about how the ansi settings are currently, are stored in
 // TEMPINT
 //
 // The lowbit contains the previous color ansi sequences
 //
 //      7    6    5    4    3 |  2    1    0
 //                            |
 //   -------------------------|-------------
 //            Last            |    Last
 //          Foreground        |  Background
 //
 // The highbit contains various save flags (true/false) (on/off)
 //
 //    15    14     13     12       | 11 | 10 |   9 |   8   |
 //                                 |    |    |     |       |
 //                                 |Prev|Prev|flash|intense|
 //    ...unused...                 |Back|Fore|     |       |
 //                                 |used|used|     |       |
 //---------------------------------|----|----|-----|-------|
 //                                 |yes |yes |on   |on     |
 //                                 |no  |no  |off  |off    |
 // Default values:                 |    |    |     |       |
 //     back = 0                    |   2|   1|    5|      2|
 //     fore = 7                    |   0|   0|    1|      5|
 //  intense = on                   |   4|   2|    2|      6|
 //    flash = off                  |   8|   4|     |       |
 //
 // So with that aside here are the defines

#define FLAGPBACKG (TEMPINT&2048)
#define PREVBACKGR (TEMPINT&7)

#define PREVFOREGR (TEMPINT&248)>>3

#define FLAGPFOREG (TEMPINT&1024)
#define SETFPFOREG TEMPINT|=1024
#define SETFPBACKG TEMPINT|=2048
#define SETPFOREGR TEMPINT|=fore<<3
#define SETPBACKGR TEMPINT|=back
#define SETFLASHON TEMPINT|=512
#define SETFLASHOFF TEMPINT&=~512
#define SETINTENSEON TEMPINT|=256
#define SETINTENSEOFF TEMPINT&=~256
#define FLAGFLASH (TEMPINT&512)
#define FLAGINTENSE (TEMPINT&256)

//nested macros
#define FOREQUPFOR fore=(FLAGPFOREG ? PREVFOREGR : 7)
#define BACEQUPBAC back=(FLAGPBACKG ? PREVBACKGR : 0)

//this determines if we are printing to *color or prfbuf
char whereto=0;

if (special>64) {
   whereto=1;
   special-=128;
   }

 if (fore==100)
    {
    FOREQUPFOR;  //fore equals previous fore (if one exists), else fore=7
    SETFPFOREG;  //sets the 'there was a previous foreground' flag
    }
 else //setting new value
    {
    SETPFOREGR;  //sets previous fore to the one currenly being passed
    SETFPFOREG;
    }

// prf("after fore: Fore %d Back %d\n",fore,back);


 if (back==100)
    {
    BACEQUPBAC;  //back equals previous back (if one exists), else back=0
    SETFPBACKG;  //set the 'there was a previous background' flag
    }
 else//setting new value
    {
    SETPBACKGR;  //sets previous back to the one currently being passed
    SETFPBACKG;
    }


//prf("after back: Fore %d Back %d\n",fore,back);

  if (special >=2) //if user has spefied to toggle flashing
    {
    if (FLAGFLASH)
       SETFLASHOFF;
    else
       SETFLASHON;
    special-=2;
    }

  if (special) //if user has specified to toggle intensity
     {
     if (FLAGINTENSE)
	SETINTENSEOFF;
     else
	SETINTENSEON;
     }

 switch (fore) {
  case 0: fore=30; break; //black
  case 1: fore=34; break; //blue
  case 2: fore=32; break; //green
  case 3: fore=36; break; //cyan
  case 4: fore=31; break; //red
  case 5: fore=35; break; //magenta
  case 6: fore=33; break; //yellow
  case 7: fore=37; break; //white
  }//end switch normal colors

 switch (back) {
   case 0: back=40; break; //black
   case 1: back=44; break; //blue
   case 2: back=42; break; //green
   case 3: back=46; break; //cyan
   case 4: back=41; break; //red
   case 5: back=45; break; //magenta
   case 6: back=43; break; //yellow
   case 7: back=47; break; //white
   }//end switch backgrounds

 //now print ansi code to prfbuf


if (!whereto)
{

		  prf("\x1b[0;");
if (FLAGFLASH)    prf("5;");
if (FLAGINTENSE)  prf("1;");
		  prf("%d;",fore);
		  prf("%dm",back);
}
else
{

    strcat(colored,"\x1b[0;");
if (FLAGFLASH) {
    strcat(colored,"5;");
    coloredpos+=2;
    }
if (FLAGINTENSE) {
    strcat(colored,"1;");
    coloredpos+=2;
    }
    strcat(colored,spr("%d;",fore));
    strcat(colored,spr("%dm",back));
    coloredpos+=10;
}




//if (FLAGPFOREG) prf(" FPF ");
//if (FLAGPBACKG) prf(" FPB ");
//if (FLAGINTENSE) prf(" FI ");
//if (FLAGFLASH) prf(" FF ");



#undef FLAGPBACKG
#undef PREVBACKGR
#undef PREVFOREGR
#undef FLAGPFOREG
#undef SETFPFOREG
#undef SETFPBACKG
#undef SETPFOREGR
#undef SETPBACKGR
#undef SETFLASHON
#undef SETFLASHOFF
#undef SETINTENSEON
#undef SETINTENSEOFF
#undef FLAGFLASH
#undef FLAGINTENSE
#undef FOREQUPFOR
#undef BACEQUPBAC
}//end prfclr function

//strclr -- accepts a string and parses it for color change codes typed
//          by the user, and calls prfclr with the right values..
//
//          toto=0 -- *string is put to prfbuf
//          toto=1 -- *string is put to *nocolor (with no ansi color codes)
//          toto=2 -- *string is put to *colored
STATIC
void strclr(char *string, char toto)
 {
 char fore=0;
 char back=7;
 unsigned char flags=0;
 char remember=0;
 int nocolorpos=0;
 coloredpos=0;

 if (toto) {
  switch(toto) {
   case 1:
     if (isnocolor) free(nocolor);
     nocolor=alcmem(strlen(string)+1);
     isnocolor=1;
     nocolor[0]='\0';
     break;
   case 2:
     if (iscolor) free(colored);
     colored=alcmem(strlen(string)+1);
     iscolor=1;
     colored[0]='\0';
     break;
     }
  }

 TEMPINT=256; //starts prfclr as (intense on)
 TEMPLONG=0; //used as a counter for this function

 #define SETFORE flags|=1
 #define FORESET (flags&1)
 #define SETBACK flags|=2
 #define BACKSET (flags&2)
 #define SETFLAS flags|=4
 #define FLASSET (flags&4)
 #define SETINTE flags|=8
 #define INTESET (flags&8)
 #define SETONEV flags|=32
 #define ONEVSET (flags&32)
 #define CLRONEV flags&=~32
 #define SETREAD flags|=64
 #define READSET (flags&64)
 #define CLRREAD flags&=~64
 #define SETCOLO flags|=16
 #define COLOSET (flags&16)
 #define GETPOSI remember=(int)TEMPLONG
 #define PUTPOSI TEMPLONG=remember
 #define POSITION string[(int)TEMPLONG]
 #define FORWARD TEMPLONG++
 #define TRUEVALUE (string[(int)TEMPLONG]-48L)

  while (POSITION !='\0') {
      CLRONEV; //one value is allowed to be set per loop

      if (POSITION=='[' && !READSET) //Start of a command sequence
	 {
	 //bug("found [\n");
	 GETPOSI; //remembers position just in case this isn't color command
	 SETREAD; //let program know we've found '['
	 FORWARD;
	 }

      if (READSET && !ONEVSET && isdigit(POSITION) && (TRUEVALUE <8L)) {
	 //prf("found digit\n");
	 if(!FORESET && !ONEVSET) {
	   //prf("setting fore\n");
	   SETFORE;
	   SETONEV;
	   fore=TRUEVALUE;
	   }
	 if(!BACKSET && !ONEVSET) {
	   //prf("setting back\n");
	   SETBACK;
	   SETONEV;
	   back=TRUEVALUE;
	   }
	 } //END IF DIGIT

      if (READSET && !ONEVSET && POSITION=='!') {
	 //prf("found !\n");
	 if (!FLASSET) {
	    //prf("setting ! flag\n");
	    SETFLAS;
	    SETONEV;
	    }
	 }//end if '!'

      if (READSET && !ONEVSET && POSITION=='+') {
	 //prf("found +\n");
	 if (!INTESET) {
	    //prf("setting + flag");
	    SETINTE;
	    SETONEV;
	    }
	 }//end if '+'

      if (READSET && !ONEVSET && POSITION==']') {
	 //if in here color command was good
	 //Do all prfclr deals here...
	 remember=0; //this can be killed for a param special to prfclr()
	 if (!FORESET) fore=100; //signals that fore is to stay the same
	 if (!BACKSET) back=100; //signals that back is to stay the same
	 if (FLASSET) remember+=2; //sets up for a toggle to prfclr()
	 if (INTESET) remember+=1;
	 if (toto==0) prfclr(fore,back,remember);
	 if (toto==2) prfclr(fore,back,remember+128);

	 SETCOLO;
	 SETONEV;
	 //flags|=32;
	 //prf("did a prfclr");

	 }//end if ']'

      //if function made it through all that with the readset flag set
      // and didn't get a onevset, then there is an illegal string in the
      //command, drop out and print as normal.
      if (READSET && !ONEVSET) {
	 //prf("resetting because of illegal string\n");
	 PUTPOSI; //Reset to start printing at right place
	 flags=0;
	 }

      //now either print out character or move forward through the string
      if (!READSET)
	 {
	 if (!toto) prf("%c",POSITION);
	 else {
	   switch (toto)
	      {
	      case 1:
		nocolor[nocolorpos]=POSITION;
		nocolorpos++;
		break;
	      case 2:
		colored[coloredpos]=POSITION;
		coloredpos++;
		break;
		}
	 }
	 FORWARD;
	 }
      else //currently reading just increment
	 {
	 if (COLOSET) { //just got done doing a color command
	    //prf("just got done with color change\n");
	    flags=0;
	    FORWARD;
	    }
	 else
	    {
	    //prf(" -> ");
	    FORWARD;
	    }
	 }
      }//end while position !=NULL

if (toto)
 {
 switch (toto) {
  case 1:
    nocolor[nocolorpos]='\0';
    break;
  case 2:
    colored[nocolorpos]='\0';
    break;
  }
 }

 #undef SETFORE
 #undef FORESET
 #undef SETBACK
 #undef BACKSET
 #undef SETFLAS
 #undef FLASSET
 #undef SETINTE
 #undef INTESET
 #undef SETONEV
 #undef ONEVSET
 #undef CLRONEV
 #undef SETREAD
 #undef READSET
 #undef CLRREAD
 #undef SETCOLO
 #undef COLOSET
 #undef GETPOSI
 #undef PUTPOSI
 #undef POSITION
 #undef FORWARD
 #undef TRUEVALUE
 } //end strclr function

// sendtoall -- sends a message to a certain group of users specified by who:
//
//         1. Send to all who aren't busy (global across the BBS)
//         2. Sends chatter msg to one chatter ch. (assumes text in masked)
//         3. Notify all, user just left this one chatter
//         4. Notify all, user just entered this one chatter
//         5. Notify all, user just left all chatters (logoff)
//         6. Notify all, user just entered all chatters (logon)
//         7. Show logons and logoffs
//         8. Notify all users that have their chatters set to any freq that
//            this user has set to.
//
//   Return values:
//
//         0. Nobody on that channel...
//         1. Message successfully sent
//
//
STATIC
char sendtoall(char who,int channel)
 {
  char sent=0; //records if message was sent to anybody
  char iflag=0; //this flag is set if user receiving is invisible
  char othchatloop; //the other users chatter channels
  char usrchatloop; //this users chatter channels
  setmbk(ocnglomb);
  for (ocnothusn=0 ; ocnothusn < nterms ; ocnothusn++) {
       switch(user[ocnothusn].class) {

	   case VACANT:
		break;
	   case ONLINE:
		break;
	   case SUPIPG:
		break;
	  default:
		if (user[ocnothusn].flags&NOINJO) break; //user is busy

		switch(who) {
		    case 1:
		      outprf(ocnothusn);
		      sent=1;
		      break;
		    case 2: //all people on channel #
		      if(!OCNFLAGS&ECHOMSG) {
			if (ocnothusn==usrnum) break; //if user is self
			}
		      if (!ocnuarr[ocnothusn].flags&CHATON) break;//chatters are off

		      if (ocnuarr[ocnothusn].flags&RECVINV) iflag=1; //sending to user is invisible
		      //Handle sysop monitor chatters mode
		      if (ocnuarr[ocnothusn].flags&SYSMCHA) {
			 clrprf();
			 prf("\n%s %d: ",usaptr->userid,channel); //PN: cannot be OCNGUID
			 strclr(masked,0);
			 prf("\n");
			 othusn=ocnothusn;
			 injoth();
			 //outprf(ocnothusn);
			 //clrprf();
			 //prf("\n");
			 //outprf(ocnothusn);
			 //user[ocnothusn].flags|=INJOIP;
			 //btuoes(ocnothusn,1);
			 }

		      for (othchatloop=0;othchatloop<26;othchatloop++) {
			  if(ocnuarr[ocnothusn].channel[othchatloop] !=0) {
			     if (ocnuarr[ocnothusn].channel[othchatloop]==channel) {
				 clrprf();
				 prfmsg(L60086,othchatloop+65,channel);
				 strclr(masked,0);
				 prf("\n");
				 othusn=ocnothusn;
				 injoth();
				 //outprf(ocnothusn);
				 //clrprf();
				 //prf("\n");
				 //outprf(ocnothusn);
				 //user[ocnothusn].flags|=INJOIP;
				 //btuoes(ocnothusn,1);
				 sent=1;
				 break;
				 }
			     }
			  }
		      break;
		    case 3: //notify all, user just left this one chatter
		      if (ocnothusn==usrnum) break; //if user is self
		      if (!ocnuarr[ocnothusn].flags&CHATON) break;//chatters are off
		      if (usrptr->flags&INVISB) break;
		      if (ocnuarr[ocnothusn].flags&RECVINV) iflag=1; //sending to user is invisible
		      for (othchatloop=0;othchatloop<26;othchatloop++) {
			  if (ocnuarr[ocnothusn].channel[othchatloop]!=0 && ocnuarr[ocnothusn].channel[othchatloop]==channel) {
			     clrprf();
				   //"User just left chatter #..."
			     prfmsg(L60087,othchatloop+65,ocnuarr[ocnothusn].channel[othchatloop]);
			     othusn=ocnothusn;
			     injoth();
			     }
			  }
		      break;
		    case 4: //notify all that user is entering...
		      if (ocnothusn==usrnum) break; //if user is self
		      if (!ocnuarr[ocnothusn].flags&CHATON) break;//chatters are off
		      if (usrptr->flags&INVISB) break;
		      if (ocnuarr[ocnothusn].flags&RECVINV) iflag=1; //sending to user is invisible
			  for (othchatloop=0;othchatloop<26;othchatloop++) {
			  if (ocnuarr[ocnothusn].channel[othchatloop]!=0 && ocnuarr[ocnothusn].channel[othchatloop]==channel) {
			     clrprf();
				    //"User just enterd chatter #..."
			     prfmsg(L60088,othchatloop+65,ocnuarr[ocnothusn].channel[othchatloop]);
			     othusn=ocnothusn;
			     injoth();
			     }
			  }
		      break;
		    case 5: //notify all about leaving all chatters (logoff)
		      if (ocnothusn==usrnum) break; //if user is self
		      if (!ocnuarr[ocnothusn].flags&CHATON) break;//chatters are off
		      if (usrptr->flags&INVISB) break;
		      if (ocnuarr[ocnothusn].flags&RECVINV) iflag=1; //sending to user is invisible
			  for (usrchatloop=0;usrchatloop<26;usrchatloop++) {
			  for (othchatloop=0;othchatloop<26;othchatloop++) {
			      if (CHANNEL[usrchatloop]!=0 && CHANNEL[usrchatloop]==ocnuarr[ocnothusn].channel[othchatloop]) {
				 clrprf();
				       //"User just left chatter #..."
				 prfmsg(L60087,othchatloop+65,ocnuarr[ocnothusn].channel[othchatloop]);
				 othusn=ocnothusn;
				 injoth();
				 }
			      }
			  }
		      break;
		    case 6: //notify all about entering all chatters (logon)
		      if (ocnothusn==usrnum) break; //if user is self
		      if (!ocnuarr[ocnothusn].flags&CHATON) break;//chatters are off
		      if (usrptr->flags&INVISB) break;
		      if (ocnuarr[ocnothusn].flags&RECVINV) iflag=1; //sending to user is invisible
			  for (usrchatloop=0;usrchatloop<26;usrchatloop++) {
			  for (othchatloop=0;othchatloop<26;othchatloop++) {
			      if (CHANNEL[usrchatloop]!=0 && CHANNEL[usrchatloop]==ocnuarr[ocnothusn].channel[othchatloop]) {
				 clrprf();
				     //"User just entered chatter # ..."
				 prfmsg(L60088,othchatloop+65,ocnuarr[ocnothusn].channel[othchatloop]);
				 othusn=ocnothusn;
				 injoth();
				 }
			      }
			  }
		      break;
		    case 7: //logons and logoffs (implicit prfbuf)
		      if (ocnothusn==usrnum) break;
		      if (usrptr->flags&INVISB) break;
		      if (OCNFLAGS&NOTOTH) {
			 if(ocnuarr[ocnothusn].flags&NOTYOU) {
			   othusn=ocnothusn;
			   injoth();
			   sent=1;
			   }
			 }
		      break;
		    case 8: //notify all on any same chatter w/ prfbuf
		      if (ocnothusn==usrnum) break; //if user is self
		      if (!ocnuarr[ocnothusn].flags&CHATON) break;//chatters are off
		      if (ocnuarr[ocnothusn].flags&RECVINV) iflag=1; //sending to user is invisible
			  for (usrchatloop=0;usrchatloop<26;usrchatloop++) {
			  for (othchatloop=0;othchatloop<26;othchatloop++) {
			      if (CHANNEL[usrchatloop]!=0 && CHANNEL[usrchatloop]==ocnuarr[ocnothusn].channel[othchatloop]) {
				 othusn=ocnothusn;
				 injoth();
				 }
			      }
			  }
		      break;

		   } //end switch who
		break;
		} //end switch class
      } //end for loop (cycling through all channels)

rstmbk();
tv_what=1;

  if (!iflag) {
     if (sent)
	return(1);
     }

 return(0);
 }

// xxxlonrou -- The logon routine
int xxxlonrou(void)
{
int i=0;
int proceed=0;
setmbk(ocnglomb);
setbtv(ocnglogen);
//     ////   /////   ////  //   //
//    //  // //      //  // ///  //  //
//    //  // // ///  //  // //// //         ...LOGON ROUTINE...
//    //  // //   // //  // // ////
//    //  // //   // //  // //  ///  //
/////  ////   /////   ////  //   //
setuserdefault();
if(!(acqbtv(&ocndisk,&ocndisk,0))) //if user not on disk
   {
   //create new record for this user with default values
   setuserdefault();
   invbtv(&ocndisk,sizeof(struct ocndisk));
   }
//now set user in memory array with what we just got from disk or just created
OCNFLAGS=ocndisk.userd.flags;
GLOBCHAR=ocndisk.userd.ocngcc;
CHATCHAR=ocndisk.userd.chatchar;
for (TEMPCHAR=0;TEMPCHAR<26;TEMPCHAR++) {
     CHANNEL[TEMPCHAR]=ocndisk.userd.channel[TEMPCHAR];
     }
strcpy(ocnuarr[usrnum].chatname,ocndisk.userd.chatname);

//show logon message to other users
prf("\n");
prfmsg(L60089);
strclr(ocndisk.logonmsg,0);
prf("\n\n");
sendtoall(7,0);
//display to any other users that so and so just entered chatter chan...
sendtoall(6,0);
clrprf();
prf("\n");
//mask off any unneeded flags
OCNFLAGS&=~SNATCHD;

tv_what=1;
//now lets get on with the logon process!!
if (demo==1)
   {
    for (i=0;i<7;i++) {
     if (sameas(demonames.names[i],usaptr->userid))
	proceed=1;
     }
   if (proceed)
      prfmsg(L60007);
   }
else //registered
   {
   prfmsg(L60090);
   proceed=1;
   }

//display users online list if user has that prefrence set
if (proceed) {
   if (OCNFLAGS&SHOWUOL && haskey(optk3)){
      prfmsg(L6UOLH);
      ocnguol(0);  //output normal user list (0)
      prfmsg(L6UOLF);
      outprf(usrnum);
      }
   }
rstbtv();
rstmbk();
return(0);
}

// typedx -- backs out of menus or exits module
STATIC
int typedx(void)
{
 switch(usrptr->substt)
    {
    case 1:
       return(0);
    case L6CHPW: case L6RENP:  //@pw change password
      putusr();
      echon();
      prfmsg(L60003); //"Password not set"
      outprf(usrnum);
      return(1);
    case OPTO7: //@I info on a user
      putusr();
      return(1);
    case OPTO19: //@UR show user's registry
      putusr();
      return(1);
    case OPTO27: //@TR transfer credits
      putusr();
      prfmsg(L60172); //"Transfer aborted"
      outprf(usrnum);
      return(1);
    case OPTO39: //@K kick user offline
      setothusn(TEMPSTRING);
      tv_what=2;
      prfmsg(L60173); //"Abort! No user kicked offline"
      tv_what=1;
      outprf(usrnum);
      putusr();
      return(1);
    case OPTO41: //@PD post days to a user
      putusr();
      prfmsg(L60174); //"No days were posted"
      outprf(usrnum);
      return(1);
    case OPTO43: //@PC post credits to a user
      putusr();
      prfmsg(L60175); //"No credits were posted"
      outprf(usrnum);
      return(1);
    case OPTO45: //@US switch user's class
      putusr();
      prfmsg(L60176); //"No user's class was switched"
      outprf(usrnum);
      return(1);
    case OPTO47: //@IK issue key to a user
      putusr();
      prfmsg(L60177); //"No key was issued"
      outprf(usrnum);
      return(1);
    case OPTO57: //@S! unsuspend a user
      putusr();
      return(1);
    case OPTO59: //@DET detailed info on a user
      putusr();
      return(1);
    case OPTO24: //@/ page a user
      putusr();
      prfmsg(L60178); //"Page aborted"
      outprf(usrnum);
      return(1);
    case OPTO34: //@Gx send graphic to a user
      putusr();
      prfmsg(L60179); //"No graphic sent"
      outprf(usrnum);
      return(1);
    case OPTO42: //@SU suspend user's account
      putusr();
      prfmsg(L60180); //"No account was suspended"
      outprf(usrnum);
      return(1);
    case OPTO44: //@DA delete user's account
      putusr();
      prfmsg(L60004); //"No account was deleted"
      outprf(usrnum);
      return(1);
    case OPTO46: //@DC deduct credits from a user
      putusr();
      prfmsg(L60181); //"No credits were deducted"
      outprf(usrnum);
      return(1);
    case OPTO60: //@RK remove key from a user
      putusr();
      prfmsg(L60182); //"No keys were removed"
      outprf(usrnum);
      return(1);
    case OPTO40: //temp for @in invisilility
      putusr();
      prfmsg(L60091); //"You will not be turned invisible.."
      outprf(usrnum);
      return(1);
    default:
      prf("\n UNASSIGNED VALUE IN TYPEDX \N");
      outprf(usrnum);
      return(1);
    }
}

// reprompt -- reprompts with last question, menu or accepts default answer
STATIC
int reprompt(void)
 {
 switch(usrptr->substt)
   {
   case L6CHPW: //@pw enter new password prompt
      prf("\n");
      prfmsg(L6CHPW);
      outprf(usrnum);
      return(-1);
   case L6RENP: //@pw verify new password prompt
      prf("\n");
      prfmsg(L6RENP);
      outprf(usrnum);
      return(-1);
   case OPTO39:  //@k kicking user offline
      setothusn(TEMPSTRING);
      tv_what=2;
      prf("\nReason for kicking OCNGUID offline:\n[65-char area]");   //2 occur so far..
      tv_what=1;
      outprf(usrnum);
      return(-1);

   case OPTO44:  //temporary delete account reprompt routine
      switch(TEMPLONG)
	{
	case UIDPMT:
	     prfmsg(L60005);
	     outprf(usrnum);
	     return(-1);
	case UIDCAL:
	     prfmsg(L60006);
	     outprf(usrnum);
	     return(-1);
	}
   case OPTO40: //@in invisibility
      prfmsg(L60091); //"You will not be turned invisible..."
      outprf(usrnum);
      putusr();
      return(1);
   default:
     prf("\n UNASSIGNED VALUE IN REPROMPT\n");
     outprf(usrnum);
   }
 return(0);
 }


// xxxsttrou -- Main input routine handler for ocnglo
int xxxsttrou(void)
{
long before;
// switch to this modules message file
   setmbk(ocnglomb);
   tv_what=1;
// Did user hit return ? goto re-prompting / accept default answer routine
// if this next line is passed it can be assumed that margc > 0
   if (margc==0) return(reprompt());

// Did user type "X" ?  "X" ALWAYS backs up!
   if ((margc == 1) && sameas(margv[0], "X")) return(typedx());

    do {
	bgncnc();  //begins command concatination process
	switch (usrptr->substt)  {
	    case 0:             /* User just arrived through menu system */
		cncchr();         //strips off module selection character
		break;

	   case L6CHPW:  //@pw change (now verify)
		inputmask(1);
		if (sameas(margv[0],"password") || sameas(margv[0],usaptr->userid)) {
		   prfmsg(L60008);
		   return(reprompt());
		   } //end if password or userid
		prf("\n");
		prfmsg(usrptr->substt=L6RENP);
		outprf(usrnum);
		return(-1);

	   case L6RENP: //@pw change (ok changed or dosen't match)
		if (!(sameas(masked,input))) {
		   putusr();
		   echon();
		   prfmsg(L60009);
		   outprf(usrnum);
		   return(1);
		   }
		else //passwords match and are good
		   {
		   putusr();
		   echon();
		   strcpy(usaptr->psword,input);
		   prf("\n");
		   prfmsg(L60010);
		   outprf(usrnum);
		   return(1);
		   }
	   case OPTO7: //@I information on a user
		TEMPCHAR=hdluidq(NULL,OPTO7,0);
		if (handeluidq) return (-1);
		if (TEMPCHAR==3)   //user is currently online
		   prfmsg(L60080); //"Information screen..."(for online user)
		if (TEMPCHAR==4)   //User is currently offline
		   prfmsg(L60081); //"Information screen..."(for offline user)
		   outprf(usrnum);
		   putusr();
		   return(1);

	   case OPTO19: //@UR Users registry
		break;

	   case OPTO24: //@/ Page user
		break;

	   case OPTO27: //@tr transfer credits
		TEMPCHAR=hdluidq(NULL,OPTO27,0);
		if (handeluidq) return(-1);

		rdedcrd(TEMPLONG,1); //deduct from this user
		gdedcrd(masked,-TEMPLONG,1,0); //post to other user
		prfmsg(L60059, spr("%ld",TEMPLONG));

		if (TEMPCHAR==3) {  //user to transfer to is online
		   //!\\ put message here that other user is online and has been
		   //!\\ notified...
		   }
		outprf(usrnum);
		putusr();
		return(1);

	   case OPTO34: //@G Send graphics to user
		break;

	   case OPTO39: //@K Kick user offline
		setothusn(TEMPSTRING);
		before=usrnum;//save this usrnum
		curusr(ocnothusn); //SET THIS USRNUM TO THE OTHER USERS USRNUM
		updusr(0);       //update the users being kicked off info
		byenow(L6KICKUO,input); //KICK OFF OTHER USER
		clrprf();
		//restore usrnum
		curusr((int)before);
		if (strlen(masked)>65) masked[65]='\0';
		shocst("User Kicked offline with =K","%s Kicked off by: %s",TEMPSTRING,usaptr->userid);
		shocst("Reason user was kicked off:","%s",input);
                tv_what=2; //Note: must be 1 untill here
		prf("\nOCNGUID kicked offline for: %s\n",input);
		outprf(usrnum);
		putusr();
		return(-1);

	   case OPTO40: //temp for: does user accept cred charges for invis
		if (cncyesno()=='Y') { //user will accept charges...
		   OCNFLAGS|=DEDICRD;  //turn on deduct credits flag
		   usrptr->flags|=INVISB; //Turn user invisible
		   prfmsg(L60041); //"you are now invisible"
		   outprf(usrnum);
		   putusr(); //put user back to where he was
		   return(1);
		   }
		else {  //user said "NO WAY", "That's too many creds.."
		   prfmsg(L60091);
		   outprf(usrnum);
		   putusr();
		   return(1);
		   }

	   case OPTO41:  //@PD add day(s) to user routine:
		TEMPCHAR=hdluidq(NULL,OPTO41,0);
		if (handeluidq) return(-1);

		if(TEMPCHAR==3)   //User online
		   uacoff(ocnothusn)->daystt+=(int)TEMPLONG;
		if(TEMPCHAR==4) { //User offline
		   accountdisk.daystt+=(int)TEMPLONG;
		   updaccount();
		   }
		prfmsg(L60030,spr("%ld",TEMPLONG)); //"you have added..."
		outprf(usrnum);
		putusr();
		return(1);

	   case OPTO42: //@SU suspend user
		TEMPCHAR=hdluidq(NULL,OPTO42,0);
		if (handeluidq) return(-1);

		if (TEMPCHAR==3) {  //user is currently online
		   if (uacoff(ocnothusn)->flags&SUSPEN) {  //if user already suspended
		       prfmsg(L60126);  //"%s is already suspended..."
		       outprf(usrnum);
		       putusr();
		       return(1);
		       }
		uacoff(ocnothusn)->flags|=SUSPEN;
		prfmsg(L60125,(toupper(uacoff(TEMPINT)->sex)=='M' ? "him" : "her"));
		}

		if (TEMPCHAR==4) {  //User is currently offline
		   if (accountdisk.flags&SUSPEN) {  //if user already suspended
		       prfmsg(L60126);  //"%s is already suspended..."
		       outprf(usrnum);
		       putusr();
		       return(1);
		       }
		   accountdisk.flags|=SUSPEN;
		   updaccount();
		   prfmsg(L60127);//"%s's account is now suspended..."
		   }

		outprf(usrnum);
		putusr();
		return(1);

	   case OPTO43: //@pc post credits to user...
		TEMPCHAR=hdluidq(NULL,OPTO43,0);
		if (handeluidq) return(-1);
		if (TEMPCHAR==3){
		   before=uacoff(ocnothusn)->creds;
		   gdedcrd(masked,-TEMPLONG,0,1);
		   prfmsg(L60064,spr("%ld",before));
		   }
		if (TEMPCHAR==4) {
		   before=accountdisk.creds;
		   gdedcrd(masked,-TEMPLONG,0,1);
		   updaccount();
		   getaccount(accountdisk.userid,1);
		   prfmsg(L60064,spr("%ld",before));
		   }
		outprf(usrnum);
		putusr();
		return(1);

	     case OPTO44:  //@DA delete account routine:
		  TEMPCHAR=hdluidq(NULL,OPTO44,0);
		  if (handeluidq) return(-1);

		  if (TEMPCHAR==3){  //if user is online
		      if (uacoff(ocnothusn)->flags&DELTAG) {
			prf("\nOCNGUID's account is already flagged for deletion\n");
			outprf(usrnum);
			putusr();
			return(1);
			}
		     uacoff(ocnothusn)->flags|=DELTAG;
		     }

		  if (TEMPCHAR==4) { //User is currently offline
		     if (accountdisk.flags&DELTAG) {
			prf("\nOCNGUID's account is already flagged for deletion\n");
			outprf(usrnum);
			putusr();
			return(1);
			}
		     accountdisk.flags|=DELTAG;
		     updaccount();
		     }

		  prfmsg(L60038,uidxrf.userid);
		  outprf(usrnum);
		  putusr();
		  return(1);

	     case OPTO45:  //@SWITCH switch users class
		 TEMPCHAR=hdluidq(masked,OPTO45,0);
		 if (handeluidq) return(-1);

		 if (TEMPCHAR==3) {  //user is currently online
		    strcpy(uacoff(ocnothusn)->curcls,TEMPSTRING);
		    strcpy(uacoff(ocnothusn)->prmcls,TEMPSTRING);
			  //"%s class is now..."
		    prfmsg(L60130);
		    }

		 if (TEMPCHAR==4) {  //User is currently offline
		    strcpy(accountdisk.curcls,TEMPSTRING);
		    strcpy(accountdisk.prmcls,TEMPSTRING);
		    updaccount();
			  //"%s class is now..."
		    prfmsg(L60130);
		    }

		 outprf(usrnum);
		 putusr();
		 return(1);

	     case OPTO46: //@DC deduct credits from user
		  TEMPCHAR=hdluidq(NULL,OPTO46,0);
		  if (handeluidq) return(-1);

		  if (TEMPCHAR==3) {//User is currently online
		     if (TEMPLONG==-1)
			TEMPLONG=uacoff(ocnothusn)->creds;
		     before=uacoff(ocnothusn)->creds;
		     gdedcrd(masked,TEMPLONG,0,1);
		     prfmsg(L60064,spr("%ld",before));
		     }

		  if (TEMPCHAR==4) {//User is currently offline
		     if (TEMPLONG==-1)
			TEMPLONG=accountdisk.creds;
		     before=accountdisk.creds;
		     gdedcrd(masked,TEMPLONG,0,1);
		     prfmsg(L60064,spr("%ld",before));
		     }

		  outprf(usrnum);
		  putusr();
		  return(1);

	     case OPTO47: //@IK issue key to user
		  TEMPCHAR=hdluidq(NULL,OPTO47,0);
		  if (handeluidq) return(-1);
		  if (!(uhskey(masked,TEMPSTRING))) {
		      givkey(masked,TEMPSTRING);
		      prfmsg(L60132,TEMPSTRING);//"You have given the %s key to %s..."
		      }
		  else prfmsg(L60133,TEMPSTRING); //"user already has that key

		  outprf(usrnum);
		  putusr();
		  return(1);

	     case OPTO57: //@S! Unsuspend user
		  TEMPCHAR=hdluidq(NULL,OPTO57,0);
		  if (handeluidq) return(-1);

		  if (TEMPCHAR==3) {  //user is currently online
		     if (!(uacoff(ocnothusn)->flags&SUSPEN)) {  //if user not suspended
			prfmsg(L60136);//"User not suspended..?!"
			outprf(usrnum);
			putusr();
			return(1);
			}
		     uacoff(ocnothusn)->flags&=~SUSPEN;
		     prfmsg(L60135); //"%s no longer suspended..."
		     }

		  if (TEMPCHAR==4) {  //user is currently offline
		     if (!(accountdisk.flags&SUSPEN)) {  //if user not suspended
			prfmsg(L60136);//"User not suspended..?!"
			outprf(usrnum);
			putusr();
			return(1);
			}
		     accountdisk.flags&=~SUSPEN;
		     updaccount();
		     prfmsg(L60135); //"%s no longer suspended..."
		     }
		  outprf(usrnum);
		  putusr();
		  return(1);

	      case OPTO59: //@det Detailed information on a user
		   TEMPCHAR=hdluidq(NULL,OPTO59,0);
		   if (handeluidq) return(-1);

		   if (TEMPCHAR==3) {  //user is currently online
		      prfmsg(L60082); //Detailed info on a user screen
		      prfmsg(L60138);//"Keys Associated with this users class:"
		      dspkys(uacoff(ocnothusn)->curcls,1);
		      }

		   if (TEMPCHAR==4) {  //user is currently offline
		      prfmsg(L60082); //Detailed info on a user screen
		      prfmsg(L60138);//"Keys Associated with this users class:"
		      dspkys(accountdisk.curcls,1);
		      }

		   prfmsg(L60139);//"Keys This user holds personally:"
		   dspkys(uidxrf.userid,0);
		   outprf(usrnum);
		   putusr();
		   return(1);
	      case OPTO60: //@RK remove key from user
		   TEMPCHAR=hdluidq(NULL,OPTO60,0);
		   if (handeluidq) return(-1);

		   if (uhskey(masked,TEMPSTRING)) {
		       rmvkey(masked,TEMPSTRING);
		       prfmsg(L60141,TEMPSTRING);//"You have removed the %s key..."
		       }
		   else prfmsg(L60142,TEMPSTRING); //"%s does not have this key..."

		   outprf(usrnum);
		   putusr();
		   return(1);

	 }//end switch usrptr->substt
    } while (!endcnc());
return(0);
}

/* xxxlofrou -- user log off routine (update user info)*/
int xxxlofrou(void)  //...LOGOFF ROUTINE...
 {
 updusr(0);
 return(0);
 }

/* xxxhuprou -- user hang up routine (lost carrier) (update user info) */
void xxxhuprou(void) //...HANG UP ...HUP
 {
 setmbk(ocnglomb);
 sendtoall(5,0);  //notify all in chatters that this user is leaving
 prf("\n");
 prfmsg(L60092);
 strclr(ocndisk.logoffmsg,0);
 prf("\n");
 sendtoall(7,0);
 OCNFLAGS&=~DEDICRD;
 updusr(0);
 rstmbk();
 }

/* xxxfinrou -- Shut down Ocean Globals routine.  Closes files                 */
void xxxfinrou(void)
{
  int i;
  setbtv(ocnglogen);

//!\\ make your own file * for the genbb file
//
//UPDATE THE NON REGISTERED DEMO LIST TO DISK
//

  strcpy(demodisk.key,"2063039615");
  strcpy(demodisk.modnam,"The Ocean Globals");
  for (i=0;i<7;i++)
      demodisk.data.names[i][0]='\0';

  //if sight does not have a record of who can use this package as a demo
  //version make them one...
  if(!(acqbtv(&demodisk,&demodisk,0))) //if not record on disk
    {
    strcpy(demodisk.key,"2063039615");
    strcpy(demodisk.modnam,"The Ocean Globals");
    for (i=0;i<7;i++)
	demodisk.data.names[i][0]='\0';
    demodisk.data.lastpublic=9999;
    demodisk.data.lastprivate=19999;

    invbtv(&demodisk,sizeof(struct demodisk));
    }

  //now update this sight's info to disk from the one in memory
  for(i=0;i<7;i++)
     strcpy(demodisk.data.names[i],demonames.names[i]);

  demodisk.data.lastpublic=demonames.lastpublic;
  demodisk.data.lastprivate=demonames.lastprivate;

  upvbtv(&demodisk,sizeof(struct demodisk));

//
//CLOSE ALL FILES.. MEMORY IS AUTOMATICALLY DE-ALLOCATED
//

clsmsg(ocnglomb);     /* Close the .MCV file */
}

void xxxdlarou(char *uid)    // The Ocean globals Delete acount routine
{
     setbtv(ocnglogen);
     if(qeqbtv(uid,0)) {     // if there is a record for this user
	geqbtv(NULL,uid,0);
	delbtv();
	}

     rstbtv();
}

/* Ocean Globals, global command handler */
int globalrou(void)
{
int proceed=0;
int i;
tv_what=1; //default to using usrnum for textvar
if (margc==0) return(0); //if user just presses return...
/* NEW COMMAND TEMPLATE

//=
if (margc==1 && sameas(margv[0],spr("%cxx",GLOBCHAR)) && haskey(optk#)){

prf("\nstill programming: \n");
outprf(usrnum);
return(1);
} //end


*/
setmbk(ocnglomb);   //message block is set for whole global routine...
setbtv(accdiskbtv); //btrieve account database


/* THIS BLOCK OF CODE WAS BEING USED TO FIGURE OUT HOW DO DO 'REAL MACROS'

//TEMP ROUTINE....
if (margc>0 && sameas(margv[0],spr("%cxx",GLOBCHAR))){
inputmask(2);
rstrin();
strclr(masked,2);
if (strlen(colored)>254) colored[255]='\0';
strcpy(input,colored);
parsin();
prf("\nSupposedly you typed: %s\n",colored);
outprf(usrnum);
return(0);
} //end

if (margc>1 && sameas(margv[0],spr("%cff",GLOBCHAR))){
prf("\nEntered function:");
prf("\nSize of Input: %d",sizeof(input));
prf("          strlen of Input: %d\n",strlen(input));
prf("size of Margv[0] %d",sizeof(margv[0]));
prf("          strlen of margv[0] %d\n",strlen(margv[0]));
prf("size of Margv[1] %d",sizeof(margv[1]));
prf("          strlen of margv[1] %d\n",strlen(margv[1]));
rstrin();
prf("\nAFTER RSTRIN()");
prf("\nSize of Input: %d",sizeof(input));
prf("          strlen of Input: %d\n",strlen(input));
prf("size of Margv[0] %d",sizeof(margv[0]));
prf("          strlen of margv[0] %d\n",strlen(margv[0]));
prf("size of Margv[1] %d",sizeof(margv[1]));
prf("          strlen of margv[1] %d\n",strlen(margv[1]));
parsin();
prf("\nAFTER PARSIN()");
prf("\nSize of Input: %d",sizeof(input));
prf("          strlen of Input: %d\n",strlen(input));
prf("size of Margv[0] %d",sizeof(margv[0]));
prf("          strlen of margv[0] %d\n",strlen(margv[0]));
prf("size of Margv[1] %d",sizeof(margv[1]));
prf("          strlen of margv[1] %d\n",strlen(margv[1]));
return(1);
} //end

*/

////   ///// ///  ///   ///
// //  //    ////////  // //  //  ...DEMO VERSION COMMANDS...
//  // ////  // // // //   //
//  // //    //    // //   //
// //  //    //    //  // //  //
////   ///// //    //   ///

if (margc>2 && sameas(margv[0], spr("%cregister",GLOBCHAR)) && demo==1\
	    && (strlen(margv[1])==1) && ((margv[1][0]-48)>=0)         \
	    && ((margv[1][0]-48)<7) && haskey("sysop")) {
      inputmask(3);
      strcpy(demonames.names[margv[1][0]-48],masked);
      prfmsg(L60093,masked,(margv[1][0]-48));//"%s added to register ..."
      outprf(usrnum);
      return(1);
} //end

if (margc>2 && sameas(margv[0], spr("%cregister",GLOBCHAR)) && demo==2\
	    && (strlen(margv[1])==1) && ((margv[1][0]-48)>=0)         \
	    && ((margv[1][0]-48)<7) && haskey("sysop")) {
      prfmsg(L60094);  //"You no longer need this function..."
      outprf(usrnum);
      return(1);
} //end

if (margc==1 && sameas(margv[0], spr("%clist",GLOBCHAR)) && demo==1   \
	     && haskey(lstkey)) {
      int i;
      prfmsg(L60095);  //"Users currently registerd.."
      for (i=0;i<7;i++)
	  prfmsg(L60096,i,demonames.names[i]); //"%d: %s"
      prf("\n");
      outprf(usrnum);
      return(1);
} //end

if (margc==1 && sameas(margv[0], spr("%clist",GLOBCHAR)) && demo==2   \
	     && haskey(lstkey)) {
      prfmsg(L60097); //"No longer need to use this function ..."
      outprf(usrnum);
      return(1);
} //end


//this checks to see if a user has access to the commands
//if registered automatic access, if demo needs to be on register list
if (demo==1)
   {
   for (i=0;i<7;i++) {
       if (sameas(demonames.names[i],usaptr->userid))
	  proceed=1;
       }
   if (!proceed) return(0);
   }

//  // ///// //    /////
//  // //    //    //  // //
////// ////  //    /////        ...HELP SCREENS...
//  // //    //    //
//  // //    //    //     //
//  // ///// ///// //



//=? or =help SCREENS
if (margc==1 && haskey(optk1) &&     \
    (sameas(margv[0],spr("%c?",GLOBCHAR)) ||       \
    sameas(margv[0],spr("%chelp",GLOBCHAR)))) {
	 TEMPCHAR=0;
	 #define DOIF if (TEMPCHAR==3) {prf("\n");TEMPCHAR=0;}
	 prf("\n");
	 prfmsg(OGHELP);   //help screen header
	 //......ALL NORMAL OPTIONS.....
	 if (haskey(optk1)) {prfmsg(OPTO1);TEMPCHAR++;DOIF}
//	 if (haskey(optk2)) {prfmsg(OPTO2);TEMPCHAR++;DOIF}
	 if (haskey(optk3)) {prfmsg(OPTO3);TEMPCHAR++;DOIF}
	 if (haskey(optk4)) {prfmsg(OPTO4);TEMPCHAR++;DOIF}
	 if (haskey(optk5)) {prfmsg(OPTO5);TEMPCHAR++;DOIF}
//	 if (haskey(optk6)) {prfmsg(OPTO6);TEMPCHAR++;DOIF}
	 if (haskey(optk7)) {prfmsg(OPTO7);TEMPCHAR++;DOIF}
	 if (haskey(optk8)) {prfmsg(OPTO8);TEMPCHAR++;DOIF}
	 if (haskey(optk9)) {prfmsg(OPTO9);TEMPCHAR++;DOIF}
//	 if (haskey(optk10)) {prfmsg(OPTO10);TEMPCHAR++;DOIF}
	 if (haskey(optk11)) {prfmsg(OPTO11);TEMPCHAR++;DOIF}
//	 if (haskey(optk12)) {prfmsg(OPTO12);TEMPCHAR++;DOIF}
//	 if (haskey(optk13)) {prfmsg(OPTO13);TEMPCHAR++;DOIF}
	 if (haskey(optk14)) {prfmsg(OPTO14);TEMPCHAR++;DOIF}
	 if (haskey(optk15)) {prfmsg(OPTO15);TEMPCHAR++;DOIF}
	 if (haskey(optk16)) {prfmsg(OPTO16);TEMPCHAR++;DOIF}
	 if (haskey(optk17)) {prfmsg(OPTO17);TEMPCHAR++;DOIF}
	 if (haskey(optk18)) {prfmsg(OPTO18);TEMPCHAR++;DOIF}
//	 if (haskey(optk19)) {prfmsg(OPTO19);TEMPCHAR++;DOIF}
	 if (haskey(optk20)) {prfmsg(OPTO20);TEMPCHAR++;DOIF}
//	 if (haskey(optk21)) {prfmsg(OPTO21);TEMPCHAR++;DOIF}
	 if (haskey(optk22)) {prfmsg(OPTO22);TEMPCHAR++;DOIF}
	 if (haskey(optk23)) {prfmsg(OPTO23);TEMPCHAR++;DOIF}
//	 if (haskey(optk24)) {prfmsg(OPTO24);TEMPCHAR++;DOIF}
	 if (haskey(optk25)) {prfmsg(OPTO25);TEMPCHAR++;DOIF}
	 if (haskey(optk26)) {prfmsg(OPTO26);TEMPCHAR++;DOIF}
//	 if (haskey(optk27)) {prfmsg(OPTO27);TEMPCHAR++;DOIF}
	 if (haskey(optk28)) {prfmsg(OPTO28);TEMPCHAR++;DOIF}
	 if (haskey(optk29)) {prfmsg(OPTO29);TEMPCHAR++;DOIF}
	 if (haskey(optk30)) {prfmsg(OPTO30);TEMPCHAR++;DOIF}
//	 if (haskey(optk32)) {prfmsg(OPTO32);TEMPCHAR++;DOIF}
	 if (haskey(optk33)) {prfmsg(OPTO33);TEMPCHAR++;DOIF}
//	 if (haskey(optk34)) {prfmsg(OPTO34);TEMPCHAR++;DOIF}
//	 if (haskey(optk35)) {prfmsg(OPTO35);TEMPCHAR++;DOIF}
//	 if (haskey(optk36)) {prfmsg(OPTO36);TEMPCHAR++;DOIF}
//	 if (haskey(optk37)) {prfmsg(OPTO37);TEMPCHAR++;DOIF}
	 if (haskey(optk38)) {prfmsg(OPTO38);TEMPCHAR++;DOIF}
	 if (haskey(optk40)) {prfmsg(OPTO40);TEMPCHAR++;DOIF}
	 if (haskey(optk49)) {prfmsg(OPTO49);TEMPCHAR++;DOIF}
	 prf("\n \n");
	 prfmsg(L6OGHF);
	 prf("\n");
	 outprf(usrnum);
	 #undef DOIF
	 return(1);
}

//=? <COMMAND> shows help on that command
if (margc==2 && sameas(margv[0],spr("%c?",GLOBCHAR))    \
	   || sameas(margv[0],spr("%chelp",GLOBCHAR)) && haskey(optk1)){

       //special op menu...
	 if (sameas(margv[1],"op") && haskey(gopkey)) {
	    TEMPCHAR=0;
	    #define DOIF if (TEMPCHAR==3) {prf("\n");TEMPCHAR=0;}
	    prfmsg(OGHELP);   //help screen header
	    //......ALL SPECIAL OP OPTIONS.....
	    if (haskey(optk39)) {prfmsg(OPTO39);TEMPCHAR++;DOIF}
//	    if (haskey(optk41)) {prfmsg(OPTO41);TEMPCHAR++;DOIF}
	    if (haskey(optk42)) {prfmsg(OPTO42);TEMPCHAR++;DOIF}
//	    if (haskey(optk43)) {prfmsg(OPTO43);TEMPCHAR++;DOIF}
	    if (haskey(optk44)) {prfmsg(OPTO44);TEMPCHAR++;DOIF}
//	    if (haskey(optk45)) {prfmsg(OPTO45);TEMPCHAR++;DOIF}
//	    if (haskey(optk46)) {prfmsg(OPTO46);TEMPCHAR++;DOIF}
	    if (haskey(optk47)) {prfmsg(OPTO47);TEMPCHAR++;DOIF}
	    if (haskey(optk57)) {prfmsg(OPTO57);TEMPCHAR++;DOIF}
//	    if (haskey(optk59)) {prfmsg(OPTO59);TEMPCHAR++;DOIF}
	    if (haskey(optk60)) {prfmsg(OPTO60);TEMPCHAR++;DOIF}

	    prf("\n \n");
	    prfmsg(L6OGHF);
	    prf("\n");
	    outprf(usrnum);
	    #undef DOIF
	    return(1);
	    }//end of special op menu

	 //=? =?
	 if (sameas(margv[1],spr("%c?",GLOBCHAR)) && haskey(optk1)){
	    prfmsg(OPTH1);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?si
//	 if (sameas(margv[1],spr("%cSI",GLOBCHAR)) && haskey(optk2)){
//	    prfmsg(OPTH2);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=? =#
	 if (sameas(margv[1],spr("%c#",GLOBCHAR)) && haskey(optk3)){
	    prfmsg(OPTH3);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =B
	 if (sameas(margv[1],spr("%cB",GLOBCHAR)) && haskey(optk4)){
	    prfmsg(OPTH4);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =SW
	 if (sameas(margv[1],spr("%cSW",GLOBCHAR)) && haskey(optk5)){
	    prfmsg(OPTH5);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =N
//	 if (sameas(margv[1],spr("%cN",GLOBCHAR)) && haskey(optk6)){
//	    prfmsg(OPTH6);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=?I
	 if (sameas(margv[1],spr("%cI",GLOBCHAR)) && haskey(optk7)){
	    prfmsg(OPTH7);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?xf
	 if (sameas(margv[1],spr("%cXF",GLOBCHAR)) && haskey(optk8)){
	    prfmsg(OPTH8);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?XU
	 if (sameas(margv[1],spr("%cXU",GLOBCHAR)) && haskey(optk9)){
	    prfmsg(OPTH9);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =RE
//	 if (sameas(margv[1],spr("%cRE",GLOBCHAR)) && haskey(optk10)){
//	    prfmsg(OPTH10);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=? =RD
	 if (sameas(margv[1],spr("%cRD",GLOBCHAR)) && haskey(optk11)){
	    prfmsg(OPTH11);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =PS
//	 if (sameas(margv[1],spr("%cPS",GLOBCHAR)) && haskey(optk12)){
//	    prfmsg(OPTH12);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=?!
	 if (sameas(margv[1],spr("%c!",GLOBCHAR)) && haskey(optk13)){
	    prfmsg(OPTH13);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?-
	 if (sameas(margv[1],spr("%c-",GLOBCHAR)) && haskey(optk14)){
	    prfmsg(OPTH14);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? # (alternate)
	 if (sameas(margv[1],spr("%c",optuolch)) && haskey(optk15)){
	    prfmsg(OPTH15);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =TD
	 if (sameas(margv[1],spr("%cTD",GLOBCHAR)) && haskey(optk16)){
	    prfmsg(OPTH16);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =UL
	 if (sameas(margv[1],spr("%cUL",GLOBCHAR)) && haskey(optk17)){
	    prfmsg(OPTH17);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?pw
	 if (sameas(margv[1],spr("%cPW",GLOBCHAR)) && haskey(optk18)){
	    prfmsg(OPTH18);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =UR
//	 if (sameas(margv[1],spr("%cUR",GLOBCHAR)) && haskey(optk19)){
//	    prfmsg(OPTH19);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=?XO
	 if (sameas(margv[1],spr("%cXO",GLOBCHAR)) && haskey(optk20)){
	    prfmsg(OPTH20);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =RC
//	 if (sameas(margv[1],spr("%cRC",GLOBCHAR)) && haskey(optk21)){
//	    prfmsg(OPTH21);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=?CN
	 if (sameas(margv[1],spr("%cCN",GLOBCHAR)) && haskey(optk22)){
	    prfmsg(OPTH22);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =ED
	 if (sameas(margv[1],spr("%cED",GLOBCHAR)) && haskey(optk23)){
	    prfmsg(OPTH23);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =/
//	 if (sameas(margv[1],spr("%c/",GLOBCHAR)) && haskey(optk24)){
//	    prfmsg(OPTH24);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=? =CS
	 if (sameas(margv[1],spr("%cCS",GLOBCHAR)) && haskey(optk25)){
	    prfmsg(OPTH25);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =CH
	 if (sameas(margv[1],spr("%cch",GLOBCHAR)) && haskey(optk26)){
	    prfmsg(OPTH26);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =TR
//	 if (sameas(margv[1],spr("%ctr",GLOBCHAR)) && haskey(optk27)){
//	    prfmsg(OPTH27);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=? =A
	 if (sameas(margv[1],spr("%ca",GLOBCHAR)) && haskey(optk28)){
	    prfmsg(OPTH28);
	    outprf(usrnum);
	    return(1);
	    }
	 //=? =SL
	 if (sameas(margv[1],spr("%cSL",GLOBCHAR)) && haskey(optk29)){
	    prfmsg(OPTH29);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?AI
	 if (sameas(margv[1],spr("%cAI",GLOBCHAR)) && haskey(optk30)){
	    prfmsg(OPTH30);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?Mx
//	 if (sameas(margv[1],spr("%cM",GLOBCHAR)) && haskey(optk32)){
//	    prfmsg(OPTH32);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=?XN
	 if (sameas(margv[1],spr("%cXN",GLOBCHAR)) && haskey(optk33)){
	    prfmsg(OPTH33);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?Gx
//	 if (sameas(margv[1],spr("%cG",GLOBCHAR)) && haskey(optk34)){
//	    prfmsg(OPTH34);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=? =NT
//	 if (sameas(margv[1],spr("%cNT",GLOBCHAR)) && haskey(optk35)){
//	    prfmsg(OPTH35);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=? =RT
//	 if (sameas(margv[1],spr("%cRT",GLOBCHAR)) && haskey(optk36)){
//	    prfmsg(OPTH36);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=? =//
//	 if (sameas(margv[1],spr("%c//",GLOBCHAR)) && haskey(optk37)){
//	    prfmsg(OPTH37);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=? `?
	 if (sameas(margv[1],spr("%c?",CHATCHAR)) && haskey(optk38)){
	    prfmsg(OPTH38);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?K (kick user offline)
	 if (sameas(margv[1],spr("%cK",GLOBCHAR)) && haskey(optk39)){
	    prfmsg(OPTH39);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?in
	 if (sameas(margv[1],spr("%cIN",GLOBCHAR)) && haskey(optk40)){
	    prfmsg(OPTH40);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?PD
//	 if (sameas(margv[1],spr("%cPD",GLOBCHAR)) && haskey(optk41)){
//	    prfmsg(OPTH41);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=?SU
	 if (sameas(margv[1],spr("%cSU",GLOBCHAR)) && haskey(optk42)){
	    prfmsg(OPTH42);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?PC
//	 if (sameas(margv[1],spr("%cPC",GLOBCHAR)) && haskey(optk43)){
//	    prfmsg(OPTH43);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=?DA
	 if (sameas(margv[1],spr("%cDA",GLOBCHAR)) && haskey(optk44)){
	    prfmsg(OPTH44);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?SWITCH
//	 if (sameas(margv[1],spr("%cswitch",GLOBCHAR)) && haskey(optk45)){
//	    prfmsg(OPTH45);
//	    outprf(usrnum);
//	    return(1);
//	    }
	 //=?DC
//	 if (sameas(margv[1],spr("%cDC",GLOBCHAR)) && haskey(optk46)){
//	    prfmsg(OPTH46);
//	    outprf(usrnum);
//	    return(1);
//	    }

	 //=?IK
	 if (sameas(margv[1],spr("%cIK",GLOBCHAR)) && haskey(optk47)){
	    prfmsg(OPTH47);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?EM
	 if (sameas(margv[1],spr("%cEM",GLOBCHAR)) && haskey(optk49)){
	    prfmsg(OPTH49);
	    outprf(usrnum);
	    return(1);
	    }
	 //=?S!
	 if (sameas(margv[1],spr("%cs!",GLOBCHAR)) && haskey(optk57)){
	    prfmsg(OPTH57);
	    outprf(usrnum);
	    return(1);
	    }

	 //=?det
//	 if (sameas(margv[1],spr("%cdet",GLOBCHAR)) && haskey(optk59)){
//	    prfmsg(OPTH59);
//	    outprf(usrnum);
//	    return(1);
//	    }

	 //=?rk
	 if (sameas(margv[1],spr("%cRK",GLOBCHAR)) && haskey(optk60)){
	    prfmsg(OPTH60);
	    outprf(usrnum);
	    return(1);
	    }

	 /* NEW HELP ON COMMAND TEMPLATE

	 //=?
	 if (sameas(margv[1],spr("%c"#,GLOBCHAR)) && haskey(optk#)){
	    prfmsg(OPTH#);
	    outprf(usrnum);
	    return(1);
	    }

	 */

	//if program reaches here user didn't have access ...
	return(0);
} //end help <command> routine



//`? displays the help screen for CHATTER CHANNELS
if (margc==1 && sameas(margv[0],spr("%c?",CHATCHAR)) && haskey(optk38)){

    TEMPCHAR=0;
    #define DOIF if (TEMPCHAR==3) {prf("\n");TEMPCHAR=0;}
    prfmsg(OPT38H);   //` help screen header
    //......ALL CHATTER COMMANDS.....
    if (haskey(optk50)) {prfmsg(OPTO50);TEMPCHAR++;DOIF}
    if (haskey(optk51)) {prfmsg(OPTO51);TEMPCHAR++;DOIF}
    if (haskey(optk52)) {prfmsg(OPTO52);TEMPCHAR++;DOIF}
    if (haskey(optk53)) {prfmsg(OPTO53);TEMPCHAR++;DOIF}
    if (haskey(optk54)) {prfmsg(OPTO54);TEMPCHAR++;DOIF}
    if (haskey(optk55)) {prfmsg(OPTO55);TEMPCHAR++;DOIF}
    if (haskey(optk56)) {prfmsg(OPTO56);TEMPCHAR++;DOIF}
    if (haskey(optk58)) {prfmsg(OPTO58);TEMPCHAR++;DOIF}
    if (haskey(optk61)) {prfmsg(OPTO61);TEMPCHAR++;DOIF}
//  if (haskey(optk62)) {prfmsg(OPTO62);TEMPCHAR++;DOIF}
//  if (haskey(optk63)) {prfmsg(OPTO63);TEMPCHAR++;DOIF}

    prf("\n \n");
    prfmsg(OPT38F);
    prf("\n");
    outprf(usrnum);
    #undef DOIF
    return(1);
} //end


//`? <cmd> shows help on that specific command
if (margc>1 && sameas(margv[0],spr("%c?",CHATCHAR))    \
	   || sameas(margv[0],spr("%chelp",CHATCHAR)) && haskey(optk38)){


	 //`? `
	 if (sameas(margv[1],spr("%c",CHATCHAR)) && haskey(optk50)){
	    prfmsg(OPTH50);
	    outprf(usrnum);
	    return(1);
	    }

	 //`? `ch
	 if (sameas(margv[1],spr("%cch",CHATCHAR)) && haskey(optk51)){
	    prfmsg(OPTH51);
	    outprf(usrnum);
	    return(1);
	    }

	 //`? `x
	 if (margc==2 && sameas(margv[1],spr("%cx",CHATCHAR)) && haskey(optk52)){
	    prfmsg(OPTH52);
	    outprf(usrnum);
	    return(1);
	    }

	 //`? `x #
	 if (margc >2 && sameas(margv[1],spr("%cx",CHATCHAR)) && haskey(optk53)){
	    prfmsg(OPTH53);
	    outprf(usrnum);
	    return(1);
	    }

	 //`? `scan
	 if (sameas(margv[1],spr("%cscan",CHATCHAR)) && haskey(optk54)){
	    prfmsg(OPTH54);
	    outprf(usrnum);
	    return(1);
	    }

	 //`? `spu
	 if (sameas(margv[1],spr("%cspu",CHATCHAR)) && haskey(optk55)){
	    prfmsg(OPTH55);
	    outprf(usrnum);
	    return(1);
	    }

	 //`? `spr
	 if (sameas(margv[1],spr("%cspr",CHATCHAR)) && haskey(optk56)){
	    prfmsg(OPTH56);
	    outprf(usrnum);
	    return(1);
	    }

	 //`? `?
	 if (sameas(margv[1],spr("%c?",CHATCHAR)) && haskey(optk38)){
	    prfmsg(OPTH38);
	    outprf(usrnum);
	    return(1);
	    }

	 //`? `ic
	 if (sameas(margv[1],spr("%cic",CHATCHAR)) && haskey(optk58)){
	    prfmsg(OPTH58);
	    outprf(usrnum);
	    return(1);
	    }

	 //`? `mon
	 if (sameas(margv[1],spr("%cMON",CHATCHAR)) && haskey(optk61)){
	    prfmsg(OPTH61);
	    outprf(usrnum);
	    return(1);
	    }

	 //`? `OFF
//	 if (sameas(margv[1],spr("%coff",CHATCHAR)) && haskey(optk62)){
//	    prfmsg(OPTH62);
//	    outprf(usrnum);
//	    return(1);
//	    }


	 //`? `ON
//	 if (sameas(margv[1],spr("%ON",CHATCHAR)) && haskey(optk63)){
//	    prfmsg(OPTH63);
//	    outprf(usrnum);
//	    return(1);
//	    }


	 /* NEW HELP ON COMMAND TEMPLATE
	 //`?
	 if (sameas(margv[1],spr("%c"#,CHATCHAR)) && haskey(optk#)){
	    prfmsg(OPTH#);
	    outprf(usrnum);
	    return(1);
	    }


	 */
}//end `? <cmd> chatter channel help on specific command




//   //  ////  /////  /// ///  ////  //
///  // //  // //  // /////// //  // //    //
//// // //  // /////  // / // ////// //         ...NORMAL COMMANDS...
// //// //  // // //  //   // //  // //                (2-38)
//  /// //  // // //  //   // //  // //    //
//   //  ////  //  // //   // //  // /////

/*

//=SI
if (margc==1 && sameas(margv[0],spr("%csi",GLOBCHAR)) && haskey(optk2)){
prfmsg(L60079);

if ((haskey(scanpu)&&haskey(scanpr))||(haskey(scanpu)&&haskey(scansy)))
   prfmsg(L60098,demonames.lastpublic); //"Public channels..."
if ((haskey(scanpr)&&haskey(scanpu))||(haskey(scanpr)&&haskey(scansy)))
   prfmsg(L60170,demonames.lastpublic+1,demonames.lastprivate);//"Private ch..."
if ((haskey(scansy)&&haskey(scanpu))||(haskey(scansy)&&haskey(scanpr)))
   prfmsg(L60171,demonames.lastprivate+1); //"Sysop only channels..."

outprf(usrnum);
return(1);
} //end system information

*/

//=# USERS ONLINE LIST
if (margc>0 && sameas(margv[0],spr("%c#",GLOBCHAR)) && haskey(optk3)){
   //'=#' is never sysop list
     char newnumb;
      tv_what=2; //sets text variables to output right info
      if (margc==2) { //user is setting his/her new preference
	 if (isdigit(margv[1][0])) {
	    if ((newnumb=margv[1][0]-48)>3) {
	       prfmsg(L60099);//"This can only be set to  1, 2 or 3..."
	       tv_what=1;
	       outprf(usrnum);
	       return(1);
	       }
	    switch (newnumb) {
	      case 1:
		ocnuarr[usrnum].flags|=256;
		ocnuarr[usrnum].flags&=~512;
		break;
	      case 2:
		ocnuarr[usrnum].flags&=~256;
		ocnuarr[usrnum].flags|=512;
		break;
	      case 3:
		ocnuarr[usrnum].flags|=768;
		break;
		}
	    }
	 else prfmsg(L60100); //"Not changed"
	 }

      //print out correct headers & footers, level 1-3
      switch (UOLLIST) {  //HEADER
	     case 1:
	       prfmsg(L6UOLH);
	       break;
	     case 2:
	       prfmsg(L6UOLH2);
	       break;
	     case 3:
	       prfmsg(L6UOLH3);
	       break;
	     }

      ocnguol(2);  //output =# user list

      switch (UOLLIST) {  //HEADER
	     case 1:
	       prfmsg(L6UOLF);
	       break;
	     case 2:
	       prfmsg(L6UOLF2);
	       break;
	     case 3:
	       prfmsg(L6UOLF3);
	       break;
	     }
      outprf(usrnum);
      tv_what=1;
      return(1);
   } //end if "=#"

//=B BUSY FLAG TOGGLE
if (margc==1 && sameas(margv[0],spr("%cb",GLOBCHAR)) && haskey(optk4)){
      if (usrptr->flags&NOINJO) {  //if busy flag is currently on
	 usrptr->flags-=NOINJO;
	 prfmsg(L60052);   //BUSY OFF
	 outprf(usrnum);
	 return(1);
	 } //end if busy flag is currently on
      else //busy flag is not currently on
	 {
	 usrptr->flags+=NOINJO;
	 prfmsg(L60053);  //BUSY ON
	 outprf(usrnum);
	 return(1);
	 }// end busy flag is not currently set
   } //end ansi toggle

//=SW SET SCREEN WIDTH
if (margc>0 && sameas(margv[0], spr("%csw",GLOBCHAR)) && haskey(optk5)){
      if (margc >1)
	 {
	 if (atoi(margv[1]) < 256) {
	    usaptr->scnwid=(atoi(margv[1]));
	    btutsw(usrnum,atoi(margv[1]));
	    prfmsg(L60047); //"you set your sw to ..."
	    outprf(usrnum);
	    return(1);
	    } //end if user specified less than 256 lines
	 else //if number was 256 or greater
	    {
	    prfmsg(L60048);//LIMIT ON SW IS...
	    outprf(usrnum);
	    return(1);
	    }//end if number was 256 or greater
	 }//end if margc >1
      else //user only typed =sl
	 {
	 prfmsg(OPTF5); //"Format..."
	 outprf(usrnum);
	 return(1);
	 }// end user only typed =sl
}//end


/*

//=N
if (margc==1 && sameas(margv[0],spr("%cn",GLOBCHAR)) && haskey(optk6)){
prf("\nstill programming: Notes and reminders \n");
outprf(usrnum);
return(1);
} //end


*/

//=I
if (margc>0 && sameas(margv[0],spr("%ci",GLOBCHAR)) && haskey(optk7)){

if (margc==1) {  //user just typed =i
  prfmsg(OPTF7); //"FORMAT..."
  outprf(usrnum);
  return(1);
  }

inputmask(2); //get full user id's name...

TEMPCHAR=hdluidq(masked,OPTO7,0);

if (handeluidq) return (-1);

if (TEMPCHAR==3)   //user is currently online
   prfmsg(L60080); //"Information screen..."  (for online user)

if (TEMPCHAR==4)   //User is currently offline
   prfmsg(L60081); //"Information screen..." (for offline user)

outprf(usrnum);
return(1);
}//end

//=XF
if (margc>0 && sameas(margv[0],spr("%cxf",GLOBCHAR)) && haskey(optk8)){
if (margc==1) {
   prfmsg(OPTF8); //"Format..."
   outprf(usrnum);
   return(1);
   }
inputmask(2);
if (strlen(masked)>79) {
   prfmsg(L60103);//"Message longer than 79 chars.."
   outprf(usrnum);
   return(1);
   }
updusr(2); //update users logoff message
prfmsg(L60104); //"Your new logoff message is..."
strclr(ocndisk.logoffmsg,0);
prf("\n");
outprf(usrnum);
return(1);
} //end

//=XU NOTIFY OTHERS WHEN YOU LOGON AND OFF TOGGLE
if (margc==1 && sameas(margv[0],spr("%cXu",GLOBCHAR)) && haskey(optk9)){
if (OCNFLAGS&NOTYOU) {
   OCNFLAGS&=~NOTYOU;
   prfmsg(L60105); //"No longer will you see users logging..."
   }
else {
   OCNFLAGS|=NOTYOU;
   prfmsg(L60106);//"Your will now see other users logging on and off..."
   }
outprf(usrnum);
return(1);
} //end

/*

//=RE
if (margc==1 && sameas(margv[0],spr("%cre",GLOBCHAR)) && haskey(optk10)){
prf("\nstill programming: re-log on to system\n");
outprf(usrnum);
return(1);
} //end

*/

//=R Roll dice in chat
if (margc>0 && sameas(margv[0],spr("%crd",GLOBCHAR)) && haskey(optk11)){
  int dice=0, sides=0;

  randomize();
  if (margc !=2)
    {
    prfmsg(OPTF11); //CORRECT FORMAT
    outprf(usrnum);
    return(-1);
    }
  if (strlen(margv[1])>25)
    {
    prfmsg(OPTF11); //CORRECT FORMAT
    outprf(usrnum);
    return(-1);
    }

  TEMPINT=0;
  TEMPCHAR=0;
  TEMPLONG=0;

  while (margv[1][TEMPINT] != '\0')
    {

    if (!(isdigit(margv[1][TEMPINT])) && !(toupper(margv[1][TEMPINT])=='D'))
      {
      //this is not a digit and is not a D!
      prfmsg(OPTF11); //"Invalid character..."
      outprf(usrnum);
      return(1);
      }

    if ((toupper(margv[1][TEMPINT])) == 'D')
      {
      TEMPINT++;
      //convert to dice
      dice=atoi(TEMPSTRING);
      TEMPSTRING[0]='\0';
      TEMPCHAR=0;
      while (margv[1][TEMPINT] != '\0')
	{
	if (!(isdigit(margv[1][TEMPINT])))
	  {
	  //this is not a digit!
	  prfmsg(OPTF11);//"You have input an invalid character!..."
	  outprf(usrnum);
	  return(1);
	  }
	TEMPSTRING[TEMPCHAR]=margv[1][TEMPINT];
	TEMPSTRING[TEMPCHAR+1]='\0';
	TEMPINT++;
	TEMPCHAR++;
	}
      //convert to sides
      sides=atoi(TEMPSTRING);
      break;
      }
    TEMPSTRING[TEMPINT]=margv[1][TEMPINT];
    TEMPSTRING[TEMPINT+1]='\0';
    TEMPINT++;
    }//end while cycling through margv
  TEMPLONG=0;
  for (TEMPINT=1;TEMPINT<=dice;TEMPINT++)
    {
    TEMPLONG+=(random(sides)+1);
    }
  prfmsg(L60037,dice,sides,spr("%ld",TEMPLONG));
  outprf(usrnum);
  return(1);
}

/*

//=PS PAGE SYSOP
if (margc==1 && sameas(margv[0],spr("%cps",GLOBCHAR)) && haskey(optk12)){
prf("\nPaging sysop at main console...\n");
printf("\7"); //beep!
outprf(usrnum);
return(1);
} //end

*/

/*

//=! ADD COLOR TO INPUT
if (margc>0 && sameas(margv[0],spr("%c!",GLOBCHAR)) && haskey(optk13)){

  if (margc>1) {
    //strip off leading edge =!
    TEMPINT=0;
    inputmask(2);
    //NOW PROCESS USERS INPUT
    prf("\n"); //puts in return for a footer
    prfmsg(L6FUID);//message header (From user:)
    strclr(masked,0); //transfers input to color in prfbuf
    prf("\n");//message footer
    if(sendtoall(1,0)) {
      clrprf();
      prfmsg(L60078); //*** COLOR MESSAGE SENT ***
      }
    else return(0);
    }
  else //user only typed =!
    prfmsg(OPTH13);
  outprf(usrnum);
  return(1);
 }

*/

//=- QUICK LOG-OFF SEQUENCE
if (margc==1 && sameas(margv[0], spr("%c-",GLOBCHAR)) && haskey(optk14)){
    byenow(L6QLOM);
    return(-1);
   }

//# OPTIONAL USERS ONLINE LIST
if (margc==1 && margv[0][0]==optuolch && haskey(optk15)){
tv_what=2; //sets text var to ouput correct info
     if (haskey(suolky)) {  //has sysop viewing powers
      setmbk(ocnglomb);
      prfmsg(L6UOL2H);    //sysop header
      ocnguol(1);         //display sysop users online list
      prfmsg(L6UOL2F);    //sysop footer
      outprf(usrnum);
      tv_what=1;
      return(1);
      }
     else {
      setmbk(ocnglomb);
      prfmsg(L6UOLH);    //normal header
      ocnguol(0);        //display normal users online list
      prfmsg(L6UOLF);    //normal footer
      outprf(usrnum);
      tv_what=1;
      return(1);
      }
   } // if # is hit

//=TD SHOW CURRENT TIME AND DATE
if (margc==1 && sameas(margv[0], spr("%ctd",GLOBCHAR)) && haskey(optk16)){
      prfmsg(L60054); //"THE TIME IS: ... THE DATE IS ..."
      outprf(usrnum);
      return(1);
} //end

//=UL TOGGLE USERS ON LINE AT LOGON TIME
if (margc==1 && sameas(margv[0], spr("%cul",GLOBCHAR)) && haskey(optk17)){
      if (OCNFLAGS&SHOWUOL) { //flag is currently set
	 OCNFLAGS-=SHOWUOL;
	 //upvbtv(&ocnuserd,sizeof(ocnuserd));
	 prfmsg(L60042); //NO UOL @ LOGON
	 outprf(usrnum);
	 return(1);
	 }
      else //flag is not currenly set
	 {
	 OCNFLAGS+=SHOWUOL;
	 //upvbtv(&ocnuserd,sizeof(ocnuserd));
	 prfmsg(L60043); //UOL @ LOGON
	 outprf(usrnum);
	 return(1);
	 }  //end if flag is not currently set
} //end

//=PW CHANGE PASSWORD
if (margc==1 && sameas(margv[0], spr("%cpw",GLOBCHAR)) && haskey(optk18)){
   getusr(L6CHPW);   //bring user into this module
   usrptr->flags|=NOINJO;             //now make user busy no matter what
   usrptr->flags|=NOGLOB;             //make no globals allowed either
   prfmsg(L6CHPW);      //"Enter new password[        ]"
   outprf(usrnum);
   echsec('',PSWSIZ);
   return(-1);  //send command process to the input handler for this module
} //end

/*

//=UR
if (margc==1 && sameas(margv[0],spr("%cur",GLOBCHAR)) && haskey(optk19)){
//Read in registery structure in the getaccount routine when doing this
//function...make it so you can call hdluidq and everything will be read in
//accordingly....
prf("\nstill programming: User Registry\n");
outprf(usrnum);
return(1);
} //end

*/

//=XO  set logon message
if (margc>0 && sameas(margv[0],spr("%cxo",GLOBCHAR)) && haskey(optk20)){
if (margc==1) {
   prfmsg(OPTF20); //"Format..."
   outprf(usrnum);
   return(1);
   }
inputmask(2);
if (strlen(masked)>79) {
   prfmsg(L60103); //"Your message is longer than 79 chars..."
   outprf(usrnum);
   return(1);
   }
updusr(1); //update users logon message
prfmsg(L60108); //"Your new logon message is:.."
strclr(ocndisk.logonmsg,0);
prf("\n");
outprf(usrnum);
return(1);
} //end

/*

//=RC
if (margc==1 && sameas(margv[0],spr("%crc",GLOBCHAR)) && haskey(optk21)){
prf("\nstill programming: Recent caller list\n");
outprf(usrnum);
return(1);
} //end

*/

//=CN
if (margc>0 && sameas(margv[0],spr("%cCN",GLOBCHAR)) && haskey(optk22)){

if(margc==1) { //user just typed =cn
  prfmsg(OPTF22); //"Format..."
  outprf(usrnum);
  return(1);
  }

inputmask(2); //get full amount even spaces...

if (strlen(masked)>19) {  //new chat name is too long
   prfmsg(L60111); //"You new chat name is too long..."
   outprf(usrnum);
   return(1);
   }

strcpy(ocnuarr[usrnum].chatname,masked);
clrprf();
prfmsg(L60112); //"Your new chat name is ..."
strclr(masked,0);
prf("\n");
outprf(usrnum);
return(1);
} //end

//=ED toggle editor type
if (margc==1 && sameas(margv[0], spr("%ced",GLOBCHAR)) && haskey(optk23)){
      if (usaptr->usrprf&PRFLIN) {//line editor currently on..
	 usaptr->usrprf&=~PRFLIN;
	 prfmsg(L60031);
	 outprf(usrnum);
	 }
      else { //line editor currently off
	 usaptr->usrprf|=PRFLIN;
	 prfmsg(L60032);
	 outprf(usrnum);
	 }
   return(1);
} //end

/*

//=/
if (margc==1 && sameas(margv[0],spr("%c/",GLOBCHAR)) && haskey(optk24)){
//!\\this function should user hdluido to see how many users are online that
//!\\match what the user typed, and automatically page if only 1 match...
prf("\nstill programming: page user\n");
outprf(usrnum);
return(1);
} //end


*/

//=CS CLEAR SCREEN
if (margc==1 && sameas(margv[0], spr("%ccs",GLOBCHAR)) && haskey(optk25)){
   prf("\x1b[2J");
   outprf(usrnum);
   return(-1);
} //end

//=CH -CHANGE- GLOBAL COMMAND CHARACTER
if (margc>0 && sameas(margv[0], spr("%cch",GLOBCHAR)) && haskey(optk26)){
	 if (margc >1) {
	    setmbk(ocnglomb);
	    if (!(margv[1][0]==CHATCHAR)) {
	       GLOBCHAR=margv[1][0];
	       prfmsg(L6CCCM);
	       }
	    else {
	       prfmsg(L60113);//"glob & chat can not be the same..."
	       }
	    outprf(usrnum);
	    return(1);
	    }
	 else {
	      prfmsg(L60074);
	      outprf(usrnum);
	      return(1);
	      }
   }//end =ch

/*

//=TR TRANSFER CREDITS TO ANOTHER USER
if (margc>0 && sameas(margv[0], spr("%ctr",GLOBCHAR)) && haskey(optk27)){
      if (margc <3) {
	 prfmsg(OPTF27); //"Format.."
	 outprf(usrnum);
	 return(1);
	 }

	 //TEST TO SEE IF USER TYPED IN # OF CREDS IN A VALID FORMAT
	 //AND DROP OUT IF NOT
	 if (!(alldgs(margv[1]))) {
	    prfmsg(L60055, margv[1]);
	    prfmsg(OPTF27);
	    outprf(usrnum);
	    return(1);
	    } //end if number is not all digits
	 //TEST TO SEE IF USER IS TYPING A STRING OF MORE THAT 8 CHARS
	 //AND DROP OUT IF SO
	 TEMPLONG=0;
	 TEMPLONG=strlen(margv[1]);
	 if (TEMPLONG >8) {
	     if(alldgs(margv[1])) {
	       prfmsg(L60057); //TOO MANY CREDITS!
	       outprf(usrnum);
	       return(1);
	       }
	     else
	       {
	       prfmsg(OPTF27); //"Format..."
	       outprf(usrnum);
	       return(1);
	       }
	     } //end if digit string is greater than 8
	 TEMPLONG=atol(margv[1]);
	 //TEST TO SEE IF USER HAS ENOUGH CREDS TO DO THIS
	 //AND DROP OUT IF NOT
	 if (TEMPLONG > usaptr->creds) {
	    prfmsg(L60058,spr("%ld",TEMPLONG));
	    outprf(usrnum);
	    return(1);
	    } //end if user dosen't have enough credits

	 //TEST TO SEE IF (TRANSFERRING TO) USER EXISTS
	 //AND DROP OUT IF NOT
	 inputmask(3);
	 TEMPCHAR=hdluidq(masked,OPTO27,0);
	 if (handeluidq) return(-1);

	 rdedcrd(TEMPLONG,1); //deduct from this user
	 gdedcrd(masked,-TEMPLONG,1,0); //post to other user
	 prfmsg(L60059, spr("%ld",TEMPLONG));

	 if (TEMPCHAR==3) {  //user to transfer to is online
	    //!\\ put message here that other user is online and has been
	    //!\\ notified...
	    }
	 outprf(usrnum);
	 return(1);
   } //end of transfer credits routine


*/

//=A ANSI TOGGLE
if (margc==1 && sameas(margv[0],spr("%CA",GLOBCHAR)) && haskey(optk28)){
      if (usaptr->ansifl&1) {  //if ansi flag is currently on
	 usaptr->ansifl=2;
	 btucmd(usrnum,"]");
	 prfmsg(L60050); //ANSI NOW OFF
	 outprf(usrnum);
	 return(1);
	 } //end if ansi flag is currently on
      else //ansi flag is not currently on
	 {
	 usaptr->ansifl=1;
	 btucmd(usrnum,"[");
	 prfmsg(L60051);  //ANSI NOW ON
	 outprf(usrnum);
	 return(1);
	 }// end ansi flag is not currently set
   } //end ansi toggle

//=SL SET SCREEN LENGTH
if (margc>0 && sameas(margv[0],spr("%cSL",GLOBCHAR)) && haskey(optk29)){
      if (margc >1)
	 {
	 if (atoi(margv[1]) < 256) {
	    usaptr->scnbrk=(atoi(margv[1]));
	    btuxnf(usrnum,0,-19,usaptr->scnbrk, "(N)onstop, (Q)uit or (C)ontinue");//,scnpaus[extptr->lingo]);
	    prfmsg(L60044); //"SL SET TO ..."
	    outprf(usrnum);
	    return(1);
	    } //end if user specified less than 256 lines
	 else //if number was 256 or greater
	    {
	    prfmsg(L60045); //LIMIT ON SCREEN LENGTH
	    outprf(usrnum);
	    return(1);
	    }//end if number was 256 or greater
	 }//end if margc >1
      else //user only typed =sl
	 {
	 prfmsg(OPTF29); //"Format..."
	 outprf(usrnum);
	 return(1);
	 }// end user only typed =sl
} //end

//=AI USER INFORMATION SCREEN FOR CURRENT USER
if (margc>0 && sameas(margv[0], spr("%cai",GLOBCHAR)) && haskey(optk30)){
     setmbk(ocnglomb);
     prfmsg(L6UI);
     outprf(usrnum);
     return(1);
} //end

/*

//=M
if (margc>0 && strlen(margv[0])>1 && strlen(margv[0])<4 \
   &&margv[0][0]==GLOBCHAR && toupper(margv[0][1])=='M' && haskey(optk32)){

if (strlen(margv[0])<=2) {
   prfmsg(OPTF32);//"Format..."
   outprf(usrnum);
   return(1);
   }

if (!(isdigit(margv[0][2]))) {
   prfmsg(OPTF32);//"Format..."
   outprf(usrnum);
   return(1);
   }

if (strlen(margv[0]) >3) { //too many characters
   prfmsg(OPTF32);//"Format..."
   outprf(usrnum);
   return(1);
   }

if (margc==1) {
   updusr(0);
   prf("\n"); //puts in return for a footer
   prfmsg(L6FUID);//message header (From user:)
   strclr(ocndisk.macros[margv[0][2]-48],0);
   prf("\n");
   sendtoall(1,0);
   clrprf();
   prfmsg(L60115,margv[0][2]);//"Macro %c sent to all.."
   return(1);
   }
//if made it to here, user is setting the macro..
 inputmask(2);
 updusr(margv[0][2]-38); //updates this macro from info in masked
 prfmsg(L60116,margv[0][2]);//"Macro %c now set to:..."
 strclr(masked,0);
 outprf(usrnum);
 clrprf();
 prf("\n");
 outprf(usrnum);
 return(1);
} //end

*/

//=XN NOTIFY OTHERS WHEN YOU LOGON AND OFF TOGGLE
if (margc==1 && sameas(margv[0],spr("%cXN",GLOBCHAR)) && haskey(optk33)){
if (OCNFLAGS&NOTOTH) {
   OCNFLAGS&=~NOTOTH;
   prfmsg(L60117);//"No logoff or logon's will be sent to others..."
   }
else {
   OCNFLAGS|=NOTOTH;
   prfmsg(L60118);//"Your logon and logoff messages will now be sent..."
   }
outprf(usrnum);
return(1);
} //end

/*

//=G Graphics display command
if (margc>0 && sameas(margv[0],spr("%cg",GLOBCHAR)) && haskey(optk34)){
FILE *truefile;

//  char buf[81];
  if (margc !=2)
    {
    prfmsg(L60033);
    outprf(usrnum);
    return(1);
    }
  if (strlen(margv[1])>25)
    {
    prfmsg(L60033);
    outprf(usrnum);
    return(1);
    }

  strcpy(TEMPSTRING,margv[1]);
  if ((truefile=fopen(TEMPSTRING,"r")) == NULL)
    {
    prfmsg(L60034,TEMPSTRING);
    outprf(usrnum);
    return(1);
    }
  //fseek(truefile, SEEK_SET, 0);
  prf("\n");
 // while (!feof(truefile))
 //   {
 //   fgets(buf, 80, truefile);
 //   prf("%s", buf);
 //   outprf(usrnum);
 //   }
  fclose(truefile);
  prf("Still working on this one\n");
  outprf(usrnum);
  return(1);
}

*/

/*

//=NT
if (margc==1 && sameas(margv[0],spr("%cnt",GLOBCHAR)) && haskey(optk35)){
prf("\nstill programming: Notes toggle\n");
outprf(usrnum);
return(1);
} //end

*/

/*

//=RT
if (margc==1 && sameas(margv[0],spr("%crt",GLOBCHAR)) && haskey(optk36)){
prf("\nstill programming: Reminders toggle\n");
outprf(usrnum);
return(1);
} //end

*/

/*

//=//
if (margc==1 && sameas(margv[0],spr("%c//",GLOBCHAR)) && haskey(optk37)){
prf("\nstill programming: Re-page user\n");
outprf(usrnum);
return(1);
} //end

*/

//note ... OPTION 38 IS PROGRAMMED IN THE HELP SCREENS (IT IS CHATTER HELP)



//=EM ECHO MESSAGES TO YOU TOGGLE
if (margc==1 && sameas(margv[0],spr("%cEM",GLOBCHAR)) && haskey(optk49)){
if (OCNFLAGS&ECHOMSG) {
   OCNFLAGS&=~ECHOMSG;
   prfmsg(L60119); //"What you type will not be sent back to you..."
   }
else {
   OCNFLAGS|=ECHOMSG;
   prfmsg(L60120); //"You will now see your messages..."
   }
outprf(usrnum);
return(1);
} //end


 ///// //   // //////  ////  /////
//      // // //      //  // //  // //
 ////    ///   /////  //  // /////             ...SYSOP COMMANDS...
    //   //        // //  // //                      (39-48)
    //   //        // //  // //     //
/////    //    /////   ////  //


//=K KICK OTHER USER OFFLINE SEQUENCE
if (margc>0 && sameas(margv[0],spr("%ck",GLOBCHAR)) && haskey(optk39)){
      if (margc <2) { //not enough parameters
	 prfmsg(OPTF39);
	 outprf(usrnum);
	 return(1);
	 }

	 inputmask(2);
	 //CHECK TO SEE IF NAME IS A USER ON-LINE
	 TEMPCHAR=hdluido(masked);

	 if (TEMPCHAR==0)
	    {
	    prfmsg(L60075); //USER NAME DOES NOT MATCH ANYBODY ON SYS...
	    outprf(usrnum);
	    return(1);
	    }

	 if (TEMPCHAR==2)
	    {
	    prfmsg(L60076); //MATCHES MORE THAN ONE USER ...
	    outprf(usrnum);
	    return(1);
	    }
	 //else there was only 1 match and it is set...
	 tv_what=2; //ocnothusn set by hdluido and is valid
	 setmbk(ocnglomb);
	 //now ask reason for kicking off user...
	 prf("\nReason for kicking OCNGUID offline:\n[65-char area...]");   //2 occur so far..
	 outprf(usrnum);
	 getusr(OPTO39);
	 return(-1);
   }//end =k

//=IN TOGGLE INVISIBILITY (FOR SYSOPS)
if (margc>0 && sameas(margv[0], spr("%cin",GLOBCHAR)) && haskey(optk40)){
      long startcreds,endcreds;

      if (usrptr->flags&INVISB) {
	 OCNFLAGS&=~DEDICRD;  //turn off deduct credits flag
	 usrptr->flags&=~INVISB;
	 usaptr->flags&=~GOINVB;
	 prfmsg(L60040);  //"invisibility deactivated"
	 outprf(usrnum);
	 return(1);
	 } //end if user is invisible
      else //if user is not invisible
	 {
	 if (inviscred) { //if package configured to charge creds from users
	  startcreds=usaptr->creds;
	  odedcrd(usrnum,1,0,1);
	  endcreds=usaptr->creds;
	  if (startcreds==endcreds) { //user is exempt from credit charges
	      OCNFLAGS|=DEDICRD;
	      usrptr->flags|=INVISB;
	      usaptr->flags|=GOINVB;
	      prf("\nYou are currently exempt from credit charges, however if you account is\n");
	      prf("switched to a class that is not exempt from credit charges you will be\n");
	      prf("charged %d credit%c per minute at that time.\n",inviscred,inviscred!=1?'s':'\0');
	      prfmsg(L60041); //invisibility activated
	      outprf(usrnum);
	      return(1);
	     }
	  else {//user is going to be charged credits
	    //give user his 1 credit back
	    odedcrd(usrnum,-1,0,1);
		  //"Being invisible costs so much per minute..."
	    prfmsg(L60123,inviscred,inviscred!=1?'s':'\0');
	    outprf(usrnum);
	    getusr(OPTO40);
	    return(-1);//Control goes to sttrou in module
	    }
	  }
	 else //sysop does not want credits deducted from invisible users
	  {
	  usrptr->flags|=INVISB;
	  usaptr->flags|=GOINVB;
	  prfmsg(L60041); //invisibility activated
	  outprf(usrnum);
	  return(1);
	  }
	 }//end if user is not invisible
} //end invisibility toggle

/*

//=PD Post days to users class
if (margc>0 && sameas(margv[0],spr("%cpd",GLOBCHAR)) && haskey(optk41)){
      if (margc <3) {
	 prf("\nFORMAT...\n");
	 outprf(usrnum);
	 return(1);
	 }

      if (!(TEMPLONG=atoi(margv[1]))) { //not a valid number
	  prfmsg(L60029);
	  return(1);
	  }

      inputmask(3);
      TEMPCHAR=hdluidq(masked,OPTO41,0);
      if (handeluidq) return(-1); //user is being snatched
      if (TEMPCHAR==3) //User online
	  uacoff(ocnothusn)->daystt+=(int)TEMPLONG;
      if (TEMPCHAR==4) { //User offline
	  accountdisk.daystt+=(int)TEMPLONG;
	  updaccount();
	  }
      prfmsg(L60030,spr("%ld",TEMPLONG));
      outprf(usrnum);
      return(1);
} //end post days

*/

//=SU
if (margc>0 && sameas(margv[0],spr("%cSU",GLOBCHAR)) && haskey(optk42)){

if (margc==1) {  //user just typed =su
  prfmsg(OPTF42); //"FORMAT..."
  outprf(usrnum);
  return(1);
  }

inputmask(2); //get full user id's name...

TEMPCHAR=hdluidq(masked,OPTO42,0);
if (handeluidq) return(-1);

if (TEMPCHAR==3) {  //user is currently online
   if (uacoff(ocnothusn)->flags&SUSPEN) {  //if user already suspended
      prfmsg(L60126);  //"%s is already suspended..."
      outprf(usrnum);
      return(1);
      }
   uacoff(ocnothusn)->flags|=SUSPEN;
   prfmsg(L60125,(toupper(uacoff(ocnothusn)->sex)=='M' ? "him" : "her"));
   }

if (TEMPCHAR==4) {  //User is currently offline
   if (accountdisk.flags&SUSPEN) {  //if user already suspended
      prfmsg(L60126);  //"%s is already suspended..."
      outprf(usrnum);
      return(1);
      }
   accountdisk.flags|=SUSPEN;
   updaccount();
   prfmsg(L60127);//"%s's account is now suspended..."
   }

outprf(usrnum);
return(1);
}//end suspend user


/*

//=PC POST USER CREDITS
if (margc>0 && sameas(margv[0],spr("%cpc",GLOBCHAR)) && haskey(optk43)){
      long before;
      if (margc <3) { //if not correct # of params...
	 prfmsg(OPTF43); //"Format..."
	 outprf(usrnum);
	 return(1);
	 }
	 inputmask(3);

	 TEMPLONG=0;
	 TEMPLONG=strlen(margv[1]);

	 if (TEMPLONG >8) {  //if more that eight digits in credit string
	    if(alldgs(margv[1])) {
	       prfmsg(L60060); //"That is too many credits"
	       outprf(usrnum);
	       return(1);
	       }
	    else //credit amount is not all digits
	       {
	       prfmsg(L60061, margv[1]); //"%s is not a valid amount"
	       prfmsg(OPTF43);  //"format..."
	       outprf(usrnum);
	       return(1);
	       }
	    }

	 TEMPLONG=0;
	 if (alldgs(margv[1]))
	    TEMPLONG=atol(margv[1]);
	 else {
	      prfmsg(L60063, margv[1],masked);//"can not post '%s' credits..."
	      prfmsg(OPTF43); //"format.."
	      outprf(usrnum);
	      return(1);
	      }

	 if (TEMPLONG) {  //if amount to x-fer >0
	    TEMPCHAR=hdluidq(masked,OPTO43,0);
	    if (handeluidq) return(-1);
	    if (TEMPCHAR==3){
	       before=uacoff(ocnothusn)->creds;
	       gdedcrd(masked,-TEMPLONG,0,1);
	       prfmsg(L60064,before);
	       }

	    if (TEMPCHAR==4) {
	       before=accountdisk.creds;
	       gdedcrd(masked,-TEMPLONG,0,1);
	       updaccount();
	       getaccount(accountdisk.userid,1);
	       prfmsg(L60064,before);
	       }
	    outprf(usrnum);
	    return(1);
	    }
	 else //credit amount is equal to 0...
	    {
	    prfmsg(L60066);
	    outprf(usrnum);
	    return(1);
	    }
}
//end post credits


*/

//=DA FLAG ACCOUNT FOR DELETION
if (margc>0 && sameas(margv[0],spr("%cda",GLOBCHAR)) && haskey(optk44)){

      if (margc <2) {
	 prfmsg(OPTF44); //"format..."
	 outprf(usrnum);
	 return(1);
	 }

      inputmask(2);

      TEMPCHAR=hdluidq(masked,OPTO44,0);
      if (handeluidq) return(-1);

      if (TEMPCHAR==3){  //if user is online
	 if (uacoff(ocnothusn)->flags&DELTAG) {
	    prf("\nOCNGUID's account is already flagged for deletion\n");
	    outprf(usrnum);
	    return(1);
	    }
	 uacoff(ocnothusn)->flags|=DELTAG;
	 }

      if (TEMPCHAR==4) { //User is currently offline
	 if (accountdisk.flags&DELTAG) {
	    prf("\nOCNGUID's account is already flagged for deletion\n");
	    outprf(usrnum);
	    return(1);
	    }
	 accountdisk.flags|=DELTAG;
	 updaccount();
	 }

      prfmsg(L60038,uidxrf.userid);
      outprf(usrnum);
      return(1);
} //end delete account

/*

//=SWITCH
if (margc>0 && sameas(margv[0],spr("%cSWITCH",GLOBCHAR)) && haskey(optk45)){

if (margc<3) {  //wrong # of parameters
  prfmsg(OPTF45); //"Format.."
  outprf(usrnum);
  return(1);
  }

if (strlen(margv[1]) >KEYSIZ) { //class name too long!!
   prfmsg(L60129); //"That classname is too long!!"
   outprf(usrnum);
   return(1);
   }


inputmask(3); //get full user id's name...
strcpy(TEMPSTRING,strupr(margv[1]));
TEMPCHAR=hdluidq(masked,OPTO45,0);
if (handeluidq) return(-1);

if (TEMPCHAR==3) {  //user is currently online
   strcpy(uacoff(ocnothusn)->curcls,TEMPSTRING);
   strcpy(uacoff(ocnothusn)->prmcls,TEMPSTRING);
	 //"%s class is now..."
   prfmsg(L60130);
   }

if (TEMPCHAR==4) {  //User is currently offline
   strcpy(accountdisk.curcls,TEMPSTRING);
   strcpy(accountdisk.prmcls,TEMPSTRING);
   updaccount();
	 //"%s class is now..."
   prfmsg(L60130);
   }

outprf(usrnum);
return(1);
} //end switch users class...

*/

/*

//=DC DEDUCT CREDITS FROM USER
if (margc>0 && sameas(margv[0],spr("%cDC",GLOBCHAR)) && haskey(optk46)){
      long before=0;
      if (margc <3) {
	 prfmsg(OPTF46); //"Format..."
	 outprf(usrnum);
	 return(1);
	 }

	 TEMPLONG=0;
	 TEMPLONG=strlen(margv[1]);
	 if (TEMPLONG >8) {
	    if(alldgs(margv[1])) {
	       prfmsg(L60067); //TOO MANY CREDITS!
	       outprf(usrnum);
	       return(1);
	       }
	    else
	       {
	       prfmsg(L60068, margv[1],masked);
	       prfmsg(OPTF46);  //"Format..."
	       outprf(usrnum);
	       return(1);
	       }
	    }

	 TEMPLONG=-2;

	 if (alldgs(margv[1]))
	    TEMPLONG=atol(margv[1]);
	 else { //the input is not all digits check for keywords..
	    if (sameas(margv[1],"all"))
	       TEMPLONG=-1L;
	    }

	 if (TEMPLONG==0) {
	    prfmsg(L60073); //DELETING 0 CREDITS HAS NO EFFECT...
	    outprf(usrnum);
	    return(1);
	    }

	 if (TEMPLONG==-2) {
	    prf("\nCommand not recognized...\n");
	    outprf(usrnum);
	    return(1);
	    }

	 inputmask(3);
	 TEMPCHAR=hdluidq(masked,OPTO46,0);
	 if (handeluidq) return(-1);

	 if (TEMPCHAR==3) {//User is currently online
	    if (TEMPLONG==-1)
	       TEMPLONG=uacoff(ocnothusn)->creds;
	    before=uacoff(ocnothusn)->creds;
	    gdedcrd(masked,TEMPLONG,0,1);
	    prfmsg(L60064,spr("%ld",before));
	    }

	 if (TEMPCHAR==4) {//User is currently offline
	    if (TEMPLONG==-1)
	       TEMPLONG=accountdisk.creds;
	    before=accountdisk.creds;
	    gdedcrd(masked,TEMPLONG,0,1);
	    prfmsg(L60064,spr("%ld",before));
	    }

	 outprf(usrnum);
	 return(1);
} //end deduct credits from user

*/

//=IK
if (margc>0 && sameas(margv[0],spr("%cik",GLOBCHAR)) && haskey(optk47)){

if (margc<3) {  //user just typed =ik
  prfmsg(OPTF47); //"Format.."
  outprf(usrnum);
  return(1);
  }

inputmask(3); //get full user id's name...
strcpy(TEMPSTRING,strupr(margv[1]));
TEMPCHAR=hdluidq(masked,OPTO47,0);
if (handeluidq) return(-1);
if (!(uhskey(masked,TEMPSTRING))) {
    givkey(masked,TEMPSTRING);
	    //"You have given the %s key to %s..."
    prfmsg(L60132,TEMPSTRING);
    }
else prfmsg(L60133,TEMPSTRING); //"user already has that key

outprf(usrnum);
return(1);
} //end issue key to user routine

//=S! un-suspend user
if (margc>0 && sameas(margv[0],spr("%cS!",GLOBCHAR)) && haskey(optk57)){

if (margc==1) {  //user just typed =s!
  prfmsg(OPTF57);//"Format:..."
  outprf(usrnum);
  return(1);
  }

inputmask(2); //get full user id's name...

TEMPCHAR=hdluidq(masked,OPTO57,0);
if (handeluidq) return(-1);

if (TEMPCHAR==3) {  //user is currently online
   if (!(uacoff(ocnothusn)->flags&SUSPEN)) {  //if user not suspended
      prfmsg(L60136);//"User not suspended..?!"
      outprf(usrnum);
      return(1);
      }
   uacoff(ocnothusn)->flags&=~SUSPEN;
   prfmsg(L60135); //"%s no longer suspended..."
   }

if (TEMPCHAR==4) {  //user is currently offline
   if (!(accountdisk.flags&SUSPEN)) {  //if user not suspended
      prfmsg(L60136);//"User not suspended..?!"
      outprf(usrnum);
      return(1);
      }
   accountdisk.flags&=~SUSPEN;
   updaccount();
   prfmsg(L60135); //"%s no longer suspended..."
   }
outprf(usrnum);
return(1);
} //end un-suspend users account




//=DET GET DETAILED INFO ON A USER
if (margc>0 && sameas(margv[0],spr("%cdet",GLOBCHAR)) && haskey(optk59)){

if (margc==1) {  //user just typed =det
  prfmsg(OPTF59); //"Format.."
  outprf(usrnum);
  return(1);
  }

inputmask(2); //get full user id's name...

TEMPCHAR=hdluidq(masked,OPTO59,0);
if (handeluidq) return(-1);

if (TEMPCHAR==3) {  //user is currently online
   prfmsg(L60082); //Detailed info on a user screen
   prfmsg(L60138);//"Keys Associated with this users class:"
   dspkys(uacoff(ocnothusn)->curcls,1);
   }

if (TEMPCHAR==4) {  //user is currently offline
   prfmsg(L60082); //Detailed info on a user screen
   prfmsg(L60138);//"Keys Associated with this users class:"
   dspkys(accountdisk.curcls,1);
   }

prfmsg(L60139);//"Keys This user holds personally:"
dspkys(uidxrf.userid,0);
outprf(usrnum);
return(1);
} //end



//=RK
if (margc>0 && sameas(margv[0],spr("%cRK",GLOBCHAR)) && haskey(optk60)){

if (margc<3) {  //user just typed =Rk
  prfmsg(OPTF60); //"Format: ..."
  outprf(usrnum);
  return(1);
  }

inputmask(3); //get full user id's name...
strcpy(TEMPSTRING,strupr(margv[1]));
TEMPCHAR=hdluidq(masked,OPTO60,0);
if (handeluidq) return(-1);

if (uhskey(masked,TEMPSTRING)) {
    rmvkey(masked,TEMPSTRING);
    prfmsg(L60141,TEMPSTRING);//"You have removed the %s key..."
    outprf(usrnum);
    return(1);
    }
else
    {
    prfmsg(L60142,TEMPSTRING); //"%s does not have this key..."
    outprf(usrnum);
    return(1);
    }
} //end remove a key from user routine

 ////  //  //  ////  ////// ////// ///// /////
//  // //  // //  //   //     //   //    //  // //
//     ////// //////   //     //   ////  /////     ...CHATTER COMMANDS...
//  // //  // //  //   //     //   //    // //
//  // //  // //  //   //     //   //    // //  //
 ////  //  // //  //   //     //   ///// //  //


//` displays a list of what you currenly have your channels set at
if (margc==1 && sameas(margv[0], spr("%c",CHATCHAR)) && haskey(optk50)){
   prfmsg(L60023);
   for (TEMPCHAR=0 ; TEMPCHAR <13 ; TEMPCHAR++) {
     prfmsg(L60024,TEMPCHAR+65,                                    \
     (CHANNEL[TEMPCHAR]>0 ? spr("%d",CHANNEL[TEMPCHAR]) : "off"),  \
     TEMPCHAR+78,                                                  \
     (CHANNEL[TEMPCHAR+13]>0 ? spr("%d",CHANNEL[TEMPCHAR+13]) : "off"));
     }
   prfmsg(L60025);
   outprf(usrnum);
   return(1);
} //end display channels currently set


//`CH change chatter channel character
if (margc>0 && sameas(margv[0], spr("%cch",CHATCHAR))&& haskey(optk51)){

   if (margc==1)
      {
      prfmsg(L60020);
      outprf(usrnum);
      return(-1);
      }

   if (margc>2) {
      prf("\nFormat...\n");
      outprf(usrnum);
      }

   if (!(margv[1][0]==GLOBCHAR)) {
      CHATCHAR=margv[1][0];
      prfmsg(L60021);
      outprf(usrnum);
      return(1);
      }
   else
      {
      prfmsg(L60113);//"Glob & chat char can't be the same..."
      outprf(usrnum);
      return(1);
      }
} //end change chatter char

//`x lists who else is on this channel ..
if (margc==1 && margv[0][0]==CHATCHAR && isalpha(margv[0][1]) && haskey(optk52) \
    && strlen(margv[0])==2){
     char number1=0;
     char number2=1;

    if (!OCNFLAGS&CHATON) {  //User does not have chatters turned on
      prf("\nYou currenly have you chatters turned off\n");
      outprf(usrnum);
      return(1);
      }

     prfmsg(L60026,toupper(margv[0][1]),CHANNEL[toupper(margv[0][1])-65]);

     for (ocnothusn=0 ; ocnothusn < nterms ; ocnothusn++) {
       switch(user[ocnothusn].class) {
	   case VACANT:
		break;
	   case ONLINE:
		break;
	   case SUPIPG:
		break;
	  default:
		//this is where we have an actual user
		for (TEMPINT=0 ; TEMPINT <26 ; TEMPINT++) {
		    if (ocnuarr[ocnothusn].channel[TEMPINT]!=0 && ocnuarr[ocnothusn].channel[TEMPINT]==CHANNEL[toupper(margv[0][1])-65])
		       {
		       if (!(user[ocnothusn].flags&INVISB || ocnuarr[ocnothusn].flags&RECVINV)) {
			  if (ocnuarr[ocnothusn].flags&CHATON)
			      number1++;
			  }
		       }
		    }
		break;
		} //end switch
	  } //end for loop (cycling through all channels)

//---------------------------PART-B-----------------------------------------
     tv_what=2;
     for (ocnothusn=0 ; ocnothusn < nterms ; ocnothusn++) {
       switch(user[ocnothusn].class) {
	   case VACANT:
		break;
	   case ONLINE:
		break;
	   case SUPIPG:
		break;
	  default:
		//this is where we have an actual user
		for (TEMPINT=0 ; TEMPINT <26 ; TEMPINT++) {
		    if (ocnuarr[ocnothusn].channel[TEMPINT]!=0 && ocnuarr[ocnothusn].channel[TEMPINT]==CHANNEL[toupper(margv[0][1])-65])
		       {
		       if (!(user[ocnothusn].flags&INVISB || ocnuarr[ocnothusn].flags&RECVINV))
			  {
			  if (ocnuarr[ocnothusn].flags&CHATON) {
			     if (number2 <number1)
				 prfmsg(L60144); //"%s, "
			     else
				 prfmsg(L60145); //"%s"
			     number2++;
			     }
			  }
		       }
		    }
		break;
		} //end switch
	  } //end for loop (cycling through all channels)
   prf("\n");
   outprf(usrnum);
   return(1);
} //end chatter scan

//`x # Changes a chatter channel #
if (margc==2 && margv[0][0]==CHATCHAR && (strlen(margv[0])==2) \
	     && isalpha(margv[0][1]) && (alldgs(margv[1])||    \
		sameas(margv[1],"off"))&& haskey(optk53)){

    unsigned setto=0; //this is what the user wants to set his channel to
    char chan=0; //used to check if this user is already on this channel

    if (!OCNFLAGS&CHATON) {  //User does not have chatters turned on
      prf("\nYou currenly have you chatters turned off\n");
      outprf(usrnum);
      return(1);
      }

    //first handle "off"
    if (sameas(margv[1],"off") || atoi(margv[1])==0) {
	if(CHANNEL[toupper(margv[0][1])-65]!=0) {
	   sendtoall(3,CHANNEL[toupper(margv[0][1])-65]);
	   CHANNEL[toupper(margv[0][1])-65]=0;
	   clrprf();
		 //"Channel %c is now off..."
	   prfmsg(L60146,toupper(margv[0][1]));
	   }
	else
	  prfmsg(L60147);//"That channel is already OFF."
	outprf(usrnum);
	return(1);
	}
    //now handle changing to another number
    setto=atoi(margv[1]);

  chan=checkchatter(usrnum,setto);//make sure not already on this chan

  if (!chan) {
     if (setto<=demonames.lastpublic) {//user wants to change to a public
	//Notify users that this user is leaving channel such and such
	sendtoall(3,CHANNEL[toupper(margv[0][1])-65]);
	//set new channel
	CHANNEL[toupper(margv[0][1])-65]=setto;
	//now notify all others that this user has just moved to this channel
	sendtoall(4,CHANNEL[toupper(margv[0][1])-65]);
	clrprf();
	prfmsg(L60028,toupper(margv[0][1]),setto);
	chan=1;
	//public
	}
     if (setto>demonames.lastpublic && setto<=demonames.lastprivate \
	&& haskey(chatpr)) { //user wants to change to a private channel
	//Notify users that this user is leaving channel such and such
	sendtoall(3,CHANNEL[toupper(margv[0][1])-65]);
	//set new channel
	CHANNEL[toupper(margv[0][1])-65]=setto;
	//now notify all others that this user has just moved to this channel
	sendtoall(4,CHANNEL[toupper(margv[0][1])-65]);
	clrprf();
	prfmsg(L60028,toupper(margv[0][1]),setto);
	//private
	chan=1;
	}
     if (setto>demonames.lastprivate && setto <32768L && haskey(chatsy)) {
	//Notify users that this user is leaving channel such and such
	sendtoall(3,CHANNEL[toupper(margv[0][1])-65]);
	//set new channel
	CHANNEL[toupper(margv[0][1])-65]=setto;
	//now notify all others that this user has just moved to this channel
	sendtoall(4,CHANNEL[toupper(margv[0][1])-65]);
	clrprf();
	prfmsg(L60028,toupper(margv[0][1]),setto);
	chan=1;
	}
     if (!chan) {
	setto=demonames.lastpublic;
	if (haskey(chatpr)) setto=demonames.lastprivate;
	if (haskey(chatsy)) setto=32767;
	sendtoall(3,CHANNEL[toupper(margv[0][1])-65]);
	//set new channel
	CHANNEL[toupper(margv[0][1])-65]=setto;
	//now notify all others that this user has just moved to this channel
	sendtoall(4,CHANNEL[toupper(margv[0][1])-65]);
	clrprf();
	prfmsg(L60028,toupper(margv[0][1]),setto);
	}
     }
  else //already on that channel
     prfmsg(L60148,chan,setto);//"Channel already set to this..."
  outprf(usrnum);
  return(1);
} //end change chatter channel

//`scan
if (margc==1 && sameas(margv[0],spr("%cSCAN",CHATCHAR)) && haskey(optk54)){


 if (!OCNFLAGS&CHATON) {  //User does not have chatters turned on
      prf("\nYou currenly have you chatters turned off\n");
      outprf(usrnum);
      return(1);
      }

  //Print out scan message header:
  prfmsg(L60149); //"Users online and there settings..."
  if ((haskey(scanpu)&&haskey(scanpr))||(haskey(scanpu)&&haskey(scansy)))
     prfmsg(L60150); //"Public channels..."
  if ((haskey(scanpr)&&haskey(scanpu))||(haskey(scanpr)&&haskey(scansy)))
     prfmsg(L60151); //"Private channels.."
  if ((haskey(scansy)&&haskey(scanpu))||(haskey(scansy)&&haskey(scanpr)))
     prfmsg(L60152); //"Sysop channels.."

  tv_what=2;
  for (ocnothusn=0 ; ocnothusn < nterms ; ocnothusn++) {
       switch(user[ocnothusn].class) {
	   case VACANT:
		break;
	   case ONLINE:
		break;
	   case SUPIPG:
		break;
	  default:
	       if (user[ocnothusn].flags&INVISB) break; //if invisible dont list
	       //LOOK THROUGH THIS USERS CHATTER CHANNELS AND DISPLAY
	       prfmsg(L60153); //print users id

	       if (ocnuarr[ocnothusn].flags&CHATON) {
		  for (TEMPCHAR=0;TEMPCHAR<26;TEMPCHAR++) {
		      if (ocnuarr[ocnothusn].channel[TEMPCHAR]!=0 && !(ocnuarr[ocnothusn].flags&RECVINV)) {

			 //show if public channel
			 if (ocnuarr[ocnothusn].channel[TEMPCHAR]<=demonames.lastpublic && haskey(scanpu))
			     prfmsg(L60154,ocnuarr[ocnothusn].channel[TEMPCHAR]);

			 //show if private channel
			 if (ocnuarr[ocnothusn].channel[TEMPCHAR]<=demonames.lastprivate && ocnuarr[ocnothusn].channel[TEMPCHAR]>demonames.lastpublic && haskey(scanpr))
			     prfmsg(L60155,ocnuarr[ocnothusn].channel[TEMPCHAR]);

			 //show if sysop channel
			 if (ocnuarr[ocnothusn].channel[TEMPCHAR]>demonames.lastprivate && haskey(scansy))
			     prfmsg(L60156,ocnuarr[ocnothusn].channel[TEMPCHAR]);

			 } //END IF CHANNEL IS GREATER THAN 0
		      }//END LOOKING THROUGH USERS CHATTERS
		  }
	       else { //chatters for this user are not on..
		 prf(" CHATTERS OFF");
		 }

	       break;
	       } //end switch
	  } //end for loop (cycling through all channels)
prf("\n");
outprf(usrnum);
return(1);
} //end


//`spu (set last public channel)
if (margc>0 && sameas(margv[0],spr("%cspu",CHATCHAR)) && haskey(optk55)) {
    unsigned long setto;  //this is what the user wants to set the deal to

    if (margc==1) { //user typed `spr
     prfmsg(OPTF55); //"fORMAT..."
     outprf(usrnum);
     return(1);
     }


    if (alldgs(margv[1])) {
       setto=atol(margv[1]);
       if (setto==0 || setto>=demonames.lastprivate) {
		 //"With the current settings your range for this ..."
	   prfmsg(L60158,demonames.lastprivate-1);
	   outprf(usrnum);
	   return(1);
	   }
       //ok to set new value
       demonames.lastpublic=atoi(margv[1]);
	     //"Ok now the last public channel is ..."
       prfmsg(L60159, demonames.lastpublic);
       outprf(usrnum);
       return(1);
       }
    else { //user typed something other than a number
       prfmsg(L60160);//"The New value must be a number"
       outprf(usrnum);
       return(1);
       }
} //end

//`spr (set last private channel)
if (margc>0 && sameas(margv[0],spr("%cspr",CHATCHAR)) && haskey(optk56)){
   unsigned long setto;  //this is what the user wants to set the deal to

   if (margc==1) { //user typed `spr
      prfmsg(OPTF56); //"Format..."
      outprf(usrnum);
      return(1);
      }

    if (alldgs(margv[1])) {
       setto=atol(margv[1]);

       if (setto<=demonames.lastpublic || setto>=32767L) {
		 //"With the current settings your range for this command.."
	  prfmsg(L60162,demonames.lastpublic+1);
	  outprf(usrnum);
	  return(1);
	  }
       //ok to set new value
       demonames.lastprivate=atoi(margv[1]);
       prfmsg(L60163,demonames.lastprivate);//"THE last private ch is..."
       outprf(usrnum);
       return(1);
       }
   else { //user typed something other than a number
       prfmsg(L60160);//"The New value must be a number"
       outprf(usrnum);
       return(1);
       }
} //end


//`x Message... Sends a message over the chatter channel
if (margc>1 && margv[0][0]==CHATCHAR && (strlen(margv[0])==2)  \
	     && isalpha(margv[0][1])  && !(margc==2 && alldgs(margv[1])) \
	     && haskey(sendch)) {
	  int freq;
	  char msgsent=0;

	  if (!OCNFLAGS&CHATON) {  //User does not have chatters turned on
	      prf("\nYou currenly have you chatters turned off\n");
	      outprf(usrnum);
	      return(1);
	      }

	  //set channel to the channel # that is to be transmitted on
	  freq=CHANNEL[toupper(margv[0][1])-65];
	  inputmask(2);
	  if (freq)
	   msgsent=sendtoall(2,CHANNEL[toupper(margv[0][1])-65]);
	  else
	    {
	    clrprf();
	    prfmsg(L60165,toupper(margv[0][1]));//"Channel currently off.."
	    outprf(usrnum);
	    return(1);
	    }

	 if(msgsent) {
	   clrprf();
	   prfmsg(L60166);//"*** Chatter Message Sent ***"
	   outprf(usrnum);
	   return(1);
	   }
	 else {
	   clrprf();
	   prfmsg(L60167);//"*** Nobody Else There! ***"
	   outprf(usrnum);
	   return(1);
	   }
} //end send message on chatter channel

//`ic
if (margc==1 && sameas(margv[0],spr("%cic",CHATCHAR)) && haskey(optk58)){
if (OCNFLAGS&RECVINV) {
   OCNFLAGS&=~RECVINV;
   prfmsg(L60168);//"Ok you are not invisible in chatter channels now."
   }
else {
   OCNFLAGS|=RECVINV;
   prfmsg(L60169);//"you are now invisible in the chatters."
   }
outprf(usrnum);
return(1);
} //end

//`mon
if (margc==1 && sameas(margv[0],spr("%cmon",CHATCHAR)) && haskey(optk61)){
if(OCNFLAGS&SYSMCHA) {
  OCNFLAGS&=~SYSMCHA;
  prf("\nYou are no longer in \"Monitor all chatters\" mode.\n");
  outprf(usrnum);
  return(1);
  }
else {
  OCNFLAGS|=SYSMCHA;
  prf("\nYou will now receive all messages that are sent in the chatters\n");
  outprf(usrnum);
  return(1);
  }
} //end

/*

//`OFF  PUT ALL CHATTER CHANNELS OFF
if (margc==1 && sameas(margv[0],spr("%coff",CHATCHAR)) && haskey(optk62)){
OCNFLAGS&=~CHATON;
prf("\nOCNGUID Just turned all %s chatters off\n",usaptr->sex=='M'?"his":"her");
sendtoall(8,0);
clrprf();
prf("\nYour chatter channels are now off...\n");
outprf(usrnum);
return(1);
} //end

*/

/*

//`ON PUT ALL CHATTER CHANNELS ON
if (margc==1 && sameas(margv[0],spr("%con",CHATCHAR)) && haskey(optk63)){
OCNFLAGS|=CHATON;
prf("\nOCNGUID Just turned all %s chatters on\n",usaptr->sex=='M'?"his":"her");
sendtoall(8,0);
clrprf();
prf("\nYour chatter channels are now on...\n");
outprf(usrnum);
return(1);
} //end

*/

//if program makes it to here, then there were no commands recognized..
rstmbk();
return(0);
}//end of global command routine

/* ocnguol shows a list of users online...the list the user sees depends
   on what value is passed to this function, as defined below */
void ocnguol(char type)
 {
 //type=0 if normal user (#) (always lists level 1)
 //type=1 if sysop user  (#) (always lists sysop list)
 //type=2 if normal or sysop user (=#)

   for (ocnothusn=0 ; ocnothusn < nterms ; ocnothusn++) {
       tv_what=2;//default deal for text vars
       switch(user[ocnothusn].class) {
	   case VACANT:
		break;
	   case SUPIPG:
		tv_what=4;
	   case ONLINE:
		tv_what=5;
	  default:
		switch (type) {
		   case 0: //(#) normal level 1 only
		     if (user[ocnothusn].flags&INVISB)
		     break;
		     prfmsg(L6UOLS);
		     break;
		   case 1: //sysop user list
		     prfmsg(L6UOL2S);
		     break;
		   case 2: //anybody =#
		     if (user[ocnothusn].flags&INVISB)
		     break;
		     switch (UOLLIST) {
			    case 1:
			       prfmsg(L6UOLS);
			       break;
			    case 2:
			       prfmsg(L6UOLS2);
			       break;
			    case 3:
			       prfmsg(L6UOLS3);
			       break;
			    }
		     break;
		   }  //end switch type
		} //end main switch
	  } //end for loop
   }


//  Text Variable system
//
//    Values that tv_what is set to and what they mean:
//
//           2. ocnothusn info   (online only)
//           3. offline users info
//           4. New user sign up
//           5. User logging on
//           default: usrnum info only (online only)
//
//

char * tv_ocngcc(void)          /* returns what the global character is */
 {
 switch (tv_what) {
   case 2: return(spr("%c",ocnuarr[ocnothusn].ocngcc));
   case 3: return(spr("%c",ocndisk.userd.ocngcc));
   case 4: return(spr("="));
   case 5: return(spr("?"));
   default: return(spr("%c",GLOBCHAR));
   }
 }

char * tv_ocnccc(void)          /* returns what the chatter character is */
 {
 switch (tv_what) {
   case 2: return(spr("%c",ocnuarr[ocnothusn].chatchar));
   case 3: return(spr("%c",ocndisk.userd.chatchar));
   case 4: return(spr("`"));
   case 5: return(spr("?"));
   default: return(spr("%c",CHATCHAR));
   }
 }

char * tv_ocnguid(void)         /* user ID */
 {
 switch (tv_what) {
   case 2: return(uacoff(ocnothusn)->userid);
   case 3: return(accountdisk.userid);
   case 4: return("New sign up");
   case 5: return("Logging on");
   default: return(usaptr->userid);
   }
 }

char * tv_ocngloc(void)         /* users location on bbs */
 {
 switch (tv_what) {
   case 2: return(module[user[ocnothusn].state]->descrp);
   case 3: return("Not online");
   case 4: return(module[user[ocnothusn].state]->descrp);
   case 5: return(module[user[ocnothusn].state]->descrp);
   default: return(module[usrptr->state]->descrp);
   }
 }

char * tv_ocngch(void)          /* users channel # */
 {
 switch (tv_what) {
   case 2: return(strupr(spr("%x",channel[ocnothusn])));
   case 3: return("??");
   case 4: return(strupr(spr("%x",channel[ocnothusn])));
   case 5: return(strupr(spr("%x",channel[ocnothusn])));
   default: return(strupr(spr("%x",channel[usrnum])));
   }
 }

char * tv_ocngcla(void)         /* users current class */
 {
 switch (tv_what) {
   case 2: return(uacoff(ocnothusn)->curcls);
   case 3: return(accountdisk.curcls);
   case 4: return("*UNKNOWN*");
   case 5: return("*UNKNOWN*");
   default: return(usaptr->curcls);
   }
 }

char * tv_ocngmin(void)         /*  users minutes online this session */
 {
 switch (tv_what) {
   case 2: return(spr("%d",user[ocnothusn].minut4/4));
   case 3: return("0");
   case 4: return("0");
   case 5: return("0");
   default: return(spr("%d",usrptr->minut4/4));
   }
 }

char * tv_ocngbau(void)         /*  users baud rate */
 {
 switch (tv_what) {
   case 2: itoa(user[ocnothusn].baud,TEMPSTRING,10);
   case 3: strcpy(TEMPSTRING,"0");
   case 4: itoa(user[ocnothusn].baud,TEMPSTRING,10);
   case 5: itoa(user[ocnothusn].baud,TEMPSTRING,10);
   default: itoa(usrptr->baud,TEMPSTRING,10);
   }
 return(TEMPSTRING);
 }

char * tv_ocngage(void)         /*  users age */
 {
 switch (tv_what) {
   case 2: return(spr("%d",uacoff(ocnothusn)->age));
   case 3: return(spr("%d",accountdisk.age));
   case 4: return("??");
   case 5: return("??");
   default: return(spr("%d",usaptr->age));
   }
 }

char * tv_ocngsex(void)         /*  users sex */
 {
 switch (tv_what) {
   case 2: return(uacoff(ocnothusn)->sex=='M'?"Male":"Female");
   case 3: return(accountdisk.sex=='M'?"Male":"Female");
   case 4: return("?");
   case 5: return("?");
   default: return(usaptr->sex=='M'?"Male":"Female");
   }
 }

char * tv_ocngtt(void)         /* total time online today */
{
 long mins;
 switch (tv_what) {
   case 2:
     mins=(uacoff(ocnothusn)->timtdy+30L)/60L;
     return(spr("%ld",mins));
   case 3:
     mins=(accountdisk.timtdy+30L)/60L;
     return(spr("%ld",mins));
   case 4: return("0");
   case 5: return("??");
   default:
      mins=(usaptr->timtdy+30L)/60L;
      return(spr("%ld",mins));
   }
}


char * tv_ocngfla(void)            /* users flags */
 {  //invisible, busy, spare space for upgrades...
 switch (tv_what) {
   case 2:
     return(spr("%c%c---",(user[ocnothusn].flags&INVISB ? 'I' : '-'),   \
			  (user[ocnothusn].flags&NOINJO ? 'B' : '-')));
   case 3: return("-----");
   case 4: return("-B---");
   case 5: return("-B---");
   default:
	return(spr("%c%c---",(usrptr->flags&INVISB ? 'I' : '-'),   \
			     (usrptr->flags&NOINJO ? 'B' : '-')));
   }
 }

char * tv_ocngcred(void)       /* users credits (current)*/
 {
 switch (tv_what) {
   case 2: return(spr("%ld",uacoff(ocnothusn)->creds));
   case 3: return(spr("%ld",accountdisk.creds));
   case 4: return("???");
   case 5: return("???");
   default: return(spr("%ld",usaptr->creds));
   }
 }

char * tv_ocnghrs(void)        /* users hours left in credits */
 {
 switch (tv_what) {
   case 2:
     return(spr("%d",(uacoff(ocnothusn)->creds/user[ocnothusn].crdrat)/60));
   case 3: return(spr("%d",accountdisk.creds/3600));
   case 4: return("??");
   case 5: return("??");
   default: return(spr("%d",(usaptr->creds/usrptr->crdrat)/60));
   }
 }

char * tv_ocngmins(void)       /* users minutes left from tv_ocnghrs */
 {
 switch (tv_what) {
   case 1: TEMPLONG=(usaptr->creds / usrptr->crdrat);
     break;
   case 2: TEMPLONG=(uacoff(ocnothusn)->creds/user[ocnothusn].crdrat);
     break;
   case 3: TEMPLONG=accountdisk.creds/60;
     break;
   case 4: return("??");
   case 5: return("??");
   }
 while ((TEMPLONG-=60) > 60 ) {}
 if(TEMPLONG < 0 ) TEMPLONG+=60;
 return(spr("%ld",TEMPLONG));
 }

char * tv_ocnchatn(void)      /* Users chat-name (no-color) */
{
 switch (tv_what) {
   case 1: strclr(ocnuarr[usrnum].chatname,1);
     break;
   case 2: strclr(ocnuarr[ocnothusn].chatname,1);
     break;
   case 3: strclr(ocndisk.userd.chatname,1);
     break;
   case 4: return("\x1b[1;35mNone set");
   case 5: return("Unknown");
   }
 return(nocolor);
}

char * tv_ocnglogn(void)      /* Users log-on message (no-color) */
{
 switch (tv_what) {
  case 1:
     getaccount(usaptr->userid,1);
     strclr(ocndisk.logonmsg,1);
     break;
  case 2: strclr(ocndisk.logonmsg,1);
     break;
  case 3: strclr(ocndisk.logonmsg,1);
     break;
  case 4: return("\x1b[1;35mNone set");
  case 5: return("Unknown");
  }
 return(nocolor);
 }

char * tv_ocnglogf(void)      /* Users log-off message (no-color) */
{
 switch (tv_what) {
  case 1:
     getaccount(usaptr->userid,1);
     strclr(ocndisk.logoffmsg,1);
     break;
  case 2: strclr(ocndisk.logoffmsg,1);
     break;
  case 3: strclr(ocndisk.logoffmsg,1);
     break;
  case 4: return("\x1b[1;35mNone set");
  case 5: return("Unknown");
  }
 return(nocolor);
 }

char * tv_ocnguolc(void)     /* Alternate Users online character */
 {
 return(spr("%c",optuolch));
 }

char * tv_ocngdat(void)     /* Todays date 06/12/72  */
 {
 return(spr("%s",ncdate(today())));
 }

char * tv_ocntuser(void)   /* Total # users online */
{
int loop;
int count=0;
   for (loop=0 ; loop < nterms ; loop++) {
       switch(user[loop].class) {
	   case VACANT:
		break;
	  default:
		if (user[loop].flags&INVISB)
		   break;
		count++;
		} //end main switch
	  } //end for loop
return(spr("%d",count));
}

char * tv_ocngsdat(void)    /* users sign up date */
{
switch (tv_what) {
   case 2: return(ncdate(uacoff(ocnothusn)->credat));
   case 3: return(ncdate(accountdisk.credat));
   case 4: return(ncdate(today()));
   case 5: return("??/??/??");
   default: return(ncdate(usaptr->credat));
   }
}

char * tv_ocnglast(void)    /* users last use of account date */
{
switch (tv_what) {
   case 2: return(ncdate(uacoff(ocnothusn)->usedat));
   case 3: return(ncdate(accountdisk.usedat));
   case 4: return(ncdate(today()));
   case 5: return("??/??/??");
   default: return(ncdate(usaptr->usedat));
   }
}

char * tv_ocngpw(void)     /* password */
{
switch (tv_what) {
  case 2: return(showpass ? uacoff(ocnothusn)->psword : "<Not Shown>");
  case 3: return(showpass ? accountdisk.psword : "<Not Shown>");
  case 4: return(showpass ? "None yet" : "<Not Shown>");
  case 5: return(showpass ? "*unknown*" : "<Not Shown>");
  default: return(showpass ? usaptr->psword : "<Not Shown>");
  }
}

char * tv_ocnrname(void)    /* Users real name */
{
switch (tv_what) {
  case 2: return(uacoff(ocnothusn)->usrnam);
  case 3: return(accountdisk.usrnam);
  case 4: return("none yet");
  case 5: return("*unknown*");
  default: return(usaptr->usrnam);
  }
}

char * tv_ocngphon(void)    /* users Phone number */
{
switch (tv_what) {
  case 2: return(uacoff(ocnothusn)->usrpho);
  case 3: return(accountdisk.usrpho);
  case 4: return("???-????");
  case 5: return("???-????");
  default: return(usaptr->usrpho);
  }
}


char * tv_ocngsyst(void)     /* Users system type */
{
switch (tv_what) {
  case 2: return(systype(1,ocnothusn));
  case 3: return(systype(0,0));
  case 4: return("*UNKNOWN*");
  case 5: return("*UNKNOWN*");
  default: return(systype(1,usrnum));
  }
}

char * tv_ocngedit(void)     /* Users editor type */
{
switch (tv_what) {
  case 2: return(uacoff(ocnothusn)->usrprf==1?"Line":"FSE");
  case 3: return(accountdisk.usrprf==1?"Line":"FSE");
  case 4: return("???");
  case 5: return("???");
  default: return(usaptr->usrprf==1?"Line":"FSE");
  }
}

char * tv_ocngansi(void)    /* Ansi settings */
{
switch (tv_what) {
  case 2: return(ansiset[uacoff(ocnothusn)->ansifl]);
  case 3: return(ansiset[accountdisk.ansifl]);
  case 4: return("???");
  case 5: return("???");
  default: return(ansiset[usaptr->ansifl]);
  }
}

char * tv_ocngbday(void)   /* Users birthday */
{
switch (tv_what) {
  case 2: return(birthday(uacoff(ocnothusn)->birthd));
  case 3: return(birthday(accountdisk.birthd));
  case 4: return("??/??/??");
  case 5: return("??/??/??");
  default: return(birthday(usaptr->birthd));
  }
}

char * tv_ocnadd1(void)   /* Users address line 1 */
{
switch (tv_what) {
  case 2: return(uacoff(ocnothusn)->usrad1);
  case 3: return(accountdisk.usrad1);
  case 4: return("???");
  case 5: return("???");
  default: return(usaptr->usrad1);
  }
}

char * tv_ocnadd2(void)   /* Users address line 2 */
{
switch (tv_what) {
  case 2: return(uacoff(ocnothusn)->usrad2);
  case 3: return(accountdisk.usrad2);
  case 4: return("???");
  case 5: return("???");
  default: return(usaptr->usrad2);
  }
}

char * tv_ocnadd3(void)   /* Users address line 3 */
{
switch (tv_what) {
  case 2: return(uacoff(ocnothusn)->usrad3);
  case 3: return(accountdisk.usrad3);
  case 4: return("???");
  case 5: return("???");
  default: return(usaptr->usrad3);
  }
}

char * tv_ocnadd4(void)   /* Users address line 1 */
{
switch (tv_what) {
  case 2: return(uacoff(ocnothusn)->usrad4);
  case 3: return(accountdisk.usrad4);
  case 4: return("???");
  case 5: return("???");
  default: return(usaptr->usrad4);
  }
}

char * tv_ocnswid(void)      /* Users screen width */
{
switch (tv_what) {
  case 2: return(spr("%d",uacoff(ocnothusn)->scnwid));
  case 3: return(spr("%d",accountdisk.scnwid));
  case 4: return("??");
  case 5: return("??");
  default: return(spr("%d",usaptr->scnwid));
  }
}

char * tv_ocnslen(void)      /* Users screen length */
{
switch (tv_what) {
  case 2: return(spr("%d",uacoff(ocnothusn)->scnbrk));
  case 3: return(spr("%d",accountdisk.scnbrk));
  case 4: return("??");
  case 5: return("??");
  default: return(spr("%d",usaptr->scnbrk));
  }
}

char * tv_ocngdcl(void)      /* Days left in current class */
{
switch (tv_what) {
  case 2: return(spr("%d",uacoff(ocnothusn)->daystt));
  case 3: return(spr("%d",accountdisk.daystt));
  case 4: return("??");
  case 5: return("??");
  default: return(spr("%d",usaptr->daystt));
  }
}

char * tv_ocncpaid(void)       /* users credits (total paid)*/
 {
 switch (tv_what) {
   case 2: return(spr("%ld",uacoff(ocnothusn)->totpaid));
   case 3: return(spr("%ld",accountdisk.totpaid));
   case 4: return("???");
   case 5: return("???");
   default: return(spr("%ld",usaptr->totpaid));
   }
 }

char * tv_ocncfree(void)       /* users credits (total free)*/
 {
 switch (tv_what) {
   case 2: return(spr("%ld",uacoff(ocnothusn)->totcreds-uacoff(ocnothusn)->totpaid));
   case 3: return(spr("%ld",accountdisk.totcreds-accountdisk.totpaid));
   case 4: return("???");
   case 5: return("???");
   default: return(spr("%ld",usaptr->totcreds-usaptr->totpaid));
   }
 }

char * tv_ocnfinvs(void)       /* Invisible at logon ? */
{
switch (tv_what) {
  case 2: return(uacoff(ocnothusn)->flags&GOINVB ? "Yes" : "No");
  case 3: return(accountdisk.flags&GOINVB ? "Yes" : "No");
  case 4: return("???");
  case 5: return("???");
  default: return(usaptr->flags&GOINVB ? "Yes" : "No");
  }
}

char * tv_ocnfprot(void)       /* This account protected ? */
{
switch (tv_what) {
  case 2: return(uacoff(ocnothusn)->flags&UNDAXS ? "Yes" : "No");
  case 3: return(accountdisk.flags&UNDAXS ? "Yes" : "No");
  case 4: return("???");
  case 5: return("???");
  default: return(usaptr->flags&UNDAXS ? "Yes" : "No");
  }
}

char * tv_ocnfsusp(void)       /* This account suspended ? */
{
switch (tv_what) {
  case 2: return(uacoff(ocnothusn)->flags&SUSPEN ? "Yes" : "No");
  case 3: return(accountdisk.flags&SUSPEN ? "Yes" : "No");
  case 4: return("???");
  case 5: return("???");
  default: return(usaptr->flags&SUSPEN ? "Yes" : "No");
  }
}

char * tv_ocnfdel(void)       /* This account flagged for deletion ? */
{
switch (tv_what) {
  case 2: return(uacoff(ocnothusn)->flags&DELTAG ? "Yes" : "No");
  case 3: return(accountdisk.flags&DELTAG ? "Yes" : "No");
  case 4: return("???");
  case 5: return("???");
  default: return(usaptr->flags&DELTAG ? "Yes" : "No");
  }
}

char * tv_ocnfmast(void)       /* This account has master key ? */
{
switch (tv_what) {
  case 2: return(uacoff(ocnothusn)->flags&HASMST ? "Yes" : "No");
  case 3: return(accountdisk.flags&HASMST ? "Yes" : "No");
  case 4: return("???");
  case 5: return("???");
  default: return(usaptr->flags&HASMST ? "Yes" : "No");
  }
}


//
// 2. ocnothusn info   (online only) (user[ocnothusn] & ocndisk)
// 3. offline users info (accountdisk & ocndisk)
// 4. New user sign up
// 5. User logging on
// default: usrnum info only (online only) (usrptr & ocndisk)
//
//

/* New Text var template

char * tv_#(void)
{
switch (tv_what) {
  case 2:
  case 3:
  case 4:
  case 5:
  default:
  }
}

*/
