/***************************************************************************
 *                                                                         *
 *   SNOVA.C                                                               *
 *                                                                         *
 *   Copyright (C) 1990-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Supernova Game Module.                                                *
 *                                                                         *
 *                                               - L. Bird                 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "brkthu.h"
#include "galsnova.h"

void EXPORT init__snova(void);
int logsnv(void);
STATIC int inpsnv(void);
STATIC void snvsth(void);
STATIC void hupsnv(void);
STATIC void delsnv(char *uid);
STATIC int snvbtv(int stt,char *uid,struct snvplyr *snv);
STATIC void snvply(void);
STATIC void snvwon(void);
STATIC void snvlos(void);
STATIC long snvscor(int games,int wins,int kills);
STATIC int snvexit(void);
STATIC void snvmenp(int usrn);
STATIC int snvnum(void);
STATIC void snvout(void);
STATIC void snvoutg(void);
STATIC void snvinimap(void);
STATIC void snvmov(void);
STATIC char *snvgen(int othnum);
STATIC void clssnv(void);
STATIC void ini_rnd(void);
STATIC int girnd(int low,int high);

#define SIZGRD 5              /* size of grid (SIZGRD X SIZGRD)            */

                              /* snvbtv() status flags                     */
#define NEW    1              /*   check or create new player's            */
#define UPD    2              /*   update this player's stats              */
#define LKA    3              /*   look at a user's game statistics        */
#define GTP    4              /*   get this player's game statistics       */
#define GTO    5              /*   get other player's game statistics      */
#define EXS    6              /*   check if player exists in database      */

#define CHLNGD  1             /* snvptr->flags values (challenged flag)    */
#define PICKING 2             /*   this player picking his map             */
#define PLAYING 4             /*   this player is playing another user     */
#define COMPUTR 8             /*   this player is playing the computer     */

#define PCOMP  (snvptr->flags&COMPUTR)

int snvstt;                   /* Super Nova state number                   */
struct module snova={         /* module interface block                    */
     "",                      /*    name used to refer to this module      */
     logsnv,                  /*    user logon routine                     */
     inpsnv,                  /*    user input routine (CR terminated)     */
     snvsth,                  /*    user/special status handler            */
     NULL,                    /*    "injoth" routine for this module       */
     NULL,                    /*    user logoff supplemental routine       */
     hupsnv,                  /*    user lost-carrier routine              */
     NULL,                    /*    midnight clean-up                      */
     delsnv,                  /*    system delete account routine          */
     clssnv                   /*    system shutdown routine                */
};

struct snvstuf {              /* Basic stuff for each user                 */
     int  flags;              /*   Supernova flags for this player         */
     int  stars,cstars;       /*   player's stars, computer's stars left   */
     int  kills;              /*   player's kills, computer's kills so far */
     int  othusr;             /*   other player's number (channel #)       */
     int  hlpscn;             /*   current help screen being read          */
     long btvptr;             /*   current btrieve record for display24()  */
     char grid1[5][5];        /*   player's map                            */
     char grid2[5][5];        /*   opponents map                           */
     char grid3[5][5];        /*   computer's map (if playing computer)    */
} *snvptr,*snvotr,*snvstuf;

struct snvplyr {              /* Player's game statistics (btrieve rec)    */
     char uid[UIDSIZ];        /*   user-ID (key field)            30 bytes */
     int  games;              /*   total games played              2 bytes */
     int  wins;               /*   total games won                 2 bytes */
     int  lost;               /*   total games lost                2 bytes */
     int  kills;              /*   kills racked up                 2 bytes */
     long score;              /*   rating (score)                  4 bytes */
} *snvplr,*snvoth,*snvplyr;   /* record size = 42 bytes/line               */

int snvgrd,snvstars;          /* msg configurable (grid size, # of stars)  */

int snvx,snvy;                /* global x,y variables                      */

int clrflg;                   /* reset YOUR grid only                      */

char snvclr[][8]={            /* color definitions                         */
     "[0;37m",                 /*   borders, coordinate markers   (grey)    */
     "[1;34m",                 /*   empty sectors            "."  (blue)    */
     "[1;35m",                 /*   missed sectors           "O"  (magenta) */
     "[1;31m",                 /*   destroyed sectors        "X"  (red)     */
     "[1;37m"                  /*   sectors containing stars "*"  (white)   */
};

FILE *snvmb;                  /* message block file pointer                */

BTVFILE *snvbb;               /* Btrieve database file pointer             */

void EXPORT
init__snova(void)             /* Initialize game variables, alloc memory   */
{
     stzcpy(snova.descrp,gmdnam("GALSNV.MDF"),MNMSIZ);
     snvstt=register_module(&snova);
     snvmb=opnmsg("galsnova.mcv");
     snvbb=opnbtv("galsnova.dat",sizeof(struct snvplyr));
     snvstuf=(struct snvstuf *)alczer(nterms*sizeof(struct snvstuf));
     snvplyr=(struct snvplyr *)alczer(nterms*sizeof(struct snvplyr));
     snvgrd=SIZGRD;
     snvstars=numopt(NSTARS,1,25);
     ini_rnd();
}

int
logsnv(void)                  /* User logged on, send message if necc      */
{
     setmbk(snvmb);
     snvplr=&(snvplyr[usrnum]);
     snvptr=&(snvstuf[usrnum]);
     if (!snvbtv(EXS,usaptr->userid,snvplr)) {
          prfmsg(PLAYSNV);
          outprf(usrnum);
     }
     else {
          snvbtv(GTP,usaptr->userid,snvplr);
     }
     return(0);
}

STATIC int
inpsnv(void)                  /* Main CR terminated input routine          */
{
     int  c,x;

     setmbk(snvmb);
     setbtv(snvbb);
     snvplr=&(snvplyr[usrnum]);
     snvptr=&(snvstuf[usrnum]);
     do {
          bgncnc();
          if (snvexit()) {    /* Process 'X' or "exit" when entered        */
               outprf(usrnum);
               return(1);
          }
          switch (usrptr->substt) {
          case 0:             /* User just entered the game..              */
               cncchr();
               snvbtv(NEW,usaptr->userid,snvplr);
               if (snvplr->games == 0) {
                    prfmsg(NEWPLR,usaptr->userid);
               }
               else {
                    prfmsg(PLRSTATS,snvplr->uid,snvplr->games,snvplr->wins,
                         snvplr->lost,snvplr->kills,
                         spr("%3ld.%02ld",snvplr->score/100,snvplr->score%100));
               }
               if (!(usrptr->flags&CONCEX)) {
                    prfmsg(SNVMEN1);
                    snvmenp(usrnum);
               }
               usrptr->substt=SNVMEN1;
               break;
          case SMENU:
          case SNVMEN1:
               if (!margc || *nxtcmd == '?') {
                    if (usrptr->flags&INJOIP) {
                         snvmenp(usrnum);
                    }
                    else {    /* User just pressed RETURN, show long menu  */
                         cncchr();
                         prfmsg(SNVMEN1);
                         snvmenp(usrnum);
                    }
               }
               else {
                    switch (toupper(c=cncchr())) {
                    case 'I': /* User wants general information            */
                         prfmsg(usrptr->substt=SNVHLP6);
                         prfmsg(PRSRTN);
                         break;
                    case 'L': /* Lookup another player's statistics        */
                         if (qlobtv(0)) {
                              prfmsg(usrptr->substt=LOOKUP);
                         }
                         else {
                              prfmsg(NOPLYRS);
                         }
                         break;
                    case 'O': /* Display other player's statistics         */
                         if (alobtv(NULL,0)) {
                              snvptr->btvptr=absbtv();
                              btuoes(usrnum,1);
                              btutrg(usrnum,1);
                              prfmsg(usrptr->substt=LISTING);
                         }
                         break;
                    case 'P': /* Play Supernova!                           */
                         if (snvptr->flags < PICKING) {
                              snvply();
                         }
                         else {
                              snvinimap();
                              prfmsg(usrptr->substt=PIKMAP);
                              prfmsg(PIKSTAR,snvptr->stars);
                         }
                         break;
                    case 'X': /* Exit Supernova back to the main menu      */
                         prfmsg(SNVBYE,usaptr->userid);
                         return(0);
                    default:
                         prfmsg(CNOTIL,c);
                         snvmenp(usrnum);
                    }
               }
               break;
          case SNVHLP6:       /* Displaying the help screens               */
               if (!margc && !(usrptr->flags&INJOIP)) {
                    prfmsg(SNVHLP6+(++snvptr->hlpscn));
                    if (strlen(prfbuf) == 0) {
                         snvptr->hlpscn=0;
                         clrprf();
                         snvmenp(usrnum);
                         break;
                    }
               }
               prfmsg(PRSRTN);
               break;
          case LOOKUP:        /* Looking up another user's statistics      */
               if (!margc) {
                    if (usrptr->flags&INJOIP) {
                         prfmsg(LOOKUP);
                    }
                    else {
                         snvbtv(LKA,usaptr->userid,snvplr);
                         prfmsg(LOOKUP);
                    }
               }
               else {
                    switch (hdluid(cncall())) {
                    case UIDFND:
                         snvbtv(LKA,uidxrf.userid,snvplr);
                         prfmsg(LOOKUP);
                         break;
                    case UIDPMT:
                         prfmsg(LOOKUP);
                         break;
                    }
               }
               break;
          case PIKOPN:        /* Pick a player that is not busy            */
               if (!margc || *nxtcmd == '?') {
                    if (!(usrptr->flags&INJOIP)) {
                         snvply(); /* Redisplay the available players      */
                    }
                    else {
                         cncchr();
                         prfmsg(PIKOPN);
                    }
               }
               else {
                    if (isdigit(*nxtcmd) && (x=cncint()) >= 0 && x <= nterms) {
                         if (x == 0) {
                              snvinimap();
                              snvptr->flags=COMPUTR;
                              for (x=0 ; x < snvstars ; x++) {
                                   do {
                                        snvx=girnd(0,snvgrd);
                                        snvy=girnd(0,snvgrd);
                                   } while (snvptr->grid3[snvx][snvy] != '.');
                                   snvptr->grid3[snvx][snvy]='*';
                                   snvptr->cstars+=1;
                              }
                              if (!morcnc()) {
                                   prfmsg(usrptr->substt=PIKMAP);
                                   prfmsg(PIKSTAR,snvptr->stars);
                              }
                              break;
                         }
                         if (x-1 != usrnum && onsys(uacoff(x-1)->userid)) {
                              snvotr=&(snvstuf[othusn]);
                              if (othusp->flags&NOINJO) {
                                   prfmsg(OTHBSY,othuap->userid,othuap->userid);
                                   snvply();
                              }
                              else if (snvotr->flags >= PICKING) {
                                   prfmsg(ALRPLYN,othuap->userid);
                                   snvply();
                              }
                              else if (snvptr->flags&CHLNGD
                                             && snvptr->othusr == othusn) {
                                   snvptr->flags=snvotr->flags=PICKING;
                                   snvotr->othusr=usrnum;
                                   prfmlt(CHLACC,usaptr->userid);
                                   injoth();
                                   snvinimap();
                                   prfmsg(usrptr->substt=PIKMAP);
                                   prfmsg(PIKSTAR,snvptr->stars);
                              }
                              else { /* If not busy, then notify and set flags*/
                                   prfmlt(CHLMSG,usaptr->userid);
                                   injoth();
                                   prfmsg(CHLSNT,othuap->userid);
                                   snvmenp(usrnum);
                                   snvotr->flags=CHLNGD;
                                   snvotr->othusr=usrnum;
                              }
                         }
                         else {
                              if (x-1 == usrnum) {
                                   prfmsg(CHSELF);
                              }
                              else {
                                   prfmsg(INVSEL);
                              }
                              snvply();
                         }
                    }
                    else {
                         prfmsg(INVSEL);
                         prfmsg(PIKOPN);
                    }
               }
               break;
          case PIKMAP:        /* Pick the locations for all stars          */
               if (!margc || *nxtcmd == '?') {
                    snvoutg();
                    if (usrptr->flags&INJOIP) {
                         prfmsg(PIKSTAR,snvptr->stars);
                    }
                    else {
                         cncchr();
                         prfmsg(PIKHELP);
                         prfmsg(PIKSTAR,snvptr->stars);
                    }
               }
               else if (*nxtcmd == '/' && sameas(cncsig(),"/random")) {
                    for (x=(snvptr->stars-1) ; x < snvstars ; x++) {
                         do {
                              snvx=girnd(0,snvgrd);
                              snvy=girnd(0,snvgrd);
                         } while (snvptr->grid1[snvx][snvy] != '.');
                         prf("%d,%d  ",snvx+1,snvy+1);
                         snvptr->grid1[snvx][snvy]='*';
                         snvptr->stars+=1;
                    }
                    outprf(usrnum);
                    snvptr->flags|=PLAYING;
                    snvmov();
               }
               else {
                    if (snvnum()) {
                         if (snvx < 0 || snvx > (snvgrd-1)) {
                              prfmsg(XOUTRNG,snvx+1,snvgrd);
                              break;
                         }
                         else if (snvy < 0 || snvy > (snvgrd-1)) {
                              prfmsg(YOUTRNG,snvy+1,snvgrd);
                              break;
                         }
                         if (snvptr->grid1[snvx][snvy] == '.') {
                              snvptr->grid1[snvx][snvy]='*';
                              if (++snvptr->stars > snvstars) {
                                   snvptr->flags|=PLAYING;
                                   snvmov();
                              }
                              else {
                                   prfmsg(PIKSTAR,snvptr->stars);
                              }
                         }
                         else {
                              prfmsg(PIKAGAIN,snvx+1,snvy+1);
                              prfmsg(PIKSTAR,snvptr->stars);
                         }
                    }
                    else {
                         snvout();
                    }
               }
               break;
          case WAITOPN:       /* Waiting for opponent to move              */
               if (!margc) {
                    if (!(usrptr->flags&INJOIP)) {
                         snvoutg();
                    }
                    prfmsg(WAITOPN);
               }
               else {
                    snvout();
               }
               break;
          case BOMBOPN:       /* Bombing the opponent - human or computer  */
               if (!margc) {
                    snvoutg();
                    prfmsg(BOMBOPN);
               }
               else if (*nxtcmd == '?') {
                    prfmsg(BOMBHLP);
               }
               else if (margc > 0) {
                    if (snvptr->flags&COMPUTR) {
                         if (snvnum()) {
                              if (snvx < 0 || snvx > (snvgrd-1)) {
                                   prfmsg(XOUTRNG,snvx+1,snvgrd);
                                   break;
                              }
                              else if (snvy < 0 || snvy > (snvgrd-1)) {
                                   prfmsg(YOUTRNG,snvy+1,snvgrd);
                                   break;
                              }
                              else if (snvptr->grid3[snvx][snvy] == '.') {
                                   prfmsg(BOMBMIS,snvx+1,snvy+1);
                                   snvptr->grid2[snvx][snvy]='O';
                              }
                              else if (snvptr->grid3[snvx][snvy] != '*') {
                                   prfmsg(BOMBAGN,snvx+1,snvy+1);
                              }
                              else {
                                   if (++snvptr->kills == snvstars) {
                                        prfmsg(YOUWON,"the computer","it's");
                                        snvwon();
                                        snvmenp(usrnum);
                                        break;
                                   }
                                   prfmsg(BOMBHIT,snvx+1,snvy+1);
                                   snvptr->grid2[snvx][snvy]='X';
                                   snvptr->grid3[snvx][snvy]='X';
                                   snvptr->cstars-=1;
                              }
                              outprf(usrnum);
                              snvmov();
                         }
                         else {
                              prfmsg(INVCORD,snvgrd);
                         }
                    }
                    else if (onsys(uacoff(snvptr->othusr)->userid)) {
                         if (snvnum()) {
                              snvotr=&snvstuf[othusn];
                              if (snvotr->grid1[snvx][snvy] == '.') {
                                   prfmlt(BMISOTH,usaptr->userid,snvx+1,snvy+1);
                                   injoth();
                                   prfmsg(BOMBMIS,snvx+1,snvy+1);
                                   snvptr->grid2[snvx][snvy]='O';
                                   snvotr->grid1[snvx][snvy]='O';
                              }
                              else if (snvotr->grid1[snvx][snvy] != '*') {
                                   prfmlt(BMISAGN2,usaptr->userid,snvx+1,snvy+1);
                                   injoth();
                                   prfmsg(BOMBAGN,snvx+1,snvy+1);
                              }
                              else {
                                   prfmlt(BHITOTH,snvx+1,snvy+1);
                                   injoth();
                                   if (++snvptr->kills == snvstars) {
                                        prfmlt(OTHWINS,usaptr->userid);
                                        othusp->substt=SMENU;
                                        injoth();
                                        prfmsg(YOUWON,othuap->userid,snvgen(othusn));
                                        snvwon();
                                        snvmenp(usrnum);
                                        break;
                                   }
                                   prfmsg(BOMBHIT,snvx+1,snvy+1);
                                   snvptr->grid2[snvx][snvy]='X';
                                   snvotr->grid1[snvx][snvy]='X';
                                   snvotr->stars-=1;
                              }
                              outprf(usrnum);
                              snvmov();
                         }
                         else {
                              snvout();
                         }
                    }
               }
               break;
          }
     } while (!endcnc());
     outprf(usrnum);
     return(1);
}

STATIC void
snvsth(void)                  /* Special status handler for computer moves */
{
     setmbk(snvmb);
     setbtv(snvbb);
     snvptr=&(snvstuf[usrnum]);
     snvplr=&(snvplyr[usrnum]);
     switch (usrptr->substt) {
     case COMPMOV:
          if (status != CYCLE) {
               dfsthn();
               break;
          }
          snvx=girnd(0,snvgrd);
          snvy=girnd(0,snvgrd);
          if (snvptr->grid1[snvx][snvy] == '*') {
               prfmsg(COMPHIT,snvx+1,snvy+1);
               snvptr->grid1[snvx][snvy]='X';
               snvptr->stars-=1;
               if ((snvptr->stars-1) == 0) {
                    snvlos();
                    prfmsg(OTHWINS,"The computer");
                    snvmenp(usrnum);
               }
               else {
                    snvoutg();
                    prfmsg(usrptr->substt=BOMBOPN);
               }
               outprf(usrnum);
               btulok(usrnum,0);
          }
          else if (snvptr->grid1[snvx][snvy] != '.') {
               btuinj(usrnum,CYCLE);
          }
          else {
               snvptr->grid1[snvx][snvy]='O';
               prfmsg(COMPMIS,snvx+1,snvy+1);
               snvoutg();
               prfmsg(usrptr->substt=BOMBOPN);
               outprf(usrnum);
               btulok(usrnum,0);
          }
          break;
     case LISTING:
          if (status == OUTMT) {
               gabbtv(snvplr,snvptr->btvptr,0);
               if (snvplr->games > 0) {
                    prfmsg(OTHSLINE,snvplr->uid,snvplr->games,snvplr->wins,
                         snvplr->lost,snvplr->kills,
                         spr("%3ld.%02ld",snvplr->score/100,snvplr->score%100));
                         outprf(usrnum);
               }
               else {
                    btuinj(usrnum,OUTMT);
               }
               if (aqnbtv(NULL) != 0) {
                    snvptr->btvptr=absbtv();
               }
               else {
                    btuoes(usrnum,0);
                    btutrg(usrnum,0);
                    snvbtv(GTP,usaptr->userid,snvplr);
                    snvmenp(usrnum);
                    outprf(usrnum);
               }
          }
          else if (status == INBLK) {
               btuoes(usrnum,0);
               btutrg(usrnum,0);
               snvbtv(GTP,usaptr->userid,snvplr);
               snvmenp(usrnum);
               outprf(usrnum);
          }
          else {
               dfsthn();
          }
          break;
     default:
          dfsthn();
     }
}

STATIC void
hupsnv(void)                  /* Someone hung up, check status of players  */
{
     setmbk(snvmb);
     if ((usrptr->state == snvstt) && !(snvstuf[usrnum].flags&COMPUTR)) {
          for (othusn=0 ; othusn < nterms ; othusn++) {
               if (user[othusn].state == snvstt) {
                    if (snvstuf[othusn].othusr == usrnum) {
                         prfmlt(OPNLFT,usaptr->userid);
                         snvmenp(othusn);
                         btupmt(othusn,0);
                         injoth();
                         break;
                    }
               }
          }
     }
}

STATIC void
delsnv(uid)                   /* If an account was deleted, remove record  */
char *uid;
{
     setbtv(snvbb);
     if (acqbtv(NULL,uid,0)) {
          delbtv();
     }
}

STATIC int
snvbtv(stt,uid,snv)           /* Supernova Btrieve routines                */
int stt;
char *uid;
struct snvplyr *snv;
{
     setbtv(snvbb);
     switch (stt) {
     case NEW:                /* Check for new player, insert record if so */
          if (qeqbtv(uid,0) == 0) {
               strncpy(snv->uid,uid,UIDSIZ);
               snv->games=0;
               snv->wins=0;
               snv->lost=0;
               snv->kills=0;
               snv->score=0L;
               insbtv(snv);
          }
          break;
     case UPD:                /* Update current player's game statistics   */
          geqbtv(NULL,uid,0);
          updbtv(snv);
          break;
     case LKA:                /* Look at a specific player's statistics    */
          if (acqbtv(snv,uid,0)) {
               prfmsg(OTHSTATS,uid,snv->games,snv->wins,snv->lost,
                 snv->kills,spr("%3ld.%02ld",snv->score/100,snv->score%100));
          }
          else {
               prfmsg(NOAVAIL,uid);
          }
          break;
     case GTP:                /* Get this player's game statistics         */
          geqbtv(snv,uid,0);
          break;
     case EXS:                /* Check to see if player has played before  */
          if (!qeqbtv(uid,0)) {
               return(0);
          }
          break;
     }
     return(1);
}

STATIC void
snvply(void)                  /* Display players available to challenge    */
{
     cncall();
     if (snvptr->flags == CHLNGD) {
          prfmsg(CHGDBY,uacoff(snvptr->othusr)->userid);
     }
     prfmsg(SHOHDR);
     for (othusn=0 ; othusn < nterms ; othusn++) {
          switch (user[othusn].class) {
          case VACANT:
          case ONLINE:
          case SUPIPG:
               break;
          default:
               if (user[othusn].flags&NOINJO) {
                    break;
               }
               if (user[othusn].flags&INVISB) {
                    break;
               }
               if (snvstuf[othusn].flags&PLAYING) {
                    break;
               }
               if (othusn == usrnum) {
                    break;
               }
               prfmsg(SHOAVL,othusn+1,uacoff(othusn)->userid,
                                   module[user[othusn].state]->descrp);
          }
     }
     prfmsg(usrptr->substt=PIKOPN);
}

STATIC void
snvwon(void)                  /* usrnum won, update record(s)              */
{
     snvbtv(GTP,usaptr->userid,snvplr);
     snvplr->games+=1;
     snvplr->wins+=1;
     snvplr->kills+=snvptr->kills;
     snvplr->score=snvscor(snvplr->games,snvplr->wins,snvplr->kills);
     snvbtv(UPD,usaptr->userid,snvplr);
     btupmt(usrnum,0);
     if (!(snvptr->flags&COMPUTR)) {
          if (instat(uacoff(snvptr->othusr)->userid,snvstt) != 0) {
               snvoth=&(snvplyr[othusn]);
               snvoth->games+=1;
               snvoth->lost+=1;
               snvoth->kills+=snvotr->kills;
               snvoth->score=snvscor(snvoth->games,snvoth->wins,snvoth->kills);
               snvbtv(UPD,othuap->userid,snvoth);
               snvotr->flags=0;
               btupmt(othusn,0);
          }
     }
     snvptr->flags=0;
}

STATIC void
snvlos(void)                  /* usrnum lost, update record(s)             */
{
     snvbtv(GTP,usaptr->userid,snvplr);
     snvplr->games+=1;
     snvplr->lost+=1;
     snvplr->kills+=snvptr->kills;
     snvplr->score=snvscor(snvplr->games,snvplr->wins,snvplr->kills);
     snvbtv(UPD,usaptr->userid,snvplr);
     btupmt(usrnum,0);
     if (!(snvptr->flags&COMPUTR)) {
          if (instat(uacoff(snvptr->othusr)->userid,snvstt)) {
               snvoth=&(snvplyr[othusn]);
               snvoth->games+=1;
               snvoth->wins+=1;
               snvoth->kills+=snvotr->kills;
               snvoth->score=snvscor(snvoth->games,snvoth->wins,snvoth->kills);
               snvbtv(UPD,othuap->userid,snvoth);
               snvotr->flags=0;
               btupmt(othusn,0);
          }
     }
     snvptr->flags=0;
}

STATIC long
snvscor(games,wins,kills)          /* Compute double precision score       */
int games,wins,kills;
{
     long p1,p2,p3;

     p1=(100L*((long)games*(long)wins*(long)kills));
     if (games > 10) {
          p2=((long)snvstars*(long)games*(long)games*(long)games)/100L;
     }
     else {
          p1=p1*100L;
          p2=(long)snvstars*(long)games*(long)games*(long)games;
     }
     p3=(p1/p2);
     return(p3);
}

STATIC int
snvexit(void)                 /* "exit" was typed or 'X' was pressed       */
{
     if (toupper(*nxtcmd) == 'X') {
          switch (usrptr->substt) {
          case SNVHLP6:
          case PIKOPN:
               snvmenp(usrnum);
               cncchr();
               return(1);
          case LOOKUP:
               snvbtv(GTP,usaptr->userid,snvplr);
               snvmenp(usrnum);
               cncchr();
               return(1);
          case PIKMAP:
          case WAITOPN:
          case BOMBOPN:
               if ((usrptr->substt != PIKMAP) || snvptr->stars == 1) {
                    if (!PCOMP && instat(uacoff(snvptr->othusr)->userid,snvstt)) {
                         if (snvstuf[othusn].flags > CHLNGD) {
                              if (snvstuf[othusn].kills > snvptr->kills) {
                                   prfmsg(FORFUSR,uacoff(snvptr->othusr)->userid);
                                   outprf(usrnum);
                                   prfmlt(FORFOTH,usaptr->userid);
                                   snvlos();
                              }
                              else {
                                   prfmlt(OPNLFT,usaptr->userid);
                              }
                         }
                         btupmt(othusn,0);
                         snvstuf[othusn].flags=0;
                         snvmenp(othusn);
                         injoth();
                    }
                    btupmt(usrnum,0);
                    snvmenp(usrnum);
                    snvptr->flags=0;
                    cncchr();
                    return(1);
               }
               snvptr->stars=1;
               prfmsg(RSTMAP);
               prfmsg(PIKSTAR,snvptr->stars);
               clrflg=1;
               snvinimap();
               cncchr();
               return(1);
          }
     }
     return(0);
}

STATIC void
snvmenp(usrn)
int usrn;
{
     btulok(usrn,0);
     btupmt(usrn,0);
     condex();
     if (usrn == usrnum) {
          prfmsg(user[usrn].substt=SMENU);
     }
     else {
          prfmlt(user[usrn].substt=SMENU);
     }
}

STATIC int
snvnum(void)                  /* Check for digits seperated by comma or spc */
{
     if (isdigit(*nxtcmd) != 0) {  /* Is first character numeric? */
          if ((snvx=cncint()) > 0) {
               if (!isdigit(*nxtcmd)) {  /* absorb comma or period          */
                    cncchr();
               }
               if ((snvy=cncint()) > 0) {
                    cncall();
                    snvx-=1;
                    snvy-=1;
                    return(1);
               }
          }
     }
     return(0);
}

STATIC void
snvout(void)                  /* Output line to other user or display map  */
{
     char *ptr;

     if (*nxtcmd == '?') {
          prfmsg(SNVHLPW);
     }
     else if (*nxtcmd == '/') {
          if (sameas((ptr=cncsig()),"/map")) {
               snvoutg();
               prfmsg(usrptr->substt);
          }
          else if (sameas(ptr,"/stat")) {
               if (!(snvptr->flags&COMPUTR) &&
                    instat(uacoff(snvptr->othusr)->userid,snvstt)) {
                    snvoth=&(snvplyr[othusn]);
                    prfmsg(BOTHSTA,usaptr->userid,othuap->userid,
                         snvplr->games,snvoth->games,
                         snvplr->wins, snvoth->wins,
                         snvplr->lost, snvoth->lost,
                         snvplr->kills,snvoth->kills,
                         spr("%3ld.%02ld",snvplr->score/100,snvplr->score%100),
                         spr("%3ld.%02ld",snvoth->score/100,snvoth->score%100));
               }
               else {
                    prfmsg(SINGSTA,snvplr->games,snvplr->wins,snvplr->lost,
                      snvplr->kills,spr("%3ld.%02ld",snvplr->score/100,
                                                     snvplr->score%100));
               }
          }
          else {
               prfmsg(CNOTIL);
          }
     }
     else if (snvptr->flags&COMPUTR) {
          prfmsg(INVCORD,snvgrd);
     }
     else if (instat(uacoff(snvptr->othusr)->userid,snvstt)) {
          snvotr=&(snvstuf[othusn]);
          if (snvotr->flags&(PICKING+PLAYING)) {
               prfmlt(FROMWHO,usaptr->userid,cncall());
               if (pfnlvl > 2 && usrptr->pfnacc > MAXPFN) {
                    clrmlt();
                    prf("");
                    btuinj(usrnum,RING);
               }
               else if (pfnlvl >= 2 && usrptr->pfnacc > WRNPFN) {
                    clrmlt();
                    prfmsg(NOPROFAN);
               }
               else {
                    injoth();
                    prfmsg(MSGSENT,othuap->userid);
               }
          }
          else {
               prfmsg(OPNNOTH,othuap->userid);
          }
     }
     else {
          prfmsg(OPNNOTH,uacoff(snvptr->othusr)->userid);
     }
}

STATIC void
snvoutg(void)                 /* Output the tactical display to the screen */
{
     int x,y;
     char c0,c1,c2,c3,*color;

     c0=c1=c2=c3=0;
     prfmsg(GRDHDR);
     for (y=0 ; y < snvgrd ; y++) {
          prf("%s%d |",snvclr[0],y+1);
          for (x=0 ; x < snvgrd ; x++) {
               c0=snvptr->grid1[x][y];
               if (c0 != c1 || x == 0) {
                    switch (c0) {
                    case '.':
                         color=snvclr[1];
                         break;
                    case 'O':
                         color=snvclr[2];
                         break;
                    case 'X':
                         color=snvclr[3];
                         break;
                    case '*':
                         color=snvclr[4];
                    }
                    prf("%s",color);
                    c1=c0;
               }
               prf(" %c ",c0);
          }
          prf("%s| |",snvclr[0]);
          for (x=0 ; x < snvgrd ; x++) {
               c2=snvptr->grid2[x][y];
               if (c2 != c3 || x == 0) {
                    switch (c2) {
                    case '.':
                         color=snvclr[1];
                         break;
                    case 'O':
                         color=snvclr[2];
                         break;
                    case 'X':
                         color=snvclr[3];
                    }
                    prf("%s",color);
                    c3=c2;
               }
               prf(" %c ",c2);
          }
          prf("%s|\r",snvclr[0]);
     }
     prfmsg(GRDTRL);
}

STATIC void
snvinimap(void)               /* Initialize grids                          */
{
     int i;

     if (clrflg) {
          setmem(snvptr->grid1,25,'.');
          clrflg=0;
     }
     else {
          setmem(snvptr->grid1,75,'.');
     }
     for (i=0 ; i < nterms ; i++) {
          if ((snvstuf[i].othusr == usrnum) && (snvptr->othusr != i)) {
               if (!(snvstuf[i].flags&COMPUTR)) {
                    snvstuf[i].flags=0;
               }
          }
     }
     snvptr->stars=1;
     snvptr->cstars=snvptr->kills=0;
     btupmt(usrnum,'.');
}

STATIC void
snvmov(void)                  /* Opponents turn to move                    */
{
     if (snvptr->flags&COMPUTR) {
          if (usrptr->substt == PIKMAP) {
               snvoutg();
               prfmsg(usrptr->substt=BOMBOPN);
          }
          else {
               prfmsg(usrptr->substt=COMPMOV);
               btulok(usrnum,1);
               btuinj(usrnum,CYCLE);
          }
     }
     else if (instat(uacoff(snvptr->othusr)->userid,snvstt)) {
          if (othusp->substt == WAITOPN) {
               othusp->substt=BOMBOPN;
               prfmlt(URTURN);
               injoth();
               prfmsg(usrptr->substt=WAITOPN);
          }
//        else if (othusp->substt == BOMBOPN) {
//             prfmlt(othusp->substt=WAITOPN);
//             injoth();
//             prfmsg(usrptr->substt=BOMBOPN);
//        }
          else {
               prfmsg(OPNPIKN,othuap->userid,snvgen(othusn));
               usrptr->substt=WAITOPN;
          }
     }
     else {
          prfmsg(OPNNOTH,uacoff(snvptr->othusr)->userid);
          usrptr->substt=WAITOPN;
     }
}

STATIC char *
snvgen(othnum)                /* Return string "his" or "her"              */
int othnum;
{
     return(uacoff(othnum)->sex == 'F' ? "her" : "his");
}

STATIC void
clssnv(void)                  /* Shut down the Supernova files             */
{
     clsmsg(snvmb);
     clsbtv(snvbb);
}

STATIC void
ini_rnd(void)                 /* initialize random number seed             */
{
     randomize();
}

STATIC int
girnd(low,high)               /* Returns random number between low and high*/
int low,high;
{
     int  z;

     return((z=random(high)) < low ? z+low : z);
}
