/***************************************************************************
 *                                                                         *
 *   LOTTO.C                                                               *
 *                                                                         *
 *   Copyright (C) 1990-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Super Lotto Main Line and Major BBS Interface                         *
 *                                                                         *
 *                                                    - L. Bird 9/8/91     *
 *                                     6.x Conversion - E. Bush 3/10/92    *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gallot.h"

#define NDIGS       8         /* number of digits to possibly guess        */
#define SHORT_MENU  1         /* short menu display flag                   */
#define LONG_MENU   0         /* long menu display flag                    */
#define LISTING     -1

/* LOTTO.C 06/03/92 15.09.34 */
void EXPORT init__lotto(void);
int loglot(void);
int lotto(void);
STATIC int display24(void);
STATIC void outdigs(void);
STATIC void lotmnu(int mtype);
STATIC void shocard(void);
STATIC void rstcard(void);
void lotmcu(void);
STATIC void picknums(void);
STATIC int validnum(void);
STATIC void lotupdctl(void);
void clslot(void);
STATIC void ini_rnd(void);
STATIC int girnd(int low,int high);

int lotstt;                   /* super lotto state number                  */
struct module slotto={        /* module interface block                    */
     "",                      /*    name used to refer to this module      */
     loglot,                  /*    logon supplemental routine             */
     lotto,                   /*    user input routine                     */
     dfsthn,                  /*    status-input routine if selected       */
     NULL,                    /*    "injoth" routine for this module       */
     NULL,                    /*    user logoff supplemental routine       */
     NULL,                    /*    hangup routine                         */
     lotmcu,                  /*    mcu routine                            */
     NULL,                    /*    delete account routine                 */
     clslot                   /*    system shutdown routine                */
};

/* definitions of lotctl.lotinfo subscript:
          lotinfo[0]= # of last winners
          lotinfo[1]=maximum range per digit
          lotinfo[2]=number of digits to guess
          lotinfo[3]=cost per ticket
          lotinfo[4]=ticket value (credits added to pot per purchase)
          lotinfo[5]=minimum credits required to play
          lotinfo[6]=roll over amount if no winners
          lotinfo[7]=start pot amount if there is a winner
*/

struct lotctl {
     char key[4];             /* key for record retrieval   4    */
     char lastwin[10][UIDSIZ];/* last winner(s) user-id     304  */
     long lastpot;            /* winning jackpot            308  */
     long jackpot;            /* current jackpot            312  */
     unsigned sold;           /* tickets sold for today     314  */
     int  lastdig[NDIGS];     /* last winning digits        330  */
     int  lotinfo[8];         /* lotto setup info           346  */
} lotctl;                     /* record size is 346              */

struct lotdta {
     char uid[UIDSIZ];        /* key is user-id                  */
     int  curdig;             /* current digit being picked      */
     int  dig[NDIGS];         /* digits picked by user-id        */
} *dtaptr,                    /* dynamically allocated array ptr */
  *lotdta;                    /* record size is 48               */

struct lstusr {
     char mode;               /* mode of display (1=Sysop)       */
     int  cntr;               /* this users counter              */
     int  n;                  /* multipurpose per-user var       */
     long fpos;               /* file position of file           */
} *lstptr,
  *lstusr;

static
int cnt,lotmsv,n,n0,n1,p,newstt,dig[NDIGS],
    msgs[]={
        SETMAX,SETNDIG,SETPRICE,SETWORTH,SETMIN,SETROLL,SETSTART
    };

char winner[10][UIDSIZ],advflg;

FILE *lotmb;

static
BTVFILE *ctlbb,*dtabb;

void EXPORT
init__lotto(void)                  /* Initialize the lotto module          */
{
     stzcpy(slotto.descrp,gmdnam("GALLOT.MDF"),MNMSIZ);
     lotstt=register_module(&slotto);
     lotmb=opnmsg("gallot.mcv");
     lotmsv=ynopt(LOTMSV);
     dtabb=opnbtv("gallod.dat",sizeof(struct lotdta));
     ctlbb=opnbtv("gallot.dat",sizeof(struct lotctl));
     if (!acqbtv(&lotctl,"key",0)) {
          strcpy(lotctl.key,"key");
          for (n=0 ; n < 11 ; n++) {
               strcpy(lotctl.lastwin[n],"NO WINNER");
          }
          for (n=0 ; n < NDIGS ; n++) {
               lotctl.lastdig[n]=dig[n]=0;
          }
          lotctl.lastpot=0L;
          lotctl.jackpot=0L;
          lotctl.sold=0;
          setmem(&lotctl.lotinfo[0],sizeof(lotctl.lotinfo[0])*8,0);
          lotctl.lotinfo[1]=9;
          lotctl.lotinfo[4]=0;
          lotctl.lotinfo[5]=0;
          lotctl.lotinfo[2]=5;
          insbtv(&lotctl);
     }
     lotdta=(struct lotdta *)alcmem(nterms*sizeof(struct lotdta));
     lstusr=(struct lstusr *)alcmem(nterms*sizeof(struct lstusr));
     ini_rnd();     /* Initialize random number seeds - 01/14/90 LB */
}

int
loglot(void)                  /* Display logon message (last winners etc.) */
{
     if (lotmsv) {
          setmbk(lotmb);
          prfmsg(LOTMSG);
          if (lotctl.lotinfo[0] > 0) {
               if (lotctl.lotinfo[0] > 10) {
                    lotctl.lotinfo[0]=10;
               }
               prfmsg(lotctl.lotinfo[0] > 1 ? LSTWINRS : LSTWINR,
                                                            lotctl.lastwin[0]);
               for (n=1 ; n < lotctl.lotinfo[0] ; n++) {
                    prfmsg(SHOWNRS,lotctl.lastwin[n]);
               }
               prfmsg(LSTPOT,l2as(lotctl.lastpot));
               prfmsg(LOTNUMS);
          }
          else {
               prfmsg(NOWINRS);
          }
          for (n=0 ; n < lotctl.lotinfo[2] ; n++) {
               if (lotctl.lastdig[n] > 0) {
                    prfmsg(SHOW2D,lotctl.lastdig[n]);
               }
          }
          prfmsg(ENDMSG,l2as(lotctl.jackpot));
          outprf(usrnum);
     }
     return(0);
}

int
lotto(void)                   /* The main input routine                    */
{
     int  i;
     long l;
     char c;

     setmbk(lotmb);
     setbtv(dtabb);
     dtaptr=&lotdta[usrnum];
     lstptr=&lstusr[usrnum];
     newstt=usrptr->substt;
     do {
          bgncnc();
          switch (newstt) {
          case 0:
               cncchr();
               if (!(usrptr->flags&CONCEX)) {
                    lotmnu(LONG_MENU);
               }
               newstt=LOTMENU;
               p=0;
               break;
          case LOTMENU:
               if (!margc) {
                    if (usrptr->flags&INJOIP) {
                         lotmnu(SHORT_MENU);
                    }
                    else {
                         lotmnu(LONG_MENU);
                    }
                    break;
               }
               if (isdigit(*nxtcmd) && usrptr->flags&MASTER) {
                    if ((lstptr->n=cncint()) > 0 && lstptr->n < 8) {
                         prfmsg(msgs[lstptr->n-1],lotctl.lotinfo[lstptr->n]);
                         prfmsg(newstt=ENTVAL);
                         break;
                    }
                    else if (lstptr->n == 8) {
                         prfmsg(newstt=SETPOT,l2as(lotctl.jackpot));
                         break;
                    }
                    else if (lstptr->n == 9) {
                         if (qlobtv(0)) {
                              lstptr->mode=1;
                              lstptr->cntr=0;
                              lstptr->fpos=absbtv();
                              if (display24()) {
                                   newstt=LISTING;
                              }
                         }
                         else {
                              prfmsg(NOTICKS);
                              lotmnu(SHORT_MENU);
                         }
                         break;
                    }
                    else {
                         cncall();
                         prfmsg(INVINP);
                         lotmnu(SHORT_MENU);
                    }
               }
               else if ((c=cncchr()) == '?') {
                    lotmnu(LONG_MENU);
                    break;
               }
               else if (c == 'X') {
                    if (p) {
                         prfmsg(EXITBUY);
                    }
                    else {
                         prfmsg(EXITLOT);
                    }
                    return(0);
               }
               else if (isalpha(c)) {
                    switch (c) {
                    case 'P':
                         if (hasmkey(LOTKEY)) {
                              rstcard();
                              shocard();
                              prfmsg(PIKDIG,lotctl.lotinfo[1],dtaptr->curdig+1);
                              newstt=SHOCARD;
                         }
                         else {
                              prfmsg(LIVONL);
                              lotmnu(SHORT_MENU);
                         }
                         break;
                    case 'L':
                         if (qlobtv(0)) {
                              lstptr->mode=0;
                              lstptr->cntr=0;
                              if (acqbtv(dtaptr,usaptr->userid,0)) {
                                   if (display24()) {
                                        newstt=LISTING;
                                   }
                                   break;
                              }
                         }
                         prfmsg(NOCARDS);
                         lotmnu(SHORT_MENU);
                         break;
                    case 'I':
                         prfmsg(LOTHELP,lotctl.lotinfo[3],lotctl.lotinfo[4],
                              lotctl.lotinfo[2],lotctl.lotinfo[1]);
                         lotmnu(SHORT_MENU);
                         break;
                    default:
                         prfmsg(CNOTIL);
                         lotmnu(SHORT_MENU);
                         break;
                    }
               }
               else {
                    cncall();
                    prfmsg(INVINP);
                    lotmnu(SHORT_MENU);
               }
               break;
          case SHOCARD:
               if (!margc) {
                    shocard();
                    prfmsg(PIKDIG,lotctl.lotinfo[1],dtaptr->curdig+1);
                    break;
               }
               if (toupper(*nxtcmd) == 'X') {
                    lotmnu(SHORT_MENU);
                    newstt=LOTMENU;
                    break;
               }
               for (n1=0 ; morcnc() ; n1++) {
                    if (validnum()) {
                         dtaptr->curdig++;
                         if (dtaptr->curdig >= lotctl.lotinfo[2]) {
                              shocard();
                              prfmsg(newstt=RUSURE);
                              break;
                         }
                    }
                    else {         /* Invalid number   */
                         cncall();
                         break;
                    }
               }
               if (newstt == SHOCARD) {
                    shocard();
                    prfmsg(PIKDIG,lotctl.lotinfo[1],dtaptr->curdig+1);
               }
               break;
          case RUSURE:
               if (!margc) {
                    shocard();
                    prfmsg(RUSHELP,lotctl.lotinfo[3]);
                    break;
               }
               if (cncyesno() == 'Y') {
                    if (rtstcrd(lotctl.lotinfo[3])) {
                         lotctl.jackpot+=lotctl.lotinfo[4];
                         lotctl.sold++;
                         strncpy(dtaptr->uid,usaptr->userid,UIDSIZ);
                         insbtv(dtaptr);
                         rdedcrd(lotctl.lotinfo[3],1);
                         lotupdctl();
                         p=1;
                    }
                    else {
                         prfmsg(CAFFORD,lotctl.lotinfo[3]);
                    }
               }
               else {
                    prfmsg(ABORTD);
               }
               dtaptr->curdig=0;
               lotmnu(SHORT_MENU);
               newstt=LOTMENU;
               break;
          case ENTVAL:
               if (!margc && !(usrptr->flags&INJOIP)) {
                    prfmsg(NOTCHNG);
               }
               else if (!margc) {  /* paged.. */
                    prfmsg(msgs[lstptr->n-1],lotctl.lotinfo[lstptr->n]);
                    break;
               }
               else if (isdigit(*nxtcmd) && (i=cncint()) >= 0) {
                    if (lstptr->n > 2
                       || (msgs[lstptr->n-1] == SETMAX
                          && i > lotctl.lotinfo[2])
                       || (msgs[lstptr->n-1] == SETNDIG
                          && (i <= NDIGS && i < lotctl.lotinfo[1] && i > 0))) {
                         if (msgs[lstptr->n-1] == SETNDIG
                            && i > lotctl.lotinfo[lstptr->n]) {
                              n=lotctl.lotinfo[lstptr->n];
                              setmem(&lotctl.lastdig[n],(NDIGS-i)*sizeof(int),0);
                         }
                         lotctl.lotinfo[lstptr->n]=i;
                         prfmsg(CHANGED);
                         lotupdctl();
                    }
                    else {
                         prfmsg(NOTRNG2);
                         prfmsg(msgs[lstptr->n-1],lotctl.lotinfo[lstptr->n]);
                         break;
                    }
               }
               else {
                    prfmsg(NOTCHNG);
               }
               outprf(usrnum);
               lotmnu(SHORT_MENU);
               newstt=LOTMENU;
               break;
          case SETPOT:
               if (!margc && !(usrptr->flags&INJOIP)) {
                    prfmsg(NOTCHNG);
               }
               else if (!margc) {
                    prfmsg(SETPOT,l2as(lotctl.jackpot));
                    break;
               }
               else if ((l=cnclon()) > 0L) {
                    lotctl.jackpot=l;
                    prfmsg(CHANGED);
                    lotupdctl();
               }
               else {
                    cncall();
                    newstt=LOTMENU;
                    prfmsg(NOTCHNG);
                    prfmsg(INVINP);
                    prfmsg(SHRTMNU2);
                    break;
               }
               lotmnu(SHORT_MENU);
               newstt=LOTMENU;
               outprf(usrnum);
               break;
          case LISTING:
               if (!margc && !(usrptr->flags&INJOIP)) {
                    display24();
               }
               else if (cncchr() == 'X') {
                    lotmnu(SHORT_MENU);
                    newstt=LOTMENU;
               }
               else {
                    prfmsg(LSTPRMT);
               }
               break;
          }
     } while (!endcnc());
     usrptr->substt=newstt;
     outprf(usrnum);
     return(1);
}

STATIC
int
display24(void)          /* Display a screenful of text & prompt for more */
{
     cnt=0;
     prf("\r");
     do {
          if (lstptr->mode) {
               gabbtv(dtaptr,lstptr->fpos,0);
               prfmsg(SHOWNER,dtaptr->uid,++lstptr->cntr,dtaptr->dig[0]);
               outdigs();
               cnt++;
          }
          else {
               prfmsg(SHOTICK,++lstptr->cntr,dtaptr->dig[0]);
               outdigs();
               cnt++;
          }
          if (lstptr->mode ? !qnxbtv() : !aqnbtv(dtaptr)) {
               if (!lstptr->cntr) {
                    prfmsg(NOCARDS);
               }
               newstt=LOTMENU;
               lotmnu(SHORT_MENU);
               return(0);
          }
          lstptr->fpos=absbtv();
     } while (cnt < 21);
     prfmsg(LSTPRMT);
     return(1);
}

STATIC
void
outdigs(void)                 /* Show current picked numbers               */
{
     for (n=1 ; n < lotctl.lotinfo[2] ; n++) {
          if (dtaptr->dig[n] > 0) {
               prfmsg(SHOW2DD,dtaptr->dig[n]);
          }
     }
     prf("\r");
}

STATIC
void
lotmnu(mtype)                 /* Display the short or long menu            */
int mtype;                         /* menu type                            */
{
     condex();
     if (!mtype) {
          prfmsg(usrptr->flags&MASTER ? SYSMENU : LOTMENU,lotctl.sold,
               lotctl.lastwin,l2as(lotctl.lastpot));
          prfmsg(usrptr->flags&MASTER ? SYSNUMS : LOTNUMS);
          for (n=0 ; n < lotctl.lotinfo[2] ; n++) {
               if (lotctl.lastdig[n] > 0) {
                    prfmsg(SHOW2D,lotctl.lastdig[n]);
               }
          }
          prfmsg(usrptr->flags&MASTER ? SYSPRMT : LOTPRMT,l2as(lotctl.jackpot),
               lotctl.lotinfo[3]);
     }
     else {
          prfmsg(SHRTMNU2);
     }
}

STATIC
void
shocard(void)                 /* Show a card with picked numbers           */
{
     prfmsg(SHOMAXD);
     for (n=1 ; n < lotctl.lotinfo[2] ; n++) {
          prfmsg(SHOW2D5,n+1);
     }
     if (dtaptr->dig[0] == 0) {
          prfmsg(SHOCARD1);
     }
     else {
          prfmsg(SHOCARD,dtaptr->dig[0]);
     }
     for (n=1 ; n < lotctl.lotinfo[2] ; n++) {
          if (dtaptr->dig[n] > 0) {
               prfmsg(SHOW2DD,dtaptr->dig[n]);
          }
     }
     prf("\r");
}

STATIC
void
rstcard(void)                 /* Initialize the card data                  */
{
     setmem(dtaptr->dig,sizeof(dtaptr->dig[0])*NDIGS,0);
     dtaptr->curdig=0;
}

void
lotmcu(void)                  /* Pick the numbers, find the winner(s)      */
{
     int dgt;

     dtaptr=&lotdta[0];
     picknums();              /* Pick (lotctl.lotinfo[2]) unique numbers   */
     lotctl.sold=n1=0;
     setbtv(dtabb);
     if (qlobtv(0)) {
          do {
               gabbtv(dtaptr,absbtv(),0);
               cnt=0;
               for (n0=0 ; n0 < lotctl.lotinfo[2] ; n0++) {
                    for (n=0 ; n < lotctl.lotinfo[2] ; n++) {
                         dgt=dtaptr->dig[n];
                         if (dgt == dig[n0]) {
                              cnt+=1;
                              break;
                         }
                    }
               }
               if (cnt == lotctl.lotinfo[2]) {
                    if (n1 < 11) {
                         if (!sameas(winner[n1],dtaptr->uid)) {
                              strcpy(winner[n1],dtaptr->uid);
                              strcpy(lotctl.lastwin[n1++],dtaptr->uid);
                         }
                    }
               }
               delbtv();
          } while (qnxbtv());
          if (n1 > 0) {
               for (n=0 ; n < n1 ; n++) {
                    addcrd(winner[n],l2as((lotctl.jackpot)/n1),0);
               }
               lotctl.lastpot=lotctl.jackpot;
               lotctl.jackpot=lotctl.lotinfo[7];
          }
          else {
               lotctl.jackpot+=lotctl.lotinfo[6];
          }
          lotctl.lotinfo[0]=n1;
     }
     else {
          lotctl.jackpot+=lotctl.lotinfo[6];
     }
     lotupdctl();
}

STATIC
void
picknums(void)                /* This is the routine to pick the numbers   */
{
     int  o,tmp;

     for (n=0 ; n < lotctl.lotinfo[2] ; n++) {
          do {
               cnt=0;
               dig[n]=girnd(1,lotctl.lotinfo[1]);
               for (n1=0 ; n1 < n ; n1++) {
                    if (dig[n] == dig[n1]) {
                         cnt=1;
                    }
               }
          } while (cnt > 0);
          lotctl.lastdig[n]=dig[n];
     }
     for (n=0 ; n < lotctl.lotinfo[2]-1 ; n++) {    /* sort numbers     */
          o=n+1;
          do {
               if (lotctl.lastdig[n] > lotctl.lastdig[o]) {
                    tmp=lotctl.lastdig[n];
                    lotctl.lastdig[n]=lotctl.lastdig[o];
                    lotctl.lastdig[o]=tmp;
               }
          } while (++o < lotctl.lotinfo[2]);
     }
}

STATIC
int
validnum(void)                /* Check numbers selected for validitity     */
{
     if ((n=cncint()) > 0 && n < lotctl.lotinfo[1]+1) {
          dtaptr->dig[dtaptr->curdig]=n;
          for (n0=0 ; n0 < dtaptr->curdig ; n0++) {
               if (dtaptr->dig[dtaptr->curdig] == dtaptr->dig[n0]) {
                    prfmsg(DBLNUM);
                    return(0);
               }
          }
     }
     else {
          prfmsg(NOTRNG2);
          dtaptr->dig[dtaptr->curdig]=0;
          return(0);
     }
     return(1);
}

STATIC
void
lotupdctl(void)               /* Update the control file (total sold, etc) */
{
     setbtv(ctlbb);
     geqbtv(NULL,"key",0);
     updbtv(&lotctl);
     setbtv(dtabb);
}

void
clslot(void)                  /* Finish up and shutdown the lotto module   */
{
     clsmsg(lotmb);
     clsbtv(ctlbb);
     clsbtv(dtabb);
}

STATIC void
ini_rnd(void)       /* Initialize random number seeds - 01/14/90 L. Bird   */
{
     randomize();
}

STATIC int
girnd(low,high)     /* Returns random number between low and high     */
int low,high;
{
     int  z;

     return((z=random(high)) < low ? z+low : z);
}