/***************************************************************************
 *                                                                         *
 *   KYRANDIA, Fantasy-world of Legends                     Version 7.00   *
 *                                                                         *
 *   Copyright (C) 1988-1992 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   KYRUTIL.C (KUTILS.C) - General low-level multi-player game utilities  *
 *                                                                         *
 *   Designed/Programmed by: Scott Brinker & Richard Skurnick   03/18/88   *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "kyrandia.h"
#include "galkyrm.h"

static
struct utlgmp {               /* utility game-player structure             */
     char uidnam[APNSIZ];     /* player's name                             */
     int cinflg;              /* is player invisible? marker               */
} *ugparr;                    /* array declaration                         */
static
int ugasiz;                   /* size of ugparr arry                       */

void
iniutl(void)                       /* initialize utility routines array    */
{
     ugparr=(struct utlgmp *)alczer(ugasiz=nterms*sizeof(struct utlgmp));
}

char *
himher(gp)                         /* display "him/her" for filling a %s   */
struct gmplyr *gp;
{
     return((gp->charms[ALTNAM]) ? "its" : ((gp->flags&FEMALE) ? "her" : "him"));
}

char *
kheshe(gp)                         /* display "he/she" for filling a %s    */
struct gmplyr *gp;
{
     return((gp->charms[ALTNAM]) ? "its" : ((gp->flags&FEMALE) ? "she" : "he"));
}

char *
hisher(gp)                         /* display "his/her" for filling a %s   */
struct gmplyr *gp;
{
     return((gp->charms[ALTNAM]) ? "its" : ((gp->flags&FEMALE) ? "her" : "his"));
}

int
ckinvs(gp)                         /* check to see if someone is invisible */
struct gmplyr *gp;
{
     if (!(gp->flags&INVISF) || (gmpptr->charms[CINVIS])) {
          return(1);
     }
     return(0);
}

void
sndoth(void)                       /* sen message to others in your room   */
{
     int i,loc;
     struct gmplyr *utlgp;

     loc=gmpptr->gamloc;
     if (loc != -1) {
          for (utlgp=gmparr,i=0 ; i < nterms ; utlgp++,i++) {
               if (i != usrnum && utlgp->gamloc == loc) {
                    outprf(i);
               }
          }
     }
     clrprf();
}

void
sndutl(stg)                        /* send a his/her message to others     */
char *stg;
{
     prf("***\r%s is %s\r",gmpptr->altnam,spr(stg,hisher(gmpptr)));
     sndoth();
}

void
sndbt2(void)                       /* send a message to a room to all but  */
{
     int i,loc;
     struct gmplyr *utlgp;

     loc=gmpptr->gamloc;
     if (loc != -1) {
          for (utlgp=gmparr,i=0 ; i < nterms ; utlgp++,i++) {
               if (i != usrnum && i != othusn && utlgp->gamloc == loc) {
                    outprf(i);
               }
          }
     }
     clrprf();
}

void
sndcgp(gp)                         /* send a message to visible people     */
struct gmplyr *gp;
{
     int i,loc;
     struct gmplyr *utlgp;

     loc=gp->gamloc;
     if (loc != -1) {
          for (utlgp=gmparr,i=0 ; i < nterms ; utlgp++,i++) {
               if (utlgp->gamloc == loc && utlgp != gp) {
                    if (!(gp->flags&INVISF) || (utlgp->charms[CINVIS])) {
                         outprf(i);
                   }
               }
          }
     }
     clrprf();
}

void
sndloc(loc)                        /* send a message to specified room     */
int loc;
{
     int i;
     struct gmplyr *utlgp;

     for (utlgp=gmparr,i=0 ; i < nterms ; utlgp++,i++) {
          if (utlgp->gamloc == loc) {
               outprf(i);
          }
     }
     clrprf();
}

void
sndnear(void)                      /* send message to closely located rooms*/
{
     if (gmlptr->gi_north != -1 && gmlptr->gi_north != gmpptr->gamloc) {
          sndloc(gmlptr->gi_north);
     }
     if (gmlptr->gi_south != -1 && gmlptr->gi_south != gmpptr->gamloc) {
          sndloc(gmlptr->gi_south);
     }
     if (gmlptr->gi_east != -1 && gmlptr->gi_east != gmpptr->gamloc) {
          sndloc(gmlptr->gi_east);
     }
     if (gmlptr->gi_west != -1 && gmlptr->gi_west != gmpptr->gamloc) {
          sndloc(gmlptr->gi_west);
     }
     clrprf();
}

void
sndgam(void)                       /* send message to everyone in the game */
{
     int i;
     struct gmplyr *utlgp;

     for (utlgp=gmparr,i=0 ; i < nterms ; utlgp++,i++) {
          if (utlgp->gamloc != -1) {
               outprf(i);
          }
     }
     clrprf();
}

void
remvgp(gp,rmvtxt)                  /* remove a user from the game          */
struct gmplyr *gp;
char *rmvtxt;
{
     prf("***\r%s has just %s!\r",gp->altnam,rmvtxt);
     sndcgp(gp);
     gp->pgploc=gp->gamloc;
     gp->gamloc=-1;
}

void
entrgp(loc,gp,enttxt)              /* place a user into the game           */
int loc;
struct gmplyr *gp;
char *enttxt;
{
     if (loc < 0) {
          loc=0;
     }
     gp->gamloc=gp->pgploc=loc;
     if (gp->flags&BRFSTF) {
          prf("...You're %s.\r",gmlocs[loc].brfdes);
     }
     else {
          setmbk(klmb);
          prfmsg(lcrous[loc].londes);
          setmbk(kmb);
     }
     locobjs(loc);
     locogps(gp);
     outprf(gp->modno);
     prf("***\r%s has just %s!\r",gp->altnam,enttxt);
     sndcgp(gp);
}

extern
int zloc;

void
locobjs(locno)                     /* describe objects in a room           */
int locno;
{
     int i,ntobjs,ncobjs;
     char *olctxt;
     struct gamloc *objloc;
     struct gamobj **lcobjs;
     struct gamobj *vsobjs[MXLOBS];

     objloc=&gmlocs[locno];
     olctxt=objloc->objlds;
     lcobjs=objloc->lcobjs;
     ntobjs=objloc->nlobjs;
     for (i=0,ncobjs=0 ; i < ntobjs ; i++) {
          if (lcobjs[i]->flags&VISIBL) {
               vsobjs[ncobjs]=lcobjs[i];
               ncobjs++;
          }
     }
     setmbk(kmb);
     switch (ncobjs) {
     case 0:
          prfmsg(KUTM00,olctxt);
          break;
     case 1:
          prfmsg(KUTM01,dobutl(vsobjs[0]),olctxt);
          break;
     case 2:
          prfmsg(KUTM02,dobutl(vsobjs[0]),dobutl(vsobjs[1]),olctxt);
          break;
     default:
          prfmsg(KUTM03);
          for (i=0 ; i < ncobjs-1 ; i++) {
               prf("%s, ",dobutl(vsobjs[i]));
          }
          prfmsg(KUTM04,dobutl(vsobjs[i]),olctxt);
     }
     if (dloc == locno) {
          prfmsg(KUTM05);
     }
     if (zloc == locno) {
          prfmsg(KUTM06);
     }
}

void
gi_invrou(void)                    /* main inventory handler               */
{
     prf("...You have ");
     gi_invutl(gmpptr,1);
     outprf(usrnum);
     if (gmpptr->gamloc != -1) {
          prf("***\r%s is taking inventory.\r",gmpptr->altnam);
          sndoth();
     }
}

void
gi_invutl(gp,you)                  /* display objects in user's inventory  */
struct gmplyr *gp;
int you;
{
     struct gamobj **gpobjs;
     int nobjs,i;

     gpobjs=gp->gpobjs;
     switch (nobjs=gp->npobjs) {
     case 0:
          break;
     case 1:
          prf("%s, ",dobutl(gpobjs[0]));
          break;
     case 2:
          prf("%s, %s, ",dobutl(gpobjs[0]),dobutl(gpobjs[1]));
          break;
     default:
          for (i=0 ; i < nobjs ; i++) {
               prf("%s, ",dobutl(gpobjs[i]));
          }
     }
     if (you) {
          prfmsg(KUTM07,gmpptr->gold,(gmpptr->gold == 1 ? "" : "s"));
     }
     else {
          if (gp->npobjs) {
               prfmsg(KUTM08);
          }
          prfmsg(KUTM09,hisher(gp));
     }
}

char *
dobutl(object)                     /* place an "a" or "an" in front of obj */
struct gamobj *object;
{
     static char retval[4][40];
     static int cycle=0;

     cycle=((cycle+1)&3);
     if (object->flags&NEEDAN) {
          strcpy(retval[cycle],"an ");
     }
     else {
          strcpy(retval[cycle],"a ");
     }
     strcat(retval[cycle],object->name);
     return(retval[cycle]);
}

void
locogps(gp)                        /* describe players in current room     */
struct gmplyr *gp;
{
     int i,ncngps;
     struct gmplyr *locogp;

     setmem(ugparr,ugasiz,0);
     for (i=0,ncngps=0 ; i < nterms ; i++) {
          locogp=&gmparr[i];
          if (locogp->gamloc == gp->gamloc && locogp != gp) {
               if (locogp->flags&INVISF) {
                    if (gmpptr->charms[CINVIS]) {
                         strcpy(ugparr[ncngps].uidnam,locogp->plyrid);
                         ugparr[ncngps].cinflg=1;
                         ncngps++;
                    }
               }
               else {
                    strcpy(ugparr[ncngps].uidnam,locogp->altnam);
                    ncngps++;
               }
          }
     }
     switch (ncngps) {
     case 0:
          break;
     case 1:
          prf("%s",ugparr[0].uidnam);
          if (ugparr[0].cinflg) {
               prfmsg(KUTM10);
          }
          prfmsg(KUTM11);
          break;
     case 2:
          prf("%s",ugparr[0].uidnam);
          if (ugparr[0].cinflg) {
               prfmsg(KUTM10);
          }
          prf(" and %s",ugparr[1].uidnam);
          if (ugparr[1].cinflg) {
               prfmsg(KUTM10);
          }
          prfmsg(KUTM12);
          break;
     default:
          for (i=0 ; i < ncngps-1 ; i++) {
               prf("%s",ugparr[i].uidnam);
               if (ugparr[i].cinflg) {
                    prfmsg(KUTM10);
               }
               prf(", ");
          }
          prf("and %s",ugparr[i].uidnam);
          if (ugparr[i].cinflg) {
               prfmsg(KUTM10);
          }
          prfmsg(KUTM12);
     }
}

int
ngpscn(gp)                         /* count users in room with specific usr*/
struct gmplyr *gp;
{
     int i,retval=0;
     struct gmplyr *ogp;

     for (i=0 ; i < nterms ; i++) {
          ogp=&gmparr[i];
          if (ogp->gamloc == gp->gamloc && ogp != gp) {
               if (!(gp->flags&INVISF) || (ogp->charms[CINVIS])) {
                    retval++;
               }
          }
     }
     return(retval);
}

int
ngpslc(locno)                      /* count users in a specified location  */
int locno;
{
     int i,retval=0;

     for (i=0 ; i < nterms ; i++) {
          if (gmparr[i].gamloc == locno) {
               retval++;
          }
     }
     return(retval);
}

int
findgp(stg)                        /* check room for a given player        */
char *stg;
{
     for (ogmptr=gmparr,othusn=0 ; othusn < nterms ; ogmptr++,othusn++) {
          if (ogmptr->gamloc == gmpptr->gamloc) {
               if (sameto(stg,ogmptr->attnam) && ckinvs(ogmptr)) {
                    return(1);
               }
          }
     }
     return(0);
}

int
fgamgp(stg)                        /* check game for a specified player    */
char *stg;
{
     for (ogmptr=gmparr,othusn=0 ; othusn < nterms ; ogmptr++,othusn++) {
          if (ogmptr->gamloc != -1 && sameas(stg,ogmptr->plyrid)) {
               return(1);
          }
     }
     return(0);
}

int
chkobj(obj)                        /* check player for a specified object  */
struct gamobj *obj;
{
     for (objno=0 ; objno < ogmptr->npobjs ; objno++) {
          if (ogmptr->gpobjs[objno] == obj) {
               return(1);
          }
     }
     return(0);
}

struct gamobj *
fndpobj(gp,stg)                    /* check user for specified object name*/
struct gmplyr *gp;
char *stg;
{
     for (objno=0 ; objno < gp->npobjs ; objno++) {
          if (sameto(stg,gp->gpobjs[objno]->name)) {
               return(gp->gpobjs[objno]);
          }
     }
     return(NULL);
}

struct gamobj *
fgmpobj(stg)                       /* check current user for specified obj */
char *stg;
{
     return(fndpobj(gmpptr,stg));
}

struct gamobj *
fndlobj(loc,stg)                   /* check a location for an object       */
struct gamloc *loc;
char *stg;
{
     for (objno=0 ; objno < loc->nlobjs ; objno++) {
          if (sameto(stg,loc->lcobjs[objno]->name)) {
               return(loc->lcobjs[objno]);
          }
     }
     return(NULL);
}

struct gamobj *
fgmlobj(stg)                       /* check current user loc for an object */
char *stg;
{
     return(fndlobj(gmlptr,stg));
}

void
takpobj(gp,objino)                 /* take an object from a player         */
struct gmplyr *gp;
int objino;
{
     if (--(gp->npobjs) != objino) {
          gp->gpobjs[objino]=gp->gpobjs[gp->npobjs];
          gp->obvals[objino]=gp->obvals[gp->npobjs];
     }
}

void
tgmpobj(objino)                    /* take an object from current player   */
int objino;
{
     takpobj(gmpptr,objino);
}

void
taklobj(loc,objino)                /* take an object from a location       */
struct gamloc *loc;
int objino;
{
     loc->nlobjs--;
     if (loc->nlobjs != objino) {
          loc->lcobjs[objino]=loc->lcobjs[loc->nlobjs];
     }
}

void
tgmlobj(objino)                    /* take an object from current usr loc  */
int objino;
{
     taklobj(gmlptr,objino);
}

void
putpobj(gp,obj,value)              /* give a player an object              */
struct gmplyr *gp;
struct gamobj *obj;
int value;
{
     gp->obvals[gp->npobjs]=value;
     gp->gpobjs[(gp->npobjs)++]=obj;
}

void
pgmpobj(obj,value)                 /* give current player an object        */
struct gamobj *obj;
int value;
{
     putpobj(gmpptr,obj,value);
}

void
putlobj(loc,obj)                   /* put an object in a location          */
struct gamloc *loc;
struct gamobj *obj;
{
     loc->lcobjs[(loc->nlobjs)++]=obj;
}

void
pgmlobj(obj)                       /* put an object in current players loc */
struct gamobj *obj;
{
     putlobj(gmlptr,obj);
}

char *
upperc(stg)                        /* capitalize 1st letter-lower case rest*/
char *stg;
{
     char *tmp;
     static char retstg[40];

     retstg[0]=toupper(*stg);
     for (tmp=retstg+1 ; *++stg != '\0' ; ) {
          *tmp++=tolower(*stg);
     }
     *tmp='\0';
     return(retstg);
}

struct binwrd *
binchk(stgptr,table,length)        /* check command array for a word       */
char *stgptr;
struct binwrd table[];
int length;
{
     int cond;
     struct binwrd *low,*mid,*high;

     low=&table[0];
     high=&table[length-1];
     while (low <= high) {
          mid=low+((int)(high-low))/2;
          if ((cond=strcmp(stgptr,mid->word)) < 0) {
               if (mid == low) {
                    break;
               }
               high=mid-1;
          }
          else if (cond > 0) {
               if (mid == high) {
                    break;
               }
               low=mid+1;
          }
          else {
               return(mid);
          }
     }
     return(NULL);
}
