/***************************************************************************
 *                                                                         *
 *   KYRANDIA, Fantasy-world of Legends                     Version 7.00   *
 *                                                                         *
 *   Copyright (C) 1988-1992 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   KYRSYSP.C (KSYSOP.C) - Sysop Editor for KYRANDIA User File            *
 *                                                                         *
 *   Designed/Programmed by: Scott Brinker & Richard Skurnick   03/18/88   *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "kyrandia.h"
#include "kyrspls.h"
#undef LEVEL6
#include "galkyrs.h"
#undef LEVEL6
#include "galkyrm.h"

STATIC void kyrawho(void);
STATIC void kyramnu(void);
STATIC void kyrdsp(void);
STATIC void kyrchg(void);
STATIC void instchg(char *altnam,char *attnam,long flag);
STATIC void gi_kyrspl(void);
STATIC char kyryn(int i);
STATIC void chgspl(int num);
STATIC void kyrsav(void);
STATIC void beusr(int usn);
STATIC void injax(void);
STATIC void kpmt(int news);

int kinuse,kyrasub,grp;

static
char uid[UIDSIZ];

void
kyraedit(void)                     /* Main Entry for Kyrandia Editor       */
{
     int i,j;

     setmbk(ksmb);
     switch (kyrasub) {
     case 0:
          kyrply=(struct gmplyr *)alcmem(sizeof(struct gmplyr));
          kpmt(KYREDT);
          btumil(usrnum,UIDSIZ-1);
          usrptr->substt=90;
          kinuse=1;
          return;
     case KYREDT:
          kyrawho();
          break;
     case KYRMNU:
          kyramnu();
          break;
     case CHGWCH:
          kyrchg();
          break;
     case EDT001:
          if (!margc) {
               kyrdsp();
          }
          else if ((i=atoi(margv[0])) < 1 || i > 5) {
               prfmsg(BADCHO);
               prfmsg(EDT001);
          }
          else {
               switch (i) {
               case 1:
                    instchg(kyrply->plyrid,kyrply->plyrid,0);
                    break;
               case 2:
                    instchg("Some Unseen Force","Unseen Force",INVISF);
                    break;
               case 3:
                    instchg("Some pegasus","pegasus",PEGASU);
                    break;
               case 4:
                    instchg("Some psuedo dragon","psuedo dragon",PDRAGN);
                    break;
               case 5:
                    instchg("Some willowisp","willowisp",WILLOW);
                    break;
               }
          }
          break;
     case EDT002:
          if (!margc) {
               kyrdsp();
          }
          else if ((i=atoi(margv[0])) < 1 || i > 25) {
               prfmsg(BADCHO);
               prfmsg(EDT002);
          }
          else {
               kyrply->level=i;
               if (kyrply->flags&FEMALE) {
                    kyrply->nmpdes=FDES00+i-1;
               }
               else {
                    kyrply->nmpdes=MDES00+i-1;
               }
               kyrply->hitpts=4*kyrply->level;
               kyrply->spts=2*kyrply->level;
               if (i < 9) {
                    kyrply->flags&=~GOTKYG;
               }
               kyrdsp();
          }
          break;
     case EDT003:
          if (!margc) {
               kyrdsp();
          }
          else if ((i=atoi(margv[0])) < 0 || i > 304) {
               prfmsg(BADCHO);
               prfmsg(EDT003);
          }
          else {
               kyrply->pgploc=i;
               kyrdsp();
          }
          break;
     case EDT004:
          if (!margc) {
               kyrdsp();
          }
          else if ((i=atoi(margv[0])) < 1 || i > 32766) {
               prfmsg(BADCHO);
               prfmsg(EDT004);
          }
          else {
               kyrply->gold=(unsigned)i;
               kyrdsp();
          }
          break;
     case EDT005:
          if (!margc) {
               kyrdsp();
          }
          else if ((i=atoi(margv[0])) < 1 || i > 50) {
               prfmsg(BADCHO);
               prfmsg(EDT005);
          }
          else {
               kyrply->spts=(i > (kyrply->level*2) ? kyrply->level*2 : i);
               kyrdsp();
          }
          break;
     case EDT006:
          if (!margc) {
               kyrdsp();
          }
          else if ((i=atoi(margv[0])) < 1 || i > 99) {
               prfmsg(BADCHO);
               prfmsg(EDT006);
          }
          else {
               kyrply->hitpts=(i > (kyrply->level*4) ? kyrply->level*4 : i);
               kyrdsp();
          }
          break;
     case EDT007:
          if (!margc) {
               kyrdsp();
          }
          else if (toupper(*margv[0]) == 'X') {
               kyrply->spouse[0]='\0';
               kyrply->flags&=~MARRYD;
               kyrdsp();
          }
          else {
               makhdl(input);
               setmem(kyrply->spouse,sizeof(UIDSIZ),0);
               movmem(input,kyrply->spouse,UIDSIZ);
               kyrply->flags|=MARRYD;
               kyrdsp();
          }
          break;
     case EDT008:
          if (!margc) {
               kyrdsp();
          }
          else if ((i=atoi(margv[0])) < 0 || i > 6) {
               prfmsg(BADCHO);
               prfmsg(EDT008);
          }
          else {
               if (kyrply->npobjs < i) {
                    for (j=kyrply->npobjs ; j < i ; j++) {
                         kyrply->gpobjs[j]=&gmobjs[2];
                    }
               }
               else {
                    for (j=i ; j < MXPOBS ; j++) {
                         kyrply->gpobjs[j]=NULL;
                    }
               }
               kyrply->npobjs=i;
               kyrdsp();
          }
          break;
     case EDT009:
          gi_kyrspl();
          kpmt(MODSPL);
          break;
     case EDT010:
     case EDT011:
     case EDT012:
     case EDT013:
     case EDT014:
     case EDT015:
          if (!margc) {
               kyrdsp();
          }
          else if ((i=atoi(margv[0])) < 1 || i > 240) {
               prfmsg(BADCHO);
               prfmsg(kyrasub);
          }
          else {
               kyrply->charms[grp]=i;
               kyrdsp();
          }
          break;
     case EDT016:
     case EDT017:
     case EDT018:
     case EDT019:
     case EDT020:
     case EDT021:
          if (!margc) {
               kyrdsp();
          }
          else {
               j=0;
               for (objptr=gmobjs ; objptr < gmobjs+45 ; objptr++) {
                    if (sameto(margv[0],objptr->name)) {
                         j=1;
                         kyrply->gpobjs[grp]=objptr;
                         kyrdsp();
                         break;
                    }
               }
               if (!j) {
                    prfmsg(NOSOBJ);
                    prfmsg(kyrasub);
               }
          }
          break;
     case EDT022:
          if (!margc) {
               kyrdsp();
          }
          else if ((i=atoi(margv[0])) < 0 || i > 4) {
               prfmsg(BADCHO);
               prfmsg(kyrasub);
          }
          else {
               kyrply->gemidx=i;
               kyrdsp();
          }
          break;
     case EDT023:
          if (!margc) {
               kyrdsp();
          }
          else if ((i=atoi(margv[0])) < 0 || i > 12) {
               prfmsg(BADCHO);
               prfmsg(kyrasub);
          }
          else {
               kyrply->stumpi=i;
               kyrdsp();
          }
          break;
     case MODSPL:
          if (!margc) {
               prfmsg(MODSPL);
          }
          else if (sameas(margv[0],"?")) {
               gi_kyrspl();
               prfmsg(MODSPL);
          }
          else if (sameas(margv[0],"x")) {
               kyrdsp();
          }
          else if ((i=atoi(margv[0])) < 1 || i > 67) {
               prfmsg(BADCHO);
               prfmsg(MODSPL);
          }
          else {
               chgspl(i);
               prfmsg(MODSPL);
          }
          break;
     }
     outprf(usrnum);
}

STATIC void
kyrawho(void)                      /* Select User to Edit or Exit to game  */
{

     if (!margc) {
          prfmsg(KYREDT);
     }
     else if (sameas(margv[0],"x")) {
          free(kyrply);
          btupmt(usrnum,'>');
          btuxmt(usrnum,kyratr);
          entrgp(gmpptr->pgploc,gmpptr,"flown down from the heavens on a golden chariot");
          usrptr->substt=7;
          kinuse=kyrasub=0;
          btumil(usrnum,DFTIMX);
          prf("");
     }
     else {
          rstrin();
          makhdl(input);
          movmem(input,uid,UIDSIZ);
          if (sameas(uid,usaptr->userid)) {
               movmem(gmpptr,kyrply,sizeof(struct gmplyr));
               kpmt(KYRMNU);
               btumil(usrnum,DFTIMX);
          }
          else {
               setbtv(kbb);
               if (acqbtv(kyrply,uid,0)) {
                    gi_rest4p(kyrply);
                    kpmt(KYRMNU);
                    btumil(usrnum,DFTIMX);

               }
               else {
                    prfmsg(NOSUCH);
                    prfmsg(KYREDT);
               }
          }
     }
}

STATIC void
kyramnu(void)                      /* Do what to the user selected?        */
{
     if (!margc) {
          kpmt(KYRMNU);
     }
     else {
          switch (toupper(*margv[0])) {
          case 'E':
               kyrdsp();
               break;
          case 'X':
               kyrsav();
               kpmt(KYREDT);
               break;
          case 'A':
               kpmt(KYREDT);
               setmem(kyrply,sizeof(struct gmplyr),0);
               break;
          case '?':
               prfmsg(KYRMNU,kyrply->plyrid);
               break;
          default:
               prfmsg(BADCHO);
               prfmsg(KYRMNU,kyrply->plyrid);
          }
     }
}

STATIC void
kyrdsp(void)                       /* Display the users account info       */
{
     int i;

     prfmsg(KYRAC1,kyrply->plyrid,kyrply->altnam,kyrply->attnam,
                   kyrply->level,kyrply->pgploc,gmlocs[kyrply->pgploc].brfdes,
                   kyrply->gold,kyrply->spts,kyrply->hitpts,
                   (kyrply->spouse[0] == '\0' ? "<None Yet>" : kyrply->spouse),
                   kyrply->npobjs);
     prfmsg(KYRAC2,kyrply->charms[0],kyrply->charms[1],kyrply->charms[2],
                   kyrply->charms[3],kyrply->charms[4],kyrply->charms[5]);
     for (i=0 ; i < 6 ; i++) {
          prfmsg(OBJLST,i+16,
                (i < kyrply->npobjs ? kyrply->gpobjs[i]->name : "---------"));
          if (i == 2 || i == 5) {
               prf("\r");
          }
     }
     prfmsg(KYRAC3,kyrply->gemidx,
             gmobjs[kyrply->stones[0]].name,gmobjs[kyrply->stones[1]].name,
             gmobjs[kyrply->stones[2]].name,gmobjs[kyrply->stones[3]].name,
             kyrply->stumpi);
     kpmt(CHGWCH);
}

STATIC void
kyrchg(void)                       /* Change what aspect of the account    */
{
     int i;

     if (!margc) {
          prfmsg(CHGWCH);
     }
     else if (sameas(margv[0],"x")) {
          kpmt(KYRMNU);
     }
     else if (sameas(margv[0],"?")) {
          kyrdsp();
     }
     else if ((i=atoi(margv[0])) < 1 || i > 23) {
          prfmsg(BADCHO);
          prfmsg(CHGWCH);
     }
     else if (i == 9) {
          gi_kyrspl();
          kpmt(MODSPL);
     }
     else {
          kpmt(EDT001+i-1);
          if (i > 9 && i < 16) {
               grp=i-10;
          }
          if (i > 15 && i < 22) {
               grp=i-16;
          }
     }
}

STATIC void
instchg(altnam,attnam,flag)        /* Change the users alternate names     */
char *altnam,*attnam;
long flag;
{
     strcpy(kyrply->altnam,altnam);
     strcpy(kyrply->attnam,attnam);
     kyrply->flags&=~(INVISF+PEGASU+WILLOW+PDRAGN);
     if (flag) {
          kyrply->flags|=flag;
          if (kyrply->charms[ALTNAM] == 0) {
               kyrply->charms[ALTNAM]=4;
          }
     }
     else {
          kyrply->charms[ALTNAM]=0;
     }
     kyrdsp();
}

STATIC void
gi_kyrspl(void)                       /* Display the spells the user has      */
{
     int i,j,k;

     k=1;
     prf("\r");
     for (i=0 ; i < 13 ; i++) {
          for (j=0 ; j < 5 ; j++,k++) {
               prfmsg(SPLLST,k,spells[k-1].name,kyryn(k-1));
          }
     }
     for (j=0 ; j < 2 ; j++,k++) {
          prfmsg(SPLLST,k,spells[k-1].name,kyryn(k-1));
     }
     prf("\r");
     prfmsg(KSPLS0);
}

STATIC char
kyryn(i)                           /* Display a Y or N for a spell         */
int i;
{
     char retval;

     switch (spells[i].sbkref) {
     case 1:
          if (kyrply->offspls&(spells[i].bitdef)) {
               retval='Y';
          }
          else {
               retval='N';
          }
          break;
     case 2:
          if (kyrply->defspls&(spells[i].bitdef)) {
               retval='Y';
          }
          else {
               retval='N';
          }
          break;
     case 3:
          if (kyrply->othspls&(spells[i].bitdef)) {
               retval='Y';
          }
          else {
               retval='N';
          }
     }
     return(retval);
}

STATIC void
chgspl(num)                        /* Change the flags on a spell          */
int num;
{
     num--;
     splptr=&spells[num];
     switch (splptr->sbkref) {
     case 1:
          if (kyrply->offspls&(splptr->bitdef)) {
               kyrply->offspls&=~(splptr->bitdef);
          }
          else {
               kyrply->offspls|=(splptr->bitdef);
          }
          break;
     case 2:
          if (kyrply->defspls&(splptr->bitdef)) {
               kyrply->defspls&=~(splptr->bitdef);
          }
          else {
               kyrply->defspls|=(splptr->bitdef);
          }
          break;
     case 3:
          if (kyrply->othspls&(splptr->bitdef)) {
               kyrply->othspls&=~(splptr->bitdef);
          }
          else {
               kyrply->othspls|=(splptr->bitdef);
          }
          break;
     }
}


STATIC void
kyrsav(void)                       /* Save changes back to the account     */
{
     int hldusn;
     extern int kyrstt;

     setbtv(kbb);
     if (!onsysn(kyrply->uidnam,1) || !(gmparr[othusn].flags&LOADED)) {
          if (acqbtv(NULL,kyrply->uidnam,0)) {
               gi_prep4d(kyrply);
               updbtv(kyrply);
               prfmsg(RECUPD);
          }
          else {
               prfmsg(RECNPD);
          }
     }
     else {
          hldusn=usrnum;
          beusr(othusn);
          if (usrptr->state == kyrstt && usrptr->substt == 7) {
               injax();
          }
          movmem(kyrply,gmpptr,sizeof(struct gmplyr));
          if (acqbtv(NULL,kyrply->uidnam,0)) {
               gi_prep4d(kyrply);
               updbtv(kyrply);
          }
          beusr(hldusn);
          setmbk(ksmb);
          prfmsg(RECUPD);
     }
     setmem(kyrply,sizeof(struct gmplyr),0);
}

STATIC void
beusr(usn)                         /* act as a usrnum for a minute         */
int usn;
{
     curusr(usn);
     gmpptr=&gmparr[usrnum];
}

STATIC void
injax(void)                        /* inject an 'X' to current channel     */
{                                  /*    (re-prompt current text)          */
     usrptr->flags|=INJOIP;
     status=CRSTG;
     clrinp();
     strcpy(input,"x");
     parsin();
     hdlinp();
     usrptr->flags&=~INJOIP;
}

STATIC void
kpmt(news)                         /* Print generic prompts and set substt */
int news;
{
     switch (kyrasub=news) {
     case KYRMNU:
          prfmsg(news,uid);
          break;
     default:
          prfmsg(news);
     }
}
