/***************************************************************************
 *                                                                         *
 *   KYRANDIA, Fantasy-world of Legends                     Version 7.00   *
 *                                                                         *
 *   Copyright (C) 1988-1992 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   KYRPROT.C (KRIGHTS.C) - Load/Save data structures                     *
 *                                                                         *
 *   Designed/Programmed by: Scott Brinker & Richard Skurnick   03/18/88   *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "kyrandia.h"
#include "galkyrm.h"
#undef LEVEL6
#include "galkyrl.h"

char *cright[3]={
     "   Multi-player Gaming System",
     "Copyright (C) 1988-92 Galacticomm",
     "       All rights reserved."
};

extern
char gamver[];

int
loadkp(void)                       /* load player data from btrieve file   */
{
     return(acqbtv(gmpptr,usaptr->userid,0));
}

void
rights(void)                       /* display copyright & put user in game */
{
     int i;

     gmpptr->modno=usrnum;
     gi_rest4p(gmpptr);
     prf("\r");
     for (i=0 ; i < 3 ; i++) {
          prf("%s\r",cright[i]);
     }
     prf("\r");
     gi_invrou();
     if (usrptr->flags&MASTER) {
          entrgp(gmpptr->pgploc,gmpptr,
              "arrived in the arms of the Goddess Tashanna");
     }
     else {
          entrgp(gmpptr->pgploc,gmpptr,
              "appeared in a crackling flash of purple lightning");
     }
     usrptr->substt=7;
}

void
gi_prep4d(gp)                      /* prepare data to be saved to disk     */
struct gmplyr *gp;
{
     int i;

     for (i=0 ; i < gp->npobjs ; i++) {
          gp->gpobjs[i]=(struct gamobj *)(gp->gpobjs[i]-gmobjs);
     }
     for (i=0 ; i < gp->nspells ; i++) {
          gp->spells[i]=(struct spell *)(gp->spells[i]-spells);
     }
}

void
gi_rest4p(gp)                      /* prepare disk data for online use     */
struct gmplyr *gp;
{
     int i;

     for (i=0 ; i < gp->npobjs ; i++) {
          gp->gpobjs[i]=&gmobjs[(int)gp->gpobjs[i]];
     }
     for (i=0 ; i < gp->nspells ; i++) {
          gp->spells[i]=&spells[(int)gp->spells[i]];
     }
}

