/***************************************************************************
 *                                                                         *
 *   KYRANDIA, Fantasy-world of Legends                     Version 7.00   *
 *                                                                         *
 *   Copyright (C) 1988-1992 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   KYROBJR.C (KOBJROUS.C) - Item routines and vector handling            *
 *                                                                         *
 *   Designed/Programmed by: Scott Brinker & Richard Skurnick   03/18/88   *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "kyrandia.h"
#include "galkyrm.h"
#undef LEVEL6
#include "galkyrl.h"

STATIC void nohutl(void);

void
youmsg(msgnum)                     /* send message to current user         */
int msgnum;
{
     prfmsg(msgnum);
     outprf(usrnum);
}

void
rubber(void)                       /* rubbing an item command handling     */
{
     gi_bagthe();
     if (margc == 1) {
          youmsg(OBJM00);
          sndutl("acting silly.");
     }
     else if ((objptr=fgmpobj(margv[1])) == NULL) {
          nohutl();
     }
     else {
          if (objptr->flags&RUBABL) {
               (*(objptr->objrou))();
          }
          else {
               youmsg(OBJM01);
               sndutl("rubbing something.");
          }
     }
}

void
thinkr(void)                       /* thinking of an item command handling */
{
     bagprep();
     if (margc > 2 && (objptr=fgmpobj("amulet")) != NULL) {
          if (fgamgp(margv[1])) {
               youmsg(OBJM02);
               rstrin();
               prf("A voice in your mind says: %s\r",margv[2]);
               outprf(ogmptr->modno);
               return;
          }
     }
     gi_bagthe();
     if (margc == 1) {
          youmsg(OBJM03);
          sndutl("thinking about life.");
     }
     else if ((objptr=fgmpobj(margv[1])) == NULL) {
          nohutl();
     }
     else {
          if (objptr->flags&THIABL) {
               (*(objptr->objrou))();
          }
          else {
               youmsg(OBJM04);
               sndutl("thinking of %s possesions.");
          }
     }
}

void
aimer(void)                        /* aiming a item command handling       */
{
     gi_bagthe();
     if (margc == 1) {
          youmsg(OBJM03);
          sndutl("pointing wildly.");
     }
     else if ((objptr=fgmpobj(margv[1])) == NULL) {
          if (pfnlvl > 1) {
               youmsg(OBJM01);
               sndutl("playing with %s body parts!");
          }
          else {
               nohutl();
          }
     }
     else if (margc < 4) {
          youmsg(OBJM05);
          sndutl("waving %s arms.");
     }
     else if (!findgp(margv[3])) {
          youmsg(OBJM06);
          sndutl("seeing ghosts!");
     }
     else {
          if (objptr->flags&AIMABL) {
               (*(objptr->objrou))();
          }
          else {
               youmsg(OBJM04);
               sndutl("waving obscenely!");
          }
     }
}

void
drinkr(void)                       /* drinking something command handling  */
{
     gi_bagthe();
     if (margc == 1) {
          youmsg(OBJM07);
          sndutl("having a drinking problem.");
     }
     else if ((objptr=fgmpobj(margv[1])) == NULL) {
          nohutl();
     }
     else {
          if (objptr->flags&DRIABL) {
               youmsg(OBJM08);
               sndutl("drinking something quickly.");
               tgmpobj(objno);
               (*(objptr->objrou))();
          }
          else {
               youmsg(OBJM07);
               sndutl("looking thirsty!");
          }
     }
}

STATIC void
nohutl(void)                       /* doing something to non-existant item */
{
     youmsg(OBJM09);
     sndutl("having wild dreams.");
}
