/***************************************************************************
 *                                                                         *
 *   KYRANDIA, Fantasy-world of Legends                     Version 7.00   *
 *                                                                         *
 *   Copyright (C) 1988-1992 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   KYRANIM.C (ANIMATOR.C) - Creature animation routines and timers       *
 *                                                                         *
 *   Designed/Programmed by: Scott Brinker & Richard Skurnick   03/18/88   *
 *                                      6.0 Conversion - E. Bush 3/12/92   *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galkyrm.h"
#include "kyrandia.h"

STATIC struct gmplyr *rndlgp(int loc);
STATIC int zarfood(void);
STATIC void rmvzar(int msgno);
STATIC void pzinlc(int loc,int msgno);
STATIC void dthbyz(void);
STATIC void dryads(void);
STATIC void elves(void);
STATIC void browns(void);
STATIC void gemakr(void);
STATIC void zarapp(void);

int dloc=0;                   /* dryad's current location number           */
struct gamloc *dryloc;        /* pointer to dryad's current location       */
int bpath[40]={               /* path of movement for the brownie          */
     71,144,66,29,82,96,136,31,114,134,
     67,52,103,53,43,150,137,18,0,129,
     168,77,133,92,61,101,73,99,69,111,
     45,132,3,2,55,60,160,48,70,112
};
int bpidx=0;                  /* current path index for the brownie        */
int bloc=0;                   /* brownie's current location number         */

#define ZARHOM  302           /* Zar's "home" location number              */
int zloc=0;                   /* Zar's current location number             */
struct gamloc *zarloc;        /* pointer to Zar's current location         */
int zstat=0;                  /* Zar's current status  (sleep,move,fly)    */
int zattck=0;                 /* Zar's next form of attack (bite,etc.)     */
int ngpszl=0;                 /* number of players in Zar's cur. location  */
#define BITE    0             /* Zar's next attack will be to bite player  */
#define BREATH  1             /* Zar's next attack will be to breath on gp */
#define CLAW    2             /* Zar's next attack will be to claw player  */
#define LIGHTN  3             /* Zar's next attack will be to lightning gp */

int sesame;
int chantd;
int rockpr;

void
inianm(void)
{
     pzinlc(ZARHOM,HLPFAN);
     rtkick(30,animat);
}

STATIC struct gmplyr *
rndlgp(loc)                        /* find a player at specified location  */
int loc;
{
     int i;
     struct gmplyr *jnkgp;

     for (jnkgp=gmparr,i=0 ; i < nterms ; jnkgp++,i++) {
          if (jnkgp->gamloc == loc) {
               return(jnkgp);
          }
     }
     return(NULL);
}

void
animat(void)                       /* rtkick main animation handler        */
{
     static int var;

     setmbk(kmb);
     chkzar();
     switch (var) {
     case 0:
          dryads();
          break;
     case 1:
          elves();
          break;
     case 2:
     case 3:
          gemakr();
          break;
     case 4:
          zarapp();
          break;
     default:
          browns();
          var=-1;
     }
     if (sesame) {
          prfmsg(WALM05);
          sndloc(185);
          sesame=0;
     }
     if (chantd) {
          chantd=0;
          prf("***\rThe altar stops glowing.\r");
          sndloc(7);
     }
     if (rockpr) {
          rockpr=0;
          prf("***\rThe mists settle down.\r");
          sndloc(27);
     }
     var++;
     rtkick(15,animat);
}

void
chkzar(void)                       /* manage Zar's activities              */
{
     static int zarctr=0;

     if (zarctr > 24) {
          rmvzar(ZMSG00);
          pzinlc(ZARHOM,ZMSG01);
          zarctr=0;
     }
     else if (zarctr < 5) {
          zarfood();
     }
     else {
          if (!zarfood()) {
               rmvzar(ZMSG00);
               pzinlc(genrdn(219,300),ZMSG01);
          }
     }
     zarctr++;
}

void
zaritm(void)                       /* handle using a dragonstaff           */
{
     sndutl("rubbing %s dragonstaff!");
     if (zloc == gmpptr->gamloc) {
          prfmsg(ZMSG12);
          prfmsg(ZMSG14);
          outprf(usrnum);
          tgmpobj(objno);
          zarfood();
     }
     else {
          tgmpobj(objno);
          prfmsg(ZMSG13);
          outprf(usrnum);
          rmvzar(ZMSG10);
          pzinlc(gmpptr->gamloc,ZMSG11);
          prfmsg(ZMSG14);
          outprf(usrnum);
          if ((genrdn(0,2)) == 1) {
               zarfood();
          }
     }
}

STATIC int
zarfood(void)                      /* attack users in Zar's room           */
{
     if (ngpslc(zloc)) {
          dthbyz();
          return(1);
     }
     return(0);
}

STATIC void
rmvzar(msgno)                      /* remove Zar from a room               */
int msgno;
{
     if ((objptr=fndlobj(zarloc,"dragon")) == NULL) {
          catastro("KYRANDIA ERROR: ZAR ON LOOSE");
     }
     taklobj(zarloc,objno);
     prfmsg(msgno);
     sndloc(zloc);
}

STATIC void
pzinlc(loc,msgno)                  /* pur Zar in a room                    */
int loc,msgno;
{
     int retdry=0;

     if ((objptr=fndlobj(&gmlocs[loc],"dryad")) == NULL) {
     }
     else {
          retdry=1;
     }
     zloc=loc;
     zarloc=&gmlocs[loc];
     zarloc->nlobjs=0;
     putlobj(zarloc,&gmobjs[52]);
     switch (loc) {
     case 0:
          putlobj(zarloc,&gmobjs[46]);
          break;
     case 7:
          putlobj(zarloc,&gmobjs[47]);
          break;
     case 9:
          putlobj(zarloc,&gmobjs[48]);
          break;
     case 42:
          putlobj(zarloc,&gmobjs[49]);
          break;
     case 101:
          putlobj(zarloc,&gmobjs[50]);
          break;
     case 186:
          putlobj(zarloc,&gmobjs[51]);
          break;
     case 295:
          putlobj(zarloc,&gmobjs[53]);
          break;
     }
     if (retdry) {
          putlobj(zarloc,&gmobjs[45]);
     }
     prfmsg(msgno);
     sndloc(loc);
}

STATIC void
dthbyz(void)                       /* attack each user in a different way  */
{
     int i;

     prfmsg(ZMSG02);
     sndloc(zloc);
     for (gmpptr=gmparr,i=0 ; i < nterms ; gmpptr++,i++) {
          if (zattck == 4) {
               zattck=BITE;
          }
          if (gmpptr->gamloc == zloc && gmpptr->level < 25) {
               prfmsg(ZMSG07,gmpptr->altnam);
               sndoth();
               switch (zattck) {
               case BITE:
                    prfmsg(ZMSG03);
                    outprf(gmpptr->modno);
                    ogmptr=gmpptr;
                    hitoth(16);
                    break;
               case BREATH:
                    prfmsg(ZMSG04);
                    outprf(gmpptr->modno);
                    if (gmpptr->charms[FIRPRO]) {
                         ogmptr=gmpptr;
                         hitoth(28);
                    }
                    else {
                         ogmptr=gmpptr;
                         hitoth(48);
                    }
                    break;
               case CLAW:
                    prfmsg(ZMSG05);
                    outprf(gmpptr->modno);
                    ogmptr=gmpptr;
                    hitoth(12);
                    break;
               case LIGHTN:
                    prfmsg(ZMSG06);
                    outprf(gmpptr->modno);
                    if (gmpptr->charms[LIGPRO]) {
                         ogmptr=gmpptr;
                         hitoth(16);
                    }
                    else {
                         ogmptr=gmpptr;
                         hitoth(32);
                    }
               }
          }
          zattck++;
     }
}

STATIC void
dryads(void)                       /* have the dryads do something         */
{
     int drnd;

     if ((objptr=fndlobj(&gmlocs[dloc],"dryad")) == NULL) {
          catastro("KYRANDIA ERROR: DRYAD ON LOOSE");
     }
     drnd=genrdn(12,168);
     if (drnd != dloc) {
          prfmsg(DMSG00);
          sndloc(dloc);
          dryloc=&gmlocs[dloc];
          taklobj(dryloc,objno);
          dloc=drnd;
          dryloc=&gmlocs[dloc];
          if (dryloc->nlobjs == MXLOBS) {
               prfmsg(DMSG01,dryloc->lcobjs[MXLOBS-1]->name,dryloc->objlds);
               taklobj(dryloc,MXLOBS-1);
          }
          putlobj(dryloc,&gmobjs[45]);
          prfmsg(DMSG02);
          sndloc(dloc);
     }
}

STATIC void
elves(void)                        /* have the elves do something          */
{
     static hints[10]={
          EHINT0,EHINT1,EHINT2,EHINT3,EHINT4,
          EHINT5,EHINT6,EHINT7,EHINT8,EHINT9
     };
     static int erand,ehidx;
     int gold,eloc;

     eloc=genrdn(12,168);
     if ((gmpptr=rndlgp(eloc)) != NULL) {
          prfmsg(EMSG00);
          sndloc(eloc);
          if (erand) {
               gold=genrdn(2,11);
               gmpptr->gold+=gold;
               prfmsg(EMSG01,gold);
               outprf(gmpptr->modno);
               prfmsg(EMSG02,gmpptr->altnam,gold);
               sndoth();
               erand=0;
          }
          else {
               if (ehidx > 9) {
                    ehidx=0;
               }
               prfmsg(hints[ehidx]);
               outprf(gmpptr->modno);
               prfmsg(EMSG03,gmpptr->altnam);
               sndoth();
               ehidx++;
               erand=1;
          }
          prfmsg(EMSG04);
          sndloc(eloc);
     }
}

STATIC void
browns(void)                       /* have the brownies do something       */
{
     if (bpidx > 39) {
          bpidx=0;
     }
     bloc=bpath[bpidx];
     if ((gmpptr=rndlgp(bloc)) != NULL) {
          prfmsg(BMSG00);
          sndloc(bloc);
          if (gmpptr->gold > 0) {
               prfmsg(BMSG01);
               outprf(gmpptr->modno);
               prfmsg(BMSG02,gmpptr->altnam,himher(gmpptr));
               sndoth();
               gmpptr->gold=0;
          }
          else if (gmpptr->npobjs > 0) {
               prfmsg(BMSG03);
               outprf(gmpptr->modno);
               prfmsg(BMSG04,gmpptr->altnam);
               sndoth();
               gmpptr->npobjs=0;
          }
          else {
               prfmsg(BMSG05);
               outprf(gmpptr->modno);
               prfmsg(BMSG06,gmpptr->altnam);
               sndoth();
          }
          prfmsg(BMSG07);
          sndloc(bloc);
     }
     bpidx++;
}

STATIC void
gemakr(void)                       /* place a gem in a random location     */
{
     static int gemctr;
     int floc,gemno;

     floc=genrdn(44,168);     /* forest locations */
     oglptr=&gmlocs[floc];
     if (oglptr->nlobjs < 4) {
          if (gemctr == 10) {
               gemno=genrdn(0,12);
               gemctr=0;
          }
          else {
               gemctr++;
               gemno=2;
          }
          putlobj(oglptr,&gmobjs[gemno]);
          prfmsg(GEMAPP,gmobjs[gemno].name);
          sndloc(floc);
     }
}

STATIC void
zarapp(void)                       /* send a zar sighted warning message   */
{
     int i;

     i=genrdn(0,168);
     prfmsg(ZARABO);
     sndloc(i);
}
