/***************************************************************************
 *                                                                         *
 *   HANGMAN.C                                                             *
 *                                                                         *
 *   Copyright (C) 1987-1993 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   This is a simple Hangman game.                                        *
 *                                                                         *
 *                                  - T. Stryker and S. Brinker 4/2/88     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "bbsutils.h"
#include "galhang.h"

void EXPORT init__hangman(void);
STATIC int hanger(void);
STATIC void chkwrg(int msg,char c);
STATIC void plcbet(void);
STATIC void shtmnu(void);
STATIC void loseit(void);
STATIC void getrwd(char *buffer);
STATIC int pguess(char c,char *realw,char *showw,char gesses[26]);
STATIC void cpyrts(char *realw,char *showw);
STATIC void fndtop(void);
STATIC void dsptop(void);
STATIC void savhan(void);
STATIC void hanhup(void);
STATIC void clshan(void);

int hanstt;                   /* module number for hangman            */
struct module hangman={       /* module interface block               */
     "",                      /*    name used to refer to this module */
     NULL,                    /*    user logon supplemental routine   */
     hanger,                  /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     hanhup,                  /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     clshan                   /*    finish-up (sys shutdown) routine  */
};

static
FILE *hanmb;                  /* sys info named-message file block pointer */
static
FILE *hangfp;

static
BTVFILE *hanbb;

static
int sbt;                      /* size of total top scores sort area        */

static
long vflen;                   /* size of vocab file                        */

#define BAKOFF 80             /* maximum size of any line, plus some       */


/*------------------------ Configuration Options --------------------------*/
int ntops,                    /* number of top scores maintained           */
    nwrong,                   /* maximum number of wrong guesses allowed   */
    hngcrr;                   /* credits consumed while in hangman         */
static
long minbet,                  /* minimum allowable bet                     */
     maxbet;                  /* maximum allowable bet                     */
/*-------------------------------------------------------------------------*/

static
struct hanrec {
     char userid[UIDSIZ];
     long chips;
} *hrecs,*hrptr,*hantop;

static
struct hangem {
     char realw[BAKOFF];
     char showw[BAKOFF];
     char gesses[27];
     long wager;
     int numwrg;
     int flags;
};

#define hptr ((struct hangem *)vdaptr)

#define LOADED 1

void EXPORT
init__hangman(void)
{
     stzcpy(hangman.descrp,gmdnam("GALHNG.MDF"),MNMSIZ);
     hanstt=register_module(&hangman);
     hanmb=opnmsg("galhang.mcv");
     hanbb=opnbtv("galhang.dat",sizeof(struct hanrec));
     ntops=numopt(NTOPS,5,25);
     nwrong=numopt(NWRONG,5,10);
     hngcrr=numopt(HNGCRR,0,32767);
     minbet=lngopt(MINBET,2L,10000L);
     maxbet=lngopt(MAXBET,3L,50000L);
     if (maxbet <= minbet) {
          catastro("HANG: MAX BET MUST BE GREATER");
     }
     hrecs=(struct hanrec *)alczer(nterms*sizeof(struct hanrec));
     hantop=(struct hanrec *)alczer(sbt=(ntops*sizeof(struct hanrec)));
     if ((hangfp=fopen("galhvo.txt",FOPRB)) == NULL) {
          catastro("CAN'T OPEN GALHVO.TXT");
     }
     for (vflen=0 ; fgetc(hangfp) != EOF ; vflen++) {
     }
     if (vflen <= BAKOFF+10) {
          catastro("GALHVO.TXT IS TOO SMALL!");
     }
     dclvda(sizeof(struct hangem));
}

STATIC int
hanger(void)
{
     int fnd;
     char c;
     long wager;

     setmbk(hanmb);
     setbtv(hanbb);
     hrptr=&hrecs[usrnum];
     switch (usrptr->substt) {
     case 0:
          if (!(hptr->flags&LOADED)) {
               if (!acqbtv(hrptr,usaptr->userid,0)) {
                    setmem(hrptr,sizeof(struct hanrec),0);
                    strcpy(hrptr->userid,usaptr->userid);
                    hrptr->chips=minbet*10L;
                    insbtv(hrptr);
               }
               if (hrptr->chips < minbet*10L) {
                    hrptr->chips=minbet*10L;
               }
          }
          hptr->flags|=LOADED;
          dspmsg(NTWMNU,l2as(hrptr->chips));
          usrptr->substt=1;
          break;
     case 1:
          if (margc == 0) {
               shtmnu();
          }
          else {
               switch (toupper(*margv[0])) {
               case 'G':
                    prfmsg(GENINF,nwrong,l2as(minbet),l2as(maxbet));
                    shtmnu();
                    break;
               case 'T':
                    fndtop();
                    dsptop();
                    shtmnu();
                    break;
               case 'H':
                    if (!hasmkey(HNGKEY)) {
                         prfmsg(PAYONL);
                         shtmnu();
                    }
                    else if (hrptr->chips < minbet) {
                         prfmsg(NOTENO,l2as(minbet));
                         shtmnu();
                    }
                    else {
                         plcbet();
                         usrptr->substt=2;
                         usrptr->crdrat=hngcrr;
                    }
                    break;
               case 'X':
                    savhan();
                    prfmsg(EXIMSG);
                    outprf(usrnum);
                    return(0);
               case '?':
                    dspmsg(NTWMNU,l2as(hrptr->chips));
                    break;
               default:
                    prfmsg(NOSUCH);
                    shtmnu();
               }
          }
          break;
     case 2:
          if (margc == 0) {
               plcbet();
          }
          else if (sameas(margv[0],"x")) {
               prfmsg(CHICKN);
               shtmnu();
               usrptr->crdrat=mmucrr;
          }
          else if (!isalpha(*margv[0])) {
               wager=atol(margv[0]);
               if (wager < minbet) {
                    prfmsg(BEREAL,l2as(minbet));
                    plcbet();
               }
               else if (wager > maxbet) {
                    prfmsg(TOOHIB,l2as(maxbet));
                    plcbet();
               }
               else if (wager > hrptr->chips) {
                    prfmsg(CHEATR);
                    plcbet();
               }
               else {
                    hptr->wager=wager;
                    hptr->numwrg=0;
                    getrwd(hptr->realw);
                    cpyrts(hptr->realw,hptr->showw);
                    setmem(hptr->gesses,26,' ');
                    prfmsg(HERESW,hptr->showw);
                    usrptr->substt=3;
               }
          }
          else {
               plcbet();
          }
          break;
     case 3:
          switch (margc) {
          case 0:
               prfmsg(WORDIS,l2as(hptr->wager),hptr->numwrg,hptr->gesses,
                                                                  hptr->showw);
               break;
          case 1:
               if (*margv[0] == '*') {
                    hrptr->chips-=(wager=(hptr->wager/2L));
                    prfmsg(QUITER,l2as(wager));
                    shtmnu();
                    usrptr->crdrat=mmucrr;
                    break;
               }
               else if (strlen(margv[0]) == 1) {
                    c=tolower(*margv[0]);
                    if ((fnd=pguess(c,hptr->realw,hptr->showw,
                                                  hptr->gesses)) > 0) {
                         if (strcmp(hptr->showw,hptr->realw) == 0) {
                              prfmsg(MATCHD,fnd,c,hptr->realw,
                                            l2as(hptr->wager));
                              hrptr->chips+=hptr->wager;
                              shtmnu();
                              usrptr->crdrat=mmucrr;
                         }
                         else {
                              prfmsg(ZOWIE,fnd,c,l2as(hptr->wager),
                                     hptr->numwrg,hptr->gesses,hptr->showw);
                         }
                    }
                    else if (fnd < 0) {
                         chkwrg(BOOHSS,c);
                    }
                    else {
                         chkwrg(MISSED,c);
                    }
                    break;
               }
          default:
               rstrin();
               if (sameas(margv[0],hptr->realw)) {
                    hrptr->chips+=hptr->wager;
                    hrptr->chips+=(wager=(hptr->wager/4L));
                    prfmsg(YOUWIN,hptr->realw,l2as(hptr->wager),
                                              l2as(wager));
                    shtmnu();
                    usrptr->crdrat=mmucrr;
               }
               else {
                    loseit();
               }
          }
     }
     outprf(usrnum);
     return(1);
}

STATIC void
chkwrg(msg,c)
int msg;
char c;
{
     hptr->numwrg+=1;
     if (hptr->numwrg == nwrong) {
          loseit();
     }
     else {
          prfmsg(msg,c,l2as(hptr->wager),hptr->numwrg,hptr->gesses,hptr->showw);
     }
}

STATIC void
plcbet(void)
{
     prfmsg(PLCBET,l2as(hrptr->chips));
}

STATIC void
shtmnu(void)
{
     prfmsg(SHTMNU,l2as(hrptr->chips));
     usrptr->substt=1;
}

STATIC void
loseit(void)
{
     hrptr->chips-=hptr->wager;
     prfmsg(YOULUZ,l2as(hptr->wager));
     shtmnu();
     usrptr->crdrat=mmucrr;
}

STATIC void
getrwd(buffer)
char *buffer;
{
     fseek(hangfp,lngrnd(0L,vflen-BAKOFF),0);
     while (fgetc(hangfp) != '\n') {
     }
     while ((*buffer++=fgetc(hangfp)) != '\r') {
     }
     *--buffer='\0';
}

STATIC int
pguess(c,realw,showw,gesses)
char c;
char *realw,*showw;
char gesses[26];
{
     int found;

     if (!isalpha(c)) {
          return(0);
     }
     if (gesses[c-'a'] != ' ') {
          return(-1);
     }
     gesses[c-'a']=toupper(c);
     for (found=0 ; *realw != '\0' ; realw++,showw++) {
          if (tolower(*realw) == c) {
               *showw=*realw;
               found+=1;
          }
     }
     return(found);
}

STATIC void
cpyrts(realw,showw)
char *realw,*showw;
{
     char c;

     while ((c=*realw++) != '\0') {
          *showw++=(c == ' ' ? c : '-');
     }
     *showw='\0';
}

STATIC void
fndtop(void)
{
     int i=1;

     if (qeqbtv(usaptr->userid,0)) {
          gcrbtv(NULL,0);
          updbtv(hrptr);
     }
     setmem(hantop,sbt,0);
     if (qhibtv(1)) {
          gcrbtv(&hantop[0],1);
          while (qprbtv() && i < ntops) {
               gcrbtv(&hantop[i],1);
               i+=1;
          }
     }
}

STATIC void
dsptop(void)
{
     int i;

     dspmsg(HANHDR);
     for (i=0 ; i < ntops ; i++) {
          dspmsg(HANSCR,i+1,hantop[i].userid,l2as(hantop[i].chips));
     }
     dspmsg(HANBOT);
}

STATIC void
savhan(void)
{
     setbtv(hanbb);
     if (hptr->flags&LOADED) {
          if (qeqbtv(usaptr->userid,0)) {
               gcrbtv(NULL,0);
               strcpy(hrptr->userid,usaptr->userid);
               updbtv(hrptr);
          }
     }
}

STATIC void
hanhup(void)
{
     hrptr=&hrecs[usrnum];
     if (usrptr->state == hanstt) {
          savhan();
     }
     setmem(hrptr,sizeof(struct hanrec),0);
}

STATIC void
clshan(void)
{
     clsmsg(hanmb);
     clsbtv(hanbb);
     if (hangfp != NULL) {
          fclose(hangfp);
     }
}
