###############################################################################
#####    This Makefile generates the GALKYR.DLL for the Kyrandia Add-on   #####
###############################################################################

.autodepend
.silent
.path.c=\bbsv6\src
.path.h=\bbsv6\src
.path.dll=\bbsv6
.path.msg=\bbsv6
.path.obj=\bbsv6\phobj

galkyr.dll: \
     galkyrl.h      galkyrm.h      galkyrs.h                               \
     kyraloc.obj    kyrandia.obj   kyranim.obj    kyrcmds.obj              \
     kyrlocs.obj    kyrobjr.obj    kyrobjs.obj    kyrprot.obj              \
     kyrrous.obj    kyrspel.obj    kyrsysp.obj    kyrutil.obj              \
     gamutils.obj                                                          \
     \bbsv6\dlib\galimp.lib        \bbsv6\dlib\gsblimp.lib                 \
     \run286\bc3\lib\phapi.lib   \bbsv6\dlib\nodef.def
     ltdll galkyr

###############################################################################
#####                 Build Objects For GALKYR DLL                        #####
###############################################################################

kyraloc.obj: kyraloc.c
     ctdll kyraloc

kyrandia.obj: kyrandia.c
     ctdll kyrandia

kyranim.obj: kyranim.c
     ctdll kyranim

kyrcmds.obj: kyrcmds.c
     ctdll kyrcmds

kyrlocs.obj: kyrlocs.c
     ctdll kyrlocs

kyrobjr.obj: kyrobjr.c
     ctdll kyrobjr

kyrobjs.obj: kyrobjs.c
     ctdll kyrobjs

kyrprot.obj: kyrprot.c
     ctdll kyrprot

kyrrous.obj: kyrrous.c
     ctdll kyrrous

kyrspel.obj: kyrspel.c
     ctdll kyrspel

kyrsysp.obj: kyrsysp.c
     ctdll kyrsysp

kyrutil.obj: kyrutil.c
     ctdll kyrutil

gamutils.obj: gamutils.c
     ctdll gamutils

###############################################################################
#####               Generate Headers for Compilation                      #####
###############################################################################

galkyrl.h: galkyrl.msg
     cd \bbsv6
     bbsmsx galkyrl -osrc
     cd \bbsv6\src

galkyrm.h: galkyrm.msg
     cd \bbsv6
     bbsmsx galkyrm -osrc
     cd \bbsv6\src

galkyrs.h: galkyrs.msg
     cd \bbsv6
     bbsmsx galkyrs -osrc
     cd \bbsv6\src

