/***************************************************************************
 *                                                                         *
 *   FLASH.H                                                               *
 *                                                                         *
 *   Copyright (C) 1988-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is The Major BBS remote-program interface, designed for use      *
 *   as an adjunct to the teleconference.                                  *
 *                                                                         *
 *                                            - T. Stryker 5/26/89         *
 *                                                                         *
 ***************************************************************************/

/* Define to compile with/without Chatlink                                 */
#define DOCLINK

#define CHPERP  10            /* maximum channels per pool                 */
#define SHPERP   6            /* maximum "shareware" channels per pool     */
#define PDSIZE 512            /* pool data history size                    */
#define PDMASK (PDSIZE-1)     /* pool data wraparound mask                 */
#define NPOOLS  10            /* maximum number of pools                   */
#define GNSIZE  20            /* game name size maximum (including the \0) */
#define GVSIZE   6            /* game version size max (including the \0)  */

extern
struct pool {
     unsigned tlcchn;
     char gamnam[GNSIZE];
     char gamver[GVSIZE];
     int nchans;
     struct fapyr *faps[CHPERP];
     int nxtbyt;
     int prttyp;
     char pdata[PDSIZE];      /* must be last element of structure         */
} *pools,*piptr,*pbptr;

extern
struct fapyr {
     int chno;
     int nxxbyt;
     int bytoff;
     int cancnt;
     struct pool *poolpt;
     int oneten;
     long serno;
     char alias[10];
     int fflags;              /* must be last element of structure         */
} *fapyrs,*fiptr,*fbptr;

                              /* fapyr.flags bit values                    */
#define FLASHY 01             /*   in flash communications mode            */
#define XMTING 02             /*   transmitting a packet                   */
#define NAKLST 04             /*   received a NAK last character           */

#define STPFLA 230            /* stop-flash-mode injected status code      */

#undef  TPCSIZ
#define TPCSIZ 41             /* max size of teleconf channel topic        */
#define TMSSIZ 60             /* max size of enter/exit messages for users */

extern
struct tlc {                  /* teleconference per-user volatile data     */
     int flags;               /*   telecon user "flag" bits                */
     int paged;               /*   intervals-since-last-paged counter      */
     int swchan;              /*   # of times switched chans in interval   */
     int blinkc;              /*   intervals-since-paged-Sysop counter     */
     unsigned channel;        /*   teleconference channel number in use    */
     char topic[TPCSIZ];      /*   channel topic as set by moderator       */
     int inpcnt;              /*   input message counter for freeloaders   */
     int reqcha;              /*   intervals-since-last-chat-request ctr.  */
     int chatch;              /*   channel of other user being chatted with*/
     int retstt;              /*   return state number when XTOOTH         */
     int retsub;              /*   return sub-state number when XTOOTH     */
     int retrat;              /*   return cred consumption rt when XTOOTH  */
     long forgets[8];         /*   "forget" flags by modem number          */
     long ignores[8];         /*   "ignore" flags by modem number          */
     long invites[8];         /*   "invite" flags by modem number          */
     unsigned prvchn;         /*   user's private channel number           */
     int defchn;              /*   default channel 1=Main 2=Private        */
     int action;              /*   users action state 2=Off 1=On           */
     int pagsts;              /*   default page status 1=On 2=Off 3=Ok     */
     int pagint;              /*   user set page interval                  */
     int chaint;              /*   user set chat interval                  */
     char theme[TPCSIZ];      /*   current topic when user is in private   */
     int pflags;              /*   flags saved to disk when updated        */
     int rewhsps;             /*   system of last user whispered to        */
     int rewhspu;             /*   usrnum of last user whispered to        */
     char inpbuf[INPSIZ];     /*   status 3 emulator input buffer          */
} *tlclst,                    /* one to a customer (dynamic array)         */
  *tlcptr,*tptr;              /* handy pointers for speed                  */

extern
struct tlc2 {                 /* secondary teleconf per-user volatile data */
     char ntrwhs[UIDSIZ];     /* net user-id to rewhisper to               */
     char entmsg[TMSSIZ];     /*   entrance message if not default         */
     char extmsg[TMSSIZ];     /*   exit message if not default             */
} *tl2lst,                    /* one to a customer (dynamic array)         */
  *tl2ptr,*t2ptr;             /* handy pointers for speed                  */

extern
struct tlcdat {               /* teleconference profile data structure     */
     char userid[UIDSIZ];     /*   user-id (BTRIEVE key)                   */
     int defchn;              /*   default teleconference channel          */
     int action;              /*   default action status (on/off)          */
     int pagsts;              /*   default page status (on/off/ok)         */
     int pagint;              /*   default page interval (1-9 mins)        */
     int chaint;              /*   default chat interval (1-9 mins)        */
     char theme[TPCSIZ];      /*   default private channel topic           */
     char entmsg[TMSSIZ];     /*   customized entrance message             */
     char extmsg[TMSSIZ];     /*   customized exit message                 */
     char reqent[TMSSIZ];     /*   requested entrance message              */
     char reqext[TMSSIZ];     /*   requested exit message                  */
     int flags;               /*   various flags that need to be saved     */
     char spare[500-323];     /*   spare space (decrease when adding)      */
} tlcdat;                     /* occurence of structure for lookups        */

#if sizeof(struct tlcdat) != 500
#error sizeof(tlcdat) has changed!  Update BCR file.
#endif

#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif

#define USEENT 1
#define USEPFN 2
#define CHNOPN 3

/* Some items need to be tagged as forgettable or ignorable                */
/* These flags do that trick                                               */

#define CANFORG 0x0001        /* Should this be forgettable?               */
#define CANIGNO 0x0002        /* Should this be ignorable?                 */

#define CHNSIZ 16
#define LSTSIZ 16

#define SIGOFF  5000          /* Offset for start of forum channels        */
#define CHNOFF 10000          /* channel offset for private channels       */

#define MNNAME "Main"
#define MNCHAN  0
#define BADCHAN 65535U

#define CPROFAN 0x0001        /* Profanity allowed?                        */
#define CENTERX 0x0002        /* User enter/exit messages?                 */
#define COPENCL 0x0004        /* Is channel open?                          */

                              /* definition of data file user bit "flags"  */
#define SQULCH  1             /*   user is squelched in Teleconference     */

extern
struct chanls {
     char name[CHNSIZ];
     char topic[TPCSIZ];
     char axskey[KEYSIZ];
     char modkey[KEYSIZ];
     char actlst1[LSTSIZ];
     char actlst2[LSTSIZ];
     unsigned flags;
     char spare[252-123];
} *chnlst;

#if sizeof(struct chanls) != 252
#error chanls struct changed size!
#endif

#define tlcoff(x) ((struct tlc *)ptrtile(tlclst,x))

                              /* definition of telecon user bit "flags"    */
#define NOPAGE 1              /*   user page-flag set to "off"             */
#define JUSTEX 2              /*   user "just exited" during current intvl */
#define OKPAGE 4              /*   user doesn't mind being paged to death  */
#define CCHVLD 8              /*   chat-channel value is valid             */
#define ACTION 16             /*   action is on                            */
#define EDITED 32             /*   users account has been edited           */
#define INVALL 64             /*   user has invited everyone to channel    */
#define XTOOTH 128            /*   exit to other than main menu            */
#define NOTALK 256            /*   user has been squelched by a sysop      */
#define TYPING 512            /*   user is now typing (for chat colors)    */
#define RSTX2M 1024           /*   reset X2MAIN when XTOOTH is invoked     */
#define IGNRAL 2048           /*   ignoring the whole world                */

                              /* sub-state codes                           */
#define TLKING  1             /*   regular conferencing                    */
#define CHTING  2             /*   chatting with another user              */
#define LNKING  3             /*   linking to another system               */
#define LINKED  4             /*   linked to another system                */
#define GOING   5             /*   orphan outdial channel going down       */
#define FLHING  6             /*   in flash protocol mode                  */
#define EDTING  10            /*   base substate for editing               */

#define EDTCHAN 50            /* In the channel editor                     */
#define EDTLIST 60            /* In the list editor                        */
#define EDTACTN 61            /* In the action editor                      */

extern
FILE *tlcmb;                  /* teleconf named-message file block pointer */

extern
int tlcstt;                   /* teleconferencing state number             */

extern int (*tlcpfn)(unsigned);  /* TLC profanity handler                  */

/* FLASH.C 24/02/92 22.53.20 */
void inifla(void);
int ck4fla(void);
void lvpool(void);

/* ENTTLC.C */
void EXPORT init__enttlc(void);
void joint(unsigned chan);
void telext(void);
int valact(char *stg);
int chkalph(char *stg);
int undupe(char *stg,int insert);
int ck4pfn(unsigned chnnum);
int findstar(char *stg);

/* Exported routines */

int addchn(struct chanls *newchan,char save);
int delchn(char *chnnam,int save);
int ndelchn(unsigned chnnum,int save);
int ersechn(char *chnnam);
int edtchn(struct chanls *edtchan,char save);
void movchn(int userno,unsigned chnnum);
int avspcchn(void);
unsigned idxchn(char *chnnam);
int chkpub(char *chnnam);
int modchn(int userno,unsigned chnnum);
int axschn(int userno,unsigned chnnum);
int chkcls(unsigned chnnum);
int chkeex(unsigned chnnum);
int chkfgt(int user1,int user2);
int chkign(int user1,int user2);
int chkpfn(unsigned chnnum);
unsigned findhome(int userno);
char *fndusr(int userno,char *start,int mnum,int prec,int *count);
char *prspow(int userno,char *start,int mnum,int prec,int *count);
int howmny(unsigned chan,char *stg,int prec,int samas);
void uactupd(void);
void swtact(int userno,unsigned chnnum);
void swtchn(int userno,unsigned chnnum);
int istlking(int userno);
int tlcstate(void);
int urinv(void);
void entrmsg(void);
int hasmtkey(int mnum);
void tpfmlt();
void tpfmsg();
void outchan(unsigned chan,int flags,int user1,int user2);
void outtlc(void);
