/***************************************************************************
 *                                                                         *
 *   FLASH.C                                                               *
 *                                                                         *
 *   Copyright (C) 1988-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is The Major BBS remote-program interface, designed for use      *
 *   as an adjunct to the teleconference.                                  *
 *                                                                         *
 *                                            - T. Stryker 5/26/89         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "plstuff.h"
#include "flash.h"
#include "galetl.h"

#pragma inline           /* MUST APPEAR BEFORE ANY CODE!                   */

STATIC
struct pool *pools,*piptr;
struct pool *pbptr;

STATIC
struct fapyr *fiptr,*fbptr;
struct fapyr *fapyrs;

#define NAK      21
#define CAN      24
#define NAKACK  120
#define REMOVE  121
#define TICK    122
#define LINEUP  127

#define fptr ((struct fapyr *)vdaptr)

STATIC
int flhres,                   /* flashing restricted by time-of-day?       */
    flhstm,                   /* if flhres, starting time flash allowed    */
    flhdur;                   /* if flhres, duration flash allowed         */

STATIC
int fnterms,                  /* flash-local copy of nterms (in case HUGE) */
    prttyp;                   /* Which version of protocol 0='89  1='92    */

void
telext(void),outtlc(void);    /* routines from ENTTLC.C called from within */

STATIC void gofchi(void);
STATIC char *ad2uid(void);
STATIC char *astuid(struct fapyr *faptr);
STATIC char flachi(int chan,int c);
STATIC char *nxpack(void);
STATIC char *napack(char c);
STATIC void flarti(void);

void
inifla(void)
{
     pools=(struct pool *)alczer(NPOOLS*sizeof(struct pool));
     fapyrs=(struct fapyr *)alczer(nterms*sizeof(struct fapyr));
     rtihdlr(flarti);
     flhres=ynopt(FLHRES);
     flhstm=numopt(FLHSTM,0,23);
     flhdur=numopt(FLHDUR,1,23);
     fnterms=nterms;
}

int
ck4fla(void)
{
     int i,j,avlchn,hr;
     static char *cmsg[]={
          "/","Flash","Protocol","Copyright","1989","Galacticomm,","Inc."
     };

     if (margc != 3+sizeof(cmsg)/sizeof(char *)) {
          return(0);
     }
     if (strcmp(margv[0],"Flash") != 0) {
          return(0);
     }
     prttyp=(strcmp(margv[7],"1992") == 0 ? 1 : 0);
     if (*(margv[3]) == '#' && *(margv[3]+1) == '9' && strlen(margv[3]) > 9) {
          if (!(sameas(margv[3]+2,bturno))) {
               prfmsg(WRGBBS,margv[1]);
               shocst("FLASH GIVEN BAD SERIAL #","Bad number: %s",margv[3]);
               return(1);
          }
     }
     else {
          for (i=margc-1 ; i >= 3 ; i--) {
               if (strcmp(margv[i],cmsg[i-3]) != 0) {
                    if (i == 7 && prttyp == 1) {
                    }
                    else if (i == 3 && *margv[3] == '#') {
                         for (j=0 ; j < nterms ; j++) {
                              if (user[j].state == usrptr->state
                               && user[j].substt == FLHING
                               && sameas(fapyrs[j].poolpt->gamnam,margv[1])
                               && sameas(fapyrs[j].poolpt->gamver,margv[2])
                               && fapyrs[j].serno == atol(margv[3]+1)) {
                                   prfmsg(DUPSER,margv[1]);
                                   return(1);
                              }
                         }
                    }
                    else {
                         return(0);
                    }
               }
          }
     }
     if (!hasmkey(FLHKEY)) {
          prfmsg(MBL4F);
          howbuy();
          return(1);
     }
     telext();
     if (flhres) {
          hr=dthour(now());
          if (flhstm+flhdur <= 24) {
               if (hr < flhstm || hr > flhstm+flhdur-1) {
                    prfmsg(NFNOW,flhstm);
                    return(1);
               }
          }
          else {
               if (hr < flhstm && hr >= flhstm+flhdur-24) {
                    prfmsg(NFNOW,flhstm);
                    return(1);
               }
          }
     }
     avlchn=-1;
     for (i=0,pbptr=pools ; i < NPOOLS ; i++,pbptr++) {
          if (pbptr->nchans == 0) {
               avlchn=i;
          }
          else if (pbptr->tlcchn == tlcptr->channel) {
               if (strcmp(margv[1],pbptr->gamnam) == 0
                  && prttyp == pbptr->prttyp) {
                    if (strcmp(margv[2],pbptr->gamver) == 0) {
                         if (pbptr->nchans < SHPERP
                           || (*margv[3] == '#' && pbptr->nchans < CHPERP)) {
                              gofchi();
                         }
                         else {
                              prfmsg(T2MANY);
                         }
                    }
                    else {
                         prfmsg(WRGVER,pbptr->gamver,pbptr->gamnam,margv[2]);
                    }
               }
               else {
                    prfmsg(WRGGAM,pbptr->gamnam,pbptr->gamver,margv[1]);
               }
               return(1);
          }
     }
     if (avlchn < 0) {
          prfmsg(NEPOOL,NPOOLS);
     }
     else {
          pbptr=&pools[avlchn];
          pbptr->tlcchn=tlcptr->channel;
          strncpy(pbptr->gamnam,margv[1],GNSIZE);
          strncpy(pbptr->gamver,margv[2],GVSIZE);
          pbptr->nxtbyt=0;
          pbptr->prttyp=prttyp;
          gofchi();
     }
     return(1);
}

STATIC void
gofchi(void)
{
     int i;
     char prtsep;
     char *nxpstg;

     fbptr=&fapyrs[usrnum];
     fbptr->chno=usrnum;
     fbptr->cancnt=0;
     fbptr->poolpt=pbptr;
     fbptr->oneten=pbptr->nchans;
     btuclo(usrnum);
     btupmt(usrnum,0);
     btuxnf(usrnum,0,0);
     prtsep=pbptr->prttyp == 1 ? '+' : ' ';
     prf("%c",LINEUP);
     for (i=0 ; i < pbptr->nchans ; i++) {
          prf("%s%c",astuid(pbptr->faps[i]),prtsep);
     }
     if ((fbptr->serno=atol(margv[3]+1)) == 0) {
          prf("%s%c%u%c",ad2uid(),prtsep,now(),LINEUP);
     }
     else if (*(margv[3]+1) == '9') {
          prf("%s%c%u %c%s%c",ad2uid(),prtsep,now(),'#',bturno,LINEUP);
     }
     else {
          prf("%s%c%u %s%c",ad2uid(),prtsep,now(),margv[3],LINEUP);
     }
     pbptr->faps[pbptr->nchans]=fbptr;

     dsairp();
     fbptr->nxxbyt=fbptr->bytoff=pbptr->nxtbyt;
     pbptr->nchans++;
     chiout(usrnum,'\0');
     chiout(usrnum,'\0');
     chiout(usrnum,'\0');
     chiout(usrnum,'\0');
     chiout(usrnum,'\0');
     chiout(usrnum,'\0');
     for (prfptr=prfbuf ; *prfptr != '\0' ; prfptr++) {
          pbptr->pdata[pbptr->nxtbyt]=*prfptr;
          pbptr->nxtbyt=((pbptr->nxtbyt+1)&PDMASK);
     }
     piptr=pbptr;
     fiptr=fbptr;
     nxpstg=nxpack();
     fbptr->fflags=FLASHY;
     for (i=0 ; i < piptr->nchans ; i++) {
          fiptr=piptr->faps[i];
          if (!(fiptr->fflags&XMTING)) {
               chious(fiptr->chno,nxpstg);
               fiptr->nxxbyt=fbptr->nxxbyt;
               fiptr->fflags|=XMTING;
          }
     }
     btuchi(usrnum,flachi);
     btuech(usrnum,0);
     btuche(usrnum,1);
     enairp();

     usrptr->substt=FLHING;
     usrptr->flags|=NOINJO;
     clrmlt();
     prfmlt(USGONE,usaptr->userid,pbptr->gamnam);
     outtlc();
     clrmlt();
}

STATIC char *
ad2uid(void)
{
     int i,len,adjpos=0;
     char byt,*uptr;
     static char astbuf[UIDSIZ+1];

     if (prttyp) {
          sprintf(astbuf,"*%s",usaptr->userid);
     }
     else {
          astbuf[0]='*';
          i=1;
          for (uptr=usaptr->userid ; *uptr != '\0' ; uptr++) {
               if (isalnum(*uptr)) {
                    astbuf[i++]=*uptr;
               }
               else if (*uptr == ' ') {
                    break;
               }
          }
          astbuf[i]='\0';
          if ((len=strlen(astbuf)) > 10) {
               astbuf[10]='\0';
               len=10;
          }
          do {
               for (i=0 ; i < pbptr->nchans ; i++) {
                    if (sameas(astbuf+1,pbptr->faps[i]->alias)) {
                         if (!adjpos) {
                              if (len == 10) {
                                   len--;
                              }
                              else {
                                   astbuf[len+1]='\0';
                                   astbuf[len]=' ';
                              }
                              adjpos=1;
                         }
                         byt=astbuf[len];
                         if (byt > 49 && byt < 57) {
                              byt++;
                         }
                         else if (byt == 57) {
                              byt=48;
                         }
                         else {
                              byt=50;
                         }
                         astbuf[len]=byt;
                         break;
                    }
               }
          } while (i != pbptr->nchans);
          strcpy(fbptr->alias,astbuf+1);
     }
     return(astbuf+(tlcptr->prvchn != tlcptr->channel));
}

STATIC char *
astuid(faptr)
struct fapyr *faptr;
{
     static char astbuf[UIDSIZ+1];

     sprintf(astbuf,"*%s",pbptr->prttyp == 1 ? uacoff(faptr->chno)->userid
                                             : faptr->alias);
     return(astbuf+(tlcoff(faptr->chno)->prvchn != tlcptr->channel));
}

void
lvpool(void)
{
     int i;
     char *nxpstg;

     dsairp();
     fiptr=&fapyrs[usrnum];
     piptr=fiptr->poolpt;
     fiptr->fflags=0;
     piptr->pdata[piptr->nxtbyt]=REMOVE;
     piptr->nxtbyt=((piptr->nxtbyt+1)&PDMASK);
     piptr->pdata[piptr->nxtbyt]=fiptr->oneten+'0';
     piptr->nxtbyt=((piptr->nxtbyt+1)&PDMASK);
     if (--(piptr->nchans) > fiptr->oneten) {
          fbptr=piptr->faps[piptr->nchans];
          piptr->faps[fiptr->oneten]=fbptr;
          fbptr->oneten=fiptr->oneten;
     }
     for (i=0 ; i < piptr->nchans ; i++) {
          fiptr=piptr->faps[i];
          if (!(fiptr->fflags&XMTING)) {
               chious(fiptr->chno,nxpstg=nxpack());
               fiptr->fflags|=XMTING;
               for (i++ ; i < piptr->nchans ; i++) {
                    fiptr=piptr->faps[i];
                    if (!(fiptr->fflags&XMTING)) {
                         chious(fiptr->chno,nxpstg);
                         fiptr->nxxbyt=piptr->nxtbyt;
                         fiptr->fflags|=XMTING;
                    }
               }
               break;
          }
     }
     btuchi(usrnum,NULL);
     btuche(usrnum,0);
     enairp();
     echon();
     btuxnf(usrnum,0,19);
     usrptr->flags&=~NOINJO;
}

STATIC char
flachi(chan,c)
int chan,c;
{
     register int i;
     char *nxpstg;

     fiptr=&fapyrs[chan];
     piptr=fiptr->poolpt;
     if (c == -1) {
          if (fiptr->nxxbyt != piptr->nxtbyt) {
               chious(chan,nxpack());
          }
          else {
               fiptr->fflags&=~XMTING;
          }
     }
     else if (fiptr->fflags&NAKLST) {
          fiptr->nxxbyt=((((c&127)<<2)+fiptr->bytoff)&PDMASK);
          chious(chan,napack(c));
          fiptr->fflags&=~NAKLST;
          fiptr->fflags|=XMTING;
     }
     else if ((c&127) == CAN) {
          if (++(fiptr->cancnt) == 3) {
               chiinj(chan,STPFLA);
          }
     }
     else if (c == odd(c)) {
          c&=127;
          if (c == NAK) {
               fiptr->fflags|=NAKLST;
          }
          else {
               fiptr->cancnt=0;
               if (c < 11) {
                    piptr->pdata[piptr->nxtbyt]=c*10+fiptr->oneten;
               }
               else {
                    piptr->pdata[piptr->nxtbyt]=110+fiptr->oneten;
                    piptr->nxtbyt=((piptr->nxtbyt+1)&PDMASK);
                    piptr->pdata[piptr->nxtbyt]=c;
               }
               piptr->nxtbyt=((piptr->nxtbyt+1)&PDMASK);
               for (i=0 ; i < piptr->nchans ; i++) {
                    fiptr=piptr->faps[i];
                    if (!(fiptr->fflags&XMTING)) {
                         chious(fiptr->chno,nxpstg=nxpack());
                         fiptr->fflags|=XMTING;
                         for (i++ ; i < piptr->nchans ; i++) {
                              fiptr=piptr->faps[i];
                              if (!(fiptr->fflags&XMTING)) {
                                   chious(fiptr->chno,nxpstg);
                                   fiptr->nxxbyt=piptr->nxtbyt;
                                   fiptr->fflags|=XMTING;
                              }
                         }
                         break;
                    }
               }
          }
     }
     return(0);
}

STATIC char *
nxpack(void)
{
     static char pakbuf[18];
     char *pkp;
     int crc,i;

     pkp=pakbuf+1;
     crc=0;
     i=0;
     do {
          crc=calcrc(crc,*pkp++=odd(piptr->pdata[fiptr->nxxbyt]));
          fiptr->nxxbyt=((fiptr->nxxbyt+1)&PDMASK);
     } while (++i < 15 && fiptr->nxxbyt != piptr->nxtbyt);
     pakbuf[0]=0x80^odd(((crc>>3)&0x70)+i);
     *pkp++=odd(crc&0x7F);
     *pkp++='\0';
     return(pakbuf);
}

STATIC char *
napack(c)
char c;
{
     static char pakbuf[18];
     char *pkp;
     int crc,i;

     crc=calcrc(0,pakbuf[1]=odd(NAKACK));
     crc=calcrc(crc,pakbuf[2]=odd(c));
     pkp=pakbuf+3;
     i=1;
     while (++i < 15 && fiptr->nxxbyt != piptr->nxtbyt) {
          crc=calcrc(crc,*pkp++=odd(piptr->pdata[fiptr->nxxbyt]));
          fiptr->nxxbyt=((fiptr->nxxbyt+1)&PDMASK);
     }
     pakbuf[0]=0x80^odd(((crc>>3)&0x70)+i);
     *pkp++=odd(crc&0x7F);
     *pkp++='\0';
     return(pakbuf);
}

STATIC void
flarti(void)
{
     static char *tckstg={"qz]"};

asm       mov  cx,NPOOLS
asm       les  si,dword ptr pools
    pool:
asm       cmp  word ptr es:[si].nchans,0
asm       je   notk
asm       lea  di,[si].pdata
asm       add  di,es:[si].nxtbyt
asm       mov  byte ptr es:[di],TICK
asm       inc  word ptr es:[si].nxtbyt
asm       and  word ptr es:[si].nxtbyt,PDMASK
    notk:
asm       add  si,.pdata+PDSIZE
asm       loop pool
asm       mov  di,0
asm       les  si,dword ptr fapyrs
    pyrs:
asm       mov  ax,es:[si].fflags
asm       and  ax,FLASHY+XMTING
asm       cmp  ax,FLASHY
asm       jne  noxm
asm       push tckstg+2
asm       push tckstg
asm       push di
asm       call far ptr _chious
asm       add  sp,6
asm       inc  word ptr es:[si].nxxbyt
asm       and  word ptr es:[si].nxxbyt,PDMASK
asm       or   word ptr es:[si].fflags,XMTING
    noxm:
asm       add  si,.fflags+2
asm       inc  di
asm       cmp  di,fnterms
asm       jl   pyrs
}

