/***************************************************************************
 *                                                                         *
 *   FAZORU.C   (OBJROU.C)                                                 *
 *                                                                         *
 *   Copyright (C) 1984, 1986, 1991 GALACTICOMM, Inc. All Rights Reserved. *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "fazdat.h"
#include "galfaz.h"

STATIC void genobj(struct object *pbjptr);
STATIC void zorbo(int modnum);
STATIC void wngeat(int objidx);
STATIC void matobj(struct object *atmptr);

void
gwing(void)                   /* gwingus just wobbles around               */
{
     jabber(FAZ1204);
}

void
snuge(void)                   /* snuge sends telepathic message            */
{
     jabber(FAZ1300);
}

void
klonk(void)                   /* dampish generates mongoos                 */
{
     genobj(&objcts[2]);
}

STATIC void
genobj(pbjptr)                /* object generator utility                  */
struct object *pbjptr;
{
     if (pyrptr->sttptr->nobjs < NOBJST) {
          pyrptr->pobjct[objidx]=2;
          mspstg("...A %s drops out ",pbjptr->name);
          mspstg("%s!\r",pyrptr->sttptr->sobjlc);
          gibber();
          mspstg("***\rA %s drops ",pbjptr->name);
          mspstg("%s from ",pyrptr->sttptr->sobjlc);
          addmbf(pyrptr->auxhdl);
          mspstg("'s %s!\r",zbjptr->name);
          fazoth();
          insobs(pbjptr);
     }
     else {
          mspstg("...The %s bulges briefly and then sits still.\r",
               zbjptr->name);
          gibber();
     }
}

void
bilge(void)                   /* bilge plays silly message                 */
{
     jabber(FAZ1301);
     fazoth();
}

void
bork(void)                    /* bork telepathizes hint about coils        */
{
     jabber(FAZ1302);
}

void
rhuba(void)                   /* rhubarb telepathizes hint about tower     */
{
     jabber(FAZ1303);
}

void
moolk(void)                   /* moolkoo announces hint about grinfrazzitz */
{
     jabber(FAZ1304);
     fazoth();
}

void
wufflar(void)                 /* wufflar generates torkii                  */
{
     genobj(&objcts[1]);
}

void
suvar(void)                   /* suvar generates wigglesnorts              */
{
     genobj(&objcts[4]);
}

void
seppe(dntcar,narg)            /* sepper dissolves east wall near osmotic   */
struct object *dntcar;
int narg;
{
     dntcar++;           /* this parameter is not used */

     if (narg >= 2 && pyrptr->sttptr == &states[299]
          && stgcmp(urgv[narg],"east") == 0 && states[299].sttmsg != FAZ455) {
          prfmsg(FAZ1206);
          outare(&states[299]);
          prfmsg(FAZ1207);
          outare(&states[304]);
          prfmsg(FAZ1208);
          outare(&states[287]);
          states[299].sttmsg=FAZ455;
          states[304].sttmsg=FAZ456;
          states[299].east=&states[304];
     }
}

void
palt(dntcar,narg)             /* palt restores east wall near osmotic      */
struct object *dntcar;
int narg;
{
     dntcar++;           /* this parameter is not used */

     if (narg >= 2 && pyrptr->sttptr == &states[299]
          && stgcmp(urgv[narg],"east") == 0 && states[299].sttmsg == FAZ455) {
          prfmsg(FAZ1211);
          outare(&states[299]);
          prfmsg(FAZ1212);
          outare(&states[304]);
          prfmsg(FAZ1213);
          outare(&states[287]);
          states[299].sttmsg=FAZ299;
          states[304].sttmsg=FAZ304;
          states[299].east=NULL;
     }
}

void
cistl(void)                   /* cistle generates snuges                   */
{
     genobj(&objcts[3]);
}

void
rommu(void)                   /* rommus gives silly message                */
{
     jabber(FAZ1306);
}

void
rucku(void)                   /* ruckus announces poor joke                */
{
     jabber(FAZ1307);
     fazoth();
}

void
bundl(void)                   /* bundle telepathizes hint about green lights */
{
     jabber(FAZ1308);
}

void
nabob(void)                   /* nabob generates gwingii                   */
{
     genobj(&objcts[0]);
}

void
bagl3(atmptr,typcod)          /* level-3 bagloon duplicates level 1-2 objs */
struct object *atmptr;
int typcod;
{
     if (typcod == 0 && pyrptr->sttptr->nobjs < NOBJST
       && atmptr-objcts < 15) {
          matobj(atmptr);
     }
}

void
bagl4(atmptr,typcod)          /* level-4 bagloon duplicates level 1-3 objs */
struct object *atmptr;
int typcod;
{
     if (typcod == 0 && pyrptr->sttptr->nobjs < NOBJST
       && atmptr-objcts < 25) {
          matobj(atmptr);
     }
}

void
bagl5(atmptr,typcod)          /* level-5 bagloon duplicates level 1-4 objs */
struct object *atmptr;
int typcod;
{
     if (typcod == 0 && pyrptr->sttptr->nobjs < NOBJST
       && atmptr-objcts < 35) {
          matobj(atmptr);
     }
}

void
dweez(void)                   /* dweezle implodes takable items lying about */
{
     int i;

     jabber(FAZ1239);
     prfmsg(FAZ1238);
     fazoth();
     for (i=0 ; i < pyrptr->sttptr->nobjs ; ) {
          if (((zbjptr=pyrptr->sttptr->sttobj[i])->flags&OBJTKB)
               && zbjptr-objcts > 4) {
               mspstg("***\rThe %s that was",zbjptr->name);
               mobjps(zbjptr);
               addmbf(" just imploded with a loud pop!\r");
               gibber();
               fazoth();
               rmvobs(i);
          }
          else {
               i+=1;
          }
     }
}

STATIC void
zorbo(modnum)                 /* kootpod turns into another obj at random  */
int modnum;
{
     char *objnam;

     pyrptr->pyrobj[objidx]=&objcts[(getrnd()&0x7fff)%modnum];
     pyrptr->pobjct[objidx]=0;
     objnam=pyrptr->pyrobj[objidx]->name;
     mspstg("...The kootpod suddenly turns into a %s!\r",objnam);
     gibber();
     mspstg("***\r%s's kootpod suddenly turned into a ",pyrptr->auxhdl);
     mspstg("%s!\r",objnam);
     fazoth();
}

void
koot4(void)                   /* level-4 kootpod turns into a level 1-3    */
{
     zorbo(25);
}

void
koot5(void)                   /* level-5 kootpod turns into a level 1-4    */
{
     zorbo(44);
}

void
koot6(void)                   /* level-6 kootpod turns into a level 1-5    */
{
     zorbo(55);
}

void
kwish(void)                   /* kwish displays hint about monoliths       */
{
     jabber(FAZ1305);
}

void
quoru(void)                   /* quorum gives hint about dongle            */
{
     jabber(FAZ1309);
}

void
cacap(void)                   /* gives clue about building nebbish         */
{
     jabber(FAZ1319);
     fazoth();
     rmvobp(pyrptr,objidx);
}

void
wappl(void)                   /* wapple gives hint about finding Orb       */
{
     jabber(FAZ1310);
     fazoth();
}

void
nebbi(othpyr,typcod)          /* nebbish gets hot/cold due to relative bps */
struct player *othpyr;
int typcod;
{
     if (typcod == 1) {
          if (user[othpyr->portno].baud > usrptr->baud) {
               jabber(FAZ1216);
          }
          else if (user[othpyr->portno].baud < usrptr->baud) {
               jabber(FAZ1217);
          }
     }
}

void
wongu(void)                   /* wongum waits five moves then eats object  */
{
     jabber(FAZ1219);
     pyrptr->pobjct[objidx]=5;
}

void
wongo(void)                   /* routine to eat obj and wait 5 more moves  */
{
     pyrptr->pobjct[objidx]=5;
     if (pyrptr->nobjs >= 2) {
          if (pyrptr->pyrobj[0] != &objcts[49]) {
               wngeat(0);
          }
          else {
               wngeat(1);
          }
     }
}

STATIC void
wngeat(objidx)                /* wongum object eater utility               */
int objidx;
{
     mspstg("***\rThe wongum just ate your %s!\r",
          pyrptr->pyrobj[objidx]->name);
     gibber();
     mspstg("***\r%s's wongum just ate ",pyrptr->auxhdl);
     addmbf(zhisher(pyrptr));
     mspstg(" %s!\r",pyrptr->pyrobj[objidx]->name);
     fazoth();
     rmvobp(pyrptr,objidx);
}

void
narre(void)                   /* narret gives misc high-level hints        */
{
     jabber(FAZ1311);
}

void
drive(void)                   /* drivel gives hint about Galaxenter        */
{
     jabber(FAZ1312);
}

void
pasta(void)                   /* narn gives hint about quilbert/gwirg      */
{
     jabber(FAZ1313);
}

STATIC void
matobj(atmptr)                /* materialize-object utility                */
struct object *atmptr;
{
     fnobjp(urgv[1],pyrptr);
     pyrptr->pobjct[objidx]=2;
     mspstg("***\rAnother %s suddenly materializes ",atmptr->name);
     mspstg("%s!\r",pyrptr->sttptr->sobjlc);
     outare(pyrptr->sttptr);
     insobs(atmptr);
}

void
noodl(void)                   /* misuse of noodle beams mix of impressions */
{
     jabber(FAZ1314);
}

void
scroo(othpyr,typcod)          /* scroom makes victim drop possessions      */
struct player *othpyr;
int typcod;
{
     int i;

     if (typcod == 1) {
          fnobjp(urgv[1],pyrptr);
          pyrptr->pobjct[objidx]=10;
          if (hldoth(&objcts[48])) {
               mspstg("***\rA ray shoots toward you from %s's",pyrptr->auxhdl);
               addmbf(" scroom, but your quahog absorbs it!\r");
               outpyr(othpyr);
               mspstg("***\rA ray shoots out of the scroom, but %s's",
                    othpyr->auxhdl);
               addmbf(" quahog absorbs it!\r");
               gibber();
               mspstg("***\rA ray shoots toward %s",othpyr->auxhdl);
               mspstg(" from %s's scroom, but",pyrptr->auxhdl);
               mspstg(" %s's quahog absorbs it!\r",othpyr->auxhdl);
               outexc(othpyr);
          }
          else {
               for (i=0 ; i < othpyr->nobjs ; ) {
                    if (pyrptr->sttptr->nobjs >= NOBJST) {
                         break;
                    }
                    mspstg("***\rYour %s suddenly falls ",othpyr->pyrobj[i]->name);
                    mspstg("%s!\r",othpyr->sttptr->sobjlc);
                    outpyr(othpyr);
                    mspstg("***\r%s just dropped a ",othpyr->auxhdl);
                    addmbf(othpyr->pyrobj[i]->name);
                    mspstg(" %s!\r",othpyr->sttptr->sobjlc);
                    gibber();
                    outexc(othpyr);
                    insobs(othpyr->pyrobj[i]);
                    rmvobp(othpyr,i);
               }
          }
     }
}

void
fashn(void)                   /* fashnork turns player invisible           */
{
     jabber(FAZ1245);
     pyrptr->pobjct[objidx]=15;
     mspstg("***\r%s",pyrptr->auxhdl);
     prfmsg(FAZ1247);
     fazoth();
     strcpy(pyrptr->auxhdl,
         iszleen(pyrptr) ? "Some unseen zleen" : "Some unseen force");
}

void
fasho(void)                   /* fashnork explodes if used too long        */
{
     jabber(FAZ1243);
     prfmsg(FAZ1244);
     fazoth();
     rmvobp(pyrptr,objidx);
}

void
fashoo(pyrp)                  /* fashnork voluntary turn-off handler       */
struct player *pyrp;
{
     if (invis(pyrp)) {
          prfmsg(FAZ1246);
          outpyr(pyrp);
          prfmsg(FAZ1248);
          strcpy(pyrp->auxhdl,pyrp->plyrid);
          mspstg("%s appears!\r",pyrp->auxhdl);
          if (pyrp == pyrptr) {
               fazoth();
          }
          else {
               gibber();
               outexc(pyrp);
          }
     }
}

void
quice(void)                   /* quice gives clue about trail to nofzinger */
{
     jabber(FAZ1317);
}

void
snaac(void)                   /* snaack gives clue about trail to blub     */
{
     jabber(FAZ1318);
}

void
babba(pyr,typcod)             /* babbalisk grabs victim's stuff            */
struct player *pyr;
int typcod;
{
     if (typcod == 1) {
          othpyr=pyr;
          if (hldoth(&objcts[51])) {
               prfmsg(FAZ1250);
               addmbf(othpyr->auxhdl);
               prfmsg(FAZ1251);
               gibber();
               prfmsg(FAZ1252);
               addmbf(pyrptr->auxhdl);
               prfmsg(FAZ1253);
               outpyr(othpyr);
               prfmsg(FAZ1254);
               addmbf(pyrptr->auxhdl);
               prfmsg(FAZ1255);
               addmbf(othpyr->auxhdl);
               prfmsg(FAZ1256);
               outexc(othpyr);
          }
          else if (pyrptr->nobjs >= NOBJHD || othpyr->nobjs == 0) {
               jabber(FAZ1257);
               prfmsg(FAZ1258);
               addmbf(pyrptr->auxhdl);
               prfmsg(FAZ1259);
               fazoth();
          }
          else {
               prfmsg(FAZ1260);
               addmbf(othpyr->auxhdl);
               mspstg("'s %s",othpyr->pyrobj[0]->name);
               prfmsg(FAZ1261);
               mspstg("%s in your hands!\r",othpyr->pyrobj[0]->name);
               gibber();
               prfmsg(FAZ1262);
               addmbf(pyrptr->auxhdl);
               prfmsg(FAZ1263);
               addmbf(othpyr->pyrobj[0]->name);
               prfmsg(FAZ1264);
               addmbf(othpyr->pyrobj[0]->name);
               mspstg(" in %s's hands!\r",pyrptr->auxhdl);
               outpyr(othpyr);
               prfmsg(FAZ1265);
               addmbf(pyrptr->auxhdl);
               prfmsg(FAZ1266);
               addmbf(othpyr->auxhdl);
               mspstg("'s %s",othpyr->pyrobj[0]->name);
               prfmsg(FAZ1267);
               addmbf(othpyr->pyrobj[0]->name);
               mspstg(" in %s's hands!\r",pyrptr->auxhdl);
               outexc(othpyr);
               insobp(pyrptr,othpyr->pyrobj[0],othpyr->pobjct[0]);
               rmvobp(othpyr,0);
          }
     }
}

void
quilbert(atmptr,typcod)       /* quilbert picks up gwirg                   */
struct object *atmptr;
int typcod;
{
     if (typcod == 0 && atmptr == &objcts[116]) {
          jabber(FAZ1545);
          prfmsg(FAZ1546);
          mspstg("%s's hands!\r",pyrptr->auxhdl);
          mspstg("***\rThe gwirg just ate %s's quilbert!\r",pyrptr->auxhdl);
          fazoth();
          fnobjp("quilbert",pyrptr);
          pyrptr->pyrobj[objidx]=&objcts[116];
          fnobjs("gwirg");
          rmvobs(objidx);
     }
}

void
quilb(void)                   /* gwirg is pointed up to enter tower        */
{
     if (urgc < 3) {
          ntnice();
          return;
     }
     if (pyrptr->sttptr == &states[301] && stgcmp(urgv[2],"up") == 0) {
          lvstt("floated up, up, and away into the darkness above");
          jabber(FAZ1225);
          ntrstt(&states[313],"floated up through the floor");
     }
     else if (pyrptr->sttptr == &states[313]
       && stgcmp(urgv[2],"down") == 0) {
          lvstt("sunk down into the floor, and vanished");
          jabber(FAZ1226);
          ntrstt(&states[301],"floated down out of the darkness above you");
     }
     else if (stgcmp(urgv[2],"up") == 0) {
          jabber(FAZ1227);
     }
}

void
zarpnt(atmptr,typcod)         /* zarkon is pointed at oolgorboid to free it */
struct object *atmptr;
int typcod;
{
     if (typcod == 0 && atmptr-objcts == 117 && atmptr->flags == OBJNVS) {
          atmptr->flags=OBJTKB;
          atmptr->name="free oolgorboid";
          states[238].sttmsg=FAZ120;
          jabber(OOGFRE);
          fazoth();
     }
}
