/***************************************************************************
 *                                                                         *
 *   FAZMST.C    (MSGSTF.C)                                                *
 *                                                                         *
 *   Copyright (C) 1984, 1986, 1991 GALACTICOMM, Inc. All Rights Reserved. *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "fazdat.h"

STATIC void genpos(struct state *where);
STATIC void zing(struct state *zingrg);

static
struct state *poss[17];

void
jabber(msgnum)                /* output specified msg num to player        */
int msgnum;
{
     prfmsg(msgnum);
     outprf(pyrctr);
}

void
gibber(void)                  /* output prfbuf contents to player          */
{
     outprf(pyrctr);
}

void
outnis(void)                  /* output to everyone not in player's state  */
{
     int i;

     for (i=0 ; i < nterms ; i++) {
          if (pyrarr[i].sttptr != pyrptr->sttptr && (pyrarr[i].logon&INGAME)) {
               outprf(i);
          }
     }
     clrprf();
}

void
fazall(void)                  /* output to everyone except player          */
{
     int i;

     for (i=0 ; i < nterms ; i++) {
          if (i != pyrctr && (pyrarr[i].logon&INGAME)) {
               outprf(i);
          }
     }
     clrprf();
}

void
fazoth(void)                  /* output to others in player's state        */
{
     struct player *tmpypt;

     tmpypt=pyrptr->sttptr->plhead;
     while (tmpypt != 0) {
          if (tmpypt != pyrptr) {
               outprf(tmpypt->portno);
          }
          tmpypt=tmpypt->nxtpyr;
     }
     clrprf();
}

void
outpyr(othpyr)                /* output to specified player only           */
struct player *othpyr;
{
     outprf(othpyr->portno);
}

void
outexc(ptrpyr)                /* output to 3rd-party viewers               */
struct player *ptrpyr;
{
     struct player *tmpypt;

     tmpypt=pyrptr->sttptr->plhead;
     while (1) {
          if (tmpypt != pyrptr && tmpypt != ptrpyr) {
               outprf(tmpypt->portno);
          }
          if ((tmpypt=tmpypt->nxtpyr) == 0) {
               break;
          }
     }
     clrprf();
}

void
outner(void)                  /* output to "nearby" states (rooms)         */
{
     poss[0]=pyrptr->sttptr;
     intmp1=1;
     genpos(poss[0]);
     for (intmp2=1 ; intmp2 < intmp1 ; intmp2++) {
          outare(poss[intmp2]);
     }
     clrprf();
}

void
fazfar(void)                  /* output to "far" (once removed) states     */
{
     int norgp;

     poss[0]=pyrptr->sttptr;
     intmp1=1;
     genpos(poss[0]);
     norgp=intmp1;
     for (intmp2=1 ; intmp2 < norgp ; intmp2++) {
          genpos(poss[intmp2]);
     }
     for (intmp2=norgp ; intmp2 < intmp1 ; intmp2++) {
          outare(poss[intmp2]);
     }
     clrprf();
}

STATIC void
genpos(where)                 /* generate possibilities to output to       */
struct state *where;
{
     zing(where->north);
     zing(where->south);
     zing(where->east);
     zing(where->west);
}

STATIC void
zing(zingrg)                  /* accumulate possibilities without duplicates */
struct state *zingrg;
{
     int i;

     if (zingrg != 0) {
          for (i=0 ; i < intmp1 ; i++) {
               if (zingrg == poss[i]) {
                    return;
               }
          }
          poss[intmp1++]=zingrg;
     }
}

void
outare(spoint)                /* output prfbuf to a given state (area)     */
struct state *spoint;
{
     struct player *tmpypt;

     tmpypt=spoint->plhead;
     while (tmpypt != 0) {
          outprf(tmpypt->portno);
          tmpypt=tmpypt->nxtpyr;
     }
     clrprf();
}

