/***************************************************************************
 *                                                                         *
 *   FAZGAM.C    (GAMES.C)                                                 *
 *                                                                         *
 *   Copyright (C) 1984, 1986, 1991 GALACTICOMM, Inc. All Rights Reserved. *
 *                 1992                                                    *
 ***************************************************************************/

#include "gcomm.h"
#include "fazdat.h"
#include "galfaz.h"
#include "brkthu.h"

STATIC int dofoon(void);
STATIC void nwfoon(void);
STATIC void kcfoon(int count);
STATIC void qtfoon(void);
STATIC void givprz(struct object *zbjptr,struct state *sptr,char *txt);
STATIC int isvowel(char chr);
STATIC int doumfl(void);
STATIC void ckumdn(int count);
STATIC void qtumfl(void);
STATIC int doosmo(void);
STATIC void osboom(void);
STATIC void qtosmo(void);
STATIC void gogwirg(struct state *gwidst);

static char foonhs[4]={0,0,0,0};
static int foonon;

int
foon(void)                    /* special cmd hdlr for Foonball Emporium    */
{
     switch (sltchk(&objcts[0],&objcts[0],&objcts[55],"slot")) {
     case -1:
          if (zbjptr == &objcts[55]) {
               if ((getrnd()&0x7fff)%5 > 1) {
                    jabber(FAZ1507);
                    prfmsg(FAZ1508);
                    mspstg("%s's hands!\r",pyrptr->auxhdl);
                    fazoth();
                    pyrptr->crackl+=3;
               }
               else {
                    prfmsg(FAZ1509);
                    outare(&states[298]);
               }
          }
          else {
               prfmsg(FAZ1500);
               outare(&states[298]);
               states[298].cmhdlr=dofoon;
               states[298].sttmsg=FAZ1506;
               foonhs[0]=foonhs[1]=foonhs[2]=0;
               foonon=1;
               kcfoon(0);
          }
     case 0:
          return(0);
     case 1:
     default:
          return(1);
     }

}

STATIC int
dofoon(void)                  /* do foonball game-play command handling    */
{
#define FOONOK 16
#define FOONBD 8
     static char *gfoons[]={"\1\2\3","\2\3\4","\3\4\1","\4\1\5",
                            "\1\5\6","\5\6\7","\6\7\1","\7\1\2",
                            "\3\2\1","\4\3\2","\1\4\3","\5\1\4",
                            "\6\5\1","\7\6\5","\1\7\6","\2\1\7"};
     static char *bfoons[]={"\5\7","\2\4","\1\3","\1\6",
                            "\7\5","\4\2","\3\1","\6\1"};
     int i;

     if (urgc >= 2 && strcmp(urgv[0],"slap") == 0
       && nmatch(urgv[1],"foon-ball")) {
          btuxmt(pyrctr,"...POW!  The foon-ball goes flying!\r");
          mspstg("***\r%s just slapped the foon-ball!\r",pyrptr->auxhdl);
          fazoth();
          for (i=0 ; i < FOONOK ; i++) {
               if (strcmp(foonhs,gfoons[i]) == 0) {
                    givprz(&objcts[55],&states[298],
                         "materializes in the middle of the floor");
                    prfmsg(FAZ1501);
                    addmbf(pyrptr->auxhdl);
                    prfmsg(FAZ1502);
                    qtfoon();
                    return(0);
               }
          }
          for (i=0 ; i < FOONBD ; i++) {
               if (strcmp(foonhs+1,bfoons[i]) == 0) {
                    prfmsg(FAZ1503);
                    addmbf(pyrptr->auxhdl);
                    prfmsg(FAZ1504);
                    qtfoon();
                    return(0);
               }
          }
          nwfoon();
          return(0);
     }
     return(1);
}

STATIC void
nwfoon(void)                  /* new foonball location utility             */
{
     int nwp;
     static char *posnam[]={"","fong","pleebor","oomwazzitz",
                            "neblin","noodiddle","kleng","ormush"};

     foonhs[0]=foonhs[1];
     foonhs[1]=foonhs[2];
     while ((nwp=((getrnd()&0x7fff)%7)+1) == foonhs[0] || nwp == foonhs[1]) {
     }
     foonhs[2]=nwp;
     mspstg("***\rThe foon-ball moves to %s!\r",posnam[nwp]);
     outare(&states[298]);
}

STATIC void
kcfoon(count)                 /* kick foonball around and eventually timeout */
int count;
{
     if (foonon) {
          if (count < 42) {
               nwfoon();
               zrtkick(7,kcfoon,count+1);
          }
          else {
               prfmsg(FAZ1505);
               qtfoon();
          }
     }
}

STATIC void
qtfoon(void)                  /* quit foonball                             */
{
     outare(&states[298]);
     states[298].cmhdlr=foon;
     states[298].sttmsg=FAZ298;
     foonon=0;
}

STATIC void
givprz(zbjptr,sptr,txt)       /* give foonprize, announce winner           */
struct object *zbjptr;
struct state *sptr;
char *txt;
{
     if (sptr->nobjs < NOBJST) {
          mspstg("***\rA %s suddenly ",zbjptr->name);
          mspstg("%s!\r",txt);
          outare(sptr);
          insobs(zbjptr);
     }
}

#define STUMFL 291
#define STUMFLMSG FAZ291
#define MAXUML 37
#define UMFCCT (sizeof(umfcst)/sizeof(char *))
#define UMFVCT (sizeof(umfvst)/sizeof(char *))
static char *umfcst[]={
     "FLESK","SNAR","NODULE","SHEEN","BEE","NONGA","TROO","WORB",
     "ZATT","FOO","RIBB","SNAG","BOBBLE","NORKER","FLEX","DREA",
     "GOON","BLAST","FREE","NISK","NAPPLE","FISH","SKOO","BIPP",
     "MOSS","SH","TH","DEEDLE","ST","POO","FLISK","NAZZ","BORB"};
static char *umfvst[]={
     "OBBLE","ISPA","EEN","OOM","ADDLE","IZZ","OON","OO","EE",
     "ONGLE","I","IBBI","AGGA","OOTA","IZA","OOTO","AZZU","EEB",
     "ANG","INGA","ORBI","IDD","ULE","UZZ","I","OO","EE","IKKI"};
static char umflwd[MAXUML];
static int umflon;
static char umflbd[MAXUML];

int
umflun(void)                  /* special cmd hdlr for Hall of Umflungoo    */
{
     int doumfl();
     int i,sylcnt;

     switch (sltchk(&objcts[2],&objcts[2],&objcts[2],"hole")) {
     case -1:
          prfmsg(FAZ1510);
          outare(&states[STUMFL]);
          states[STUMFL].cmhdlr=doumfl;
          states[STUMFL].sttmsg=FAZ1511;
          sylcnt=(getrnd()&3)+2;
          strcpy(umflwd,((sylcnt&1) ? umfvst[(getrnd()&0x7fff)%UMFVCT]
                                    : umfcst[(getrnd()&0x7fff)%UMFCCT]));
          for (i=1 ; i < sylcnt ; i++) {
               if (isvowel(umflwd[strlen(umflwd)-1])) {
                    strcat(umflwd,umfcst[(getrnd()&0x7fff)%UMFCCT]);
               }
               else {
                    strcat(umflwd,umfvst[(getrnd()&0x7fff)%UMFVCT]);
               }
          }
          setmem(umflbd,MAXUML,32);
          umflbd[strlen(umflwd)]='\0';
          umflon=1;
          ckumdn(0);
     case 0:
          return(0);
     case 1:
     default:
          return(1);
     }
}

STATIC int
isvowel(chr)                  /* return true if chr is a vowel             */
char chr;
{
     if (chr == 'A' || chr == 'E' || chr == 'I' || chr == 'O' || chr == 'U') {
          return(1);
     }
     return(0);
}

STATIC int
doumfl(void)                  /* do umflungoo game play if active          */
{
     int umflec,i;

     if (urgc >= 2 && strcmp(urgv[0],"yell") == 0) {
          yelrtn();
          if (strcmp(urgv[1],umflwd) == 0) {
               givprz(&objcts[59],&states[STUMFL],
                    "pops out of the hole in the floor");
               prfmsg(FAZ1514);
               mspstg("%s ",umflwd);
               mspstg("%s ",umflwd);
               mspstg("%s",umflwd);
               prfmsg(FAZ1515);
               strcpy(umflbd,pyrptr->auxhdl);
               ucify(umflbd);
               mspstg("%s ",umflbd);
               mspstg("%s ",umflbd);
               mspstg("%s",umflbd);
               prfmsg(FAZ1516);
               qtumfl();
          }
          else {
               for (i=umflec=0 ; urgv[1][i] != 0 && umflwd[i] != 0 ; i++) {
                    if (urgv[1][i] == umflwd[i]) {
                         if (umflbd[i] == 32) {
                              umflbd[i]=umflwd[i];
                              umflec=1;
                         }
                    }
               }
               if (umflec) {
                    prfmsg(FAZ1517);
                    mspstg("%s\r",umflbd);
                    outare(&states[STUMFL]);
               }
          }
          return(0);
     }
     return(1);
}

STATIC void
ckumdn(count)                 /* check if umflungoo is done                */
int count;
{
     if (umflon) {
          if (count < 120) {
               zrtkick(5,ckumdn,count+1);
          }
          else {
               prfmsg(FAZ1512);
               addmbf(umflwd);
               prfmsg(FAZ1513);
               qtumfl();
          }
     }
}

STATIC void
qtumfl(void)                  /* quit umflungoo                            */
{
     outare(&states[STUMFL]);
     states[STUMFL].cmhdlr=umflun;
     states[STUMFL].sttmsg=STUMFLMSG;
     umflon=0;
}

static int osmoon=0;
static struct object *osmobj;
static int osmcnt=0;

int
osmo(void)                    /* special cmd hdlr for osmotic              */
{
     int doosmo(),i,j;
     char *mbftmp;

     switch (sltchk(NULL,NULL,NULL,"osmotic")) {
     case -1:
          if ((i=(int)(zbjptr-objcts)) < 5) {
               j=25;
          }
          else if (i < 15) {
               j=35;
          }
          else if (i < 25) {
               j=44;
          }
          else {
               j=52;
          }
          osmobj=&objcts[(getrnd()&0x7fff)%j];
          prfmsg(FAZ1525);
          mbftmp=prfptr;
          mspstg("%s!\"\r",osmobj->name);
          ucify(mbftmp);
          osboom();
          states[299].cmhdlr=doosmo;
          states[287].sttmsg=FAZ1526;
          osmoon=1;
          osmcnt=0;
     case 0:
          return(0);
     case 1:
     default:
          if (urgc > 1 && strcmp(urgv[1],"how") == 0) {
               prfmsg(FAZ1536);
               osboom();
               osmcnt=0;
          }
          return(1);
     }
}

STATIC int
doosmo(void)                  /* do osmotic game play when active          */
{
     char *mbftmp;

     switch (sltchk(NULL,NULL,NULL,"osmotic")) {
     case -1:
          if (zbjptr == osmobj) {
               prfmsg(FAZ1529);
               mbftmp=prfptr;
               addmbf(pyrptr->auxhdl);
               ucify(mbftmp);
               prfmsg(FAZ1530);
               osboom();
               givprz(&objcts[57],&states[299],
                    "wiggles out from under the osmotic");
               qtosmo();
          }
          else {
               prfmsg(FAZ1531);
               addmbf(pyrptr->auxhdl);
               prfmsg(FAZ1532);
               outare(&states[299]);
               qtosmo();
          }
     case 0:
          return(0);
     case 1:
     default:
          return(1);
     }
}

STATIC void
osboom(void)                  /* boom the osmotic's voice around           */
{
     outare(&states[299]);
     prfmsg(FAZ1527);
     outare(&states[287]);
     prfmsg(FAZ1528);
     outare(&states[304]);
}

void
osmwat(void)                  /* make osmotic announcement every 45 secs   */
{
     char *mbftmp;

     if ((++osmcnt&15) == 15) {
          if (osmoon) {
               if (osmcnt < 100) {
                    prfmsg(FAZ1533);
                    mbftmp=prfptr;
                    mspstg("%s!\"\r",osmobj->name);
                    ucify(mbftmp);
                    osboom();
               }
               else {
                    prfmsg(FAZ1534);
                    outare(&states[299]);
                    qtosmo();
               }
          }
          else {
               prfmsg(FAZ1535);
               osboom();
          }
     }
     zrtkick(3,osmwat,0);
}

STATIC void
qtosmo(void)                  /* quit osmotic waiting for target object    */
{
     states[299].cmhdlr=osmo;
     states[287].sttmsg=FAZ287;
     osmoon=osmcnt=0;
}

#define nor 0
#define sou 1
#define eas 2
#define wes 3
static char gwirgd[]={
     wes,nor,wes,nor,nor,wes,sou,eas,eas,nor,eas,eas,eas,eas,
     sou,sou,sou,sou,sou,eas,sou,eas,eas,eas,eas,eas,eas,eas,
     eas,nor,nor,nor,nor,nor,nor,eas,nor,nor,wes,wes,wes,wes,
     wes,wes,nor,wes,sou,wes,sou,wes,wes,wes,wes,wes,wes,wes,
     wes,wes,wes,wes,wes,wes,wes,sou,sou,wes,sou,wes,sou,wes,
     wes,wes,wes,wes,wes,wes,nor,nor,nor,nor,eas,sou,eas,sou,
     sou,eas,nor,nor,nor
};
static int gwirdp=0;
static struct state *gwirgs=&states[286];
static char *dirnms[]={"north","south","east","west"};

void
gwirg(void)                   /* move gwirg every 5 seconds                */
{
     int gwidir;
     struct state *gwidst;

     if (gwirgs != NULL && sfnobjs("gwirg",gwirgs) != NULL) {
          srmvobs(objidx,gwirgs);
          switch (gwidir=gwirgd[gwirdp]) {
          case nor:
               gwidst=gwirgs->north;
               break;
          case sou:
               gwidst=gwirgs->south;
               break;
          case eas:
               gwidst=gwirgs->east;
               break;
          case wes:
               gwidst=gwirgs->west;
               break;
          }
          gwirdp=(gwirdp+1)%sizeof(gwirgd);
          prfmsg(FAZ1540);
          mspstg("%s!\r",dirnms[gwidir]);
          outare(gwirgs);
          prfmsg(FAZ1541);
          mspstg("%s!\r",dirnms[gwidir^1]);
          outare(gwidst);
          gogwirg(gwidst);
     }
     zrtkick(5,gwirg,0);
}

STATIC void
gogwirg(gwidst)               /* gwirg movement utility                    */
struct state *gwidst;
{
     if (gwidst->nobjs == NOBJST) {
          zbjptr=gwidst->sttobj[NOBJST-1];
          mspstg("***\rThe gwirg just ate the %s that was",zbjptr->name);
          mspstg(zbjptr->positn,gwidst->sobjlc);
          addmbf("!\r");
          outare(gwidst);
          gwidst->nobjs-=1;
     }
     gwidst->sttobj[gwidst->nobjs++]=&objcts[116];
     gwirgs=gwidst;
}
