/***************************************************************************
 *                                                                         *
 *   TLCFSD.H                                                              *
 *                                                                         *
 *   Copyright (C) 1993-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Prototypes and definitions for Teleconference FSD routines.           *
 *                                                                         *
 *                                            - J. Moriarty  11/93         *
 *                                                                         *
 ***************************************************************************/

#define CEDNAME 0                  /* Channel editor defines               */
#define CEDTOPI 1
#define CEDAXSK 2
#define CEDMODK 3
#define CEDACT1 4
#define CEDACT2 5
#define CEDCPRO 6
#define CEDCENT 7
#define CEDCOPE 8

#define LEDNAME 0                  /* List editor defines                  */
#define LEDSEEK 1
#define LEDUSEK 2

#define AEDNAME  0                 /* Action editor defines                */
#define AEDSIMP1 1
#define AEDSIMP2 2
#define AEDSIMP3 3
#define AEDSIMP4 4
#define AEDCOMP1 5
#define AEDCOMP2 6
#define AEDCOMP3 7
#define AEDCOMP4 8
#define AEDRESP1 9
#define AEDRESP2 10
#define AEDRESP3 11
#define AEDRESP4 12
#define AEDKEY   13

struct cedctrl {
     int user;                     /* User in channel editor               */
     int state;                    /* State of channel editor              */
     unsigned channel;             /* Channel being edited                 */
     int sysop;                    /* Sysop or moderator?                  */
};

extern struct cedctrl cedctrl;     /* Channel editor control block         */
extern struct chanls cedtemp;      /* Temp channel for FSD                 */

struct aedctrl {
     int user;                     /* User in action editor                */
     int state;                    /* State of action editor               */
};

extern struct aedctrl aedctrl;     /* Handles action editor                */
extern struct actlst ledtemp;      /* List editor temp block               */
extern struct action aedtemp;      /* Word editor temp block               */

extern char cedfsp[];
extern char cedfmt[];

extern char ledfsp[];
extern char ledfmt[];

void initfsd(void);
char *tfsdpft(void);

void cedptc(int issysop);
void cedprp(int msgno,int mode);
void ceddun(int save);
void cedcdun(int save);
int cedvfy(int fldno,char *answer);

void leddun(int save);
void ledcdun(int save);
void ledprp(int msgno,int mode);
void ledptc(void);
int ledvfy(int fldno,char *answer);

void aeddun(int save);
void aedcdun(int save);
void aedprp(int msgno,int mode);
void rplchr(char *target,char in,char out);
void aedptc(void);
int aedvfy(int fldno,char *answer);
