/***************************************************************************
 *                                                                         *
 *   ETLAPI.H                                                              *
 *                                                                         *
 *   Copyright (C) 1993-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   External hook handler interface.                                      *
 *                                                                         *
 *                                            - M. Donnelly 11/8/93        *
 *                                                                         *
 ***************************************************************************/

typedef int (*THOOK)(int code);

#define TH_INPUT   0     /* A user has typed input for this channel.       */
#define TH_JOIN    1     /* A user just joined his current channel.        */
#define TH_ENTER   2     /* A user just entered tlc (in current channel).  */
#define TH_EXIT    3     /* A user is exiting Teleconference.              */
#define TH_CYCLE   4     /* The cycle you requested is here.               */
#define TH_INFO    5     /* Display info line for game.                    */
#define TH_SHTDWN  6     /* The BBS is shutting down.                      */

/* When adding a hook, NULL can be passed for the keywd parameter.  This will
   cause your hook to be called EVERY line of input in Teleconference (at
   least while in the TLKING substate).  If you want to take over a (user)
   channel completely, the channel can be "mastered" via apimas().  This will
   cause ALL input to be routed to your hook, and no other hook (or TLC itself)
   will see the input.  Note that only one hook can master a channel at a
   time (think about it).  apimas() will return non-zero if it could not
   master the channel, or you can check ahead with masavl(), which returns
   non-zero if the channel CAN be mastered.                                */

/* addhook() returns your hook number, which must be saved if you want to do
   any cycling via apicyc() or channel mastering via apimas().  Pass this
   number back in to apicyc() and your hook will be called with TH_CYCLE
   when it comes in.  If addhook() fails, it returns -1, which probably
   indicates that the hook table is full (msg option) or the hook interface
   had not been initialized (don't forget the Requires: line in your MDF!)
   before you tried to insert your hook.                                   */

int addhook(char *keywd, THOOK hookfn);  /* Add a new TLC hook.            */
int delhook(int hook);                   /* Un-hook self.                  */
void tlcpmt(void);                       /* prfmlt(ETLPMT) from tlcmb.     */
int cycavl(void);                        /* Cycle available on usrnum?     */
int apicyc(int hook);                    /* Inject cycle.                  */
int masavl(void);                        /* Master available on usrnum?    */
int apimas(int hook);                    /* Master channel (exclusively).  */

/* Above functions here are those usable by other modules.  I suggest you
   move them (and the defines/typedef above) to FLASH.H for visibility.    */

/* ----- TLC-only stuff goes below here ---------------------------------- */

void iniapi(void);                      /* Initialize all the tlc API stuff*/
void clsapi(void);                      /* Shutdown/close the tlc API stuff*/
void hupapi(void);                      /* Hang up API stuff.              */
int hdlapi(void);                       /* Check input for TLC hooks.      */
void entapi(void);                      /* Inform hooks of user entering.  */
void exiapi(void);                      /* Inform hooks of user exiting.   */
void joiapi(void);                      /* Inform hooks of user switching. */
void apists(void);                      /* API status handler (CYCLE only).*/
int infapi(void);                       /* Request info from each app      */

/* Above functions are used by TLC to talk to API and not for other apps.
   These prototypes should only be visible to TLC.  I suggest you leave
   them here.                                                              */
