/***************************************************************************
 *                                                                         *
 *   ETLAPI.C                                                              *
 *                                                                         *
 *   Copyright (C) 1993-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   External hook handler.                                                *
 *                                                                         *
 *                                            - M. Donnelly 11/8/93        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "plstuff.h"
#include "message.h"
#include "galetl.h"
#include "flash.h"
#include "bbsutils.h"
#include "etlapi.h"

struct tlchook {
     char *keywd;             /* Or NULL if hook wants all input.          */
     THOOK hookfn;            /* Function to call for this hook.           */
} *tlchook;

int *cycles;                  /* Hooks requesting cycles (per channel).    */
int *master;                  /* Hooks mastering users (per channel).      */

int nhooks;                   /* Maximum number of total hooks;            */
int hooks=0;                  /* Number of hooks in use right now.         */
int init=0;                   /* Have we initialized yet?                  */

void EXPORT __tlcapi(void)    /* GP marker                                 */
{
}

void
iniapi(void)                  /* Initialize all the tlc API stuff.         */
{
     int i;

     init=1;
     setmbk(tlcmb);
     nhooks=numopt(NHOOKS,1,64);
     tlchook=(struct tlchook *)alczer(sizeof(struct tlchook)*nhooks);
     cycles=(int *)alczer(sizeof(int)*nterms);
     master=(int *)alczer(sizeof(int)*nterms);
     for (i=0 ; i < nterms ; i++) {
          master[i]=-1;
          cycles[i]=-1;
     }
     rstmbk();
}

void
clsapi(void)                  /* Shutdown/close the tlc API stuff.         */
{
     int i;

     for (i=0 ; i < hooks ; i++) {
          tlchook[i].hookfn(TH_SHTDWN);
     }
}

void
hupapi(void)                  /* Hang up API stuff.                        */
{
     cycles[usrnum]=-1;
     master[usrnum]=-1;
}

void
apists(void)                  /* API status handler (CYCLE only).          */
{
     int hook;

     if (cycles[usrnum] != -1) {
          hook=cycles[usrnum];
          cycles[usrnum]=-1;
          tlchook[hook].hookfn(TH_CYCLE);
     }
}

int
apicyc(int hook)              /* Inject cycle.                             */
{
     if (cycles[usrnum] == -1) {
          btuinj(usrnum,CYCLE);
          cycles[usrnum]=hook;
          return(0);
     }
     else {
          return(1);
     }
}

int
cycavl(void)                  /* Cycle available on usrnum?                */
{
     if (cycles[usrnum] == -1) {
          return(1);
     }
     else {
          return(0);
     }
}

int
apimas(int hook)              /* Master channel (exclusively).             */
{
     if (hook == -1) {
          master[usrnum]=-1;
          return(0);
     }
     if (master[usrnum] == -1) {
          master[usrnum]=hook;
          return(0);
     }
     else {
          return(1);
     }
}

int
masavl(void)                  /* Master available on usrnum?               */
{
     if (master[usrnum] == -1) {
          return(1);
     }
     else {
          return(0);
     }
}

int
addhook(char*keywd,THOOK hookfn)   /* Add a new TLC hook.                  */
{
     int i=hooks;

     if (!init) {
          return(-1);
     }
     if (i == nhooks) {       /* Hook table is full, return failure code.  */
          return(-1);
     }
     else {
          tlchook[i].hookfn=hookfn;
          if (keywd != NULL) {
               tlchook[i].keywd=alcdup(keywd);
          }
          else {
               tlchook[i].keywd=NULL;
          }
          hooks++;
          return(i);
     }
}

int
delhook(int hook)             /* Un-hook self.                             */
{
     int copy;

     if (hook >= hooks) {
          return(1);
     }
     copy=(hooks-hook)*sizeof(struct tlchook);
     if (copy > 0) {
          memmove(tlchook+hook,tlchook+hook+1,copy);
     }
     hooks--;
     tlchook[hooks].keywd=NULL;
     tlchook[hooks].hookfn=NULL;
     return(0);
}

int
hdlapi(void)                  /* Check input for TLC hooks.                */
{
     int i;
     int hit=0;

     if (master[usrnum] != -1) {
          tlchook[master[usrnum]].hookfn(TH_INPUT);
          return(1);
     }

     for (i=0 ; i < hooks ; i++) {
          if (tlchook[i].keywd == NULL
            || (margc > 0 && sameas(tlchook[i].keywd,margv[0]))) {
               hit=tlchook[i].hookfn(TH_INPUT);
               if (hit) {
                    setmbk(tlcmb);
                    break;
               }
          }
     }
     return(hit);
}

void
entapi(void)                  /* Inform hooks of user entering.            */
{
     int i;

     for (i=0 ; i < hooks ; i++) {
          tlchook[i].hookfn(TH_ENTER);
     }
}

void
exiapi(void)                  /* Inform hooks of user exiting.             */
{
     int i;

     for (i=0 ; i < hooks ; i++) {
          tlchook[i].hookfn(TH_EXIT);
     }
}

void
joiapi(void)                  /* Inform hooks of user switching.           */
{
     int i;

     for (i=0 ; i < hooks ; i++) {
          tlchook[i].hookfn(TH_JOIN);
     }
}

int
infapi(void)                  /* Request info from each app                */
{
     int i;
     int retval=0;

     for (i=0 ; i < hooks ; i++) {
          if (tlchook[i].hookfn(TH_INFO)) {
               retval++;
          }
     }
     return(retval);
}

void
tlcpmt(void)                  /* Re-prompt user.                           */
{
     setmbk(tlcmb);
     prfmlt(ETLPMT);
     rstmbk();
}
