/***************************************************************************
 *                                                                         *
 *   ETLACT.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Entertainment Collection Teleconference action handling routines.     *
 *                                                                         *
 *                                            - M. Donnelly 11/3/93        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "plstuff.h"
#include "message.h"
#include "galetl.h"
#include "flash.h"
#include "bbsutils.h"
#include "etlfsd.h"
#include "etlact.h"
#include "chatlink.h"
#include "spoke.h"

#define AF_STDDIR      0      /* Standard direction (@TU = "Sysop")        */
#define AF_DIROTH      1      /* Directed at target (@TU = "you")          */
#define AF_DIRALL      2      /* Directed at all    (@TU = "everyone")     */
#define AF_DIRNET      3      /* Directed at netusr (@TU = "Sysop@1")      */
#define AF_ACTHELP     4      /* Action help special case.                 */

#ifdef DOCLINK
extern struct usrlist *usrlist;
extern struct netuser *netusr,*othnet;
extern int sysno;
#endif

struct actusr {
     int tlcchn;    /* tlc channel of this user.                           */
     int idx[2];    /* Index of action list (0/1) for this user.           */
     int see[2];    /* Can user see others use action list (0/1)?          */
     int use[2];    /* Can user use actions list (0/1)?                    */
} *actusr;

BTVFILE *actbb;
struct actctl *actctl;
struct actlst *actlst;
int actidx;                        /* Current action idx (0/1!) being used */

#define ABLEFT (ABFSIZ-sizeof(KILCOLR)-1-strlen(vdatmp)) /* Room in vdatmp */

STATIC void loadacts(void);
STATIC char *ads2dst(char *dest,char *src);
STATIC char *adc2dst(char *dest,char src);
STATIC int  adf2dst(char *src,int direct,int fromnum);
STATIC void strlcpy(char *dst,char *src,int num);

void EXPORT __tlcact(void)         /* Marker to show up in GP.OUT files    */
{
}

void
iniact(void)                       /* Initialize the action routines       */
{
     actctl=(struct actctl *)alczer(sizeof(struct actctl)*NLISTS);
     actlst=(struct actlst *)alczer(sizeof(struct actlst)*NLISTS);
     actusr=(struct actusr *)alczer(sizeof(struct actusr)*nterms);
     actbb=opnbtv("GALACT.DAT",sizeof(struct action));
     loadacts();
     dclvda(outbsz);
}

STATIC int
nxtlst(void)                       /* Find an empty action list slot       */
{
     int i;

     for (i=0 ; i < NLISTS && actlst[i].name[0] != '\0' ; i++) {
     }
     if (i == NLISTS) {      /* Ran to end of loop, so no hit - ret error */
          i=-1;
     }
     return(i);
}

/* Note: loadlist depends on the side effect of the list being in the      */
/* scratch buffer (tmplst) for the channel name.                           */

STATIC void
loadlist(int list)                 /* Load in this action list             */
{
     int i=0;
     int numxky=0,xkyidx=0;

     actlst[list]=*tmplst;
     actctl[list].count=0;
     actctl[list].list=NULL;
     memset(tmpact,0,sizeof(struct action));
     strcpy(tmpact->list,actlst[list].name);
     if (qgebtv(tmpact->list,0)) {                /* First pass, count 'em */
          while (1) {
               gcrbtv(NULL,0);
               if (!sameas(tmpact->list,actlst[list].name)) {
                    break;
               }
               if (!sameas(tmpact->list,LSTNAM)) {
                    actctl[list].count++;
                    if (tmpact->actkey[0] != '\0') {
                         numxky++;
                    }
               }
               if (!qnxbtv()) {
                    break;
               }
          }
     }
     if (actctl[list].count > 0) {                /* Second pass, read 'em */
          actctl[list].xkylst=(int *)alczer(sizeof(int)*actctl[list].count);
          actctl[list].xkynam=(KEYNAME *)alczer(KEYSIZ*numxky);
          actctl[list].numxky=numxky;
          actctl[list].list=alczer(ACTSIZ*actctl[list].count);
          memset(tmpact,0,sizeof(struct action));
          strcpy(tmpact->list,actlst[list].name);
          qgebtv(tmpact->list,0);
          while (1) {
               gcrbtv(NULL,0);
               if (!sameas(tmpact->list,actlst[list].name)) {
                    break;
               }
               if (!sameas(tmpact->list,LSTNAM)) {
                    strcpy(IDXACT(actctl[list].list,i),tmpact->name);
                    if (tmpact->actkey[0] != '\0') {
                         actctl[list].xkylst[i]=xkyidx+1;
                         strcpy((char *)&(actctl[list].xkynam[xkyidx]),tmpact->actkey);
                         xkyidx++;
                    }
                    i++;
               }
               if (!qnxbtv()) {
                    break;
               }
          }
     }
}

STATIC void
loadacts(void)                     /* Load in the action lists             */
{
     int next;
     long savpos;

     setbtv(actbb);
     memset(tmplst,0,sizeof(struct actlst));
     strcpy(tmplst->list,LSTNAM);
     if (qgebtv(tmplst->name,0)) {
          while (1) {
               gcrbtv(NULL,0);
               next=nxtlst();
               if (next == -1) {
                    catastro("GALACT: TOO MANY ACTION LISTS IN FILE (!)");
               }
               savpos=absbtv();
               loadlist(next);
               gabbtv(NULL,savpos,0);
               if (!qnxbtv() || !sameas(tmplst->list,LSTNAM)) {
                    break;
               }
          }
     }
     rstbtv();
}

void
lstlst(void)                  /* display available action lists            */
{
     int loop;

     prfmsg(ACTLLST);
     for (loop=0 ; loop < NLISTS ; loop++) {
          if ((actlst[loop].name[0] != '\0') && !actctl[loop].deltag) {
               prfmsg(ACT1,actlst[loop].name);
               if ((loop+1)%4 == 0) {
                    prfmsg(ACTBRK);
                    outprf(usrnum);
               }
          }
     }
     if ((loop+1)%4 != 0) {
          prfmsg(ACTBRK);
     }
}

STATIC int
fndlst(char *lstnam)               /* Find a list index given the name     */
{
     int i;

     if ((lstnam[0] == '\0') || (lstnam == NULL)) {
          return(-1);
     }
     for (i=0 ; i < NLISTS && !sameas(actlst[i].name,lstnam) ; i++) {
     }
     if (i == NLISTS) {
          i=-1;
     }
     return(i);
}

STATIC int
fndact(int lstidx,char *actnam)    /* Find an action in a list             */
{
     char *list=actctl[lstidx].list;
     int comp;
     int mididx;
     int loidx;
     int hiidx;

     if (actctl[lstidx].count == 0) {
          return(0);
     }
     loidx=0;
     hiidx=actctl[lstidx].count-1;
     while (loidx <= hiidx) {
          mididx=loidx+(hiidx-loidx)/2;
          if ((comp=stricmp(actnam,IDXACT(list,mididx))) < 0) {
               if (mididx == loidx) {
                    break;
               }
               hiidx=mididx-1;
          }
          else if (comp > 0) {
               if (mididx == hiidx) {
                    break;
               }
               loidx=mididx+1;
          }
          else {
               return(1);
          }
     }
     return(0);
}

STATIC int
newidx(char *list,int max,char *newact) /* does action word already exist? */
{                                       /* (for adding a new action word)  */
     int i;

     for (i=0 ; i < max ; i++) {
          if (stricmp(IDXACT(list,i), newact) > 0) {
               break;
          }
     }
     return(i);
}

STATIC int
fndidx(char *list,int max,char *newact) /* does action word already exist? */
{                                       /* (for deleting an action word)   */
     int i;

     for (i=0 ; i < max ; i++) {
          if (sameas(IDXACT(list,i),newact)) {
               break;
          }
     }
     return(i);
}

void
clsact(void)                       /* Close down the action routines       */
{
     int i;

     setbtv(actbb);
     for (i=0 ; i < NLISTS ; i++) {
          if (actlst[i].name[0] != '\0' && actctl[i].deltag) {
               memset(tmpact,0,sizeof(struct action));
               strcpy(tmplst->list,LSTNAM);
               strcpy(tmplst->name,actlst[i].name);
               geqbtv(NULL,tmplst->list,0);
               delbtv();
               memset(tmpact,0,sizeof(struct action));
               strcpy(tmpact->list,actlst[i].name);
               if (agebtv(NULL,tmpact->list,0)) {
                    while (1) {
                         delbtv();
                         if (!qnxbtv()) {
                              break;
                         }
                         gcrbtv(NULL,0);
                         if (!sameas(tmpact->list,actlst[i].name)) {
                              break;
                         }
                    }
               }
          }
     }
     rstbtv();
     clsbtv(actbb);
}

int
chkact(struct action * chkact)     /* Is this an existing action?          */
{
     int idx;
     int is;

     idx=fndlst(chkact->list);
     if (idx == -1) {
          return(0);
     }
     if (actctl[idx].deltag) {
          return(-1);
     }
     setbtv(actbb);
     is=acqbtv(chkact,chkact->list,0);
     rstbtv();
     return(is);
}

int
chklst(struct actlst *chklst)      /* Is this an existing action list?     */
{
     int idx;

     idx=fndlst(chklst->name);
     if (idx == -1) {
          return(0);
     }
     *chklst=actlst[idx];
     if (actctl[idx].deltag) {
          return(-1);
     }
     else {
          return(1);
     }
}

int
addact(struct action *newact)      /* Add a new action                     */
{
     int list=fndlst(newact->list);
     int i;
     int osize,oidxsz;
     int copy,copyidx;

     if (list == -1) {
          return(1);
     }
     if (fndact(list,newact->name)) {
          return(1);
     }
     if (actctl[list].count == NACTS) {
          return(1);
     }
     strlwr(newact->name);
     strupr(newact->list);
     if (strstr(newact->complx,"@IN")) {
          newact->isyell=1;
     }
     else {
          newact->isyell=0;
     }
     i=newidx(actctl[list].list,actctl[list].count,newact->name);
     osize=actctl[list].count*ACTSIZ;
     copy=osize-(i*ACTSIZ);
     actctl[list].list=alcrsz(actctl[list].list,osize,osize+ACTSIZ);
     oidxsz=actctl[list].count*sizeof(int);
     copyidx=oidxsz-(i*sizeof(int));
     actctl[list].xkylst=(int *)alcrsz(actctl[list].xkylst,oidxsz,
                                       oidxsz+sizeof(int));
     if (copy > 0) {
          memmove(actctl[list].list+((i+1)*ACTSIZ),
                  actctl[list].list+(i*ACTSIZ),copy);
          memmove(&(actctl[list].xkylst[i+1]),&(actctl[list].xkylst[i]),copyidx);
     }
     strcpy(IDXACT(actctl[list].list,i),newact->name);
     actctl[list].xkylst[i]=0;
     if (newact->actkey[0] != '\0') {
          actctl[list].xkynam=(KEYNAME *)alcrsz(actctl[list].xkynam,
                                     actctl[list].numxky*KEYSIZ,
                                     (actctl[list].numxky+1)*KEYSIZ);
          strcpy((char *)&(actctl[list].xkynam[actctl[list].numxky]),
                 newact->actkey);
          actctl[list].numxky++;
          actctl[list].xkylst[i]=actctl[list].numxky;
     }
     actctl[list].count++;
     setbtv(actbb);
     if (acqbtv(NULL,newact->list,0)) {
          delbtv();
     }
     insbtv(newact);
     rstbtv();
     return(0);
}

int
addlst(struct actlst *newlst)      /* Add a new action list                */
{
     int list=fndlst(newlst->name);

     if (list != -1) {
          return(1);
     }
     list=nxtlst();
     if (list == -1) {
          return(1);
     }
     strupr(newlst->name);
     setbtv(actbb);
     strcpy(newlst->list,LSTNAM);
     actctl[list].count=0;
     actctl[list].list=NULL;
     actlst[list]=*newlst;
     if (acqbtv(NULL,newlst->list,0)) {
          delbtv();
     }
     memset(tmpact,0,sizeof(struct action));
     *tmplst=*newlst;
     insbtv(NULL);
     rstbtv();
     return(0);
}

int
delact(struct action *oldact)      /* Remove an action                     */
{
     int list=fndlst(oldact->list);
     int i;
     int osize;
     int copy;

     if (list == -1) {
          return(1);
     }
     if (!fndact(list,oldact->name)) {
          return(1);
     }
     strlwr(oldact->name);
     strupr(oldact->list);
     i=fndidx(actctl[list].list,actctl[list].count,oldact->name);
     osize=actctl[list].count*ACTSIZ;
     copy=(osize)-((i+1)*ACTSIZ);
     if (copy > 0) {
          memmove(actctl[list].list+(i*ACTSIZ),
                  actctl[list].list+((i+1)*ACTSIZ),copy);
          memmove(&(actctl[list].xkylst[i]),&(actctl[list].xkylst[i+1]),
                  (actctl[list].count-i-1)*sizeof(int));
     }
     actctl[list].list=alcrsz(actctl[list].list,osize,osize-ACTSIZ);
     actctl[list].count--;
     setbtv(actbb);
     if (acqbtv(NULL,oldact->list,0)) {
          delbtv();
     }
     else {
          rstbtv();
     }
     return(0);
}

int
dellst(struct actlst *oldlst)      /* Remove an action list                */
{
     int i=fndlst(oldlst->name);

     if (i == -1) {
          return(1);
     }
     actctl[i].deltag=1;
     return(0);
}

int
chgact(struct action *newact)      /* Change an action                     */
{
     int list=fndlst(newact->list);
     int i;

     if (list == -1) {
          return(1);
     }
     if (!fndact(list,newact->name)) {
          return(1);
     }
     strlwr(newact->name);
     strupr(newact->list);
     if (strstr(newact->complx,"@IN")) {
          newact->isyell=1;
     }
     else {
          newact->isyell=0;
     }
     i=fndidx(actctl[list].list,actctl[list].count,newact->name);
     if (actctl[list].xkylst[i] != 0) {
          if (newact->actkey[0] == '\0') {
               actctl[list].xkylst[i]=0;
          }
          else {
               strcpy((char *)&(actctl[list].xkynam[(actctl[list].xkylst[i])-1]),
                      newact->actkey);
          }
     }
     else {
          if (newact->actkey[0] != '\0') {
               actctl[list].xkynam=(KEYNAME *)alcrsz(actctl[list].xkynam,
                                          actctl[list].numxky*KEYSIZ,
                                          (actctl[list].numxky+1)*KEYSIZ);
               strcpy((char *)&(actctl[list].xkynam[actctl[list].numxky]),
                      newact->actkey);
               actctl[list].numxky++;
               actctl[list].xkylst[i]=actctl[list].numxky;
          }
     }
     setbtv(actbb);
     geqbtv(NULL,newact->list,0);
     updbtv(newact);
     rstbtv();
     return(0);
}

int
chglst(struct actlst *newlst)      /* Change an action list                */
{
     int list=fndlst(newlst->name);

     if (list == -1) {
          return(1);
     }
     strupr(newlst->name);
     strcpy(newlst->list,LSTNAM);
     setbtv(actbb);
     geqbtv(NULL,newlst->list,0);
     updbtv(newlst);
     rstbtv();
     actlst[list]=*newlst;
     uactupd();
     return(0);
}

void                               /* Set this user up for actions         */
setusr(int unum,unsigned tlcchn,char *act1,char *act2)
{
     int i;
     int lstidx;
     struct actusr *curact=actusr+unum;
     char *check=act1;

     for (i=0 ; i < 2 ; i++,check=act2) {
          curact->tlcchn=tlcchn;
          if (check == NULL || (lstidx=fndlst(check)) == -1) {
               curact->idx[i]=-1;
               curact->see[i]=0;
               curact->use[i]=0;
          }
          else {
               curact->idx[i]=lstidx;
               curact->see[i]=gen_haskey(actlst[lstidx].seekey,unum,user+unum);
               curact->use[i]=gen_haskey(actlst[lstidx].usekey,unum,user+unum);
          }
     }
}

#ifdef DOCLINK
STATIC char *
actnam(int unum,int direct)        /* appropriate "name" to direct to      */
{                                  /* (chatlink)                           */
     extern char *nnstg;

     switch (direct) {
     case AF_DIROTH:
          return("you");
     case AF_ACTHELP:
          return("Sysop");
     case AF_DIRALL:
          return("everyone");
     case AF_DIRNET:
          return(spr(nnstg,othnet->userid,othnet->sysno));
     case AF_STDDIR:
          return(uacoff(unum)->userid);
     default:
          return("[??]");
     }
}

STATIC char *
actpos(int unum,int direct)        /* appropriate "name" to direct to      */
{                                  /* (possesive, chatlink)                */
     extern char *nnstg;
     char *temp;

     switch (direct) {
     case AF_DIROTH:
          return("your");
     case AF_ACTHELP:
          return("Sysop's");
     case AF_DIRALL:
          return("everyone's");
     case AF_DIRNET:
          temp=spr(nnstg,othnet->userid,othnet->sysno);
          strcat(temp,"'s");
          return(temp);
     case AF_STDDIR:
          return(spr("%s's",uacoff(unum)->userid));
     default:
          return("[??]");
     }
}

STATIC char *
himher(int unum,int direct)        /* appropriate pronoun                  */
{                                  /* (chatlink)                           */
     switch (direct) {
     case AF_DIROTH:
          return("you");           /* Or your?                             */
     case AF_ACTHELP:
          return("him");
     case AF_DIRALL:
          return("their");
     case AF_DIRNET:
          return(othnet->sex == 'F' ? "her" : "him");
     case AF_STDDIR:
          return(uacoff(unum)->sex == 'F' ? "her" : "him");
     default:
          return("[??]");
     }
}

STATIC char *
hisher(int unum,int direct)        /* appropriate pronoun                  */
{                                  /* (chatlink)                           */
     switch (direct) {
     case AF_DIROTH:
          return("your");
     case AF_ACTHELP:
          return("his");
     case AF_DIRALL:
          return("their");
     case AF_DIRNET:
          return(othnet->sex == 'F' ? "her" : "his");
     case AF_STDDIR:
          return(uacoff(unum)->sex == 'F' ? "her" : "his");
     default:
          return("[??]");
     }
}

#else
STATIC char *
actnam(int unum,int direct)        /* appropriate "name" to direct to      */
{                                  /* (non-chatlink)                       */
     switch (direct) {
     case AF_DIROTH:
          return("you");
     case AF_ACTHELP:
          return("Sysop");
     case AF_DIRALL:
          return("everyone");
     case AF_STDDIR:
          return(uacoff(unum)->userid);
     default:
          return("[??]");
     }
}

STATIC char *
actpos(int unum,int direct)        /* appropriate "name" to direct to      */
{                                  /* (possesive, non-chatlink)            */
     switch (direct) {
     case AF_DIROTH:
          return("your");
     case AF_ACTHELP:
          return("Sysop's");
     case AF_DIRALL:
          return("everyone's");
     case AF_STDDIR:
          return(spr("%s's",uacoff(unum)->userid));
     default:
          return("[??]");
     }
}

STATIC char *
himher(int unum,int direct)        /* appropriate pronoun                  */
{                                  /* (non-chatlink)                       */
     switch (direct) {
     case AF_DIROTH:
          return("you");           /* Or your?                             */
     case AF_ACTHELP:
          if (unum == -1) {
               return("him");
          }
          else {
               return(uacoff(unum)->sex == 'F' ? "her" : "him");
          }
     case AF_DIRALL:
          return("their");
     case AF_STDDIR:
          return(uacoff(unum)->sex == 'F' ? "her" : "him");
     default:
          return("[??]");
     }
}

STATIC char *
hisher(int unum,int direct)        /* appropriate pronoun                  */
{                                  /* (non-chatlink)                       */
     switch (direct) {
     case AF_DIROTH:
          return("your");
     case AF_ACTHELP:
          if (unum == -1) {
               return("him");
          }
          else {
               return(uacoff(unum)->sex == 'F' ? "her" : "his");
          }
     case AF_DIRALL:
          return("their");
     case AF_STDDIR:
          return(uacoff(unum)->sex == 'F' ? "her" : "his");
     default:
          return("[??]");
     }
}
#endif

/* Direct can be:

   AF_STDDIR:  not directed (others see) (@TU/@TS/@TM -> Sysop/his/him)
   AF_DIROTH:  directed at victim        (@TU/@TS/@TM -> you/your/you)
   AF_DIRALL:  to everyone               (@TU/@TS/@TM -> everyone/their/their)
   AF_DIRNET:  to net user (others see)  (@TU/@TS/@TM -> Sysop@1/his/him)
   AF_ACTHELP: action help               (@TU/@TS/@TM -> Sysop/his/him)    */

STATIC char *
actfmt(char *src,int direct,int fromnum)     /* parse action macros        */
{
#ifdef DOCLINK
     extern char *nnstg;
#endif
     int i;
     char *tmp,ascbuf[4];
     static int blink,rcsctr=0;
     static char *dest,fore[7],back[6];

     if (rcsctr++ == 0) {
          dest=vdatmp;
          i=strlen(src)-1;
          while (i >= 0 && src[i] == '\1') {
               src[i]='\0';
               i--;
          }
          rplchr(src,'\1','\n');
          blink=0;
          strcpy(fore,"[1;32m");
          strcpy(back,"[40m");
          setmem(vdatmp,ABFSIZ,0);
     }
     while (*src != '\0') {
          if (*src != '@') {
               dest=adc2dst(dest,*src);
               src++;
          }
          else {
               src++;
               switch (*src) {
               case '@':
                    dest=adc2dst(dest,*src);
                    src++;
                    break;
               case '0':
               case '1':
               case '2':
               case '3':
               case '4':
               case '5':
               case '6':
               case '7':
               case '8':
               case '9':
                    ascbuf[0]=src[0];
                    i=1;
                    while (i < 3 && isdigit(src[i])) {
                         ascbuf[i]=src[i];
                         i++;
                    }
                    ascbuf[i]='\0';
                    dest=adc2dst(dest,atoi(ascbuf));
                    src+=i;
                    break;
               case 'E':
                    dest=adc2dst(dest,'\33');
                    src++;
                    break;
               case 'N':
                    dest=adc2dst(dest,'\n');
                    src++;
                    break;
               case 'C':
                    src++;
                    if (*src == '\n') {
                         src++;
                    }
                    break;
               case 'A':
                    src++;
                    switch (*src) {
                    case '0':
                         dest=ads2dst(dest,"[0m");
                         dest=ads2dst(dest,back);
                         dest=ads2dst(dest,fore);
                         blink=0;
                         break;
                    case '1':
                         dest=ads2dst(dest,"[5m");
                         blink=1;
                         break;
                    default:
                         dest=ads2dst(dest,UNKMAC);
                         break;
                    }
                    src++;
                    break;
               case 'B':
                    src++;
                    switch (*src) {
                    case '0':
                    case '8':
                         dest=ads2dst(dest,"[40m");
                         strcpy(back,"[40m");
                         break;
                    case '1':
                    case '9':
                         dest=ads2dst(dest,"[41m");
                         strcpy(back,"[41m");
                         break;
                    case '2':
                    case 'A':
                         dest=ads2dst(dest,"[42m");
                         strcpy(back,"[42m");
                         break;
                    case '3':
                    case 'B':
                         dest=ads2dst(dest,"[43m");
                         strcpy(back,"[43m");
                         break;
                    case '4':
                    case 'C':
                         dest=ads2dst(dest,"[44m");
                         strcpy(back,"[44m");
                         break;
                    case '5':
                    case 'D':
                         dest=ads2dst(dest,"[45m");
                         strcpy(back,"[45m");
                         break;
                    case '6':
                    case 'E':
                         dest=ads2dst(dest,"[46m");
                         strcpy(back,"[46m");
                         break;
                    case '7':
                    case 'F':
                         dest=ads2dst(dest,"[47m");
                         strcpy(back,"[47m");
                         break;
                    default:
                         dest=ads2dst(dest,UNKMAC);
                         break;
                    }
                    src++;
                    break;
               case 'F':
                    src++;
                    switch (*src) {
                    case 'P':
                         if (fromnum) {
#ifdef DOCLINK
                              dest=ads2dst(dest,spr(nnstg,usaptr->userid,sysno));
#endif
                         }
                         else {
                              dest=ads2dst(dest,usaptr->userid);
                         }
                         dest=ads2dst(dest,"'s");
                         break;
                    case 'U':
                         if (fromnum) {
#ifdef DOCLINK
                              dest=ads2dst(dest,spr(nnstg,usaptr->userid,sysno));
#endif
                         }
                         else {
                              dest=ads2dst(dest,usaptr->userid);
                         }
                         break;
                    case 'S':
                         dest=ads2dst(dest,hisher(usrnum,0));
                         break;
                    case 'M':
                         dest=ads2dst(dest,himher(usrnum,0));
                         break;
                    default:
                         if ((*src >= 'A' && *src <= 'F') || isdigit(*src)) {
                              switch (*src) {
                              case '0':
                                   dest=ads2dst(dest,"[0;30");
                                   strcpy(fore,"[0;30");
                                   break;
                              case '1':
                                   dest=ads2dst(dest,"[0;31");
                                   strcpy(fore,"[0;31");
                                   break;
                              case '2':
                                   dest=ads2dst(dest,"[0;32");
                                   strcpy(fore,"[0;32");
                                   break;
                              case '3':
                                   dest=ads2dst(dest,"[0;33");
                                   strcpy(fore,"[0;33");
                                   break;
                              case '4':
                                   dest=ads2dst(dest,"[0;34");
                                   strcpy(fore,"[0;34");
                                   break;
                              case '5':
                                   dest=ads2dst(dest,"[0;35");
                                   strcpy(fore,"[0;35");
                                   break;
                              case '6':
                                   dest=ads2dst(dest,"[0;36");
                                   strcpy(fore,"[0;36");
                                   break;
                              case '7':
                                   dest=ads2dst(dest,"[0;37");
                                   strcpy(fore,"[0;37");
                                   break;
                              case '8':
                                   dest=ads2dst(dest,"[1;30");
                                   strcpy(fore,"[1;30");
                                   break;
                              case '9':
                                   dest=ads2dst(dest,"[1;31");
                                   strcpy(fore,"[1;31");
                                   break;
                              case 'A':
                                   dest=ads2dst(dest,"[1;32");
                                   strcpy(fore,"[1;32");
                                   break;
                              case 'B':
                                   dest=ads2dst(dest,"[1;33");
                                   strcpy(fore,"[1;33");
                                   break;
                              case 'C':
                                   dest=ads2dst(dest,"[1;34");
                                   strcpy(fore,"[1;34");
                                   break;
                              case 'D':
                                   dest=ads2dst(dest,"[1;35");
                                   strcpy(fore,"[1;35");
                                   break;
                              case 'E':
                                   dest=ads2dst(dest,"[1;36");
                                   strcpy(fore,"[1;36");
                                   break;
                              case 'F':
                                   dest=ads2dst(dest,"[1;37");
                                   strcpy(fore,"[1;37");
                                   break;
                              }
                              if (blink) {
                                   dest=ads2dst(dest,";5");
                              }
                              dest=adc2dst(dest,'m');
                              strcat(fore,"m");
                         }
                         else {
                              dest=ads2dst(dest,UNKMAC);
                         }
                         break;
                    }
                    src++;
                    break;
               case 'T':
                    src++;
                    if ((othusn == -1) && (direct != AF_ACTHELP)
                     && (direct != AF_DIRALL)) {
                         dest=ads2dst(dest,"(No @T context!)");
                         src++;
                         break;
                    }
                    switch (*src) {
                    case 'P':
                         dest=ads2dst(dest,actpos(othusn,direct));
                         break;
                    case 'U':
                         dest=ads2dst(dest,actnam(othusn,direct));
                         break;
                    case 'S':
                         dest=ads2dst(dest,hisher(othusn,direct));
                         break;
                    case 'M':
                         dest=ads2dst(dest,himher(othusn,direct));
                         break;
                    default:
                         dest=ads2dst(dest,UNKMAC);
                         break;
                    }
                    src++;
                    break;
               case 'I':
                    src++;
                    if (*src == 'N') {
                         if (direct == AF_ACTHELP) {
                              dest=ads2dst(dest,"(User input here)");
                         }
                         else {
                              if (margc > 1) {
                                   rstrin();
                                   dest=ads2dst(dest,margv[1]);
                                   parsin();
                              }
                         }
                    }
                    else {
                         dest=ads2dst(dest,UNKMAC);
                    }
                    src++;
                    break;
               case '<':
                    src++;
                    if (rcsctr != 1) {
                         dest=ads2dst(dest,"(No recursed files)");
                    }
                    else if ((tmp=strchr(src,'>')) == NULL) {
                         dest=ads2dst(dest,UNKMAC);
                    }
                    else {
                         *tmp='\0';
                         if (!adf2dst(src,direct,fromnum)) {
                              dest=ads2dst(dest,"(File not found)");
                         }
                         *tmp='>';
                         src=tmp+1;
                    }
                    break;
               default:
                    dest=ads2dst(dest,UNKMAC);
                    src++;
                    break;
               }
          }
     }
     if (--rcsctr == 0) {
          strcat(dest,KILCOLR);
     }
     xlttxv(vdatmp,ABFSIZ);
     return(vdatmp);
}

STATIC char *
ads2dst(                           /* Add macro expansion string to dest   */
char *dest,                        /*   destination pointer (inside vdatmp)*/
char *src)                         /*   string to add to dest              */
{
     strlcpy(dest,src,ABLEFT);
     return(dest+strlen(dest));
}

STATIC char *
adc2dst(                           /* Add macro expansion character to dest*/
char *dest,                        /*   destination pointer (inside vdatmp)*/
char src)                          /*   character to add to dest           */
{
     if (ABLEFT > 0) {
          *dest++=src;
     }
     return(dest);
}

STATIC int
adf2dst(                           /* Add macro expansion file to dest     */
char *src,                         /*   file to add to dest                */
int direct,                        /*   direct parameter for actfmt()      */
int fromnum)                       /*   fromnum parameter for actfmt()     */
{
     FILE *fp;
     char linbuf[255];

     if (rsvnam(src)) {
          return(0);
     }
     if ((fp=fopen(src,FOPRA)) != NULL) {
          while (fgets(linbuf,sizeof(linbuf),fp) != NULL && ABLEFT > 0) {
               actfmt(linbuf,direct,fromnum);
          }
          fclose(fp);
          return(1);
     }
     return(0);
}

STATIC void
strlcpy(                           /* copy a string with limit              */
char *dst,
char *src,
int num)      /* total # of bytes in destination, including '\0' terminator */
{
     int i;

     for (i=0 ; i < num-1 && *src != '\0' ; i++) {
          *dst++=*src++;
     }
     *dst='\0';
}

STATIC void
dmplst(int idx,int ignkey)         /* Dump this list to the current user   */
{
     int i,wpl=0;
     char *list=actctl[idx].list;
     int keyidx;

     for (i=0 ; i < actctl[idx].count ; i++) {
          keyidx=actctl[idx].xkylst[i];
          if (ignkey || !keyidx || haskey((char *)&(actctl[idx].xkynam[keyidx-1]))) {
               prfmsg(ACT1,IDXACT(list,i));
               wpl++;
               if (wpl == 4) {
                    wpl=0;
                    prfmsg(ACTBRK);
                    outprf(usrnum);
               }
          }
     }
     if (wpl != 4) {
          prfmsg(ACTBRK);
     }
}

STATIC void
sholst(void)                       /* Show this user his action list(s)    */
{
     int first=0;

     if (actusr[usrnum].use[0] && !(actctl[actusr[usrnum].idx[0]].deltag)) {
          first=1;
          prfmsg(ACTLIST,actlst[actusr[usrnum].idx[0]].name);
          dmplst(actusr[usrnum].idx[0],0);
     }
     if (actusr[usrnum].use[1] && !(actctl[actusr[usrnum].idx[1]].deltag)) {
          if (first) {
               prfmsg(ACTBRK);
          }
          prfmsg(ACTLIST,actlst[actusr[usrnum].idx[1]].name);
          dmplst(actusr[usrnum].idx[1],0);
     }
     if (!first) {
          prfmsg(NOACTS);
     }
     else {
          prfmsg(ACTBRK);
     }
}

void
lstact(char *lstnam,int ignkey)    /* List action words in single list     */
{
     int tempidx;

     prfmsg(ACTLIST,strupr(lstnam));
     tempidx=fndlst(lstnam);
     if (tempidx == -1) {
          return;
     }
     dmplst(tempidx,ignkey);
     prfmsg(ACTBRK);
}

STATIC int
isempty(char *targ)                /* check for an empty action            */
{
     return(sameas(targ,"\1\1\1"));
}

STATIC void
acthlp(void)                       /* Perform action help for cur action   */
{
     if (isempty(tmpact->complx)) {             /* Simple action         */
          prfmsg(SIMPHLP2,tmpact->name,actfmt(tmpact->simple,AF_ACTHELP,0));
          return;
     }
     else {
          othusn=-1;
          if (isempty(tmpact->simple)) {         /* Forced yell or direct */
               if (tmpact->isyell) {
                    prfmsg(YELLHLP2,tmpact->name,tmpact->name,actfmt(tmpact->complx,AF_ACTHELP,0));
               }
               else {
                    prfmsg(DIRHLP2,tmpact->name,tmpact->name,actfmt(tmpact->complx,AF_ACTHELP,0));
               }
          }
          else {
               if (tmpact->isyell) {
                    prfmsg(CYELHLP3,tmpact->name,tmpact->name,actfmt(tmpact->simple,AF_ACTHELP,0));
                    prfmsg(CYELHLP4,tmpact->name,tmpact->name,actfmt(tmpact->complx,AF_ACTHELP,0));
               }
               else {
                    prfmsg(CDIRHLP3,tmpact->name,tmpact->name,actfmt(tmpact->simple,AF_ACTHELP,0));
                    prfmsg(CDIRHLP4,tmpact->name,tmpact->name,actfmt(tmpact->complx,AF_ACTHELP,0));
               }
          }
     }
}

STATIC void                        /* Show mlt buf to most people on chan  */
shoact(int tlcchn,int exunm1,int exunm2)
{
     int loop;
     char sav,*ptr;

     ptr=prfptr;
     prfmlt(ETLPMT);
     sav=*ptr;
     for (loop=0 ; loop < nterms ; loop++) {
          if (loop != exunm1 && loop != exunm2
            && actusr[loop].tlcchn == tlcchn) {
               if (actusr[loop].see[actidx]) {
                    if ((user[loop].state == tlcstt)
                     && (user[loop].substt == TLKING)
                     || (user[loop].substt == LINKED)) {
                         if (!(chkfgt(loop,usrnum) || chkign(loop,usrnum))) {
                              switch (user[loop].substt) {
                              case TLKING:
                                   outmlt(loop);
                                   break;
                              case LINKED:
                                   *ptr='\0';
                                   undupe(prfbuf+findstar(prfbuf),1);
                                   *ptr=sav;
                                   *(ptr-1)='\0';
                                   btuxmt(loop,prfbuf+findstar(prfbuf));
                                   btuxct(loop,1,"\r");
                                   *(ptr-1)='\r';
                                   break;
                              }
                         }
                    }
               }
          }
     }
     clrmlt();
}

STATIC void
shoone(int unum)                   /* Show mlt buf to single user          */
{
     prfmlt(ETLPMT);
     outmlt(unum);
     clrmlt();
}

STATIC void
asimpl(void)                       /* Process simple action command        */
{
     othusn=-1;     /* actfmt() will catch this and error on @T's          */
     if (isempty(tmpact->simple)) {     /* No simple for this action!?     */
          prfmsg(tmpact->isyell ? MUSTYEL : MUSTDIR,tmpact->name,tmpact->name);
     }
     else {
          prfmlt(ACTFRAME,actfmt(tmpact->simple,AF_STDDIR,0));
          shoact(actusr[usrnum].tlcchn,usrnum,-1);
          prfmsg(RESFRAME,actfmt(tmpact->resp,AF_STDDIR,0));
     }
}

STATIC void
acomplx(void)                      /* Process complex action command       */
{
     int count;
     int secret=0;

     if (tmpact->isyell) {
          othusn=-1;     /* actfmt() will catch this and error on @T's     */
          prfmlt(ACTFRAME,actfmt(tmpact->complx,AF_STDDIR,0));
          shoact(actusr[usrnum].tlcchn,usrnum,-1);
          prfmsg(RESFRAME,actfmt(tmpact->resp,AF_STDDIR,0));
     }
     else {
          if (sameas(margv[margc-1],"secretly")) {
               secret=1;
               margn[margc-2][0]='\0';
          }
          if (sameas(margv[1],"all")) {
               if (secret) {
                    prfmsg(NAASEC,tmpact->name);
               }
               else {
                    prfmlt(ACTFRAME,actfmt(tmpact->complx,AF_DIRALL,0));
                    shoact(actusr[usrnum].tlcchn,usrnum,-1);
                    prfmsg(RESFRAME,actfmt(tmpact->resp,AF_DIRALL,0));
               }
          }
          else {
               fndusr(usrnum,margv[1],1,2,&count);
               if (count == 0) {
                    prfmsg(WHSNHR,margv[1]);
               }
               else if (count > 1) {
                    prfmsg(AMBIG,margv[1],tmpact->name);
               }
               else if (!actusr[othusn].see[actidx]) {
                    prfmsg(CNTSEE,othuap->userid,tmpact->name);
               }
               else if (chkign(othusn,usrnum)) {
                    prfmsg(IGNORN2,othuap->userid);
               }
               else if (chkfgt(othusn,usrnum)) {
                    prfmsg(FORGTN,othuap->userid);
               }
               else if (secret) {
                    prfmlt(ACTFRAMS,actfmt(tmpact->complx,AF_DIROTH,0));
                    shoone(othusn);
                    prfmsg(RESFRAMS,actfmt(tmpact->resp,AF_STDDIR,0),othuap->userid);
               }
               else {
                    prfmlt(ACTFRAME,actfmt(tmpact->complx,AF_DIROTH,0));
                    shoone(othusn);
                    prfmlt(ACTFRAME,actfmt(tmpact->complx,AF_STDDIR,0));
                    shoact(actusr[usrnum].tlcchn,usrnum,othusn);
                    prfmsg(RESFRAME,actfmt(tmpact->resp,AF_STDDIR,0));
               }
          }
     }
}

STATIC int
hdllst(int idx)                    /* Check input against this action      */
{
     int is=fndact(idx,margv[0]);
     int i;

     if (!is) {
          return(0);
     }
     strcpy(tmpact->list,actlst[idx].name);
     strcpy(tmpact->name,margv[0]);
     setbtv(actbb);
     if (!acqbtv(NULL,tmpact->list,0)) {
          rstbtv();
          return(0);
     }
     rstbtv();
     i=fndidx(actctl[idx].list,actctl[idx].count,margv[0]);
     if (actctl[idx].xkylst[i] != 0
         && !haskey(actctl[idx].xkynam[(actctl[idx].xkylst[i])-1])) {
          return(0);
     }
     if (margc == 2 && (sameas(margv[1],"?") || sameas(margv[1],"help"))) {
          acthlp();
          return(1);
     }
     if (isempty(tmpact->complx) || margc == 1) {  /* Simple/basic action*/
          asimpl();
     }
     else {
          acomplx();
     }
     return(1);
}

void
actlist(void)                 /* show action words in list                 */
{
     if (actusr[usrnum].use[0] == 0 && actusr[usrnum].use[1]) {
          prfmsg(ACTCANT);
     }
     else {
          sholst();
     }
}

void
action(void)                  /* handle "action" keyword input             */
{
     int shwlst=FALSE;

     if (!hasmkey(ACTKEY)) {
          tpfmsg(ACLIVO);
          howbuy();
          return;
     }
     if (sameas(margv[1],"on")) {
          swtact(usrnum, tlcptr->channel);
          tlcoff(usrnum)->flags|=ACTION;
          prfmsg(ACTMON);
     }
     else if (sameas(margv[1],"off")) {
          tlcoff(usrnum)->flags&=~ACTION;
          prfmsg(ACTMOF);
     }
     else if (sameas(margv[1],"list")) {
          if (margc == 2) {
               sholst();
          }
          else {
               if (actusr[usrnum].use[0]) {
                    if (sameas(actlst[actusr[usrnum].idx[0]].name,margv[2])
                        && !(actctl[actusr[usrnum].idx[0]].deltag)) {
                         shwlst=TRUE;
                    }
                    else if (!shwlst && actusr[usrnum].use[1]) {
                         if (sameas(actlst[actusr[usrnum].idx[1]].name,margv[2])
                             && !(actctl[actusr[usrnum].idx[1]].deltag)) {
                              shwlst=TRUE;
                         }
                    }
                    if (shwlst) {
                         lstact(margv[2],0);
                    }
                    else {
                         prfmsg(NOSLST);
                    }
               }
          }
     }
     else if (sameas(margv[1],"edit")) {
          if (hasmkey(AEDTKEY) || hasmkey(TSYSKEY)) {
               if (aedctrl.user == -1) {
                    if (!(usrptr->flags&INVISB)) {
                         tpfmlt(ENTEDT,usaptr->userid);
                         outtlc();
                    }
                    setusr(usrnum,tlcptr->channel,NULL,NULL);
                    usrptr->substt=EDTLIST;
                    aedctrl.user=usrnum;
                    aedctrl.state=LEDHDRP;
                    prfmsg(LEDHDR);
                    prfmsg(LEDHDRP);
               }
               else {
                    prfmsg(LEDBUSY);
               }
          }
          else {
               prfmsg(ACTSTF2);
          }
     }
     else {
          prfmsg(ACTSTF2);
     }
}


int
hdlact(void)                       /* Handle usrnum's action entry         */
{
     int filter=0;

     if (margc == 0 || !isalnum(input[0])) {
          return(0);
     }
     for (actidx=0 ; actidx < 2 ; actidx++) {
          if (actusr[usrnum].use[actidx]) {
               if (hdllst(actusr[usrnum].idx[actidx])
                   && !(actctl[actusr[usrnum].idx[actidx]].deltag)) {
                    filter=1;
                    break;
               }
          }
     }
     return(filter);
}

void
cpyausr(int dstusr,int srcusr)     /* Copy action info for linking         */
{
     actusr[dstusr]=actusr[srcusr];
}

#ifdef DOCLINK
STATIC void
anetsimpl(void)                    /* Process simple action command. (net) */
{
     othusn=-1;          /* actfmt() will catch this and error on @T's     */
     if (isempty(tmpact->simple)) {     /* No simple for this action!?     */
          prfmsg(tmpact->isyell ? MUSTYEL : MUSTDIR,tmpact->name,tmpact->name);
     }
     else {
          sendactmsg(NULL,0,usrlist[usrnum].vc,
                     actfmt(tmpact->simple,AF_STDDIR,1));
          prfmlt(ACTFRAME,actfmt(tmpact->simple,AF_STDDIR,0));
          shoact(actusr[usrnum].tlcchn,usrnum,-1);
          prfmsg(RESFRAME,actfmt(tmpact->resp,AF_STDDIR,0));
     }
}

STATIC void
anetcomplx(void)                   /* Process complex action command. (net)*/
{
     int count;
     int secret=0;

     if (tmpact->isyell) {
          othusn=-1;     /* actfmt() will catch this and error on @T's     */
          sendactmsg(NULL,0,usrlist[usrnum].vc,
                     actfmt(tmpact->complx,AF_STDDIR,1));
          prfmlt(ACTFRAME,actfmt(tmpact->complx,AF_STDDIR,0));
          shoact(actusr[usrnum].tlcchn,usrnum,-1);
          prfmsg(RESFRAME,actfmt(tmpact->resp,AF_STDDIR,0));
     }
     else {
          rstrin();                                              /* CLR 6  */
          if (sameas(margv[margc-1],"secretly")) {
               secret=1;
               margn[margc-2][0]='\0';
          }
          if (sameas(margv[1],"all")) {
               if (secret) {
                    prfmsg(NAASEC,tmpact->name);
               }
               else {
                /* First, show the net users the action going to "all"     */
                    sendactmsg(NULL,0,usrlist[usrnum].vc,
                               actfmt(tmpact->complx,AF_DIRALL,1));
                /* Next, show the local users the action going to "all"    */
                    prfmlt(ACTFRAME,actfmt(tmpact->complx,AF_DIRALL,0));
                    shoact(actusr[usrnum].tlcchn,usrnum,-1);
                /* That done, format the response and leave it in prfbuf   */
                    prfmsg(RESFRAME,actfmt(tmpact->resp,AF_DIRALL,0));
               }
          }
          else {
               if ((count=guessname(margv[1],"action")) == 2) {  /* CLR 7  */
                    return;
               }
               if (count == 0 || othnet->vc != usrlist[usrnum].vc) {/* CLR 8  */
                    prfmsg(WHSNHR,margv[1]);
                    prfmsg(ETLPMT);                              /* CLR 9  */
                    outprf(usrnum);
                    return;
               }
               /* Set up othusn so actfmt() can find it when necessary     */
               othusn=othnet->usrnum;
               if (secret) {
                    if (othnet->sysno != sysno) {
                         strcpy(prfbuf,actfmt(tmpact->complx,AF_DIROTH,1));
                         strcat(prfbuf,"...secretly!");
                         sendactres(othnet->userid,othnet->sysno,prfbuf);
                    }
                    else {
                         prfmsg(ACTFRAMS,actfmt(tmpact->complx,AF_DIROTH,0));
                         shoone(othnet->usrnum);
                    }
                    sprintf(tempname,nnstg,othnet->userid,othnet->sysno);       /* SJN 62 */
                    prfmsg(RESFRAMS,actfmt(tmpact->resp,AF_DIROTH,0),tempname); /* SJN 62 */
               }
               else {
                    if (othnet->sysno != sysno) {
                       /* First, show targetted net user                   */
                         strcpy(prfbuf,actfmt(tmpact->complx,AF_DIROTH,1));
                         sendactres(othnet->userid,othnet->sysno,prfbuf);
                       /* Next show other users in this channel on net     */
                         strcpy(prfbuf,actfmt(tmpact->complx,AF_DIRNET,1));
                         sendactmsg(othnet->userid,othnet->sysno,
                                    usrlist[usrnum].vc,prfbuf);
                       /* Then show other users in this channel locally    */
                         prfmlt(ACTFRAME,actfmt(tmpact->complx,AF_DIRNET,0));
                         shoact(actusr[usrnum].tlcchn,usrnum,-1);
                       /* Show response with net @ stuff on                */
                         prfmsg(RESFRAME,actfmt(tmpact->resp,AF_DIRNET,0));
                    }
                    else {
                       /* First, show targetted local user                 */
                         prfmlt(ACTFRAME,actfmt(tmpact->complx,AF_DIROTH,0));
                         shoone(othnet->usrnum);
                       /* Next show other users in this channel on net     */
                         strcpy(prfbuf,actfmt(tmpact->complx,AF_DIRNET,1));
                         sendactmsg(NULL,0,usrlist[usrnum].vc,prfbuf);
                       /* Then show other users in this channel locally    */
                         prfmlt(ACTFRAME,actfmt(tmpact->complx,AF_STDDIR,0));
                         shoact(actusr[usrnum].tlcchn,usrnum,othusn);
                       /* Show response with no net @ stuff on             */
                         prfmsg(RESFRAME,actfmt(tmpact->resp,AF_DIROTH,0));
                    }
               }
          }
     }
     prfmsg(ETLPMT);                                             /* CLR 10 */
     outprf(usrnum);                                             /* CLR 11 */
}

STATIC int
hdlnetlst(int idx)                 /* Check inp against this action. (net) */
{
     int is=fndact(idx,margv[0]);

     if (!is) {
          return(0);
     }
     strcpy(tmpact->list,actlst[idx].name);
     strcpy(tmpact->name,margv[0]);
     setbtv(actbb);
     if (!acqbtv(NULL,tmpact->list,0)) {
          rstbtv();
          return(0);
     }
     rstbtv();
     if (margc == 2 && (sameas(margv[1],"?") || sameas(margv[1],"help"))) {
          acthlp();
          prfmsg(ETLPMT);
          outprf(usrnum);
          return(1);
     }
     if (isempty(tmpact->complx) || margc == 1) {    /* Simple action    */
          anetsimpl();
          prfmsg(ETLPMT);
          outprf(usrnum);
     }
     else {
          anetcomplx();
     }
     return(1);
}

int
netchkact(void)                    /* Handle usrnum's action entry. (net)  */
{
     int filter=0;

     if (margc == 0 || !isalnum(input[0])) {
          return(0);
     }
     if (!(tlcoff(usrnum)->flags&ACTION)) {
          return(0);
     }
     for (actidx=0 ; actidx < 2 ; actidx++) {
          if (actusr[usrnum].use[actidx]) {
               if (hdlnetlst(actusr[usrnum].idx[actidx])) {
                    filter=1;
                    break;
               }
          }
     }
     return(filter);
}
#endif
