/***************************************************************************
 *                                                                         *
 *   ENTTLC.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS Entertainment Collection telecon handler.       *
 *                                                                         *
 *                                            - T. Stryker 3/2/89          *
 *    Action Enhancements and Mods            - S. Brinker & R. Skurnick   *
 *                                            - 3/25/89                    *
 *    Tele-Games Enhancements and Mods        - J. Kobal 6/21/90           *
 *    API, chan edtr, action edtr, etc.       - J. Moriarty 11/1/93        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "plstuff.h"
#include "message.h"
#include "galetl.h"
#include "fsdbbs.h"
#include "etlfsd.h"
#include "etlact.h"
#include "etlapi.h"
#include "flash.h"
#include "bbsutils.h"

#ifdef DOCLINK                /* if defined, CHATLINK is active       */
#include "chatlink.h"
#include "spoke.h"

int sysno;
int netrpt;
struct usrlist *usrlist;

#undef STATIC
#define STATIC static
#define CSTATIC
#else
#define CSTATIC static
#endif

STATIC int tlclog(void);
CSTATIC int telecn(void);
STATIC void tcsthn(void);
STATIC void tlchup(void);
STATIC void deltlc(char *userid);
STATIC void clstlc(void);

#ifdef DOCLINK
struct module enttlcmd={      /* module interface block               */
     "",                      /*    name used to refer to this module */
     tlclog,                  /*    user logon supplemental routine   */
     spokecheck,              /*    input routine if selected         */
     spokethn,                /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     tlchup,                  /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     deltlc,                  /*    delete-account routine            */
     clstlc                   /*    finish-up (sys shutdown) routine  */
};
#else
struct module enttlcmd={      /* module interface block               */
     "",                      /*    name used to refer to this module */
     tlclog,                  /*    user logon supplemental routine   */
     telecn,                  /*    input routine if selected         */
     tcsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     tlchup,                  /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     deltlc,                  /*    delete-account routine            */
     clstlc                   /*    finish-up (sys shutdown) routine  */
};
#endif

int tlcstt;                   /* teleconferencing state number             */

#define NEEDCO -1             /* target user-id count when colon is needed */

FILE *tlcmb;                  /* teleconf named-message file block pointer */
static
BTVFILE *tbb;                 /* BTRIEVE file pointer for tele. profiles   */
static
BTVFILE *tchbb;               /* BTRIEVE file pointer for channel info     */

struct tlc *tlclst,           /* one to a customer (dynamic array)         */
           *tlcptr,*tptr;     /* handy pointers for speed                  */

struct tlc2 *tl2lst,          /* one to a customer (dynamic array)         */
           *tl2ptr;           /* handy pointers for speed                  */

struct chanls *chnlst;        /* channel arrays                            */

#define FNDBIT(u) (1L<<((u)&0x1F))
#define INVFLS(u) invites[(u)/32]
#define FORFLS(u) forgets[(u)/32]
#define IGNFLS(u) ignores[(u)/32]

struct tlcdat tlcdat;

int (*tlcpfn)(unsigned)=ck4pfn  ;  /* Initialize tlc profanity handler     */

static
struct telemisc {             /* miscellaneous teleconference data         */
     int edtin;               /*   sysop editor is in use                  */
     int wchmsg;              /*   which message is being edited           */
     int entchg;              /*   entrance message changed boolean        */
     int extchg;              /*   exit message changed boolean            */
     int updrec;              /*   record must be updated                  */
     char uname[UIDSIZ];      /*   who's being changed (user-id)           */
} *telmisc;                   /* dynamic allocated occurence of structure  */

                              /* bit flag definitions for updrec           */
#define UPDFLG 1              /*   updated one of the users flags          */
#define UPDMSG 2              /*   updated one of the users messages       */

/*--- OPTIONS FROM GALETL.MSG ---*/

int tinpsz,                   /* allowable input size for teleconference   */
    starsq,                   /* want asterisks in front of async msgs?    */
    chtlok,                   /* initialize chatlink routines              */
    npaymx;                   /* max times can talk per session if no pay  */

static
int nswchx,                   /* max times can switch chans or on-off/15sec*/
    sopbel,                   /* Sysop page at main console bell period    */
    dftpop,                   /* default page option setting (ON/OFF/OK)   */
    oktocg,                   /* ok to charge for teleconference messages  */
    dispad,                   /* display charges on auditrail              */
    lnkaud,                   /* generate audit trail entry per linkup?    */
    msgchg,                   /* amount of charges if ok to charge         */
    etlccr,                   /* teleconference credit consumption rate    */
    etlcov,                   /* does the tele cc rate over-ride Forums'?  */
    eswtfr,                   /* allow usrs to swt to & from Forum chans?  */
    etlpst,                   /* number of credits a TLCOp can post        */
    numchan,                  /* Number of public channels available       */
    whs2pag,                  /* Convert failed whispers to pages?         */
    badpag;                   /* the current page just failed              */

char *diahay,                 /* outgoing dial prefix for Hayes-category   */
     *diaxec,                 /* outgoing dial prefix for XECOM-category   */
     dirchr;                  /* Character to indicate directed message    */

static
char *linkpw,                 /* incoming link-up request password         */
     *somoth,                 /* displaying names of users in telecon      */
     *defalst,                /* action list for private/Forum channels    */
     *defalst2;               /* 2nd action list for private/Forum channels*/

#define FSDHDR 40             /* max RIP/FSD header length                 */

static
char fsdhdr1[FSDHDR],         /* FSD header (channel edit) for moderator   */
     fsdhdr2[FSDHDR],         /* FSD header (channel edit)                 */
     fsdhdr3[FSDHDR],         /* FSD header (channel create)               */
     fsdhdr4[FSDHDR],         /* FSD header (action list edit)             */
     fsdhdr5[FSDHDR],         /* FSD header (action list create)           */
     fsdhdr6[FSDHDR],         /* FSD header (action word edit)             */
     fsdhdr7[FSDHDR];         /* FSD header (action word create)           */

STATIC void g2chan(int chno);
STATIC void linkup(void);
STATIC void lvchi(int eximsg,int ntrmsg);
STATIC void dial(void);
STATIC int chnavl(int chan);
CSTATIC char tlchat(int chan,int ch);
STATIC int quitlc(void);
CSTATIC void tlcctx(int userno);
STATIC int glopag(void);
STATIC void page(void);
STATIC void pospag(char *pagmsg);
STATIC void chat(void);
STATIC void invite(void);
STATIC void devite(void);
STATIC void unifor(void);
STATIC void forget(void);
STATIC void rememb(void);
STATIC void ignore(void);
STATIC void notice(void);
STATIC void join(void);
STATIC int chncnt(void);
STATIC void rewhisper(char *what);
STATIC void whisper(char *whoto,int mnum);
STATIC void direct(char *whoto,int mnum);
STATIC void tlctck(void);
STATIC void initls(void);
STATIC char *tlsrui(void);
STATIC void psdasc(void);
STATIC void ret2tl(int who);
STATIC void hupchi(int xitmsg);
STATIC void actas(int usrnm);
STATIC void echo(void);
STATIC void teditor(void);
STATIC void tedtmnu(void);
STATIC void edtr01(void);
STATIC void edtr02(void);
STATIC void edtr03(void);
STATIC void edtr04(void);
STATIC void edtr05(void);
STATIC void edtr06(void);
STATIC void edtr07(void);
STATIC void edtr08(void);
STATIC void usredt(void);
STATIC void chkhdl(void);
STATIC void pmtedw(void);
STATIC void edtwch(void);
STATIC void updrent(void);
STATIC void updrext(void);
STATIC void updflag(int flag);
STATIC void shomsg(void);
STATIC void updmsg(void);
STATIC void dedcds(void);
STATIC void chgmsg(void);
STATIC void tlcscan(void);
STATIC void setupchn(void);
STATIC void lstchn(void);
STATIC unsigned entertlc(char *destchan);
STATIC int ckchned(void);
STATIC int cfgchn(void);
STATIC int cfglst(void);
STATIC int cfgact(void);
STATIC void movehome(int userno);

void EXPORT
init__enttlc(void)                 /* initialize teleconference module     */
{
     int i;
     char *cp;

     stzcpy(enttlcmd.descrp,gmdnam("GALETL.MDF"),MNMSIZ);
     tlcstt=register_module(&enttlcmd);
     tlcmb=opnmsg("galetl.mcv");
     tbb=opnbtv("galetlp.dat",sizeof(struct tlcdat));
     tchbb=opnbtv("galetlch.dat",sizeof(struct chanls));
     tlclst=alctile(nterms,sizeof(struct tlc));
     for (i=0 ; i < nterms ;  i++) {
          setmem(tlcoff(i),sizeof(struct tlc),0);
     }
     tl2lst=(struct tlc2 *)alczer(nterms*sizeof(struct tlc2));
     telmisc=(struct telemisc *)alcmem(sizeof(struct telemisc));
     numchan=numopt(NUMCHAN,1,100);
     chnlst=(struct chanls *)alczer(numchan*sizeof(struct chanls));
     cedctrl.state=0;
     cedctrl.user=-1;
     aedctrl.state=0;
     aedctrl.user=-1;
     cedctrl.channel=BADCHAN;
     setmem(telmisc,sizeof(struct telemisc),0);
     starsq=ynopt(STARSQ);
     npaymx=numopt(NPAYMX,0,32767);
     nswchx=numopt(NSWCHX,1,32767);
     tinpsz=numopt(TINPSZ,1,255);
     sopbel=numopt(SOPBEL,0,2000);
     cp=lastwd(rawmsg(DFTPOP));
     dftpop=*(cp+strlen(cp)-1);
     oktocg=ynopt(OKTOCG);
     dispad=ynopt(DISPAD);
     msgchg=numopt(MSGCHG,1,32767);
     linkpw=stgopt(LINKPW);
     lnkaud=ynopt(LNKAUD);
     diahay=stgopt(DIAHAY);
     diaxec=stgopt(DIAXEC);
     etlccr=numopt(ETLCCR,-32767,32767);
     etlcov=ynopt(ETLCOV);
     chtlok=ynopt(CHTLOK);
     etlpst=numopt(ETLPST,0,9999);
     somoth=stgopt(SOMOTH);
     defalst=stgopt(DEFALST);
     defalst2=stgopt(DEFALST2);
     dirchr=chropt(DIRCHR);
     whs2pag=ynopt(WHS2PAG);
     stzcpy(fsdhdr1,getasc(FSDHDR1),FSDHDR);
     stzcpy(fsdhdr2,getasc(FSDHDR2),FSDHDR);
     stzcpy(fsdhdr3,getasc(FSDHDR3),FSDHDR);
     stzcpy(fsdhdr4,getasc(FSDHDR4),FSDHDR);
     stzcpy(fsdhdr5,getasc(FSDHDR5),FSDHDR);
     stzcpy(fsdhdr6,getasc(FSDHDR6),FSDHDR);
     stzcpy(fsdhdr7,getasc(FSDHDR7),FSDHDR);
     eswtfr=(etlcov || ynopt(ESWTFR));
     if (nswchx == 9999) {
          nswchx=0;
     }
     if (tjoinrou == NULL) {
          tjoinrou=joint;
     }
     rtkick(10,tlctck);
     globalcmd(glopag);
     iniact();
     initfsd();
     iniapi();
     inifla();
     setupchn();
#ifdef DOCLINK
     if (chtlok) {
          inispoke();              /* initialize CHATLINK if enabled       */
     }
#endif
}

void
joint(chan)                        /* join teleconference from other module*/
unsigned chan;
{
     tlcptr=tlcoff(usrnum);
     if (!(usrptr->flags&X2MAIN)) {
          tlcptr->flags|=RSTX2M;
          usrptr->flags|=X2MAIN;
     }
     tlcptr->retstt=usrptr->state;
     tlcptr->retsub=usrptr->substt;
     tlcptr->retrat=usrptr->crdrat;
     tlcptr->flags|=XTOOTH;
     swtchn(usrnum,chan+SIGOFF);
     usrptr->state=tlcstt;
     usrptr->substt=0;
     telecn();
}

STATIC int
tlclog(void)                       /* teleconference supplemental logon   */
{
     setbtv(tbb);
     setmbk(tlcmb);
     tlcptr=tlcoff(usrnum);
     tl2ptr=&tl2lst[usrnum];
     tlcptr->rewhsps=-1;
     tlcptr->rewhspu=-1;
     tl2ptr->ntrwhs[0]='\0';
     tlcptr->prvchn=usrnum+CHNOFF;
     if (!acqbtv(&tlcdat,usaptr->userid,0)) {
          setmem(&tlcdat,sizeof(struct tlcdat),0);
          strcpy(tlcdat.userid,usaptr->userid);
          switch (dftpop) {
          case 'N':
               tlcdat.pagsts=1;
               break;
          case 'F':
               tlcdat.pagsts=2;
               break;
          case 'K':
               tlcdat.pagsts=3;
               break;
          }
          tlcdat.defchn=1;
          tlcdat.action=1;
          tlcdat.pagint=8;
          tlcdat.chaint=8;
          insbtv(&tlcdat);
     }
     tlcptr->pflags=tlcdat.flags;
     if ((tlcptr->defchn=tlcdat.defchn) == 2) {
          tlcptr->channel=usrnum+CHNOFF;
     }
     if ((tlcptr->action=tlcdat.action) == 1) {
          if (hasmtkey(ACTKEY)) {
               tlcptr->flags|=ACTION;
          }
     }
     switch ((tlcptr->pagsts=tlcdat.pagsts)) {
     case 1:  /* on */
          break;
     case 2:  /* off */
          tlcptr->flags|=NOPAGE;
          break;
     case 3:  /* ok  */
          tlcptr->flags|=OKPAGE;
          break;
     }
     tlcptr->pagint=tlcdat.pagint;
     tlcptr->chaint=tlcdat.chaint;
     strcpy(tl2ptr->entmsg,tlcdat.entmsg);
     strcpy(tl2ptr->extmsg,tlcdat.extmsg);
     if (hasmtkey(TOPKEY)) {
          strcpy(tlcptr->theme,tlcdat.theme);
          strcpy(tlcptr->topic,tlcdat.theme);
     }
     return(0);
}

CSTATIC int
telecn(void)                       /* main teleconferencing input handler  */
{
     int savusn,i,count;
     void (*rouptr)();
     char uid[UIDSIZ],*ptr;

     setmbk(tlcmb);
     tlcptr=tlcoff(usrnum);
     tl2ptr=&tl2lst[usrnum];
     switch (usrptr->substt) {
     case 0:
          rstrin();
          ptr=input+1;
          while ((*ptr != '\0') && (*ptr == ' ')) {
               ++ptr;
          }
          parsin();
          i=entertlc(ptr);
          if (!axschn(usrnum,i)) {
               i=findhome(usrnum);
          }
          swtchn(usrnum,i);
          usrptr->substt=TLKING;
          btumil(usrnum,tinpsz);
          btuxnf(usrnum,0,19);
          if (!(usrptr->flags&INVISB)) {
               entrmsg();
               outtlc();
          }
          tpfmsg(INTRO);
          tlcctx(usrnum);
          if (etlcov || !(tlcptr->flags&XTOOTH)) {
               usrptr->crdrat=etlccr;
          }
          entapi();
          break;
     case TLKING:
          if (hdlapi()) {
               break;
          }
          if (margc == 0) {
               if (!(usrptr->flags&INJOIP)) {
                    tlcctx(usrnum);
               }
               else {
                    prfmsg(ETLPMT);
                    outprf(usrnum);
                    return(1);
               }
               break;
          }
          if (input[inplen-1] == '^') {
               tpfmsg(MSGABT);
               break;
          }
          if (!urinv()) {
               if (ck4fla()) {
                    break;
               }
          }
          else {
               clrprf();
          }
          if (margc == 1) {
               if (sameas(margv[0],"#") || sameas(margv[0],"users")) {
                    usrson();
                    prfmsg(ETLPMT);
                    outprf(usrnum);
                    clrprf();
                    break;
               }
               if (sameas(margv[0],"?") || sameas(margv[0],"/?")) {
                    tpfmsg(TLCHLP2,netchar,dirchr);
                    break;
               }
               if (sameas(margv[0],"x") || sameas(margv[0],"/x")) {
                    if (nswchx && (tlcptr->flags&JUSTEX)
                     && !(usrptr->flags&OPCHAT)) {
                         tpfmsg(NANNOY);
                         break;
                    }
                    telext();
                    if (!(usrptr->flags&INVISB)) {
                         tlcptr->flags|=JUSTEX;
                         if ((!(chnlst[tlcptr->channel].flags&CENTERX))
                          || (!strlen(tl2ptr->extmsg))) {
                              tpfmlt(LVITLC,usaptr->userid);
                         }
                         else {
                              tpfmlt(EXISKL,tl2ptr->extmsg);
                         }
                         outtlc();
                    }
                    tpfmsg(EXITLC);
                    return(quitlc());
               }
               if (sameas(margv[0],"edit") || sameas(margv[0],"/e")) {
                    if (nswchx && (tlcptr->flags&JUSTEX)
                     && !(usrptr->flags&OPCHAT)) {
                         tpfmsg(NANNOY);
                         break;
                    }
                    telext();
                    if (!(usrptr->flags&INVISB)) {
                         tlcptr->flags|=JUSTEX;
                         tpfmlt(ENTEDT,usaptr->userid);
                         outtlc();
                    }
                    tedtmnu();
                    break;
               }
               if (sameas(margv[0],"//")) {
                    tpfmsg(RWHSFMT);
                    break;
               }
               if (sameas(margv[0],"menu") && hasmtkey(MNUKEY)) {
                    if (telmisc->edtin) {
                         tpfmsg(EDTINU);
                         break;
                    }
                    telext();
                    if (!(usrptr->flags&INVISB)) {
                         tlcptr->flags|=JUSTEX;
                         tpfmlt(ENTEDT,usaptr->userid);
                         outtlc();
                    }
                    usredt();
                    break;
               }
               if (sameas(margv[0],"list")) {
                    lstchn();
                    prfmsg(LSTFTR);
                    break;
               }
               if (sameas(margv[0],"games")) {
                    prfmsg(TLGHDR);
                    if (infapi() == 0) {
                         setmbk(tlcmb);
                         prfmsg(TLGNON);
                    }
                    else {
                         setmbk(tlcmb);
                    }
                    break;
               }
               if (sameas(margv[0],"main") || sameas(margv[0],"/m")) {
                    if (tlcptr->channel == MNCHAN) {
                         tpfmsg(PUBCHN,chnlst[0].name);
                    }
                    else if (!eswtfr && tlcptr->channel < CHNOFF
                      && tlcptr->channel >= SIGOFF && !(usrptr->flags&MASTER)) {
                         tpfmsg(CANTEX);
                    }
                    else if (!axschn(usrnum,MNCHAN)) {
                         tpfmsg(NAXSCHN);
                    }
                    else {
                         g2chan(0);
                    }
                    break;
               }
               if (sameas(margv[0],"scan") || sameas(margv[0],"/s")) {
                    tlcscan();
                    break;
               }
               if (sameas(margv[0],"action") || sameas(margv[0],"/a")) {
                    tpfmsg(ACTSTF2);
                    break;
               }
               if (sameas(margv[0],"forget") || sameas(margv[0],"/f")) {
                    forget();
                    break;
               }
               if (sameas(margv[0],"remember")) {
                    rememb();
                    break;
               }
               if (sameas(margv[0],"ignore")) {
                    ignore();
                    break;
               }
               if (sameas(margv[0],"notice")) {
                    notice();
                    break;
               }
               if (sameas(margv[0],"open")
                && modchn(usrnum,tlcptr->channel)) {
                    chnlst[tlcptr->channel].flags&=~COPENCL;
                    edtchn(&chnlst[tlcptr->channel],1);
                    prfmsg(CHNOPEN);
                    break;
               }
               if (sameas(margv[0],"close")
                && modchn(usrnum,tlcptr->channel)) {
                    chnlst[tlcptr->channel].flags|=COPENCL;
                    edtchn(&chnlst[tlcptr->channel],1);
                    prfmsg(CHNCLSD);
                    break;
               }
               if (sameas(margv[0],"channel")) {
                    i=ckchned();
                    if (i == 1) {
                         setusr(usrnum,tlcptr->channel,NULL,NULL);
                         telext();
                         break;
                    }
                    else if (i == 2) {
                         setusr(usrnum,tlcptr->channel,NULL,NULL);
                         outprf(usrnum);
                         telext();
                         return(1);
                    }
               }
               if (sameas(margv[0],"squelch") && hasmtkey(TLCOPKY)) {
                    tpfmsg(SQLHLP);
                    break;
               }
          }
          if (margc == 2) {
               if (sameas(margv[0],"echo") || sameas(margv[0],"/h")) {
                    echo();
                    break;
               }
               if (sameas(margv[0],"invite") || sameas(margv[0],"/i")) {
                    invite();
                    break;
               }
               if (sameas(margv[0],"uninvite") || sameas(margv[0],"/u")) {
                    devite();
                    break;
               }
               if (sameas(margv[0],"forget") || sameas(margv[0],"/f")) {
                    forget();
                    break;
               }
               if (sameas(margv[0],"remember")) {
                    rememb();
                    break;
               }
               if (sameas(margv[0],"ignore")) {
                    ignore();
                    break;
               }
               if (sameas(margv[0],"notice")) {
                    notice();
                    break;
               }
          }
          if (sameas(margv[0],"action") || sameas(margv[0],"/a")) {
               action();
               break;
          }
          if (sameas(margv[0],"chat") || sameas(margv[0],"/c")) {
               if (tlcptr->pflags&SQULCH) {
                    tpfmsg(SQLRBF2);
               }
               else {
                    chat();
               }
               break;
          }
          if (sameas(margv[0],"join") || sameas(margv[0],"/j")) {
               join();
               break;
          }
          if (hasmtkey(DIALKY) && sameas(margv[0],"dial")) {
               telext();
               dial();
               break;
          }
          if (margc == 3 && sameas(margv[0],"link")) {
               telext();
               if (!sameas(margv[1],linkpw)) {
                    tpfmsg(LPWNOG);
                    break;
               }
               if (lnkaud) {
                    shocst("TELECONFERENCE LINK-UP","%s linked with %.7s",
                           usaptr->userid,margv[2]);
               }
               if (!(usrptr->flags&INVISB)) {
                    tpfmlt(XFORMD,usaptr->userid,margv[2]);
                    outtlc();
               }
               for (i=1 ; i < nmods ; i++) {
                    if (i != tlcstt && (rouptr=module[i]->huprou) != NULL) {
                         (*rouptr)();
                    }
               }
               setmbk(tlcmb);
               tlcptr=tlcoff(usrnum);
               tl2ptr=&tl2lst[usrnum];
               usaptr->usedat=today();
               updacc();
               usrptr->class=BBSPRV;
               usrptr->flags|=NOZAP;
               sprintf(usaptr->userid,"(%.7s)",margv[2]);
               btubsz(usrnum,OUTSIZ/2,OUTSIZ/2);
               btutrg(usrnum,OUTSIZ-1);
               btuinj(usrnum,CYCLE);
               setmem(tlcptr->inpbuf,INPSIZ,0);
               linkup();
               prfmsg(LINKDM);
               break;
          }
          if (margc >= 2 && sameas(margv[0],"post")
            && hasmtkey(TLCOPKY)) {
               if (!etlpst) {
                    prfmsg(NOTPST);
               }
               else {
                    rstrin();
                    stzcpy(uid,margv[1],UIDSIZ);
                    zonkhl(uid);
                    switch (addcrd(uid,spr("%d",etlpst),0)) {
                    case -1:
                         prfmsg(BDPUID);
                         break;
                    case 1:
                         saycrd(spr("%d",etlpst),0);
                    case 0:
                         prfmsg(OKPUID,etlpst,uid);
                         break;
                    }
               }
               break;
          }
          if (margc >= 2 && (sameas(margv[0],"zappo") || sameas(margv[0],"/z"))
           && hasmtkey(TLCOPKY)) {
               rstrin();
               if (margv[margc-1][0] == '/') {
                    margn[margc-2][0]='\0';
               }
               if (onsysn(margv[1],1)) {
                    kilchn(othusn);
                    setmbk(tlcmb);
                    clrprf();
                    prfmsg(ZAPDOK);
                    if (margv[margc-1][0] == '/' && hasmtkey(DELKEY)) {
                         if (tolower(margv[margc-1][1]) == 'd') {
                              if (delacct(othuap->userid) >= 0) {
                                   prfmsg(ZAPDDL);
                                   shocst("TELE-USER DELETED",
                                         "%s deleted by %s",othuap->userid,
                                         usaptr->userid);
                              }
                              else {
                                   prfmsg(ZAPDND);
                              }
                         }
                         else if (tolower(margv[margc-1][1]) == 's') {
                              kiluid(othuap->userid);
                              prfmsg(ZAPDSU);
                         }
                    }
               }
               else {
                    prfmsg(ZAPDNO);
               }
               break;
          }
          if (margc >= 2 && sameas(margv[0],"squelch")
           && hasmtkey(TLCOPKY)) {
               rstrin();
               setbtv(tbb);
               if (qeqbtv(margv[1],0)) {
                    gcrbtv(&tlcdat,0);
                    if (tlcdat.flags&SQULCH) {
                         if (onsysn(tlcdat.userid,1)) {
                              tlcoff(othusn)->pflags&=~SQULCH;
                              if ((othusp->state == tlcstt)
                               && (othusp->substt == TLKING)) {
                                   tpfmlt(SQLUUND);
                                   tpfmlt(ETLPMT);
                                   outmlt(othusn);
                              }
                         }
                         tlcdat.flags&=~SQULCH;
                         updbtv(&tlcdat);
                         tpfmsg(SQLSUND,tlcdat.userid);
                         outprf(usrnum);
                    }
                    else {
                         if (onsysn(tlcdat.userid,1)) {
                              if (othkey(getmsg(TSYSKEY))) {
                                   tpfmsg(SQLNSYS);
                                   break;
                              }
                              tlcoff(othusn)->pflags|=SQULCH;
                              if ((othusp->state == tlcstt)
                               && (othusp->substt == TLKING)) {
                                   tpfmlt(SQLUDNE2);
                                   tpfmlt(ETLPMT);
                                   outmlt(othusn);
                              }
                         }
                         else {
                              if (uidkey(tlcdat.userid,getmsg(TSYSKEY))) {
                                   tpfmsg(SQLNSYS);
                                   break;
                              }
                         }
                         tlcdat.flags|=SQULCH;
                         updbtv(&tlcdat);
                         tpfmsg(SQLSDNE,tlcdat.userid);
                         outprf(usrnum);
                    }
               }
               else {
                    tpfmsg(SQLNSUCH);
               }
               break;
          }
          if (margc >= 2) {
               if (sameas(margv[0],"invite") || sameas(margv[0],"/i")) {
                    invite();
                    break;
               }
               if (sameas(margv[0],"uninvite") || sameas(margv[0],"/u")) {
                    devite();
                    break;
               }
               if (sameas(margv[0],"forget") || sameas(margv[0],"/f")) {
                    forget();
                    break;
               }
               if (sameas(margv[0],"remember") || sameas(margv[0],"/r")) {
                    rememb();
                    break;
               }
               if (sameas(margv[0],"ignore")) {
                    ignore();
                    break;
               }
               if (sameas(margv[0],"notice")) {
                    notice();
                    break;
               }
          }
          if (sameas(margv[0],"page") || sameas(margv[0],"/p")) {
               page();
               break;
          }
          if (tlcpfn(tlcptr->channel)) {
               break;
          }
          if (sameas(margv[0],"topic") || sameas(margv[0],"/t")) {
               if (!urinv()) {
                    if (tlcptr->pflags&SQULCH) {
                         tpfmsg(SQLRBF2);
                    }
                    else if (margc == 1) {
                         tlcptr->topic[0]='\0';
                         tpfmsg(CLRTHE);
                    }
                    else if (!hasmtkey(TOPKEY)) {
                         tlcptr->topic[0]='\0';
                         tpfmsg(NOTHEM);
                         howbuy();
                    }
                    else {
                         rstrin();
                         *(margv[1]+TPCSIZ-1)='\0';
                         strcpy(tlcptr->topic,margv[1]);
                         if (tlcptr->channel == tlcptr->prvchn) {
                              tpfmlt(NOWTHE,usaptr->userid,tlcptr->topic);
                              outtlc();
                         }
                         tpfmsg(URTHEM,tlcptr->topic);
                    }
               }
               break;
          }
          if (!hasmtkey(UNLKEY) && (tlcptr->inpcnt)++ >= npaymx) {
               tpfmsg(NPAYXC,npaymx);
               howbuy();
               break;
          }
          if (sameas(margv[0],"whisper")) {
               if (!urinv()) {
                    if (tlcptr->pflags&SQULCH) {
                         tpfmsg(SQLRBF2);
                    }
                    else if (margc < 4) {
                         tpfmsg(WHSFMT2);
                    }
                    else {
                         whisper(margv[2],2);
                    }
               }
               break;
          }
          if (margv[0][0] == '/') {
               if (!urinv()) {
                    if (tlcptr->pflags&SQULCH) {
                         tpfmsg(SQLRBF2);
                    }
                    else if (margv[0][1] == '/') {
                         rewhisper(&margv[0][2]);
                    }
                    else if (margc < 2 || margv[0][1] == '\0') {
                         tpfmsg(WHSFMT2);
                    }
                    else {
                         whisper(margv[0]+1,0);
                    }
               }
               break;
          }
          if (margv[0][0] == dirchr) {
               if (!urinv()) {
                    if (tlcptr->pflags&SQULCH) {
                         tpfmsg(SQLRBF2);
                    }
                    else if (margc < 2 || margv[0][1] == '\0') {
                         tpfmsg(DIRFMT,dirchr);
                    }
                    else {
                         direct(margv[0]+1,0);
                    }
               }
               break;
          }
          if (tlcptr->pflags&SQULCH) {
               tpfmsg(SQLRBF2);
               break;
          }
          if (urinv()) {
               prfmsg(ETLPMT);
               outprf(usrnum);
               return(1);
          }
          if (tlcptr->flags&ACTION) {
               if (hdlact()) {
                    break;
               }
          }
          rstrin();
#ifdef DOCLINK
          if (nettlc()) {     /* CHATLINK */
               return(1);     /* CHATLINK */
          }                   /* CHATLINK */
#endif
          tpfmlt(TLCFRM,usaptr->userid,input);
          outtlc();
          if (chncnt() == 1) {
               tpfmsg(BYSELF);
          }
          else {
               prfmsg(NMSENT);
          }
          break;
     case CHTING:
          if (margc == 1 && sameas(margv[0],"x")) {
               lvchi(EXICH2,ENTTLC);
               if (usrptr->flags&OPCHAT) {
                    clrprf();
                    actas(tlcptr->chatch);
                    lvchi(EXICH2,ENTTLC);
                    outprf(usrnum);
                    actas(tlcptr->chatch);
               }
          }
          else {
               return(1);
          }
          break;
     case LNKING:
          if (margc == 1 && sameas(margv[0],"x")) {
               if (usaptr->userid[0] != '(') {
                    lvchi(EXILNK,ENTTLC);
                    savusn=usrnum;
                    actas(tlcptr->chatch);
                    btubsz(usrnum,INPSIZ,OUTSIZ);
                    rstchn();
                    actas(savusn);
               }
          }
          else if (margc > 0 && (sameas(margn[margc-1]-7,"LINKED!")
                              || sameas(margn[margc-1]-14,"LLIINNKKEEDD!!"))) {
               if (usaptr->userid[0] == '(') {
                    actas(tlcptr->chatch);
                    lvchi(LINKOK,LKDTLC);
                    prfmsg(ETLPMT);
                    outprf(usrnum);
                    actas(tlcptr->chatch);
                    cpyausr(usrnum,tlcptr->chatch);
                    linkup();
               }
               return(1);
          }
          else if (usaptr->userid[0] == '(') {
               if (bdspec()) {
                    shochl("Linking Teleconferences",'',
                            baudat(usrptr->baud,0));
               }
               return(1);
          }
          else {
               return(1);
          }
          break;
     case LINKED:
          if (margc == 0) {
               return(1);
          }
          if (*margv[0] == ':') {
               margv[0]++;
          }
          if (margc == 1 && sameas(margv[0],"***")) {
               return(1);
          }
          for (i=0,count=0 ; i < margc ; i++) {
               if (*margv[i] != '(' && ++count >= 2) {
                    break;
               }
               if (sameas(margv[i],usaptr->userid)) {
                    return(1);
               }
          }
          rstrin();
          ptr=getmsg(NMSENT);
          stpans(ptr);
          if (!sameto(margv[i],ptr)
            && undupe(margv[0],0)
            && undupe(margv[0]+1,0)
            && undupe(margv[0]+2,0)) {
               tpfmlt(LNMSKL,usaptr->userid,margv[0]);
               outtlc();
          }
          return(1);
     case GOING:
     case FLHING:
          return(1);
     case EDTCHAN:
          if (!cfgchn()) {
               outprf(usrnum);
               return(1);          /* Bail if gone into FSD                */
          }
          break;
     case EDTLIST:
          if (!cfglst()) {
               outprf(usrnum);
               return(1);
          }
          break;
     case EDTACTN:
          if (!cfgact()) {
               outprf(usrnum);
               return(1);
          }
          break;
     default:
          if (pfnlvl >= 2 && usrptr->pfnacc > WRNPFN) {
               tpfmsg(RAUNCH);
               break;
          }
          if (pfnlvl > 2) {
               tpfmsg(PFNWRD);
               break;
          }
          switch (usrptr->substt) {
          case 10:
               teditor();
               break;
          case 11:
               edtr01();
               break;
          case 12:
               edtr02();
               break;
          case 13:
               edtr03();
               break;
          case 14:
               edtr04();
               break;
          case 15:
               edtr05();
               break;
          case 16:
               edtr06();
               break;
          case 17:
               edtr07();
               break;
          case 18:
               edtr08();
               break;
          case 90:
               chkhdl();
               break;
          case 91:
               edtwch();
               break;
          case 92:
               updmsg();
               break;
          default:
               catastro("ENTTLC SUBSTT=%d ERROR",usrptr->substt);
          }
     }
     if (usrptr->substt == TLKING && *prfbuf != '\0') {
          prfmsg(ETLPMT);
     }
     outprf(usrnum);
     return(1);
}

int
ck4pfn(unsigned chnnum)            /* check for profanity and deal with it */
{
     int retval=0;

     if (chnnum < SIGOFF) {
          if (chnlst[chnnum].flags&CPROFAN) {
               if (pfnlvl > 1 && usrptr->pfnacc >= pfnlvl) {
                    usrptr->pfnacc-=pfnlvl;
               }
               return(0);
          }
     }
     if (usrptr->pfnacc > MAXPFN) {
          btuinj(usrnum,RING);
          prf("");
          retval=1;
     }
     else if (pfnlvl >= 2 && usrptr->pfnacc > WRNPFN) {
          prfmsg(RAUNCH);
          retval=1;
     }
     else if (pfnlvl > 2) {
          prfmsg(PFNWRD);
          retval=1;
     }
     return(retval);
}

/* Delete a channel by name.  "save" is TRUE to indicate deletion should   */
/* be reflected on disk, else only delete from RAM  (API)                  */

int
delchn(char *chnnam,int save)
{
     unsigned chnnum;

     chnnum = idxchn(chnnam);
     if (chnnum == BADCHAN) {
          return(1);
     }
     return(ndelchn(chnnum,save));
}

int
ndelchn(unsigned chnnum,int save) /* Del chan by number (API)             */
{
     unsigned loop;
     char chnnam[CHNSIZ];

     if (chnnum >= numchan) {
          return(1);
     }
     if (chnlst[chnnum].name[0] == '\0') {
          return(1);
     }
     strcpy(chnnam,chnlst[chnnum].name);
     memset(&chnlst[chnnum],'\0',sizeof(struct chanls));
     for (loop = 0 ; loop < nterms ; loop++) {
          if (tlcoff(loop)->channel == chnnum) {
               if (user[loop].state == tlcstt) {
                    if (user[loop].substt != TLKING) {
                         swtchn(loop,findhome(loop));
                    }
                    else {
                         movehome(loop);
                         tpfmsg(CHNDELD);
                         tlcctx(loop);
                         tpfmsg(ETLPMT);
                         outprf(loop);
                    }
               }
               else {
                    swtchn(loop,MNCHAN);
               }
          }
     }
     if (save) {
          return(ersechn(chnnam));
     }
     return(0);
}

int
ersechn(char *chnnam)              /* Erase chan from DAT  (API)           */
{
     setbtv(tchbb);
     if (acqbtv(NULL,chnnam,0)) {
          delbtv();
          rstbtv();
          return(0);
     }
     else {
          rstbtv();
          return(1);
     }
}

/* Create a channel. "save" indicates chan should be saved to disk (API)   */

int
addchn(struct chanls *newchan,char save)
{
     int loop;

     setbtv(tchbb);
     if (idxchn(newchan->name) != BADCHAN) {
          rstbtv();
          return(1);
     }
     for (loop=0 ; loop < numchan ; loop++) {
          if (chnlst[loop].name[0] == '\0') {
               chnlst[loop]=*newchan;
               if (save) {
                    insbtv(newchan);
               }
               rstbtv();
               return(0);
          }
     }
     rstbtv();
     return(1);
}

/* Edit a channel. "save" indicates changes should be saved to disk. (API) */
/* 0 = all is well, 1 = no such channel found,                             */
/* 2 = changed in RAM but not found on disk                                */

int
edtchn(struct chanls *edtchan,char save)
{
     unsigned chnnum;

     chnnum=chkpub(edtchan->name);
     if (chnnum == BADCHAN) {
          return(1);
     }
     chnlst[chnnum]=*edtchan;
     if (save) {
          setbtv(tchbb);
          if (acqbtv(NULL,edtchan->name,0)) {
               *((struct chanls *)tchbb->data)=*edtchan;
               updbtv(NULL);
               rstbtv();
               return(0);
          }
          else {
               rstbtv();
               return(2);
          }
     }
     return(0);
}

int
chkpub(char *chnnam)     /* is this a valid public channel?  (API)         */
{
     int loop;

     if (chnnam == NULL) {
          return(BADCHAN);
     }
     for (loop = 0 ; loop < numchan ; loop++) {
          if (chnlst[loop].name[0] != '\0') {
               if (sameas(chnnam,chnlst[loop].name)) {
                    return(loop);
               }
          }
     }
     return(BADCHAN);
}

int
chkpfn(unsigned chnnum)       /* is profanity allowed on chnnum?  (API)    */
{
     if (chnlst[chnnum].flags&CPROFAN) {
          return(1);
     }
     else {
          return(0);
     }
}

int
chkeex(unsigned chnnum)       /* are enter/exits used on chnnum?  (API)    */
{
     if (chnlst[chnnum].flags&CENTERX) {
          return(1);
     }
     else {
          return(0);
     }
}

int
chkcls(unsigned chnnum)       /* is chnnum closed?  (API)                  */
{
     if (chnlst[chnnum].flags&COPENCL) {
          return(1);
     }
     else {
          return(0);
     }
}

int
avspcchn(void)                /* is there an avail chan slot in RAM?  (API)*/
{
     int loop;

     for (loop = 0 ; loop < numchan ; loop++) {
          if (chnlst[loop].name[0] == '\0') {
               return(TRUE);
          }
     }
     return(FALSE);
}

STATIC void
lstchn(void)                  /* list out all chans the user has access to */
{
     int loop;
     int seeall=FALSE;
     int clinked;
     int closed;

     if (hasmtkey(TSYSKEY)) {
          seeall=TRUE;
     }
     prfmsg(LSTHDR);
     for (loop=0 ; loop < numchan ; loop++) {
          if (chnlst[loop].name[0] != '\0') {
               if (seeall || axschn(usrnum,loop)) {
#ifdef DOCLINK
                    clinked=(netactive && (netmain == loop));
#else
                    clinked=FALSE;
#endif
                    closed=chkcls(loop);
                    prfmsg(LSTCHN,chnlst[loop].name,chnlst[loop].topic,
                      (clinked ? "(ChatLink)" : ""),
                      (closed ? "(Closed)" : ""));
               }
          }
     }
}

STATIC void
setupchn(void)                /* initialize channel arrays                 */
{
     int chancnt;
     int chanlft;
     struct chanls tempchan;

     setbtv(tchbb);
     chanlft=qlobtv(0);
     if (!chanlft) {
          catastro("GALETL: NO CHANNELS IN DAT FILE");
     }
     if (acqbtv(NULL,MNNAME,0)) {
          chnlst[0]=*((struct chanls *)tchbb->data);
     }
     else {
          catastro("GALETL: NO MAIN CHANNEL");
     }
     chanlft=qlobtv(0);
     chancnt=1;
     while (chanlft) {
          gcrbtv(&tempchan,0);
          if (!sameas(tempchan.name,MNNAME)) {
               chnlst[chancnt]=tempchan;
               chancnt++;
          }
          chanlft=qnxbtv();
     }
     rstbtv();
}

/* Send to everyone on chan except for user1 and user2                     */
/* user1 - must be valid, and is the source of the message                 */
/* flags - CANFORG, CANIGNO.  Assumes user1 is source, so                  */
/* cannot be -1  (API)                                                     */

void
outchan(unsigned chan,int flags,int user1,int user2)
{
     char sav,*ptr;
     struct tlc *tmptlc;
     int loop;

     setmbk(tlcmb);
     ptr=prfptr;
     prfmlt(ETLPMT);
     sav=*ptr;
     for (loop=0 ; loop < nterms ; loop++) {
          if (loop != user1 && loop != user2 && user[loop].state == tlcstt) {
               tmptlc=tlcoff(loop);
               if (chan == tmptlc->channel) {
                    if (!(flags&CANFORG
                     && tmptlc->FORFLS(user1)&FNDBIT(user1))) {
                         if (!(flags&CANIGNO && ((tmptlc->flags&IGNRAL)
                          || tmptlc->IGNFLS(user1)&FNDBIT(user1)))) {
                              switch (user[loop].substt) {
                              case TLKING:
                                   outmlt(loop);
                                   break;
                              case LINKED:
                                   *ptr='\0';
                                   undupe(prfbuf+findstar(prfbuf),1);
                                   *ptr=sav;
                                   *(ptr-1)='\0';
                                   btuxmt(loop,prfbuf+findstar(prfbuf));
                                   btuxct(loop,1,"\r");
                                   *(ptr-1)='\r';
                                   break;
                              }
                         }
                    }
               }
          }
     }
     clrmlt();
     rstmbk();
}

STATIC void
tlcscan(void)                 /* scan user currently in teleconference     */
{
     struct tlc *tp;

     tpfmsg(NSCNHDR);
     for (othusn=0 ; othusn < nterms ; othusn++) {
          tp=tlcoff(othusn);
          othusp=&user[othusn];
          if (othusp->state == tlcstt && !(othusp->flags&INVISB)) {
               prf("%-30s... ",uacoff(othusn)->userid);
               if (tlcptr->FORFLS(othusn)&FNDBIT(othusn)) {
                    prf("* ");
               }
               else {
                    prf("  ");
               }
               if (tlcptr->INVFLS(othusn)&FNDBIT(othusn)) {
                    prf("* ... ");
               }
               else {
                    prf("  ... ");
               }
               if (othusp->substt == CHTING) {
                    prf(" (Chatting)");
               }
               else if (othusp->substt == LNKING) {
                    prf(" (Linking)");
               }
               else if (othusp->substt >= EDTING) {
                    prf(" (Editing)");
               }
#ifdef DOCLINK
               else if ((chtlok) && (tp->channel >= CHNOFF+nterms)) {
                    prf("%s",vcusrnum(othusn));               /* CHATLINK */
               }                                              /* CHATLINK */
#endif
               else if (tp->channel < SIGOFF) {
                    prf("%s",chnlst[tp->channel].name);
               }
               else if (tp->channel < CHNOFF) {
                    prf("%s",sigoff(tp->channel-SIGOFF)->signam);
               }
               else {
                    prf("%s's",uacoff(tp->channel-CHNOFF)->userid);
               }
               if (tp->topic[0] != '\0'
                    && othusp->substt == TLKING
                    && tp->channel == tp->prvchn) {
                    prf("\r%42s(%.35s)\r","",tp->topic);
               }
               else if (tp->channel < SIGOFF
                         && chnlst[tp->channel].topic[0] != '\0') {
                    prf("\r%42s(%.35s)\r","",chnlst[tp->channel].topic);
               }
               else if (othusp->substt == FLHING) {
                    pbptr=fapyrs[othusn].poolpt;
                    prf(" [Flash %s %s]\r",pbptr->gamnam,pbptr->gamver);
               }
               else {
                    prf("\r");
               }
          }
     }
     prfmsg(NSCNFTR);
}

unsigned
idxchn(char *chnnam)          /* return index of a public channel  (API)   */
{
     unsigned loop;

     for (loop=0 ; loop < numchan ; loop++) {
          if (sameas(chnnam,chnlst[loop].name)) {
               return(loop);
          }
     }
     return(BADCHAN);
}



int
modchn(int userno,unsigned chnnum) /* Does user have mod access to chan (API)*/
{
     if (gen_haskey(getmsg(TSYSKEY),userno,&user[userno])) {
          return(1);
     }
     else if (gen_haskey(chnlst[chnnum].modkey,userno,&user[userno])) {
          return(1);
     }
     return(0);
}

/* Does userno have access to chnnum.  Only valid for public and private   */
/* channels.  A forum will always return true.  (API)                      */

int
axschn(int userno,unsigned chnnum)
{
     if (chnnum == BADCHAN) {
          return(FALSE);
     }
     if ((chnnum < SIGOFF) && (chnnum >= numchan)) {
          return(FALSE);
     }
     if ((chnnum >= SIGOFF) && (chnnum < CHNOFF)) {
          return(TRUE);
     }
#ifdef DOCLINK
     if (chnnum >= NETCHNOFF) {
          if (!chtlok) {
               return(FALSE);
          }
          else {
               return(gen_haskey(chatlkey,userno,&user[userno]));
          }
     }
#endif
     if (chnnum >= CHNOFF) {
          if (chnnum == CHNOFF+userno) {
               return(TRUE);
          }
          if ((tlcoff(chnnum-CHNOFF)->INVFLS(userno)&FNDBIT(userno))
            || (tlcoff(chnnum-CHNOFF)->flags&INVALL)) {
               return(TRUE);
          }
          else {
               return(FALSE);
          }
     }
     if (chnlst[chnnum].name[0] == '\0') {
          return(FALSE);
     }
     if (chnlst[chnnum].flags&COPENCL) {
          if (modchn(userno,chnnum)) {
               return(TRUE);
          }
          else {
               return(FALSE);
          }
     }
     if (chnlst[chnnum].axskey[0] == '\0') {
          return(TRUE);
     }
     if (gen_haskey(chnlst[chnnum].axskey,userno,&user[userno])) {
          return(TRUE);
     }
     else {
          return(FALSE);
     }
}

int
istlking(int userno)          /* Is a user in TLKING substate?             */
{                             /* This does NOT verify if he is TLC. (API)  */

     if (user[userno].substt == TLKING) {
          return(TRUE);
     }
     else {
          return(FALSE);
     }
}

int
tlcstate(void)                     /* Module state for Teleconference. (API) */
{
     return(tlcstt);
}

void
movchn(int userno,unsigned chnnum) /* Moves a userno to a certain channel. */
{                                  /* Does NOT check access.  (API)        */
     if (!(usrptr->flags&INVISB)) {
          tpfmlt(LEFTCH,usaptr->userid);
          outtlc();
     }
     swtchn(userno,chnnum);
     if (!(usrptr->flags&INVISB)) {
          tpfmlt(CAMEIN,usaptr->userid);
          outtlc();
     }
}

void
uactupd(void)  /* Update all action word flags for all users in TLC.  (API) */
{
     int loop;

     for (loop=0 ; loop < nterms ; loop++) {
          if (user[loop].state == tlcstt) {
               swtact(loop,tlcoff(loop)->channel);
          }
     }
}

void
swtact(int userno,unsigned chnnum) /* Set user action access to chnnum. (API) */
{
     if (chnnum < SIGOFF) {
          setusr(userno,chnnum,chnlst[chnnum].actlst1,chnlst[chnnum].actlst2);
     }
     else {
          setusr(userno,chnnum,defalst,defalst2);
     }
}

void
swtchn(int userno,unsigned chnnum) /* Move user to a diff chn, lowest level. */
{                                  /* ALL should go through this rou (API)   */
     if (chnnum == BADCHAN) {
          setusr(userno,chnnum,NULL,NULL);
          return;
     }
     tlcoff(userno)->channel=chnnum;
     swtact(userno,chnnum);
     joiapi();
}

STATIC unsigned
entertlc(char *destchan)      /* Return chn user should be in on entering TLC */
{
     unsigned chnnum;

     if ((destchan == NULL) || (*destchan == '\0')) {
          return(tlcptr->channel);
     }
     chnnum=chkpub(destchan);
     if (chnnum != BADCHAN) {
          return(chnnum);
     }
     return(MNCHAN);
}

STATIC void
movehome(int userno)          /* Find chn user has access to and put there */
{
     swtchn(userno,findhome(userno));
     if (!(user[userno].flags&INVISB)) {
          tpfmlt(CAMEIN,uacoff(userno)->userid);
          outtlc();
     }
}

unsigned
findhome(int userno)          /* Where should user be when removed (API)   */
{
     if (axschn(userno,MNCHAN)) {
          return(MNCHAN);
     }
     else {
          return(CHNOFF+userno);
     }
}

int hasmtkey(int mnum)             /* does user has TSYSKEY or mnum (API)  */
{
     setmbk(tlcmb);
     if (hasmkey(TSYSKEY)) {
          rstmbk();
          return(1);
     }
     else {
          rstmbk();
          return(hasmkey(mnum));
     }
}

STATIC void
g2chan(int chno)                   /* go to specified teleconf channel #   */
{
     movchn(usrnum,chno);
     tlcctx(usrnum);
}

int
valact(char *stg)                  /* is string a valid action name?       */
{
     char *ptr;

     if (stg == NULL || *stg == '\0' || !isalpha(*stg)) {
          return(0);
     }
     ptr=stg;
     while (*ptr != '\0') {
          if (*ptr < '!' || *ptr > 'z') {
               return(0);
          }
          ++ptr;
     }
     return(1);
}

int
chkalph(char *stg)                 /* is a string alphabetic               */
{
     char *ptr;

     if (stg == NULL) {
          return(0);
     }
     if (*stg == '\0') {
          return(0);
     }
     ptr=stg;
     while (*ptr != '\0') {
          if (!isalpha(*ptr)) {
               return(0);
          }
          ++ptr;
     }
     return(1);
}

int
undupe(stg,insert)                 /* utility for ignoring echoed output   */
char *stg;
int insert;
{
     int i;
     long thissg;
     static long signas[10];

     for (thissg=0L ; *stg != '\0' && *stg != '\r' ; stg++) {
          if (*stg == ESC) {
               do {
                    stg++;
               } while (*stg != '\0' && *stg != '\r' && !isalpha(*stg));
               if (!isalpha(*stg) || *++stg == '\0' || *stg == '\r') {
                    break;
               }
          }
          if ((thissg+=thissg) < 0L) {
               thissg=-thissg+1;
          }
          thissg+=*stg;
     }
     for (i=0 ; i < sizeof(signas)/sizeof(long) ; i++) {
          if (thissg == signas[i]) {
               return(0);
          }
     }
     if (insert) {
          movmem(signas,signas+1,sizeof(signas)-sizeof(long));
          signas[0]=thissg;
     }
     return(1);
}

STATIC void
linkup(void)                       /* enter linked-up condition            */
{
     btutsw(usrnum,0);
     shochl(spr("Linked with %s",usaptr->userid),'',baudat(usrptr->baud,0));
     btucmd(usrnum,"]");
     usrptr->substt=LINKED;
}

STATIC void
lvchi(eximsg,ntrmsg)               /* leave the btuchi() "chat" condition  */
int eximsg,ntrmsg;
{
     tlcptr->flags&=~CCHVLD;
     tlcptr->reqcha=0;
     btuchi(usrnum,NULL);
     btuchi(tlcptr->chatch,NULL);
     if (usrptr->substt == LNKING || usrptr->substt == LINKED) {
          btutrg(usrnum,0);
          btubsz(usrnum,INPSIZ,OUTSIZ);
          btuclo(usrnum);
     }
     btucli(usrnum);
     btumil(usrnum,tinpsz);
     swtchn(usrnum,tlcptr->channel);
     tpfmlt(ntrmsg,usaptr->userid,uacoff(tlcptr->chatch)->userid);
     outtlc();
     usrptr->substt=TLKING;
     usrptr->flags&=~NOGLOB;
     tpfmsg(eximsg);
     tlcctx(usrnum);
     echon();
}

STATIC void
dial(void)                         /* dial out to link to another system   */
{
     int saveun;
     char *ptr;
     struct tlc *otlptr;

     if (margc < 3) {
          tpfmsg(LNKSYN);
          return;
     }
     if (*margv[1] != '*') {
          othusn=0xFF;
          sscanf(margv[1],"%x",&othusn);
          if ((othusn=usridx(othusn)) < 0) {
               tpfmsg(NSUCHC,margv[1]);
               return;
          }
          if (!chnavl(othusn)) {
               tpfmsg(CHNINU,margv[1]);
               return;
          }
     }
     else {
          for (othusn=nterms-1 ; othusn >= 0 ; othusn--) {
               if (chnavl(othusn)) {
                    break;
               }
          }
          if (othusn < 0) {
               tpfmsg(NOCHAV);
               return;
          }
     }
     othusp=&user[othusn];
     othuap=uacoff(othusn);
     otlptr=tlcoff(othusn);
     if (!(othusp->flags&ISRIAL) && margc < 4) {
          tpfmsg(NONUMD);
          return;
     }
     sprintf(othuap->userid,"(%.7s)",margv[2]);
     strupr(othuap->userid);
     btubsz(usrnum,OUTSIZ/2,OUTSIZ/2);
     btutrg(usrnum,OUTSIZ-1);
     btuinj(usrnum,CYCLE);
     setmem(tlcptr->inpbuf,INPSIZ,0);
     btubsz(othusn,OUTSIZ/2,OUTSIZ/2);
     btutrg(othusn,OUTSIZ-1);
     btuinj(othusn,CYCLE);
     setmem(otlptr->inpbuf,INPSIZ,0);
     if (!(usrptr->flags&INVISB)) {
          tpfmlt(ODIALG,usaptr->userid,margv[2]);
          outtlc();
     }
     if (othusp->flags&ISRIAL) {
          tpfmsg(SERIGO);
     }
     else if (othusp->flags&IS2698) {
          ptr=spr("%s%s\r",diahay,margv[3]);
          btuxct(othusn,strlen(ptr),ptr);
          tpfmsg(DIALOMP);
     }
     else {
          btucmd(othusn,spr("%s%sM",diaxec,margv[3]));
          tpfmsg(DIALOMP);
     }
     tlcptr->chatch=othusn;
     otlptr->chatch=usrnum;
     usrptr->substt=LNKING;
     othusp->substt=LNKING;
     othusp->state=tlcstt;
     othusp->class=BBSPRV;
     othusp->flags|=NOZAP;
     otlptr->channel=tlcptr->channel;   /* Check for problem w/ swtchn     */
     saveun=usrnum;
     usrnum=othusn;
     shochl("Teleconference Dialing Out",'',baudat(usrptr->baud,0));
     usrnum=saveun;
}

STATIC int
chnavl(chan)                       /* channel is available for dial out?   */
int chan;
{
     struct user *othusp;

     othusp=&user[chan];
     return(othusp->class == VACANT
       && othusp->state == AWAITC
       && !(othusp->flags&NOHDWE));
}

CSTATIC char
tlchat(chan,ch)                    /* bypass routine for btuchi() for chat */
int chan;
int ch;
{
     int oth;
     char c;
     struct tlc *tmptlc;

     tmptlc=tlcoff(chan);
     oth=tmptlc->chatch;
     c=((char)ch)&eurmsk;
     switch (c) {
     case '\r':
          chiinp(oth,c);
          chiout(oth,c);
          chiout(oth,'\n');
          return(c);
     case 8:
     case 127:
          chiinp(oth,8);
          chiout(oth,8);
          chiout(oth,' ');
          chiout(oth,8);
          return(8);
     default:
          if (c >= 32) {
               if (!(tmptlc->flags&TYPING)) {
                    if (uacoff(oth)->ansifl&ANSON) {
                         chious(oth,"\33[32m");
                    }
                    if (uacoff(chan)->ansifl&ANSON) {
                         chious(chan,"\33[33m");
                    }
                    tmptlc->flags|=TYPING;
                    tlcoff(oth)->flags&=~TYPING;
               }
               chiinp(oth,c);
               chiout(oth,c);
               return(c);
          }
     }
     return(0);
}

STATIC int
quitlc(void)                       /* quit teleconference, whence came     */
{
     if (tlcptr->flags&XTOOTH) {
          if (tlcptr->flags&RSTX2M) {
               usrptr->flags&=~X2MAIN;
          }
          tlcptr->flags&=~(XTOOTH+RSTX2M);
          tlcptr->channel=findhome(usrnum);
          if (tlcptr->defchn == 2) {
               swtchn(usrnum,usrnum+CHNOFF);
          }
          swtchn(usrnum,BADCHAN);
          condex();
          usrptr->state=tlcptr->retstt;
          usrptr->substt=tlcptr->retsub;
          usrptr->crdrat=tlcptr->retrat;
          injacr();
          return(1);
     }
     swtchn(usrnum,BADCHAN);
     rstrxf();
     return(0);
}

CSTATIC void
tlcctx(int userno)                 /* teleconference channel user display  */
{
     char *curguy,tmpbuf[UIDSIZ+6];
     unsigned chan;
     int othuno;
     int orguser;

     orguser=usrnum;
     usrnum=userno;

#ifdef DOCLINK
      if (nettlcctx()) {           /* CHATLINK                             */
          return;                  /* CHATLINK                             */
      }                            /* CHATLINK                             */
#endif

     initls();
     tlcptr=tlcoff(usrnum);
     chan=tlcptr->channel;
     othuno=(tlcptr->channel-CHNOFF);
     if (chan < SIGOFF) {          /* Always use channel info              */
          tpfmsg(PUBCHN,chnlst[chan].name);
          if (chnlst[chan].topic[0] != '\0') {
               tpfmsg(CHNTOP,chnlst[chan].topic);
          }
     }
     else if (chan < CHNOFF) {
          tpfmsg(SIGCHN,sigoff(chan-SIGOFF)->signam);
     }
     else {
          if (chan == tlcptr->prvchn) {
               tpfmsg(URTPRV);
          }
          else {
               tpfmsg(HISPRV,uacoff(othuno)->userid);
          }
          if (tlcoff(othuno)->topic[0] != '\0') {
               tpfmsg(CHNTOP,tlcoff(othuno)->topic);
          }
     }
     switch (chncnt()) {
     case 0:
     case 1:
          tpfmsg(BYSELF);
          break;
     case 2:
          tpfmsg(ONEOTH,tlsrui());
          break;
     case 3:
          strcpy(tmpbuf,tlsrui());
          tpfmsg(TWOOTH,tmpbuf,tlsrui());
          break;
     default:
          strcpy(tmpbuf,tlsrui());
          while ((curguy=tlsrui()) != NULL) {
               prf(somoth,tmpbuf);
               strcpy(tmpbuf,curguy);
          }
          tpfmsg(SEVOTH,tmpbuf);
     }
     tpfmsg(IROEPI);
     usrnum=orguser;
}

void
tpfmsg(msgno,parm1,parm2,parm3)    /* teleconf prfmsg-equiv, with star-strip */
int msgno;
long parm1,parm2,parm3;
{
     int cnt;
     char *tptr;

     tptr=getmsg(msgno);
     if (!starsq && (cnt=findstar(tptr)) != 0) {
          strcpy(tptr+cnt-4,tptr+cnt);
     }
     prf(tptr,parm1,parm2,parm3);
}

void
tpfmlt(msgno,parm1,parm2,parm3)    /* teleconf prfmlt-equiv, with star-strip */
int msgno;                              /* (butchered to meet requirements)  */
long parm1,parm2,parm3;
{
     char *tptr;
     int clsave,cnt;

     cklonl();
     clsave=clingo;
     for (clingo=0 ; clingo < nlingo ; clingo++) {
          if (linuse[clingo]) {
               prfptr=prfpointers[clingo];
               tptr=getmsg(msgno);
               if (!starsq && (cnt=findstar(tptr)) != 0) {
                    strcpy(tptr+cnt-4,tptr+cnt);
               }
               prf(tptr,parm1,parm2,parm3);
               prfpointers[clingo]=prfptr;
          }
     }
     prfptr=prfpointers[0];
     clingo=clsave;
     mltflg=1;
}

int
findstar(stg)                      /* find offset of end of stars (or 0)   */
char *stg;                              /* stg to find offset in           */
{
     int rv;
     char buf[40];

     stzcpy(buf,stg,sizeof(buf));
     stpans(buf);
     if (!(rv=(sameto("***\r",buf) ? findstg("***\r",stg) : 0))) {
          rv=(sameto("***\n",buf) ? findstg("***\n",stg) : 0);
     }
     return(rv);
}

STATIC int
glopag(void)                       /* globally-accessible form of "page"   */
{
     if (margc >= 1 && sameas(margv[0],"/p")) {
          setmbk(tlcmb);
          if (margc == 1 || (margc == 2 && sameas(margv[1],"?"))) {
               prfmsg(GLPFMT);
          }
          else {
               tlcptr=tlcoff(usrnum);
               page();
          }
          outprf(usrnum);
          return(1);
     }
     else if (margc == 1 && sameas(margv[0],"/#")) {
          usrson();
          outprf(usrnum);
          return(1);
     }
     return(0);
}

STATIC void
page(void)                         /* "page" function                      */
{
     int count;
     char *pagmsg;

     badpag=0;
     if (urinv()) {
     }
     else if (margc == 1) {
          tpfmsg(PAGFMT);
     }
     else if (*margv[1] == '(') {
          tpfmsg(NOPLNK);
     }
     else {
          rstrin();
          if ((count=howmny(tlcoff(usrnum)->channel,margv[1],0,1)) == 1) {
               pagmsg="";
          }
          else {
               pagmsg=fndusr(usrnum,margv[1],1,0,&count);
          }
          if (count == 0) {
               if (sameas(margv[1],"on")) {
                    tlcptr->flags&=~(NOPAGE+OKPAGE);
                    tpfmsg(PAGTON,tlcptr->pagint/4,tlcptr->chaint/4);
               }
               else if (sameas(margv[1],"off")) {
                    tlcptr->flags|=NOPAGE;
                    tpfmsg(PAGTOF);
               }
               else if (sameas(margv[1],"ok")) {
                    tlcptr->flags|=OKPAGE;
                    tlcptr->flags&=~NOPAGE;
                    tpfmsg(PAGTOK);
               }
               else if (sameas(margv[1],"Sysop") || sameto("Sysop ",margv[1])
                        || sameto("Sysop:",margv[1])) {
                    if (tlcptr->blinkc) {
                         tpfmsg(PAGS2M);
                    }
                    else {
                         belper(sopbel);
                         printf("\7");
                         tpfmsg(PAGEOK,"Sysop (at main console)");
                         psmatm();
                         shochl(usaptr->userid,'',baudat(usrptr->baud,1));
                         tlcptr->blinkc=8;
                    }
               }
               else {
                    tpfmsg(NPGUID,margv[1]);
                    badpag=1;
               }
          }
          else if (count > 1) {
               prfmsg(PAMBIG,margv[1],"/p");
          }
          else if (count != 1) {
               tpfmsg(NPGAMB,margv[1]);
          }
          else {
               pospag(pagmsg);
          }
     }
}

STATIC void
pospag(pagmsg)                     /* possible page utility           */
char *pagmsg;
{
     if (!hasmtkey(PAGKEY)) {
          tpfmsg(CANTPG);
          howbuy();
     }
     else if (tlcoff(othusn)->flags&NOPAGE) {
          tpfmsg(PAGOFF,othuap->userid);
     }
     else if ((tlcoff(othusn)->FORFLS(usrnum)&FNDBIT(usrnum))) {
          tpfmsg(FORGTN,othuap->userid);
     }
     else if (!(tlcoff(othusn)->flags&OKPAGE) && tlcoff(othusn)->paged) {
          tpfmsg(PAGL2M,othuap->userid,tlcoff(othusn)->pagint/4);
     }
     else if (!tlcpfn(BADCHAN)) {
          if (*pagmsg == '\0') {
               prfmlt(PAGMSG,usaptr->userid,module[usrptr->state]->descrp);
          }
          else {
               prfmlt(PAGNOT,usaptr->userid,
                              module[usrptr->state]->descrp,pagmsg);
          }
          if (injoth()) {
               tlcoff(othusn)->paged=tlcoff(othusn)->pagint;
               tpfmsg(PAGEOK,othuap->userid);
          }
          else {
               tpfmsg(PAGNPS,othuap->userid);
          }
     }
}

STATIC void
chat(void)                         /* "chat" function                      */
{
     int i,count;

     if (urinv()) {
     }
     else if (margc == 1) {
          tpfmsg(CHAFMT);
     }
     else {
          rstrin();
          if ((count=howmny(tlcptr->channel,margv[1],0,1)) == 0
            || (count == 1 && othusp->substt >= EDTING)
            || (count == 1 && othusp->state != tlcstt)) {
               tpfmsg(NCHUID,margv[1]);
          }
          else if (count != 1) {
               tpfmsg(NCHAMB,margv[1]);
          }
          else if (othusp->substt == CHTING) {
               tpfmsg(ALRICH,othuap->userid);
          }
          else if (othusn == usrnum) {
               tpfmsg(NCHSLF);
          }
          else if ((tlcoff(othusn)->FORFLS(usrnum)&FNDBIT(usrnum))) {
               tpfmsg(FORGTN,othuap->userid);
          }
          else if ((tlcoff(othusn)->flags&CCHVLD)
            && usrnum == tlcoff(othusn)->chatch) {
               tlcoff(usrnum)->chatch=othusn;
               tlcoff(usrnum)->flags&=~TYPING;
               tlcoff(othusn)->flags&=~TYPING;
               btumil(othusn,-(othuap->scnwid-1));
               btumil(usrnum,-(usaptr->scnwid-1));
               usrptr->substt=CHTING;
               othusp->substt=CHTING;
               usrptr->flags|=NOGLOB;
               othusp->flags|=NOGLOB;
               telext();
               tlcptr=tlcoff(othusn);
               i=usrnum;
               usrnum=othusn;
               telext();
               tpfmlt(GONCHA,othuap->userid);
               outtlc();
               btucli(othusn);
               btuclo(othusn);
               tpfmlt(ACCPCH,usaptr->userid);
               tpfmlt(ENTCHA);
               outmlt(othusn);
               btuchi(othusn,tlchat);
               usrnum=i;
               btuclo(usrnum);
               btucli(usrnum);
               tlcptr=tlcoff(usrnum);
               tpfmlt(GONCHA,usaptr->userid);
               outtlc();
               tpfmsg(ENTCHA);
               btuchi(usrnum,tlchat);
          }
          else if (!hasmtkey(CHTKEY)) {
               tpfmsg(CANTCH);
               howbuy();
          }
          else if (tlcoff(othusn)->flags&NOPAGE) {
               tpfmsg(PAGOFF,othuap->userid);
          }
          else if (!(tlcoff(othusn)->flags&OKPAGE) && tlcoff(othusn)->reqcha) {
               tpfmsg(CHAL2M,othuap->userid,tlcoff(othusn)->chaint/4);
          }
          else {
               tpfmlt(CHAREQ,usaptr->userid,
                     (usaptr->sex == 'M' ? "him" : "her"),usaptr->userid);
               if (injoth()) {
                    tlcptr->chatch=othusn;
                    tlcptr->flags|=CCHVLD;
                    tlcoff(othusn)->reqcha=tlcoff(othusn)->chaint;
                    tpfmsg(CREQOK,othuap->userid);
               }
               else {
                    tpfmsg(PAGNPS,othuap->userid);
               }
          }
     }
}

STATIC void
invite(void)                       /* invite a user to a channel           */
{
     int count;
     struct tlc *otlcpt;

     if (urinv()) {
          return;
     }
     rstrin();
     count=howmny(tlcptr->channel,margv[1],0,1);
     if (count == 0) {
          if (sameas(margv[1],"all")) {
               tlcptr->flags|=INVALL;
               tpfmsg(OKALLI);
          }
          else {
               tpfmsg(PAGNON,margv[1]);
          }
     }
     else if (count != 1) {
          tpfmsg(AMBIG,margv[1],"invite");
     }
     else {
          if (usrnum == othusn) {
               tpfmsg(WHYYOU,"invite");
          }
          else if ((tlcoff(othusn)->FORFLS(usrnum)&FNDBIT(usrnum))) {
               tpfmsg(FORGTN,othuap->userid);
          }
          else if (othuap->userid[0] == '(') {
               tpfmsg(NOINVL);
          }
          else {
               tlcptr->INVFLS(othusn)|=FNDBIT(othusn);
               otlcpt=tlcoff(othusn);
               if (otlcpt->flags&NOPAGE
                 || ((otlcpt->paged) && !(otlcpt->flags&OKPAGE))) {
               }
               else {
                    tpfmlt(INVITA,usaptr->userid,
                                  (usaptr->sex == 'M' ? "his" : "her"));
                    if (othusp->state == tlcstt && othusp->substt == TLKING) {
                         tpfmlt(INVITJ,usaptr->userid);
                    }
                    injoth();
               }
               tpfmsg(OKINVT,othuap->userid);
               if (tlcptr->prvchn != tlcptr->channel) {
                    tpfmsg(INVWRN);
               }
          }
     }
}

STATIC void
devite(void)                       /* uninvite a user from a channel       */
{
     int count;

     if (urinv()) {
          return;
     }
     rstrin();
     count=howmny(tlcptr->channel,margv[1],0,1);
     if (count == 0) {
          if (sameas(margv[1],"all")) {
               tlcptr->flags&=~INVALL;
               tpfmsg(UNVALL);
          }
          else {
               tpfmsg(PAGNON,margv[1]);
          }
     }
     else if (count != 1) {
          tpfmsg(AMBIG,margv[1],"uninvite");
     }
     else if (usrnum == othusn) {
          tpfmsg(WHYYOU,"uninvite");
     }
     else if (othkey(getmsg(TSYSKEY))) {
          tpfmsg(NODICE2);
     }
     else {
          unifor();
     }
}

STATIC void
unifor(void)                       /* kicked out by forget or uninvite cmd */
{
     int i,j;
     struct tlc *tmptlc,*otlcpt;
     struct usracc *tmpptr;

     otlcpt=tlcoff(othusn);
     tlcptr->INVFLS(othusn)&=~FNDBIT(othusn);
     if (otlcpt->channel == tlcptr->prvchn) {
          swtchn(othusn,findhome(othusn));
          if (othusp->state == tlcstt && othusp->substt == FLHING) {
               ret2tl(othusn);
               tpfmsg(KUNVIT,othuap->userid);
          }
          else if (othusp->state == tlcstt && othusp->substt == TLKING) {
               tmptlc=tlcptr;
               tlcptr=otlcpt;
               j=usrnum;
               i=usrnum=othusn;
               tpfmlt(KICKDO,uacoff(i)->userid);
               prfmlt(ETLPMT);
               for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
                    if (othusn != j && othusp->state == tlcstt
                      && othusp->substt == TLKING && othusn != i) {
                         if (tmptlc->channel == tlcoff(othusn)->channel) {
                              if (!(tlcoff(othusn)->FORFLS(usrnum)&FNDBIT(usrnum))) {
                                   outmlt(othusn);
                              }
                         }
                    }
               }
               clrmlt();
               tmpptr=othuap;
               curusr(i);
               tpfmsg(UNVITD2,uacoff(j)->userid);
               tlcctx(usrnum);
               prfmsg(ETLPMT);
               outprf(usrnum);
               tpfmlt(CAMEIN,usaptr->userid);
               outtlc();
               tlcptr=tmptlc;
               curusr(j);
               tpfmsg(KUNVIT,uacoff(i)->userid);
               othuap=tmpptr;
          }
          else {
               tpfmsg(OKUNVT,othuap->userid);
          }
     }
     else {
          tpfmsg(OKUNVT,othuap->userid);
     }
}

int
chkign(int user1, int user2)  /* see if user1 is ignoring user2.  (API)    */
{
     if (tlcoff(user1)->flags&IGNRAL) {
          return(TRUE);
     }
     if (tlcoff(user1)->IGNFLS(user2)&FNDBIT(user2)) {
          return(TRUE);
     }
     return(FALSE);
}

STATIC void
ignore(void)                                        /* ignore a user       */
{
     int count;

     if (urinv()) {
          return;
     }
     if (margc == 1) {
          prfmsg(IGNHELP);
          return;
     }
     if ((margc == 2) && (sameas(margv[1],"all"))) {
          tlcptr->flags|=IGNRAL;
          prfmsg(IGNORA);
          return;
     }
     rstrin();
     count=howmny(tlcptr->channel,margv[1],0,1);
     if (count == 0) {
          tpfmsg(PAGNON,margv[1]);
     }
     else if (count != 1) {
          tpfmsg(AMBIG,margv[1],"ignore");
     }
     else if (othkey(getmsg(TSYSKEY))) {
          tpfmsg(NODICE2);
     }
     else {
          tlcptr->IGNFLS(othusn)|=FNDBIT(othusn);
          unifor();
          clrprf();
          tpfmsg(IGNOR2,othuap->userid,
                       (othuap->sex == 'M' ? "his" : "her"),
                        othuap->userid);
     }
}

STATIC void
notice(void)                       /* remembering a user                   */
{
     int count;

     if (urinv()) {
          return;
     }
     if (margc == 1) {
          prfmsg(NOTHELP);
          return;
     }
     if ((margc == 2) && (sameas(margv[1],"all"))) {
          tlcptr->flags&=~IGNRAL;
          prfmsg(NOTICA);
          return;
     }
     rstrin();
     count=howmny(tlcptr->channel,margv[1],0,1);
     if (count == 0) {
          tpfmsg(PAGNON,margv[1]);
     }
     else if (count != 1) {
          tpfmsg(AMBIG,margv[1],"notice");
     }
     else {
          tlcptr->IGNFLS(othusn)&=~FNDBIT(othusn);
          tpfmsg(NOTICD,othuap->userid,(othuap->sex == 'F' ? "her" : "his"));
     }
}

int
chkfgt(int user1,int user2)   /* see if user1 is forgetting user2  (API)   */
{
     if (tlcoff(user1)->FORFLS(user2)&FNDBIT(user2)) {
          return(TRUE);
     }
     return(FALSE);
}

STATIC void
forget(void)                       /* forgetting a user and uninvite       */
{
     int count;

     if (urinv()) {
          return;
     }
     if (margc == 1) {
          prfmsg(FGTHELP);
          return;
     }
     rstrin();
     count=howmny(tlcptr->channel,margv[1],0,1);
     if (count == 0) {
          tpfmsg(PAGNON,margv[1]);
     }
     else if (count != 1) {
          tpfmsg(AMBIG,margv[1],"forget");
     }
     else if (othkey(getmsg(TSYSKEY))) {
          tpfmsg(NODICE2);
     }
     else {
          tlcptr->FORFLS(othusn)|=FNDBIT(othusn);
          unifor();
          clrprf();
          tpfmsg(FORGT2,othuap->userid,
                       (othuap->sex == 'M' ? "his" : "her"),
                        othuap->userid);
     }
}

STATIC void
rememb(void)                       /* remembering a user                   */
{
     int count;

     if (urinv()) {
          return;
     }
     if (margc == 1) {
          prfmsg(RMBHELP);
          return;
     }
     rstrin();
     count=howmny(tlcptr->channel,margv[1],0,1);
     if (count == 0) {
          tpfmsg(PAGNON,margv[1]);
     }
     else if (count != 1) {
          tpfmsg(AMBIG,margv[1],"remember");
     }
     else {
          tlcptr->FORFLS(othusn)&=~FNDBIT(othusn);
          tpfmsg(REMEMD,othuap->userid,(othuap->sex == 'F' ? "her" : "his"));
     }
}

STATIC void
join(void)                    /* joining a channel                         */
{
     unsigned ochn,signo,count;

     if ((nswchx > 0) && ((tlcptr->swchan)++ >= nswchx)) {
          tpfmsg(NANNOY);
     }
     else if ((tlcptr->channel != MNCHAN) && !eswtfr
       && (tlcptr->channel < CHNOFF) && (tlcptr->channel >= SIGOFF)
       && !(usrptr->flags&MASTER)) {
          tpfmsg(CANTEX);
     }
     else if (margc == 1) {
          if (tlcptr->channel == tlcptr->prvchn) {
               if (axschn(usrnum,MNCHAN)) {
                    g2chan(MNCHAN);
               }
               else {
                    tpfmsg(NAXSCHN);
               }
          }
          else {
               g2chan(tlcptr->prvchn);
          }
     }
     else {
          ochn=chkpub(margv[1]);
          if (ochn != BADCHAN) {
               if (tlcptr->channel == ochn) {
                    tpfmsg(ALRCHN);
               }
               else {
                    if (axschn(usrnum,ochn)) {
                         g2chan(ochn);
                    }
                    else {
                         tpfmsg(NAXSCHN);
                    }
               }
          }
          else if (*(nxtcmd=margv[1]) == SIGIDC) {
               qscptr=qscoff(usrnum);
               iniqsc();
               if (!eswtfr && !(usrptr->flags&MASTER)) {
                    tpfmsg(CANTJN);
               }
               else if ((signo=findsig(cncuid())) == NOSIG) {
                    tpfmsg(NOSAXS);
               }
               else if (tlcptr->channel == signo+SIGOFF) {
                    tpfmsg(ALRINS);
               }
               else {
                    g2chan(signo+SIGOFF);
               }
          }
          else {
               rstrin();
               count=howmny(tlcptr->channel,margv[1],0,1);
               if (count == 0) {
                    tpfmsg(PAGNON,margv[1]);
               }
               else if (count != 1) {
                    tpfmsg(AMBIG,margv[1],"join");
               }
               else if (CHNOFF+othusn == tlcptr->channel) {
                    tpfmsg(ALRTHR,(othuap->sex == 'F' ? "her" : "his"));
               }
               else if ((tlcoff(othusn)->INVFLS(usrnum)&FNDBIT(usrnum))
               || (tlcoff(othusn)->flags&INVALL)
               || (usrptr->flags&MASTER)
               || sameas(othuap->userid,usaptr->userid)) {
                    ochn=othusn;
                    g2chan(ochn+CHNOFF);
               }
               else {
                    tpfmsg(NOTINV,othuap->userid);
               }
          }
     }
}

STATIC int
chncnt(void)                       /* count number of users on channel     */
{
     int i,cnt;
     unsigned chan;

     chan=tlcoff(usrnum)->channel;
     for (i=0,cnt=0 ; i < nterms ; i++) {
          if (user[i].state == tlcstt
            && (user[i].substt == TLKING || user[i].substt == LINKED)
            && tlcoff(i)->channel == chan) {
               if (!(user[i].flags&INVISB) || i == usrnum) {
                    cnt++;
               }
          }
     }
     return(cnt);
}

STATIC void
rewhisper(char *what)
{
     if (tlcptr->rewhsps != -1) {
          tlcptr->rewhsps=-1;
          tlcptr->rewhspu=-1;
          tpfmsg(NORWHS);
     }
     else if (tlcptr->rewhspu == -1) {
          tpfmsg(NORWHS);
     }
     else {
          rstrin();
          sprintf(vdatmp,"%s %s",uacoff(tlcptr->rewhspu)->userid,what);
          stzcpy(input,vdatmp,tinpsz);
          parsin();
          whisper(margv[0],0);
     }
}

STATIC void
whisper(whoto,mnum)                /* "whisper" function                   */
char *whoto;
int mnum;
{
     int count;
     char *what;

     what=fndusr(usrnum,whoto,mnum,2,&count);
     if (count > 1) {
          prfmsg(PAMBIG,whoto,"whisper to");
     }
     else if (count == 0) {
          if (whs2pag) {
               rstrin();
               sprintf(vdatmp,"page %s",whoto);
               stzcpy(input,vdatmp,tinpsz);
               parsin();
               tpfmsg(CVT2PAG);
               outprf(usrnum);
               clrprf();
               page();
               tlcptr->rewhsps=-1;
               if (badpag) {
                    badpag=0;
               }
               else {
                    tlcptr->rewhspu=othusn;
               }
          }
          else {
               tpfmsg(WHSNHR,whoto);
          }
     }
     else if (count != 1) {
          tpfmsg(AMBIG,whoto,"whisper");
     }
     else if (*what == '\0') {
          tpfmsg(WHSFMT2);
     }
     else if ((tlcoff(othusn)->FORFLS(usrnum)&FNDBIT(usrnum))) {
          tpfmsg(FORGTN,othuap->userid);
     }
     else {
          tlcptr->rewhsps=-1;
          tlcptr->rewhspu=othusn;
          tpfmlt(WHSTO,usaptr->userid,what);
          prfmlt(ETLPMT);
          outmlt(othusn);
          prfmsg(WHSSNT,othuap->userid);
     }
}

STATIC void
direct(whoto,mnum)                /* "direct" function                   */
char *whoto;
int mnum;
{
     int count;
     char *what;

     what=fndusr(usrnum,whoto,mnum,2,&count);
     if (count > 1) {
          prfmsg(DAMBIG,whoto,dirchr);
     }
     else if (count == 0) {
          tpfmsg(WHSNHR,whoto);
     }
     else if (count != 1) {
          tpfmsg(AMBIG,whoto,"directed");
     }
     else if (*what == '\0') {
          tpfmsg(DIRFMT,dirchr);
     }
     else if ((tlcoff(othusn)->FORFLS(usrnum)&FNDBIT(usrnum))) {
          tpfmsg(FORGTN,othuap->userid);
     }
     else {
#ifdef DOCLINK
          if (netactive) {
               if ((usrlist[usrnum].vc >= 0L) &&
                 ((vccnt(usrlist[usrnum].vc)) > 1) && !netrpt) {
                    sprintf(tempname,nnstg,usaptr->userid,sysno);
                    sprintf(tempname2,nnstg,othuap->userid,sysno);
                    prfmsg(NETDIRTO,tempname,tempname2,what);
                    sendactmsg(NULL,0,usrlist[usrnum].vc,prfbuf);
               }
          }
#endif
          tpfmlt(DIRTO,usaptr->userid,othuap->userid,what);
          outchan(tlcptr->channel,CANFORG,usrnum,othusn);
          tpfmlt(DIRTO,usaptr->userid,"you",what);
          prfmlt(ETLPMT);
          outmlt(othusn);
          prfmsg(DIRSNT,othuap->userid);
     }
}

/* More intelligent parser of message destination                          */

char *
fndusr(int userno,char *start,int mnum,int prec,int *count)
{
     char *argend;
     int done=FALSE;
     int lastcnt=0;
     int loop;
     int tempusn;

     for (loop=0 ; loop < margc ; loop++) {
          margn[loop][0]='\0';
     }
     while ((done == FALSE) && (mnum < margc)) {
          argend=margn[mnum];
          if (*(argend-1) == ':') {
               *(argend-1)='\0';
               *count=howmny(tlcoff(userno)->channel,start,prec,1);
               *(argend-1)=':';
               mnum++;
               done=TRUE;
          }
          else {
               *count=howmny(tlcoff(userno)->channel,start,prec,0);
               margn[mnum][0]=' ';
          }
          if (*count == 0) {
               done=TRUE;
          }
          else {
               if (*count == 1) {
                    tempusn=othusn;
               }
               lastcnt=*count;
          }
          if (!done) {
               mnum++;
          }
     }
     for (loop=0 ; loop < margc ; loop++) {
          margn[loop][0]='\0';
     }
     rstrin();
     if ((*count != 1) && (lastcnt > 0)) {
          *count=lastcnt;
     }
     if (*count == 1) {
          othusn=tempusn;
          othusp=&user[othusn];
          othuap=uacoff(othusn);
     }
     if (mnum == margc) {
          return("");
     }
     else {
          return(margv[mnum]);
     }
}

/* Parse the destination of a string.  (API)                               */

char *
prspow(int userno,char *start,int mnum,int prec,int *count)
{
     char *msg;
     int gobl,i;

     for (i=0 ; i < margc ; i++) {
          margn[i][0]='\0';
     }
     if ((*count=howmny(tlcoff(userno)->channel,start,prec,0)) == 0) {
          msg=margn[mnum];
          if (*(msg-1) == ':') {
               *(msg-1)='\0';
               *count=howmny(tlcoff(userno)->channel,start,prec,1);
               if (mnum != margc-1) {
                    msg++;
               }
          }
          else {
               msg="";
          }
          rstrin();
     }
     else if (*count == 1) {
          rstrin();
          for (i=mnum+1 ; i < margc ; i++) {
               msg=margn[i];
               if (*(msg-1) == ':') {
                    *(msg-1)='\0';
                    if (!sameto(start,othuap->userid)) {
                         *(msg-1)=':';
                    }
                    else {
                         i++;
                    }
                    break;
               }
               else {
                    *msg='\0';
                    gobl=sameto(start,othuap->userid);
                    if (i < margc-1) {
                         *msg=' ';
                    }
               }
               if (!gobl) {
                    break;
               }
          }
          msg=(i == margc ? "" : margv[i]);
     }
     else {
          rstrin();
          if ((msg=strchr(start,':')) == NULL) {
               margn[mnum][0]='\0';
               *count=NEEDCO;
               msg="";
          }
          else {
               *msg='\0';
               if (*++msg != '\0') {
                    msg++;
               }
               *count=howmny(tlcoff(userno)->channel,start,prec,1);
          }
     }
     return(msg);
}

/* number of people on chan starting with stg. (API)                       */
/* chan to check out                                                       */
/* stg to use in sameto() test                                             */
/* how precise should this be? 0-2                                         */
/* take sameas() as a return(1)?                                           */

int
howmny(unsigned chan,char *stg,int prec,int samas)
{
     int cnt=0,dstusn;

     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          othuap=uacoff(othusn);
          switch (prec) {
          case 2:
               if (tlcoff(othusn)->channel != chan) {
                    break;
               }
          case 1:
               if (othusp->state != tlcstt || othusp->substt != TLKING) {
                    break;
               }
          case 0:
               if (othusp->flags&INVISB || othusp->class < SUPLON
                 || !sameto(stg,othuap->userid)) {
                    break;
               }
               if (samas && sameas(stg,othuap->userid)) {
                    return(1);
               }
               dstusn=othusn;
               cnt++;
          }
     }
     if (cnt == 1) {
          othusn=dstusn;
          othusp=&user[othusn];
          othuap=uacoff(othusn);
     }
     return(cnt);
}

void
outtlc(void)                  /* prf()s prfbuf to teleconference chan (API)*/
{
     int ousn;
     char sav,*ptr;
     struct user *ousp;

     ptr=prfptr;
     prfmlt(ETLPMT);
     sav=*ptr;
     for (ousn=0,ousp=user ; ousn < nterms ; ousn++,ousp++) {
          if (ousn != usrnum && ousp->state == tlcstt) {
               if (tlcptr->channel == tlcoff(ousn)->channel) {
                    if (!(tlcoff(ousn)->FORFLS(usrnum)&FNDBIT(usrnum))) {
                         switch (ousp->substt) {
                         case TLKING:
                              outmlt(ousn);
                              break;
                         case LINKED:
                              *ptr='\0';
                              undupe(prfbuf+findstar(prfbuf),1);
                              *ptr=sav;
                              *(ptr-1)='\0';
                              btuxmt(ousn,prfbuf+findstar(prfbuf));
                              btuxct(ousn,1,"\r");
                              *(ptr-1)='\r';
                              break;
                         }
                    }
               }
          }
     }
     clrmlt();
}

STATIC void
tlctck(void)                       /* real-time teleconference kicker      */
{
     struct tlc *tlcptr;

     for (usrnum=0 ; usrnum < nterms ; usrnum++) {
          tlcptr=tlcoff(usrnum);
          usrptr=&user[usrnum];
          if (usrptr->substt == FLHING) {
               usrptr->flags|=ACTIVE;
          }
          if (tlcptr->paged != 0) {
               tlcptr->paged--;
          }
          if (tlcptr->blinkc != 0) {
               if ((tlcptr->blinkc-=1) == 0) {
                    shochl(uacoff(usrnum)->userid,'',
                           baudat(user[usrnum].baud,0));
               }
          }
          if (tlcptr->reqcha != 0) {
               tlcptr->reqcha--;
          }
          tlcptr->swchan=0;
          tlcptr->flags&=~JUSTEX;
     }
     rtkick(15,tlctck);
}

STATIC void
initls(void)                       /* initialize teleconferencer list      */
{
     othusn=-1;
     othusp=user-1;
}

STATIC char *
tlsrui(void)                       /* teleconferencer list, show next one  */
{
     static char retval[UIDSIZ+6];

     while (othusn < nterms-1) {
          othusn++;
          othusp++;
          othuap=uacoff(othusn);
          tptr=tlcoff(othusn);
          if (othusp->state == tlcstt && othusn != usrnum
             && (othusp->substt == TLKING || othusp->substt == LINKED)
             && tptr->channel == tlcptr->channel) {
               if (!(othusp->flags&INVISB)) {
                    strcpy(retval,othuap->userid);
                    if (tlcptr->FORFLS(othusn)&FNDBIT(othusn)) {
                         stzcat(retval," (f)",sizeof(retval));
                    }
                    return(retval);
               }
          }
     }
     return(NULL);
}

void                               /* CHATLINK                             */
tcsthn(void)                       /* teleconference status handler        */
{
     setmbk(tlcmb);
     tlcptr=tlcoff(usrnum);
     if (status == CYCLE && (usrptr->substt == LNKING ||
         usrptr->substt == LINKED)) {
          psdasc();
     }
     else if (status == CYCLE && usrptr->substt == TLKING) {
          apists();
     }
     else if (!isuidc(usaptr->userid[0])) {
          switch (status) {
          case INBLK:
          case CMDOK:
          case CMN2OK:
          case CM25OK:
          case RCVX29:
          case 'M':
          case OUTMT:
          case 251:
          case 252:
          case 253:
               break;
          case 'D':
          case 'R':
          case 'V':
               btucmd(usrnum,"M");
               break;
          case 'B':
          case 'T':
               hupchi(LNKHUP);
               usrptr->substt=GOING;
          default:
               tlchup();
               rstchn();
          }
     }
     else if (status == STPFLA) {
          if (usrptr->substt == FLHING) {
               ret2tl(usrnum);
               tpfmsg(USRETD,pbptr->gamnam);
               tlcctx(usrnum);
               prfmsg(ETLPMT);
               outprf(usrnum);
          }
     }
     else {
          dfsthn();
     }
}

STATIC void
psdasc(void)                       /* cycle-based pseudo-ASCII handler     */
{
     char tmpbuf[2];

     setmem(tmpbuf,sizeof(tmpbuf),0);
     while (btuibw(usrnum) > 0) {
          btuica(usrnum,tmpbuf,1);
          if (usrptr->substt == LNKING) {
               btuxct(tlcptr->chatch,1,tmpbuf);
          }
          if (tmpbuf[0] == '\n' || tmpbuf[0] == '\r') {
               strcpy(input,tlcptr->inpbuf);
               parsin();
               telecn();
               setmem(tlcptr->inpbuf,INPSIZ,0);
               break;
          }
          else if (strlen(tlcptr->inpbuf) < INPSIZ-1) {
               stzcat(tlcptr->inpbuf,tmpbuf,sizeof(tlcptr->inpbuf));
          }
     }
     btuinj(usrnum,CYCLE);
}

STATIC void
ret2tl(who)                        /* return to talking sub-stt from flash */
int who;
{
     int savusn;

     savusn=usrnum;
     actas(who);
     lvpool();
     btucli(usrnum);
     swtchn(usrnum,tlcptr->channel);
     if (!(usrptr->flags&INVISB)) {
          tpfmlt(USBACK,usaptr->userid,pbptr->gamnam);
          outtlc();
     }
     usrptr->substt=TLKING;
     actas(savusn);
}

STATIC void
tlchup(void)                       /* teleconference hang-up routine       */
{
     int i,j,othusn,chn;
     struct tlc *otlcpt;

     tlcptr=tlcoff(usrnum);
     tl2ptr=&tl2lst[usrnum];
     setmbk(tlcmb);
     telext();
     hupapi();
     if (cedctrl.user == usrnum) {
          cedctrl.user=-1;
          cedctrl.state=0;
          cedctrl.channel=BADCHAN;
     }
     if (aedctrl.user == usrnum) {
          aedctrl.user=-1;
          aedctrl.state=0;
     }
     if (usrptr->state == tlcstt) {
          switch (usrptr->substt) {
          case LINKED:
               btubsz(usrnum,INPSIZ,OUTSIZ);
          case TLKING:
               if (!(usrptr->flags&INVISB)) {
                    tpfmlt(TLCHUP,usaptr->userid);
                    outtlc();
               }
               break;
          case LNKING:
               btubsz(usrnum,INPSIZ,OUTSIZ);
               if (usaptr->userid[0] != '(') {
                    user[tlcptr->chatch].substt=GOING;
                    btuinj(tlcptr->chatch,RING);
                    break;
               }
          case CHTING:
               hupchi(ECHHP2);
               break;
          case GOING:
               break;
          case FLHING:
               lvpool();
               break;
          case 90:
          case 91:
          case 92:
               setmem(telmisc,sizeof(struct telemisc),0);
          }
     }
     if (tlcptr->flags&EDITED) {
          setbtv(tbb);
          setmem(&tlcdat,sizeof(struct tlcdat),0);
          acqbtv(&tlcdat,usaptr->userid,0);
          strcpy(tlcdat.userid,usaptr->userid);
          tlcdat.flags=tlcptr->pflags;
          tlcdat.defchn=tlcptr->defchn;
          tlcdat.action=tlcptr->action;
          tlcdat.pagsts=tlcptr->pagsts;
          tlcdat.pagint=tlcptr->pagint;
          tlcdat.chaint=tlcptr->chaint;
          strcpy(tlcdat.theme,tlcptr->theme);
          strcpy(tlcdat.entmsg,tl2ptr->entmsg);
          strcpy(tlcdat.extmsg,tl2ptr->extmsg);
          if (acqbtv(NULL,usaptr->userid,0)) {
               updbtv(&tlcdat);
          }
     }
     if (isuidc(usaptr->userid[0])) {
          chn=tlcptr->prvchn;
          for (j=0 ; j < nterms ; j++) {
               otlcpt=tlcoff(j);
               if (otlcpt->channel == chn && usrnum != j) {
                    swtchn(j,findhome(j));
                    if (user[j].state == tlcstt && user[j].substt == FLHING) {
                         ret2tl(j);
                    }
                    else if (user[j].state == tlcstt
                       && user[j].substt == TLKING) {
                         tlcptr=otlcpt;
                         i=usrnum;

                         curusr(j);
                         tpfmsg(HKICKO2,uacoff(i)->userid);
                         tlcctx(usrnum);
                         prfmsg(ETLPMT);
                         outprf(usrnum);

                         if (!(usrptr->flags&INVISB)) {
                              tpfmlt(CAMEIN,usaptr->userid);
                              outtlc();
                         }

                         otlcpt=tlcptr;
                         curusr(i);
                    }
               }
               otlcpt->INVFLS(usrnum)&=~FNDBIT(usrnum);
               otlcpt->FORFLS(usrnum)&=~FNDBIT(usrnum);
               otlcpt->IGNFLS(usrnum)&=~FNDBIT(usrnum);
          }
     }
     for (othusn=0 ; othusn < nterms ; othusn++) {
          otlcpt=tlcoff(othusn);
          if (otlcpt->chatch == usrnum) {
               otlcpt->flags&=~CCHVLD;
          }
          if ((otlcpt->rewhsps == -1) && (otlcpt->rewhspu == usrnum)) {
               otlcpt->rewhspu=-1;
          }
     }
     swtchn(usrnum,BADCHAN);
     tlcptr=tlcoff(usrnum);
     setmem(tlcptr,sizeof(struct tlc),0);
}

STATIC void
hupchi(xitmsg)                /* utility for terminating btuchi link */
int xitmsg;
{

#ifdef DOCLINK
     extern unsigned chanl;
     chanl=0xFFFF;
#endif

     actas(tlcptr->chatch);
     lvchi(xitmsg,ENTTLC);
     prfmsg(ETLPMT);
     outprf(usrnum);
     actas(tlcptr->chatch);
}

STATIC void
actas(usrnm)                  /* act as specified user until further notice*/
int usrnm;
{
     usrnum=usrnm;
     usrptr=&user[usrnum];
     extptr=extoff(usrnum);
     clingo=extptr->lingo;
     usaptr=uacoff(usrnum);
     tlcptr=tlcoff(usrnum);
     tl2ptr=&tl2lst[usrnum];
     pbptr=fapyrs[usrnum].poolpt;
}

STATIC void
deltlc(userid)                /* delete user routine                       */
char *userid;
{
     setbtv(tbb);
     if (acqbtv(NULL,userid,0)) {
          delbtv();
     }
}

STATIC void
clstlc(void)                  /* close teleconference files for shutdown   */
{
     clsact();
     clsapi();
     clsmsg(tlcmb);
     clsbtv(tbb);
     clsbtv(tchbb);
}

STATIC void
echo(void)                    /* handle the "echo" command                 */
{
     if (sameas(margv[1],"on")) {
          btuech(usrnum,2);
          tpfmsg(ECHMON);
     }
     else if (sameas(margv[1],"off")) {
          btuech(usrnum,0);
          tpfmsg(ECHMOF);
     }
     else if (sameas(margv[1],"px")) {
          btuech(usrnum,1);
          tpfmsg(ECHMPX);
     }
     else {
          tpfmsg(ECHHLP);
     }
}

void
entrmsg(void)                /* display default msg or enter msg     */
{
     if ((!(chnlst[tlcptr->channel].flags&CENTERX))
      || (!strlen(tl2ptr->entmsg))) {
          tpfmlt(ENTTLC,usaptr->userid);
     }
     else {
          tpfmlt(EXISKL,tl2ptr->entmsg);
     }
}

void
telext(void)                       /* telegames general exit functions     */
{
     exiapi();
}

int
urinv(void)                        /* can't execute command while invisible*/
{
     if (usrptr->flags&INVISB) {
          tpfmsg(URINVS);
          return(1);
     }
     return(0);
}

/*****************  TELECONFERENCE EDITOR SUBSTATE ROUTINES ***************/

static
char *defchs[3]={
     "","Main Channel","Private Channel"
};

static
char *onoffs[4]={
     "","ON","OFF","OK"
};

STATIC void
teditor(void)                      /* teleconference editor main menu      */
{
     if (margc == 0) {
          tedtmnu();
     }
     else {
          switch (toupper(*margv[0])) {
          case 'X':
               tpfmsg(EXIEDT);
               outprf(usrnum);
               usrptr->substt=TLKING;
               btumil(usrnum,tinpsz);
               swtchn(usrnum,tlcptr->channel);
               if (!(usrptr->flags&INVISB)) {
                    entrmsg();
                    outtlc();
               }
               tpfmsg(INTRO);
               tlcctx(usrnum);
               tlcptr->flags|=EDITED;
               break;
          case '1':
               tpfmsg(DEFCHN2);
               usrptr->substt=11;
               break;
          case '2':
               tpfmsg(DEFACT2);
               usrptr->substt=12;
               break;
          case '3':
               tpfmsg(PAGOOO2);
               usrptr->substt=13;
               break;
          case '4':
               tpfmsg(PAGINT);
               usrptr->substt=14;
               break;
          case '5':
               tpfmsg(CHAINT);
               usrptr->substt=15;
               break;
          case '6':
               tpfmsg(CHATHE);
               btumil(usrnum,40);
               usrptr->substt=16;
               break;
          case '7':
               if (!hasmtkey(REQKEY)) {
                    tpfmsg(NOREQS);
                    tedtmnu();
               }
               else {
                    tpfmsg(REQENT);
                    btumil(usrnum,TMSSIZ);
                    usrptr->substt=17;
               }
               break;
          case '8':
               if (!hasmtkey(REQKEY)) {
                    tpfmsg(NOREQS);
                    tedtmnu();
               }
               else {
                    tpfmsg(REQEXT);
                    btumil(usrnum,TMSSIZ);
                    usrptr->substt=18;
               }
               break;
          default:
               tpfmsg(SAYWHA);
               tedtmnu();
          }
     }
}

STATIC void
tedtmnu(void)                      /* display current user settings        */
{
     usrptr->substt=EDTING;
     setbtv(tbb);
     geqbtv(&tlcdat,usaptr->userid,0);
     rstbtv();
     prfmsg(EDTMNU2,(!strlen(tl2ptr->entmsg) ? "(none)" : tl2ptr->entmsg),
                   (!strlen(tl2ptr->extmsg) ? "(none)" : tl2ptr->extmsg),
                   defchs[tlcptr->defchn],
                   onoffs[tlcptr->action],
                   onoffs[tlcptr->pagsts],
                   tlcptr->pagint/4,
                   tlcptr->chaint/4,
                   (tlcptr->theme[0] == '\0' ? "(none)" : tlcptr->theme),
                   (tlcdat.reqent[0] == '\0' ? "(none)" : tlcdat.reqent),
                   (tlcdat.reqext[0] == '\0' ? "(none)" : tlcdat.reqext));
}

STATIC void
edtr01(void)                       /* handle editing default channel       */
{
     if (margc == 0) {
          tedtmnu();
     }
     else {
          switch (*margv[0]) {
          case '1':
               tpfmsg(OKSET);
               tlcptr->defchn=1;
               tedtmnu();
               break;
          case '2':
               tpfmsg(OKSET);
               tlcptr->defchn=2;
               tedtmnu();
               break;
          default:
               tpfmsg(SAYWHA);
               tpfmsg(DEFCHN2);
          }
     }
}

STATIC void
edtr02(void)                       /* handle setting action mode on/off    */
{
     if (margc == 0) {
          tedtmnu();
     }
     else {
          switch (*margv[0]) {
          case '1':
               tpfmsg(OKSET);
               tlcptr->action=1;
               tedtmnu();
               break;
          case '2':
               tpfmsg(OKSET);
               tlcptr->action=2;
               tedtmnu();
               break;
          default:
               tpfmsg(SAYWHA);
               tpfmsg(DEFACT2);
          }
     }
}

STATIC void
edtr03(void)                       /* handle setting page status           */
{
     if (margc == 0) {
          tedtmnu();
     }
     else {
          switch (*margv[0]) {
          case '1':
               tpfmsg(OKSET);
               tlcptr->pagsts=1;
               tedtmnu();
               break;
          case '2':
               tpfmsg(OKSET);
               tlcptr->pagsts=2;
               tedtmnu();
               break;
          case '3':
               tpfmsg(OKSET);
               tlcptr->pagsts=3;
               tedtmnu();
               break;
          default:
               tpfmsg(SAYWHA);
               tpfmsg(PAGOOO2);
          }
     }
}

STATIC void
edtr04(void)                       /* handle page interval                 */
{
     int i;

     if (margc == 0) {
          tedtmnu();
     }
     else if ((i=atoi(margv[0])) > 0 && i < 10) {
          tpfmsg(OKSET);
          tlcptr->pagint=(4*i);
          tedtmnu();
     }
     else {
          tpfmsg(SAYWHA);
          tpfmsg(PAGINT);
     }
}

STATIC void
edtr05(void)                       /* handle chat intervals                */
{
     int i;

     if (margc == 0) {
          tedtmnu();
     }
     else if ((i=atoi(margv[0])) > 0 && i < 10) {
          tpfmsg(OKSET);
          tlcptr->chaint=(4*i);
          tedtmnu();
     }
     else {
          tpfmsg(SAYWHA);
          tpfmsg(CHAINT);
     }
}

STATIC void
edtr06(void)                       /* handle setting a channel topic       */
{
     if (margc == 0) {
          tlcptr->theme[0]='\0';
          tedtmnu();
     }
     else {
          rstrin();
          stzcpy(tlcptr->theme,margv[0],TPCSIZ);
          tpfmsg(OKSET);
          tedtmnu();
     }
}

STATIC void
edtr07(void)                       /* handle setting req ent message       */
{
     if (margc == 0) {
          tedtmnu();
     }
     else {
          setbtv(tbb);
          geqbtv(&tlcdat,usaptr->userid,0);
          rstrin();
          if (hasmtkey(AUTKEY)) {
               if (oktocg) {
                    if (!dedcrd((long)msgchg,0)) {
                         tpfmsg(CNTAFT,"you");
                    }
                    else {
                         stzcpy(tlcdat.entmsg,margv[0],TMSSIZ);
                         strcpy(tl2ptr->entmsg,tlcdat.entmsg);
                         tpfmsg(YOUUPD2,msgchg);
                    }
               }
               else {
                    stzcpy(tlcdat.entmsg,margv[0],TMSSIZ);
                    strcpy(tl2ptr->entmsg,tlcdat.entmsg);
                    tpfmsg(OKSETAUT);
               }
          }
          else {
               stzcpy(tlcdat.reqent,margv[0],TMSSIZ);
               tpfmsg(OKSET);
          }
          updbtv(&tlcdat);
          rstbtv();
          tedtmnu();
     }
}

STATIC void
edtr08(void)                       /* handle setting req ext message       */
{
     if (margc == 0) {
          tedtmnu();
     }
     else {
          setbtv(tbb);
          geqbtv(&tlcdat,usaptr->userid,0);
          rstrin();
          if (hasmtkey(AUTKEY)) {
               if (oktocg) {
                    if (!dedcrd((long)msgchg,0)) {
                         tpfmsg(CNTAFT,"you");
                    }
                    else {
                         stzcpy(tlcdat.extmsg,margv[0],TMSSIZ);
                         strcpy(tl2ptr->extmsg,tlcdat.extmsg);
                         tpfmsg(YOUUPD2,msgchg);
                    }
               }
               else {
                    stzcpy(tlcdat.extmsg,margv[0],TMSSIZ);
                    strcpy(tl2ptr->extmsg,tlcdat.extmsg);
                    tpfmsg(OKSETAUT);
               }
          }
          else {
               stzcpy(tlcdat.reqext,margv[0],TMSSIZ);
               tpfmsg(OKSET);
          }
          updbtv(&tlcdat);
          rstbtv();
          tedtmnu();
     }
}

/*************** END OF TELECONFERENCE EDITING SUBSTATE ROUTINE ************/

/*****************  SYSOP EDITOR FOR ENTER/EXIT MESSAGES    ****************/

static
struct tlcdat othtlc;

STATIC void
usredt(void)                       /* entering sysop editor state          */
{
     setmem(telmisc,sizeof(struct telemisc),0);
     usrptr->substt=90;
     tpfmsg(SYSEDT);
     btumil(usrnum,UIDSIZ-1);
     telmisc->edtin=1;
}

STATIC void
chkhdl(void)                       /* select a user to edit or exit editor */
{
     if (margc == 0) {
          usredt();
     }
     else if (sameas(margv[0],"x")) {
          setmem(telmisc,sizeof(struct telemisc),0);
          tpfmsg(EXIEDT);
          outprf(usrnum);
          usrptr->substt=TLKING;
          btumil(usrnum,tinpsz);
          swtchn(usrnum,tlcptr->channel);
          if (!(usrptr->flags&INVISB)) {
               entrmsg();
               outtlc();
          }
          tpfmsg(INTRO);
          tlcctx(usrnum);
     }
     else {
          rstrin();
          makhdl(input);
          setbtv(tbb);
          if (qeqbtv(input,0)) {
               gcrbtv(&othtlc,0);
               movmem(input,telmisc->uname,UIDSIZ);
               pmtedw();
               usrptr->substt=91;
          }
          else {
               tpfmsg(NOSUCH);
          }
     }
}

STATIC void
pmtedw(void)                       /* prompt for "edit which field?"       */
{
     struct usracc tmpacc;

     if (!onsysn(telmisc->uname,1)) {
          setbtv(accbb);
          geqbtv(othuap=&tmpacc,telmisc->uname,0);
     }
     prfmsg(EDTWC4,telmisc->uname,
          (!strlen(othtlc.entmsg) ? "<None Set>" : othtlc.entmsg),
          (!strlen(othtlc.extmsg) ? "<None Set>" : othtlc.extmsg),
          othtlc.reqent[0] == '\0' ? "(none)" : othtlc.reqent,
          othtlc.reqext[0] == '\0' ? "(none)" : othtlc.reqext,
          ((othtlc.flags&SQULCH) ? "Yes" : "No"),
          l2as(othuap->creds));
}

STATIC void
edtwch(void)                       /* select choice to edit or exit out    */
{
     if (margc == 0) {
          pmtedw();
     }
     else {
          switch (toupper(*margv[0])) {
          case 'X':
               setbtv(tbb);
               if (qeqbtv(telmisc->uname,0)) {
                    dedcds();
               }
               else {
                    prfmsg(RECNUP);
               }
               usredt();
               break;
          case '1':
          case '2':
               telmisc->wchmsg=atoi(margv[0]);
               shomsg();
               break;
          case '3':
               telmisc->wchmsg=1;
               updrent();
               break;
          case '4':
               telmisc->wchmsg=2;
               updrext();
               break;
          case '5':
               updflag(SQULCH);
               break;
          default:
               tpfmsg(SAYWHA);
               pmtedw();
          }
     }
}

STATIC void
updrent(void)
{
     if (othtlc.reqent[0] != '\0') {
          strcpy(othtlc.entmsg,othtlc.reqent);
          othtlc.reqent[0]='\0';
          telmisc->entchg=1;
          telmisc->updrec|=UPDMSG;
     }
     pmtedw();
}

STATIC void
updrext(void)
{
     if (othtlc.reqext[0] != '\0') {
          strcpy(othtlc.extmsg,othtlc.reqext);
          othtlc.reqext[0]='\0';
          telmisc->extchg=1;
          telmisc->updrec|=UPDMSG;
     }
     pmtedw();
}

STATIC void
updflag(flag)                      /* update one of the users flags        */
int flag;
{
     if (othtlc.flags&flag) {
          othtlc.flags&=~flag;
     }
     else {
          othtlc.flags|=flag;
     }
     telmisc->updrec|=UPDFLG;
     pmtedw();
}

STATIC void
shomsg(void)                       /* show current message, prompt for new */
{
     prfmsg(SHOSTF,telmisc->wchmsg == 1 ? "entrance" : "exit",
          telmisc->wchmsg == 1 ? (!strlen(othtlc.entmsg) ? "<None Set>" : othtlc.entmsg) :
                                 (!strlen(othtlc.extmsg) ? "<None Set>" : othtlc.extmsg));
     usrptr->substt=92;
     btumil(usrnum,TMSSIZ-1);
}

STATIC void
updmsg(void)                       /* update the message in the work area  */
{
     char *msgptr;

     if (margc) {
          msgptr=(telmisc->wchmsg == 1 ? othtlc.entmsg : othtlc.extmsg);
          setmem(msgptr,TMSSIZ,0);
          if (margc == 1 && toupper(*margv[0]) == 'X') {
          }
          else {
               rstrin();
               strcpy(msgptr,input);
               if (telmisc->wchmsg == 1) {
                    telmisc->entchg=1;
               }
               else {
                    telmisc->extchg=1;
               }
          }
          telmisc->updrec|=UPDMSG;
     }
     usrptr->substt=91;
     btumil(usrnum,tinpsz);
     pmtedw();
}

STATIC void
dedcds(void)                       /* deduct the credits from the user     */
{
     int chgamt;
     struct usracc tmpacc;

     if (telmisc->updrec&UPDFLG) {
          if (onsysn(telmisc->uname,1)) {
               tlcoff(othusn)->pflags=0;
               tlcoff(othusn)->pflags|=othtlc.flags&SQULCH;
               tlcoff(othusn)->flags|=EDITED;
          }
     }
     if (telmisc->updrec&UPDMSG) {
          if (oktocg) {
               chgamt=(telmisc->entchg+telmisc->extchg)*msgchg;
               if (chgamt) {
                    if (onsysn(telmisc->uname,1)) {
                         if (!odedcrd(othusn,(long)chgamt,0,0)) {
                              tpfmsg(CNTAFT,telmisc->uname);
                              return;
                         }
                         else {
                              movmem(othtlc.entmsg,tl2lst[othusn].entmsg,TMSSIZ);
                              movmem(othtlc.extmsg,tl2lst[othusn].extmsg,TMSSIZ);
                              tlcoff(othusn)->flags|=EDITED;
                              clrprf();
                              tpfmlt(YOUUPD2,chgamt);
                              injoth();
                              tpfmsg(USRCHD2,telmisc->uname,chgamt);
                         }
                    }
                    else {
                         setbtv(accbb);
                         if (acqbtv(&tmpacc,telmisc->uname,0)) {
                              if (!ndedcrd(tmpacc.userid,(long)chgamt,0,0)) {
                                   tpfmsg(CNTAFT,telmisc->uname);
                                   return;
                              }
                              else {
                                   tpfmsg(USRDED,telmisc->uname,chgamt);
                              }
                         }
                         else {
                              catastro("TLC: No master for %s!",telmisc->uname);
                         }
                    }
                    if (dispad) {
                         shocst("TELECONFERENCE CREDIT CHARGE",
                                "%s charged %d credits",telmisc->uname,chgamt);
                    }
               }
               else {
                    chgmsg();
               }
          }
          else {
               chgmsg();
          }
     }
     setbtv(tbb);
     gcrbtv(NULL,0);
     updbtv(&othtlc);
     prfmsg(URCUPD);
}

STATIC void
chgmsg(void)                       /* enter/exit changed no charge update  */
{
     if (onsys(telmisc->uname)) {
          movmem(othtlc.entmsg,tl2lst[othusn].entmsg,TMSSIZ);
          movmem(othtlc.extmsg,tl2lst[othusn].extmsg,TMSSIZ);
          tlcoff(othusn)->flags|=EDITED;
          clrprf();
          tpfmlt(YOUUPDF);
          injoth();
          tpfmsg(USRCHDF,telmisc->uname);
     }
}
/*************** END OF SYSOP ENTER/EXIT MESSAGE ***************************/

/************************* CHANNEL EDITING *********************************/

/* Check to see if someone should go into the channel editor               */
/* 0 = No, 1 = Goes into editor, 2 = Goes into FSD (Moderator)             */

STATIC int
ckchned(void)
{
     if (hasmtkey(TSYSKEY)) {
          if (cedctrl.user == -1) {
               cedctrl.user=usrnum;
               cedctrl.sysop=TRUE;
               cedctrl.state=CEDHDRP2;
               if (!(usrptr->flags&INVISB)) {
                    tpfmlt(ENTEDT,usaptr->userid);
                    outtlc();
               }
               usrptr->substt=EDTCHAN;
               prfmsg(CEDHDR);
               prfmsg(CEDHDRP2);
          }
          else {
               prfmsg(CEDBUSY);
          }
          return(1);
     }
     if (modchn(usrnum,tlcptr->channel)) {
          if (cedctrl.user == -1) {
               cedctrl.user=usrnum;
               cedctrl.sysop=FALSE;
               cedctrl.state=CEDEDP;
               if (!(usrptr->flags&INVISB)) {
                    tpfmlt(ENTEDT,usaptr->userid);
                    outtlc();
               }
               usrptr->substt=EDTCHAN;
               cedctrl.channel=tlcptr->channel;
               cedtemp=chnlst[cedctrl.channel];
               if ((usaptr->ansifl&ANSON)
                && usaptr->scnfse >= 23
                && usaptr->scnwid >= 80) {
                    cedprp(CEDFSANS,1);
                    if (isripu()) {
                         fsdrhd(fsdhdr1);
                    }
                    fsdbkg(tfsdpft());
                    cedptc(FALSE);
                    fsdego(cedvfy,ceddun);
               }
               else {
                    cedprp(CEDFSNAN,0);
                    cedptc(FALSE);
                    fsdego(cedvfy,ceddun);
               }
               return(2);
          }
          else {
               prfmsg(CEDBUSY);
               return(1);
          }
     }
     return(0);
}

STATIC int
cfgchn(void)                  /* enter sysop channel editor                */
{
     switch (cedctrl.state) {
     case CEDHDRP2:
          if (margc == 0) {
               prfmsg(CEDHDR);
               prfmsg(CEDHDRP2);
               break;
          }
          switch (toupper(*margv[0])) {
          case 'E':
               cedctrl.state=CEDEDP;
               btumil(usrnum,CHNSIZ-1);
               prfmsg(CEDEDP);
               break;
          case 'L':
               lstchn();
               if (isripu()) {
                    prfmsg(CEDHDR);
               }
               prfmsg(CEDHDRP2);
               break;
          case 'V':
               cedctrl.state=CEDVWP;
               btumil(usrnum,CHNSIZ-1);
               prfmsg(CEDVWP);
               break;
          case 'C':
               if (!avspcchn()) {
                    prfmsg(CEDNSPC);
                    if (isripu()) {
                         prfmsg(CEDHDR);
                    }
                    prfmsg(CEDHDRP2);
                    break;
               }
               cedctrl.state=CEDCRP;
               btumil(usrnum,CHNSIZ-1);
               prfmsg(CEDCRP);
               break;
          case 'D':
               cedctrl.state=CEDDLP;
               btumil(usrnum,CHNSIZ-1);
               prfmsg(CEDDLP);
               break;
          case 'X':
               btumil(usrnum,tinpsz);
               btuxnf(usrnum,0,19);
               cedctrl.user=-1;
               cedctrl.channel=BADCHAN;
               usrptr->substt=TLKING;
               swtchn(usrnum,tlcptr->channel);
               if (!(usrptr->flags&INVISB)) {
                    entrmsg();
                    outtlc();
               }
               prfmsg(ED2TLC);
               tlcctx(usrnum);
               break;
          case '?':
               prfmsg(CEDHDR);
               prfmsg(CEDHDRP2);
               break;
          default:
               prfmsg(SAYWHA);
               if (isripu()) {
                    prfmsg(CEDHDR);
               }
               prfmsg(CEDHDRP2);
          }
          break;
     case CEDEDP:                  /* Base editing                         */
          if (margc == 0) {
               prfmsg(CEDEDP);
               break;
          }
          if (sameas(margv[0],"X")) {
               cedctrl.state=CEDHDRP2;
               if (isripu()) {
                    prfmsg(CEDHDR);
               }
               prfmsg(CEDHDRP2);
               btumil(usrnum,tinpsz);
               break;
          }
          if (sameas(margv[0],"?")) {
               lstchn();
               prfmsg(CEDEDP);
               break;
          }
          cedctrl.channel=chkpub(margv[0]);
          if (cedctrl.channel != BADCHAN) {
               cedtemp=chnlst[cedctrl.channel];
               if ((usaptr->ansifl&ANSON)
                && usaptr->scnfse >= 23
                && usaptr->scnwid >= 80) {
                    cedprp(CEDFSANS,1);
                    if (isripu()) {
                         fsdrhd(fsdhdr2);
                    }
                    fsdbkg(tfsdpft());
                    cedptc(TRUE);
                    fsdego(cedvfy,ceddun);
               }
               else {
                    cedprp(CEDFSNAN,0);
                    cedptc(TRUE);
                    fsdego(cedvfy,ceddun);
               }
               return(0);
          }
          else {
               prfmsg(CEDBDC);
               prfmsg(CEDEDP);
               break;
          }
     case CEDVWP:                  /* Base viewing                         */
          if (margc == 0) {
               prfmsg(CEDVWP);
               break;
          }
          if (sameas(margv[0],"X")) {
               cedctrl.state = CEDHDRP2;
               if (isripu()) {
                    prfmsg(CEDHDR);
               }
               prfmsg(CEDHDRP2);
               btumil(usrnum,tinpsz);
               break;
          }
          if (sameas(margv[0],"?")) {
               lstchn();
               prfmsg(CEDVWP);
               break;
          }
          cedctrl.channel=chkpub(margv[0]);
          if (cedctrl.channel != BADCHAN) {
               cedtemp=chnlst[cedctrl.channel];
               cedprp(CEDFSINF,-1);
               fsddsp(tfsdpft());
               usrptr->substt=EDTCHAN;
               prfmsg(CEDVWP);
               break;
          }
          else {
               prfmsg(CEDBDC);
               prfmsg(CEDVWP);
               break;
          }
     case CEDCRP:                  /* Creating a channel                   */
          if (margc == 0) {
               prfmsg(CEDCRP);
               break;
          }
          if (sameas(margv[0],"X")) {
               cedctrl.state=CEDHDRP2;
               if (isripu()) {
                    prfmsg(CEDHDR);
               }
               prfmsg(CEDHDRP2);
               btumil(usrnum,tinpsz);
               break;
          }
          if (!chkalph(margv[0])) {
               prfmsg(CEDNOA,margv[0]);
               prfmsg(CEDCRP);
               break;
          }
          cedctrl.channel=chkpub(margv[0]);
          if (cedctrl.channel != BADCHAN) {
               prfmsg(CEDALRX,margv[0]);
               prfmsg(CEDCRP);
               break;
          }
          memset(&cedtemp,'\0',sizeof(struct chanls));
          strcpy(cedtemp.name,margv[0]);
          strcpy(cedtemp.modkey,getmsg(TSYSKEY));
          strcpy(cedtemp.axskey,getmsg(UNLKEY));
          cedtemp.flags=CENTERX;
          if ((usaptr->ansifl&ANSON)
           && usaptr->scnfse >= 23
           && usaptr->scnwid >= 80) {
               cedprp(CEDFSANS,1);
               if (isripu()) {
                    fsdrhd(fsdhdr3);
               }
               fsdbkg(tfsdpft());
               cedptc(TRUE);
               fsdego(cedvfy,cedcdun);
          }
          else {
               cedprp(CEDFSNAN,0);
               cedptc(TRUE);
               fsdego(cedvfy,cedcdun);
          }
          return(0);
     case CEDDLP:                  /* Deleting a channel                   */
          if (margc == 0) {
               prfmsg(CEDDLP);
               break;
          }
          if (sameas(margv[0],"X")) {
               cedctrl.state=CEDHDRP2;
               if (isripu()) {
                    prfmsg(CEDHDR);
               }
               prfmsg(CEDHDRP2);
               btumil(usrnum,tinpsz);
               break;
          }
          if (sameas(margv[0],"?")) {
               lstchn();
               prfmsg(CEDDLP);
               break;
          }
          if (sameas(margv[0],MNNAME)) {
               prfmsg(CEDNDLM);
               prfmsg(CEDDLP);
               break;
          }
          cedctrl.channel=chkpub(margv[0]);
          if (cedctrl.channel == BADCHAN) {
               prfmsg(CEDBDC);
               prfmsg(CEDDLP);
               break;
          }
          else {
               cedctrl.state=CEDDLSR;
               prfmsg(CEDDLSR,chnlst[cedctrl.channel].name);
               btumil(usrnum,tinpsz);
               break;
          }
     case CEDDLSR:
          if (margc == 0) {
               prfmsg(CEDDLSR,chnlst[cedctrl.channel].name);
               btumil(usrnum,tinpsz);
               break;
          }
          if (sameas(margv[0],"X")) {
               cedctrl.state=CEDHDRP2;
               if (isripu()) {
                    prfmsg(CEDHDR);
               }
               prfmsg(CEDHDRP2);
               break;
          }
          if ((margv[0][0] == 'y') || (margv[0][0] == 'Y')) {
               if (ndelchn(cedctrl.channel,1) == 0) {
                    prfmsg(CEDDLSC);
               }
               else {
                    prfmsg(CEDDLER);
               }
               cedctrl.state=CEDHDRP2;
               if (isripu()) {
                    prfmsg(CEDHDR);
               }
               prfmsg(CEDHDRP2);
               break;
          }
          else if ((margv[0][0] == 'n') || (margv[0][0] == 'N')) {
               prfmsg(CEDNDL,chnlst[cedctrl.channel].name);
               cedctrl.state=CEDHDRP2;
               if (isripu()) {
                    prfmsg(CEDHDR);
               }
               prfmsg(CEDHDRP2);
               break;
          }
          else {
               prfmsg(CEDDLSR,chnlst[cedctrl.channel].name);
               btumil(usrnum,tinpsz);
               break;
          }
     default:
          catastro("EDITCHAN SUBSTATE ERROR");
     }
     return(1);
}
/************************ END OF CHANNEL EDITORS ***************************/

/************************* ACTION LIST EDITORS *****************************/


STATIC int
cfglst(void)                       /* Enter action editor                  */
{
     static int tmpint;

     switch (aedctrl.state) {
     case LEDHDRP:
          if (margc == 0) {
               prfmsg(LEDHDR);
               prfmsg(LEDHDRP);
               break;
          }
          switch (toupper(*margv[0])) {
          case 'E':
               aedctrl.state=LEDEDP;
               btumil(usrnum,ACTSIZ-1);
               prfmsg(LEDEDP);
               break;
          case 'L':
               lstlst();
               if (isripu()) {
                    prfmsg(LEDHDR);
               }
               prfmsg(LEDHDRP);
               break;
          case 'W':
               aedctrl.state=LEDWDP;
               btumil(usrnum,ACTSIZ-1);
               prfmsg(LEDWDP);
               break;
          case 'V':
               aedctrl.state=LEDVWP;
               btumil(usrnum,ACTSIZ-1);
               prfmsg(LEDVWP);
               break;
          case 'C':
               aedctrl.state=LEDCRP;
               btumil(usrnum,ACTSIZ-1);
               prfmsg(LEDCRP);
               break;
          case 'D':
               aedctrl.state=LEDDLP;
               btumil(usrnum,ACTSIZ-1);
               prfmsg(LEDDLP);
               break;
          case 'X':
               btumil(usrnum,tinpsz);
               btuxnf(usrnum,0,19);
               aedctrl.user=-1;
               aedctrl.state=0;
               usrptr->substt=TLKING;
               swtchn(usrnum,tlcptr->channel);
               if (!(usrptr->flags&INVISB)) {
                    entrmsg();
                    outtlc();
               }
               prfmsg(ED2TLC);
               tlcctx(usrnum);
               break;
          case '?':
               prfmsg(LEDHDR);
               prfmsg(LEDHDRP);
               break;
          default:
               prfmsg(SAYWHA);
               if (isripu()) {
                    prfmsg(LEDHDR);
               }
               prfmsg(LEDHDRP);
          }
          break;
     case LEDEDP:                  /* Base editing                         */
          if (margc == 0) {
               prfmsg(LEDEDP);
               break;
          }
          if (sameas(margv[0],"X")) {
               aedctrl.state=LEDHDRP;
               if (isripu()) {
                    prfmsg(LEDHDR);
               }
               prfmsg(LEDHDRP);
               btumil(usrnum,tinpsz);
               break;
          }
          if (sameas(margv[0],"?")) {
               lstlst();
               prfmsg(LEDEDP);
               break;
          }
          strcpy(ledtemp.list,LSTNAM);
          stzcpy(ledtemp.name,margv[0],ACTSIZ);
          if (chklst(&ledtemp) == 1) {
               if ((usaptr->ansifl&ANSON)
                && usaptr->scnfse >= 23
                && usaptr->scnwid >= 80) {
                    ledprp(LEDFSANS,1);
                    if (isripu()) {
                         fsdrhd(fsdhdr4);
                    }
                    fsdbkg(tfsdpft());
                    ledptc();
                    fsdego(ledvfy,leddun);
               }
               else {
                    ledprp(LEDFSNAN,0);
                    ledptc();
                    fsdego(ledvfy,leddun);
               }
               return(0);
          }
          else {
               prfmsg(LEDBDL);
               prfmsg(LEDEDP);
               break;
          }
     case LEDWDP:
          if (margc == 0) {
               prfmsg(LEDWDP);
               break;
          }
          if (sameas(margv[0],"X")) {
               aedctrl.state=LEDHDRP;
               if (isripu()) {
                    prfmsg(LEDHDR);
               }
               prfmsg(LEDHDRP);
               btumil(usrnum,tinpsz);
               break;
          }
          if (sameas(margv[0],"?")) {
               lstlst();
               prfmsg(LEDWDP);
               break;
          }
          strcpy(ledtemp.list,LSTNAM);
          stzcpy(ledtemp.name,margv[0],ACTSIZ);
          if (chklst(&ledtemp) == 1) {
               usrptr->substt=EDTACTN;
               aedctrl.state=AEDHDRP;
               prfmsg(AEDHDR);
               prfmsg(AEDHDRP);
               break;
          }
          else {
               prfmsg(LEDBDL);
               btumil(usrnum,ACTSIZ-1);
               prfmsg(LEDEDP);
               break;
          }
     case LEDVWP:                  /* Base viewing                         */
          if (margc == 0) {
               prfmsg(LEDVWP);
               break;
          }
          if (sameas(margv[0],"X")) {
               aedctrl.state=LEDHDRP;
               if (isripu()) {
                    prfmsg(LEDHDR);
               }
               prfmsg(LEDHDRP);
               btumil(usrnum,tinpsz);
               break;
          }
          if (sameas(margv[0],"?")) {
               lstlst();
               prfmsg(LEDVWP);
               break;
          }
          strcpy(ledtemp.list,LSTNAM);
          stzcpy(ledtemp.name,margv[0],ACTSIZ);
          if (chklst(&ledtemp) == 1) {
               ledprp(LEDFSINF,-1);
               fsddsp(tfsdpft());
               usrptr->substt=EDTLIST;
               prfmsg(LEDVWP);
               break;
          }
          else {
               prfmsg(LEDBDL);
               prfmsg(LEDVWP);
               break;
          }
     case LEDCRP:                  /* Creating a list                      */
          if (margc == 0) {
               prfmsg(LEDCRP);
               break;
          }
          if (sameas(margv[0],"X")) {
               aedctrl.state=LEDHDRP;
               if (isripu()) {
                    prfmsg(LEDHDR);
               }
               prfmsg(LEDHDRP);
               btumil(usrnum,tinpsz);
               break;
          }
          strupr(margv[0]);
          if (!chkalph(margv[0])) {
               prfmsg(LEDNOA,margv[0]);
               prfmsg(LEDCRP);
               break;
          }
          memset(&ledtemp,'\0',sizeof(struct actlst));
          strcpy(ledtemp.list,LSTNAM);
          stzcpy(ledtemp.name,margv[0],ACTSIZ);
          if ((tmpint=chklst(&ledtemp)) == 1) {
               prfmsg(LEDALRX,margv[0]);
               prfmsg(LEDCRP);
               break;
          }
          else if (tmpint == -1) {
               prfmsg(LEDALRX2,margv[0]);
               prfmsg(LEDCRP);
               break;
          }
          strcpy(ledtemp.usekey,getmsg(ACTKEY));
          if ((usaptr->ansifl&ANSON)
           && usaptr->scnfse >= 23
           && usaptr->scnwid >= 80) {
               ledprp(LEDFSANS,1);
               if (isripu()) {
                    fsdrhd(fsdhdr5);
               }
               fsdbkg(tfsdpft());
               ledptc();
               fsdego(ledvfy,ledcdun);
          }
          else {
               ledprp(LEDFSNAN,0);
               ledptc();
               fsdego(ledvfy,ledcdun);
          }
          return(0);
     case LEDDLP:                  /* Deleting a list                      */
          if (margc == 0) {
               prfmsg(LEDDLP);
               break;
          }
          if (sameas(margv[0],"X")) {
               aedctrl.state=LEDHDRP;
               if (isripu()) {
                    prfmsg(LEDHDR);
               }
               prfmsg(LEDHDRP);
               btumil(usrnum,tinpsz);
               break;
          }
          if (sameas(margv[0],"?")) {
               lstlst();
               prfmsg(LEDDLP);
               break;
          }
          strcpy(ledtemp.list,LSTNAM);
          stzcpy(ledtemp.name,margv[0],ACTSIZ);
          if (chklst(&ledtemp) == 1) {
               aedctrl.state=LEDDLSR;
               prfmsg(LEDDLSR,ledtemp.name);
               btumil(usrnum,tinpsz);
               break;
          }
          else {
               prfmsg(LEDBDL);
               prfmsg(LEDDLP);
               break;
          }
     case LEDDLSR:
          if (margc == 0) {
               prfmsg(LEDDLSR,ledtemp.name);
               btumil(usrnum,tinpsz);
               break;
          }
          if (sameas(margv[0],"X")) {
               aedctrl.state=LEDHDRP;
               if (isripu()) {
                    prfmsg(LEDHDR);
               }
               prfmsg(LEDHDRP);
               break;
          }
          if ((margv[0][0] == 'y') || (margv[0][0] == 'Y')) {
               if (dellst(&ledtemp) == 0) {
                    prfmsg(LEDDLSC);
               }
               else {
                    prfmsg(LEDDLER);
               }
               aedctrl.state=LEDHDRP;
               if (isripu()) {
                    prfmsg(LEDHDR);
               }
               prfmsg(LEDHDRP);
               break;
          }
          else if ((margv[0][0] == 'n') || (margv[0][0] == 'N')) {
               prfmsg(LEDNDL,ledtemp.name);
               aedctrl.state=LEDHDRP;
               if (isripu()) {
                    prfmsg(LEDHDR);
               }
               prfmsg(LEDHDRP);
               break;
          }
          else {
               prfmsg(LEDDLSR,ledtemp.name);
               btumil(usrnum,tinpsz);
               break;
          }
     default:
          catastro("EDITLIST SUBSTATE ERROR");
     }
     return(1);
}
/************************ END OF ACTION LIST EDITORS ***********************/

/************************* ACTION WORD EDITORS *****************************/

STATIC int
cfgact(void)                       /* Enter action editor                  */
{
     switch (aedctrl.state) {
     case AEDHDRP:
          if (margc == 0) {
               prfmsg(AEDHDR);
               prfmsg(AEDHDRP);
               break;
          }
          switch (toupper(*margv[0])) {
          case 'E':
               aedctrl.state=AEDEDP;
               btumil(usrnum,ACTSIZ-1);
               prfmsg(AEDEDP);
               break;
          case 'L':
               lstact(ledtemp.name,1);
               if (isripu()) {
                    prfmsg(AEDHDR);
               }
               prfmsg(AEDHDRP);
               break;
          case 'V':
               aedctrl.state=AEDVWP;
               btumil(usrnum,ACTSIZ-1);
               prfmsg(AEDVWP);
               break;
          case 'C':
               aedctrl.state=AEDCRP;
               btumil(usrnum,ACTSIZ-1);
               prfmsg(AEDCRP);
               break;
          case 'D':
               aedctrl.state=AEDDLP;
               btumil(usrnum,ACTSIZ-1);
               prfmsg(AEDDLP);
               break;
          case 'X':
               usrptr->substt=EDTLIST;
               aedctrl.state=LEDHDRP;
               if (isripu()) {
                    prfmsg(LEDHDR);
               }
               prfmsg(LEDHDRP);
               break;
          case '?':
               prfmsg(AEDHDR);
               prfmsg(AEDHDRP);
               break;
          default:
               prfmsg(SAYWHA);
               if (isripu()) {
                    prfmsg(AEDHDR);
               }
               prfmsg(AEDHDRP);
          }
          break;
     case AEDEDP:                  /* Base editing                         */
          if (margc == 0) {
               prfmsg(AEDEDP);
               break;
          }
          if (sameas(margv[0],"X")) {
               aedctrl.state=AEDHDRP;
               if (isripu()) {
                    prfmsg(AEDHDR);
               }
               prfmsg(AEDHDRP);
               btumil(usrnum,tinpsz);
               break;
          }
          if (sameas(margv[0],"?")) {
               lstact(ledtemp.name,1);
               prfmsg(AEDEDP);
               break;
          }
          memset(&aedtemp,'\0',sizeof(struct action));
          strcpy(aedtemp.list,ledtemp.name);
          stzcpy(aedtemp.name,margv[0],ACTSIZ);
          if (chkact(&aedtemp) == 1) {
               if ((usaptr->ansifl&ANSON)
                && usaptr->scnfse >= 23
                && usaptr->scnwid >= 80) {
                    aedprp(AEDFSAN2,1);
                    if (isripu()) {
                         fsdrhd(fsdhdr6);
                    }
                    fsdbkg(tfsdpft());
                    aedptc();
                    fsdego(aedvfy,aeddun);
               }
               else {
                    aedprp(AEDFSNA2,0);
                    aedptc();
                    fsdego(aedvfy,aeddun);
               }
               return(0);
          }
          else {
               prfmsg(AEDBDW);
               prfmsg(AEDEDP);
               break;
          }
     case AEDVWP:                    /* Base viewing                       */
          if (margc == 0) {
               prfmsg(AEDVWP);
               break;
          }
          if (sameas(margv[0],"X")) {
               aedctrl.state=AEDHDRP;
               if (isripu()) {
                    prfmsg(AEDHDR);
               }
               prfmsg(AEDHDRP);
               btumil(usrnum,tinpsz);
               break;
          }
          if (sameas(margv[0],"?")) {
               lstact(ledtemp.name,1);
               prfmsg(AEDVWP);
               break;
          }
          strcpy(aedtemp.list,ledtemp.name);
          stzcpy(aedtemp.name,margv[0],ACTSIZ);
          if (chkact(&aedtemp) == 1) {
               aedprp(AEDFSIN2,-1);
               fsddsp(tfsdpft());
               usrptr->substt=EDTACTN;
               prfmsg(AEDVWP);
               break;
          }
          else {
               prfmsg(AEDBDL);
               prfmsg(AEDVWP);
               break;
          }
     case AEDCRP:                    /* Creating a word                    */
          if (margc == 0) {
               prfmsg(AEDCRP);
               break;
          }
          if (sameas(margv[0],"X")) {
               aedctrl.state=AEDHDRP;
               if (isripu()) {
                    prfmsg(AEDHDR);
               }
               prfmsg(AEDHDRP);
               btumil(usrnum,tinpsz);
               break;
          }
          if (!valact(margv[0])) {
               prfmsg(AEDNOA2,margv[0]);
               prfmsg(AEDCRP);
               break;
          }
          memset(&aedtemp,'\0',sizeof(struct action));
          strcpy(aedtemp.list,ledtemp.name);
          stzcpy(aedtemp.name,margv[0],ACTSIZ);
          if (chkact(&aedtemp) != 0) {
               prfmsg(AEDALRX,margv[0]);
               prfmsg(AEDCRP);
               break;
          }
          if ((usaptr->ansifl&ANSON)
           && usaptr->scnfse >= 23
           && usaptr->scnwid >= 80) {
               aedprp(AEDFSAN2,1);
               if (isripu()) {
                    fsdrhd(fsdhdr7);
               }
               fsdbkg(tfsdpft());
               aedptc();
               fsdego(aedvfy,aedcdun);
          }
          else {
               aedprp(AEDFSNA2,0);
               aedptc();
               fsdego(aedvfy,aedcdun);
          }
          return(0);
     case AEDDLP:                  /* Deleting a word                      */
          if (margc == 0) {
               prfmsg(AEDDLP);
               break;
          }
          if (sameas(margv[0],"X")) {
               aedctrl.state=AEDHDRP;
               if (isripu()) {
                    prfmsg(AEDHDR);
               }
               prfmsg(AEDHDRP);
               btumil(usrnum,tinpsz);
               break;
          }
          if (sameas(margv[0],"?")) {
               lstact(ledtemp.name,1);
               prfmsg(AEDDLP);
               break;
          }
          strcpy(aedtemp.list,ledtemp.name);
          stzcpy(aedtemp.name,margv[0],ACTSIZ);
          if (chkact(&aedtemp) == 1) {
               aedctrl.state=AEDDLSR;
               prfmsg(AEDDLSR,aedtemp.name);
               btumil(usrnum,tinpsz);
               break;
          }
          else {
               prfmsg(AEDBDL);
               prfmsg(AEDDLP);
               break;
          }
     case AEDDLSR:
          if (margc == 0) {
               prfmsg(AEDDLSR,aedtemp.name);
               btumil(usrnum,tinpsz);
               break;
          }
          if (sameas(margv[0],"X")) {
               aedctrl.state=AEDHDRP;
               if (isripu()) {
                    prfmsg(AEDHDR);
               }
               prfmsg(AEDHDRP);
               break;
          }
          if ((margv[0][0] == 'y') || (margv[0][0] == 'Y')) {
               if (delact(&aedtemp) == 0) {
                    prfmsg(AEDDLSC);
               }
               else {
                    prfmsg(AEDDLER);
               }
               aedctrl.state=AEDHDRP;
               if (isripu()) {
                    prfmsg(AEDHDR);
               }
               prfmsg(AEDHDRP);
               break;
          }
          else if ((margv[0][0] == 'n') || (margv[0][0] == 'N')) {
               prfmsg(AEDNDL,aedtemp.name);
               aedctrl.state=AEDHDRP;
               if (isripu()) {
                    prfmsg(AEDHDR);
               }
               prfmsg(AEDHDRP);
               break;
          }
          else {
               prfmsg(AEDDLSR,aedtemp.name);
               btumil(usrnum,tinpsz);
               break;
          }
     default:
          catastro("EDITACTN SUBSTATE ERROR");
     }
     return(1);
}
/*********************** END OF ACTION WORD EDITOR *************************/

#ifdef DOCLINK

#define SPOKEVER 4
#define SPOKESUBVER 23

#undef LEVEL3
#undef LEVEL4
#undef LEVEL6
#include "galclspk.h"

#undef STATIC
#define STATIC static

tpf();

extern FILE *spokmb;

extern char tempname[40],tempname2[40];

extern unsigned chanl;
extern long oldvc;
extern int spokechn;
extern int linktime;
extern int autolink;
extern int debchan,scrdebug,deblen;
extern char *ejekey;
extern int chgxmt;

extern FILE *sff;

/* Configuration variables */

extern int clint;
extern char maintop[];
extern int netnswchx;
extern char *etlpmt;
int netactive=0;
int netmain;
char netchar;
extern int netcharge;
extern long hubvc;
int spspeed;
extern int brdnsys;

struct netuser *gnetusr,*othnet;

/* GALCLSPK.CFG variables */

extern char *nnstg;

/* I/O related variables and macros */

extern int inchsiz,outchsiz;

#define OUTPAQ1 ((struct paq1 *)outbuff)
#define OUTPAQ2 ((struct paq2 *)outbuff)
#define OUTPAQ3 ((struct paq3 *)outbuff)
#define OUTPAQ4 ((struct paq4 *)outbuff)

#define WAITBUFSIZE 81
extern char *waitbuff;

#define INBUFFSIZE 2048
#define OUTBUFSIZE 1024
#define COMPBUFFSIZE 2048
#define SQBUFFSIZE 2048

extern char *sqbuf;
extern char *compbuff,*compbuffptr;
extern char *inbuff,*buffptr,*inbuff2;
extern char *scrfname;
extern BTVFILE *netrbb;

struct netchain {
     int entries;
     struct netuser *netusr;
};

extern struct netchain netchain[MAXCHAIN];

int spokelog(),
    spoke();

void spokethn(),
     spokehup(),
     clsspoke(),
     spokecln(),
     spokedel();

int spokestt;

struct module smodule={       /* module interface block                    */
     "",                      /*    description for main menu              */
     spokelog,                /*    user logon supplemental routine        */
     spoke,                   /*    input routine if selected              */
     spokethn,                /*    status-input routine if selected       */
     NULL,                    /*    "injoth" routine                       */
     NULL,                    /*    logoff routine                         */
     spokehup,                /*    hangup (lost carrier) routine          */
     spokecln,                /*    midnight cleanup routine               */
     spokedel,                /*    delete-account routine                 */
     clsspoke                 /*    finish-up (sys shutdown) routine       */
};

void
inispoke(void)                /* initialize chatlink                       */
{
     int i;

     dclvda(OUTBUFSIZE);
     stzcpy(smodule.descrp,gmdnam("GALCL.MDF"),MNMSIZ);
     spokestt=register_module(&smodule);
     netrbb=opnbtv("GALCLREG.DAT",sizeof(struct netreg));
     setmbk(tlcmb);
     netnswchx=numopt(NSWCHX,1,32767);
     etlpmt=stgopt(ETLPMT);
     spokmb=opnmsg("GALCLSPK.MCV");
     setmbk(spokmb);
     netchar=chropt(SPOKCHAR);
     netcharge=numopt(SPOKECHG,0,32767);
     clint=ynopt(CLINT);
     scrfname=stgopt(SCRFNAME);
     brdnsys=ynopt(BRDNSYS);
     spspeed=numopt(CHSPEED,300,19200);
     chatlkey=stgopt(CHATLKEY);
     ejekey=stgopt(EJEKEY);
     chgxmt=ynopt(CHGXMT);
     rstmbk();
     spreadcfg();
     hubvc=257L*sysno+256L;
     if (OUTSIZ >= INPSIZ) {
          if (INPSIZ >= OUTSIZ/2) {
               inchsiz=OUTSIZ;
               outchsiz=INPSIZ;
          }
          else {
               inchsiz=OUTSIZ/2;
               outchsiz=inchsiz;
          }
     }
     else {
          if (OUTSIZ >= INPSIZ/2) {
               inchsiz=INPSIZ;
               outchsiz=OUTSIZ;
          }
          else {
               inchsiz=INPSIZ/2;
               outchsiz=inchsiz;
          }
     }
     inbuff=(char *)alczer(INBUFFSIZE);
     inbuff2=inbuff;
     buffptr=inbuff;
     compbuff=(char *)alczer(COMPBUFFSIZE);
     compbuffptr=compbuff;
     sqbuf=(char *)alczer(SQBUFFSIZE);
     waitbuff=(char *)alczer(WAITBUFSIZE);
     usrlist=(struct usrlist *)alczer(sizeof(struct usrlist)*nterms);
     for (i=0 ; i < MAXCHAIN ; i++) {
          netchain[i].netusr=NULL;
          netchain[i].entries=0;
     }
     rtkick(1,dlyspoke);
     rtkick(15,spokekick);
}

int
spokecheck(void)                   /* chatlink command handler             */
{
     int ret,tt;

     if (!chtlok) {
           return(telecn());
     }
     chanl=tlcoff(usrnum)->channel;
     oldvc=usrlist[usrnum].vc;
     if (usrptr->substt == TLKING && margc) {
          if (*margv[0] == netchar) {
               if (sameas(margv[0]+1,"menu") && haskey(syskey)) {
                    usrptr->flags|=NOINJO;
                    if (!(usrptr->flags&INVISB)) {
                         tlcptr->flags|=JUSTEX;
                         setmbk(tlcmb);
                         tpfmlt(ENTEDT,usaptr->userid);
                         outtlc();
                    }
                    setmbk(spokmb);
                    prfmsg(usrptr->substt=SPOKEMEN);
                    rstmbk();
                    usrlist[usrnum].chain=2;
                    usrptr->state=spokestt;
                    outprf(usrnum);
                    setusr(usrnum,tlcptr->channel,NULL,NULL);
                    telext();
                    if (netactive) {
                         moduser(usaptr->userid,sysno,usrnum,-1L);
                         sendmoduser(usaptr->userid,sysno,usrnum,-1L,4);
                    }
                    return(1);
               }
               if (sameas(margv[0]+1,"reg")) {
                    usrptr->flags|=NOINJO;
                    if (!(usrptr->flags&INVISB)) {
                         tlcptr->flags|=JUSTEX;
                         setmbk(tlcmb);
                         tpfmlt(ENTEDT,usaptr->userid);
                         outtlc();
                    }
                    usrlist[usrnum].chain=1;
                    usrptr->substt=SPOKEMEN;
                    strcpy(input,"r");
                    margc=1;
                    margv[0]=input;
                    setusr(usrnum,tlcptr->channel,NULL,NULL);
                    telext();
                    spoke();
                    usrptr->state=spokestt;
                    if (netactive) {
                         moduser(usaptr->userid,sysno,usrnum,-1L);
                         sendmoduser(usaptr->userid,sysno,usrnum,-1L,4);
                    }
                    return(1);
               }
               else if (sameas(margv[0]+1,"help") || sameas(margv[0]+1,"?")) {
                    setmbk(spokmb);
                    prfmlt(NETHELP,netchar,netchar,netchar,netchar,netchar,
                           netchar);
                    rstmbk();
                    pmlt(etlpmt);
                    outmlt(usrnum);
                    return(1);
               }
               else if (sameas(margv[0]+1,"who") && !netactive) {
                    rstr_and_comp();
                    setmbk(spokmb);
                    if (margc < 2) {
                         prfmlt(WHOFMT,netchar,netchar);
                    }
                    else if (strchr(margv[1],'@') != NULL) {
                         prfmlt(NONET);
                    }
                    else {
                         zonkhl(margv[1]);
                         findnetreg(margv[1]);
                         outprf(usrnum);
                    }
                    rstmbk();
                    pmlt(etlpmt);
                    outmlt(usrnum);
                    return(1);
               }
               else if (sameas(margv[0]+1,"scan") && !netactive) {
                    setmbk(spokmb);
                    prfmlt(NONET);
                    rstmbk();
                    pmlt(etlpmt);
                    outmlt(usrnum);
                    return(1);
               }
          }
     }
     if (!netactive || !(ret=spokein())) {
          if (usrptr->substt == -1) {
               usrptr->substt=0;
          }
          tt=usrptr->substt;
          ret=telecn();
          if (netactive) {
               if (usrptr->substt != TLKING
                 && onnet(usaptr->userid,sysno) >= 0L) { /* CHAT */
                    moduser(usaptr->userid,sysno,usrnum,-1L);
                    sendmoduser(usaptr->userid,sysno,usrnum,-1L,
                                usrptr->substt == CHTING ? 3 : 4);
                    if (usrptr->substt == CHTING) {
                         othusn=tlcoff(usrnum)->chatch;
                         moduser(uacoff(othusn)->userid,sysno,othusn,-1L);
                         sendmoduser(uacoff(othusn)->userid,sysno,othusn,-1L,3);
                    }
               }
               else if (usrptr->state == tlcstt && usrptr->substt == TLKING
                && tt != TLKING && tt != 0) {
                    moduser(usaptr->userid,sysno,usrnum,usrlist[usrnum].vc);
                    sendmoduser(usaptr->userid,sysno,usrnum,
                                usrlist[usrnum].vc,6);
               }
          }
          return(ret);
     }
     return(ret);
}

STATIC
void
spokethn(void)                     /* chatlink status handler              */
{
     int usrhold=usrnum;

     if (!chtlok) {
           tcsthn();
           return;
     }
     setmbk(tlcmb);
     if (status == OUTMT && usrlist[usrnum].netstate == 2
                         && usrptr->substt == TLKING) {
          spokescan(usrlist[usrnum].chain,usrlist[usrnum].entry,
                    usrlist[usrnum].sysn);
     }
     else if (status == OUTMT && usrlist[usrnum].netstate == 3
                              && usrptr->substt == TLKING) {
          outsysnames(usrlist[usrnum].chain);
     }
     else if (status == OUTMT && usrlist[usrnum].netstate == 4
                              && usrptr->substt == TLKING) {
          spokescan2(usrlist[usrnum].vrec);
     }
     else if (status == OUTMT && usrlist[usrnum].netstate == 5
                              && usrptr->substt == TLKING) {
          spokescan3(usrlist[usrnum].vrec,0);
     }
     else if (usrnum == spokechn && usrptr->state == spokestt) {
          if (status == OUTMT) {
               sendlistelements();
               return;
          }
          if (status == INBLK || status == CYCLE) {
               if (status == CYCLE) {
                    btuinj(usrnum,CYCLE);
               }
               handleincome();
               if (usrptr->substt == GOING) {
                    parsepacket();
               }
               else if (usrptr->substt == LINKED) {
                    linked();
               }
          }
          else if (status == 'M' && (usrptr->flags&ISX25)) {     /* SJN X25 */
               if (autolink && usrptr->substt == LINKED) {
                    spokescript();
               }
          }
          else {
               switch (status) {
               case 253:
               case 252:
               case 251:
               case CM25OK:                                      /* SJN X25 */
               case RCVX29:                                      /* SJN X25 */
               case CLOX29:                                      /* SJN X25 */
                    break;
               case CMN2OK:
                    if (spspeed == 1200) {
                         break;
                    }
               default:
                    setmbk(spokmb);
                    prfmsg(CONTERM,nctime(now()),ncdate(today()));
                    rstmbk();
                    spokerec(prfbuf);
                    clrmlt();
                    if (netactive) {
                         shutdown();
                    }
                    if (sff != NULL) {
                         fclose(sff);
                    }
                    linktime=0;
                    btuchi(usrnum,NULL);
                    if (!autolink) {
                         othusn=tlcoff(usrnum)->chatch;
                         btuchi(othusn,NULL);
                         if (user[othusn].state == spokestt
                           && user[othusn].substt == DIALGO) {
                              user[othusn].substt=SPOKEMEN;
                              uacoff(othusn)->scnbrk=deblen;
                              scurusr(othusn);
                              rstrxf();
                              scurusr(usrhold);
                              btuech(othusn,1);
                              terminate(othusn);
                         }
                    }
                    else if (scrdebug && user[debchan].state == spokestt
                                      && user[debchan].substt == DIALGO) {
                         user[debchan].substt=SPOKEMEN;
                         scurusr(debchan);
                         uacoff(debchan)->scnbrk=deblen;
                         rstrxf();
                         scurusr(usrhold);
                         terminate(debchan);
                    }
                    rstchn();
               }
               return;
          }
     }
     else {
          (*tcsthn)();
     }
}

STATIC void
clsspoke(void)                     /* close chatlink data file             */
{
     clsbtv(netrbb);
}

STATIC void
spokedel(char *uid)                /* delete entry from chatlink data file */
{
     setbtv(netrbb);
     if (acqbtv(NULL,uid,0)) {
          delbtv();
     }
}

void
netr1(void)                        /* get age for chatlink registry        */
{
     if (margc == 0) {
          strcpy(NETREGPTR->age,"   ");
     }
     else {
          strcpy(NETREGPTR->age,margv[0]);
     }
     prfmsg(usrptr->substt=NETR2);
     btumil(usrnum,sizeof(NETREGPTR->desc1)-1);
}

int
nettlc(void)                       /* send a chatlink message              */
{
     long vc;
     int vcc;

     if (!chtlok) {
           return(0);
     }
     if (!netactive) {
          return(0);
     }
     vc=usrlist[usrnum].vc;
     if (vc < 0L) {
          return(0);
     }
     if ((vcc=vccnt(vc)) > 1 && !netrpt) {
          publicnet(usaptr->userid,sysno,usrnum,vc,margv[0]);
     }
     if (chncnt() > 1 || vcc==1L) {
          return(0);
     }
     prfmlt(NMSENT);
     pmlt(etlpmt);
     outmlt(usrnum);
     return(1);
}
#endif
