/***************************************************************************
 *                                                                         *
 *   ANDROIDS.C                                                            *
 *                                                                         *
 *   Copyright (C) 1989-1993 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is a little robot action game, to demonstrate a few of the       *
 *   possibilities inherent in The Major BBS.                              *
 *                                                                         *
 *                                            - T. Stryker 2/7/88          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "brkthu.h"
#include "majorbbs.h"
#include "galdroid.h"

void EXPORT init__androids(void);
STATIC void idcata(int which);
STATIC void drotck(void);
STATIC void dromin(void);
STATIC int androi(void);
STATIC void g2play(void);
STATIC void prfttl(void);
STATIC void ntrgam(void);
STATIC int finsco(void);
STATIC void writ10(void);
STATIC int intop10(long pts,struct t10stf *ttpts);
STATIC void rmvguy(int guy);
STATIC int fndprw(int ptsrow);
STATIC int fndlet(char chr);
STATIC void drosta(void);
STATIC void go2slo(void);
STATIC void asetup(void);
STATIC void allsco(void);
STATIC void in1sco(struct droid *dp,char *userid);
STATIC void rf1sco(struct droid *droptr);
STATIC void outpys(int uncond);
STATIC void drwbrd(void);
STATIC char drochi(int chan,int ch);
STATIC void drorti(void);
STATIC void drohup(void);
STATIC void clsdro(void);

static
int drostt;                   /* Androids game playing state          */

struct module androidm={      /* module interface block               */
     "",                      /*    name used to refer to this module */
     NULL,                    /*    user logon supplemental routine   */
     androi,                  /*    input routine if selected         */
     drosta,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     drohup,                  /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     clsdro                   /*    finish-up (sys shutdown) routine  */
};

static
FILE *dromb;                  /* Androids message file block pointer  */

struct droid {                /* per-player dynamic info              */
     int row,col;             /*   coordinates of android             */
     long points;             /*   how many points so far             */
     long ptsdsp;             /*   points most recently displayed     */
     long secs;               /*   how long so far in seconds         */
     int ptsrow;              /*   display row-number of points       */
     char chr;                /*   display symbol                     */
     char scodun;             /*   flag - score done in last UPDIVL   */
     char needrc;             /*   flag - need to restore cursor      */
} *drolst,*droptr,            /* dynam alloc'd array of droids, & ptr */
  *dpafol[26];                /* ptrs to droid structs, by alpha char */

static
int unafol[26];               /* user numbers as function of letters  */

#define MAXDRO   6            /* max number of droids in game         */
#define UPDIVL   5            /* update interval for pts/hr, in secs  */
#define PLAYING -1            /* substate code when actually playing  */
#define BDTSIZ   7            /* baud rate table size                 */
#define CHCRIT 170            /* start ignoring keys if buffer > this */

static
int chbufd,                   /* characters buffered in slowest chan  */
    chperi;                   /* chars per 1/TPERSC interval (slowest)*/

static
struct {                      /* # of players allowed, by baud rate   */
     unsigned baud;           /*   (set from config parameters)       */
     int allowd;
} bdrtbl[BDTSIZ]={{300,0},{1200,0},{2400,0},{4800,0},{9600,0},{19200,0},
                  {(unsigned int)38400L,0}};

static
int rampts,                   /* number of points transferred by ram  */
    bonpts,                   /* number of points for super-bonus prz */
    ptsded;                   /* number of points deducted for crash  */

static
struct t10stf {               /* top-ten listings data                */
     char userid[UIDSIZ];     /*   User-ID                            */
     int date;                /*   date of game                       */
     long pts;                /*   number of points, or points per hr */
} ttpts[3],ttpph[3];          /* top-three pts & top-three pts/hour   */

static
char *mapp,*omapp,*oomapp;    /* copies of playfield                  */
static
unsigned hsize,vsize,bdsize;  /* horiz & vert playfield size, & bytes */

static
int playrs[MAXDRO],nplyrs=0;  /* usrnum's of actual players, & count  */

#define    map(row,col)   (*(mapp+(row)*hsize+(col)))

static
char firsdg[80]={                            /* 1st digit of num, 1 to 80  */
     '0','0','0','0','0','0','0','0','0','1',
     '1','1','1','1','1','1','1','1','1','2',
     '2','2','2','2','2','2','2','2','2','3',
     '3','3','3','3','3','3','3','3','3','4',
     '4','4','4','4','4','4','4','4','4','5',
     '5','5','5','5','5','5','5','5','5','6',
     '6','6','6','6','6','6','6','6','6','7',
     '7','7','7','7','7','7','7','7','7','8'
};
static
char secndg[80]={                            /* 2nd digit of num, 1 to 80  */
     '1','2','3','4','5','6','7','8','9','0',
     '1','2','3','4','5','6','7','8','9','0',
     '1','2','3','4','5','6','7','8','9','0',
     '1','2','3','4','5','6','7','8','9','0',
     '1','2','3','4','5','6','7','8','9','0',
     '1','2','3','4','5','6','7','8','9','0',
     '1','2','3','4','5','6','7','8','9','0',
     '1','2','3','4','5','6','7','8','9','0'
};

static
char wrtchr[]={"\33[yy;xxHz"};               /* template write-char seq    */

static
unsigned psernd;                             /* pseudo-random accumulator  */

static                   /* game rule-variable controls                    */
int showro,                   /* show run-over prizes in new locations     */
    showam,                   /* show auto-moved prizes in new locations   */
    amshos,                   /*   auto-moved prizes, show spaces not '?'  */
    showpy,                   /* show players                              */
    pyshoq,                   /*   players, show question marks not ' '    */
    vacpos,                   /* vacated position disp code (32 or 219)    */
    nquick,                   /* controls how violently prizes auto-move   */
    bonon,                    /* bonus on-time in 1/TPERSCths of a second  */
    bonoff,                   /* bonus off-time in 1/TPERSCths of a second */
    bonnum;                   /* number of bonuses strewn at on-time       */

static
char nquicka[]={5,0,2,5,10,0,10,1,2,5,0};
static
char bonona[]={50,60,70,10,30,50,70,30,70,90,90,30,30,50,50,50,50};
static
char bonoffa[]={30,20,10,10,120,70,50};
static
char bonnuma[]={1,1,1,1,2,1,1,1,1,1,1,1,1,1,2,3,1,1,1,1,1,1,1,1,1,3,1,1,1};

void EXPORT
init__androids(void)          /* Androids master system-init entry point   */
{
     int i,j;
     char *mapptr,*mp,c;
     FILE *fp;

     stzcpy(androidm.descrp,gmdnam("GALAND.MDF"),MNMSIZ);
     drostt=register_module(&androidm);
     dromb=opnmsg("galdroid.mcv");
     rampts=numopt(RAMPTS,0,1000);
     bonpts=numopt(BONPTS,0,1000);
     ptsded=numopt(PTSDED,0,1000);
     for (i=0 ; i < BDTSIZ ; i++) {
          bdrtbl[i].allowd=numopt(BDRTB1+i,0,MAXDRO);
     }
     drolst=(struct droid *)alczer(nterms*sizeof(struct droid));
     mapptr=rawmsg(BCKGND4);
     stpans(mapptr);
     for (mp=mapptr+1 ; *mp != '\r' ; mp++) {
          if (*mp == '\0') {
               idcata(1);
          }
     }
     hsize=(int)(mp-(mapptr+1));
     vsize=1;
     while (*++mp != '\0') {
          if (*mp == '\r') {
               vsize++;
          }
     }
     if (hsize < 5 || vsize < 5) {
          idcata(2);
     }
     mapp=alcmem(bdsize=hsize*vsize);
     omapp=alcmem(bdsize);
     oomapp=alcmem(bdsize);
     mp=mapptr+1;
     for (i=0 ; i < vsize ; i++) {
          for (j=0 ; j < hsize ; j++) {
               map(i,j)=((c=*mp++) == ' ' && i == vsize-1 ? 219 : c);
          }
          if (*mp++ != '\r') {
               idcata(3);
          }
     }
     if (*mp != '\0') {
          idcata(4);
     }
     nplyrs=0;
     if ((fp=fopen("androids.t10",FOPRB)) != NULL) {
          fread(ttpts,3,sizeof(struct t10stf),fp);
          fread(ttpph,3,sizeof(struct t10stf),fp);
          fclose(fp);
     }
     vsize--;
     rtihdlr(drorti);
     drotck();
     dromin();
}

STATIC
void
idcata(which)                 /* identify catastrophe in playfield         */
int which;
{
     catastro("INIDRO: error %d in playfield",which);
}

STATIC
void
drotck(void)                  /* once-per-second real-time checker         */
{
     int i;
     struct droid *dp;
     static int secnds=0;

     for (i=0 ; i < nplyrs ; i++) {
          drolst[playrs[i]].secs++;
     }
     if (++secnds == UPDIVL) {
          secnds=0;
          for (i=0 ; i < nplyrs ; i++) {
               dp=&drolst[playrs[i]];
               if (!dp->scodun) {
                    rf1sco(dp);
               }
               dp->scodun=0;
          }
     }
     rtkick(1,drotck);
}

STATIC
void
dromin(void)                  /* once-per-minute game rules changer        */
{
     static int minctr=2;

     showro=minctr%      5 ;
     showam=minctr%      3 ;
     amshos=(minctr+2)%  5 ;
     showpy=minctr%     13 ;
     pyshoq=minctr%      7 ;
     vacpos=(minctr%79 > 1 ? ' ' : 219);
     nquick=nquicka[minctr%sizeof(nquicka)];
     bonon=bonona[minctr%sizeof(bonona)];
     bonoff=bonoffa[minctr%sizeof(bonoffa)];
     bonnum=bonnuma[minctr%sizeof(bonnuma)];
     minctr++;
     rtkick(60,dromin);
}

STATIC
int
androi(void)                  /* Androids master <CR>-string entry point   */
{
     unsigned i,minbdr,ninstt,nallow,autott;

     setmbk(dromb);
     droptr=&drolst[usrnum];
     do {
          autott=0;
          bgncnc();
          switch (usrptr->substt) {
          case 0:
               cncchr();
               prfmsg(INTRO3,usaptr->scnwid/2-9);
               if (!(usaptr->ansifl&ANSON)) {
                    prfmsg(NOANSI);
                    return(0);
               }
               if (usaptr->scnwid < hsize+2) {
                    prfmsg(S2SMAL,hsize+2);
                    return(0);
               }
               if (usaptr->scnbrk < 24 && usaptr->scnbrk != CTNUOS) {
                    prfmsg(S2SHRT);
                    return(0);
               }
               for (i=ninstt=0,minbdr=(unsigned int)38400L ; i < nterms ; i++) {
                    if (user[i].state == drostt) {
                         ninstt++;
                         minbdr=min(minbdr,user[i].baud);
                    }
               }
               for (i=0 ; i < BDTSIZ ; i++) {
                    if (minbdr <= bdrtbl[i].baud) {
                         break;
                    }
               }
               if (ninstt > (nallow=bdrtbl[i].allowd)) {
                    if (nallow == 0) {
                         prfmsg(NOGOOD,minbdr);
                    }
                    else {
                         prfmsg(TOMANY,nallow,minbdr);
                    }
                    return(0);
               }
               chperi=minbdr/(11*TPERSC);
               prfmsg(INSTRS);
               prfmsg(usrptr->substt=P2PLAY2);
               break;
          case P2PLAY2:
               if (margc > 0) {
                    switch (cncchr()) {
                    case 'X':
                         return(0);
                    case 'D':
                         prfmsg(DETAILS3,rampts,ptsded,bonpts);
                         break;
                    case 'T':
                         prfttl();
                         break;
                    case 'P':
                         ntrgam();
                         break;
                    default:
                         cncall();
                         prfmsg(P2PLAY2);
                    }
               }
               else {
                    prfmsg(P2PLAY2);
               }
               break;
          case PLAYING:
               autott=finsco();
               rmvguy(usrnum);
          case BCKGND4:
               g2play();
               if (autott) {
                    prfttl();
               }
               else {
                    prfmsg(JIRPTD);
               }
               cncall();
               break;
          default:
               prf("");
               cncall();
               break;
          }
     } while (!endcnc());
     outprf(usrnum);
     return(1);
}

STATIC
void
g2play(void)                  /* go to the P2PLAY2 substate                */
{
     usrptr->flags&=~NOINJO;
     btutsw(usrnum,usaptr->scnwid);
     rstrxf();
     btuoes(usrnum,0);
     usrptr->substt=P2PLAY2;
}

STATIC
void
prfttl(void)                  /* output top-three listings                 */
{
     int i;
     char *fmtstg;
     char *ptsdat,*ptspts,*pphdat,*pphpts;

     prfmsg(TOPTHR1);
     fmtstg=rawmsg(TTFMT2);
     for (i=0 ; i < 3 ; i++) {
          if (ttpts[i].userid[0] == '\0') {
               ptsdat="";
               ptspts="";
          }
          else {
               ptsdat=spr("%s",ncedat(ttpts[i].date));
               ptspts=l2as(ttpts[i].pts);
          }
          prf(fmtstg,i+1,ttpts[i].userid,ptsdat,ptspts);
     }
     prfmsg(TOPTHR2);
     fmtstg=rawmsg(TTFMT2);
     for (i=0 ; i < 3 ; i++) {
          if (ttpph[i].userid[0] == '\0') {
               pphdat="";
               pphpts="";
          }
          else {
               pphdat=spr("%s",ncedat(ttpph[i].date));
               pphpts=l2as(ttpph[i].pts);
          }
          prf(fmtstg,i+1,ttpph[i].userid,pphdat,pphpts);
     }
     prfmsg(PTTPMT2);
}

STATIC
void
ntrgam(void)                  /* enter game if possible                    */
{
     char chr;
     int i,j;
     char *ptr,*optr;

     for (i=0 ; i < nterms ; i++) {
          if (user[i].state == drostt && user[i].substt == BCKGND4) {
               prfmsg(HOLDON2);
               usrptr->substt=P2PLAY2;
               return;
          }
     }
     drwbrd();
     allsco();
     prf("\33[%d;10H",vsize+2);
     prfmsg(ONEMOM);
     btuoes(usrnum,1);
     droptr->row=1;
     if (droptr->chr == '\0') {
          for (chr=usaptr->userid[0] ; fndlet(chr) ; chr=(chr+1-'A')%26+'A') {
          }
          droptr->chr=chr;
          dpafol[chr-'A']=droptr;
          unafol[chr-'A']=usrnum;
     }
     for (i=vsize+5 ; fndprw(i) ; i++) {
     }
     droptr->ptsrow=i;
     ptr=mapp+hsize;
     optr=omapp+hsize;
     for (i=1 ; i < vsize ; i++) {
          for (j=0 ; j < hsize ; j++) {
               *optr=(*ptr == '\4' || isdigit(*ptr) || isalpha(*ptr)
                      ? ' ' : *ptr);
               ptr++;
               optr++;
          }
     }
     usrptr->flags|=NOINJO;
     usrptr->substt=BCKGND4;
}

STATIC
int
finsco(void)                  /* output "final" score upon interruption    */
{
     int i,n;
     struct droid *dp;
     long pts,pph;
     char *prepts,*pstpts,*prepph,*pstpph;
     int autott=0;

     for (i=0 ; i < nplyrs ; i++) {
          dp=&drolst[playrs[i]];
          pts=dp->points;
          pph=(pts*3600L)/dp->secs;
          prepts=pstpts=prepph=pstpph="";
          if (playrs[i] == usrnum) {
               if ((n=intop10(pts,ttpts)) != 0) {
                    prepts=spr("\33[s\33[A\33[5;45;33m#%-2dEVER!\33[u\33[44m",n);
                    pstpts="\33[0;1;44;37m";
                    autott=1;
               }
               if ((n=intop10(pph,ttpph)) != 0) {
                    prepph=spr("\33[s\33[A\33[5;45;33m#%-2dEVER!\33[u\33[44m",n);
                    pstpph="\33[0;1;44;37m";
                    autott=1;
               }
          }
          prf("\33[%d;41H%s %7s%s%s %7s%s",dp->ptsrow,
               prepts,l2as(pts),pstpts,prepph,l2as(pph),pstpph);
     }
     outprf(usrnum);
     if (autott) {
          writ10();
     }
     return(autott);
}

STATIC
void
writ10(void)                  /* write top-three data to disk              */
{
     FILE *fp;

     if ((fp=fopen("androids.t10",FOPWB)) == NULL) {
          catastro("WRIT10: CAN'T OPEN ANDROIDS.T10");
     }
     fwrite(ttpts,3,sizeof(struct t10stf),fp);
     fwrite(ttpph,3,sizeof(struct t10stf),fp);
     fclose(fp);
}

STATIC
int
intop10(pts,ttpts)            /* find out if score is in top-three (where) */
long pts;
struct t10stf *ttpts;
{
     int j,k;
     struct t10stf *ttptsk;

     for (j=0 ; j < 3 ; j++) {
          if (pts > ttpts->pts) {
               for (k=j,ttptsk=ttpts ; k < 2 ; k++,ttptsk++) {
                    if (sameas(ttptsk->userid,usaptr->userid)) {
                         break;
                    }
               }
               if (j < k) {
                    movmem(ttpts,ttpts+1,(k-j)*sizeof(struct t10stf));
               }
               strcpy(ttpts->userid,usaptr->userid);
               ttpts->date=today();
               ttpts->pts=pts;
               return(j+1);
          }
          else if (sameas(ttpts->userid,usaptr->userid)) {
               break;
          }
          ttpts++;
     }
     return(0);
}

STATIC
void
rmvguy(guy)                   /* remove a guy from the game                */
int guy;
{
     int i;

     for (i=0 ; i < nplyrs ; i++) {
          if (playrs[i] == guy) {
               dsairp();
               drochi(guy,' ');
               btuchi(guy,NULL);
               echonu(guy);
               playrs[i]=playrs[--nplyrs];
               enairp();
               prf("\33[%d;4H%33s\33[u",drolst[guy].ptsrow,"");
               for (i=0 ; i < nplyrs ; i++) {
                    outprf(playrs[i]);
               }
               clrprf();
               return;
          }
     }
     catastro("ANDROIDS: RMVGUY ERROR");
}

STATIC
int
fndprw(ptsrow)                /* find if a given points-row is taken yet   */
int ptsrow;
{
     int i;

     for (i=0 ; i < nplyrs ; i++) {
          if (drolst[playrs[i]].ptsrow == ptsrow) {
               return(1);
          }
     }
     return(0);
}

STATIC
int
fndlet(chr)                   /* find if a given android letter is taken   */
char chr;
{
     int i;

     for (i=0 ; i < nterms ; i++) {
          if (drolst[i].chr == chr) {
               return(1);
          }
     }
     return(0);
}

STATIC
void
drosta(void)                  /* Androids master status-input entry point  */
{
     setmbk(dromb);
     droptr=&drolst[usrnum];
     switch (usrptr->substt) {
     case BCKGND4:
          if (status == OUTMT) {
               asetup();
          }
          else if (status == 252 || status == 253) {
               go2slo();
          }
          else {
               dfsthn();
          }
          break;
     case TOOSLO:
          if (status == OUTMT) {
               btuoes(usrnum,0);
               btulok(usrnum,0);
               g2play();
          }
          else {
               dfsthn();
          }
          break;
     case PLAYING:
          if (status == CYCLE) {
               if (droptr->points != droptr->ptsdsp) {
                    rf1sco(droptr);
                    droptr->scodun=1;
               }
               else if (btuoba(usrnum) == OUTSIZ-1 && droptr->needrc) {
                    droptr->needrc=0;
                    btuxmt(usrnum,"\33[u");
               }
               btuinj(usrnum,CYCLE);
          }
          else if (status == 252) {
               rmvguy(usrnum);
               go2slo();
          }
          else if (status == 253) {
               btuclo(usrnum);
          }
          else {
               dfsthn();
          }
          break;
     default:
          dfsthn();
     }
}

STATIC
void
go2slo(void)                  /* shut a player down due to overflow        */
{
     btuclo(usrnum);
     btulok(usrnum,1);
     btuoes(usrnum,1);
     btucli(usrnum);
     prfmsg(usrptr->substt=TOOSLO);
     outprf(usrnum);
}

STATIC
void
asetup(void)                  /* attempt to set up a new android, or cycle */
{                             /* (the tricky part is synchronizing this    */
                              /* user's CRT with everybody else's that is  */
     int i,j;                 /* already in the game, and pounding away on */
     char *optr,*ooptr;       /* their keyboards while he tries to get in) */
     struct droid *dp;

     dsairp();
     if (memcmp(mapp,omapp,bdsize) == 0) {
          playrs[nplyrs++]=usrnum;
          btuchi(usrnum,drochi);
          btuech(usrnum,2);
          for (i=1 ; i < hsize-2 ; i++) {
               if (mapp[hsize+i] == ' ') {
                    break;
               }
          }
          droptr->col=i-1;
          drochi(usrnum,'L');
          enairp();
          in1sco(droptr,usaptr->userid);
          outpys(1);
          droptr->secs++;
          btuoes(usrnum,0);
          for (i=0 ; i < nplyrs ; i++) {
               if (playrs[i] != usrnum) {
                    dp=&drolst[playrs[i]];
                    prf("\33[%d;42H%7s %7s",dp->ptsrow,
                       l2as(dp->points),l2as((dp->points*3600L)/dp->secs));
               }
          }
          prf("\33[0m\33[%d;1H\33[K\33[u\33[1;44;37m",vsize+2);
          usrptr->substt=PLAYING;
          btuinj(usrnum,CYCLE);
     }
     else {
          enairp();
          movmem(omapp,oomapp,bdsize);
          dsairp();
          movmem(mapp,omapp,bdsize);
          enairp();
          optr=omapp+hsize;
          ooptr=oomapp+hsize;
          for (i=2 ; i < vsize+1 ; i++) {
               for (j=0 ; j < hsize ; j++) {
                    if (*optr != *ooptr) {
                         if (*optr == '\4') {
                              prf("\33[%d;%dH\33[5;35m\4\33[0;1;37;44m",i,j+2);
                         }
                         else {
                              prf("\33[%d;%dH%c",i,j+2,*optr);
                         }
                    }
                    optr++;
                    ooptr++;
               }
          }
     }
     outprf(usrnum);
}

STATIC
void
allsco(void)                  /* initialize all scores for new player      */
{
     int i;

     for (i=0 ; i < nplyrs ; i++) {
          in1sco(&drolst[playrs[i]],uacoff(playrs[i])->userid);
     }
     prf("\33[u");
}

STATIC
void
in1sco(dp,userid)             /* initialize one score utility              */
struct droid *dp;
char *userid;
{
     prf("\33[%d;4H   %c    %-29s %7s %7s",
         dp->ptsrow,dp->chr,userid,l2as(dp->points),
        (dp->secs ? spr("%ld",(dp->points*3600L)/dp->secs) : ""));
}

STATIC
void
rf1sco(droptr)                /* refresh one score utility                 */
struct droid *droptr;
{
     prf("\33[%d;42H%7s %7s",droptr->ptsrow,l2as(droptr->points),
        l2as((droptr->points*3600L)/droptr->secs));
     outpys(0);
     droptr->ptsdsp=droptr->points;
}

STATIC
void
outpys(uncond)                /* output prfbuf contents to all players     */
int uncond;
{
     int i;

     for (i=0 ; i < nplyrs ; i++) {
          if (uncond || btuoba(playrs[i]) > 1024) {
               drolst[playrs[i]].needrc=1;
               outprf(playrs[i]);
          }
     }
}

STATIC
void
drwbrd(void)                  /* draw board (playfield) on user's CRT      */
{
     char mchar;
     int i,j,ls219r,ls219c;
     int color=0;

     btutsw(usrnum,0);
     prf("\33[0m\33[2J\33[H\33[1;36;44m");
     for (i=0 ; i < vsize+1 ; i++) {
          prf(" ");
          for (j=0 ; j < hsize ; j++) {
               mchar=map(i,j);
               if (mchar == ' ' || isdigit(mchar) || mchar == '\4'
                 || (isalpha(mchar) && i < vsize)) {
                    mchar=' ';
               }
               else if (mchar == 176) {
                    if (color != 1) {
                         prf("\33[36m");
                         color=1;
                    }
               }
               else if (mchar == 177) {
                    if (color != 2) {
                         prf("\33[32m");
                         color=2;
                    }
               }
               else if (mchar == 178) {
                    if (color != 3) {
                         prf("\33[31m");
                         color=3;
                    }
               }
               else if (mchar == 219) {
                    ls219r=i+1;
                    ls219c=j+2;
                    if (color != 4) {
                         prf(i < vsize ? "\33[33m" : "\33[0m");
                         color=4;
                    }
               }
               else if (mchar < 128) {
                    if (usaptr->systyp == 1 && color != 5) {
                         color=5;
                         prf("\33[7m");
                    }
               }
               else if (color != 6) {
                    prf("\33[1;33;44m");
                    color=6;
               }
               if (usaptr->systyp != 1) {
                    if (mchar == 219 && i == vsize) {
                         mchar='-';
                    }
                    else if (mchar > 127) {
                         mchar='@';
                    }
               }
               prf("%c",mchar);
          }
          prf(" ");
          if (usaptr->scnwid != hsize+2) {
               prf("\r");
          }
     }
     prfmsg(PYLIST2);
     prf("\33[%d;%dH\33[s\33[44;37m",ls219r,ls219c);
}

STATIC
char
drochi(chan,ch)               /* INTERRUPT-LEVEL input-keystroke handler   */
int chan;
int ch;
{
     static int updn[26]={
          1,-1,0,0,1,0,0,0,1,0,0,0,-1,-1,1,1,1,1,0,1,1,-1,1,-1,1,-1
     };
     static int lfrt[26]={
          0,0,1,-1,0,1,-1,-1,0,-1,1,1,0,0,0,0,0,0,-1,0,0,0,0,0,0,0
     };
     static int mvcode[26]={
          'A','B','C','D','A','C','D','D','A','D','C','C','B',
          'B','A','A','A','A','D','A','A','B','A','B','A','B'
     };
     struct droid *dp,*odp;
     char locdat;
     unsigned oldloc,newloc,przloc,ptexch;
     unsigned oldrow,oldcol,newrow,newcol,przrow,przcol,i;
     char outstg[40],*osptr;
     char c;

     dp=&drolst[chan];
     c=((char)ch)&eurmsk;
     if (isalpha(c) && chbufd < CHCRIT) {
          c=(c&~('a'-'A'))-'A';
          oldrow=dp->row;
          oldcol=dp->col;
          newrow=oldrow-updn[c];
          newcol=oldcol+lfrt[c];
          osptr=outstg;
          if ((locdat=mapp[newloc=newrow*hsize+newcol]) != ' ') {
               if (isdigit(locdat)) {
                    dp->points+=locdat-'0';
                    do {
                         przrow=(newrow+(psernd+=12163))%vsize;
                         przcol=(newcol+(psernd+= 7457))%hsize;
                    } while (mapp[przloc=przrow*hsize+przcol] > ' ');
                    mapp[przloc]=locdat;
                    *osptr++='\33';
                    *osptr++='[';
                    if (przrow >= 9) {
                         *osptr++=firsdg[przrow];
                    }
                    *osptr++=secndg[przrow];
                    *osptr++=';';
                    if (++przcol >= 9) {
                         *osptr++=firsdg[przcol];
                    }
                    *osptr++=secndg[przcol];
                    *osptr++='H';
                    *osptr++=(showro ? locdat : ' ');
               }
               else if (isalpha(locdat) && newrow < vsize) {
                    odp=dpafol[locdat-'A'];
                    ptexch=(unsigned int)min(odp->points,rampts);
                    dp->points+=ptexch;
                    odp->points-=ptexch;
                    chiout(unafol[locdat-'A'],'\7');
                    chbufd++;
                    przrow=newrow-updn[c];
                    przcol=newcol+lfrt[c];
                    while (mapp[przloc=przrow*hsize+przcol] > ' ') {
                         przrow=(przrow+(psernd+=12163))%vsize;
                         przcol=(przcol+(psernd+= 7457))%hsize;
                    }
                    odp->row=przrow;
                    odp->col=przcol;
                    mapp[przloc]=locdat;
                    *osptr++='\33';
                    *osptr++='[';
                    if (przrow >= 9) {
                         *osptr++=firsdg[przrow];
                    }
                    *osptr++=secndg[przrow];
                    *osptr++=';';
                    if (++przcol >= 9) {
                         *osptr++=firsdg[przcol];
                    }
                    *osptr++=secndg[przcol];
                    *osptr++='H';
                    *osptr++=locdat;
               }
               else if (locdat == '\4') {
                    dp->points+=bonpts;
                    chiout(chan,'\7');
                    chbufd++;
               }
               else {
                    if ((dp->points-=ptsded) < 0) {
                         dp->points=0;
                    }
                    chiout(chan,'\7');
                    chbufd++;
                    return(0);
               }
          }
          mapp[newloc]=dp->chr;
          dp->row=newrow;
          dp->col=newcol;
          *osptr++='\33';
          *osptr++='[';
          if (oldrow >= 9) {
               *osptr++=firsdg[oldrow];
          }
          *osptr++=secndg[oldrow];
          *osptr++=';';
          if (++oldcol >= 9) {
               *osptr++=firsdg[oldcol];
          }
          *osptr++=secndg[oldcol];
          *osptr++='H';
          if (mapp[oldloc=oldrow*hsize+oldcol-1] == dp->chr) {
               mapp[oldloc]=' ';
               *osptr++=vacpos;
               if (vacpos == ' ') {
                    *osptr++='\b';
               }
               else {
                    *osptr++='\33';
                    *osptr++='[';
                    *osptr++='D';
               }
          }
          *osptr++='\33';
          *osptr++='[';
          *osptr++=mvcode[c];
          *osptr++=(showpy ? dp->chr : (pyshoq ? '?' : vacpos));
          *osptr='\0';
          chbufd+=(int)(osptr-outstg);
          for (i=0 ; i < nplyrs ; i++) {
               drolst[playrs[i]].needrc=1;
               chious(playrs[i],outstg);
          }
     }
     else if (c == ' ') {
          oldrow=dp->row;
          oldcol=dp->col;
          if (mapp[oldloc=oldrow*hsize+oldcol] == dp->chr) {
               mapp[oldloc]=' ';
               wrtchr[2]=firsdg[oldrow];
               wrtchr[3]=secndg[oldrow];
               wrtchr[5]=firsdg[++oldcol];
               wrtchr[6]=secndg[oldcol];
               wrtchr[8]=vacpos;
               chbufd+=(sizeof(wrtchr)-1);
               for (i=0 ; i < nplyrs ; i++) {
                    drolst[playrs[i]].needrc=1;
                    chious(playrs[i],wrtchr);
               }
          }
     }
     else if (c == '\r') {
          chiinj(chan,CRSTG);
     }
     return(0);
}

STATIC
void
drorti(void)                  /* Androids real-time INTERRUPT handler      */
{
     static char przchr=' ';
     static unsigned opzrow,opzcol;
     unsigned przrow,przcol,przloc,i;
     static int spcctr=1;
     static int numctr;
     static int spcrow,spccol,spcloc;
     static char wrtspc[]={"\33[yy;xxH\33[5;35m\4\33[0;1;37;44m"};

     if ((chbufd-=chperi) <= 0) {
          chbufd=0;
          if (nplyrs != 0) {
               if (przchr != ' ') {
                    do {
                         przrow=(opzrow+(psernd+=12163))%vsize;
                         przcol=(opzcol+(psernd+= 7457))%hsize;
                    } while (mapp[przloc=przrow*hsize+przcol] > ' ');
                    mapp[przloc]=przchr;
                    wrtchr[2]=firsdg[przrow];
                    wrtchr[3]=secndg[przrow];
                    wrtchr[5]=firsdg[++przcol];
                    wrtchr[6]=secndg[przcol];
                    wrtchr[8]=(showam ? przchr : (amshos ? ' ' : '?'));
                    chbufd=sizeof(wrtchr)-1;
                    for (i=0 ; i < nplyrs ; i++) {
                         drolst[playrs[i]].needrc=1;
                         chious(playrs[i],wrtchr);
                    }
                    przchr=' ';
               }
               else {
                    przrow=(opzrow+(psernd+=12163))%vsize;
                    przcol=(opzcol+(psernd+= 7457))%(hsize-nquick);
                    przloc=przrow*hsize+przcol;
                    for (i=0 ; i < nquick ; i++,przloc++) {
                         if (isdigit(mapp[przloc])) {
                              przcol+=i;
                              przchr=mapp[przloc];
                              mapp[przloc]=' ';
                              opzrow=przrow;
                              opzcol=przcol;
                              wrtchr[2]=firsdg[przrow];
                              wrtchr[3]=secndg[przrow];
                              wrtchr[5]=firsdg[++przcol];
                              wrtchr[6]=secndg[przcol];
                              wrtchr[8]=vacpos;
                              chbufd=sizeof(wrtchr)-1;
                              for (i=0 ; i < nplyrs ; i++) {
                                   drolst[playrs[i]].needrc=1;
                                   chious(playrs[i],wrtchr);
                              }
                              break;
                         }
                    }
               }
          }
     }
     if (nplyrs != 0) {
          if (spcctr < 0) {
               if (spcctr == -1) {
                    if (chbufd < CHCRIT) {
                         if (mapp[spcloc] == '\4') {
                              mapp[spcloc]=' ';
                              wrtchr[2]=firsdg[spcrow];
                              wrtchr[3]=secndg[spcrow];
                              wrtchr[5]=firsdg[spccol];
                              wrtchr[6]=secndg[spccol];
                              wrtchr[8]=vacpos;
                              chbufd+=sizeof(wrtchr)-1;
                              for (i=0 ; i < nplyrs ; i++) {
                                   drolst[playrs[i]].needrc=1;
                                   chious(playrs[i],wrtchr);
                              }
                         }
                         spcctr=bonoff;
                    }
               }
               else {
                    spcctr++;
               }
          }
          else if (spcctr == 1) {
               if (chbufd < CHCRIT-sizeof(wrtspc)) {
                    do {
                         spcrow=(spcrow+(psernd+=12163))%vsize;
                         spccol=(spccol+(psernd+= 7457))%hsize;
                    } while (mapp[spcloc=spcrow*hsize+spccol] > ' ');
                    mapp[spcloc]='\4';
                    wrtspc[2]=firsdg[spcrow];
                    wrtspc[3]=secndg[spcrow];
                    wrtspc[5]=firsdg[++spccol];
                    wrtspc[6]=secndg[spccol];
                    chbufd+=(sizeof(wrtspc)-1);
                    for (i=0 ; i < nplyrs ; i++) {
                         drolst[playrs[i]].needrc=1;
                         chious(playrs[i],wrtspc);
                    }
                    if (++numctr >= bonnum) {
                         numctr=0;
                         spcctr=-bonon;
                    }
               }
          }
          else {
               spcctr--;
          }
     }
}

STATIC
void
drohup(void)                  /* Androids master lost-carrier entry point  */
{
     droptr=&drolst[usrnum];
     if (usrptr->state == drostt && usrptr->substt == PLAYING) {
          rmvguy(usrnum);
     }
     setmem(droptr,sizeof(struct droid),0);
}

STATIC
void
clsdro()                      /* Androids system-shutdown entry point      */
{
     clsmsg(dromb);
}

