Program QWKFixSend;

{Version 1.0 - 3 February 1995}

{Copyright at Common Law, West El Paso Information Network, 1995}
{All Rights Reserved, UCC 1-207}

{Send comments and bug reports to wepin@sgir.com}

{Ensure that QWKFxS.exe and QWKFxS.cfg are BOTH in the default directory
 before running QWKFxS.exe.}

Uses Dos, CRT;

Const

  CurrentDrive = 0;

Var

  PathName,
  InFile,
  OutFile      :Text;
  AnyKey       :Char;
  Path,
  InputLine,
  Address,
  CurrentPath  :String;
  LongAddress,
  Found,
  Found2nd     :Boolean;
  DIRInfo      :SearchRec;

Function Uppercase(S:String):String;

  Var

    I   : Integer;
    New : String;

  Begin

    New := '';
    For I := 1 to Length(S) Do
      New := New + Upcase(S[I]);
    Uppercase := New

  End;

Procedure CheckForLongAdr(var F:Text; var LongAdr:Boolean; var Adr:String);

  begin
    Reset(F);
    Adr := 'x';
    LongAdr := False;
    While ((not EOF(F)) and (Adr <> '')) Do
      Readln(F, Adr);
    While ((not EOF(F)) and (Adr = '')) Do
      Readln(F, Adr);
    If Uppercase(Copy(Adr, 1, 3)) = 'TO:' Then
      LongAdr := True;
    If Copy(Adr,4,1) <> ' ' Then
      Adr := Concat('To: ', Copy(Adr,4,Length(Adr)-3))
    Else
      Adr := Concat('To: ', Copy(Adr,5,Length(Adr)-4));
    Close(F)
  end;

Procedure MakeAdrValid(var InputLine:String);

  var
    Colon,
    AdrOk         : Boolean;
    Checkstring   : String;
    I,
    ColonPosition : Integer;

  Function ValidAdr(InputLine:String):Boolean;

    var
      I             : Integer;
      BadAdr,
      Found1st,
      FoundAtSign,
      Found2nd,
      FoundPeriod,
      Found3rd      : Boolean;
      TestChar      : String[1];
      CharTest      : Char;

    begin
      ValidAdr := False;
      BadAdr := False;
      Found1st := False;
      FoundAtSign := False;
      Found2nd := False;
      FoundPeriod := False;
      Found3rd := False;
      I := 5;
      While (I <= Length(InputLine)) AND
            (Not BadAdr) AND
            (Not FoundAtSign) Do
        begin
          If (Copy(InputLine,I,1) = ' ') OR
             (Copy(InputLine,I,1) = ',') Then
            BadAdr := True;
            TestChar := Copy(InputLine,I,1);
          If TestChar[1] IN ['A'..'Z','a'..'z','0'..'9'] Then
            Found1st := True;
          If Copy(InputLine,I,1) = '@' Then
            FoundAtSign := True;
          I := I + 1
        end;
      While (I <= Length(InputLine)) AND
            (Not BadAdr) AND
            (Not FoundPeriod) Do
        begin
          If (Copy(InputLine,I,1) = ' ') OR
             (Copy(InputLine,I,1) = ',') Then
            BadAdr := True;
            TestChar := Copy(InputLine,I,1);
          If TestChar[1] IN ['A'..'Z','a'..'z','0'..'9'] Then
            Found2nd := True;
          If Copy(InputLine,I,1) = '.' Then
            FoundPeriod := True;
          I := I + 1
        end;
      While (I <= Length(InputLine)) AND
            (Not BadAdr) Do
        begin
          If (Copy(InputLine,I,1) = ' ') OR
             (Copy(InputLine,I,1) = ',') Then
            BadAdr := True;
            TestChar := Copy(InputLine,I,1);
          If TestChar[1] IN ['A'..'Z','a'..'z','0'..'9'] Then
            Found3rd := True;
          I := I + 1
        end;
      If (Found1st) And
         (FoundAtSign) And
         (Found2nd) And
         (FoundPeriod) And
         (Found3rd) And
         (Not BadAdr) Then
           ValidAdr := True
    end;

  begin
    While (Copy(InputLine,Length(InputLine),1) = ' ') Do
      InputLine := Copy(InputLine,1,Length(InputLine)-1);
    AdrOK := False;
    Colon := False;
    ColonPosition := 0;
    I := 5;
    While (I < Length(InputLine)) And (Not Colon) Do
      begin
        If Copy(InputLine,I,1) = ':' Then
          begin
            ColonPosition := I;
            Colon := True
          End;
        I := I + 1
      end;
    If Colon Then
      begin
        CheckString := UpperCase(Copy(InputLine,5,ColonPosition-4));
        If (CheckString = 'IN:') Or
           (CheckString = 'INT:') Or
           (CheckString = 'INTERNET:') Or
           (CheckString = 'INTRNET:') Or
           (CheckString = 'INTENET:') Or
           (CheckString = 'INTRENET:') Or
           (CheckString = 'INTERNT:') Then
             AdrOk := True;
        If AdrOk Then
          If Copy(InputLine,ColonPosition+1,1) = ' ' Then
            InputLine := Concat(Copy(InputLine,1,4),
                                'IN:',
                                Copy(InputLine,
                                     ColonPosition+1,
                                     Length(InputLine)-ColonPosition))
          Else
            InputLine := Concat(Copy(InputLine,1,4),
                                'IN: ',
                                Copy(InputLine,
                                     ColonPosition+1,
                                     Length(InputLine)-ColonPosition))
      End
    Else
      If ValidAdr(InputLine) Then
        InputLine := Concat(Copy(InputLine,1,4),
                            'IN: ',
                            Copy(InputLine,5,Length(InputLine)-4))
  End;

begin
  Assign(PathName, 'QWKFxS.cfg');
  {$I-}
  Reset(PathName);
  {$I+}
  If IOResult = 0 Then
    begin
      Readln(PathName, Path);
      Close(PathName);
      If copy(Path, Length(Path), 1) = '\' Then
        Path := copy(Path, 1, Length(Path)-1);
      If ((Length(Path)=2) AND (copy(Path,2,1)=':')) Then
        Path := Concat(Path,'\');
      GetDir(CurrentDrive, CurrentPath);
      {$I-}
      ChDir(Path);
      {$I+}
      If IOResult = 0 Then
        begin
          FindFirst('*', Archive, DIRInfo);
          While DOSError=0 Do
            begin
              Assign(InFile, DIRInfo.Name);
              CheckForLongAdr(InFile, LongAddress, Address);
              Assign(InFile, DIRInfo.Name);
              Rename(InFile, concat(DIRInfo.Name, '.tmp'));
              Assign(OutFile, DIRInfo.Name);
              Reset(InFile);
              Rewrite(OutFile);
              Found := False;
              Found2nd := False;
              While ((not EOF(InFile)) and (not Found)) Do
                begin
                  Readln(InFile, InputLine);
                  If uppercase(copy(InputLine, 1, 4)) = 'TO: ' then
                    begin
                      If LongAddress Then
                        InputLine := Address;
                      Found := True;
                      MakeAdrValid(InputLine)
                    end;
                  Writeln(OutFile, InputLine);
                end;
              While ((not EOF(InFile)) and (not Found2nd)) Do
                begin
                  Readln(InFile, InputLine);
                  If uppercase(copy(InputLine, 1, 3)) = 'TO:' then
                    begin
                      If LongAddress Then
                        Readln(Infile,Inputline); {Del Adr line in msg}
                      Found2nd := True;
                    end;
                  Writeln(OutFile, InputLine);
                end;
              While not EOF(InFile) Do
                begin
                  Readln(InFile, InputLine);
                  Writeln(OutFile, InputLine)
                end;
              Close(InFile);
              Close(OutFile);
              Erase(InFile);
              FindNext(DIRInfo);
            end;
          ChDir(CurrentPath)
        end
      else
        begin
          writeln;
          writeln('Either the specified drive is nonexistant, the specified');
          writeln('drive is not ready, or the specified path is not valid.');
          writeln('Check the path specified in QWKFxS.cfg to ensure that');
          writeln('a valid drive and path is specified.');
          writeln;
          write('Press any key to continue: ');
          AnyKey := ReadKey;
          ChDir(CurrentPath)
        end
    end
  else
    begin
      writeln;
      writeln('QWKFxS.cfg not found in the expected location.  Please');
      writeln('ensure that QWKFxS.cfg is in the same directory as');
      writeln('QWKFxS.exe and that you have changed to the drive and path');
      writeln('where they are located before executing QWKFxS.exe.');
      writeln;
      write('Press any key to continue: ');
      AnyKey := readkey;
    end
end.

