/*
*********************************************************************
* hwmcomp.h
* contains local compiler directions, substitutions for compiler
* differences
*
* Frank LaPiana, HighWater Mark BBS, 1992, 1993
*
* Changes/renames etc for MBBS v6.1b
* Frank LaPiana, HighWater Mark, March 1993
*********************************************************************
*/

/* check if this file has already been included */
#ifndef hwmcomp_h
	#define hwmcomp_h 		/* flag for inclusion of this file */

	/*
	*****************************************************************
	* standard constants that can be used in all compilers and
	* programs without problems.
	*****************************************************************
	*/
	#ifndef NULL
		#include "_null.h"		/* Borland definitions for NULL */
	#endif
	#ifndef NULLPTR
		#define NULLPTR ((void *) NULL)
	#endif
	#ifndef NULLCHAR
		#define NULLCHAR '\0'
	#endif
	#ifndef NULLFUNC
		#define NULLFUNC ((void *)0)
	#endif

	#ifndef TRUE
		#define	TRUE 1
	#endif
	#ifndef FALSE
		#define FALSE 0
	#endif

	/*
	*****************************************************************
	* compiler type for this project.
	*****************************************************************
	*/
	#define BORLAND
	#define TURBO_C_PLUS
	#define PHARLAP

	/*
	*****************************************************************
	* handy & usefull declarations for readability and portability
	*****************************************************************
	*/
	/* these are logical operators for logical tests, ie, seperators for */
	/* multiple conditionals. */
	#define AND &&
	#define OR ||

	/* these are logical operators for BIT operations */
	#define BITAND &
	#define BITOR |

	/* maximum path length for a complete file name. this constant */
	/* varies from compiler to compiler, so we make it all the same. */
	/* we will use the constant MAXPATHLEN. we also need the name */
	/* of the include file to which we must resolve, since this also */
	/* varies from compiler to compiler. */
	#ifndef MAXPATHLEN
		#ifdef TURBO_C_PLUS
			#define MAXPATHLEN MAXPATH
			#define MAXPATHINCLUDE <dir.h>
		#elif BORLAND
			#define MAXPATHLEN MAXPATH
			#define MAXPATHINCLUDE <dir.h>
		#else
			#error unknown compiler type - need for MAXPATHLEN
		#endif
	#endif

	/* different compilers use different names for the alloc/malloc */
	/* include file. Let's set it up here. */
	#ifndef ALLOC_INCLUDE
		#ifdef TURBO_C_PLUS
			#define ALLOC_INCLUDE <alloc.h>
		#elif BORLAND
			#define ALLOC_INCLUDE <alloc.h>
		#else
			#error unknown compiler type - need for ALLOC_INCLUDE name
		#endif
	#endif

	/* different compilers use different names for the variable */
	/* arguement include file. Let's set it up here. */
	#ifndef VARARGS_INCLUDE
		#ifdef TURBO_C_PLUS
			#define VARARGS_INCLUDE <stdarg.h>
		#elif BORLAND
			#define VARARGS_INCLUDE <stdarg.h>
		#else
			#error unknown compiler type - need for VARARGS_INCLUDE name
		#endif
	#endif

	/* this is a Turbo C/Microsoft function to convert a string to lower case */
	/* if it's defined in the current library, then uncomment the */
	/* next line; otherwise we define it as a macro using "tolower" */
	#ifdef TURBO_C_PLUS
		#define strlwr_define
		#ifdef strlwr_define
			char *strlwr (char *String);
		#endif
	#endif
	#ifdef BORLAND
		#define strlwr_define
		#ifdef strlwr_define
			char *strlwr (char *String);
		#endif
	#endif
	#ifdef MSC_600
		#define strlwr_define
	#endif
	#ifdef MSC_510
		#define strlwr_define
	#endif
	#ifndef strlwr_define
		#define strlwr(a) {int iTemp1; for(iTemp1=0;a[iTemp1]!=NULLCHAR;iTemp1++){a[iTemp1]=tolower(a[iTemp1]);} }
		#define strlwr_define
	#endif
	#ifdef TURBO_C_PLUS
		#define strupr_define
		#ifdef strupr_define
			char *strupr (char *String);
		#endif
	#endif
	#ifdef BORLAND
		#define strupr_define
		#ifdef strupr_define
			char *strupr (char *String);
		#endif
	#endif
	#ifdef MSC_600
		#define strupr_define
	#endif
	#ifdef MSC_510
		#define strupr_define
	#endif
	#ifndef strupr_define
		#define strupr(a) {int iTemp1; for(iTemp1=0;a[iTemp1]!=NULLCHAR;iTemp1++){a[iTemp1]=toupper(a[iTemp1]);} }
		#define strupr_define
	#endif


	/*
	*****************************************************************
	* special PROJECT definitions
	* MajorBBS 6.0x
	*****************************************************************
	*/
	/* compiler directives */
	#define TSC_C			/* compiler type */
//	#define VROOMM			/* use Borland overlays */
//	#define ECLIPSE
	#define PHAR_LAP		/* extended memory */

	/*
	*****************************************************************
	* compilation options
	*****************************************************************
	*/
	// suppress the formfeed used before the display of all messsages,
	// if the user chooses the "read all" option.
//	#define HWM_MSG_FF_SUPPRESS
//	#undef  HWM_MSG_FF_SUPPRESS

	// allows more then 8 channel groups... but statistics will
	// be wrong.
	// Changes required in the following files:
	//		majorbbs.c (look for NGROUP, NGADD, HWM_CHAN_GROUP)
	//		BBSMAJOR.MSG (look for GROUPA)
	//		majorbbs.h (look for hwmcomp.h)
	#define HWM_CHAN_GROUP
	#undef  HWM_CHAN_GROUP
#ifdef HWM_CHAN_GROUP
	#define NGADD 8
#else
	#define NGADD 0
#endif

	// uses a special character "+" to denote "DO NOT EXIT MODULE"
	// in the menu system, when going to a module, and "exit on
	// concatenated entry" is turned on.
	//		files: menuing.c
	#define HWM_NO_EXIT_MENU
	#undef  HWM_NO_EXIT_MENU

	// allow the use of text variables in menu pages; also allow
	// for "+" as per above.
    // files MENUING.C
	#define HWM_MENU_VAR
//	#undef  HWM_MENU_VAR

	// allow users to change own entry/exit messages in ENTTLC
	// files: ENTTLC.C
	#define HWM_ENTTLC_MSG_CHANGE
//	#undef  HWM_ENTTLC_MSG_CHANGE

	// display the standard telecon entry/exit message, always
	#define HWM_ENTTLC_MSG_STANDARD
//	#undef  HWM_ENTTLC_MSG_STANDARD

	// disallows people without E-Mail access from using E-mail from forums
	// files: SIGS.C
	#define HWM_FORUM_EMAIL
//  #undef  HWM_FORUM_EMAIL

	// disallow people without the PAGE key from paging SYSOP, or
	// using "/#" or "/recent", or from being paged.
	// files: ENTTLC.C GALGLO.C
	#define HWM_PAGE_KEY
	#undef  HWM_PAGE_KEY

	// disable the whisper command
	//		files: enttlc.c
	#define HWM_NO_WHISPER
	#undef  HWM_NO_WHISPER

	// allows actions to be set up by "key" rather then by "person"
	// file ENTTLC.C
	#define HWM_KEY_ACTION
//	#undef  HWM_KEY_ACTION

	// uses a special format for listing actions to users
	// file ENTTLC.C
	#define HWM_ACTION_LIST
//  #undef  HWM_ACTION_LIST

	// allow downloads even if not enough credits
	// file: LIBDISP.C
	#define HWM_ALLOW_DOWNLOAD
//	#undef  HWM_ALLOW_DOWNLOAD

	// makes as many functions as non-static as possible, for
	// tracing down errors
	// files: HWMCOMP.H
	#define HWM_NO_STATIC
//  #undef HWM_NO_STATIC
#endif
