/*
     MAKEUSR.C - Creates Batches of User-Id's for People with
                 random passwords.  (actually, crc's of their id)

                 argv[1] prefix
                 argv[2] class
                 argv[3] # to gen

     Copyright 1994 Concentric Research Corp. - Christopher L. Kotacka  */

#include "gcomm.h"
#include "majorbbs.h"

#define MAXMAK 100
#define GEN 80

struct users {
     char userid[MAXMAK][UIDSIZ];
     char passwd[MAXMAK][PSWSIZ];
};

struct users genusers;
struct uidxrf uidxrf;
struct usracc acc;
struct acclass class;

BTVFILE *accbb,*classbb,*xrfbb;

FILE *genlog;

int failsafe;
int idx;
int suf,uniq;

char *ttt;

/* Protos */
int open_files  (void);
int close_files (void);
int fillin      (void);
int insusr      (void);
int genpass     (void);
int helpem      (void);
int class_there (void);
int report_em   (void);
int gen_em      (void);

char prefix[GEN];
char genclass[GEN];
int  number;

main(int argc, char *argv[1])
{
     if (argc != 4) {
          helpem();
          return(0);
     }

/* Check Prefix arg for validity */

     if (strlen(argv[1]) < (UIDSIZ-4)) {
          stzcpy(prefix,argv[1],GEN);
     }
     else {
          printf("\nprefix must be under 20 characters\n");
          return(0);
     }

/* Check Class arg */

     open_files();

     if (strlen(argv[2]) < KEYSIZ) {
          toupper(*argv[2]);
          stzcpy(genclass,argv[2],KEYSIZ);
          if (!class_there()) {
               printf("\n%s class does not exist!\n",genclass);
               close_files();
               return(0);
          }
     }
     else {
          printf("\n%s has too many characters for class-name\n",argv[2]);
          close_files();
          return(0);
     }

/* Check number arg */

     number=atoi(argv[3]);
     if (number > MAXMAK) {
          printf("Can only create %d accounts at a time, not %d\n",MAXMAK,
            number);
          close_files();
          return(0);
     }

/* Done Reality checking */

     gen_em();
     close_files();
     report_em();
     return(1);
}

open_files()
{
     accbb=opnbtv("BBSUSR.DAT",sizeof(struct usracc));
     classbb=opnbtv("BBSCLAS.DAT",sizeof(struct acclass));
     xrfbb=opnbtv("bbsxrf.dat",sizeof(struct uidxrf));
     return(1);
}

close_files()
{
     clsbtv(accbb);
     clsbtv(classbb);
     return(1);
}

class_there()            /* Does the class in question exist? */
{
     int rc;

     rc=0;
     setbtv(classbb);
     strupr(genclass);
     if (acqbtv(NULL,genclass,0)) {
          rc=1;
     }
     rstbtv();
     return(rc);
}


fillin()                 /* Fill In Account Information */
{
     char *fillin="FILL-IN";

     stzcpy(acc.userid,genusers.userid[idx],UIDSIZ);
     stzcpy(acc.psword,genusers.passwd[idx],PSWSIZ);
     stzcpy(acc.usrnam,fillin,NADSIZ);
     stzcpy(acc.usrad1,fillin,NADSIZ);
     stzcpy(acc.usrad2,fillin,NADSIZ);
     stzcpy(acc.usrad3,fillin,NADSIZ);
     stzcpy(acc.usrad4,fillin,NADSIZ);
     stzcpy(acc.usrpho,"1-800-745-2747",PHOSIZ);
     acc.systyp=0x01;
     acc.usrprf='\0';
     acc.ansifl='\0';
     acc.scnwid=0x50;    /* 80 */
     acc.scnbrk=0x18;    /* 24 */
     acc.scnfse=0x18;
     acc.age=0x20;
     acc.sex='M';
     acc.credat=acc.usedat=acc.csicnt=today();
     stzcpy(acc.prmcls,genclass,KEYSIZ);
     stzcpy(acc.curcls,genclass,KEYSIZ);
     acc.creds=acc.totcreds=10000L;      /* change for own use */
     stzcpy(acc.birthd,"01/01/65",DATSIZ);
                              /* Fill in Xrf Stuff */
     stzcpy(uidxrf.userid,acc.userid,UIDSIZ);
     stzcpy(uidxrf.xrfstg,acc.userid,XRFSIZ+1);
     return(1);
}

gen_pass()               /* generate a random password for this guy */
{
     /* Use modified Gcomm crc() routine from FLASH.C */

     char *pkp;
     int crc,i;
     char tmpuid[UIDSIZ];

     stzcpy(tmpuid,genusers.userid[idx],UIDSIZ);
     pkp=tmpuid;
     crc=0;
     i=0;
     do {
          crc=calcrc(crc,*pkp++);
     } while (++i < 15 && *pkp != '\0');
     itoa(abs(crc),genusers.passwd[idx],10);
     if (strlen(genusers.passwd[idx]) < 4) {       /* make it more chars */
          strcat(genusers.passwd[idx],"000");
     }
     printf("%-29.29s | %-9.9s \n",genusers.userid[idx],
          genusers.passwd[idx]);
     return(1);
}


insusr()                 /* Insert and create the Userid */
{

     setbtv(accbb);
     if (!dinsbtv(&acc)) {
          printf("\n\nYo Bub, %s already exists, something's hosed!\n",
               acc.userid);
     }
     rstbtv();
     setbtv(xrfbb);      /* Do the Cross Reference file too */
     insbtv(&uidxrf);
     rstbtv();
     return(1);
}

gen_em()                 /* Driver Loop to generate the accounts */
{
     *ttt='\0';
     failsafe=suf=0;
     for (idx = 0; idx < number; idx++) {
          do {
               uniq=0;
               stzcpy(genusers.userid[idx],prefix,UIDSIZ);
               itoa(suf,ttt,10);
               strcat(genusers.userid[idx],ttt);
               setbtv(accbb);
               if (acqbtv(NULL,genusers.userid[idx],0)) {
                    if (suf < 32000) {
                         suf++;  /* Bump the ID */
                    }
                    else {
                         failsafe=1;
                         printf("\nExceeded 32000 in rollover! \n");
                         break;
                    }
               }
               else {
                    uniq=1;
               }
          } while (uniq == 0);
          if (failsafe) {
               break;
          }
          gen_pass();
          fillin();
          insusr();
     }
     return(1);
}

report_em()              /* Make a detailed list of account and passwords */
{
     int i;

     if ((genlog=fopen("MAKEUSR.LOG",FOPAA)) == NULL) {
          printf("\nHoly Shit!!! Can't tell you who I made!  Woops!\n");
          return(0);
     }
     fprintf(genlog,"-------------------------------------------------------\n");
     fprintf(genlog,"Run:  %s %s Gen'd %d for Class: %s\n",
        ncdate(today()),nctime(now()),number,genclass);
     fprintf(genlog,"-------------------------------------------------------\n");
     fprintf(genlog,"       USERID                          PASSWORD\n\n");
     for ( i = 0; i < number ; i++) {
          fprintf(genlog,"%03d >  %-29.29s   %-9.9s\n",i,genusers.userid[i],
               genusers.passwd[i]);
     }
     fclose(genlog);
     printf("Log is in: MAKEUSR.LOG\n");
     return(1);
}

helpem()                 /* Show the weenie how to use this program */
{
     char *x={
          "\nMAKEUSR  (C) 1994 CRC/CLK\n"
          "              Concentric Research Corp.\n"
          "              Christopher L. Kotacka\n\n"
          "MAKEUSR <prefix> <class> <number>\n\n"
          "<prefix>   =  Name prefix, ie: DEMOS\n"
          "              to gen  DEMOS1,DEMOS2,DEMOS3 etc. etc\n"
          "<class>    =  Account class, like DEMOACCT, DEMOGRP\n"
          "              ( This class MUST exist already )\n"
          "<number>   =  Number of accounts to generate\n"
          "              ( This can be up to 100 at a time )\n"};

     printf("%s",x);
     return(1);
}
