/***
 *
 * ANXGLOBF.H - header for ANXGLOBF.C
 *
 * by Annex Online Services / Randall R. Spangler
 *
 * $Revision: 1.0 $ $Date: 1996/05/07 04:50:24 $
 *
 * This is a simple plug-in replacement API for globalcmd() which allows
 * you to specify the priority at which your global command loads itself.
 * This solves the problem of different modules all fighting over who gets
 * to load their global command handlers first.
 *
 * Your old code probable looks like this:
 *

        globalcmd(globptr);

 *
 * Just replace this with:
 *

        #include "anxglobf.h"

        GlobalFixRegister(globptr,numopt(GLOBPRIO,1,1000));

 *
 * And add the following to your MSG file:
 *

 This sets the priority at which our global command
 handler loads itself.  Lower numbers make us load
 earlier; higher numbers make us load later, after
 other global command handlers.  You normally shouldn't
 need to adjust this, but if you are having problems
 with your global command ordering you can tinker with
 this setting.  The default for this setting is 500.

GLOBPRIO {Global handler load priority: 500} N 1 1000

 *
 * You can either add ANXGLOBF.OBJ to your .LNK file, or just copy and
 * paste the functions you need straight into your .C file.
 *
 * You can feel free to include ANXGLFIX.DLL and ANXGLFIX.MDF in your
 * installs; they're tiny little files.  If these aren't present on a
 * system, the GlobalFixRegister() command will just call globalcmd();
 * this means that your global command WILL get registered one way or
 * another.
 *
 * If you have any questions about GlobalFix, please contact me.
 *
 *    	Randall R. Spangler
 *      ender@bbs.annex.com
 *
 ***/

#ifndef __ANXGLOBF_H
#define __ANXGLOBF_H

/* Default priorities to pass to GlobalFixRegister().  These should give you
 * a rough order for how you want to register your functions. */
#define GLFIX_PUTFIRST 1        /* Put ahead of all other global commands */
#define GLFIX_PUTLAST 1000      /* Put after all other global commands */
#define GLFIX_DONTCARE 500      /* Just register me - who cares where?  (This
                                 * is the priority at which GlobalFix puts
                                 * all global commands which are registered
                                 * using the old globalcmd() interface.) */

/* Return codes for GlobalFix functions. */
/* The following are good: */
#define GLFIX_SUCCESS 0         /* Call succeeded */
#define GLFIX_PASSTHRU 1        /* ANXGLFIX.DLL wasn't found, so request was
                                 * passed through to globalcmd() - your
                                 * global command DID register, though */
/* The following are bad: */
#define GLFIX_FAIL 2            /* Call completely failed */
#define GLFIX_BADPRIO 3         /* Priority is <1 or >1000 */

int         GlobalFixRegister(int (*glofunc) (), int priority);
 /* Registers a global command with the specified priority.  Returns zero if
  * successful or non-zero if error (in which case you can compare the return
  * code to the GLFIX_ return codes in ANXGLOBF.H). */

#endif          /* __ANXGLOBF_H */
