/* galftfix.c */

#include "gcomm.h"
#include "majorbbs.h"
#include "filexfer.h"
#include "patchit.h"

STATIC int fixftfrex(void);
STATIC int fixftfrop(int append,int ascii,int resume);

patchinfo rexpatch;
patchinfo roppatch;

void EXPORT
init__galftfix(void)
{
     patchinit(&roppatch,ftfrop,fixftfrop);
     patchnew(&roppatch);
     patchinit(&rexpatch,ftfrex,fixftfrex);
     patchnew(&rexpatch);
}

int
fixftfrex(void)              /* check if file to be received exists already */
{
     int retval;
     char *pp;

     while ((pp=strstr(ftfscb->fname,"..")) != NULL) {
          pp[0]='_';
          pp[1]='_';
     }
     strrpl(ftfscb->fname,'\\','_');
     strrpl(ftfscb->fname,'/','_');
     strrpl(ftfscb->fname,':','_');
     patchold(&rexpatch);
     retval=ftfrex();
     patchnew(&rexpatch);
     return(retval);
}

int
fixftfrop(                           /* Open file for reception and writing */
int append,                             /* if exists, 1=append, 0=overwrite */
int ascii,                                             /* 1=ascii, 0=binary */
int resume)                                     /* 1=resume, 0=from scratch */
{
     int retval;
     char *pp;

     while ((pp=strstr(ftfscb->fname,"..")) != NULL) {
          pp[0]='_';
          pp[1]='_';
     }
     strrpl(ftfscb->fname,'\\','_');
     strrpl(ftfscb->fname,'/','_');
     strrpl(ftfscb->fname,':','_');
     patchold(&roppatch);
     retval=ftfrop(append,ascii,resume);
     patchnew(&roppatch);
     return(retval);
}

