/***************************************************************************
 *                                                                         *
 *   SIGS.C                                                                *
 *                                                                         *
 *   Copyright (C) 1988-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is The Major BBS Forums (public messaging areas) handler.        *
 *                                                                         *
 *                                  - T. Stryker 7/26/88                   *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galms.h"
#include "message.h"

int sigstt;                   /* state code for SIGs module           */

struct module sigsmod={       /* module interface block               */
     "",                      /*    name used to refer to this module */
     NULL,                    /*    user logon supplemental routine   */
     sigs,                    /*    input routine if selected         */
     emsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     NULL,                    /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     sigdla,                  /*    delete-account routine            */
     clssig                   /*    finish-up (sys shutdown) routine  */
};

/*--- OPTIONS FROM GALMS.MSG ---*/

int nsigs,                    /* number of SIGs allowed for                */
    stlcop,                   /* SIG teleconference option                 */
    sigccr,                   /* default SIG credit consumption rate       */
    siglif,                   /* default lifetime of a SIG message, in days*/
    sigtck,                   /* default "ticks" (credits) per SIG msg     */
    sattck,                   /* default "ticks" (credits) per file upload */
    sdnaud,                   /* Do audit trail entry per SIG download?    */
    supaud,                   /* Do audit trail entry per SIG upload?      */
    sopmhd,                   /* allow SIG-Ops to modify SIG headers?      */
    autqsc;                   /* automatically have new Forums in qscfgs?  */

char *sigsys,                 /* name of Sysop privileged SIG usage key    */
     *sigprv;                 /* name of privileged SIG usage key          */

extern
char *emlkey;                 /* key required in order to email via SIG    */

char dftsig[SIGSIZ];          /* default SIG for new users etc.            */

int dftprf=0;                 /* default value of preference flags         */
int qscsiz;                   /* size of in-memory quickscan recs (qscptr) */

void *sigblok;               /* sigdat table ref pointer                  */
void *qscblok;               /* quickscan table ref pointer               */

struct qscfg *qscldr;         /* temp loading space for quickscan records  */

STATIC void sigloc(void);
STATIC void modloc(void);
STATIC void trcans(char *stg,int len);

#define MMENU (readac() >= OPAXES ? ORSPRMT : (stlcop ? RSPRMT : NTRSPRMT))
#define HUH   SIGHUH

#define acclvl(x,sn) (((sn)&1) ? x[(sn)>>1]>>4 : (x[(sn)>>1]&0x0F))

void
inisig(void)                  /* initialize sig processing                 */
{
     unsigned i;
     struct sighdr *tmp;

     stzcpy(sigsmod.descrp,gmdnam("GALFOR.MDF"),MNMSIZ);
     sigstt=register_module(&sigsmod);
     nsigs=numopt(NSIGS,1,MAXSIG);
     stlcop=ynopt(STLCOP);
     sigccr=numopt(SIGCCR,-32767,32767);
     siglif=numopt(SIGLIF,-1,32767);
     sigtck=numopt(SIGTCK,-32767,32767);
     sattck=numopt(SATTCK,-32767,32767);
     sdnaud=ynopt(SDNAUD);
     supaud=ynopt(SUPAUD);
     sopmhd=ynopt(SOPMHD);
     autqsc=ynopt(AUTQSC);
     sigsys=stgopt(SIGSYS);
     sigprv=stgopt(SIGPRV);
     if (ynopt(DFTPR1)) {
          dftprf|=CWHENR;
     }
     switch (tokopt(DFTPR2,"NOTIFY","PROMPT","READIT",NULL)) {
     case 3:
          dftprf|=GORTIN;
     case 2:
          dftprf|=P4NEWM;
     }
     if (ynopt(DFTPR3)) {
          dftprf|=FORUM2;
     }
     switch (tokopt(DFTPR4,"PROMPT","NEVER","ALWAYS",NULL)) {
     case 3:
          dftprf|=ALWQUO;
     case 1:
          dftprf|=MSGQUO;
     }
     if (!ynopt(DFTPR5)) {
          dftprf|=CMBHDR;
     }
     stzcpy(dftsig,getmsg(DFTSIG),sizeof(dftsig));
     dftnlv=alcmem(i=((nsigs+1)/2));
     dftliv=alcmem(i);
     maxnlv=alcmem(i);
     alcsig();
     for (i=0 ; i < nsigs ; i++) {
          setmem(sigoff(i),sizeof(struct sigdat),0);
     }
     alcqsc();
     for (i=0 ; i < nterms ; i++) {
          setmem(qscoff(i),qscsiz,0);
     }

     qscldr=(struct qscfg *)alcmem(MAXQSC);
     tmpqsc=(struct qscfg *)alcmem(qscsiz);
     sopqsc=(struct qscfg *)alcmem(qscsiz);
     sopusa=(struct usracc *)alcmem(sizeof(struct usracc));

     tmp=(struct sighdr *)alcmem(sizeof(struct sighdr)+msgbyts);
     strcpy(compos.userid,"/");
     if (!agtbtv(tmp,&compos,TONUM)) {
          catastro("EMPTY GALMSG.DAT!");
     }
     do {
          if (tmp->signo >= nsigs || !(tmp->flags&ISSHDR)) {
               catastro("INISIG: BAD HDR #%u",tmp->signo);
          }
          mnewsg(tmp);
          strcpy(compos.userid,tmp->to);
          compos.msgno=-1L;
     } while (agtbtv(tmp,&compos,TONUM) && tmp->to[0] == SIGIDC);
     free(tmp);
}

void
mnewsg(hdrptr)                /* fill in new sigdat entry from msg         */
struct sighdr *hdrptr;
{
     int sn;
     int oidx;
     char *bptr,*eptr;

     sn=hdrptr->signo;
     if (sn > sv.hisign) {
          sv.hisign=sn;
     }
     strcpy(sigoff(sn)->sigop,hdrptr->from);
     strcpy(sigoff(sn)->signam,hdrptr->to);
     stzcpy(sigoff(sn)->sigloc,hdrptr->sigloc,KEYSIZ);
     movmem(hdrptr->topic,sigoff(sn)->descrp,
            sizeof(struct sigdat)-sizeof(char *)-UIDSIZ-SIGSIZ-KEYSIZ);
     wracut(dftnlv,hdrptr->dfnlv,sn);
     wracut(dftliv,hdrptr->dfliv,sn);
     wracut(maxnlv,hdrptr->mxnlv,sn);
     mkdir(hdrptr->to+1);
     if ((oidx=findstg("mhs-addr:",hdrptr->text)) > 0) {
          bptr=hdrptr->text+oidx;
          while (isspace(*bptr)) {
               bptr++;
          }
          eptr=strchr(bptr,'\r');
          if (eptr != NULL) {
               *eptr='\0';
          }
          sigoff(sn)->mhsaddr=alcdup(bptr);
     }
}

int
sigs(void)                    /* main status-3 input vector for sigs       */
{
     if (fireup()) {
          if (margc == 1 && sameas(input,"x")) {
               switch (esgstt) {
               case SSTART:
               case NTSSTART:
               case RSPRMT:
               case NTRSPRMT:
               case OPSTART:
               case ORSPRMT:
                    return(0);
               }
               abostf();
          }
          else {
               do {
                    bgncnc();
                    switch (esgstt) {
                    case 0:
                         cncchr();
                         usrptr->flags&=~X2MAIN;
                         sigst0();
                         break;
                    case SSTART:
                    case NTSSTART:
                    case RSPRMT:
                    case NTRSPRMT:
                    case OPSTART:
                    case ORSPRMT:
                         if (ssstart()) {
                              return(1);
                         }
                         break;
                    case READBUL:
                    case DNLFILL:
                         sreadbu();
                         break;
                    case SRKEY:
                         ssrkey();
                         break;
                    case STARTN:
                    case STARTF:
                         sstarts();
                         break;
                    case LISTYP:
                         slistyp();
                         break;
                    case STARTL:
                         sstartl();
                         break;
                    case RQUICKL:
                         srquick();
                         break;
                    case QUICKC:
                    case QUICKC4:
                         squickc();
                         break;
                    case QCADD:
                         sqcadd();
                         break;
                    case QCDEL:
                         sqcdel();
                         break;
                    case QCKWDS:
                         sqckwds();
                         break;
                    case QCSRKY:
                         sqcsrky();
                         break;
                    case MODWHT:
                         smodwhs();
                         break;
                    case DELMSN:
                         sdelmss();
                         break;
                    case MMINF:
                    case SRCHNG:
                    case SCANNG:
                    case SCANAP:
                    case LISTNG:
                    case SLSTTL:
                    case CPYING:
                         btuclo(usrnum);
                         prfmsg(ABOLST);
                         abostf();
                         break;
                    case RRRQ:
                         ssrrrq();
                         break;
                    case SIGMTO:
                         ssigmto();
                         break;
                    case SELSIG:
                         sselsig();
                         break;
                    case SIGCON3:
                         ssigcon();
                         break;
                    case SIG123:
                    case SYS123:
                         s123();
                         break;
                    case SIGUID2:
                    case SYSUID2:
                         suid();
                         break;
                    case OPRMNU:
                         soprmnu();
                         break;
                    case CRESIG:
                         scresig();
                         break;
                    case DELSIG:
                         sdelsig();
                         break;
                    case DELRUS1:
                         sdelrus();
                         break;
                    case UCPSRC:
                         sucpsrc();
                         break;
                    case UCPDST:
                    case UCPDST2:
                         sucpdst();
                         break;
                    case SIGLOC:
                    case SIGLOCH:
                    case SIGLOCB:
                         sigloc();
                         break;
                    case MODLOC:
                    case MODLOCH:
                    case MODLOCB:
                         modloc();
                         break;

                    default:
                         hdlesg();
                    }
               } while (!endcnc());
          }
     }
     if (esgstt != EDITING) {
          outprf(usrnum);
          usrptr->substt=esgstt;
     }
     return(1);
}

void
abostf(void)                  /* abort "stuff" (whatever is going on)      */
{
     cpyoff();
     clrxrf();
     esgptr->sflags=0;
     esgptr->prethr=0L;
     esgptr->keynum=TONUM;
     setmem(esgptr->prvpos,NPREVS*sizeof(long),0);
     esgptr->pvpidx=0;
     cncall();
     if (esgptr->usigno != qscptr->cursig) {
          prfmsg(R2SIG,sigoff(esgptr->usigno=qscptr->cursig)->signam);
     }
     prompt(MMENU);
}

void
sigst0(void)                  /* SIG substate 0 handler (from Main Menu)   */
{
     long savflg;

     esgptr->keynum=TONUM;
     if (qscptr->cursig == NOSIG || rdautl(qscptr->cursig) == NOAXES) {
          if ((qscptr->cursig=findsig(dftsig)) == NOSIG
           && rdautl(qscptr->cursig=0) == NOAXES) {
               catastro("CONFIGURATION OPTION \"DFTSIG\" NAMES A FORUM THAT DOESN'T EXIST: %s",
                         dftsig);
          }
     }
     savflg=usrptr->flags;
     usrptr->flags&=~CONCEX;
     joinsg(qscptr->cursig);
     usrptr->flags=savflg;
}

int
onsqsc(userid)                /* is user "on system"? (if so, update qscfg)*/
char *userid;
{
     if (onsysn(userid,1)) {
          if (!sameas(qscoff(othusn)->userid,userid)) {
               iqscfg(qscoff(othusn),userid);
          }
          return(1);
     }
     return(0);
}

void
iniqsc(void)                  /* initialize qscfg area if not already      */
{
     if (!sameas(qscptr->userid,usaptr->userid)) {
          iqscfg(qscptr,usaptr->userid);
     }
}

void
iqscfg(qscptr,userid)         /* initialize qscfg from disk (if none, make)*/
struct qscfg *qscptr;
char *userid;
{
     setbtv(qscbb);
     while (!grbqsc(qscptr,userid)) {
          setmem(qscptr,qscsiz,0);
          stzcpy(qscptr->userid,userid,UIDSIZ);
          qscptr->nsigs=nsigs;
          qscptr->cursig=NOSIG;
          qscptr->flags=dftprf;
          if (!autqsc) {
               setmem(LSOFAR,nsigs*sizeof(long),0xFF);
          }
          setmem(qscptr->acclso,(nsigs+1)/2,NOTSET+(NOTSET<<4));
          invbtv(qscptr,qscsiz);
     }
     setbtv(esgbb);
}

int
grbqsc(grbptr,userid)         /* grab the quickscan record for a userid    */
struct qscfg *grbptr;              /* buffer to get it into                */
char *userid;                      /* userid whose record is to be gotten  */
{
     int i;

     setbtv(qscbb);
     if (!acqbtv(qscldr,userid,0)) {
          return(0);
     }
     if (qscldr->nsigs != nsigs) {
          movmem(&qscldr->acclso[(qscldr->nsigs+1)/2]
                 ,&qscldr->acclso[(nsigs+1)/2],nsigs*sizeof(long));
          if ((qscldr->nsigs+1)/2 < (nsigs+1)/2) {
               setmem(&qscldr->acclso[(qscldr->nsigs+1)/2]
                      ,(nsigs+1)/2-(qscldr->nsigs+1)/2,NOTSET+(NOTSET<<4));
               setmem(&qscldr->acclso[(nsigs+1)/2+sizeof(long)*qscldr->nsigs]
                      ,(nsigs-qscldr->nsigs)*sizeof(long),autqsc ? 0 : 0xFF);
          }
          qscldr->nsigs=nsigs;
     }
     movmem(qscldr,grbptr,qscsiz);
     if (grbptr->cursig >= nsigs || sigoff(grbptr->cursig)->signam[0] == '\0') {
          grbptr->cursig=NOSIG;
     }
     for (i=0 ; i < nsigs ; i++) {
          if (((long *)(&grbptr->acclso[(nsigs+1)/2]))[i] > sv.msgtot) {
               ((long *)(&grbptr->acclso[(nsigs+1)/2]))[i]=sv.msgtot;
          }
     }
     rstbtv();
     setbtv(esgbb);
     return(1);
}

int
ssstart(void)                 /* state: sitting at main sig menu           */
{
     int c;

     switch (c=cncchr()) {
     case '?':
          switch (esgstt) {
          case SSTART:
          case NTSSTART:
          case OPSTART:
               prfmsg(FHLPHDR);
               outprf(usrnum);
               asig(FIRSTM);
               xtext();
               fupqs(MMINF,0);
               break;
          case RSPRMT:
               prompt(SSTART);
               break;
          case NTRSPRMT:
               prompt(NTSSTART);
               break;
          case ORSPRMT:
               prompt(OPSTART);
               break;
          }
          break;
     case 'R':
          prompt(READBUL);
          break;
     case 'W':
          if (readac() < WRAXES) {
               errmsg(NWRSIG);
          }
          else if (credsf(esgptr->sigtck)) {
               esgptr->msg.auxtpc[0]='\0';
               prompt(SIGMTO);
          }
          break;
     case 'Q':
          prompt(RQUICKL);
          break;
     case 'F':
          esgptr->sflags|=SCN4AT;
          prompt(DNLFILL);
          break;
     case 'T':
          if ((stlcop || readac() >= OPAXES) && (tjoinrou != NULL)) {
               usrptr->substt=esgstt;
               (*tjoinrou)(esgptr->usigno);
               return(1);
          }
          errmsg(CNOTIL);
          break;
     case 'S':
          if (*nxtcmd != '\0' && *nxtcmd != ' ') {
               usrptr->flags&=~CONCEX;
          }
          prompt(SELSIG);
          break;
     default:
          if (readac() >= OPAXES) {
               switch (c) {
               case 'M':
                    prfmsg(MODWRN);
                    prompt(MODWHT);
                    break;
               case 'E':
                    prompt(DELMSN);
                    break;
               case 'A':
                    asig(LASTM);
                    fupqs(SCANAP,SCN4AT+SCN4UA);
                    break;
               case 'C':
                    prompt(SIGCON3);
                    break;
               case 'O':
                    if (haskey(sigsys)) {
                         prompt(OPRMNU);
                         break;
                    }
               default:
                    errmsg(CNOTIL);
               }
               break;
          }
          errmsg(CNOTIL);
     }
     return(0);
}

void
ssigmto(void)                 /* state: SIG message to who, or ALL         */
{
     switch (morcnc()) {
     case '?':
          prohlp(sigoff(esgptr->usigno)->mhsaddr != NULL ? SMEHLP : SMTHLP);
          break;
     case '.':
          cncchr();
          strcpy(esgptr->msg.userto,ALL);
          edimsg(1,1,pstdun,0);
          break;
     default:
          if (*nxtcmd == '@') {
               cncchr();
               if (morcnc() != '\0') {
                    stzcpy(esgptr->msg.userto,cncall(),UIDSIZ);
                    edimsg(1,1,pstdun,0);
               }
               else {
                    prohlp(sigoff(esgptr->usigno)->mhsaddr != NULL ?
                           SMEHLP : SMTHLP);
               }
          }
          else {
               switch (hdluid(cncall())) {
               case UIDFND:
                    strcpy(esgptr->msg.userto,uidxrf.userid);
                    edimsg(1,1,pstdun,0);
                    break;
               case UIDPMT:
                    prompt(esgstt);
                    break;
               case UIDCAL:
                    esgptr->dftinp=languages[clingo]->yes[0];
                    break;
               }
          }
     }
}

void
ssigcon(void)                 /* state: Sysop/SIG-Op configure-users       */
{
     int lvl;
     char tmp[UIDSIZ];

     stzcpy(tmp,cncall(),UIDSIZ);
     if (sameas(tmp,"?")) {
          prfmsg(SIGCON1);
          prohlp(SIGCON4);
     }
     else if (sameas(tmp,"1") || sameas(tmp,"2") || sameas(tmp,"3")) {
          esgptr->blknum=tmp[0];
          prompt(haskey(sigsys) ? SYS123 : SIG123);
     }
     else if (sameas(tmp,"4")) {
          prompt(MODLOC);
     }
     else {
          if ((lvl=rdoutl(tmp)) == NOTSET) {
               errmsg(HUH);
          }
          else {
               movmem(tmp,esgptr->mhs.addr,UIDSIZ);
               prfmsg(CURLVL,tmp,accstg[lvl]);
               prompt(haskey(sigsys) ? SYSUID2 : SIGUID2);
          }
     }
}

void
s123(void)                    /* state: configure dftnlv, dftliv or maxnlv */
{
     int newlvl,tmp;

     switch (cncchr()) {
     case '?':
          prohlp(esgstt == SIG123 ? SIG123N2 : SYS123N2);
          return;
     case 'Z':
          newlvl=NOAXES;
          break;
     case 'R':
          newlvl=RDAXES;
          break;
     case 'D':
          newlvl=DLAXES;
          break;
     case 'W':
          newlvl=WRAXES;
          break;
     case 'U':
          newlvl=ULAXES;
          break;
     case 'C':
          newlvl=COAXES;
          break;
     case 'F':
          if (haskey(sigsys)) {
               newlvl=OPAXES;
               break;
          }
     default:
          errmsg(HUH);
          return;
     }
     wracar((tmp=esgptr->blknum-'1') == 0 ? dftnlv : tmp == 1 ? dftliv : maxnlv,
            newlvl);
     prompt(MMENU);
}

void
suid(void)                    /* state: configure User-ID                  */
{
     int newlvl,actlvl;

     switch (cncchr()) {
     case '?':
          prohlp(esgstt == SIGUID2 ? SIGUIDH2 : SYSUIDH2);
          return;
     case 'Z':
          newlvl=NOAXES;
          break;
     case 'R':
          newlvl=RDAXES;
          break;
     case 'D':
          newlvl=DLAXES;
          break;
     case 'W':
          newlvl=WRAXES;
          break;
     case 'U':
          newlvl=ULAXES;
          break;
     case 'C':
          newlvl=COAXES;
          break;
     case 'F':
          if (haskey(sigsys)) {
               newlvl=OPAXES;
               break;
          }
     case '*':
          newlvl=NOTSET;
          break;
     default:
          errmsg(HUH);
          return;
     }
     writac(esgptr->mhs.addr,newlvl);
     actlvl=rdoutl(esgptr->mhs.addr);
     if (actlvl != newlvl) {
          if (newlvl == NOAXES && actlvl == RDAXES) {
               prfmsg(DFTSOV);
          }
          else if (actlvl == SYAXES) {
               prfmsg(RMNSYS2);
          }
          else if (newlvl == NOTSET) {
               prfmsg(BAKDFT,esgptr->mhs.addr,accstg[actlvl]);
          }
          else {
               prfmsg(MXNLOVN,esgptr->mhs.addr,accstg[actlvl]);
          }
          outprf(usrnum);
     }
     esgptr->mhs.addr[0]='\0';
     prompt(MMENU);
}

void
soprmnu(void)                 /* state: operations menu                    */
{
     switch (cncchr()) {
     case 'C':
          prompt(CRESIG);
          break;
     case 'D':
          prompt(DELSIG);
          break;
     case 'U':
          prfmsg(UCPINF);
          prompt(UCPSRC);
          break;
     default:
          errmsg(HUH);
     }
}

void
scresig(void)                 /* state: create a sig, enter new name       */
{
     char *signam,*snp;

     if (sv.hisign >= nsigs-1) {
          blwoff(NOROOM);
     }
     else if (*(signam=cncuid()) != SIGIDC || strlen(signam) < 2 || morcnc()) {
          errmsg(SIGNNG);
     }
     else if (findsig(signam) != NOSIG) {
          errmsg(SIGXST);
     }
     else {
          for (snp=signam+1 ; *snp != '\0' ; snp++) {
               if (*snp == '.' || !isfiln(*snp,signam)) {
                    errmsg(SIGCNG);
                    return;
               }
          }
          stzcpy(esgptr->newsig,signam,UIDSIZ);
          prompt(SIGLOC);
     }
}

STATIC void
sigloc(void)                  /* state: create a sig, enter a sig lock     */
{
     struct sighdr *hdrptr;
     char keyreq[KEYSIZ];

     hdrptr=(struct sighdr *)(&esgptr->msg);
     setmem(hdrptr,sizeof(struct sighdr),0);
     if (morcnc() == '?') {
          cncall();
          prompt(SIGLOCH);
          return;
     }
     else if (morcnc()) {
          stzcpy(keyreq,strupr(cncwrd()),KEYSIZ);
          if (!keynam(keyreq)) {
               prompt(SIGLOCB);
               return;
          }
          stzcpy(hdrptr->sigloc,keyreq,KEYSIZ);
     }
     else {
          setmem(hdrptr->sigloc,KEYSIZ,0);
     }
     stzcpy(esgptr->msg.to,esgptr->newsig,UIDSIZ);
     stzcpy(esgptr->msg.userto,esgptr->newsig,UIDSIZ);
     prfmsg(MAKSIG,sigccr,siglif,sigtck,sattck);
     outprf(usrnum);
     edimsg(1,1,csgdun,0);
}

STATIC void
modloc(void)                  /* state: modify a sig lock                  */
{
     char keyreq[KEYSIZ];

     if (morcnc() == '?') {
          cncall();
          prompt(MODLOCH);
          return;
     }
     else if (morcnc()) {
          stzcpy(keyreq,strupr(cncwrd()),KEYSIZ);
          if (!keynam(keyreq)) {
               prompt(MODLOCB);
               return;
          }
          stzcpy(sigoff(esgptr->usigno)->sigloc,keyreq,KEYSIZ);
     }
     else {
          setmem(sigoff(esgptr->usigno)->sigloc,KEYSIZ,0);
     }
     prompt(SIGCON3);
}

void
csgdun(save)                  /* create-SIG done, finish up                */
int save;
{
     struct sighdr *hdrptr;

     if (save) {
          if (sv.hisign >= nsigs-1) {
               prfmsg(NOROOM);
               prompt(MMENU);
          }
          else {
               hdrptr=(struct sighdr *)(&esgptr->msg);
               hdrptr->signo=sv.hisign+1;
               hdrptr->flags=ISSHDR;
               hdrptr->dfnlv=RDAXES;
               hdrptr->dfliv=ULAXES;
               hdrptr->mxnlv=COAXES;
               postit();
               mnewsg(hdrptr);
               prfmsg(SIGCNF,hdrptr->to);
               figin(1);
               joinsg(hdrptr->signo);
          }
     }
     else {
          prfmsg(NOSIGC);
          prompt(MMENU);
     }
}

void
sdelsig(void)                 /* state: delete sig, what name?             */
{
     int signo;
     char *signam;

     if (morcnc() == '?') {
          lissgs(rprdls);
     }
     else if (sameas(signam=cncsig(),dftsig)) {
          errmsg(CANTDD);
     }
     else if ((signo=findsig(signam)) == NOSIG) {
          errmsg(SLSNXI);
     }
     else if (anyone(signo)) {
          errmsg(CANTDL);
     }
     else {
          esgptr->blknum=signo;
          prompt(DELRUS1);
     }
}

void
sdelrus(void)                 /* state: delete SIG, are you sure??         */
{
     switch (cncyesno()) {
     case 'Y':
          if (anyone(esgptr->blknum)) {
               blwoff(SNUKIN);
          }
          else {
               esgptr->usigno=esgptr->blknum;
               asig(FIRSTM);
               do {
                    delmsg();
               } while (anibtv(&esgptr->msg));
               esgptr->usigno=qscptr->cursig;
               prfmsg(SIGDOK);
               setmem(sigoff(esgptr->blknum),sizeof(struct sigdat),0);
               prompt(OPRMNU);
          }
          break;
     case 'N':
          prompt(OPRMNU);
          break;
     default:
          errmsg(HUH);
     }
}

void
rprdls(void)                  /* re-prompt after sig-list under sdelsig()  */
{
     prompt(DELSIG);
}

void
cpyoff(void)                  /* turn file-copying process off             */
{
     if (esgptr->sflags&CPYIPG) {
          fclose(esgptr->fp);
          if (esgptr->fpout != NULL) {
               fclose(esgptr->fpout);
          }
          esgptr->sflags&=~CPYIPG;
     }
}

void
sucpsrc(void)                 /* state: user-copy source User-ID?          */
{
     char *up;

     if (getqsc(up=cncuid(),sopqsc) == NULL) {
          errmsg(SOPUNG);
     }
     else {
          stzcpy(esgptr->msg.from,up,UIDSIZ);
          prompt(UCPDST);
     }
}

void
sucpdst(void)                 /* state: user-copy destination User-ID?     */
{
     char *dstuid;
     struct qscfg *srcuqp,*dstuqp;

     if (onsysn(dstuid=cncuid(),1)) {
          errmsg(DCBONL,dstuid);
     }
     else if ((srcuqp=getqsc(esgptr->msg.from,tmpqsc)) == NULL) {
          blwoff(SOPUNG);
     }
     else if ((dstuqp=getqsc(dstuid,sopqsc)) == NULL) {
          errmsg(SOPUNG);
     }
     else {
          setbtv(qscbb);
          movmem(srcuqp->acclso,dstuqp->acclso,(nsigs+1)/2);
          upvbtv(dstuqp,qscsiz);
          prompt(UCPDST2);
     }
}

void
smodwhs(void)                 /* state: modify what sig msg number?        */
{
     if (isalon()) {
          if (acqbtv(&esgptr->msg,&compos,TONUM)) {
               esgmod(moddun);
          }
          else {
               errmsg(NSUCHM);
          }
     }
}

void
sdelmss(void)                 /* state: delete (erase) what msg number?    */
{
     if (isalon()) {
          if (acqbtv(&esgptr->msg,&compos,TONUM)) {
               cncall();
               delwck();
          }
          else {
               errmsg(NSUCHM);
          }
     }
}

void
sreadbu(void)                 /* state: read-msg menu                      */
{
     char signam[SIGSIZ];
     long msgno;

     switch (cncchr()) {
     case '?':
          prohlp(esgstt == READBUL ? RBLHLP : DLLHLP);
          break;
     case 'K':
          prompt(SRKEY);
          btumil(usrnum,MXKWLN-1);
          break;
     case 'S':
          asig(msgno=LSOFAR[qscptr->cursig]);
          if (msgno > 0L) {
               stzcpy(signam,esgptr->msg.to,SIGSIZ);
               if (qnxbtv()) {
                    gcrbtv(&esgptr->msg,TONUM);
                    if (sameas(esgptr->msg.to,signam)) {
                         esgptr->fpos=absbtv();
                    }
                    else {
                         estabc();
                    }
               }
          }
          prompt(msgno >= esgptr->msg.msgno ? STARTF : STARTN);
          break;
     case 'L':
          asig(FIRSTM);
          prompt(LISTYP);
          break;
     default:
          errmsg(HUH);
     }
}

void
ssrkey(void)                  /* state: enter search key?                  */
{
     char *kwp;

     if (morcnc() == '?') {
          prohlp(SRKEYH);
     }
     else {
          if (*(kwp=cncall()) != '.') {
               movmem(kwp,esgptr->keywds,MXKWLN-1);
          }
          if (findkw(esgptr->keywds) == NULL && (kwp=findkw("")) != NULL) {
               movmem(esgptr->keywds,kwp,MXKWLN-1);
          }
          btumil(usrnum,DFTIMX);
          asig(FIRSTM);
          fupqs(SRCHNG,SCNNXT+SCNKWD);
     }
}

char *
findkw(kwd)                   /* find kwd in quickscan keyword list        */
char *kwd;
{
     int i;
     char *kwdptr;

     for (i=0,kwdptr=qscptr->qskwds[0]; i < NQSKWG ; i++,kwdptr+=MXKWLN) {
          if (sameas(kwd,kwdptr)) {
               return(kwdptr);
          }
     }
     return(NULL);
}

void
sstarts(void)                 /* state: start scan at what msg number?     */
{
     if (strtup(RTSHLP)) {
          sgonext();
     }
}

void
sscosig(void)                 /* state: next, previous, thread, or read?   */
{
     switch (cncchr()) {
     case 'N':
          sgonext();
          break;
     case 'P':
          sgoprev();
          break;
     case 'T':
          prompt(THRFBP);
          break;
     case '#':
          prompt(GONUM);
          break;
     case 'R':
          scoutls();
          break;
     case 'D':
          if (esgstt == SCDSIG) {
               if (attfs(&esgptr->msg) == NULL) {
                    prfmsg(ATTNF,l2as(esgptr->msg.msgno));
                    gorep();
               }
               else {
                    setwhn(gorep);
                    prfmsg(DNLHDR);
                    if (!begdld()) {
                         prompt(esgstt);
                    }
               }
               break;
          }
     default:
          errmsg(HUH);
     }
}

void
scoutls(void)                 /* "read this message" sigs utility          */
{
     xtext();
     switch (esgptr->msg.flags&(FILATT+APPVED)) {
     case 0:
          gorep();
          break;
     case FILATT:
          prfmsg(ATTNAP);
          if (readac() < OPAXES) {
               gorep();
          }
          else {
               dnload(gorep);
          }
          break;
     case FILATT+APPVED:
          if (readac() < DLAXES) {
               prfmsg(FBNODL);
               gorep();
          }
          else {
               dnload(gorep);
          }
          break;
     }
}

void
gorep(void)                   /* go issue reply etc. prompt line           */
{
     if (usrptr->state == emlstt && esgptr->keynum == UTONUM) {
          prompt(readac() < OPAXES ? REPSEM : RESOP2);
     }
     else {
          prompt(readac() < OPAXES ? REPSIG : REPOP2);
     }
}

void
sgoprev(void)                 /* sig go-to-previous msg utility            */
{
     long p;
     int sn;

     if (usrptr->state == emlstt) {
          oncors();
          goprev();
     }
     else if (esgptr->sflags&SCNQUI) {
          if (esgptr->pvpidx >= NPREVS-1
           || (p=esgptr->prvpos[esgptr->pvpidx+1]) == 0
           || !aabbtv(&esgptr->msg,p,TONUM)
           || (sn=findsig(esgptr->msg.to)) == NOSIG) {
               estabc();
               errmsg(PVPGON);
          }
          else {
               esgptr->usigno=sn;
               esgptr->pvpidx++;
               sumscn(1);
          }
     }
     else {
          if (esgptr->sflags&SCN4UA) {
               esgptr->sflags|=SCNNXT;
          }
          else {
               esgptr->sflags&=~SCNNXT;
          }
          gocyc();
     }
}

void
sgonext(void)                 /* sig go-to-next msg utility                */
{
     int sn;

     if (usrptr->state == emlstt) {
          oncors();
          gonext();
     }
     else {
          esgptr->sflags&=~MHSORG;
          while (esgptr->pvpidx > 0) {
               esgptr->pvpidx--;
               if (aabbtv(&esgptr->msg,esgptr->prvpos[esgptr->pvpidx],TONUM)
                && (sn=findsig(esgptr->msg.to)) != NOSIG) {
                    esgptr->usigno=sn;
                    sumscn(0);
                    return;
               }
          }
          if (esgptr->sflags&SCN4UA) {
               esgptr->sflags&=~SCNNXT;
          }
          else {
               esgptr->sflags|=SCNNXT;
          }
          gocyc();
     }
}

void
gocyc(void)                   /* go cycle onward through msgs (continue)   */
{
     int flags;

     oncors();
     flags=esgptr->sflags;
     if (flags&SCNKWD) {
          prompt(SRCHNG);
     }
     else if (flags&SCN4UA) {
          prompt(SCANAP);
     }
     else if (flags&SCN4AT) {
          prompt(SCANNG);
     }
     else {
          esgstt=SCANNG;
     }
     bgncyc();
}

void
srepsig(void)                 /* state: reply, thread, prev, next, etc.?   */
{
     switch (cncchr()) {
     case 'R':
          if (readac() < WRAXES) {
               errmsg(NWRSIG);
          }
          else if (credsf(esgptr->sigtck)) {
               strcpy(esgptr->msg.userto,esgptr->msg.from);
               addaux(formax("Reply to #"));
               ediwqu(srpdun);
          }
          break;
     case 'E':
          if (esgptr->msg.flags&MHSMSG) {
               if (mhsrok()) {
                    esgptr->sflags|=MHSORG;
                    strcpy(esgptr->msg.to,esgptr->msg.from);
                    strcpy(esgptr->msg.userto,esgptr->msg.from);
                    ediwqu(serdun);
               }
          }
          else if (credok(haskey(emlkey),emltck)) {
               strcpy(esgptr->msg.userto,esgptr->msg.from);
               strcpy(esgptr->msg.to,esgptr->msg.from);
               addaux(formax("Reply to #"));
               ediwqu(serdun);
          }
          break;
     case 'C':
          if (usrptr->state == emlstt && esgptr->keynum == UTONUM) {
               refclr(USING);
          }
          else {
               errmsg(HUH);
          }
          break;
     case 'T':
          prompt(THRFBP);
          break;
     case 'P':
          sgoprev();
          break;
     case 'N':
          sgonext();
          break;
     case '#':
          prompt(GONUM);
          break;
     case 'F':
          if (readac() >= OPAXES) {
               if ((esgptr->msg.flags&(FILATT+APPVED)) == FILATT) {
                    prompt(REPOPA);
               }
               else {
                    prompt((esgptr->msg.flags&EXEMPT) ? REPOPU : REPOPX);
               }
               break;
          }
     default:
          errmsg(HUH);
     }
}

void
srepopx(void)                 /* state: operator functions menu            */
{
     int cpytck;

     switch (cncchr()) {
     case 'N':
          sgonext();
          break;
     case '#':
          prompt(GONUM);
          break;
     case 'F':
          if (esgptr->msg.flags&ISSHDR) {
               errmsg(NOFCSH);
          }
          else {
               prompt(OPFWD1);
          }
          break;
     case 'C':
          if (esgptr->msg.flags&ISSHDR) {
               errmsg(NOFCSH);
          }
          else {
               cpytck=sigtck;
               if (esgptr->msg.flags&FILATT) {
                    cpytck+=sattck;
               }
               if (credok(1,cpytck)) {
                    prompt(OPCPY1);
               }
          }
          break;
     case 'T':
          estabc();
          esgptr->msg.flags|=EXEMPT;
          upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
          prfmsg(XMPCNF);
          gorep();
          break;
     case 'U':
          estabc();
          esgptr->msg.flags&=~EXEMPT;
          upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
          prfmsg(UXMCNF);
          gorep();
          break;
     case 'E':
          if (esgptr->msg.flags&ISSHDR) {
               errmsg(NDELHD);
          }
          else if (esgcfl()) {
               errmsg(USING);
          }
          else {
               prfmsg(OKGONE,l2as(esgptr->msg.msgno));
               delsms();
          }
          break;
     case 'M':
          estabc();
          esgmod(modurs);
          break;
     case 'A':
          if (esgstt == REPOPA) {
               estabc();
               esgptr->msg.flags|=APPVED;
               upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
               sigoff(esgptr->usigno)->nw4app--;
               sigoff(esgptr->usigno)->nfiles++;
               prfmsg(APVCNF);
               gorep();
               break;
          }
     default:
          errmsg(HUH);
     }
}

void
modurs(save)                  /* modify finish-up during a scan            */
int save;
{
     if (save) {
          wrtmod();
     }
     else {
          prfmsg(WABORT);
     }
     sgonext();
}

void
srpdun(save)                  /* sig reply done, possible attachment?      */
int save;
{
     if (save) {
          possat(sradun);
     }
     else {
          prfmsg(WABORT);
          sgonext();
     }
}

void
serdun(save)                  /* email reply done, possible attachment?    */
int save;
{
     if (save) {
          possat(eradun);
     }
     else {
          prfmsg(WABORT);
          sgonext();
     }
}

void
eradun(void)                  /* return receipt requested?                 */
{
     if (askrrr) {
          prompt(RRRQ);
     }
     else {
          sradun();
     }
}

void
ssrrrq(void)                  /* state: return receipt requested?          */
{
     switch (cncyesno()) {
     case 'Y':
          if (!credok(hasmkey(RRRKEY),rrrtck)) {
               break;
          }
          esgptr->msg.flags|=RECREQ;
     case 'N':
          sradun();
          break;
     default:
          errmsg(YORN);
     }
}

void
sradun(void)                  /* sig reply attachment done, proceed        */
{
     int addrep=0;
     long temp,ultdest;

     if (esgptr->msg.to[0] == SIGIDC) {
          addrep=1;
     }
     if (esgptr->msg.flags&MHSMSG) {
          sendmhs();
          prfmsg(SNTMHS);
          outprf(usrnum);
          clrprf();
     }
     else {
          postwc();
     }
     cncall();
     temp=esgptr->fpos;
     sgonext();
     ultdest=esgptr->fpos;
     esgptr->fpos=temp;
     estabc();
     if (addrep) {
          esgptr->msg.nreply++;
     }
     if (sameas(usaptr->userid,esgptr->msg.userto) && qscptr->flags&CWHENR) {
          esgptr->msg.userto[0]=clrchr(esgptr->msg.userto[0]);
     }
     upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
     esgptr->fpos=ultdest;
     estaab();
/*
 *   The following 4 lines get us out if the Forum message just replied
 *      to was replied to from E-mail, and it was the very last message
 *      in the user's TO YOU scan.  (Omitting this code means if the guy
 *      hits (P)revious, he'll be scanning through his CLEARED mail.)
 */
     if (usrptr->state == emlstt && ultdest == temp) {
          clrprf();
          blwoff(RPREND);
     }
}

void
postwc(void)                  /* post SIG msg (with blank-check)           */
{
     if (esgptr->msg.text[1] != '\0' || (esgptr->msg.flags&FILATT)) {
          postit();
          sigmhs();
          stdcnf();
     }
}

void
sthrfbp(void)                 /* state: thread forwd, backwd, or parent?   */
{
     char *sptr;

     if (esgptr->prethr == 0L) {
          esgptr->prethr=esgptr->fpos;
          esgptr->pthkyn=esgptr->keynum;
          esgptr->keynum=TOTOPIC;
     }
     switch (cncchr()) {
     case '?':
          prohlp(FBPHLP);
          break;
     case 'F':
          thrutl(1);
          break;
     case 'B':
          thrutl(0);
          break;
     case 'P':
          esgstt=scoscd();
          sptr=esgptr->msg.auxtpc;
          if (sameto("Rep",sptr)) {
               while (!isdigit(*sptr) && *sptr != '\0') {
                    sptr++;
               }
               strcpy(compos.userid,esgptr->msg.to);
               compos.msgno=atol(sptr);
               if (acqbtv(&esgptr->msg,&compos,TONUM)) {
                    sumscn(0);
               }
               else {
                    errmsg(THPNF,l2as(compos.msgno));
               }
          }
          else {
               errmsg(THPNRP);
          }
          break;
     default:
          errmsg(HUH);
     }
}

void
thrutl(fwd)                   /* thread forward/backward utility           */
int fwd;
{
     char savtpc[TPCSIZ];

     estabc();
     strcpy(savtpc,esgptr->msg.topic);
     if (fwd ? anibtv(&esgptr->msg) : apibtv(&esgptr->msg)) {
          if (strncmp(esgptr->msg.topic,savtpc,25) == 0) {
               sumscn(0);
               return;
          }
     }
     estabc();
     esgstt=scoscd();
     errmsg(fwd ? THFEND : THBBGN);
}

void
sopfwd(void)                  /* state: Sysop/SIG-Op forward msg to who?   */
{
     if (mhsact && hasmkey(MHSKEY) && valmhs(nxtcmd)) {
          esgptr->sflags|=MHSORG;
          sdtptr=sigoff(esgptr->usigno);
          fwdit(NULL,0);
          delsms();
          esgptr->sflags&=~MHSORG;
          cncall();
     }
     else if (validwr(*nxtcmd == SIGIDC ? cncsig() : cncall())) {
          if (esgcfl()) {
               errmsg(USING);
          }
          else {
               fwdit(uidxrf.userid,0);
               delsms();
          }
     }
}

void
sopcpy(void)                  /* state: Sysop/SIG-Op copy msg to who?      */
{
     if (mhsact && hasmkey(MHSKEY) && valmhs(nxtcmd)) {
          stzcpy(esgptr->mhs.addr,nxtcmd,MHSADR);
          esgptr->sflags|=MHSORG;
          sdtptr=sigoff(esgptr->usigno);
          setwhn(cpsdun);
          if (fwdit(NULL,1)) {
               cncall();
               pstcpy();
          }
          esgptr->sflags&=~MHSORG;
     }
     else if (validwr(*nxtcmd == SIGIDC ? cncsig() : cncall())) {
          esgptr->mhs.addr[0]='\0';
          if (esgcfl()) {
               errmsg(USING);
          }
          else {
               setwhn(cpsdun);
               if (fwdit(uidxrf.userid,1)) {
                    pstcpy();
               }
               cncall();
          }
     }
}

void
pstcpy(void)                  /* re-establish position when copy is done   */
{
     int cpytck;

     cpytck=sigtck;
     if ((esgptr->msg.flags&FILATT) && !(esgptr->sflags&MHSORG)) {
          cpytck+=sattck;
     }
     dedcrd(cpytck,1);
     if (usrptr->state == emlstt) {
          oncors();
          estabc();
          if (anibtv(&esgptr->msg)) {
               esgptr->fpos=absbtv();
               if (estaab()) {
                    sumnew();
               }
               else {
                    blwoff(WOWEE);
               }
          }
          else {
               blwoff(RPREND);
          }
     }
     else {
          estabc();
          esgptr->prethr=0L;
          asig((esgptr->sflags&SCN4UA) ? LASTM : esgptr->msg.msgno);
          sgonext();
     }
}

void
delsms(void)                  /* delete a SIG msg utility                  */
{
     long temp,ultdest;

     cncall();
     if (usrptr->state == emlstt) {
          temp=esgptr->fpos;
          oncors();
          estabc();
          if (anibtv(&esgptr->msg)) {
               ultdest=absbtv();
               esgptr->fpos=temp;
               estabc();
               delmsg();
               esgptr->fpos=ultdest;
               if (estaab()) {
                    sumnew();
               }
               else {
                    blwoff(WOWEE);
               }
          }
          else {
               esgptr->fpos=temp;
               estabc();
               delmsg();
               blwoff(RPREND);
          }
     }
     else {
          estabc();
          delmsg();
          esgptr->prethr=0L;
          asig((esgptr->sflags&SCN4UA) ? LASTM : esgptr->msg.msgno);
          sgonext();
     }
}

void
slistyp(void)                 /* state: what listing mode?                 */
{
     switch (cncchr()) {
     case '?':
          prohlp(LTPHLP);
          break;
     case 'F':
          esgptr->sflags|=SCNFTX;
     case 'T':
          esgptr->sflags|=SCN2LT;
     case 'B':
          if (esgptr->sflags&SCNQUI) {
               prfmsg(LSTNHD);
               fupqsn(LISTNG,SCNQUI);
          }
          else {
               prompt(STARTL);
          }
          break;
     default:
          errmsg(HUH);
     }
}

void
sstartl(void)                 /* state: start listing at what msg number?  */
{
     if (strtup(RTLHLP)) {
          esgstt=LISTNG;
          prfmsg(LSTNHD);
          if (!(esgptr->sflags&SCN2LT)) {
               prf("\r");
          }
          evlals();
          bgncyc();
     }
}

void
srquick(void)                 /* state: read quickscan menu                */
{
     switch (cncchr()) {
     case '?':
          prohlp(RQLHLP);
          break;
     case 'K':
          fupqsn(SRCHNG,SCNQUI+SCNNXT+SCNKWD);
          break;
     case 'S':
          fupqsn(SCANNG,SCNQUI+SCNNXT);
          break;
     case 'L':
          esgptr->sflags|=SCNQUI;
          prompt(LISTYP);
          break;
     case 'C':
          prompt(QUICKC);
          break;
     default:
          errmsg(HUH);
     }
}

void
fupqs(qsprmt,flags)           /* fire up (quick) scan, involving cycling   */
int qsprmt,flags;
{
     esgptr->sflags|=flags;
     esgptr->sflags&=~FNDMSG;
     prompt(qsprmt);
     bgncyc();
}

void
fupqsn(qsprmt,flags)          /* fire up (quick) scan without prompt       */
int qsprmt,flags;
{
     esgptr->sflags|=flags;
     esgstt=qsprmt;
     esgptr->dftinp='\0';
     bgncyc();
}

void
squickc(void)                 /* state: quickscan configuring, + or -?     */
{
     switch (cncchr()) {
     case '?':
          cncall();
          prfmsg(QCHELP);
          prompt(QUICKC4);
          break;
     case 'V':
          prompt(QUICKC);
          break;
     case '+':
          prompt(QCADD);
          break;
     case '-':
          prompt(QCDEL);
          break;
     case 'K':
          prompt(QCKWDS);
          break;
     default:
          errmsg(HUH);
     }
}

void
sqcadd(void)                  /* state: quickscan config, add a SIG to list*/
{
     int sn,firsch;
     char *cp;

     if ((firsch=morcnc()) == '?') {
          lissgs(rprqca);
     }
     else if (sameas(cp=cncsig(),"/ALL") && isalpha(firsch)) {
          for (sn=0 ; sn < nsigs ; sn++) {
               if (margc > 1 && sameas(margv[1],"+ALL")) {
                    LSOFAR[sn]=sv.msgtot;
               }
               else if (LSOFAR[sn] < 0) {
                    LSOFAR[sn]=0;
               }
          }
          cncall();
          prompt(QUICKC4);
     }
     else if ((sn=findsig(cp)) == NOSIG) {
          errmsg(SLSNXI);
     }
     else {
          if (LSOFAR[sn] >= 0) {
               LSOFAR[sn]=sv.msgtot;
          }
          else {
               LSOFAR[sn]=0;
          }
          prompt(QUICKC4);
     }
}

void
rprqca(void)                  /* reprompt after sig list under sqcadd()    */
{
     prompt(QCADD);
}

void
sqcdel(void)                  /* state: quickscan config, delete what sig? */
{
     int sn,firsch;
     char *cp;

     firsch=morcnc();
     if (sameas(cp=cncsig(),"/ALL") && isalpha(firsch)) {
          for (sn=0 ; sn < nsigs ; sn++) {
               LSOFAR[sn]=-1;
          }
          prompt(QUICKC4);
     }
     else if ((sn=findsig(cp)) == NOSIG || LSOFAR[sn] < 0) {
          esgstt=QUICKC;
          errmsg(QCDERR);
     }
     else {
          LSOFAR[sn]=-1;
          prompt(QUICKC4);
     }
}

void
sqckwds(void)                 /* state: quickscan config keywords, which 1?*/
{
     switch (esgptr->blknum=cncchr()) {
     case '?':
          cncall();
          prfmsg(QCKWDH);
          prompt(QCKWDS);
          break;
     case '1':
     case '2':
     case '3':
     case '4':
     case '5':
          prompt(QCSRKY);
          btumil(usrnum,MXKWLN-1);
          break;
     default:
          errmsg(HUH);
     }
}

void
sqcsrky(void)                 /* state: quickscan config new keyword entry */
{
     if (margc == 0) {
          if (input[0] == '\0') {
               prohlp(QCSRKYH);
               return;
          }
          morcnc();
     }
     else if (morcnc() == '?') {
          prohlp(QCSRKYH);
          return;
     }
     movmem(cncall(),qscptr->qskwds[esgptr->blknum-'1'],MXKWLN-1);
     btumil(usrnum,DFTIMX);
     prompt(QCKWDS);
}

int
qsignx(idx)                   /* quickscan SIG list: next SIG no.?    */
int idx;
{
     while (idx < nsigs) {
          if (LSOFAR[idx] >= 0L) {
               if (rdautl(idx) > NOAXES) {
                    return(idx);
               }
          }
          idx++;
     }
     return(NOSIG);
}

int
scoscd(void)                  /* return SCOSIG or SCDSIG, dep on att'ment  */
{
     if ((esgptr->msg.flags&(FILATT+APPVED)) == FILATT+APPVED
       && readac() >= DLAXES) {
          return(SCDSIG);
     }
     return(SCOSIG);
}

void
lissgs(whndun)                /* list-sigs utility, when done invoke whndun*/
void (*whndun)();
{
     cncall();
     esgptr->usigno=-1;
     esgptr->whndun=whndun;
     prompt(SLSTTL);
     bgncyc();
}

void
bgncyc(void)                  /* begin cycling                             */
{
     cycmed();
     prf("");
}

void
cycmed(void)                  /* cycle mediator, called from emsthn()      */
{
     int instt,smslif,bufndd;
     char *chcred();

     if (esgstt == MMINF || (esgstt == LISTNG && (esgptr->sflags&SCNFTX))) {
          bufndd=outbsz-2;
     }
     else {
          bufndd=outbsz-2-1024;         /* (this way we don't get more than */
     }                                  /*   a K "ahead of ourselves")      */
     if (btuoba(usrnum) > bufndd) {
          instt=esgstt;
          switch (esgstt) {
          case MMINF:
               sdtptr=sigoff(esgptr->usigno);
               prfmsg(SINFO,accstg[readac()],
                            sdtptr->sigop,
                            chcred(usrptr->crdrat),
                            chcred(esgptr->sigtck),
                            chcred(esgptr->sattck),
                            esgptr->sattck > 0 ? "rebate" : "bonus");
               smslif=sigopt("message-lifetime:",siglif);
               prfmsg(smslif >= 0 ? INFSLM : INFSUL,smslif);
               prfmsg(FHLPTRL);
               cncall();
               prompt(MMENU);
               break;
          case SRCHNG:
          case SCANNG:
          case SCANAP:
               vnxmsg();
               break;
          case LISTNG:
               listms();
               break;
          case SLSTTL:
               lsnams();
               break;
          case CPYING:
               copysm();
               break;
          default:
               return;
          }
          outprf(usrnum);
          if (esgptr->sflags&LONFIN) {
               esgstt=usrptr->substt=LONFIN;
               btuinj(usrnum,CRSTG);
          }
          if (esgstt != instt) {
               return;
          }
     }
     cncall();
     btuinj(usrnum,CYCLE);
}

char *
chcred(amt)                   /* generate charge-amount phrase for info    */
int amt;
{
     char *retval;

     if (amt == 0) {
          retval="not charged at all";
     }
     else if (amt > 0) {
          retval=spr("charged %d credits",amt);
     }
     else {
          retval=spr("given %d credits",-amt);
     }
     return(retval);
}

void
copysm(void)                  /* copy some data from src to dest (cycled)  */
{
     int i,c;

     for (i=0 ; i < 512 ; i++) {
          if ((c=fgetc(esgptr->fp)) == EOF) {
               cpyoff();
               (*esgptr->whndun)();
               return;
          }
          fputc(c,esgptr->fpout);
     }
     prf(".");
}

void
lsnams(void)                  /* list SIG names (one at a time, cycled)    */
{
     while (++(esgptr->usigno) < nsigs) {
          if (readac() != NOAXES) {
               sdtptr=sigoff(esgptr->usigno);
               prfmsg(SLSLIN,sdtptr->signam,sdtptr->nmsgs,sdtptr->nfiles,
                      sdtptr->sigop,sdtptr->descrp);
               return;
          }
     }
     esgptr->usigno=qscptr->cursig;
     prfmsg(SLSTRL);
     (*esgptr->whndun)();
}

void
listms(void)                  /* list msgs, quickscan or regular (cycled)  */
{
     if (esgptr->sflags&SCNQUI) {
          if (esgptr->sflags&SCNCIS) {
               estabc();
               if (anibtv(&esgptr->msg)) {
                    evlals();
                    return;
               }
               esgptr->sflags&=~SCNCIS;
          }
          switch (nxtqs(qslidx())) {
          case FOUND:
               evlals();
               esgptr->sflags|=SCNCIS;
               break;
          case KEEPON:
               break;
          case DONE:
               prfmsg(ENDQSL);
               abostf();
               break;
          }
     }
     else {
          estabc();
          if (anibtv(&esgptr->msg)) {
               evlals();
          }
          else {
               prfmsg(ENDOFL);
               abostf();
          }
     }
}

void
vnxmsg(void)                  /* validate next msg (cycled scans & kwdsr)  */
{
     switch (esgptr->sflags&(SCNQUI+SCNNXT+SCNCIS)) {
     case 0:
     case SCNNXT:
          esgptr->sflags|=SCNCIS;
          evlams();
          break;
     case SCNCIS:
          estabc();
          if (apibtv(&esgptr->msg)) {
               evlams();
          }
          else {
               estabc();
               cncall();
               if (esgptr->sflags&FNDMSG) {
                    prompt(SCNBGN);
                    esgstt=scoscd();
               }
               else {
                    prfmsg(EOSCAN);
                    abostf();
               }
          }
          break;
     case SCNNXT+SCNCIS:
          estabc();
          if (anibtv(&esgptr->msg)) {
               evlams();
          }
          else {
               estabc();
               cncall();
               if (esgptr->sflags&FNDMSG) {
                    prompt(SCNEND);
                    esgstt=scoscd();
               }
               else {
                    prfmsg(EOSCAN);
                    abostf();
               }
          }
          break;
     case SCNQUI+SCNNXT:
          switch (nxtqs(qslidx())) {
          case FOUND:
               evlams();
               esgptr->sflags|=SCNCIS;
               break;
          case KEEPON:
               break;
          case DONE:
               prfmsg(QSCMPL);
               abostf();
               break;
          }
          break;
     case SCNQUI+SCNNXT+SCNCIS:
          estabc();
          if (anibtv(&esgptr->msg)) {
               evlams();
          }
          else {
               prf(".");
               esgptr->sflags&=~SCNCIS;
          }
          break;
     default:
          catastro("VNXMSG: PREV/QSCAN!");
     }
}

int
qslidx(void)                  /* quickscan last index, plus 1 (0 if none)  */
{
     int retval;

     if (!(esgptr->sflags&SCNCIQ)) {
          retval=0;
          esgptr->sflags|=SCNCIQ;
     }
     else {
          retval=esgptr->usigno+1;
     }
     return(retval);
}

void
evlams(void)                  /* evaluate a msg for possible scan halt     */
{
     int phit;

     if (kwdmat()) {
          phit=(((esgptr->sflags&SCNNXT) == 0)^((esgptr->sflags&SCN4UA) != 0));
          sumscn(phit);
          esgptr->sflags|=FNDMSG;
          if (esgptr->sflags&SCNQUI) {
               movmem(esgptr->prvpos,esgptr->prvpos+1,(NPREVS-1)*sizeof(long));
               esgptr->prvpos[0]=esgptr->fpos;
          }
     }
     else {
          esgptr->fpos=absbtv();
          prf(".");
     }
}

void
evlals(void)                  /* evaluate a listing for poss display       */
{
     char *prepbp;

     esgptr->fpos=absbtv();
     if (!(esgptr->sflags&SCN4AT) || (esgptr->msg.flags&APPVED)) {
          switch (esgptr->sflags&(SCN2LT+SCNFTX)) {
          case 0:
               prepbp=prfptr;
               prfmsg(BRFLST,
                 spr(spr("%%%dld",strlen(l2as(sv.msgtot))),esgptr->msg.msgno),
                 ncedat(esgptr->msg.crdate),
                 esgptr->msg.topic,
                 esgptr->msg.from);
               if (noalen(prepbp) > 79) {
                    trcans(prepbp,79);
                    prfptr=&prfbuf[strlen(prfbuf)];
               }
               break;
          case SCN2LT:
               sumams();
               break;
          case SCN2LT+SCNFTX:
               sumams();
               outprf(usrnum);
               prf("");
               xtext();
               break;
          }
     }
     else {
          prf((esgptr->sflags&SCN2LT) ? "." : "");
     }
}

STATIC void
trcans(stg,len)                    /* truncate a stg to x NON-ANSI bytes   */
char *stg;                              /* string to truncate              */
int len;                                /* # of NON-ANSI bytes to trunc to */
{
     int inans=0,i=0;

     while (*stg != '\0') {
          if (inans && isalpha(*stg)) {
               inans=0;
          }
          else if (*stg == 27) {
               inans=1;
          }
          else if (!inans && i++ == (len-2)) {
               *stg++='*';
               *stg++='\r';
               *stg='\0';
               return;
          }
          stg++;
     }
}

int
nxtqs(nxtidx)                 /* next quickscan activity FOUND/KEEPON/DONE */
int nxtidx;
{
     if (nxtidx < nsigs && (nxtidx=qsignx(nxtidx)) != NOSIG) {
          esgptr->usigno=nxtidx;
          compos.msgno=LSOFAR[nxtidx];
          strcpy(compos.userid,sigoff(nxtidx)->signam);
          prompt(esgstt);
          if (agtbtv(&esgptr->msg,&compos,TONUM)
            && sameas(esgptr->msg.to,compos.userid)) {
               esgptr->fpos=absbtv();
               return(FOUND);
          }
          return(KEEPON);
     }
     return(DONE);
}

int
kwdmat(void)                  /* keyword match current msg (genly qualify) */
{
     int i,flags;
     char *kwlptr;

     flags=esgptr->sflags;
     if (flags&SCN4UA) {
          return((esgptr->msg.flags&(FILATT+APPVED)) == FILATT);
     }
     if ((flags&SCN4AT) && !(esgptr->msg.flags&APPVED)) {
          return(0);
     }
     if (!(flags&SCNKWD)) {
          return(1);
     }
     if (prfptr != prfbuf) {
          outprf(usrnum);
     }
     sumams();
     prfptr=prfbuf;
     if (flags&SCNQUI) {
          for (i=0 ; i < NQSKWG ; i++) {
               if (*(kwlptr=qscptr->qskwds[i]) != '\0' && kwdchk(kwlptr)) {
                    prfmsg(FNDQSK,kwlptr);
                    return(1);
               }
          }
          return(0);
     }
     return(kwdchk(esgptr->keywds));
}

int
kwdchk(list)                  /* check if this compound keyword matches    */
char *list;
{
     int i;

     strcpy(input,list);
     parsin();
     cncall();
     for (i=0 ; i < margc ; i++) {
          if (!findstg(margv[i],prfbuf)
            && !findstg(margv[i],esgptr->msg.text)) {
               return(0);
          }
     }
     return(1);
}

void
pstdun(save)                  /* post-to-SIG done, possible attachment?    */
int save;
{
     if (save) {
          strcpy(esgptr->msg.to,sigoff(esgptr->usigno)->signam);
          possat(attdun);
     }
     else {
          prfmsg(WABORT);
          prompt(MMENU);
     }
}

void
setwhn(whndun)                /* set "return address" for when done        */
void (*whndun)();
{
     esgptr->whndun=whndun;
}

void
attdun(void)                  /* attachment processing done, post SIG msg  */
{
     postwc();
     cncall();
     prompt(MMENU);
}

void
sselsig(void)                 /* state: select new SIG, enter name?        */
{
     int signo;

     if (morcnc() == '?') {
          lissgs(pmtssg);
     }
     else if ((signo=findsig(cncsig())) == NOSIG) {
          errmsg(SLSNXI);
     }
     else {
          joinsg(signo);
     }
}

void
pmtssg(void)                  /* re-prompt after SIG list under sselsig()  */
{
     prompt(SELSIG);
}

void
joinsg(signo)                 /* join a SIG                                */
int signo;
{
     int oidx;

     esgptr->usigno=qscptr->cursig=signo;
     asig(FIRSTM);
     usrptr->crdrat=sigopt("credit-consumption-rate:",sigccr);
     esgptr->sigtck=sigopt("charge-per-message-posted:",sigtck);
     esgptr->sattck=sigopt("charge-per-file-uploaded:",sattck);
     if ((oidx=findstg("thoughts-of-the-day:",esgptr->msg.text)) > 0 &&
         !(usrptr->flags&CONCEX)) {
          prfmsg(TODHDR);
          prf("%s\r",esgptr->msg.text+oidx);
          prfmsg(TODTRL);
     }
     prompt(readac() >= OPAXES ? OPSTART : (stlcop ? SSTART : NTSSTART));
}

int
sigopt(idstg,dftval)          /* find a SIG option in intro message        */
char *idstg;
int dftval;
{
     int oidx;

     if ((oidx=findstg(idstg,esgptr->msg.text)) > 0) {
          return(atoi(esgptr->msg.text+oidx));
     }
     return(dftval);
}

void
asig(msgnum)                  /* acquire highest msg <= msgnum in this SIG */
long msgnum;
{
     if (!alomsg(TONUM,msgnum)) {
          catastro("ASIG: NO FORUM #%d",esgptr->usigno);
     }
}

int
readac(void)                  /* read access level, curr guy, curr SIG     */
{
     return(rdautl(esgptr->usigno));
}

int
saxxok(signo)                 /* SIG access is ok (for external modules)   */
int signo;
{
     if (signo < 0 || signo >= nsigs) {
          return(1);
     }
     qscptr=qscoff(usrnum);
     iniqsc();
     return(rdautl(signo) > NOAXES);
}

void
alcsig(void)                       /* allocate sig data array              */
{
     sigblok=alcblok(nsigs,sizeof(struct sigdat));
}

struct sigdat *
sigoff(signo)                 /* get offset for sigdat structure           */
int signo;                         /* sig number to get offset for         */
{
     return((struct sigdat *)ptrblok(sigblok,signo));
}

void
alcqsc(void)                       /* allocate quickscan data structures   */
{
     qscsiz=sizeof(struct qscfg)+sizeof(long)*nsigs+(nsigs+1)/2;
     qscblok=alcblok(nterms,qscsiz);
}

struct qscfg *
qscoff(unum)                       /* qscptr calculation routine           */
int unum;
{
     return((struct qscfg *)ptrblok(qscblok,unum));
}

int
rdautl(signo)                 /* read access level, curr guy, another SIG  */
int signo;
{
     if (signo >= nsigs || sigoff(signo)->signam[0] == '\0') {
          return(NOAXES);
     }
     if (haskey(sigsys)) {
          return(SYAXES);
     }
     return(alvutl(qscptr,signo));
}

int
rdoutl(userid)                /* read access level, another guy, curr SIG  */
char *userid;
{
     struct qscfg *othuqp;

     if ((othuqp=getqsc(userid,sopqsc)) == NULL) {
          return(NOTSET);
     }
     if (onsysn(userid,1)) {
          if (othkey(sigsys)) {
               return(SYAXES);
          }
     }
     else if (uidkey(userid,sigsys)) {
          return(SYAXES);
     }
     return(alvutl(othuqp,esgptr->usigno));
}

struct qscfg *
getqsc(userid,sopqsc)         /* point at qscfg, either online or disk     */
char *userid;
struct qscfg *sopqsc;
{
     struct qscfg *othuqp;

     if (onsqsc(userid)) {
          othuqp=qscoff(othusn);
     }
     else {
          setbtv(accbb);
          if (!acqbtv(sopusa,userid,0)) {
               setbtv(esgbb);
               return(NULL);
          }
          setbtv(esgbb);
          iqscfg(sopqsc,userid);
          othuap=sopusa;
          othuqp=sopqsc;
     }
     strcpy(userid,othuqp->userid);
     return(othuqp);
}

int
alvutl(othuqp,signo)          /* access level sense utility                */
struct qscfg *othuqp;
int signo;
{
     int setval,maxval,retval;
     int hask;
     char reqkey[KEYSIZ];

     stzcpy(reqkey,sigoff(signo)->sigloc,KEYSIZ);
     if (reqkey[0] == '\0') {
          stzcpy(reqkey,sigprv,KEYSIZ);
     }
     if (onsysn(othuqp->userid,1)) {
          hask=othkey(reqkey);
     }
     else {
          hask=uidkey(othuqp->userid,reqkey);
     }
     if ((setval=acclvl(othuqp->acclso,signo)) == NOTSET) {
          retval=acclvl((hask ? dftliv : dftnlv),signo);
     }
     else if (!hask && setval > (maxval=acclvl(maxnlv,signo))) {
          retval=maxval;
     }
     else {
          retval=setval;
     }
     if (retval == NOAXES && sameas(sigoff(signo)->signam,dftsig)) {
          return(RDAXES);
     }
     return(retval);
}

int
dftlvl(array)                 /* get default access lvl, curr SIG          */
char *array;
{
     return(acclvl(array,esgptr->usigno));
}

void
writac(userid,value)          /* write an access level for spec'd user     */
char *userid;
int value;
{
     int oldval;

     if (value == OPAXES) {
          mksigo(userid,NOTSET);
          if (onsys(userid) && !(usrptr->flags&INVISB)) {
               prfmlt(UNOWOP,sigoff(esgptr->usigno)->signam);
               injoth();
               prfmsg(SNOTIFD,userid);
          }
     }
     else {
          oldval=rdoutl(userid);
          if (oldval == OPAXES && value < OPAXES) {
               mksigo(usaptr->userid,value);
          }
          else if (onsqsc(userid)) {
               wracar(qscoff(othusn)->acclso,value);
               if ((value=rdoutl(userid)) != oldval
                 && !(usrptr->flags&INVISB)) {
                    prfmlt(UNEWAC,usaptr->userid,accstg[value],
                                  sigoff(esgptr->usigno)->signam);
                    injoth();
                    prfmsg(SNOTIFD,userid);
               }
          }
          else {
               iqscfg(sopqsc,userid);
               wracar(sopqsc->acclso,value);
               setbtv(qscbb);
               upvbtv(sopqsc,qscsiz);
               setbtv(esgbb);
          }
     }
}

void
mksigo(userid,oldgac)         /* make userid the SIG-Op of current SIG     */
char *userid;                      /* user-id to make the new sig-op       */
int oldgac;                        /* what access to grant the old sig-op  */
{
     if (!sameas(userid,sigoff(esgptr->usigno)->sigop)) {
          stzcpy(tmpqsc->userid,sigoff(esgptr->usigno)->sigop,UIDSIZ);
          if (isuidc(tmpqsc->userid[0])) {
               if (onsqsc(tmpqsc->userid)) {
                    wracar(qscoff(othusn)->acclso,oldgac);
                    if (!sameas(tmpqsc->userid,usaptr->userid) &&
                        !(usrptr->flags&INVISB)) {
                         prfmlt(UNEWAC,usaptr->userid,accstg[oldgac],
                                       sigoff(esgptr->usigno)->signam);
                         injoth();
                         prfmsg(SNOTIFD,tmpqsc->userid);
                         outprf(usrnum);
                    }
               }
               else {
                    iqscfg(sopqsc,tmpqsc->userid);
                    wracar(sopqsc->acclso,oldgac);
                    setbtv(qscbb);
                    upvbtv(sopqsc,qscsiz);
               }
               setbtv(esgbb);
          }
     }
     strcpy(sigoff(esgptr->usigno)->sigop,userid);
     asig(FIRSTM);
     strcpy(esgptr->msg.from,userid);
     upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
     if (onsqsc(userid)) {
          wracar(qscoff(othusn)->acclso,OPAXES);
     }
     else {
          iqscfg(sopqsc,userid);
          wracar(sopqsc->acclso,OPAXES);
          setbtv(qscbb);
          upvbtv(sopqsc,qscsiz);
     }
     setbtv(esgbb);
}

void
wracar(acarpt,value)          /* write an access level to a spec'd array   */
char *acarpt;
int value;
{
     wracut(acarpt,value,esgptr->usigno);
}

void
wracut(acarpt,value,signo)    /* write-access-level utility                */
char *acarpt;
int value,signo;
{
     char *cp;

     cp=&acarpt[signo>>1];
     if (signo&1) {
          *cp&=0x0F;
          *cp|=value<<4;
     }
     else {
          *cp&=0xF0;
          *cp|=value;
     }
}

void
sigdla(uid)                   /* SIG account-delete vector                 */
char *uid;
{
     int i;

     setbtv(qscbb);
     if (acqbtv(NULL,uid,0)) {
          delbtv();
     }
     for (i=0 ; i < nsigs ; i++) {
          sdtptr=sigoff(i);
          if (sameas(uid,sdtptr->sigop)) {
               stzcpy(sdtptr->sigop,"Sysop",UIDSIZ);
          }
     }
}

void
clssig(void)                  /* close down SIG activity, system shutdown  */
{
     struct sighdr *tmp;

     if (esgbb != NULL) {
          setbtv(esgbb);
          tmp=(struct sighdr *)alcmem(sizeof(struct sighdr)+msgbyts);
          strcpy(compos.userid,"/");
          ggtbtv(tmp,&compos,TONUM);
          do {
               if (tmp->signo >= nsigs || !(tmp->flags&ISSHDR)) {
                    catastro("CLSSIG: BAD HDR #%u",tmp->signo);
               }
               strcpy(tmp->from,sigoff(tmp->signo)->sigop);
               strcpy(tmp->to,sigoff(tmp->signo)->signam);
               stzcpy(tmp->sigloc,sigoff(tmp->signo)->sigloc,KEYSIZ);
               movmem(sigoff(tmp->signo)->descrp,tmp->topic,sizeof(struct sigdat)
                      -sizeof(char *)-UIDSIZ-SIGSIZ);
               tmp->dfnlv=acclvl(dftnlv,tmp->signo);
               tmp->dfliv=acclvl(dftliv,tmp->signo);
               tmp->mxnlv=acclvl(maxnlv,tmp->signo);
               upvbtv(tmp,NVMSIZ+strlen(tmp->text));
               strcpy(compos.userid,tmp->to);
               compos.msgno=-1L;
          } while (agtbtv(tmp,&compos,TONUM) && tmp->to[0] == SIGIDC);
          free(tmp);
          clsbtv(esgbb);
     }
     clsbtv(qscbb);
     clsmsg(esgmb);
}

