/***************************************************************************
 *                                                                         *
 *   PLSTUFF.H                                                             *
 *                                                                         *
 *   Copyright (C) 1992-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Galacticomm Fault-Tolerant GP handler and GP dump routines.           *
 *                                                                         *
 *                                    - Robert A. Rose 02/18/92            *
 *                                    - Robert N. Stein 12/29/92           *
 *                                                                         *
 ***************************************************************************/

extern char *dstname;              /* report file name (GP.OUT)            */
extern void *lastexcro;            /* address of last exception            */
extern int gphdlr;                 /* 0=report & abort, 1=silent & continue*/
extern unsigned gpcntr;            /* counter of GP's (reset if recovery)  */
extern unsigned gpslmt;            /* how many times to continue thru GP   */
extern int gpboot;                 /* Cold Boot after GP'ing 0=No 1=Yes    */
extern int prtdnam;                /* ok to print DLL name on screen 1=yes */

void protinit(                     /* initialize for protected mode        */
char *pgmname);                    /*   prog name (end with a space) or "" */
void loaddll(char *modnam);        /* load and link a DLL into memory      */
void initdlls();                   /* initialize all DLLs just loaded      */
void setgphand(char *title);       /* set the GP handler routine           */
void appgprept(void);              /* application-specific gp report       */
void appgprecd(void);              /* application-specific gp record       */

void *alctile(unsigned qty,unsigned size);
                                   /* allocate over 64K tiled memory region*/
void *ptrtile(void *bigptr,unsigned index);
                                   /* get address of a tile in tiled region*/
int pltile(unsigned long size,int bsel,unsigned stride,unsigned tsize);
                                   /* allocate Phar Lap tiled region       */

void plcatast(int plerr,char *msg);/* phar-lap catastro()                  */
void DosBlockIntr(void);           /* Block all interrupts at 8259         */
void DosUnblockIntr(void);         /* Unblock all interrupts at 8259       */
