/***************************************************************************
 *                                                                         *
 *   PLBTVSTF.C                                                            *
 *                                                                         *
 *   Copyright (C) 1987-1994 GALACTICOMM, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This file contains a library of routines for accessing BTRIEVE files  *
 *   with fixed or variable length records, compatible with the Phar Lap   *
 *   286 DOS extender protected mode environment.                          *
 *                                                                         *
 *                                            - T. Stryker 3/7/90          *
 *   Dup Ins/Upd, File Create, Misc others    - S. Brinker/R. Skurnick     *
 *   Phar Lap 286 Extender support            - R. A. Rose 12/19/91        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "plstuff.h"
#include "dos.h"

int _plmerror=0;              /* Last Phar Lap Memory Error                */

extern
jmp_buf disaster;             /* master error-recovery longjmp save block  */

struct btvblk *bb;                      /* current btvu file pointer set   */
static struct btvblk *bbstk[BBSTSZ];    /* setbtv()/rstbtv() stack         */
static int status;                      /* status code returned by btvu()  */
static int bbomode=PRIMBV;              /* opnbtv() file-open mode         */
static char *gpbptr;                    /* general purpose buffer pointer  */
static int gpbseg;                      /* real-mode segment of the above  */
static int *statusptr;                  /* status code returned by btvu()  */
static int statusseg;                   /* real-mode segment of the above  */
static int lastlen;                     /* length of last record read in   */

struct filspc {               /* Btrieve STAT command file spec            */
     int reclen;
     int pagsiz;
     int numofx;
     long numofr;
     int flags;
     int reserved;
     int unupag;
};

struct keyspc {               /* Btrieve STAT command key specs            */
     int keypos;
     int keylen;
     int flags;
     long numofk;
     int dontcare;
     long reserved;
};
#define ANOSEG  0x10          /* keyspc.flags bit for key has another seg  */

struct statbf {               /* STAT command ret buf layout               */
     struct filspc fs;
     struct keyspc ks[SEGMAX];
     char altcol[265];
};

static
struct btvdat {   /* btrieve parameter block structure for use with INT 0x7B */
     int datbufoff;
     int datbufseg;
     int dbflen;
     int posp38off;
     int posp38seg;
     int posblkoff;
     int posblkseg;
     int funcno;
     int keyoff;
     int keyseg;
     char keylen;
     char keyno;
     int statptoff;
     int statptseg;
     int magic;
} *btvdatptr;
static int btvdatseg;              /* real-mode segment of the above       */

void eclint(int inum,REGS16 *regs);
char huge *plfarmalloc(unsigned long ln);
int btvu(int funcno,int datbufseg,int keyseg,int keyno,int rlen);
void maksur(int size);
int clckln(void);
STATIC void btverr(char *who);
STATIC void posbtverr(char *recptr,char *stg);

void
eclalcrem(                         /* allocate real-mode dynamic memory    */
int size,                          /*   (make both real seg and selector)  */
int *seg,
char **sel)
{
     SEL pmsel;
     int rv;

     DosBlockIntr();
     if ((rv=DosAllocRealSeg((ULONG)size,(PUSHORT)seg,&pmsel)) != 0) {
          DosUnblockIntr();
          catastro("REAL-MODE MEMORY POOL EXHAUSTED (rv=%d, %d bytes)",rv,size);
     }
     DosUnblockIntr();
     *sel=MK_FP(pmsel,0);
     return;
}

struct btvblk *
opnbtv(                            /* open a Btrieve file; return ptr.     */
char *filnam,                      /* name of file to open                 */
int maxlen)                        /* maximum length of recs in file       */
{
     int tptr;

     if (statusptr == NULL) {
          eclalcrem(sizeof(int),&statusseg,(char **)&statusptr);
          eclalcrem(sizeof(struct btvdat),&btvdatseg,(char **)&btvdatptr);
     }
     eclalcrem(sizeof(struct btvblk),&tptr,(char **)&bb);
     bb->realseg=tptr;

     bb->filnam=malloc(strlen(filnam)+1);
     strcpy(bb->filnam,filnam);
     bb->reclen=maxlen;
     eclalcrem(maxlen,&bb->dataseg,&bb->data);
     maksur(strlen(filnam)+1);
     strcpy(gpbptr,filnam);
     if (btvu(0,0,gpbseg,bbomode,bb->reclen) != 0) {
          btverr("OPEN");
     }
     eclalcrem(clckln(),&bb->keyseg,&bb->key);
     setbtv(bb);
     return(bb);
}

#define GPBP ((struct statbf *)gpbptr)

int
clckln(void)                  /* calculate all key lengths in curr file    */
{                             /*   (and return the max of them all)        */
     static int kbfseg=0;
     int i,keyno,klen,maxofa;
     char *tmp;

     if (kbfseg == 0) {
          eclalcrem(64,&kbfseg,&tmp);
     }
     maksur(sizeof(struct statbf));
     if (btvu(15,gpbseg,kbfseg,0,sizeof(struct statbf)) != 0) {
          btverr("STAT");
     }
     maxofa=0;
     for (i=0,keyno=0 ; keyno < GPBP->fs.numofx ; i++,keyno++) {
          klen=GPBP->ks[i].keylen;
          while (GPBP->ks[i].flags&ANOSEG) {
               klen+=GPBP->ks[++i].keylen;
          }
          bb->keylns[keyno]=klen;
          if (klen > maxofa) {
               maxofa=klen;
          }
     }
     return(maxofa+1);
}

void
maksur(                       /* make sure that gen purp buff is big enough*/
int size)
{
     static int gpbsiz=0;

     if (size > gpbsiz) {
          if (gpbsiz > 0) {
               free(gpbptr);
          }
          eclalcrem(size,&gpbseg,&gpbptr);
          gpbsiz=size;
     }
}

void
omdbtv(                       /* set opnbtv() file-open mode               */
int mode)                     /* mode in which to open the btrieve file    */
{
     bbomode=mode;
}

void
setbtv(                       /* set a Btrieve data block for use          */
struct btvblk *bbptr)         /* btrieve pointer to make current           */
{
     movmem(bbstk,bbstk+1,sizeof(struct btvblk *)*(BBSTSZ-1));
     *bbstk=bb;
     bb=bbptr;
}

void
rstbtv(void)                  /* restore last btrieve data block for use   */
{
     bb=*bbstk;
     movmem(bbstk+1,bbstk,sizeof(struct btvblk *)*(BBSTSZ-1));
}

int
qrybtv(                       /* query Btrieve operations utility          */
void *key,                    /* key value to use for query                */
int keynum,                   /* key number to query by                    */
int qryopt)                   /* what type of query operation to perform   */
{
     if (bb == NULL) {
          return(0);
     }
     if (key != NULL) {
          movmem(key,bb->key,bb->keylns[keynum]);
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if (btvu(qryopt,0,bb->keyseg,keynum,bb->reclen) != 0) {
          if (status == 4 || status == 9) {
               return(0);
          }
          btverr("QUERY");
     }
     return(1);
}

int
qnpbtv(                       /* query next/previous Btrieve utility       */
int getopt)                   /* what type of query option to perform      */
{
     if (bb == NULL) {
          return(0);
     }
     if (btvu(getopt-50,bb->dataseg,bb->keyseg,bb->lastkn,bb->reclen) != 0) {
          if (status == 4 || status == 9) {
               return(0);
          }
          posbtverr(NULL,"QUERY-NP");
     }
     return(1);
}

void
getbtv(                            /* get Btrieve operations utility       */
void *recptr,                      /* ptr to area to retrieve record into  */
void *key,                         /* key value to use for retrieve record */
int keynum,                        /* key number of key to work with       */
int getopt)                        /* get operation to be performed        */
{
     int recseg;

     if (bb == NULL) {
          return;
     }
     if (recptr == NULL) {
          recseg=bb->dataseg;
     }
     else {
          maksur(bb->reclen);
          recseg=gpbseg;
     }
     if (key != NULL && bb != NULL) {
          movmem(key,bb->key,bb->keylns[keynum]);
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if (btvu(getopt,recseg,bb->keyseg,keynum,bb->reclen) != 0) {
          posbtverr(recptr,"GET");
     }
     if (recptr != NULL) {
          movmem(gpbptr,recptr,btvdatptr->dbflen);
     }
}

STATIC void
posbtverr(                         /* possible btrieve error               */
char *recptr,                      /*  (don't crash on overflow, truncate) */
char *stg)
{
     if (status != 22) {
          btverr(stg);
     }
     if (recptr == NULL) {
          bb->data[bb->reclen-1]='\0';
     }
     else {
          gpbptr[bb->reclen-1]='\0';
     }
     status=0;
}

int
obtbtv(                            /* "acquire" Btrieve operations utiltiy */
void *recptr,                      /* ptr to area to retrieve record into  */
void *key,                         /* key value to use for retrieve record */
int keynum,                        /* key number of key to work with       */
int obtopt)                        /* get operation to be performed        */
{
     int recseg;

     if (bb == NULL) {
          return(0);
     }
     if (recptr == NULL) {
          recseg=bb->dataseg;
     }
     else {
          maksur(bb->reclen);
          recseg=gpbseg;
     }
     if (key != NULL && bb != NULL) {
          movmem(key,bb->key,bb->keylns[keynum]);
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if (btvu(obtopt,recseg,bb->keyseg,keynum,bb->reclen) != 0) {
          if (status == 4 || status == 9) {
               return(0);
          }
          posbtverr(recptr,"OBTAIN");
     }
     if (recptr != NULL) {
          movmem(gpbptr,recptr,btvdatptr->dbflen);
     }
     return(1);
}

int
anpbtv(                       /* "acquire" next/previous (case sensitive)  */
void *recptr,                 /* ptr to area to retrieve record into       */
int anpopt)                   /* operation to be performed                 */
{
     return(anpbtvl(recptr,1,anpopt));
}

int
anpbtvl(                      /* "acquire" next/previous Btrieve utility   */
void *recptr,                 /* ptr to area to retrieve record into       */
int chkcas,                   /* check case in strcmp() operation?         */
int anpopt)                   /* operation to be performed                 */
{
     if (bb == NULL) {
          return(0);
     }
     movmem(bb->key,bb->data,bb->keylns[bb->lastkn]);
     if (obtbtv(recptr,NULL,-1,anpopt)) {
          return(chkcas ? strcmp(bb->data,bb->key) == 0
                        : stricmp(bb->data,bb->key) == 0);
     }
     return(0);
}

int
llnbtv(void)                  /* return the length of the last record read */
{
     return(lastlen);
}

long
absbtv(void)                  /* return current Btrieve file position      */
{
     if (bb == NULL) {
          return(0L);
     }
     maksur(sizeof(long));
     if (btvu(22,gpbseg,0,0,sizeof(long)) != 0) {
          posbtverr(gpbptr,"ABSOLUTE");
     }
     return(*(long *)gpbptr);
}

void
gabbtv(                       /* get Btrieve record from a file position   */
void *recptr,                 /* ptr to area to retrieve record into       */
long abspos,                  /* absolute position to used for get-absolute*/
int keynum)                   /* key number to use for this get-absolute   */
{
     if (bb == NULL) {
          return;
     }
     if (!aabbtv(recptr,abspos,keynum)) {
          btverr("GET-ABSOLUTE");
     }
}

aabbtv(                       /* "acquire" a record from a file position   */
void *recptr,                 /* ptr to area to retrieve record into       */
long abspos,                  /* absolute position to used for acq-absolute*/
int keynum)                   /* key number to use for this acq-absolute   */
{
     int recseg;

     if (bb == NULL) {
          return(0);
     }
     if (recptr == NULL) {
          recseg=bb->dataseg;
          *(long *)(bb->data)=abspos;
     }
     else {
          maksur(bb->reclen);
          recseg=gpbseg;
          *(long *)gpbptr=abspos;
     }
     bb->lastkn=keynum;
     btvu(23,recseg,bb->keyseg,keynum,bb->reclen);
     if (status == 22) {
          if (recptr == NULL) {
               bb->data[bb->reclen-1]='\0';
          }
          else {
               gpbptr[bb->reclen-1]='\0';
          }
          status=0;
     }
     if (status == 0 && recptr != NULL) {
          movmem(gpbptr,recptr,btvdatptr->dbflen);
     }
     return(status == 0);
}

void
sabbtv(                       /* step "absolute" Btrieve operations        */
void *recptr)
{
     int recseg;

     if (bb == NULL) {
          return;
     }
     if (recptr == NULL) {
          recseg=bb->dataseg;
     }
     else {
          maksur(bb->reclen);
          recseg=gpbseg;
     }
     if (btvu(24,recseg,0,0,bb->reclen) != 0) {
          posbtverr(recptr,"STEP-ABSOLUTE");
     }
     if (recptr != NULL) {
          movmem(gpbptr,recptr,btvdatptr->dbflen);
     }
}

int
stpbtv(                       /* "step" based btrieve operations           */
void *recptr,                 /* ptr to area to retrieve record into       */
int stpopt)                   /* step option to be performed               */
{
     int recseg;

     if (recptr == NULL) {
          recseg=bb->dataseg;
     }
     else {
          maksur(bb->reclen);
          recseg=gpbseg;
     }
     if (btvu(stpopt,recseg,NULL,0,bb->reclen) != 0) {
          if (status == 9) {
               return(0);
          }
          else {
               btverr("STEP");
          }
     }
     if (recptr != NULL) {
          movmem(gpbptr,recptr,btvdatptr->dbflen);
     }
     return(1);
}

void
updbtv(                       /* "update" a Btrieve record                 */
void *recptr)                 /* ptr to area for record update             */
{
     upvbtv(recptr,bb->reclen);
}

void
upvbtv(                       /* "update" a variable-length Btrieve record */
void *recptr,                 /* ptr to area for record update             */
int length)                   /* length of data buffer for updating        */
{
     int recseg;

     if (bb == NULL) {
          return;
     }
     if (recptr == NULL) {
          recseg=bb->dataseg;
     }
     else {
          maksur(length);
          movmem(recptr,gpbptr,length);
          recseg=gpbseg;
     }
     if (btvu(3,recseg,bb->keyseg,bb->lastkn,length) != 0) {
          btverr("UPDATE");
     }
}

int
dupdbtv(                      /* "update" w/ no catastro's for duplicates  */
void *recptr)                 /* does not support variable length records  */
{
     int recseg,length;

     length=bb->reclen;
     if (recptr == NULL) {
          recseg=bb->dataseg;
     }
     else {
          maksur(length);
          movmem(recptr,gpbptr,length);
          recseg=gpbseg;
     }
     switch (btvu(3,recseg,bb->keyseg,bb->lastkn,length)) {
     case 0:
          return(1);
     case 5:
          return(0);
     default:
          btverr("UPDATE");
          return(0);
     }
}

void
insbtv(                       /* insert a new Btrieve record               */
void *recptr)
{
     invbtv(recptr,bb->reclen);
}

void
invbtv(                       /* insert new variable length Btrieve record */
void *recptr,
int length)
{
     int recseg;

     if (bb == NULL) {
          return;
     }
     if (recptr == NULL) {
          recseg=bb->dataseg;
     }
     else {
          maksur(length);
          movmem(recptr,gpbptr,length);
          recseg=gpbseg;
     }
     if (btvu(2,recseg,bb->keyseg,0,length) != 0) {
          btverr("INSERT");
     }
}

int
dinsbtv(                      /* "insert" w/ no catastro's for duplicates  */
void *recptr)                 /* does not support variable length records  */
{
     int recseg,length;

     length=bb->reclen;
     if (recptr == NULL) {
          recseg=bb->dataseg;
     }
     else {
          maksur(length);
          movmem(recptr,gpbptr,length);
          recseg=gpbseg;
     }
     switch (btvu(2,recseg,bb->keyseg,0,length)) {
     case 0:
          return(1);
     case 5:
          return(0);
     default:
          btverr("INSERT");
          return(0);
     }
}

void
delbtv(void)                  /* delete the current Btrieve record         */
{
     if (bb == NULL) {
          return;
     }
     if (btvu(4,0,0,bb->lastkn,bb->reclen) != 0) {
          btverr("DELETE");
     }
}

void
clsbtv(                       /* close specified Btrieve file              */
struct btvblk *bbp)
{
     char *filnam;

     if (goodptr(bb=bbp) && bb->filnam != NULL) {
          filnam=bb->filnam;
          bb->filnam=NULL;
          if (btvu(1,0,0,0,0) != 0) {
               catastro("BTRIEVE CLOSE ERROR %d ON FILE \"%s\"",status,filnam);
          }
          DosFreeSeg(FP_SEG(bb->key));
          DosFreeSeg(FP_SEG(bb->data));
          free(filnam);
          DosFreeSeg(FP_SEG(bb));
     }
}

void
crtbtv(                                 /* Create a btrieve file           */
char *filnam,                           /* name of file to be created      */
void *databuf,                          /* buffer holding creation parms   */
int lendbuf,                            /* length of data buffer           */
int keyno)                              /* parameter used in creating file */
{
     int tptr;
     BTVFILE *crtbb=NULL;

     eclalcrem(sizeof(BTVFILE),&tptr,(char **)&crtbb);
     setmem(crtbb,sizeof(BTVFILE),0);
     crtbb->realseg=tptr;
     crtbb->reclen=lendbuf;
     eclalcrem(lendbuf,&crtbb->dataseg,&crtbb->data);
     movmem(databuf,crtbb->data,lendbuf);
     eclalcrem(strlen(filnam)+1,&crtbb->keyseg,&crtbb->key);
     strcpy(crtbb->key,filnam);
     setbtv(crtbb);
     if (btvu(14,crtbb->dataseg,crtbb->keyseg,keyno,crtbb->reclen) != 0) {
          crtbb->filnam=filnam;
          btverr("CREATE");
     }
     rstbtv();
     free(crtbb->key);
     free(crtbb->data);
     free(crtbb);
}

#define GIBP ((struct statbf *)gpbptr)

long
cntrbtv(void)                 /* Get number of records in a btrieve file   */
{
     static int kbfseg=0;
     char *tmp;

     if (kbfseg == 0) {
          eclalcrem(64,&kbfseg,&tmp);
     }
     maksur(sizeof(struct statbf));
     if (btvu(15,gpbseg,kbfseg,0,sizeof(struct statbf)) != 0) {
          btverr("STAT");
     }
     return(GIBP->fs.numofr);
}

int
rlenbtv(void)                 /* Record length of a btrieve file           */
{
     static int kbfseg=0;
     char *tmp;

     if (kbfseg == 0) {
          eclalcrem(64,&kbfseg,&tmp);
     }
     maksur(sizeof(struct statbf));
     if (btvu(15,gpbseg,kbfseg,0,sizeof(struct statbf)) != 0) {
          btverr("STAT");
     }
     return(GIBP->fs.reclen);
}

STATIC void
btverr(                       /* print out any btrieve error messages      */
char *who)
{
     char buff[40];

     sprintf(buff,"%s ERROR %d",who,status);
     catastro("BTRIEVE %s ON FILE \"%s\"",buff,bb->filnam);
}

int
btvu(                                    /* underlying Btrieve cmd interface */
int funcno,
int datbufseg,
int keyseg,
int keyno,
int rlen)
{
     REGS16 eclregs;
     static int btrvup=0,alrcat=0;

     if (!btrvup) {
          memset(&eclregs,0,sizeof(REGS16));
          eclregs.ax=0x357B;
          eclint(0x21,&eclregs);
          if (eclregs.bx != 0x33) {
               if (alrcat) {
                    return(0);
               }
               alrcat=1;
               catastro("Run BTRIEVE first, before running The Major BBS!");
          }
          btrvup=1;
     }
     btvdatptr->datbufoff=0;
     btvdatptr->datbufseg=datbufseg;
     btvdatptr->dbflen=rlen;
     btvdatptr->posp38off=38;
     btvdatptr->posp38seg=bb->realseg;
     btvdatptr->posblkoff=0;
     btvdatptr->posblkseg=bb->realseg;
     btvdatptr->funcno=funcno;
     btvdatptr->keyoff=0;
     btvdatptr->keyseg=keyseg;
     btvdatptr->keylen=(char)255;
     btvdatptr->keyno=(char)keyno;
     btvdatptr->statptoff=0;
     btvdatptr->statptseg=statusseg;
     *statusptr=0;
     btvdatptr->magic=24950;
     memset(&eclregs,0,sizeof(REGS16));
     eclregs.dx=0;
     eclregs.ds=btvdatseg;
     eclint(0x7B,&eclregs);
     lastlen=btvdatptr->dbflen;
     return(status=*statusptr);
}

void
eclint(                            /* protected to real interrupt          */
int inum,
REGS16 *regs)
{
     DosRealIntr(inum,regs,0L,0);
}

char huge *
plfarmalloc(unsigned long ln)      /* PHARLAP version of farmalloc         */
{
     SEL psel;

     _plmerror=DosAllocHuge(HIWORD(ln),LOWORD(ln),&psel,0,0);
     if (_plmerror != 0) {
          printf("\nPLFARMALLOC=%d! (%x:%x)\n",_plmerror,HIWORD(ln),LOWORD(ln));
          return(NULL);
     }
     return(MAKEP(psel,0));
}
