/***************************************************************************
 *                                                                         *
 *   MONITOR.C                                                             *
 *                                                                         *
 *   Copyright (C) 1992-1994 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Monitor-All screen code                                               *
 *                                                                         *
 *                                            - Robert A. Rose 02/10/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "oprlow.h"

unsigned monkey(unsigned scncod);
void shomal(void);

extern int stahdl;                 /* handle for the graph screen          */
int mhdl;                          /* handle for the monitor screen        */
extern int shdl;                   /* handle for the summary screen        */

int manhue=0x1A,
    mbahue=0x1B,
    mashue=0x50;

struct scrnid monascn={
     "bbsm.bin",                   /* screen filename                      */
     3040,                         /* length of screen (4000 for full scrn)*/
     ALT_M,                        /* select scan code (from main screen)  */
                                   /* ala 'Keyboard Accelerator'           */
     NULL,                         /* screen going away routine            */
     NULL,                         /* screen repaint routine               */
     monkey,                       /* key handler routine                  */
     NULL,                         /* occasional update routine            */
     0,                            /* seconds between occasional updates   */
     0,                            /* seconds to go before next update     */
     NULL,                         /* called every cycle when displayed    */
     2,0,                          /* current cursor position on screen    */
     0,                            /* does cursor move?                    */
     1,                            /* should screen scroll?                */
     1,1,70,17,                    /* scrolling for window (default)       */
     NULL,                         /* perm. save buffer                    */
     NULL                          /* current location of screen           */
};

unsigned
monkey(                       /* Monitor screen keystroke handler routine  */
unsigned scncod)                        /* keystroke hit                   */
{
     switch (scncod) {
     case TAB:
          scn2mai(shdl);
          break;
     case BAKTAB:
          scn2mai(stahdl);
          break;
     default:
          return(scncod);
     }
     return(0);
}

void
shomal(void)                  /* show "monitor all" channel status         */
{
     int i,rlen;
     char *inptr;

     prf("|%-9.9s| %02x |%3d |",uacoff(usrnum)->userid,channel[usrnum],status);
     if (status == CRSTG) {
          prf(" %-52.52s\r",input);
          if (inplen > 52) {
               prf("|         |    |    | %-52.52s\r",input+52);
               if (inplen > 104) {
                    prf("|         |    |    | %-52.52s\r",input+104);
                    if (inplen > 156) {
                         prf("|         |    |    | %-52.52s\r",input+156);
                    }
               }
          }
     }
     else {
          prf("\r");
     }
     for (i=0 ; i < nterms ; i++) {
          if (btuoba(i) > (prfptr-prfbuf)) {
               if ((user[i].flags&MONALL) ||
                   ((user[i].flags&MONINP) && status == CRSTG)) {
                    outprf(i);
               }
          }
     }
     clrprf();
     prf("");
     actvscn(mhdl);
     locate(70,17);
     if (status == CRSTG) {
          sstatr(manhue);
          printf("\n %02x ",channel[usrnum]);
          sstatr(mbahue);
          printf("%c",179);
          sstatr(manhue);
          printf("%3d ",status);
          sstatr(mbahue);
          printf("%c",179);
          sstatr(manhue);
          printf(" %.58s",input);
          for (rlen=inplen-58,inptr=input+58 ; rlen > 0 ; rlen-=58,inptr+=58) {
               sstatr(mbahue);
               printf("\n    %c    %c ",179,179);
               sstatr(manhue);
               printf("%.58s",inptr);
          }
     }
     else {
          sstatr(manhue);
          printf("\n");
          sstatr(mashue);
          printf(" %02x ",channel[usrnum]);
          sstatr(mbahue);
          printf("%c",179);
          sstatr(mashue);
          printf("%3d ",status);
          sstatr(mbahue);
          printf("%c ",179);
          sstatr(0x1A);
          switch (status) {
          case 251:
               printf("<Data Input Buffer Overflow>");
               break;
          case 252:
               printf("<Echo Output Buffer Overflow>");
               break;
          case 253:
               printf("<Data Output Buffer Overflow>");
               break;
          case 254:
               printf("<Status Input Buffer Overflow>");
               break;
          case 255:
               printf("<Command Output Buffer Overflow>");
               break;
          case 11:
               printf("<Lost Carrier>");
               break;
          case 13:
               printf("<Invalid Command>");
               break;
          case 6:
               printf("<User aborted output>");
               break;
          }
     }
}
