/*        Header file for use with messages: E-Mail, SIGs and MHS          */
/*   Copyright (C) 1988-1994 GALACTICOMM, Inc.    All Rights Reserved.     */

extern
int sigstt,                        /* state code for SIGs module           */
    emlstt;                        /* state code for electronic mail module*/

#define SIGSIZ    10               /* max size of SIG names (incl. '\0')   */
#define MAXSIG  3500               /* max number of SIGs total             */
#define MXKWLN    16               /* max keyword group length (incl. '\0')*/
#define NQSKWG     5               /* number of quickscan keyword groups   */
#define FWDESZ    60               /* max length of forwardee name/MHS addr*/
#define MAXQSC 16384               /* max size of a user's quickscan record*/

struct qscfg {                     /* quickscan/config per-user data       */
     char userid[UIDSIZ];          /* master key for lookups               */
     char fwdee[FWDESZ];           /* forwardee for private e-mail if any  */
     unsigned fwdate;              /* date that forwardee was chosen       */
     char qskwds[NQSKWG][MXKWLN];  /* quickscan keywords                   */
     int cursig;                   /* current SIG number                   */
     int nsigs;                    /* number of SIGs when last updated     */
     int flags;                    /* preference-related flags             */
     char spare[185-179];          /* spare space, decrease when adding on */
     char acclso[1];               /* variable len access and lsofar arrays*/
};

extern
struct qscfg *qscldr;              /* temp loading space for qscan records */

                                   /* preference-related flag definitions  */
#define CWHENR  1                  /*   clear messages after replied to?   */
#define P4NEWM  2                  /*   pause at logon for new mail?       */
#define GORTIN  4                  /*   if P4NEWM, go right into E-mail?   */
#define FORUM2  8                  /*   consider forum mail E-mail "to"?   */
#define MSGQUO  16                 /*   use message quoting at all?        */
#define ALWQUO  32                 /*   always use message message quoting?*/
#define USRSET  64                 /*   has this guy set his preferences?  */
#define QSATT   128                /*   Major QWK-Mail include atts flag   */
#define CMBHDR  256                /*   combine header and body of messages*/

extern
int qscsiz;                   /* size of in-memory quickscan recs (qscptr) */

#define LSOFAR ((long *)(&qscptr->acclso[(nsigs+1)/2]))

extern
struct qscfg *tmpqsc,         /* temp one-shot qscsiz quickscan hold area  */
             *sopqsc,         /* singular SYSOP/SIG-Op scratch area        */
             *qscptr;         /* ptr to current user's quickscan entry     */

extern
struct usracc *sopusa,        /* singular SYSOP/SIG-Op scratch acct        */
               qikuac;        /* "distribution list" scratch acct area     */

extern
struct dstdat *tmpqik;        /* scratch distribution list data ptr        */
extern
struct qikusr *qkusrs,        /* dyn alloc'd array of list info            */
              *qcurusr;       /* pointer to current user's list info       */
extern
struct fndblk sigfnd;         /* find block structure for DOS operations   */

extern
char *dftnlv,                 /* default non-live SIG access bits          */
     *dftliv,                 /* default live SIG access bits              */
     *maxnlv;                 /* maximum non-live SIG access bits          */

                                   /* SIG access level codes               */
#define NOAXES 0                   /*   no access                          */
#define RDAXES 2                   /*   read access                        */
#define DLAXES 4                   /*   download access                    */
#define WRAXES 6                   /*   write access                       */
#define ULAXES 8                   /*   upload access                      */
#define COAXES 10                  /*   Co-Op access                       */
#define OPAXES 12                  /* (ret from readac() when SIG-Op)      */
#define SYAXES 14                  /* (ret from readac() when Sysop)       */
#define NOTSET 15                  /*   not set yet (use default)          */

#define TPCSIZ   51                /* topic field size (including the '\0')*/
#define AXTSIZ   57                /* aux topic size   (including the '\0')*/
#define NVMSIZ  216                /* non-variable message size component  */

                                   /* esigs.dat message database key id's  */
#define TOTOPIC   0                /*   compos "to" User-ID + topic field  */
#define FROMNUM   1                /*   compos "from" User-ID + msg number */
#define TONUM     2                /*   compos "to" User-ID + msg number   */
#define UTONUM    3                /*   compos "userto" + msg number       */

#define FIRSTM    0L               /* "first message" code, for searches   */
#define LASTM  0x7FFFFFFFL         /* "last message" code, for searches    */

#define ALL    "** ALL **"         /* string for userto dest when general  */
#define EMAIL  "E-mail"            /* string output for EMAIL module name  */
#define SIGS   "Forum"             /* string output for SIG module name    */

struct message {
     long msgno;                   /* message number                       */
     char userto[UIDSIZ];          /* User-ID personally to, or "** ALL **"*/
     char from[UIDSIZ];            /* message originator                   */
     char to[UIDSIZ];              /* recipient User-ID or SIG name        */
     char topic[TPCSIZ];           /* main topic, editable, carried over   */
     char auxtpc[AXTSIZ];          /* auxillary topic (reply to #88888,    */
                                   /*   fw by Aaaaaaaaa, cc: of #99999)    */
     unsigned crdate;              /* message creation date                */
     unsigned crtime;              /* message creation time of day         */
     int nreply;                   /* number of times replied to           */
     int flags;                    /* message/attachment flag bits         */
     char spare[NVMSIZ-211];       /* spare space, decrease when adding on */
     char text[1];                 /* variable-length message text         */
};
                                   /* message flag bits                    */
#define ISSHDR  0x0001             /*   message is SIG header format       */
#define EXEMPT  0x0002             /*   message is exempt from auto-delete */
#define RECREQ  0x0010             /*   return-receipt requested when read */
#define INDRCT  0x0020             /*   "indirect" att, direct has filespec*/
#define FILATT  0x0040             /*   file is attached to this message   */
#define APPVED  0x0080             /*   file attached is ok to download    */
#define ISRETR  0x0100             /*   sender can't delete or modify      */
#define MHSMSG  0x0200             /*   this message is MHS based          */

struct sighdr {
     long msgno;                   /* message number                       */
     char userto[UIDSIZ];          /* should always be "** ALL **"         */
     char from[UIDSIZ];            /* SIG-Op User-ID                       */
     char to[UIDSIZ];              /* SIG name (with leading slash)        */
     char topic[TPCSIZ];           /* SIG short description                */

     int signo;                    /* SIG number                           */
     int  nmsgs;                   /* number of messages in the SIG        */
     int  nfiles;                  /* number of files in the SIG           */
     int  nw4app;                  /* number of files waiting for apprvl   */
     char ispare[AXTSIZ-4-14-KEYSIZ]; /* a little internal spare space     */
     char sigloc[KEYSIZ];          /* SIG privileged key name              */
     int  dfnlv;                   /* default non-live access setting      */
     int  dfliv;                   /* default live access setting          */
     int  mxnlv;                   /* maximum non-live access setting      */
     char mispare[4];              /* more internal spare space            */

     unsigned crdate;              /* SIG creation date                    */
     unsigned crtime;              /* SIG creation time of day             */
     int nreply;                   /* number of times replied to           */
     int flags;                    /* settable SIG options                 */
     char spare[NVMSIZ-211];       /* spare space, decrease when adding on */
     char text[1];                 /* variable-length SIG intro text       */
};

#define SIGIDC '/'                 /* SIG identifier character             */
#define NOSIG  32766               /* code for absence-of-SIG              */
#define UPLTYPS 0x100              /* addend for upload protocol type codes*/
#define NPREVS   5                 /* previous-msg file pos's maintained   */
#define FSPSIZ  64                 /* filespec size (including the '\0')   */

#define MHSADR 256                 /* Max size of MHS addr (include '\0')  */

struct mhsinf {                    /* btrieve file structure for MHS data  */
     long msgno;                   /*   message number to relate to        */
     char addr[MHSADR];            /*   address for replies to message     */
     char spare[338-260];          /*   spare for growth                   */
};

extern
char *mhsoutd,                     /* Directory for outgoing MHS messages  */
     *mhsfild,                     /* Directory for outgoing MHS files     */
     *mhsind,                      /* Directory for incoming MHS messages  */
     *gtwnme,                      /* BBS gateway name                     */
     *mhskey;                      /* key required to send MHS messages    */

struct esgusr {               /* esigs user data                           */
     long fpos;               /*   message file position                   */
     long prethr;             /*   fpos in effect b4 starting thread or cc:*/
     int keynum;              /*   key number in use                       */
     int pthkyn;              /*   key number in eff b4 starting thread    */
     FILE *fp;                /*   attachment/source file handle           */
     FILE *fpout;             /*   destination file handle when copying    */
     int fxftyp;              /*   file transfer method type code          */
     int blknum;              /*   block number in progress                */
     int lstsiz;              /*   DL: last block size UL: last byte count */
     long curpos;             /*   current position within download file   */
     void (*whndun)();        /*   esgutl when-done "return address"       */
     int ccount;              /*   carbon copy count toward maximum allowed*/
     int usigno;              /*   SIG number that user is in, or NOSIG    */
     int sigtck;              /*   "ticks" (credits) per SIG msg in cursig */
     int sattck;              /*   "ticks" (credits) per upload in cursig  */
     char keywds[MXKWLN];     /*   keywords being searched for (input stg) */
     unsigned sflags;         /*   run-time control flags                  */
     long prvpos[NPREVS];     /*   previous-message file positions         */
     int pvpidx;              /*   index position now active in prvpos[]   */
     long mhsfpos;            /*   MHS hold file position                  */
     char dftinp;             /*   default input letter if CR hit          */
     struct mhsinf mhs;       /*   MHS related data per user               */
     struct message msg;      /*   esigs message data block                */
     char newsig[UIDSIZ];     /*   temp holder for new SIG name            */
};
                              /* run-time control flags                    */
#define SCNNXT     1          /*   scan direction is forward ("next")      */
#define SCNCIS     2          /*   scan continuing in SIG (!starting anew) */
#define SCNQUI     4          /*   quickscan in progress                   */
#define SCNCIQ     8          /*   continuing quickscan (!first qs pass)   */
#define SCN4AT    16          /*   scanning for attachments (download)     */
#define SCN4UA    32          /*   scanning for unapproved attachments     */
#define SCNKWD    64          /*   scanning (searching) for keywords       */
#define SCN2LT   128          /*   scanning (listing) in 2-line-title mode */
#define SCNFTX   256          /*   scanning (listing) in full-text mode    */
#define CPYIPG   512          /*   file-copy operation in progress         */
#define NOPGBK  1024          /*   no-page-breaks in effect                */
#define RAFIPG  2048          /*   reply-after-forward in effect           */
#define LONIPG  4096          /*   a supplemental logon is in progress     */
#define LONFIN  8192          /*   finished with supplemental logon        */
#define MHSORG 16384          /*   this message is going out via MHS       */
#define FNDMSG 32768u         /*   found a message in a keyword search     */

#define esgptr ((struct esgusr *)vdaptr)    /* volatile data pointer casts */
#define esgarr(u) ((struct esgusr *)vdaoff(u))

extern
struct compos {               /* composite user-id/msg# for searches       */
     char userid[UIDSIZ];     /*   user-id to or from, or SIG name         */
     long msgno;              /*   message number                          */
} compos;

extern
struct sigdat {               /* ram-resident SIG data tables              */
     char sigop[UIDSIZ];      /*   User-ID of SIG-Op                       */
     char signam[SIGSIZ];     /*   SIG name                                */
     char descrp[TPCSIZ];     /*   SIG short description                   */
     int signo;               /*   SIG number                              */
     int  nmsgs;              /*   number of messages in the SIG           */
     int  nfiles;             /*   number of files in the SIG              */
     int  nw4app;             /*   number of files waiting for approval    */
     char *mhsaddr;           /*   MHS address string if any               */
     char sigloc[KEYSIZ];     /*   SIG privileged key name                 */
} *sdtptr;                    /* scratch ptr for scanning thru sigdat      */

/* added structures and definitions for "distribution list"                */
/* capabilities follow here                                                */

#define MAXLST 40                  /* number of "names" in a personal list */

struct dstdat {                    /* personal list records structure      */
     char keyval[UIDSIZ];          /*   key value for look-up (User-ID)    */
     char list[MAXLST][UIDSIZ];    /*   array of personal list names       */
     char spare[1300-1230];        /*   spare space decrease as needed     */
};

#define LFILSZ      8+1+3+1        /* maximum length of a list file name   */

struct qikusr {                    /* RAM-resident "distribution list" info*/
     FILE *fp;                     /*   file pointer for reading lists     */
     char fspec[FSPSIZ];           /*   scratch file spec for attachments  */
     int countr;                   /*   cycle-counter (also total charge)  */
     int dsttyp;                   /*   current distribution type          */
     long curpos;                  /*   distribution list current position */
};

                              /* distribution "types" (while distributing) */
#define   PERSNL    1              /* using a personal list right now      */
#define   SYSOPD    2              /* using a sysop-defined list right now */
#define   MASSML    4              /* using a mass mailing right now       */
#define   ISWRIT    8              /* is just writing a message right now  */
#define   ISCOPY    16             /* is copying a message (just written)  */

extern
char *emlkey,                 /* key to allow users to write E-mail        */
     *rrrtxt,                 /* return receipt text                       */
     *rrrtpc;                 /* return receipt topic                      */

extern
FILE *esgmb;                  /* esigs named-message file block ptr        */
extern
BTVFILE *esgbb,               /* esigs btrieve file block ptr              */
        *qscbb,               /* esigs quickscan/config btrieve file ptr   */
        *qikbb,               /* personal distribution list btrv file ptr  */
        *mhsbb;               /* MHS btrieve file pointer                  */
extern
long filen;                   /* length of attachment found, from opnatt() */
extern
int esgstt;                   /* current/new usrptr->substt hold register  */
extern
int msgbyts,                  /* maximum number of bytes in message texts  */
    autfwd;                   /* msg written auto-forwarded? 0,1,or 2=MHS  */

extern
char *accstg[];               /* names of access levels                    */

#define FOUND   1             /* return values for CYCLE-mediated activity */
#define KEEPON -1
#define DONE    0

/*--- OPTIONS FROM GALMS.MSG ---*/

extern
int emllif,                   /* lifetime of an E-Mail message, in days    */
    emltck,                   /* "ticks" (credits) eaten per E-Mail msg    */
    eattck,                   /* "ticks" (credits) eaten per attachment    */
    rrrtck,                   /* "ticks" (credits) eaten per return receipt*/
    ednaud,                   /* Do audit trail entry per E-Mail download? */
    eupaud,                   /* Do audit trail entry per E-Mail upload?   */
    askatt,                   /* Ask users for E-mail file attachments?    */
    askrrr,                   /* Ask users for E-mail return receipts?     */
    askcpy;                   /* Ask users to copy E-mail?                 */

extern
int nsigs,                    /* number of SIGs allowed for                */
    stlcop,                   /* SIG teleconference option                 */
    sigccr,                   /* default SIG credit consumption rate       */
    siglif,                   /* default lifetime of a SIG message, in days*/
    sigtck,                   /* default "ticks" (credits) per SIG msg     */
    sattck,                   /* default "ticks" (credits) per file upload */
    sdnaud,                   /* Do audit trail entry per SIG download?    */
    supaud,                   /* Do audit trail entry per SIG upload?      */
    sopmhd,                   /* allow SIG-Ops to modify SIG headers?      */
    esgvda,                   /* max number of bytes required by email/sigs*/
    qikchg,                   /* credits eaten per distribution list msg.  */
    mhsact;                   /* is MHS active 1=Yes 0=No                  */

extern
char *sigsys,                 /* name of Sysop privileged SIG usage key    */
     *mhskey,                 /* name of key required to send MHS messages */
     *sigprv;                 /* key required for privileged Forum access  */

extern
char dftsig[];                /* default SIG for new users etc.            */

/*--- Decide Email versus SIG ---*/

#define  either(x,y) (usrptr->state == emlstt ? (x) : (y)) /* E-Mail vs SIG */
#define meither(x,y) (esgptr->msg.to[0] != SIGIDC || esgptr->keynum == FROMNUM ? (x) : (y))

/* DATUTILS.C 04/02/92 14.18.24 */
char *prntim(int mode,int time);
char *prndat(int mode,int date,char sep);
char *prnday(int date,int size);
/* DISTLST.C 23/02/92 17.32.18 */
void lvlacc(void);
void charging(void);
int entqik(void);
void dstbgn(int flags);
void dstcyc(void);
int valdat(char *tmpptr);
void sentup(void);
void sentsp(void);
void qfclose(void);
void sysusr(void);
void sentusr(void);
void lstcnf(void);
void dstcnf(void);
/* MHSHDL.C 17/03/92 13.47.14 */
void inimhs(void);
int sendmhs(void);
void mhscpy(void);
int valmhs(char *buff);
int mhsfsnd(void);
void sigmhs(void);
void clsmhs(void);
int mhsscn(void);
void outrtk(void);
int mhschk(long fpos);
int mhsrhd(void);
int mhschkh(void);
void sndnot(int wchtyp);
int mhstxt(void);
void mhsbad(void);
void mhsproc(int taskid);

/* EMAIL.C 24/02/92 22.12.28 */
void inieml(void);
void ck4gpf(void);
void emlsnt(void);
int ealert(void);
int email(void);
int lonfin(void);
void slonrdn(void);
void sestart(void);
void sspecfn(void);
void sentfwd(void);
void sauters(void);
void snemprf(void);
void stypref(void);
void squoprf(void);
void scmbprf(void);
void srewhat(void);
void ertphd(void);
void sertfq(void);
void sscoscn(void);
void scoutle(void);
void modfrm(int save);
void gonext(void);
void goprev(void);
void attwrn(void);
void dwrrr(void);
void xfprf2tx(void);
void srfvpn(void);
void dorply(void);
int mhsrok(void);
void rpedun(int save);
void rpadun(void);
void srrrq(void);
void pmail(void);
void scopyq(void);
void scpyuid(void);
void cpudun(void);
void cpudun2(void);
void rprdun(int abrted);
void rfdwck(void);
void refdel(int cflmsg);
void swhofwd(void);
void swhocpy(void);
void swhoto(void);
void smodwht(void);
void sdelmsn(void);
void emldel(char *uid);
void emlcls(void);
/* ESGUTL.C 24/02/92 22.52.20 */
void EXPORT init__esig(void);
int fireup(void);
void hdlesg(void);
void susequo(void);
int isrepl(void);
void dnload(void (*whndun)());
int tshesg(int tshcod);
int begdld(void);
void sdnldq(void);
void emsthn(void);
void possat(void (*rouptr)());
void sattfiq(void);
int fupesg(int fupcod);
void begupl(void);
void sreefnm(void);
void snewtfn(void);
void ssopfsp(void);
void ediwqu(void (*whndun)());
void edimsg(int clr,int tpc,void (*whndun)(),int ffv);
void begupl(void);
int begdld(void);
int dunedtg(int flags);
int esgimr(long mno);
int uidxst(char *uid);
char *tpcfnm(struct message *msg);
char *attfnm(struct message *msg);
char *attfsn(struct message *msg);
char *attfsd(struct message *msg);
char *attfs(struct message *msg);
int findsig(char *name);
int findsigu(char *name,int cond);
void addaux(char *newaux);
void aauxut(char *newaux,char *auxtpc);
char *formax(char *leader);
void mkmsgn(void);
void postit(void);
void posti(void);
void wrtmsg(void);
void stdcnf(void);
void pstpst(int recip,int sender);
void figin(int addend);
void sgonum(void);
void oncors(void);
int strtup(int hlpmsn);
void estabc(void);
void estabn(void);
int estaab(void);
void sumams(void);
char *datlin(void);
char *axtstg(void);
char *frmfld(void);
void sumnew(void);
void sumscn(int dsifmore);
void refclr(int cflmsg);
int aqnxut(void);
int alomsg(int keyno,long msgno);
void prompt(int news);
void prohlp(int news);
void errmsg();
void blwoff();
void xtext(void);
void quotem(void);
int linlen(char *ptr);
int tovalid(void);
int validwr(char *dest);
int isalon(void);
void moddun(int save);
void wrtmod(void);
int fwdit(char *recip,int copy);
void cpedun(void);
void cpsdun(void);
void dunfwc(int copy);
void sendto(char *recip);
void dwfwdf(void);
void delwck(void);
void delmsg(void);
void qikdel(int tdy);
void esgmcu(void);
char *sigtpc(int signo);
void esgmod(void (*whndun)());
int anyone(int insig);
int esgcfl(void);
void esghup(void);
int credok(int nlvflg,int howmny);
int credsf(int howmny);
int clrchr(int c);
int uclchr(int c);
int lwclch(int c);
int sendmsg(struct message *msg,char *to);
int snd2mhs(struct message *msg,char *to);
/* SIGS.C 24/02/92 23.02.42 */
void inisig(void);
void mnewsg(struct sighdr *hdrptr);
int sigs(void);
void abostf(void);
void sigst0(void);
int onsqsc(char *userid);
void iniqsc(void);
void iqscfg(struct qscfg *qscptr,char *userid);
int grbqsc(struct qscfg *grbptr,char *userid);
int ssstart(void);
void ssigmto(void);
void ssigcon(void);
void s123(void);
void suid(void);
void soprmnu(void);
void scresig(void);
void csgdun(int save);
void sdelsig(void);
void sdelrus(void);
void rprdls(void);
void cpyoff(void);
void sucpsrc(void);
void sucpdst(void);
void smodwhs(void);
void sdelmss(void);
void sreadbu(void);
void ssrkey(void);
char *findkw(char *kwd);
void sstarts(void);
void sscosig(void);
void scoutls(void);
void gorep(void);
void sgoprev(void);
void sgonext(void);
void gocyc(void);
void srepsig(void);
void srepopx(void);
void modurs(int save);
void srpdun(int save);
void serdun(int save);
void eradun(void);
void ssrrrq(void);
void sradun(void);
void postwc(void);
void sthrfbp(void);
void thrutl(int fwd);
void sopfwd(void);
void sopcpy(void);
void pstcpy(void);
void delsms(void);
void slistyp(void);
void sstartl(void);
void srquick(void);
void fupqs(int qsprmt,int flags);
void fupqsn(int qsprmt,int flags);
void squickc(void);
void sqcadd(void);
void rprqca(void);
void sqcdel(void);
void sqckwds(void);
void sqcsrky(void);
int qsignx(int idx);
int scoscd(void);
void lissgs(void (*whndun)());
void bgncyc(void);
void cycmed(void);
char *chcred(int amt);
void copysm(void);
void lsnams(void);
void listms(void);
void vnxmsg(void);
int qslidx(void);
void evlams(void);
void evlals(void);
int nxtqs(int nxtidx);
int kwdmat(void);
int kwdchk(char *list);
void pstdun(int save);
void setwhn(void (*whndun)());
void attdun(void);
void sselsig(void);
void pmtssg(void);
void joinsg(int signo);
int sigopt(char *idstg,int dftval);
void asig(long msgnum);
int readac(void);
int saxxok(int signo);
void alcsig(void);
struct sigdat *sigoff(int signo);
void alcqsc(void);
struct qscfg *qscoff(int unum);
int rdautl(int signo);
int rdoutl(char *userid);
struct qscfg *getqsc(char *userid,struct qscfg *sopqsc);
int alvutl(struct qscfg *othuqp,int signo);
int dftlvl(char *array);
void writac(char *userid,int value);
void mksigo(char *userid,int oldgac);
void wracar(char *acarpt,int value);
void wracut(char *acarpt,int value,int signo);
void sigdla(char *uid);
void clssig(void);
