/***************************************************************************
 *                                                                         *
 *   GALP&QH.H                                                             *
 *                                                                         *
 *   Copyright (C) 1993-1994 GALACTICOMM, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This is the Polls and Questionnaires header file.                     *
 *                                                                         *
 *                                 - M. Timothy Stark 10/01/93             *
 *                                                                         *
 ***************************************************************************/

#define PNAMELEN        26    /* poll name length                          */
#define PDESCLEN        40    /* poll description length                   */
#define KEYLEN          16    /* key field length                          */
#define STRSIZ         240    /* string size for temporary string area     */
#define POLLSPERPG      16    /* number of polls to list per page          */
#define ANSPERPG        15    /* number of answers per page in answer list */
#define TXTSIZ        2000    /* size of text buffer for questions         */
#define PTHFILSIZ       50    /* size of text buffer for path and file name*/
#define FILESIZ         13    /* size of a file                            */
#define MSGSIZ        1024    /* max size of message area                  */
#define ANSSIZ        1000    /* size of text buffer for answer            */
#define MAXASTGS        16    /* maximum number of answer strings          */
#define ANSSTGLEN       65    /* answer string length                      */
#define MAXQUES        100    /* maximum number of questions per poll      */
#define MAXCYCS          3    /* maximum QEQ's per cycle for listing       */
#define MXLWID          80    /* maximum label width                       */
#define MAXWHEEL         7    /* maximum frames in wheel animation         */
#define MAXPARAM        16    /* maximum number of answer parameters       */
#define RESUSRS2        -1    /* substate place holder                     */
#define PFNTSTY "|Y00000100"  /* poll font style                           */
#define PBUTSTY "|1B00000201EQ010E000F080700000F07000000" /* button style  */
#define QFNTSTY "|Y000002LD"  /* question font style                       */
#define QBUTSTY "|1B0P0I0201EQ01010F0F080700000F0700000P" /* button style  */

/* question types                                                          */
#define CREDIT           1    /* credit card number question type          */
#define DATE             2    /* date question type                        */
#define DISONLY          3    /* display only question type                */
#define MULTICHC         4    /* multiple choice question                  */
#define NUMERIC          5    /* numeric question type                     */
#define OPEN_ENDED       6    /* open ended response question type         */
#define TRUEFALSE        7    /* true/false question type                  */
#define YESNO            8    /* yes/no question type                      */
#define USERACCT         9    /* user account question type                */

#define SHOW             1    /* show poll to user regardless of key       */
#define DIM              2    /* dim poll to user without proper key       */
#define HIDE             3    /* hide poll from user without proper key    */

#define SKIP             1    /* skip logon process altogether             */
#define ANNOUNCE         2    /* announce new poll to user                 */
#define ASK              3    /* ask user to take this poll now            */
#define INSIST           4    /* insist user takes this poll               */

/* define poll types                                                       */
#define POLL             1    /* tallies results (doesn't allow open-ended */
                              /*   answer types though)                    */
#define QUEST            2    /* doesn't tally results (although it can    */
                              /*   save a user's answers for lookup) and   */
                              /*   allows all answer types                 */

/* define temp user flags                                                  */
#define LONMODE          1    /* user is in the logon input handler rou.   */
#define MORELIST         2    /* RETURN will continue listing display      */
#define INSISTDUN        4    /* during logon, no more insist polls        */
#define ASKDUN           8    /* during logon, no more ask polls           */
#define HASSLE          16    /* was user hassled during logon process?    */
#define REVERSE         32    /* search in reverse mode                    */
#define FNDFIRST        64    /* have found the first results record       */
#define ADDRESP        128    /* insert open ended response data           */

/* poll flags                                                              */
#define   DISBRANCH      1    /* discard branching answers                 */
#define   SPARE          2    /* spare flag (reserved for future use)      */
#define   EDITP          4    /* poll is currently being edited            */
#define   ADDP           8    /* poll is currently being added             */
#define   CLRDFLT       16    /* default all questions to clear screen?    */
#define   DELETE        32    /* poll has been tagged for deletion         */

/* question flags                                                          */
#define   BRANCH         1    /* this question contains branching          */
#define   EXMPT          2    /* exempt answer from data storage           */
#define   EDITQ          4    /* question is being edited                  */
#define   CLRSCN         8    /* clear screen before this question         */

/* data storage type definitions                                           */
#define BTRIEVE          1    /* store answers to BTRIEVE data file        */
#define ASCII            2    /* store answers to an ASCII file            */
#define BOTH             3    /* store answers to both ASCII and BTRIEVE   */
#define DISCARD          4    /* do not store answers                      */

#define ONCE             1    /* only allow user to answer once            */
#define REPLACE          2    /* replace previous answers                  */
#define ACCUMULATE       3    /* accumulate answers                        */

struct polldata {                  /* master poll data structure           */
     char      pname[PNAMELEN];    /* poll name                            */
     char      pdesc[PDESCLEN];    /* poll description                     */
     int       polltype;           /* poll type POLL=1 QUES=2              */
     int       priority;           /* poll priority 0=SKIP 1=ANNOUNCE      */
                                   /* 2=ASK 3=INSIST                       */
     int       data;               /* data storage method array element    */
                                   /* 0/1=BTRIEVE 2=ASCII 3=BOTH 4=NONE    */
     int       answer;             /* 0/1=ONCE 2=REPLACE 3=ACCUMULATE      */
     unsigned  createdate;         /* date poll was created                */
     unsigned  closedate;          /* date to close this poll              */
     char      lookup_key[KEYLEN]; /* key required to look up answers      */
     char      logon_key[KEYLEN];  /* key required to get logon option     */
     char      acc_key[KEYLEN];    /* key required to answer poll          */
     int       acc_attr;           /* access display attribute             */
     char      res_key[KEYLEN];    /* key required to view results         */
     char      grant_key[KEYLEN];  /* key to grant users that complete     */
     char      grant_class[KEYLEN];/* class to grant users that complete   */
     long      grant_crd;          /* credits to grant users that complete */
     char      grant_file[PTHFILSIZ]; /* file to grant users that complete */
     int       flags;              /* poll flags                           */
};

struct quesdata {                  /* poll question data structure         */
     int       qnum;               /* question identification number       */
     char      pollname[PNAMELEN]; /* poll name this question is related to*/
     int       qtype;              /* question type                        */
     char      ansstg[MAXASTGS][ANSSTGLEN];   /* array of answer strings   */
     int       branch[MAXASTGS];   /* branching designators                */
     int       prev;               /* previous question                    */
     int       next;               /* default next question                */
     long      max;                /* maximum value/length of answer       */
     long      min;                /* minimum value/length of answer       */
     int       field;              /* field array element for usracc struct*/
     int       flags;              /* question flags                       */
     int       ansparam;           /* number of answer parameters to allow */
     char      txtmsg[TXTSIZ];     /* question/text display message        */
};

struct ansrdata {                  /* poll answer data structure           */
     int       qnum;               /* question number for this answer      */
     char      pollname[PNAMELEN]; /* poll name this answer is related to  */
     char      uid[UIDSIZ];        /* userid of owner of this data         */
     char      answer[ANSSIZ];     /* variable length answer string        */
};

struct pollstat {                  /* current poll status for this user    */
     char      uid[UIDSIZ];        /* userid                               */
     char      pname[PNAMELEN];    /* poll name                            */
};

/* construct composite key for question acquisition                        */
struct quescomp {                  /* composite key for question           */
     int       qnum;               /* question number of ques to acquire   */
     char      pollname[PNAMELEN]; /* pollname of poll to acquire          */
};

/* construct composite key for answer acquisition                          */
struct ansrcomp {                  /* composite key for answer             */
     int       qnum;               /* question number of this answer       */
     char      pollname[PNAMELEN]; /* pollname of poll to acquire          */
     char      uid[UIDSIZ];        /* userid of owner of this data         */
};

/* construct composite key for answer acquisition                          */
struct cupacomp {                  /* composite key for cleanup answers    */
     int       qnum;               /* question number of this answer       */
     char      pollname[PNAMELEN]; /* pollname of poll to acquire          */
};

/* construct composite key for finding user status of polls                */
struct statcomp {
     char      uid[UIDSIZ];        /* userid                               */
     char      pname[PNAMELEN];    /* poll name                            */
};

/* construct composite key for logon poll acquisition                      */
struct usercomp {
     char      uid[UIDSIZ];        /* userid to acuire                     */
     int       prior;              /* priority to acquire                  */
     int       status;             /* status to acquire                    */
};

struct polltemp {                  /* temporary storage area for user      */
     char      tstr[STRSIZ];       /* genaral purpose storage area         */
     char      tans[ANSSIZ];       /* temporary answer storage area        */
     char      tmpid[UIDSIZ];      /* used for stat lookup                 */
     int       flags;              /* temporary user flags                 */
     int       ques;               /* place holder for listing in cycle    */
     int       fques;              /* first question for viewing results   */
     int       ans;                /* answer counter for cycle             */
     int       cur;                /* current question for auto-inc        */
     int       wheel;              /* spinning wheel place holder          */
     long      pos;                /* position holder for CYCLING          */
     long      oldpos;             /* position holder for current page     */
     char      dftinp;             /* default input character              */
     char select[POLLSPERPG][PNAMELEN]; /* poll selection array            */
     struct polldata pdata;        /* poll data structure                  */
     struct quesdata qdata;        /* question data structure              */
     struct ansrdata adata;        /* answer data structure                */
     char fsdbuf[1];               /* share VDA buffer area with FSD       */
};

struct polltally {                 /* survey answer tally structure        */
     char pollname[PNAMELEN];      /* tally for what pollname              */
     int  answer[MAXQUES][MAXASTGS];    /* tallies by question number      */
};

#define pptr ((struct polldata *)(pbb->data))     /* poll data area        */
#define qptr ((struct quesdata *)(qbb->data))     /* question data area    */

#define tp          ((struct polltemp *)vdaptr)    /* define vdaptr        */
#define otp(x)      ((struct polltemp *)vdaoff(x)) /* define other vdaptr  */
#define atp         ((struct polltemp *)vdatmp)    /* define for cleanup   */
#define mp          ((struct message  *)vdatmp)    /* define for message   */

/* define function prototypes                                              */
void EXPORT init__polmod (void);
STATIC void polhang (void);
STATIC void polcls (void);
STATIC void polacup (void);
STATIC void polsthn (void);
STATIC int polon (void);
STATIC int polin (void);
STATIC void polmsg (int msg, int mode);
STATIC int ispollop (void);
STATIC int isysop (void);
STATIC int dunques (int flags);
STATIC int listpolls (void);
STATIC int chk4poll (void);
STATIC int polmain (void);
STATIC void addprp (int msgno, int amode);
STATIC char *polrft (void);
STATIC int polvfy (int fldno, char *answer);
STATIC void poldun (int save);
STATIC void polptc (void);
STATIC void quesprp (int msgno, int amode);
STATIC char *quesrft (void);
STATIC int quesvfy (int fldno, char *answer);
STATIC void quesdun (int save);
STATIC void quesptc (void);
STATIC void astgprp (int msgno, int amode);
STATIC char *astgrft (void);
STATIC int astgvfy (int fldno, char *answer);
STATIC void astgdun (int save);
STATIC void astgptc (void);
STATIC int checkscn (void);
STATIC void setptrs (void);
STATIC void initdata (void);
STATIC int listquest (void);
STATIC int fndpoll (void);
STATIC int fndstat (void);
STATIC void cyc_inc (void);
STATIC void qtypevfy (void);
STATIC void saveques (int mode);
STATIC void gettake (void);
STATIC void getres (void);
STATIC void loadnext (void);
STATIC void loadprev (void);
STATIC int chknext (void);
STATIC int chkprev (void);
STATIC void setinplen (void);
STATIC char *questxt (void);
STATIC void editqtype (int mode);
STATIC void editmult (int mode);
STATIC void loadquestxt (void);
STATIC void showmult (int mode);
STATIC int ismult (void);
STATIC void cyc_tally (void);
STATIC int remove_tally (void);
STATIC void add_tally (void);
STATIC int chk_answer (char *stg);
STATIC void results (void);
STATIC void getlook (void);
STATIC void shwrslt (void);
STATIC void duppoll (void);
STATIC void nonpoll (void);
STATIC void takepoll (void);
STATIC void getpoll (void);
STATIC void editpoll (void);
STATIC void addques (void);
STATIC void getques (void);
STATIC void quesopts (void);
STATIC void getlup (void);
STATIC void disstats (void);
STATIC void cyc_ques (void);
STATIC void cyc_rslt (void);
STATIC void cyc_lup (void);
STATIC void cyc_disstats (void);
STATIC void cyc_logon (void);
STATIC void cyc_resusrs (void);
STATIC void cyc_resusrs2 (void);
STATIC int gopoll (void);
STATIC void nxtpoll (void);
STATIC void pollask (void);
STATIC void pollins (void);
STATIC int notexp (void);
STATIC void cycwheel (void);
STATIC int chkpoll (void);
STATIC void apendasc (void);
STATIC void grantstf (void);
STATIC char *attfsp (struct message *msg);
STATIC void upaccfld (void);
STATIC void delconf (void);
STATIC void cyc_delques (void);
STATIC void dundelq (void);
STATIC void prf2tx (void);
STATIC void poldft (int msg);
STATIC int okdate (char *stg);
STATIC int chk_clearance (void);
STATIC void resconf (void);
STATIC void gtrfsb (int msgno, int maxbuts, char *fstyle, char *bstyle, char butarr[][MXLWID+1]);
STATIC char *rsltper (int num, int tot);
STATIC void initasc (void);
STATIC void rstflgs (void);
STATIC void pnachng (void);
STATIC void qnachng (void);
STATIC void anachng (void);
STATIC int polstat (void);
STATIC int duntake (int flags);
STATIC void saveresp (char *ansstg);
