/***************************************************************************
 *                                                                         *
 *   GALP&Q.C                                                              *
 *                                                                         *
 *   Copyright (C) 1993-1994 GALACTICOMM, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This is the Polls and Questionnaires source code file.                *
 *                                                                         *
 *                                 - M. Timothy Stark 10/01/93             *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "message.h"
#include "fsdbbs.h"
#include "galp&q.h"
#include "galp&qh.h"

struct module polmod={   /* module interface block                         */
     "",                 /* name used to refer to this module              */
     polon,              /* user logon supplemental routine                */
     polin,              /* input routine if selected                      */
     polsthn,            /* status-input routine if selected               */
     NULL,               /* "injoth" routine for this module               */
     NULL,               /* user logoff supplemental routine               */
     polhang,            /* hangup (lost carrier) routine                  */
     polacup,            /* midnight cleanup routine                       */
     NULL,               /* delete-account routine                         */
     polcls              /* finish-up (sys shutdown) routine               */
};

struct quescomp qcomp;             /* question data structure              */
struct ansrcomp acomp;             /* answer composite key structure       */
struct cupacomp acompcup;          /* cleanup answer composite key struct  */
struct usercomp ucomp;             /* user composite key structure         */
struct statcomp scomp;             /* user stat composite key structure    */

struct polltally tally;            /* master system tally area             */
struct pollstat *pollsarr,*sp;     /* define user poll stat array/ptr      */

static char *qtypes[]={            /* declare 'question types' array       */
     "CREDIT_CARD_NUMBER",         /* credit card question type (for FSD)  */
     "CREDIT_CARD_NUMBER",         /* credit card question type            */
     "DATE",                       /* date question type                   */
     "DISPLAY_ONLY",               /* display only question type           */
     "MULTIPLE_CHOICE",            /* multiple choice question type        */
     "NUMERIC_VALUE",              /* numeric value question type          */
     "OPEN_ENDED_RESPONSE",        /* open ended response question type    */
     "TRUE/FALSE",                 /* true/false question type             */
     "YES/NO",                     /* yes/no question type                 */
     "USER_ACCOUNT"                /* user account question type           */
};

static char *uaflds[]={
     "NAME",                       /* name user account field (for FSD)    */
     "NAME",                       /* name user account field              */
     "ADDRESS_LINE_1",             /* address line 1 user account field    */
     "ADDRESS_LINE_2",             /* address line 2 user account field    */
     "ADDRESS_LINE_3",             /* address line 3 user account field    */
     "ADDRESS_LINE_4",             /* address line 4 user account field    */
     "PHONE-NUMBER",               /* phone number user account field      */
     "BIRTHDAY",                   /* birthday user account field          */
     "SEX",                        /* sex user account field               */
     "ANSI_SETTING",               /* ansi setting user account field      */
     "EDITOR_SETTING",             /* editor setting user account field    */
     "PASSWORD"                    /* password setting user account field  */
};

static char *stypes[]={            /* declare 'data storage type' array    */
     "BTRIEVE",                    /* store to btrieve data file           */
     "BTRIEVE",                    /* ditto                                */
     "ASCII",                      /* store to ascii file                  */
     "BOTH",                       /* store to btrieve/ascii               */
     "DISCARD"                     /* discard answer (branching)           */
};

static char *types[]={             /* declare 'types' array                */
     "POLL",                       /* polltype is 'POLL'                   */
     "POLL",                       /* ditto                                */
     "QUESTIONNAIRE"               /* polltype is 'QUESTIONNAIRE'          */
};

static char *type[]={              /* declare 'type' array                 */
     "Poll",                       /* polltype is 'POLL'                   */
     "Poll",                       /* ditto                                */
     "Questionnaire"               /* polltype is 'QUESTIONNAIRE'          */
};

static char *atts[]={              /* declare 'menu attributes' array      */
     "SHOW",                       /* attribute is 'SHOW'                  */
     "SHOW",                       /* ditto                                */
     "DIM",                        /* attribute is 'DIM'                   */
     "HIDE"                        /* attribute is 'HIDE'                  */
};

static char *priors[]={            /* declare 'logon priority' array       */
     "SKIP",                       /* skip logon routine for this poll     */
     "SKIP",                       /* ditto                                */
     "ANNOUNCE",                   /* announce poll to user                */
     "ASK",                        /* ask user to take this poll           */
     "INSIST"                      /* insist that user takes this poll     */
};

static char *yesno[]={             /* declare 'yes/no' array               */
     "YES",                        /* yes for yes/no question type (FSD)   */
     "YES",                        /* yes for yes/no question type         */
     "NO"                          /* no for yes/no question type          */
};

static char *truefalse[]={         /* declare 'true/false' array           */
     "TRUE",                       /* true for true/false question type    */
     "TRUE",                       /* true for true/false question type    */
     "FALSE"                       /* false for true/flase question type   */
};

static char *atypes[]={            /* declare 'answer type' array          */
     "ONCE",                       /* once for answer type (for FSD)       */
     "ONCE",                       /* once for answer type                 */
     "REPLACE",                    /* replace for answer type              */
     "ACCUMULATE"                  /* accumulate for answer type           */
};

static char *wheel[]={             /* declare wheel animation array        */
     "/",                          /* cell 0 in wheel animation sequence   */
     "-",                          /* cell 1 in wheel animation sequence   */
     "|",                          /* cell 2 in wheel animation sequence   */
     "/",                          /* cell 3 in wheel animation sequence   */
     "-",                          /* cell 4 in wheel animation sequence   */
     "\\",                         /* cell 5 in wheel animation sequence   */
     "|"                           /* cell 6 in wheel animation sequence   */
};

static char *pstat[]={             /* declare 'poll status' strings        */
     "NEW",                        /* this poll hasn't been completed yet  */
     "DONE",                       /* this poll has been completed         */
     "DEL",                        /* poll has been tagged for deletion    */
     "MAINT",                      /* poll is currently undergoing maint   */
};

/* define RIP variables                                                    */
char polbuts[POLLSPERPG][MXLWID+1],     /* poll button array               */
     fntsty[RFNTSZ+1],                  /* poll font style                 */
     butsty[RBSYSZ+1];                  /* poll button style               */

char quesbuts[MAXASTGS][MXLWID+1],      /* question button array           */
     qfntsty[RFNTSZ+1],                 /* question font style             */
     qbutsty[RBSYSZ+1];                 /* question button style           */

/* define stgopt() variables                                               */
char *supkey,                      /* super user key for granting stuff    */
     *pllopkey;                    /* Poll-Op key                          */

char *poledit;                     /* used for huprou() to check if vdaptr */
                                   /* is valid for current usrnum          */

/* Begin FSD stuff */
/* define Field Specs String */
static char polfsp[]="\
PNAME \
PDESC \
PTYPE(ALT=POLL ALT=QUESTIONNAIRE MULTICHOICE) \
PPRIOR(ALT=SKIP ALT=ANNOUNCE ALT=ASK ALT=INSIST MULTICHOICE) \
PDATA(ALT=BTRIEVE ALT=ASCII ALT=BOTH ALT=DISCARD MULTICHOICE) \
SBRNCH(ALT=YES ALT=NO MULTICHOICE) \
PREANS(ALT=ONCE ALT=REPLACE ALT=ACCUMULATE MULTICHOICE) \
PCLRDF(ALT=YES ALT=NO MULTICHOICE) \
CREATE \
CLOSE \
LKUPKEY \
RSKEY \
LGKEY \
ACKEY \
ACATT(ALT=SHOW ALT=DIM ALT=HIDE MULTICHOICE) \
GRANTKEY \
GRANTCLS \
GRANTCRD \
GRANTFIL \
DONE(ALT=SAVE ALT=QUIT MULTICHOICE)";

static char polfmt[]="\
PNAME=%s%c\
PDESC=%s%c\
PTYPE=%s%c\
PPRIOR=%s%c\
PDATA=%s%c\
SBRNCH=%s%c\
PREANS=%s%c\
PCLRDF=%s%c\
CREATE=%s%c\
CLOSE=%s%c\
LKUPKEY=%s%c\
RSKEY=%s%c\
LGKEY=%s%c\
ACKEY=%s%c\
ACATT=%s%c\
GRANTKEY=%s%c\
GRANTCLS=%s%c\
GRANTCRD=%s%c\
GRANTFIL=%s%c";

#define PNAMEFLD    0
#define PDESCFLD    1
#define PTYPEFLD    2
#define PRIORFLD    3
#define PDATAFLD    4
#define SBRNCHFLD   5
#define PREANSFLD   6
#define PCLRDFFLD   7
#define CREATFLD    8
#define CLOSEFLD    9
#define LKUPFLD     10
#define RSKEYFLD    11
#define LGKEYFLD    12
#define ACKEYFLD    13
#define ACATTFLD    14
#define GRNTKFLD    15
#define GRNTCLSFLD  16
#define GRNTCFLD    17
#define GRNTFFLD    18

static char qusspc[]="\
ALT=CREDIT_CARD_NUMBER ALT=DATE \
ALT=DISPLAY_ONLY ALT=MULTIPLE_CHOICE ALT=NUMERIC_VALUE \
ALT=OPEN_ENDED_RESPONSE ALT=TRUE/FALSE ALT=YES/NO \
ALT=USER_ACCOUNT MULTICHOICE";

static char polspc[]="\
ALT=MULTIPLE_CHOICE ALT=TRUE/FALSE ALT=YES/NO ALT=DISPLAY_ONLY MULTICHOICE";

/* define question editor fsp,fmt */
static char quesfsp[]="\
QPTYPE \
QPNAME \
QNUM \
QTYPE(%s) \
QFIELD(ALT=NAME ALT=ADDRESS_LINE_1 ALT=ADDRESS_LINE_2 ALT=ADDRESS_LINE_3 \
ALT=ADDRESS_LINE_4 ALT=PHONE_NUMBER ALT=BIRTHDAY ALT=SEX \
ALT=ANSI_SETTING ALT=EDITOR_SETTING ALT=PASSWORD MULTICHOICE) \
QNEXT(MIN=0 MAX=100) \
QPREV(MIN=0 MAX=100) \
QEXMPT(ALT=YES ALT=NO MULTICHOICE) \
QBRNCH(ALT=YES ALT=NO MULTICHOICE) \
QPARAM \
QCLRSCN(ALT=YES ALT=NO MULTICHOICE) \
DONE(ALT=SAVE ALT=QUIT MULTICHOICE)";

static char quesfmt[]="\
QPTYPE=%s%c\
QPNAME=%s%c\
QNUM=%d%c\
QTYPE=%s%c\
QFIELD=%s%c\
QNEXT=%s%c\
QPREV=%s%c\
QEXMPT=%s%c\
QBRNCH=%s%c\
QPARAM=%s%c\
QCLRSCN=%s%c";

#define QPTYPFLD    0
#define QPNAMFLD    1
#define QNUMFLD     2
#define QTYPEFLD    3
#define QFLDFLD     4
#define QNEXTFLD    5
#define QPREVFLD    6
#define QEXEMFLD    7
#define QBRNCHFLD   8
#define QPARAMFLD   9
#define QCLRSCNFLD  10

static char astgfsp[]="\
TSTR01 \
ASTG00 \
ABNM00 \
ASTG01 \
ABNM01 \
ASTG02 \
ABNM02 \
ASTG03 \
ABNM03 \
ASTG04 \
ABNM04 \
ASTG05 \
ABNM05 \
ASTG06 \
ABNM06 \
ASTG07 \
ABNM07 \
ASTG08 \
ABNM08 \
ASTG09 \
ABNM09 \
ASTG10 \
ABNM10 \
ASTG11 \
ABNM11 \
ASTG12 \
ABNM12 \
ASTG13 \
ABNM13 \
ASTG14 \
ABNM14 \
ASTG15 \
ABNM15 \
DONE(ALT=SAVE ALT=QUIT MULTICHOICE)";

static char astgfmt[]="\
TSTR01=%s%c\
ASTG00=%s%c\
ABNM00=%s%c\
ASTG01=%s%c\
ABNM01=%s%c\
ASTG02=%s%c\
ABNM02=%s%c\
ASTG03=%s%c\
ABNM03=%s%c\
ASTG04=%s%c\
ABNM04=%s%c\
ASTG05=%s%c\
ABNM05=%s%c\
ASTG06=%s%c\
ABNM06=%s%c\
ASTG07=%s%c\
ABNM07=%s%c\
ASTG08=%s%c\
ABNM08=%s%c\
ASTG09=%s%c\
ABNM09=%s%c\
ASTG10=%s%c\
ABNM10=%s%c\
ASTG11=%s%c\
ABNM11=%s%c\
ASTG12=%s%c\
ABNM12=%s%c\
ASTG13=%s%c\
ABNM13=%s%c\
ASTG14=%s%c\
ABNM14=%s%c\
ASTG15=%s%c\
ABNM15=%s%c";

#define TSTR01FLD   0
#define ASTG00FLD   1
#define ABNM00FLD   2
#define ASTG01FLD   3
#define ABNM01FLD   4
#define ASTG02FLD   5
#define ABNM02FLD   6
#define ASTG03FLD   7
#define ABNM03FLD   8
#define ASTG04FLD   9
#define ABNM04FLD   10
#define ASTG05FLD   11
#define ABNM05FLD   12
#define ASTG06FLD   13
#define ABNM06FLD   14
#define ASTG07FLD   15
#define ABNM07FLD   16
#define ASTG08FLD   17
#define ABNM08FLD   18
#define ASTG09FLD   19
#define ABNM09FLD   20
#define ASTG10FLD   21
#define ABNM10FLD   22
#define ASTG11FLD   23
#define ABNM11FLD   24
#define ASTG12FLD   25
#define ABNM12FLD   26
#define ASTG13FLD   27
#define ABNM13FLD   28
#define ASTG14FLD   29
#define ABNM14FLD   30
#define ASTG15FLD   31
#define ABNM15FLD   32
/* End FSD stuff */

static
FILE *polmb;                       /* message block file pointer           */

static
BTVFILE *sbb,                      /* user stat file pointer               */
        *pbb,                      /* master data file pointer             */
        *qbb,                      /* question data file pointer           */
        *abb,                      /* answer data file pointer             */
        *tbb;                      /* tally data file buffer pointer       */

static int polrmn;                 /* register module number               */

void EXPORT
init__polmod(void)
{
     int savlang;

     stzcpy(polmod.descrp,gmdnam("GALPOL.MDF"),MNMSIZ);
     polrmn=register_module(&polmod);

     sbb=opnbtv("galp&qs.dat",sizeof(struct pollstat));
     pbb=opnbtv("galp&qp.dat",sizeof(struct polldata));
     qbb=opnbtv("galp&qq.dat",sizeof(struct quesdata));
     abb=opnbtv("galp&qa.dat",sizeof(struct ansrdata));
     tbb=opnbtv("galp&qt.dat",sizeof(struct polltally));
     polmb=opnmsg("galp&q.mcv");
     supkey=stgopt(SUPKEY);
     pllopkey=stgopt(PLLOPKEY);
     if (ripdfd) {
          strcpy(fntsty,PFNTSTY);
          strcpy(butsty,PBUTSTY);
          strcpy(qfntsty,QFNTSTY);
          strcpy(qbutsty,QBUTSTY);
          savlang=clingo;
          clingo=ripidx;
          gtrfsb(DISPPOLL,POLLSPERPG,fntsty,butsty,polbuts);
          gtrfsb(TAKEPOLL,MAXASTGS,qfntsty,qbutsty,quesbuts);
          clingo=savlang;
     }
     poledit=(char *)alczer(sizeof(char)*nterms);
     pollsarr=(struct pollstat *)alczer(sizeof(struct pollstat)*nterms);
     dclvda(fsdroom(POLLATPL,polfsp,0)+sizeof(struct polltemp)-1);
     dclvda(fsdroom(POLLNTPQ,polfsp,0)+sizeof(struct polltemp)-1);
     sprintf(qbb->data,
             quesfsp,sizeof(polspc) > sizeof(qusspc) ? polspc : qusspc);
     dclvda(fsdroom(QUESATPL,qbb->data,0)+sizeof(struct polltemp)-1);
     dclvda(fsdroom(QUESNTPQ,qbb->data,0)+sizeof(struct polltemp)-1);
     dclvda(fsdroom(ASTGATPL,astgfsp,0)+sizeof(struct polltemp)-1);
     dclvda(fsdroom(ASTGNTPQ,astgfsp,0)+sizeof(struct polltemp)-1);
     dclvda(sizeof(struct message)+MSGSIZ);
     rstflgs();
     initasc();
}

STATIC void
gtrfsb(msgno,maxbuts,fstyle,bstyle,butarr)   /* get RIP font & button info */
int msgno,maxbuts;
char *fstyle,*bstyle;
char butarr[][MXLWID+1];
{
     int nfnd=0,sl,loop,len;
     char *cp,*cp2;

     cp=rawmsg(msgno);
     sl=strlen(cp);
     for (loop=0 ; (loop < sl) && (strncmp(cp,RIP_BUTTON,BCSIZ) != 0)
        ; loop++,cp++) {
          if (strncmp(cp,RIP_FONT_STYLE,FSSIZ) == 0) {
               stzcpy(fstyle,cp,RFNTSZ+1);
          }
          else if (strncmp(cp,RIP_BUTTON_STYLE,BSSIZ) == 0) {
               stzcpy(bstyle,cp,RBSYSZ+1);
          }
     }
     while (*cp != '\0' && strlen(cp) >= RBUTSZ && nfnd < maxbuts) {
          if (strncmp(cp,RIP_BUTTON,BCSIZ) == 0) {
               if ((cp2=strstr(cp,"<>")) == NULL) {
                    break;
               }
               if ((cp2=strstr(cp2+2,"<>")) == NULL) {
                    break;
               }
               cp2+=2;
               len=((int)(cp2-cp))+1;
               stzcpy(butarr[nfnd],cp,len);
               strcat(butarr[nfnd],
                 (msgno == TAKEPOLL ? spr("%c",nfnd+65) : spr("%d`M",nfnd+1)));
               nfnd++;
               cp=*cp2 == '\r' ? cp2+1 : cp2;
          }
          else {
               cp++;
          }
     }
     if (nfnd < POLLSPERPG) {
          catastro("GALP&Q: Error in level 6 option %d! (RIP)=%d",msgno,nfnd);
     }
}

STATIC int
polon(void)                             /* supplemental logon routine      */
{
     setptrs();
     chkdft(tp->dftinp);
     if (usrptr->flags&INJOIP) {
          clrinp();
     }
     do {
          bgncnc();
          switch (usrptr->substt) {
          case 0:
               setbtv(pbb);
               if (!qlobtv(0)) {
                    return(0);
               }
               tp->pos=absbtv();
               poledit[usrnum]=0;
               tp->flags|=LONMODE;
               usrptr->substt=LOGON;
               btuinj(usrnum,CYCLE);
               break;
          case POLLASK:
               pollask();
               break;
          case POLLINS:
               pollins();
               break;
          case TAKEPOLL:
          case SHRTPOLL:
               takepoll();
               break;
          case EMGEXIT:
               cncall();
               return(0);
          }
     } while (!endcnc());
     outprf(usrnum);
     return(1);
}

STATIC int
polin(void)                             /* CR terminated input routine     */
{
     setptrs();
     chkdft(tp->dftinp);
     if (usrptr->flags&INJOIP) {
          clrinp();
     }
     do {
          bgncnc();
          switch (usrptr->substt) {
          case 0:
               cncchr();
               usrptr->flags&=~X2MAIN;
               if (!hasmkey(MAINKEY)) {
                    prfmsg(NOACC);
                    return(0);
               }
               /* bounce non-pollops out of module if none are present     */
               if (!isysop && chk4poll() == 0) {
                    prfmsg(NOPOLLS);
                    return(0);
               }
               polmsg(ispollop() == 0 ? WELCOME : WELCOMES,0);
               polmsg(MAIN,1);
               break;
          case MAIN:                    /* module main menu substt         */
               if (polmain() == 0) {
                    return(0);
               }
               break;
          case GETTAKE:                 /* get poll name to take           */
               gettake();
               break;
          case GETRES:                  /* get poll name to view results   */
               getres();
               break;
          case SHWRSLT:                 /* for a given ques# show results  */
               shwrslt();
               break;
          case GETLOOK:                 /* get User-ID to lookup           */
               getlook();
               break;
          case GETLUP:                  /* get poll for looking up user    */
          case MORLUP:
               getlup();
               break;
          case DISSTATS:                /* show stats for lookup user/poll */
               disstats();
               break;
          case DUPPOLL:                 /* duplicate poll name rebuff      */
               duppoll();
               break;
          case NONPOLL:                 /* invalid poll name rebuff        */
               nonpoll();
               break;
          case TAKEPOLL:                /* get answer for current ques#    */
          case SHRTPOLL:
               takepoll();
               break;
          case GETPOLL:                 /* poll-op edit/add poll           */
               getpoll();
               break;
          case EDITPOLL:                /* poll editor menu                */
               editpoll();
               break;
          case DELCONF:                 /* delete confirmation             */
               delconf();
               break;
          case RESCONF:                 /* reset users answer confirmation */
               resconf();
               break;
          case QUESTXT:                 /* edit question text area         */
               loadquestxt();
               break;
          case ADDQUES:                 /* add question prompt             */
               addques();
               break;
          case GETQUES:                 /* edit/add question prompt        */
               getques();
               break;
          case QUESOPTS:                /* question editor menu            */
          case QOSHRT:
               quesopts();
               break;
          case DUNDELQ:                 /* done deleting questions         */
               dundelq();
               break;
          case PNACHNG:
               pnachng();
               break;
          case QNACHNG:
               qnachng();
               break;
          case ANACHNG:
               anachng();
               break;
          }
     } while (!endcnc());
     outprf(usrnum);
     return(1);
}

STATIC void
polsthn(void)                           /* status handler routine          */
{
     setptrs();
     switch (status) {
     case CYCLE:
          switch (usrptr->substt) {
          case LOGON:
               cyc_logon();
               break;
          case GETQUES:
          case ADDQUES:
               cyc_ques();
               break;
          case SHWRSLT:
               cyc_rslt();
               break;
          case TAKEPOLL:
               cyc_tally();
               break;
          case GETLUP:
          case MORLUP:
               cyc_lup();
               break;
          case DISSTATS:
               cyc_disstats();
               break;
          case RESUSRS:
               cyc_resusrs();
               break;
          case RESUSRS2:
               cyc_resusrs2();
               break;
          case DELQUES:
               cyc_delques();
               break;
          case AUTOINC:
               cyc_inc();
               break;
          }
          break;
     default:
          dfsthn();
     }
}

STATIC void
polmsg(msg,mode)                        /* output msg and change substt    */
int msg,mode;
{
     int fnd;

     if (status == CYCLE || !morcnc()) {
          switch(msg) {
          case MAIN:
          case MNSHRT:
               btumil(usrnum,DFTIMX);
               prfmsg(ispollop() == 0 ? msg : msg+1);
               break;
          case MAININFO:
               prfmsg(msg);
               return;
          case EDITPOLL:
               if (tp->pdata.flags&ADDP) {
                    tp->pdata.flags&=~ADDP;
                    tp->pdata.flags|=EDITP;
                    setbtv(pbb);
                    if (acqbtv(NULL,tp->pdata.pname,0)) {
                         updbtv(&tp->pdata);
                    }
               }
               btumil(usrnum,DFTIMX);
               prfmsg(msg,type[tp->pdata.polltype],tp->pdata.pname);
               break;
          case POLLNF:
          case POLLAE:
          case POLLEXP:
          case POLLTDL:
               prfmsg(msg,tp->tstr);
               break;
          case USRTKGP:
               prfmsg(msg,tp->pdata.pname);
               break;
          case AUTOINC:
               prfmsg(msg);
               tp->wheel=tp->cur=0;
               btulok(usrnum,1);
               btuinj(usrnum,CYCLE);
               break;
          case ADDQUES:
               btumil(usrnum,DFTIMX);
               if (tp->qdata.qnum == 0) {
                    prfmsg(ADDFQUES,tp->qdata.qnum+1);
               }
               else {
                    prfmsg(msg,tp->qdata.qnum+1);
               }
               break;
          case QUESNF:
               prfmsg(msg,qcomp.qnum+1,type[tp->pdata.polltype],
                    tp->pdata.pname);
               break;
          case DUPPOLL:
               prfmsg(msg,tp->pdata.pname);
               break;
          case SAVEPOLL:
               prfmsg(msg,type[tp->pdata.polltype],tp->pdata.pname);
               break;
          case SAVEQUES:
               prfmsg(msg,tp->qdata.qnum+1);
               break;
          case DELQUES:
               prfmsg(msg,tp->qdata.qnum+1);
               tp->wheel=0;
               btulok(usrnum,1);
               btuinj(usrnum,CYCLE);
               break;
          case DUNDELQ:
               prfmsg(CLRWHL);
               prfmsg(msg,tp->qdata.qnum+1);
               break;
          case COMPPOLL:
               btumil(usrnum,DFTIMX);
               setbtv(sbb);
               stzcpy(sp->uid,usaptr->userid,UIDSIZ);
               stzcpy(sp->pname,tp->pdata.pname,PNAMELEN);
               stzcpy(scomp.uid,usaptr->userid,UIDSIZ);
               stzcpy(scomp.pname,tp->pdata.pname,PNAMELEN);
               if (!qeqbtv(&scomp,0)) {
                    insbtv(sp);
                    if (tp->pdata.data != DISCARD) {
                         prfmsg(msg,type[tp->pdata.polltype],tp->pdata.pname);
                    }
                    grantstf();
               }
               else {
                    prfmsg(msg+1,type[tp->pdata.polltype],tp->pdata.pname);
                    gcrbtv(NULL,0);
                    if (tp->pdata.data != DISCARD) {
                         updbtv(sp);
                    }
               }
               rstbtv();
               break;
          case QUESOPTS:
               prfmsg(msg,tp->pdata.pname,tp->qdata.qnum+1);
               if (tp->qdata.qtype == MULTICHC) {
                    prfmsg(msg+1);
               }
               prfmsg(msg+2);
               break;
          case QOSHRT:
               prfmsg(tp->qdata.qtype == MULTICHC ? msg : msg+1);
               break;
          case QUESTXT:
               if (tp->qdata.qtype == MULTICHC) {
                    prfmsg(msg+1,MAXASTGS);
               }
               else {
                    prfmsg(msg);
               }
               break;
          case GETRES:
          case GETPOLL:
          case GETTAKE:
               btumil(usrnum,DFTIMX);
               if (msg == GETPOLL && !(tp->flags&LONMODE)
                 && poledit[usrnum]) {
                    if (usrptr->substt != MAIN) {
                         /* unlock poll for others to use                  */
                         if (tp->pdata.flags&(EDITP|ADDP)) {
                              tp->pdata.flags&=~(EDITP+ADDP);
                              poledit[usrnum]=0;
                              setbtv(pbb);
                              if (acqbtv(NULL,tp->pdata.pname,0)) {
                                   updbtv(&tp->pdata);
                              }
                         }
                    }
               }
               if (msg == GETTAKE && (tp->flags&LONMODE)) {
                    usrptr->substt=LOGON;
                    nxtpoll();
                    poldft(msg);
                    return;
               }
               usrptr->substt=msg;
               if (listpolls() == 0) {
                    if (msg == GETTAKE || msg == GETRES) {
                         polmsg(MAIN,1);
                         poldft(msg);
                         return;
                    }
               }
               if (!(tp->flags&MORELIST)) {
                    prfmsg(msg);
               }
               poldft(msg);
               return;
          case TAKEPOLL:
               acomp.qnum=tp->qdata.qnum;
               stzcpy(acomp.pollname,tp->pdata.pname,PNAMELEN);
               stzcpy(acomp.uid,usaptr->userid,UIDSIZ);
               setmem(&tp->adata,sizeof(struct ansrdata),0);
               setbtv(abb);
               fnd=acqbtv(&tp->adata,&acomp,0) ? 1 : 0;
               setinplen();
               if (isripu()) {
                    prfmsg(TPCLR);
                    if (ismult()) {
                         prf("\r!%s%s",qfntsty,qbutsty);
                         showmult(2);
                    }
                    prf("\r!|e%s",RNMOR3);
                    prf("\r[0;1;32m%s\r\r",tp->qdata.txtmsg);
                    outprf(usrnum);
                    clrprf();
               }
               else {
                    if (tp->qdata.flags&CLRSCN) {
                         prfmsg(CLEARSCN);
                    }
                    prfmsg(msg,tp->qdata.txtmsg);
               }
               if (tp->qdata.qtype == DISONLY) {
                    prfmsg(DISPONLY);
                    break;
               }
               else if (ismult()) {
                    showmult(0);
               }
               if (fnd && tp->pdata.data != DISCARD
                && tp->pdata.data != ASCII && !(tp->qdata.flags&EXMPT)) {
                    prfmsg(CURANS,tp->adata.answer);
                    if (tp->qdata.qtype == OPEN_ENDED) {
                         prfmsg(tp->qdata.qnum == 0 ? CUROEAEF : CUROEAEP);
                    }
                    else {
                         if (tp->qdata.ansparam == 1) {
                              prfmsg(tp->qdata.qnum == 0 ? CURANSF : CURANSP);
                         }
                         else {
                              prfmsg(tp->qdata.qnum == 0 ? CURANSFM : CURANSPM,
                                   tp->qdata.ansparam);
                         }
                    }
               }
               else {
                    if (tp->qdata.qtype == OPEN_ENDED) {
                         prfmsg(tp->qdata.qnum == 0 ? CUROEAIF : CUROEAIP);
                    }
                    else {
                         setmem(&tp->adata,sizeof(struct ansrdata),0);
                         if (tp->qdata.ansparam == 1) {
                              prfmsg(tp->qdata.qnum == 0 ? SHRTPOLF : SHRTPOLL);
                         }
                         else {
                              prfmsg(tp->qdata.qnum == 0 ? SHRTPLFM : SHRTPOLM,
                                   tp->qdata.ansparam);
                         }
                    }
               }
               rstbtv();
               break;
          case SAVEMULT:
               prfmsg(msg,tp->qdata.qnum+1);
               break;
          case BADANSR:
               prfmsg(msg,tp->qdata.ansparam,
                    tp->qdata.ansparam == 1 ? "" : "s");
               break;
          case SHWRSLT:
               setbtv(tbb);
               if (!acqbtv(&tally,tp->pdata.pname,0)) {
                    prfmsg(NORSLTS);
                    polmsg(GETRES,1);
                    return;
               }
               tp->ques=0;
               btuinj(usrnum,CYCLE);
               break;
          case GETLUP:
               btumil(usrnum,DFTIMX);
               setbtv(sbb);
               if (!acqbtv(sp,tp->tmpid,1)) {
                    rstbtv();
                    prfmsg(NOSTATS,tp->tmpid);
                    prfmsg(usrptr->substt=GETLOOK);
                    poldft(msg);
                    return;
               }
               tp->oldpos=tp->pos=absbtv();
               tp->ans=0;
               rstbtv();
               btuinj(usrnum,CYCLE);
               break;
          case MORLUP:
               btuinj(usrnum,CYCLE);
               break;
          case DISSTATS:
               btuinj(usrnum,CYCLE);
               break;
          case POLLINS:
               prfmsg(msg,type[tp->pdata.polltype]);
               break;
          case POLLASK:
          case POLLANC:
               prfmsg(msg,type[tp->pdata.polltype],tp->pdata.pname);
               break;
          case DELCONF:
               prfmsg(msg,type[tp->pdata.polltype],tp->pdata.pname,
                    type[tp->pdata.polltype]);
               break;
          case RESCONF:
               prfmsg(msg,type[tp->pdata.polltype],tp->pdata.pname,
                    type[tp->pdata.polltype]);
               break;
          case POLLDEL:
               shocst("P&Q POLL TAGGED FOR DELETE",
                      "Poll %s tagged by %s for delete",
                      tp->pdata.pname,usaptr->userid);
               setbtv(pbb);
               geqbtv(&tp->pdata,tp->pdata.pname,0);
               tp->pdata.flags|=DELETE;
               updbtv(&tp->pdata);
               prfmsg(msg,type[tp->pdata.polltype],tp->pdata.pname);
               break;
          case RESUSRS:
               btulok(usrnum,1);
               prfmsg(msg,tp->pdata.pname);
               tp->ans=0;
               tp->wheel=0;
               btuinj(usrnum,CYCLE);
               break;
          case RESDUN:
               prfmsg(CLRWHL);
               btulok(usrnum,0);
               prfmsg(msg,tp->pdata.pname);
               break;
          case GETQUES:
               tp->flags&=~MORELIST;
               prfmsg(tp->qdata.qnum < MAXQUES-1 ? msg : msg+1);
               break;
          case ERRUPD:
               prfmsg(msg,type[tp->pdata.polltype]);
               break;
          case RSLTPMT:
               prfmsg(tp->ques-1 > tp->fques ? msg : msg+1);
               break;
          default:
               prfmsg(msg);
          }
     }
     if (mode == 1) {
          usrptr->substt=msg;
     }
     poldft(msg);
}

STATIC int
ispollop(void)                          /* check if user has Poll-Op key   */
{
     if (haskey(pllopkey) || isysop()) {
          return(1);
     }
     return(0);
}

STATIC int
isysop(void)                           /* check if user has Super user key */
{
     return(haskey(supkey) ? 1 : 0);
}


STATIC int
dunques(flags)                          /* FSE dunedt() routine            */
int flags;
{
     setmbk(polmb);
     usrptr->state=polrmn;
     if (!(flags&ED_QUITEX)) {
          if (tp->qdata.qtype == MULTICHC && !(tp->qdata.flags&EDITQ)) {
               editmult(1);
          }
          else {
               polmsg(SAVEQUES,0);
               if (tp->qdata.flags&EDITQ) {
                    polmsg(QUESOPTS,1);
               }
               else {
                    saveques(1);
                    polmsg(AUTOINC,1);
               }
          }
     }
     else {
          polmsg(QTXTABRT,0);
          setbtv(qbb);
          qcomp.qnum=tp->qdata.qnum;
          stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
          if (acqbtv(NULL,&qcomp,0)) {
               stzcpy(tp->qdata.txtmsg,qptr->txtmsg,TXTSIZ);
          }
          polmsg((tp->qdata.flags&EDITQ) ? QUESOPTS : AUTOINC,1);
     }
     outprf(usrnum);
     return(1);
}

STATIC int
listpolls(void)                         /* poll listing routine            */
{
     int i=0,more=0,attribute;

     setbtv(pbb);
     setmbk(polmb);
     if (tp->flags&MORELIST) {
          tp->flags&=~MORELIST;
          more=1;
          gabbtv(&tp->pdata,(tp->oldpos=tp->pos),0);
     }
     else {
          if (!qlobtv(0)) {
               if (isripu()) {
                    prfmsg(GTHDR);
                    prfmsg(MAINHDR);
               }
               polmsg(NOPOLLS,0);
               rstbtv();
               return(0);
          }
     }
     setmem(tp->select,POLLSPERPG*PNAMELEN,0);
     do {
          gcrbtv(&tp->pdata,0);
          if (i == 0) {
               tp->oldpos=absbtv();
          }
          if (usrptr->substt == GETRES) {
               if (tp->pdata.polltype != POLL
                 || !haskey(tp->pdata.res_key)
                 || tp->pdata.data == DISCARD || tp->pdata.data == ASCII) {
                    continue;
               }
          }
          if (usrptr->substt != GETPOLL && (tp->pdata.flags&DELETE)) {
               continue;
          }
          if (usrptr->substt == GETTAKE && notexp() == 0) {
               continue;
          }
          attribute=1;
          if (!ispollop() && !chk_clearance()) {
               if (tp->pdata.acc_attr == HIDE) {
                    continue;
               }
               attribute=tp->pdata.acc_attr == DIM ? 0 : 1;
          }
          stzcpy(tp->select[i++],tp->pdata.pname,PNAMELEN);
          if (i == 1) {
               if (!isripu()) {
                    switch (usrptr->substt) {
                    case GETRES:
                         prfmsg(GRHDR);
                         break;
                    case GETPOLL:
                         prfmsg(GPHDR);
                         break;
                    default:
                         prfmsg(GTHDR);
                    }
               }
               else if (!more) {
                    prfmsg(GTHDR);
               }
               prfmsg(MAINHDR);
               if (isripu()) {
                    prf("\r!%s%s",fntsty,butsty);
               }
          }
          if (!isripu()) {
               prfmsg(DISPPOLL,
                    attribute,i,attribute,tp->pdata.pname,tp->pdata.pdesc,
                    pstat[polstat()]);
          }
          else {
               prf("\r!");
               prf(polbuts[i-1],i,tp->pdata.pname,tp->pdata.pdesc,
                    pstat[polstat()]);
          }
     } while (i < POLLSPERPG && qnxbtv());
     if (isripu()) {
          prf("\r!%s",RNMOR3);
     }
     if (i == 0) {
          polmsg(NOPOLLS,0);
          rstbtv();
          return(0);
     }
     else if (i == POLLSPERPG) {
          if (qnxbtv()) {
               gcrbtv(&tp->pdata,0);
               tp->flags|=MORELIST;
               tp->pos=absbtv();
               switch (usrptr->substt) {
               case GETRES:
                    prfmsg(MORERES);
                    break;
               case GETPOLL:
                    prfmsg(MORPOLL);
                    break;
               default:
                    prfmsg(MOREGT);
               }
          }
          else {
               tp->pos=tp->oldpos;
          }
     }
     rstbtv();
     return(1);
}

STATIC int
chk4poll(void)                          /* check if poll should be displayed*/
{
     setbtv(pbb);
     if (qlobtv(0)) {
          do {
               gcrbtv(&tp->pdata,0);
               if (!haskey(tp->pdata.acc_key)) {
                    if (tp->pdata.acc_attr == HIDE) {
                         continue;
                    }
                    else {
                         return(1);
                    }
               }
               else {
                    return(1);
               }
          } while (qnxbtv());
     }
     return(0);
}

STATIC int
polmain(void)                           /* main menu input routine         */
{
     int chr;
     tp->flags&=~MORELIST;
     if (!morcnc()) {
          polmsg((isripu() ? MAIN : MNSHRT),0);
          return(1);
     }
     if ((chr=morcnc()) == '?') {
          cncall();
          polmsg(MAIN,1);
     }
     else if (margc == 1 && chr == 'X' && sameas(margv[0],"x")) {
          cncall();
          if (!(tp->flags&LONMODE)) {
               prfmsg(EXIT);
          }
          return(0);
     }
     else if (chr == 'G') {             /* general information             */
          cncall();
          polmsg(MAININFO,0);
          condex();
          polmsg((isripu() ? MAIN : MNSHRT),0);
     }
     else if (chr == 'T') {             /* take a poll                     */
          cncchr();
          polmsg(GETTAKE,1);
     }
     else if (chr == 'R') {             /* view results for polls          */
          cncchr();
          tp->fques=0;
          tp->flags&=~(FNDFIRST+REVERSE);
          polmsg(GETRES,1);
     }
     else if (chr == 'L') {             /* lookup an individuals results   */
          cncchr();
          polmsg(GETLOOK,1);
     }
     else if (chr == 'S' && ispollop()) {   /* Poll-Op maintenance          */
          cncchr();
          polmsg(GETPOLL,1);
     }
     else {
          prfmsg(CMDNOTU,cncall());
          polmsg(MAIN,1);
     }
     return(1);
}

STATIC void
addprp(msgno,amode)                 /* prepare for user information editing */
int msgno;
int amode;                /* 1=full-screen entry, 0=linear entry -1=display */
{
     setmbk(polmb);
     sprintf(vdatmp,polfmt,
          tp->pdata.pname,'\0',
          tp->pdata.pdesc,'\0',
          types[tp->pdata.polltype],'\0',
          priors[tp->pdata.priority],'\0',
          stypes[tp->pdata.data],'\0',
          (tp->pdata.flags&DISBRANCH) ? "YES" : "NO",'\0',
          atypes[tp->pdata.answer],'\0',
          (tp->pdata.flags&CLRDFLT) ? "YES" : "NO",'\0',
          spr("%s",ncdate(tp->pdata.createdate)),'\0',
          spr("%s",ncdate(tp->pdata.closedate)),'\0',
          tp->pdata.lookup_key,'\0',
          tp->pdata.res_key,'\0',
          tp->pdata.logon_key,'\0',
          tp->pdata.acc_key,'\0',
          atts[tp->pdata.acc_attr],'\0',
          tp->pdata.grant_key,'\0',
          tp->pdata.grant_class,'\0',
          l2as(tp->pdata.grant_crd),'\0',
          tp->pdata.grant_file,'\0');
     fsdroom(msgno,polfsp,amode);
     fsdapr(tp->fsdbuf,vdasiz,vdatmp);
}

STATIC char *
polrft(void)                            /* poll FSD reformat routine       */
{
     char *templt;

     switch(fsdusr->amode) {
     case 1:
          templt=getasc(fsdusr->tmpmsg);
          break;
     case 0:
          templt=NULL;
          break;
     case -1:
          templt=rawmsg(fsdusr->tmpmsg);
     }
     if (!isysop()) {
          tpwipe(templt,GRNTKFLD,1,1);
          tpwipe(templt,GRNTCLSFLD,1,1);
          tpwipe(templt,GRNTCFLD,1,1);
          tpwipe(templt,GRNTFFLD,1,1);
     }
     return(templt);
}

STATIC
int
polvfy(fldno,answer)                    /* poll FSD verify routine         */
int fldno;
char *answer;
{
     switch (fldno) {
     case PTYPEFLD:      /* on questionnaire protect RESULTS KEY           */
          if (sameas(answer,types[2])) {     /* if this is a QUESTIONNAIRE */
               fsdscb->flddat[RSKEYFLD].flags|=FFFAVD;
          }
          else {                             /* else it's a POLL           */
               fsdscb->flddat[RSKEYFLD].flags&=~FFFAVD;
          }
          break;
     case PDESCFLD:
          while (*answer == ' ') {
               strcpy(answer,&answer[1]);
          }
          break;
     case PNAMEFLD:
          while (*answer == ' ') {
               strcpy(answer,&answer[1]);
          }
     case LKUPFLD:
     case RSKEYFLD:
     case LGKEYFLD:
     case ACKEYFLD:
     case GRNTKFLD:
     case GRNTCLSFLD:
          strupr(answer);
          break;
     case GRNTFFLD:
          strupr(answer);
          if (rsvnam(answer)) {
               stzcpy(answer,tp->pdata.grant_file,PTHFILSIZ);
          }
          break;
     case CLOSEFLD:
          stripb(answer);
          if (!okdate(answer)) {
               strcpy(answer,ncdate(tp->pdata.closedate));
          }
     }
     return(vfyadn(fldno,answer));
}

STATIC void
poldun(save)                            /* poll FSD when done routine      */
int save;
{
     setmbk(polmb);
     usrptr->state=polrmn;
     if (!save) {
          prfmsg(POLLQUIT);
          polmsg((tp->pdata.flags&(EDITP|ADDP)) ? EDITPOLL : GETPOLL,1);
     }
     else {
          fsdfxt(PNAMEFLD,tp->pdata.pname,PNAMELEN);
          fsdfxt(PDESCFLD,tp->pdata.pdesc,PDESCLEN);
          tp->pdata.polltype=fsdord(PTYPEFLD)+1;
          if (tp->pdata.polltype == 0) {
               tp->pdata.polltype++;
          }
          tp->pdata.data=fsdord(PDATAFLD)+1;
          tp->pdata.priority=fsdord(PRIORFLD)+1;
          tp->pdata.answer=fsdord(PREANSFLD)+1;
          tp->pdata.createdate=dcdate(fsdnan(CREATFLD));
          tp->pdata.closedate=dcdate(fsdnan(CLOSEFLD));
          fsdfxt(LKUPFLD,tp->pdata.lookup_key,KEYLEN);
          fsdfxt(RSKEYFLD,tp->pdata.res_key,KEYLEN);
          fsdfxt(LGKEYFLD,tp->pdata.logon_key,KEYLEN);
          fsdfxt(ACKEYFLD,tp->pdata.acc_key,KEYLEN);
          tp->pdata.acc_attr=fsdord(ACATTFLD)+1;
          fsdfxt(GRNTKFLD,tp->pdata.grant_key,KEYLEN);
          fsdfxt(GRNTCLSFLD,tp->pdata.grant_class,KEYLEN);
          fsdfxt(GRNTFFLD,tp->pdata.grant_file,PTHFILSIZ);
          tp->pdata.grant_crd=atol(fsdnan(GRNTCFLD));
          if (fsdord(SBRNCHFLD)+1 != 2) {
               tp->pdata.flags|=DISBRANCH;
          }
          if (fsdord(PCLRDFFLD)+1 != 2) {
               tp->pdata.flags|=CLRDFLT;
          }
          else {
               tp->pdata.flags&=~CLRDFLT;
          }
          setbtv(pbb);
          if (tp->pdata.flags&EDITP) {
               if (acqbtv(NULL,tp->pdata.pname,0)) {
                    updbtv(&tp->pdata);
                    shocst("P&Q POLL UPDATED","Poll %s has been updated by %s",
                         tp->pdata.pname,usaptr->userid);
               }
               else {
                    polmsg(ERRUPD,0);
               }
               polmsg(EDITPOLL,1);
          }
          else {
               tp->pdata.flags|=ADDP;
               poledit[usrnum]=1;
               if (strlen(tp->pdata.pname) < 3) {
                    polmsg(NONPOLL,1);
               }
               else if (dinsbtv(&tp->pdata)) {
                    shocst("P&Q NEW POLL ADDED","Poll %s has been added by %s",
                         tp->pdata.pname,usaptr->userid);
                    polmsg(SAVEPOLL,0);
                    polmsg(AUTOINC,1);
               }
               else {
                    polmsg(DUPPOLL,1);
               }
          }
          rstbtv();
     }
}

STATIC void
polptc(void)                            /* poll FSD protect routine        */
{
     fsdscb->flddat[CREATFLD].flags|=FFFAVD;
     if (strlen(tp->pdata.pname) > 0) {      /* differentiate edit/add     */
          fsdscb->flddat[PNAMEFLD].flags|=FFFAVD; /* can't change key      */
     }
     if (!isysop()) {
          fsdscb->flddat[GRNTKFLD].flags|=FFFAVD;
          fsdscb->flddat[GRNTCLSFLD].flags|=FFFAVD;
          fsdscb->flddat[GRNTCFLD].flags|=FFFAVD;
          fsdscb->flddat[GRNTFFLD].flags|=FFFAVD;
     }
}

STATIC void
quesptc(void)                           /* question FSD protect routine    */
{
     fsdscb->flddat[QPNAMFLD].flags|=FFFAVD;
     fsdscb->flddat[QPTYPFLD].flags|=FFFAVD;
     fsdscb->flddat[QNUMFLD].flags|=FFFAVD;
     fsdscb->flddat[QFLDFLD].flags|=FFFAVD;
     if (tp->qdata.qnum == 0) {                   /* N/A for first question*/
          fsdscb->flddat[QPREVFLD].flags|=FFFAVD;
     }
     if (tp->qdata.qnum == MAXQUES-1) {           /* N/A for last question */
          fsdscb->flddat[QNEXTFLD].flags|=FFFAVD;
     }
     if (tp->qdata.qtype == DISONLY) {       /* display only               */
          fsdscb->flddat[QEXEMFLD].flags|=FFFAVD;
     }
     if (tp->pdata.polltype != QUEST) {
          if (tp->qdata.qtype == MULTICHC || tp->qdata.qtype == 0) {
               if (tp->qdata.flags&BRANCH) {
                    fsdscb->flddat[QPARAMFLD].flags|=FFFAVD;
               }
          }
          else {
               fsdscb->flddat[QPARAMFLD].flags|=FFFAVD;
               fsdscb->flddat[QBRNCHFLD].flags|=FFFAVD;
          }
     }
     else {
          fsdscb->flddat[QBRNCHFLD].flags|=FFFAVD;
     }
}

STATIC void
quesprp(msgno,amode)               /* prepare for user information editing */
int msgno;
int amode;               /* 1=full-screen entry, 0=linear entry -1=display */
{
     setmbk(polmb);
     sprintf(qbb->data,quesfsp,tp->pdata.polltype == QUEST ? qusspc : polspc);
     fsdroom(msgno,qbb->data,amode);
     sprintf(vdatmp,quesfmt,
          types[tp->pdata.polltype],'\0',
          tp->qdata.pollname,'\0',
          tp->qdata.qnum+1,'\0',
          qtypes[tp->qdata.qtype == 0 ? tp->pdata.polltype == QUEST ? 0 : 4
                                      : tp->qdata.qtype],'\0',
          tp->qdata.qtype == 9 ? uaflds[tp->qdata.field] : "",'\0',
          tp->qdata.qnum == MAXQUES-1 ? "N/A" : spr("%d",tp->qdata.next+1),'\0',
          tp->qdata.qnum == 0 ? "N/A" : spr("%d",tp->qdata.prev+1),'\0',
          yesno[(tp->qdata.flags&EXMPT) ? 1 : 2],'\0',
          yesno[(tp->qdata.flags&BRANCH) ? 1 : 2],'\0',
          (tp->qdata.qtype == 0 && tp->pdata.polltype == QUEST)
          || (tp->pdata.polltype != QUEST
          && tp->qdata.qtype != 0 && tp->qdata.qtype != MULTICHC)
               ? "N/A" : spr("%d",tp->qdata.ansparam),'\0',
          yesno[(tp->qdata.flags&CLRSCN) ? 1 : 2],'\0');
     fsdapr(tp->fsdbuf,vdasiz,vdatmp);
}

STATIC char *
quesrft(void)                           /* question FSD reformat routine   */
{
     char *templt;

     switch(fsdusr->amode) {
     case 1:
          templt=getasc(fsdusr->tmpmsg);
          break;
     case 0:
          templt=NULL;
          break;
     case -1:
          templt=rawmsg(fsdusr->tmpmsg);
     }
     if (tp->pdata.polltype != QUEST) {
          tpwipe(templt,QFLDFLD,1,1);
     }
     return(templt);
}

STATIC
int
quesvfy(fldno,answer)                   /* question FSD verify routine     */
int fldno;
char *answer;
{
     int i;

     switch (fldno) {
     case QTYPEFLD:
          for (i=0 ; i < 9 ; i++) {
               if (sameas(qtypes[i],answer)) {
                    break;
               }
          }
          if (i == 9) {                      /* USER_ACCOUNT question type */
               fsdscb->flddat[QFLDFLD].flags&=~FFFAVD; /* unprotect ua fld */
               if (fsdscb->xitkey == '\r' || fsdscb->xitkey == TAB
                || fsdscb->xitkey == CRSRDN) {
                    fsdscb->crsfld=fldno+1;
                    strcpy(answer,qtypes[9]);
               }
               fsdsan(fldno+1,uaflds[0]);
          }
          else {
               fsdscb->flddat[QFLDFLD].flags|=FFFAVD;       /* set defaults*/
               fsdsan(fldno+1,"");
          }
          fldptr=fsdscb->flddat+fldno+1;     /* set pointer to QFLDFLD     */
          if (fsdscb->flags&FSDANS) {
               shofld(fldptr->attr,1);       /* show QFLDFLD data          */
          }
          if (i == DISONLY) {                /* display only qtype         */
               fsdscb->flddat[QEXEMFLD].flags |=FFFAVD;
          }
          else {
               fsdscb->flddat[QEXEMFLD].flags &=~FFFAVD;
          }
          if (i == MULTICHC) {  /* allow branching for multiple choice only*/
               fsdscb->flddat[QBRNCHFLD].flags&=~FFFAVD;
               fsdscb->flddat[QPARAMFLD].flags|=FFFAVD;
               fsdsan(QPARAMFLD,"1");
          }
          else {
               fsdsan(QBRNCHFLD,yesno[2]);
               fldptr=fsdscb->flddat+QBRNCHFLD;
               shofld(fldptr->attr,1);
               fsdscb->flddat[QBRNCHFLD].flags|=FFFAVD;
               fsdscb->flddat[QPARAMFLD].flags|=FFFAVD;
               fsdsan(QPARAMFLD,"N/A");

          }
          fldptr=fsdscb->flddat+QPARAMFLD;   /* set pointer to QPARAMFLD   */
          if (fsdscb->flags&FSDANS) {
               shofld(fldptr->attr,1);       /* show QPARAMFLD data        */
          }
          fldptr=fsdscb->flddat+fldno;
          strcpy(answer,qtypes[i]);
          break;
     case QNEXTFLD:
          if ((i=atoi(answer)) <= 0 || i > MAXQUES || i == tp->qdata.qnum+1
            || i == atoi(fsdnan(QPREVFLD))) {
               strcpy(answer,spr("%d",tp->qdata.qnum+2));
          }
          break;
     case QPREVFLD:
          if ((i=atoi(answer)) <= 0 || i >= MAXQUES || i == tp->qdata.qnum+1
            || i == atoi(fsdnan(QNEXTFLD))) {
               strcpy(answer,spr("%d",tp->qdata.qnum));
          }
          break;
     case QBRNCHFLD:
          if (sameas(answer,yesno[0])) {
               fsdscb->flddat[QPARAMFLD].flags|=FFFAVD;
               fsdsan(QPARAMFLD,"1");
               fldptr=fsdscb->flddat+QPARAMFLD;
               if (fsdscb->flags&FSDANS) {
                    shofld(fldptr->attr,1);
               }
               fldptr=fsdscb->flddat+fldno;
               strcpy(answer,yesno[0]);
          }
          else {
               if (fsdscb->flddat[QPARAMFLD].flags&FFFAVD) {
                    fsdscb->flddat[QPARAMFLD].flags&=~FFFAVD;
                    if (fsdscb->xitkey == '\r'
                     || fsdscb->xitkey == TAB
                     || fsdscb->xitkey == CRSRDN) {
                         fsdscb->crsfld=fldno+1;
                    }
               }
          }
          break;
     case QPARAMFLD:
          if ((i=atoi(answer)) <= 0 || i > MAXPARAM) {
               strcpy(answer,"1");
          }
     }
     return(vfyadn(fldno,answer));
}

STATIC void
quesdun(save)                           /* question FSD when done routine  */
int save;
{
     setmbk(polmb);
     usrptr->state=polrmn;
     if (!save) {
          prfmsg(QUESABRT);
          if (tp->qdata.flags&EDITQ) {
               polmsg(QUESOPTS,1);
          }
          else {
               polmsg(AUTOINC,1);
          }
     }
     else {
          tp->qdata.qtype=fsdord(QTYPEFLD)+1;
          if (tp->pdata.polltype != QUEST) {
               switch (tp->qdata.qtype) {
               case 0:
               case 1:
                    tp->qdata.qtype=MULTICHC;
                    break;
               case 2:
                    tp->qdata.qtype=TRUEFALSE;
                    break;
               case 3:
                    tp->qdata.qtype=YESNO;
                    break;
               case 4:
                    tp->qdata.qtype=DISONLY;
               }
          }
          tp->qdata.field=fsdord(QFLDFLD)+1;
          qtypevfy();
          if (!sameas(fsdnan(QNEXTFLD),"N/A")) {
               tp->qdata.next=atoi(fsdnan(QNEXTFLD))-1;
          }
          else {
               tp->qdata.next=MAXQUES;
          }
          tp->qdata.ansparam=atoi(fsdnan(QPARAMFLD));
          if (tp->qdata.ansparam == 0) {     /* answer parameters must be  */
               tp->qdata.ansparam=1;         /* greater than 0.            */
          }
          tp->qdata.prev=tp->qdata.qnum == 0 ? 0 : atoi(fsdnan(QPREVFLD))-1;
          if (fsdord(QEXEMFLD)+1 != 2) {     /* if user answers YES        */
               tp->qdata.flags|=EXMPT;       /* exempt answer from data    */
          }
          else {
               tp->qdata.flags&=~EXMPT;
          }
          if (fsdord(QBRNCHFLD)+1 != 2) {    /* if user answer YES         */
               tp->qdata.flags|=BRANCH;      /* enable branching           */
          }
          else {
               tp->qdata.flags&=~BRANCH;
          }
          if (fsdord(QCLRSCNFLD)+1 != 2) {   /* if clear screen on display */
               tp->qdata.flags|=CLRSCN;
          }
          else {
               tp->qdata.flags&=~CLRSCN;
          }
          polmsg((tp->qdata.flags&EDITQ) ? QUESOPTS : QUESTXT,1);
     }
}

STATIC void
astgprp(msgno,amode)                /* prepare for user information editing */
int msgno;
int amode;                /* 1=full-screen entry, 0=linear entry -1=display */
{
     int i;
     char *cp;
     static char branch[MAXASTGS][4];

     setmbk(polmb);
     setmem(branch,MAXASTGS*4,0);
     stzcpy(tp->tstr,tp->qdata.txtmsg,70);
     for (cp=tp->tstr ; *cp != '\0' ; cp++) {
          if (*cp == 13 || *cp == 10) {
               *cp=32;
          }
     }
     cp=tp->tstr;
     while (*cp == 32) {
          cp++;
     }
     for (i=0 ; i < MAXASTGS ; i++) {
          if (tp->qdata.flags&BRANCH) {
               if (tp->qdata.branch[i] == 0) {
                    sprintf(branch[i],"%d",
                         (tp->qdata.branch[i]=tp->qdata.next)+1);
               }
               else {
                    sprintf(branch[i],"%d",tp->qdata.branch[i]+1);
               }
          }
          else {
               stzcpy(branch[i],"",4);
          }
     }
     sprintf(vdatmp,astgfmt,
          cp,'\0',
          tp->qdata.ansstg[0],'\0',
          branch[0],'\0',
          tp->qdata.ansstg[1],'\0',
          branch[1],'\0',
          tp->qdata.ansstg[2],'\0',
          branch[2],'\0',
          tp->qdata.ansstg[3],'\0',
          branch[3],'\0',
          tp->qdata.ansstg[4],'\0',
          branch[4],'\0',
          tp->qdata.ansstg[5],'\0',
          branch[5],'\0',
          tp->qdata.ansstg[6],'\0',
          branch[6],'\0',
          tp->qdata.ansstg[7],'\0',
          branch[7],'\0',
          tp->qdata.ansstg[8],'\0',
          branch[8],'\0',
          tp->qdata.ansstg[9],'\0',
          branch[9],'\0',
          tp->qdata.ansstg[10],'\0',
          branch[10],'\0',
          tp->qdata.ansstg[11],'\0',
          branch[11],'\0',
          tp->qdata.ansstg[12],'\0',
          branch[12],'\0',
          tp->qdata.ansstg[13],'\0',
          branch[13],'\0',
          tp->qdata.ansstg[14],'\0',
          branch[14],'\0',
          tp->qdata.ansstg[15],'\0',
          branch[15],'\0');
     fsdroom(msgno,astgfsp,amode);
     fsdapr(tp->fsdbuf,vdasiz,vdatmp);
}

STATIC char *
astgrft(void)                           /* answer FSD reformat routine     */
{
     char *templt;

     switch(fsdusr->amode) {
     case 1:
          templt=getasc(fsdusr->tmpmsg);
          break;
     case 0:
          templt=NULL;
          break;
     case -1:
          templt=rawmsg(fsdusr->tmpmsg);
     }
     if (!(tp->qdata.flags&BRANCH)) {   /* hide branching                  */
          tpwipe(templt,ABNM00FLD,1,1);
          tpwipe(templt,ABNM01FLD,1,1);
          tpwipe(templt,ABNM02FLD,1,1);
          tpwipe(templt,ABNM03FLD,1,1);
          tpwipe(templt,ABNM04FLD,1,1);
          tpwipe(templt,ABNM05FLD,1,1);
          tpwipe(templt,ABNM06FLD,1,1);
          tpwipe(templt,ABNM07FLD,1,1);
          tpwipe(templt,ABNM08FLD,1,1);
          tpwipe(templt,ABNM09FLD,1,1);
          tpwipe(templt,ABNM10FLD,1,1);
          tpwipe(templt,ABNM11FLD,1,1);
          tpwipe(templt,ABNM12FLD,1,1);
          tpwipe(templt,ABNM13FLD,1,1);
          tpwipe(templt,ABNM14FLD,1,1);
          tpwipe(templt,ABNM15FLD,1,1);
     }
     return(templt);
}

STATIC int
astgvfy(fldno,answer)                   /* answer FSD verify routine       */
int fldno;
char *answer;
{
     int i;

     switch (fldno) {
     case ABNM00FLD:
     case ABNM01FLD:
     case ABNM02FLD:
     case ABNM03FLD:
     case ABNM04FLD:
     case ABNM05FLD:
     case ABNM06FLD:
     case ABNM07FLD:
     case ABNM08FLD:
     case ABNM09FLD:
     case ABNM10FLD:
     case ABNM11FLD:
     case ABNM12FLD:
     case ABNM13FLD:
     case ABNM14FLD:
     case ABNM15FLD:
          if ((i=atoi(answer)) <= 0 || i > MAXQUES || i == tp->qdata.qnum+1
            || i == tp->qdata.prev-1) {
               strcpy(answer,spr("%d",tp->qdata.next+1));
          }
     }
     return(vfyadn(fldno,answer));
}

STATIC void
astgdun(save)                           /* answer FSD when done routine    */
int save;
{
     int i;

     setmbk(polmb);
     usrptr->state=polrmn;
     if (!save) {
          prfmsg(MEQUIT);
     }
     else {
          prfmsg(MESAVE);
          fsdfxt(ASTG00FLD,tp->qdata.ansstg[0],ANSSTGLEN);
          fsdfxt(ASTG01FLD,tp->qdata.ansstg[1],ANSSTGLEN);
          fsdfxt(ASTG02FLD,tp->qdata.ansstg[2],ANSSTGLEN);
          fsdfxt(ASTG03FLD,tp->qdata.ansstg[3],ANSSTGLEN);
          fsdfxt(ASTG04FLD,tp->qdata.ansstg[4],ANSSTGLEN);
          fsdfxt(ASTG05FLD,tp->qdata.ansstg[5],ANSSTGLEN);
          fsdfxt(ASTG06FLD,tp->qdata.ansstg[6],ANSSTGLEN);
          fsdfxt(ASTG07FLD,tp->qdata.ansstg[7],ANSSTGLEN);
          fsdfxt(ASTG08FLD,tp->qdata.ansstg[8],ANSSTGLEN);
          fsdfxt(ASTG09FLD,tp->qdata.ansstg[9],ANSSTGLEN);
          fsdfxt(ASTG10FLD,tp->qdata.ansstg[10],ANSSTGLEN);
          fsdfxt(ASTG11FLD,tp->qdata.ansstg[11],ANSSTGLEN);
          fsdfxt(ASTG12FLD,tp->qdata.ansstg[12],ANSSTGLEN);
          fsdfxt(ASTG13FLD,tp->qdata.ansstg[13],ANSSTGLEN);
          fsdfxt(ASTG14FLD,tp->qdata.ansstg[14],ANSSTGLEN);
          fsdfxt(ASTG15FLD,tp->qdata.ansstg[15],ANSSTGLEN);
          if (tp->qdata.flags&BRANCH) {
               tp->qdata.branch[0]=(i=atoi(fsdnan(ABNM00FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[1]=(i=atoi(fsdnan(ABNM01FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[2]=(i=atoi(fsdnan(ABNM02FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[3]=(i=atoi(fsdnan(ABNM03FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[4]=(i=atoi(fsdnan(ABNM04FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[5]=(i=atoi(fsdnan(ABNM05FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[6]=(i=atoi(fsdnan(ABNM06FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[7]=(i=atoi(fsdnan(ABNM07FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[8]=(i=atoi(fsdnan(ABNM08FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[9]=(i=atoi(fsdnan(ABNM09FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[10]=(i=atoi(fsdnan(ABNM10FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[11]=(i=atoi(fsdnan(ABNM11FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[12]=(i=atoi(fsdnan(ABNM12FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[13]=(i=atoi(fsdnan(ABNM13FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[14]=(i=atoi(fsdnan(ABNM14FLD))) == 0 ? 0 : i-1;
               tp->qdata.branch[15]=(i=atoi(fsdnan(ABNM15FLD))) == 0 ? 0 : i-1;
          }
          for (i=0 ; i < MAXASTGS ; i++) {
               if (strlen(tp->qdata.ansstg[i]) > 0) {
                    break;
               }
          }
          if (i == MAXASTGS) {
               polmsg(BADASTGS,0);
               polmsg(QUESOPTS,1);
               return;
          }
     }
     if ((tp->qdata.flags&EDITQ) || !save) {
          polmsg(QUESOPTS,1);
     }
     else {
          saveques(1);
          polmsg(AUTOINC,1);
     }
}

STATIC void
astgptc(void)                           /* answer FSD protect routine      */
{
     fsdscb->flddat[TSTR01FLD].flags|=FFFAVD;
     if (!(tp->qdata.flags&BRANCH)) {   /* disable branching               */
          fsdscb->flddat[ABNM00FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM01FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM02FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM03FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM04FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM05FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM06FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM07FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM08FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM09FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM10FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM11FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM12FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM13FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM14FLD].flags|=FFFAVD;
          fsdscb->flddat[ABNM15FLD].flags|=FFFAVD;
     }
}

STATIC int
checkscn(void)                          /* check user for ANSI             */
{
     if ((usaptr->ansifl&ANSON) && usaptr->scnfse >= 23
       && usaptr->scnwid >= 80) {
          return(1);
     }
     return(0);
}

STATIC void
setptrs(void)                           /* set miscellaneous pointers      */
{
     setmbk(polmb);
     sp=&pollsarr[usrnum];
}

STATIC void
initdata(void)                          /* initialize user data            */
{
     setmem(&tp->pdata,sizeof(struct polldata),0);
     tp->pdata.flags|=(DISBRANCH+CLRDFLT);
     tp->pdata.createdate=today();
     tp->pdata.closedate=datofc(cofdat(today())+90);
     stzcpy(tp->pdata.lookup_key,rawmsg(PLLOPKEY),KEYLEN);
     tp->pdata.priority=ANNOUNCE;
}

STATIC int
listquest(void)                         /* list questions routine          */
{
     int rv=0;

     setbtv(qbb);
     setmbk(polmb);
     qcomp.qnum=0;
     stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
     if (!(qeqbtv(&qcomp,0))) {
          polmsg(QUESNF,0);
     }
     else {
          prfmsg(LISTQHDR);
          btuinj(usrnum,CYCLE);
          tp->ques=qcomp.qnum;     /* set place holder for CYCLE           */
          tp->ans=0;               /* answers per page counter for CYCLE   */
          rv=1;
     }
     rstbtv();
     return(rv);
}

STATIC int
fndpoll(void)                           /* find poll via tp->tstr          */
{
     int rv=0,i;

     setbtv(pbb);
     if ((i=atoi(tp->tstr)) == 0) {     /* handle poll name entry          */
          strupr(tp->tstr);
          if (acqbtv(&tp->pdata,tp->tstr,0)) {
               rv=chkpoll();
          }
          else {
               polmsg(POLLNF,0);
          }
     }
     else {                             /* handle array cell entry         */
          i--;
          if (i < POLLSPERPG && i >= 0) {
               strcpy(tp->tstr,tp->select[i]);
               if (acqbtv(&tp->pdata,tp->tstr,0)) {
                    rv=chkpoll();
               }
               else {
                    strcpy(tp->tstr,spr("%d",i+1));
                    polmsg(POLLNF,0);
               }
          }
          else {
               polmsg(POLLNF,0);
          }
     }
     rstbtv();
     return(rv);
}

STATIC int
fndstat(void)                           /* find poll status                */
{
     int rv=0,i;

     setbtv(sbb);
     if ((i=atoi(tp->tstr)) == 0) {     /* handle poll name entry          */
          stzcpy(scomp.uid,tp->tmpid,UIDSIZ);
          stzcpy(scomp.pname,strupr(tp->tstr),PNAMELEN);
          if (acqbtv(sp,&scomp,0)) {
               rv=1;
          }
     }
     else {                             /* handle array cell entry         */
          i--;
          if (i < POLLSPERPG && tp->select[i][0] != '\0') {
               stzcpy(scomp.uid,tp->tmpid,UIDSIZ);
               stzcpy(scomp.pname,tp->select[i],PNAMELEN);
               if (acqbtv(sp,&scomp,0)) {
                    rv=1;
               }
          }
     }
     rstbtv();
     return(rv);
}

STATIC void
cyc_inc(void)                           /* auto-inc find next question #   */
{
     setbtv(qbb);
     qcomp.qnum=tp->cur++;
     stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
     if (!acqbtv(&tp->qdata,&qcomp,0)) {
          setmem(&tp->qdata,sizeof(struct quesdata),0);
          if (qcomp.qnum < MAXQUES) {
              tp->qdata.qnum=qcomp.qnum;
              stzcpy(tp->qdata.pollname,tp->pdata.pname,PNAMELEN);
              tp->qdata.next=tp->qdata.qnum+1;
              tp->qdata.prev=tp->qdata.qnum-1;
              if (tp->pdata.flags&CLRDFLT) {
                   tp->qdata.flags|=CLRSCN;
              }
              else {
                   tp->qdata.flags&=~CLRSCN;
              }
              tp->qdata.ansparam=1;
              prf(" \r");
              polmsg(ADDQUES,1);
          }
          else {
               prfmsg(CLRWHL);
               prfmsg(NOMOREQ);
               polmsg(GETQUES,1);
          }
          btulok(usrnum,0);
          outprf(usrnum);
          return;
     }
     cycwheel();
     btuinj(usrnum,CYCLE);
}

STATIC void
qtypevfy(void)                          /* question type verify routine    */
{
     switch (tp->qdata.qtype) {
     case 0:
     case 1:                            /* credit card question type       */
          tp->qdata.max=20L;            /* allow dashes or spaces          */
          tp->qdata.min=13L;            /* smallest valid credit card #    */
          break;
     case 2:                            /* date question type */
          tp->qdata.max=8L;             /* allow for date mm/dd/yy format  */
          tp->qdata.min=8L;             /* must be exactly 8 char's in len.*/
          break;
     case 3:                            /* display only question type      */
          tp->qdata.max=tp->qdata.min=0L;    /* no input expected          */
          break;
     case 4:                            /* multiple choice */
          tp->qdata.max=1L;             /* Alpha letter only               */
          tp->qdata.min=1L;             /* Must be minimum of 1 letter     */
          break;
     case 5:                            /* numeric question type           */
          tp->qdata.max=99999L;
          tp->qdata.min=0L;
          break;
     case 6:                            /* open ended response question type*/
          tp->qdata.max=1999L;
          tp->qdata.min=0L;
          break;
     case 7:                            /* true / false                    */
          tp->qdata.min=4L;
          tp->qdata.max=5L;
          setmem(tp->qdata.ansstg,ANSSTGLEN*MAXASTGS,0);
          setmem(tp->qdata.branch,2*MAXASTGS,0);
          stzcpy(tp->qdata.ansstg[0],truefalse[1],ANSSTGLEN);
          stzcpy(tp->qdata.ansstg[1],truefalse[2],ANSSTGLEN);
          break;
     case 8:                            /* yes / no                        */
          tp->qdata.min=2L;
          tp->qdata.max=3L;
          setmem(tp->qdata.ansstg[0],ANSSTGLEN*MAXASTGS,0);
          setmem(tp->qdata.branch,2*MAXASTGS,0);
          stzcpy(tp->qdata.ansstg[0],yesno[1],ANSSTGLEN);
          stzcpy(tp->qdata.ansstg[1],yesno[2],ANSSTGLEN);
          break;
     case 9:                            /* user account question type      */
          tp->qdata.max=60L;
          tp->qdata.min=0L;
     }
}

STATIC void
saveques(mode)                          /* question update/insert routine  */
int mode;
{
     setbtv(qbb);
     stzcpy(tp->qdata.pollname,tp->pdata.pname,PNAMELEN);
     if (tp->qdata.flags&EDITQ) {
          qcomp.qnum=tp->qdata.qnum;
          stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
          if (acqbtv(NULL,&qcomp,0)) {
               if (mode) {
                    tp->qdata.flags&=~EDITQ;
               }
               upvbtv(&tp->qdata,sizeof(struct quesdata)-TXTSIZ
                    +strlen(tp->qdata.txtmsg)+1);
          }
          else {
               polmsg(QERRUPD,0);
          }
     }
     else {
          invbtv(&tp->qdata,sizeof(struct quesdata)-TXTSIZ
               +strlen(tp->qdata.txtmsg)+1);
     }
     rstbtv();
}

STATIC void
gettake(void)                           /* get poll name/number from user  */
{
     int chr;

     if (!morcnc()) {
          if (tp->flags&MORELIST) {
               tp->pos=tp->oldpos;
          }
          polmsg(GETTAKE,1);
     }
     else if ((chr=morcnc()) == '?') {
          cncall();
          tp->flags&=~MORELIST;
          polmsg(GETTAKE,1);
     }
     else if (margc == 1 && chr == 'X' && sameas(margv[0],"x")) {
          cncall();
          condex();
          polmsg(MAIN,1);
     }
     else if (chr == '.') {
          cncall();
          polmsg(GETTAKE,1);
     }
     else {
          tp->flags&=~MORELIST;
          strcpy(tp->tstr,cncall());
          if (fndpoll()) {
               stzcpy(scomp.uid,usaptr->userid,UIDSIZ);
               stzcpy(scomp.pname,tp->pdata.pname,PNAMELEN);
               setbtv(sbb);
               if (qeqbtv(&scomp,0)) {
                    if (tp->pdata.answer <= ONCE) {
                         polmsg(ANSONCE,0);
                         polmsg(GETTAKE,1);
                         return;
                    }
               }
               rstbtv();
               qcomp.qnum=0;
               stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
               setbtv(qbb);
               if (!acqbtv(&tp->qdata,&qcomp,0)) {
                    polmsg(NOQUES,0);
                    polmsg(GETTAKE,1);
               }
               else {
                    if (!haskey(tp->pdata.acc_key)) {
                         if (tp->pdata.acc_attr == HIDE
                           && !haskey(tp->pdata.res_key)
                           && !haskey(tp->pdata.lookup_key)) {
                              polmsg(POLLNF,0);
                         }
                         else {
                              prfmsg(NOACCKEY,type[tp->pdata.polltype],
                                   tp->pdata.pname);
                         }
                         condex();
                         polmsg(GETTAKE,1);
                    }
                    else {
                         prfmsg(TPHDR);
                         polmsg(TAKEPOLL,1);
                    }
               }
          }
          else {
               polmsg(GETTAKE,1);
          }
     }
}

STATIC void
getres(void)                            /* get results for a poll routine  */
{
     int chr;

     if (!morcnc()) {
          tp->flags&=~MORELIST;
          polmsg((isripu() ? GETRES : GRSHRT),0);
     }
     else if ((chr=morcnc()) == '?') {
          cncall();
          tp->flags&=~MORELIST;
          polmsg(GETRES,1);
     }
     else if (chr == '.') {
          cncall();
          if (tp->flags&MORELIST) {
               polmsg(GETRES,1);
          }
          else {
               polmsg((isripu() ? GETRES : GRSHRT),0);
          }
     }
     else if (margc == 1 && chr == 'X' && sameas(margv[0],"x")) {
          cncall();
          condex();
          polmsg(MAIN,1);
     }
     else {
          tp->flags&=~MORELIST;
          strcpy(tp->tstr,cncall());
          if (fndpoll()) {
               if (tp->pdata.polltype == QUEST || tp->pdata.data == ASCII
                || tp->pdata.data == DISCARD) {
                    polmsg(POLLNF,0);
                    polmsg(GETRES,1);
               }
               else {
                    if (!haskey(tp->pdata.res_key)) {
                         if (tp->pdata.acc_attr == HIDE
                           && !haskey(tp->pdata.acc_key)
                           && !haskey(tp->pdata.lookup_key)) {
                              polmsg(POLLNF,0);
                         }
                         else {
                              prfmsg(NORESKEY,type[tp->pdata.polltype],
                                   tp->pdata.pname);
                         }
                         condex();
                         polmsg(GETRES,1);
                    }
                    else {
                         polmsg(SHWRSLT,1);
                    }
               }
          }
          else {
               polmsg(GETRES,1);
          }
     }
}

STATIC void
loadnext(void)                          /* load next poll in sequence      */
{
     if ((tp->qdata.flags&BRANCH) && isalpha(tp->adata.answer[0])) {
          qcomp.qnum=tp->qdata.branch[(int)(tp->adata.answer[0])-65];
     }
     else {
          qcomp.qnum=tp->qdata.next;
     }
     stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
     setbtv(qbb);
     geqbtv(&tp->qdata,&qcomp,0);
     rstbtv();
     polmsg(TAKEPOLL,1);
}

STATIC void
loadprev(void)                          /* load previous poll in sequence  */
{
     qcomp.qnum=tp->qdata.prev;
     stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
     setbtv(qbb);
     geqbtv(&tp->qdata,&qcomp,0);
     rstbtv();
     polmsg(TAKEPOLL,1);
}

STATIC int
chknext(void)                           /* check if next question is valid */
{
     if (tp->qdata.next == 0) {
          return(0);
     }
     if ((tp->qdata.flags&BRANCH) && isalpha(tp->adata.answer[0])) {
          qcomp.qnum=tp->qdata.branch[(int)(tp->adata.answer[0])-65];
     }
     else {
          qcomp.qnum=tp->qdata.next;
     }
     stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
     setbtv(qbb);
     if (qeqbtv(&qcomp,0)) {
          rstbtv();
          return(1);
     }
     rstbtv();
     return(0);
}

STATIC int
chkprev(void)                           /* check if prev question is valid */
{
     if (tp->qdata.qnum == 0) {    /* at beginning of poll                 */
          return(0);
     }
     qcomp.qnum=tp->qdata.prev;
     stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
     setbtv(qbb);
     if (qeqbtv(&qcomp,0)) {
          rstbtv();
          return(1);
     }
     rstbtv();
     return(0);
}

STATIC void
setinplen(void)                         /* set input length for user       */
{
     int len;

     switch (tp->qdata.qtype) {
     case 3:                            /* display only                    */
     case 6:                            /* open ended response             */
          len=1;
          break;
     case 5:                            /* numeric value                   */
          len=10;
          break;
     case 4:                            /* multiple choice                 */
          len=tp->qdata.ansparam == 1 ? 1 : tp->qdata.ansparam*2;
          break;
     case 0:                            /* credit card                     */
     case 1:                            /* ditto                           */
     case 2:                            /* date                            */
     case 7:                            /* true/false                      */
     case 8:                            /* yes/no                          */
     case 9:                            /* user account                    */
          len=(int)tp->qdata.max;
     }
     btumil(usrnum,len);
}

STATIC char *
questxt(void)                           /* return question text area       */
{
     int i,j;

     setmem(tp->tstr,STRSIZ,0);
     j=i=0;
     do {
          if (i == 0) {
               if (tp->qdata.txtmsg[j] == 32 || tp->qdata.txtmsg[j] == 13) {
                    j++;
                    continue;
               }
          }
          else if (tp->qdata.txtmsg[j] == 13) {
               j++;
               continue;
          }
          tp->tstr[i++]=tp->qdata.txtmsg[j++];
     } while (i < 30);
     tp->tstr[i]='\0';
     return(tp->tstr);
}

STATIC void
editqtype(mode)                         /* begin editing question type FSD */
int mode;
{
     if (checkscn()) {
          quesprp(QUESATPL,1);
          fsdrhd("Question Display/Edit");
          fsdbkg(quesrft());
          quesptc();
          fsdego(quesvfy,quesdun);
     }
     else {
          if (mode == 0) {
               quesprp(QUESNTPD,-1);
               fsddsp(quesrft());
               polmsg(QNACHNG,1);
          }
          else {
               quesprp(QUESNTPQ,0);
               quesptc();
               fsdego(quesvfy,quesdun);
          }
     }
}

STATIC void
editmult(mode)                          /* begin answer string FSD         */
int mode;
{
     if (checkscn()) {
          astgprp(ASTGATPL,1);
          fsdrhd("Multichoice Answer String Display/Edit");
          fsdbkg(astgrft());
          astgptc();
          fsdego(astgvfy,astgdun);
     }
     else {
          if (mode == 0) {
               astgprp(ASTGATPL,-1);
               fsddsp(astgrft());
               polmsg(ANACHNG,1);
          }
          else {
               astgprp(ASTGNTPQ,0);
               astgptc();
               fsdego(astgvfy,astgdun);
          }
     }
}

STATIC void
loadquestxt(void)                       /* begin editing question with FSE */
{
     if (!morcnc()) {
          polmsg(QUESTXT,1);
     }
     else if (morcnc() == '.') {
          cncall();
          sprintf(tp->tstr,"%s: Question %d",tp->pdata.pname,tp->qdata.qnum+1);
          bgnedt(TXTSIZ,tp->qdata.txtmsg,51,tp->tstr,dunques,
               (tp->qdata.flags&EDITQ) ? ED_FIXTOP : (ED_FIXTOP|ED_CLRTXT));
     }
     else if (morcnc() == 'X') {
          cncall();
          prfmsg(QUESABRT);
          polmsg((tp->qdata.flags&EDITQ) ? QUESOPTS : AUTOINC,1);
     }
     else {
          cncall();
          polmsg(OUTOFRNG,0);
          polmsg(QUESTXT,1);
     }
}

STATIC void
showmult(mode)                          /* show multichoice answer strings */
int mode;
{
     int i;

     setmbk(polmb);
     if (mode != 0) {
          if (isripu()) {
               for (i=0 ; i < MAXASTGS ; i++) {
                    if (strlen(tp->qdata.ansstg[i]) > 0) {
                         prf("\r!%s%s",quesbuts[i],tp->qdata.ansparam == 1 ? "`M" : "");
                    }
               }
          }
     }
     if (mode != 2) {
          prf("\r");
          for (i=0 ; i < MAXASTGS ; i++) {
               if (strlen(tp->qdata.ansstg[i]) > 0) {
                    prfmsg(ANSSTG,spr("%c",65+i),tp->qdata.ansstg[i]);
               }
          }
     }
}

STATIC int
ismult(void)                            /* check for multichoice type      */
{
     if (tp->qdata.qtype == MULTICHC || tp->qdata.qtype == TRUEFALSE
      || tp->qdata.qtype == YESNO) {
          return(1);
     }
     return(0);
}

STATIC void
cyc_tally(void)                         /* tally user responses            */
{
     int i=0, done=0;

     setmbk(polmb);
     if ((tp->qdata.flags&BRANCH) && isalpha(tp->adata.answer[0])) {
          qcomp.qnum=tp->qdata.branch[(int)(tp->adata.answer[0])-65];
     }
     else {
          qcomp.qnum=tp->qdata.next;
     }
     stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
     setbtv(qbb);
     if (acqbtv(&tp->qdata,&qcomp,0)) {
          acomp.qnum=tp->qdata.qnum;
          stzcpy(acomp.pollname,tp->pdata.pname,PNAMELEN);
          stzcpy(acomp.uid,usaptr->userid,UIDSIZ);
          setbtv(abb);
          if (acqbtv(&tp->adata,&acomp,0)) {
               delbtv();
               setbtv(tbb);
               geqbtv(&tally,tp->pdata.pname,0);
               do {
                    if (isalpha(tp->adata.answer[i])) {
                         tally.answer[tp->qdata.qnum][tp->adata.answer[i]-65]--;
                    }
               } while (tp->adata.answer[i++] != '\0');
               upvbtv(&tally,sizeof(struct polltally));
               rstbtv();
          }
          else {
               done=1;
          }
          rstbtv();
     }
     else {
          done=1;
     }
     rstbtv();
     if (done) {
          qcomp.qnum=tp->ques;
          stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
          setbtv(qbb);
          geqbtv(&tp->qdata,&qcomp,0);
          if (tp->pdata.data != DISCARD && tp->pdata.data != ASCII
             && !(tp->qdata.flags&EXMPT)) {
               acomp.qnum=tp->qdata.qnum;
               stzcpy(acomp.pollname,tp->pdata.pname,PNAMELEN);
               stzcpy(acomp.uid,usaptr->userid,UIDSIZ);
               setbtv(abb);
               if (acqbtv(&tp->adata,&acomp,0)) {
                    stzcpy(tp->adata.answer,tp->tstr,ANSSIZ);
                    upvbtv(&tp->adata,sizeof(struct ansrdata)
                         -ANSSIZ+strlen(tp->adata.answer)+1);
               }
               rstbtv();
          }
          else {
               stzcpy(tp->adata.answer,tp->tstr,ANSSIZ);
          }
          rstbtv();
          if (tp->qdata.qtype == USERACCT) {      /* user account field    */
               upaccfld();
          }
          if (tp->pdata.data == ASCII || tp->pdata.data == BOTH) {
               apendasc();
          }
          if (tp->pdata.polltype != QUEST) {
               add_tally();
          }
          prfmsg(CLRWHL);
          btulok(usrnum,0);
          if (chknext()) {
               loadnext();
          }
          else {
               polmsg(COMPPOLL,0);
               condex();
               polmsg(GETTAKE,1);
          }
          outprf(usrnum);
     }
     else {
          btuinj(usrnum,CYCLE);
          cycwheel();
     }
     rstbtv();
}

STATIC int
remove_tally(void)                      /* remove tallied stats for ques # */
{
     int i=0;

     setbtv(tbb);
     if (!acqbtv(&tally,tp->pdata.pname,0)) {
          setmem(&tally,sizeof(struct polltally),0);
          stzcpy(tally.pollname,tp->pdata.pname,PNAMELEN);
          invbtv(&tally,sizeof(struct polltally));
          return(1);
     }
     do {
          if (isalpha(tp->adata.answer[i])) {
               tally.answer[tp->qdata.qnum][tp->adata.answer[i]-65]--;
          }
     } while (tp->adata.answer[i++] != '\0');
     gcrbtv(NULL,0);
     upvbtv(&tally,sizeof(struct polltally));
     rstbtv();
     if ((tp->qdata.flags&BRANCH) && !sameas(tp->adata.answer,tp->tstr)) {
          tp->wheel=0;
          btulok(usrnum,1);
          btuinj(usrnum,CYCLE);
          prfmsg(CLRBRNCH);
          return(0);
     }
     return(1);
}

STATIC void
add_tally(void)                         /* add tallied stat for ques #     */
{
     int i=0;

     setbtv(tbb);
     if (!acqbtv(&tally,tp->pdata.pname,0)) {
          setmem(&tally,sizeof(struct polltally),0);
          stzcpy(tally.pollname,tp->pdata.pname,PNAMELEN);
          invbtv(&tally,sizeof(struct polltally));
          gcrbtv(NULL,0);
     }
     do {
          if (isalpha(tp->adata.answer[i])) {
               tally.answer[tp->qdata.qnum][tp->adata.answer[i]-65]++;
          }
     } while (tp->adata.answer[i++] != '\0');
     upvbtv(&tally,sizeof(struct polltally));
     rstbtv();
}

STATIC int
chk_answer(stg)                         /* check answer string validity    */
char *stg;
{
     int max,i,param;
     char *tptr,*cp;
     static char temp[STRSIZ];

     if (atoi(stg) > 0 || sameas(stg,"0")) {
          polmsg(OUTOFRNG,0);
          return(0);
     }
     for (i=0,max=0 ; i < MAXASTGS ; i++) {
          if (strlen(tp->qdata.ansstg[i]) > 0) {
               max++;
          }
          else {
               break;
          }
     }
     max+=65;                           /* adjust to 'A' base              */
     i=0;
     setmem(temp,STRSIZ,0);
     for (cp=stg,tptr=temp,param=0
          ; *cp != '\0' && param < MAXASTGS ; cp++) {
          if (isalpha(*cp) && !samein(spr("%c",*cp),temp)) {
               if ((*tptr++=toupper(*cp)) >= max) {
                    polmsg(OUTOFRNG,0);
                    return(0);
               }
               *tptr++=',';
               param++;
          }
     }
     if (param > 0 && param <= tp->qdata.ansparam) {
          *(tptr-1)='\0';
          stzcpy(tp->tstr,temp,STRSIZ);
          return(1);
     }
     polmsg(BADANSR,0);
     return(0);
}

STATIC void
results(void)                           /* display results routine         */
{
     int i,tot;

     setmbk(polmb);
     if (tp->flags&REVERSE) {
          tp->flags&=~REVERSE;
     }
     prfmsg(SHWRSLT,tp->pdata.pname,tp->qdata.txtmsg);
     setbtv(tbb);
     if (acqbtv(&tally,tp->pdata.pname,0)) {
          for (i=0,tot=0 ; i < MAXASTGS ; i++) {
               if (strlen(tp->qdata.ansstg[i]) == 0) {
                    break;
               }
               tot+=tally.answer[tp->qdata.qnum][i];
          }
          for (i=0 ; i < MAXASTGS ; i++) {
               if (strlen(tp->qdata.ansstg[i]) == 0) {
                    break;
               }
               prfmsg(RSLTAS,spr("%c",i+65),tp->qdata.ansstg[i],
                    tally.answer[tp->qdata.qnum][i],
                    rsltper(tally.answer[tp->qdata.qnum][i],tot));
          }
          prfmsg(RSLTTOT,tot);
     }
     else {
          for (i=0 ; i < MAXASTGS ; i++) {
               if (strlen(tp->qdata.ansstg[i]) == 0) {
                    break;
               }
               prfmsg(RSLTAS,spr("%c",i+65),tp->qdata.ansstg[i],0,0);
          }
          prfmsg(RSLTTOT,0);
     }
     polmsg(RSLTPMT,0);
}

STATIC void
getlook(void)                           /* lookup get userid routine       */
{
     char *user;

     if (!morcnc()) {
          polmsg(GETLOOK,1);
     }
     else if (morcnc() == 'X' && sameas(margv[0],"x") && margc == 1) {
          cncall();
          clrxrf();
          condex();
          polmsg(MAIN,1);
     }
     else {
          switch (hdluid(cncall())) {
          case UIDFND:
               user=uidxrf.userid;
               break;
          case UIDPMT:
               polmsg(usrptr->substt,1);
               return;
          case UIDCAL:
               return;
          }
          strcpy(tp->tmpid,user);
          polmsg(GETLUP,1);
     }
}

STATIC void
shwrslt(void)                           /* show results input handler      */
{
     if (!morcnc()) {
          polmsg(RSLTPMT,0);
     }
     else if (morcnc() == '?') {
          cncall();
          if (tp->ques > 0) {
               tp->ques--;
          }
          btuinj(usrnum,CYCLE);
     }
     else if (morcnc() == 'X') {
          cncall();
          condex();
          polmsg(GETRES,1);
     }
     else if (morcnc() == '-' && margc == 1 && sameas(margv[0],"-")) {
          if (tp->ques-1 > tp->fques) {
               cncall();
               tp->flags|=REVERSE;
               btuinj(usrnum,CYCLE);
          }
          else {
               prfmsg(CMDNOTU,cncall());
               polmsg(RSLTPMT,0);
          }
     }
     else if (morcnc() == '.') {
          cncall();
          btuinj(usrnum,CYCLE);
     }
     else {
          prfmsg(CMDNOTU,cncall());
          polmsg(RSLTPMT,0);
     }
}

STATIC void
duppoll(void)                           /* get non-duplicate poll name rou */
{
     if (!morcnc()) {
          polmsg(DUPPOLL,1);
     }
     else if (morcnc() == 'X' && sameas(margv[0],"x") && margc == 1) {
          cncall();
          setmem(&tp->pdata,sizeof(struct polldata),0);
          polmsg(GETPOLL,1);
     }
     else {
          stzcpy(tp->pdata.pname,strupr(cncall()),PNAMELEN);
          setbtv(pbb);
          if (dinsbtv(&tp->pdata)) {
               shocst("P&Q NEW POLL ADDED","Poll %s has been added by %s",
                    tp->pdata.pname,usaptr->userid);
               polmsg(SAVEPOLL,0);
               polmsg(AUTOINC,1);
          }
          else {
               polmsg(DUPPOLL,1);
          }
          rstbtv();
     }
}

STATIC void
nonpoll(void)                           /* get valid poll name routine     */
{
     if (!morcnc()) {
          polmsg(NONPOLL,1);
     }
     else if (morcnc() == 'X' && sameas(margv[0],"x") && margc == 1) {
          cncall();
          setmem(&tp->pdata,sizeof(struct polldata),0);
          polmsg(GETPOLL,1);
     }
     else {
          stzcpy(tp->pdata.pname,strupr(cncall()),PNAMELEN);
          setbtv(pbb);
          if (strlen(tp->pdata.pname) < 3) {
               polmsg(NONPOLL,1);
          }
          else if (dinsbtv(&tp->pdata)) {
               shocst("P&Q NEW POLL ADDED","Poll %s has been added by %s",
                    tp->pdata.pname,usaptr->userid);
               polmsg(SAVEPOLL,0);
               polmsg(AUTOINC,1);
          }
          else {
               polmsg(DUPPOLL,1);
          }
          rstbtv();
     }
}

STATIC void
takepoll(void)                          /* take poll input handler routine */
{
     if (!morcnc()) {
          polmsg(TAKEPOLL,1);
     }
     else if (morcnc() == '?') {
          cncall();
          tp->flags&=~MORELIST;
          polmsg(TAKEPOLL,1);
     }
     else if (tp->qdata.qtype == OPEN_ENDED && margc == 1
           && sameas(margv[0],"e")) {
          cncall();
          if (strlen(tp->adata.answer) != 0) {
               sprintf(tp->tstr,"%s: Question %d",tp->pdata.pname,
                       tp->qdata.qnum+1);
               bgnedt(TXTSIZ,tp->adata.answer,51,tp->tstr,duntake,ED_FIXTOP);
          }
          else {
               polmsg(OUTOFRNG,0);
               polmsg(TAKEPOLL,1);
          }
     }
     else if (margc == 1 && sameas(margv[0],".")) {
          cncall();
          if (tp->qdata.qtype != DISONLY
           && strlen(tp->adata.answer) == 0) {
               if (tp->qdata.qtype == OPEN_ENDED) {
                    tp->flags|=ADDRESP;
                    sprintf(tp->tstr,"%s: Question %d",tp->pdata.pname,
                            tp->qdata.qnum+1);
                    bgnedt(TXTSIZ,tp->adata.answer,51,tp->tstr,duntake,
                         ED_FIXTOP+ED_CLRTXT);
               }
               else {
                    polmsg(MUSTANSR,0);
                    polmsg(TAKEPOLL,1);
               }
               return;
          }
          if (chknext()) {
               loadnext();
          }
          else {
               polmsg(COMPPOLL,0);
               condex();
               polmsg(GETTAKE,1);
          }
     }
     else if (margc == 1 && sameas(margv[0],"-")) {
          cncall();
          if (tp->qdata.qnum == 0) {
               polmsg(OUTOFRNG,0);
               polmsg(TAKEPOLL,1);
          }
          else {
               if (chkprev()) {
                    loadprev();
               }
               else {
                    polmsg(NOPREV,0);
                    if (isripu()) {
                         polmsg(TAKEPOLL,1);
                    }
                    else {
                         if (tp->qdata.ansparam == 1) {
                              prfmsg(tp->qdata.qnum == 0 ? SHRTPOLF : SHRTPOLL);
                         }
                         else {
                              prfmsg(tp->qdata.qnum == 0 ? SHRTPLFM : SHRTPOLM,
                                   tp->qdata.ansparam);
                         }
                         tp->dftinp=getdft();
                    }
               }
          }
     }
     else if (margc == 1 && sameas(margv[0],"x")) {
          cncall();
          if ((tp->flags&LONMODE) && tp->pdata.priority == INSIST) {
               polmsg(POLLINS,1);
          }
          else {
               condex();
               tp->flags&=~MORELIST;
               polmsg(GETTAKE,1);
          }
     }
     else {              /* if answer is valid: store data, get next ques. */
          if (tp->qdata.qtype != DISONLY) {
               saveresp(strupr(cncall()));
          }
          else {
               cncall();
               if (chknext()) {
                    loadnext();
               }
               else {
                    polmsg(COMPPOLL,0);
                    condex();
                    polmsg(GETTAKE,1);
               }
          }
     }
}

STATIC void
getpoll(void)                           /* get poll to edit routine        */
{
     int chr,i;

     setmbk(polmb);
     if (!morcnc()) {
          if (tp->flags&MORELIST) {
               tp->pos=tp->oldpos;
          }
          polmsg(GETPOLL,1);
     }
     else if ((chr=morcnc()) == '?') {
          cncall();
          tp->flags&=~MORELIST;
          polmsg(GETPOLL,1);
          return;
     }
     else if (margc == 1 && chr == 'X' && sameas(margv[0],"x")) {
          cncall();
          condex();
          polmsg(MAIN,1);
          return;
     }
     else if (chr == '.') {
          cncall();
          polmsg(GETPOLL,1);
     }
     else if (chr == 'A' && sameas(margv[0],"a")) {
          cncall();
          tp->flags&=~MORELIST;
          initdata();
          if (checkscn()) {
               addprp(POLLATPL,1);
               fsdrhd("General Poll Information");
               fsdbkg(polrft());
          }
          else {
               addprp(POLLNTPQ,0);
          }
          polptc();
          fsdego(polvfy,poldun);
          return;
     }
     else {
          strcpy(tp->tstr,cncall());
          if (fndpoll()) {
               for (i=0 ; i < nterms ; i++) {
                    if ((user[i].state == polrmn && user[i].substt == TAKEPOLL)
                      || inedit(i,duntake)) {
                         if (sameas(otp(i)->pdata.pname,tp->pdata.pname)) {
                              polmsg(USRTKGP,0);
                              setmem(&tp->pdata,sizeof(struct polldata),0);
                              polmsg(GETPOLL,1);
                              return;
                         }
                    }
               }
               setbtv(pbb);
               if (acqbtv(NULL,tp->pdata.pname,0)) {
                    tp->pdata.flags|=EDITP;
                    poledit[usrnum]=1;
                    updbtv(&tp->pdata);
                    polmsg(EDITPOLL,1);
               }
               else {
                    tp->flags&=~MORELIST;
                    polmsg(GETPOLL,1);
               }
               rstbtv();
          }
          else {
               tp->flags&=~MORELIST;
               polmsg(GETPOLL,1);
          }
     }
}

STATIC void
editpoll(void)                          /* edit poll input handler         */
{
     int chr;

     if (!morcnc()) {
          polmsg(EDITPOLL,1);
     }
     else if ((chr=morcnc()) == '?') {
          cncall();
          polmsg(EDITHELP,0);
          polmsg(EDITPOLL,1);
     }
     else if (margc == 1 && chr == 'X' && sameas(margv[0],"x")) {
          cncall();
          tp->flags&=~MORELIST;
          polmsg(GETPOLL,1);
     }
     else if (chr == 'G') {
          cncall();
          if (checkscn()) {
               addprp(POLLATPL,1);
               fsdrhd("General Poll Information Display/Edit");
               fsdbkg(polrft());
               polptc();
               fsdego(polvfy,poldun);
          }
          else {
               addprp(POLLNTPD,-1);
               fsddsp(polrft());
               polmsg(PNACHNG,1);
          }
     }
     else if (chr == 'Q') {
          cncall();
          usrptr->substt=GETQUES;
          if (listquest() == 0) {
               clrprf();
               polmsg(NOQEDIT,0);
               polmsg(GETQUES,1);
          }
     }
     else if (chr == 'D') {
          cncchr();
          polmsg(DELCONF,1);
     }
     else if (chr == 'R') {
          cncchr();
          polmsg(RESCONF,1);
     }
     else {
          prfmsg(CMDNOTU,cncall());
          polmsg(EDITPOLL,1);
     }
}

STATIC void
addques(void)                           /* add question routine            */
{
     int chr;

     if (!morcnc()) {
          prfmsg(tp->qdata.qnum == 0 ? ADDFQUES : ADDQUES,tp->qdata.qnum+1);
          poldft(usrptr->substt);
     }
     else if ((chr=morcnc()) == '?') {
          cncall();
          if (tp->qdata.qnum == 0) {
               polmsg(ADDHELP,0);
               polmsg(ADDQUES,1);
          }
          else {
               listquest();
          }
     }
     else if (chr == '.') {
          cncall();
          editqtype(1);
     }
     else if (chr == 'X') {
          cncall();
          if (tp->qdata.qnum == 0) {
               setbtv(pbb);
               geqbtv(NULL,tp->pdata.pname,0);
               delbtv();
               rstbtv();
               polmsg(GETPOLL,1);
          }
          else {
               tp->qdata.qnum=0;
               usrptr->substt=GETQUES;
               listquest();
          }
     }
     else {
          strcpy(tp->tstr,cncall());
          if ((qcomp.qnum=atoi(tp->tstr)-1) >= 0 && qcomp.qnum < MAXQUES) {
               stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
               setbtv(qbb);
               if (!(acqbtv(&tp->qdata,&qcomp,0))) {
                    tp->qdata.qnum=qcomp.qnum;
                    tp->qdata.next=qcomp.qnum+1;
                    tp->qdata.prev=qcomp.qnum-1;
                    editqtype(1);
               }
               else {
                    tp->qdata.flags|=EDITQ;
                    polmsg(QUESOPTS,1);
               }
          }
          else {
               prfmsg(AQWRNG,MAXQUES);
               prfmsg(tp->qdata.qnum == 0 ? ADDFQUES
                                          : ADDQUES,tp->qdata.qnum+1);
               poldft(usrptr->substt);
          }
     }
}

STATIC void
getques(void)                           /* get question for edit routine   */
{
     int chr;

     if (!morcnc()) {
          if (tp->flags&MORELIST) {
               polmsg(MORQUES,0);
          }
          else {
               polmsg(GETQUES,1);
          }
     }
     else if ((chr=morcnc()) == '?') {
          cncall();
          listquest();
          return;
     }
     else if (chr == '.') {
          cncall();
          if (tp->flags&MORELIST) {
               prfmsg(LISTQHDR);
               btuinj(usrnum,CYCLE);
               tp->ques=tp->qdata.qnum;
               tp->ans=0;
          }
          else {
               polmsg(GETQUES,1);
          }
     }
     else if (margc == 1 && chr == 'X' && sameas(margv[0],"x")) {
          cncall();
          polmsg(EDITPOLL,1);
          return;
     }
     else if (chr == 'A') {
          cncall();
          polmsg(AUTOINC,1);
     }
     else {
          strcpy(tp->tstr,cncall());
          if ((qcomp.qnum=atoi(tp->tstr)-1) >= 0) {
               stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
               setbtv(qbb);
               if (!(acqbtv(&tp->qdata,&qcomp,0))) {
                    polmsg(QUESNF,0);
                    polmsg(GETQUES,1);
               }
               else {
                    tp->qdata.flags|=EDITQ;
                    polmsg(QUESOPTS,1);
               }
          }
          else {
               prfmsg(CMDNOTU,tp->tstr);
               polmsg(GETQUES,1);
          }
     }
}

STATIC void
quesopts(void)                          /* question editor input handler   */
{
     int chr,i;

     if (!morcnc()) {
          polmsg((isripu() ? QUESOPTS : QOSHRT),1);
     }
     else if ((chr=morcnc()) == '?') {
          cncall();
          polmsg(QUESOPTS,1);
     }
     else if (chr == 'G') {
          cncall();
          editqtype(0);
     }
     else if (chr == 'T') {
          cncall();
          loadquestxt();
     }
     else if (chr == 'X') {
          cncall();
          if (tp->qdata.qtype == MULTICHC) {
               for (i=0 ; i < MAXASTGS ; i++) {
                    if (strlen(tp->qdata.ansstg[i]) > 0) {
                         break;
                    }
               }
               if (i == MAXASTGS) {
                    usrptr->substt=GETQUES;
                    if (listquest() == 0) {
                         polmsg(NOQEDIT,0);
                         polmsg(GETQUES,1);
                    }
                    return;
               }
          }
          saveques(1);
          usrptr->substt=GETQUES;
          if (listquest() == 0) {
               polmsg(NOQEDIT,0);
               polmsg(GETQUES,1);
          }
     }
     else if (chr == 'D') {
          cncall();
          if (tp->qdata.qnum == 0) {
               polmsg(CNTDLQ1,0);
               polmsg((isripu() ? QUESOPTS : QOSHRT),1);
          }
          else {
               polmsg(DELQUES,1);
          }
     }
     else if (chr == 'M' && tp->qdata.qtype == MULTICHC) {
          cncall();
          editmult(0);
          return;
     }
     else if (chr == 'C' && tp->qdata.qtype == MULTICHC) {
          cncall();
          setmem(tp->qdata.ansstg[0],ANSSTGLEN*MAXASTGS,0);
          setmem(tp->qdata.branch,sizeof(int)*MAXASTGS,0);
          polmsg(MULTCLR,0);
          polmsg(BADASTGS,0);
          polmsg((isripu() ? QUESOPTS : QOSHRT),1);
     }
     else {
          prfmsg(CMDNOTU,cncall());
          polmsg((isripu() ? QUESOPTS : QOSHRT),1);
     }
}

STATIC void
getlup(void)                            /* get poll to lookup input handler*/
{
     if (!morcnc()) {
          if (usrptr->substt == MORLUP) {
               tp->pos=tp->oldpos;
               polmsg(MORLUP,1);
          }
          else {
               polmsg(GETLUP,1);
          }
     }
     else if (morcnc() == 'X' && margc == 1 && sameas(margv[0],"x")) {
          cncall();
          condex();
          polmsg(GETLOOK,1);
     }
     else if (morcnc() == '.') {
          cncall();
          polmsg(MORLUP,1);
     }
     else if (morcnc() == '?') {
          cncall();
          polmsg(GETLUP,1);
     }
     else {
          strcpy(tp->tstr,cncall());
          if (fndstat()) {
               if (tp->pdata.acc_attr == HIDE
                 && !haskey(tp->pdata.res_key)
                 && !haskey(tp->pdata.acc_key)
                 && !haskey(tp->pdata.lookup_key)) {
                    polmsg(POLLNF,0);
                    polmsg(GETLUP,1);
               }
               else {
                    tp->ques=0;
                    polmsg(DISSTATS,1);
               }
          }
          else {
               if (fndpoll()) {
                    if (tp->pdata.acc_attr == HIDE
                      && !haskey(tp->pdata.res_key)
                      && !haskey(tp->pdata.acc_key)
                      && !haskey(tp->pdata.lookup_key)) {
                         polmsg(POLLNF,0);
                    }
                    else {
                         prfmsg(NOLOOKEY,tp->tmpid,type[tp->pdata.polltype],
                              tp->pdata.pname);
                    }
               }
               polmsg(GETLUP,1);
          }
     }
}

STATIC void
disstats(void)                          /* display user answer stats       */
{
     if (!morcnc()) {
          if (tp->ques > 0) {
               tp->ques--;
          }
          btuinj(usrnum,CYCLE);
     }
     else if (morcnc() == '.') {
          cncall();
          if (tp->ques < MAXQUES) {
               btuinj(usrnum,CYCLE);
          }
     }
     else if (morcnc() == 'X') {
          cncall();
          condex();
          polmsg(GETLUP,1);
     }
     else {
          cncall();
          polmsg((isripu() ? DISSTATS : STATSHRT),0);
     }
}

STATIC void
cyc_ques(void)                          /* question display cycle routine  */
{
     int i=0;

     do {
          if (usrptr->substt == GETQUES && tp->ques >= MAXQUES) {
               polmsg(GETQUES,1);
               outprf(usrnum);
               return;
          }
          else {
               qcomp.qnum=tp->ques++;
               stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
               setbtv(qbb);
               if (qeqbtv(&qcomp,0)) {
                    gcrbtv(&tp->qdata,0);
                    tp->ans++;
                    prfmsg(LISTQUES,tp->qdata.qnum+1,questxt(),
                         qtypes[tp->qdata.qtype],
                         tp->qdata.qnum == 0 ? "N/A"
                           : spr("%3d",tp->qdata.prev+1),
                         tp->qdata.qnum == MAXQUES-1
                           ? "N/A" : spr("%3d",tp->qdata.next+1),
                         (tp->qdata.flags&BRANCH) ? "YES" : "NO");
                    outprf(usrnum);
                    clrprf();
               }
               rstbtv();
               if (usrptr->substt == GETQUES && tp->ans >= ANSPERPG) {
                    do {
                         qcomp.qnum=tp->ques++;
                         stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
                         setbtv(qbb);
                         if (qeqbtv(&qcomp,0)) {
                              gcrbtv(&tp->qdata,0);
                              tp->ans=0;
                              tp->flags|=MORELIST;
                              polmsg(MORQUES,0);
                              outprf(usrnum);
                              return;
                         }
                         i++;
                    } while (tp->ques < MAXQUES);
               }
          }
     } while (i++ < MAXCYCS && tp->ques < MAXQUES);
     if (tp->ques == 100) {
          if (usrptr->substt == GETQUES) {
               polmsg(GETQUES,1);
          }
          else {
               polmsg(AUTOINC,1);
          }
          outprf(usrnum);
          return;
     }
     btuinj(usrnum,CYCLE);
}

STATIC void
cyc_rslt(void)                          /* results display cycle routine   */
{
     int i=0;

     setbtv(qbb);
     if (tp->flags&REVERSE) {
          tp->ques-=2;
          do {
               qcomp.qnum=tp->ques--;
               stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
               if (acqbtv(&tp->qdata,&qcomp,0)) {
                    if (tp->qdata.qtype == MULTICHC
                     || tp->qdata.qtype == TRUEFALSE
                     || tp->qdata.qtype == YESNO) {
                         tp->ques+=2;
                         rstbtv();
                         results();
                         outprf(usrnum);
                         return;
                    }
               }
          } while (i++ < MAXCYCS && tp->ques >= 0);
          rstbtv();
          if (tp->ques < 0) {
               tp->ques=0;
               tp->flags&=~REVERSE;
          }
          btuinj(usrnum,CYCLE);
     }
     else {
          do {
               qcomp.qnum=tp->ques++;
               stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
               if (acqbtv(&tp->qdata,&qcomp,0)) {
                    if (tp->qdata.qtype == MULTICHC
                     || tp->qdata.qtype == TRUEFALSE
                     || tp->qdata.qtype == YESNO) {
                         rstbtv();
                         if (!(tp->flags&FNDFIRST)) {
                              tp->flags|=FNDFIRST;
                              tp->fques=tp->qdata.qnum;
                         }
                         results();
                         outprf(usrnum);
                         return;
                    }
               }
          } while (i++ < MAXCYCS && tp->ques < MAXQUES);
          rstbtv();
          if (tp->ques == MAXQUES || tp->ques < 0) {
               polmsg(ENDRSLT,0);
               polmsg(GETRES,1);
               outprf(usrnum);
          }
          else {
               btuinj(usrnum,CYCLE);
          }
     }
}

STATIC void
cyc_lup(void)                           /* lookup display cycle routine    */
{
     int i=0;

     setbtv(sbb);
     gabbtv(sp,(tp->oldpos=tp->pos),1);
     do {
          setbtv(pbb);
          if (acqbtv(&tp->pdata,sp->pname,0)) {
               if ((haskey(tp->pdata.lookup_key)
                 || sameas(tp->tmpid,usaptr->userid))
                 && !(tp->pdata.flags&DELETE)) {
                    if (tp->pdata.acc_attr != HIDE
                      || haskey(tp->pdata.res_key)
                      || haskey(tp->pdata.acc_key)) {
                         if (tp->ans == 0) {
                              prfmsg(GLUPHDR,tp->tmpid);
                              setmem(tp->select,POLLSPERPG*PNAMELEN,0);
                         }
                         stzcpy(tp->select[tp->ans++],tp->pdata.pname,PNAMELEN);
                         prfmsg(LUPLSTG,tp->ans,tp->pdata.pname);
                    }
               }
          }
          rstbtv();
          if (!aqnbtv(sp)) {
               if (tp->ans == 0) {
                    prfmsg(NOACCESS,tp->tmpid);
                    polmsg(GETLOOK,1);
               }
               else {
                    prfmsg(GETLUP);
                    poldft(usrptr->substt);
               }
               outprf(usrnum);
               rstbtv();
               return;
          }
     } while (i++ < MAXCYCS && tp->ans < POLLSPERPG);
     tp->pos=absbtv();
     rstbtv();
     if (tp->ans == POLLSPERPG) {
          prfmsg(MORLUP);
          poldft(usrptr->substt);
          outprf(usrnum);
     }
     else {
          btuinj(usrnum,CYCLE);
     }
}

STATIC void
cyc_disstats(void)                      /* display stats cycle routine     */
{
     qcomp.qnum=tp->ques++;
     stzcpy(qcomp.pollname,sp->pname,PNAMELEN);
     setbtv(qbb);
     if (acqbtv(&tp->qdata,&qcomp,0)) {
          acomp.qnum=tp->qdata.qnum;
          stzcpy(acomp.pollname,tp->qdata.pollname,PNAMELEN);
          stzcpy(acomp.uid,tp->tmpid,UIDSIZ);
          setbtv(abb);
          if (acqbtv(&tp->adata,&acomp,0)) {
               prfmsg(SHWSTAT,tp->tmpid,tp->qdata.pollname,tp->qdata.txtmsg);
               if (ismult()) {
                    showmult(0);
               }
               prfmsg(DISSTATS,tp->adata.answer);
               poldft(DISSTATS);
               outprf(usrnum);
               return;
          }
     }
     if (tp->ques < MAXQUES) {
          btuinj(usrnum,CYCLE);
     }
     else {
          prfmsg(ENDSTAT,tp->qdata.pollname);
          polmsg(GETLUP,1);
          outprf(usrnum);
     }
}

STATIC void
cyc_logon(void)                         /* cycle through polls at logon rou*/
{
     if (!(tp->flags&INSISTDUN)) {
          setbtv(pbb);
          gabbtv(&tp->pdata,tp->pos,0);
          if (!(tp->pdata.flags&(EDITP|ADDP|DELETE))) {
               if (haskey(tp->pdata.logon_key) && notexp()) {
                    stzcpy(scomp.uid,usaptr->userid,UIDSIZ);
                    stzcpy(scomp.pname,tp->pdata.pname,PNAMELEN);
                    setbtv(sbb);
                    if (!qeqbtv(&scomp,0)) {
                         if (tp->pdata.priority == INSIST) {
                              if (gopoll() != 0) {
                                   return;
                              }
                         }
                    }
               }
          }
          nxtpoll();
          return;
     }
     if (!(tp->flags&ASKDUN)) {
          setbtv(pbb);
          gabbtv(&tp->pdata,tp->pos,0);
          if (!(tp->pdata.flags&(EDITP|ADDP|DELETE))) {
               if (haskey(tp->pdata.logon_key) && notexp()) {
                    stzcpy(scomp.uid,usaptr->userid,UIDSIZ);
                    stzcpy(scomp.pname,tp->pdata.pname,PNAMELEN);
                    setbtv(sbb);
                    if (!qeqbtv(&scomp,0)) {
                         if (tp->pdata.priority == ASK
                           || tp->pdata.priority == ANNOUNCE) {
                              if (gopoll() != 0) {
                                   return;
                              }
                         }
                    }
               }
          }
          nxtpoll();
     }
}

STATIC void
cyc_resusrs(void)                       /* reset users cycle routine       */
{
     if (tp->ans >= MAXQUES) {
          setbtv(sbb);
          tp->pos=acqbtv(sp,tp->pdata.pname,2) ? absbtv() : 0L;
          usrptr->substt=RESUSRS2;
          rstbtv();
     }
     else {
          acompcup.qnum=tp->ans;
          stzcpy(acompcup.pollname,tp->pdata.pname,PNAMELEN);
          setbtv(abb);
          if (acqbtv(&tp->adata,&acompcup,1)) {
               delbtv();
          }
          else {
               tp->ans++;
          }
     }
     rstbtv();
     cycwheel();
     btuinj(usrnum,CYCLE);
}

STATIC void
cyc_resusrs2(void)                      /* reset-2 users cycle routine     */
{
     setbtv(sbb);
     if (aabbtv(sp,tp->pos,2)) {
          delbtv();
          if (aqnbtv(sp)) {
               tp->pos=absbtv();
          }
     }
     else {
          rstbtv();
          setbtv(tbb);
          if (acqbtv(NULL,tp->pdata.pname,0)) {
               delbtv();
          }
          rstbtv();
          polmsg(RESDUN,0);
          polmsg(EDITPOLL,1);
          outprf(usrnum);
          return;
     }
     rstbtv();
     cycwheel();
     btuinj(usrnum,CYCLE);
}

STATIC int
gopoll(void)                            /* prepare user for taking poll    */
{
     qcomp.qnum=0;
     stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
     setbtv(qbb);
     if (acqbtv(&tp->qdata,&qcomp,0)) {
          if (!(tp->flags&HASSLE)) {
               tp->flags|=HASSLE;
               polmsg(HSLHDR,0);
          }
          if (tp->pdata.priority == INSIST) {
               polmsg(POLLANC,0);
               polmsg(POLLINS,1);
          }
          else if (tp->pdata.priority == ANNOUNCE) {
               polmsg(POLLANC,0);
               outprf(usrnum);
               return(0);
          }
          else {
               polmsg(POLLASK,1);
          }
          outprf(usrnum);
          return(1);
     }
     prf("\rPoll '%s' is missing question #%d!",
          tp->pdata.pname,qcomp.qnum);
     return(0);
}

STATIC void
nxtpoll(void)                           /* locate next poll           */
{
     setbtv(pbb);
     gabbtv(NULL,tp->pos,0);
     if (qnxbtv()) {
          tp->pos=absbtv();
          btuinj(usrnum,CYCLE);
     }
     else {
          qlobtv(0);
          tp->pos=absbtv();
          if (!(tp->flags&INSISTDUN)) {
               tp->flags|=INSISTDUN;
               btuinj(usrnum,CYCLE);
          }
          else if (!(tp->flags&ASKDUN)) {
               tp->flags|=ASKDUN;
               if (tp->flags&HASSLE) {
                    prfmsg(RETLON);
               }
               else {
                    prf("");
               }
               outprf(usrnum);
               clrprf();
               usrptr->substt=EMGEXIT;
               btuinj(usrnum,CRSTG);
          }
     }
     rstbtv();
}

STATIC void
pollask(void)                           /* logon ask input handler         */
{
     switch (cncyesno()) {
     case 'Y':
          cncall();
          polmsg(TAKEPOLL,1);
          break;
     case 'X':
          cncall();
          prfmsg(ASKNO);
          prfmsg(RETLON);
          usrptr->substt=EMGEXIT;
          btuinj(usrnum,CRSTG);
          break;
     case '\0':
          polmsg(POLLASK,1);
          break;
     default:
          cncall();
          prfmsg(ASKNO);
          outprf(usrnum);
          clrprf();
          usrptr->substt=LOGON;
          nxtpoll();
     }
}

STATIC void
pollins(void)                           /* logon inist input handler       */
{
     if (morcnc() == '.') {
          cncall();
          polmsg(TAKEPOLL,1);
     }
     else if (morcnc() == 'X' && ispollop()) {
          cncall();
          prfmsg(RETLON);
          usrptr->substt=EMGEXIT;
          btuinj(usrnum,CRSTG);
     }
     else {
          cncall();
          polmsg(POLLINS,1);
     }
}

STATIC int
notexp(void)                            /* check if poll is expired/deleted*/
{
     if (cofdat(tp->pdata.closedate) < cofdat(today())) {
          return(0);                    /* poll is closed                  */
     }
     if (tp->pdata.flags&DELETE) {
          return(0);
     }
     return(1);
}


STATIC void
cycwheel(void)                          /* cycle wheel animation routine   */
{
     if (tp->wheel >= MAXWHEEL) {
          tp->wheel=0;
     }
     prfmsg(WHEEL,wheel[tp->wheel++]);
     outprf(usrnum);
}

STATIC int
chkpoll(void)                           /* check poll before accessing     */
{
     int retval=1;

     if (tp->pdata.flags&DELETE) {
          polmsg(POLLTDL,0);
          retval=0;
     }
     if (usrptr->substt == GETTAKE && !notexp()) {
          polmsg(POLLEXP,0);
          retval=0;
     }
     if (tp->pdata.flags&(EDITP|ADDP)) {
          polmsg(POLLAE,0);
          retval=0;
     }
     return(retval);
}

STATIC void
apendasc(void)                          /* ASCII file append routine       */
{
     FILE *fp;

     setmbk(polmb);
     strcpy(tp->tstr,rawmsg(ASCIIFIL));
     if ((fp=fopen(tp->tstr,FOPAA)) != NULL) {
          fprintf(fp,"\n%s %s (%s): %s #%d\nAnswer: %s\n",
               ncdate(today()),
               nctime(now()),
               usaptr->userid,
               tp->pdata.pname,
               tp->qdata.qnum+1,
               tp->adata.answer);
          fclose(fp);
     }
     else {
          shocst("P&Q FILE OPEN ERROR!","Error opening file %s for append!",
               tp->tstr);
     }
}

STATIC void
grantstf(void)           /* after completion of poll/questionnaire handle  */
{                        /* granting user specifed key, credits and file   */
     FILE *fp;
     long creds;
     struct clstab *tabptr;

     tabptr=fndcls(usaptr->curcls);
     if (strlen(tp->pdata.grant_key) > 0) {
          if (!haskey(tp->pdata.grant_key)) {
               givkey(usaptr->userid,tp->pdata.grant_key);
               prfmsg(GOTKEY,tp->pdata.grant_key);
          }
     }
     if (tp->pdata.grant_crd > 0L) {         /* post credits to user       */
          addcrd(usaptr->userid,l2as(tp->pdata.grant_crd),0);
          prfmsg(CRDSPST,l2as(tp->pdata.grant_crd));
     }
     else if (tp->pdata.grant_crd < 0L && !(tabptr->flags&CRDXMT)) {
          creds=tp->pdata.grant_crd*-1L;
          if (dedcrd(creds,0)) {
               prfmsg(CRDSDED,l2as(creds));
          }
     }
     if (strlen(tp->pdata.grant_class) > 0) {/* data in class field?       */
          swtcls(usaptr,1,tp->pdata.grant_class,3,0);
     }
     if (strlen(tp->pdata.grant_file) > 0) { /* found something here       */
          setmem(mp,sizeof(struct message)+MSGSIZ,0);
          mp->msgno=++sv.msgtot;
          stzcpy(mp->userto,usaptr->userid,UIDSIZ);
          stzcpy(mp->from,"Sysop",UIDSIZ);
          stzcpy(mp->to,usaptr->userid,UIDSIZ);
          strcpy(mp->topic,"Polls & Questionnaires File");
          clrprf();
          prfmsg(GRNTFIL,type[tp->pdata.polltype],tp->pdata.pname);
          prf2tx();
          mp->flags|=(FILATT+APPVED+INDRCT);
          if ((fp=fopen(attfsp(mp),FOPWB)) != NULL) {
               setmem(prfbuf,FSPSIZ,0);
               strcpy(prfbuf,tp->pdata.grant_file);
               fwrite(prfbuf,1,FSPSIZ-1,fp);
               fclose(fp);
          }
          mp->crdate=today();
          mp->crtime=now();
          sendmsg(mp,usaptr->userid);
          clrprf();
          prfmsg(MSGSNT,type[tp->pdata.polltype],tp->pdata.pname);
     }
}

STATIC char *
attfsp(msg)                   /* attachment filespec, "direct" only        */
struct message *msg;
{
     static char filespec[FSPSIZ];
     char *fnp;
     int fnplen;

     strcpy(filespec,msg->to[0] == SIGIDC ? msg->to+1 : "email");
     fnp=spr("\\%ld.att",msg->msgno);
     while ((fnplen=strlen(fnp)) >= 14) {         /* ensures over 2 billion */
          fnp[fnplen-2]=fnp[fnplen-1];            /*   unique filenames     */
          fnp[fnplen-1]=fnp[1];
          movmem(fnp+2,fnp+1,strlen(fnp+1));
     }
     strcat(filespec,fnp);
     return(filespec);
}

STATIC void
upaccfld(void)                          /* update user specified user data */
{
     switch (tp->qdata.field) {
     case 0:
     case 1:                            /* name                            */
          stzcpy(usaptr->usrnam,tp->adata.answer,NADSIZ);
          break;
     case 2:                            /* company                         */
          stzcpy(usaptr->usrad1,tp->adata.answer,NADSIZ);
          break;
     case 3:                            /* address line 1                  */
          stzcpy(usaptr->usrad2,tp->adata.answer,NADSIZ);
          break;
     case 4:                            /* address line 2                  */
          stzcpy(usaptr->usrad3,tp->adata.answer,NADSIZ);
          break;
     case 5:                            /* address line 3                  */
          stzcpy(usaptr->usrad4,tp->adata.answer,NADSIZ);
          break;
     case 6:                            /* phone number                    */
          stzcpy(usaptr->usrpho,tp->adata.answer,PHOSIZ);
          break;
     case 7:                            /* birthday                        */
          if (okbday(tp->adata.answer)) {
               stzcpy(usaptr->birthd,tp->adata.answer,DATSIZ);
          }
          break;
     case 8:                            /* sex                             */
          if (sameas(tp->adata.answer,"m") || sameas(tp->adata.answer,"f")) {
               usaptr->sex=toupper(tp->adata.answer[0]);
          }
          break;
     case 9:                            /* ansi setting                    */
          if (sameto(tp->adata.answer,"yes") || sameto(tp->adata.answer,"on")) {
               usaptr->ansifl|=ANSON;
          }
          else if (sameto(tp->adata.answer,"no")
                || sameto(tp->adata.answer,"off")) {
               usaptr->ansifl&=~ANSON;
               usaptr->ansifl|=ANSMAN;
          }
          else if (sameto(tp->adata.answer,"auto")) {
               usaptr->ansifl=0;
          }
          break;
     case 10:                           /* editor setting                  */
          if (sameto(tp->adata.answer,"yes")
           || sameto(tp->adata.answer,"fse")) {
               usaptr->usrprf&=~PRFLIN;
          }
          else if (sameto(tp->adata.answer,"no")
                 || sameto(tp->adata.answer,"line")) {
               usaptr->usrprf|=PRFLIN;
          }
          break;
     case 11:                           /* password                        */
          stzcpy(usaptr->psword,tp->adata.answer,PSWSIZ);
     }
}

STATIC void
delconf(void)                           /* delete confirmation rebuff      */
{
     switch (cncyesno()) {
     case '\0':
          polmsg(DELCONF,1);
          break;
     case '?':
          cncall();
          polmsg(DELHELP,0);
          polmsg(DELCONF,1);
          break;
     case 'Y':
          cncall();
          polmsg(POLLDEL,0);
          polmsg(GETPOLL,1);
          break;
     default:
          cncall();
          polmsg(EDITPOLL,1);
     }
}

STATIC void
cyc_delques(void)                       /* delete questions cycle routine  */
{
     setbtv(tbb);
     if (acqbtv(&tally,tp->pdata.pname,0)) {
          setmem(tally.answer[tp->qdata.qnum],sizeof(int)*MAXASTGS,0);
          upvbtv(&tally,sizeof(struct polltally));
     }
     rstbtv();
     setbtv(abb);
     acompcup.qnum=tp->qdata.qnum;
     stzcpy(acompcup.pollname,tp->pdata.pname,PNAMELEN);
     if (acqbtv(NULL,&acompcup,1)) {
          delbtv();
     }
     else {
          rstbtv();
          setbtv(qbb);
          qcomp.qnum=tp->qdata.qnum;
          stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
          if (acqbtv(NULL,&qcomp,0)) {
               delbtv();
          }
          rstbtv();
          btulok(usrnum,0);
          polmsg(DUNDELQ,1);
          outprf(usrnum);
          return;
     }
     rstbtv();
     cycwheel();
     btuinj(usrnum,CYCLE);
}

STATIC void
dundelq(void)                           /* delete questions when done rou  */
{
     cncall();
     usrptr->substt=GETQUES;
     listquest();
}

STATIC void
prf2tx(void)                  /* xfer prfbuf contents to message text area */
{
     char *cp;

     stpans(prfbuf);
     if (strlen(prfbuf) >= MSGSIZ) {
          prfbuf[MSGSIZ-1]='\0';
     }
     for (cp=prfbuf ; *cp != '\0' ; cp++) {
          if (*cp == '\n') {
               *cp='\r';
          }
     }
     strcpy(mp->text,prfbuf);
     clrprf();
}

STATIC void
poldft(msg)                             /* substt check for dftinp()       */
int msg;
{
     if (!isripu()) {
          tp->dftinp=getdft();
     }
     else {
          switch (msg) {
          case COMPPOLL:
          case COMPPOL2:
          case ANSONCE:
               return;
          default:
               tp->dftinp=getdft();
          }
     }
}

STATIC int
okdate(stg)                             /* make sure date is valid         */
char *stg;
{
     if (sameas(stg,ncdate(datofc(cofdat(dcdate(stg)))))
       && cofdat(dcdate(stg)) >= cofdat(today())) {
          return(1);
     }
     return(0);
}

STATIC int
chk_clearance(void)                     /* check user access level         */
{
     switch (usrptr->substt) {
     case GETRES:
          return(haskey(tp->pdata.res_key));
     case GETTAKE:
          return(haskey(tp->pdata.acc_key));
     }
     return(0);
}

STATIC void
resconf(void)                           /* reset user answers confirmation */
{
     switch (cncyesno()) {
     case '\0':
          polmsg(RESCONF,1);
          break;
     case '?':
          cncall();
          polmsg(RESHELP,0);
          polmsg(RESCONF,1);
          break;
     case 'Y':
          cncall();
          polmsg(RESUSRS,1);
          break;
     default:
          cncall();
          polmsg(EDITPOLL,1);
     }
}

STATIC void
polhang(void)                           /* lost carrier routine            */
{
     setptrs();
     if (poledit[usrnum]) {
          if (tp->pdata.flags&(EDITP|ADDP)) {
               qcomp.qnum=0;
               stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
               setbtv(qbb);
               if (!acqbtv(NULL,&qcomp,0)) {
                    rstbtv();
                    setbtv(pbb);
                    if (acqbtv(NULL,tp->pdata.pname,0)) {
                         delbtv();
                    }
               }
               else {
                    setbtv(pbb);
                    if (acqbtv(NULL,tp->pdata.pname,0)) {
                         tp->pdata.flags&=~(EDITP+ADDP);
                         updbtv(&tp->pdata);
                    }
               }
          }
          poledit[usrnum]=0;
     }
}

STATIC void
polacup(void)                           /* auto-cleanup routine            */
{
     setbtv(pbb);
     if (qlobtv(0)) {
          do {
               gcrbtv(&atp->pdata,0);
               if (atp->pdata.flags&DELETE) {
                    delbtv();
                    atp->ques=0;
                    stzcpy(qcomp.pollname,atp->pdata.pname,PNAMELEN);
                    setbtv(qbb);
                    do {
                         qcomp.qnum=atp->ques++;
                         if (acqbtv(&atp->qdata,&qcomp,0)) {
                              delbtv();
                              acompcup.qnum=qcomp.qnum;
                              stzcpy(acompcup.pollname,atp->pdata.pname,PNAMELEN);
                              setbtv(abb);
                              if (acqbtv(&atp->adata,&acompcup,1)) {
                                   do {
                                        if (!sameas(atp->adata.pollname,
                                                    atp->pdata.pname)) {
                                             break;
                                        }
                                        delbtv();
                                   } while (aqnbtv(&atp->adata));
                              }
                              rstbtv();
                         }
                    } while (atp->ques < MAXQUES);
                    rstbtv();
                    setbtv(tbb);
                    if (acqbtv(&tally,atp->pdata.pname,0)) {
                         delbtv();
                    }
                    rstbtv();
                    setbtv(sbb);
                    if (acqbtv(NULL,atp->pdata.pname,2)) {
                         do {
                              delbtv();
                         } while (acqbtv(NULL,atp->pdata.pname,2));
                    }
                    rstbtv();
               }
          } while (qnxbtv());
     }
}

STATIC void
polcls(void)                            /* system shutdown routine         */
{
     clsmsg(polmb);
     clsbtv(sbb);
     clsbtv(pbb);
     clsbtv(qbb);
     clsbtv(abb);
     clsbtv(tbb);
}

STATIC char *
rsltper(num,tot)                        /* results percentage calculation  */
int num,tot;
{
     long comp;

     if (tot == 0) {
          comp=0L;
     }
     else {
          comp=(long)num*1000L/(long)tot;
          comp-=comp/10L*10L;
     }
     return(tot == 0 ? "  0.0"
          : spr("%3ld.%1.1ld",num*100L/tot,comp));
}

STATIC void
initasc(void)                           /* initialize ASCII log file       */
{
     FILE *fp;
     char tmpfil[FILESIZ];

     stzcpy(tmpfil,rawmsg(ASCIIFIL),FILESIZ);
     if ((fp=fopen(tmpfil,FOPRA)) == NULL) {
          if ((fp=fopen(tmpfil,FOPWA)) != NULL) {
               fprintf(fp,"Poll and Questionnaires Log File: %s %s\n",
                    ncdate(today()),nctime(now()));
          }
     }
     fclose(fp);
}

STATIC void
rstflgs(void)                           /* reset Poll-Op flags             */
{
     setbtv(pbb);
     if (qlobtv(0)) {
          do {
               gcrbtv(NULL,0);
               if (pptr->flags&(EDITP|ADDP)) {
                    pptr->flags&=~(EDITP+ADDP);
                    updbtv(NULL);
               }
          } while (qnxbtv());
     }
}

STATIC void
pnachng(void)                           /* non-ansi change poll question   */
{
     switch (cncyesno()) {
     case 'Y':
          cncall();
          addprp(POLLNTPQ,0);
          polptc();
          fsdego(polvfy,poldun);
          break;
     case 'N':
     case 'X':
          cncall();
          polmsg(EDITPOLL,1);
          break;
     default:
          polmsg(PNACHNG,1);
     }
}

STATIC void
qnachng(void)                           /* non-ansi change question ques.  */
{
     switch (cncyesno()) {
     case 'Y':
          cncall();
          quesprp(QUESNTPQ,0);
          quesptc();
          fsdego(quesvfy,quesdun);
          break;
     case 'N':
     case 'X':
          cncall();
          polmsg(QUESOPTS,1);
          break;
     default:
          polmsg(QNACHNG,1);
     }
}
STATIC void
anachng(void)                           /* non-ansi change answer string   */
{
     switch (cncyesno()) {
     case 'Y':
          cncall();
          astgprp(ASTGNTPQ,0);
          astgptc();
          fsdego(astgvfy,astgdun);
          break;
     case 'N':
     case 'X':
          cncall();
          polmsg(QUESOPTS,1);
          break;
     default:
          polmsg(ANACHNG,1);
     }
}

STATIC int
polstat(void)                           /* return pstat array cell         */
{
     int stat=0;

     if (tp->pdata.flags&(EDITP|ADDP)) {
          stat=3;
     }
     else if (tp->pdata.flags&DELETE) {
          stat=2;
     }
     else {
          stzcpy(scomp.uid,usaptr->userid,UIDSIZ);
          stzcpy(scomp.pname,tp->pdata.pname,PNAMELEN);
          setbtv(sbb);
          if (qeqbtv(&scomp,0)) {
               stat=1;
          }
          rstbtv();
     }
     return(stat);
}

STATIC int
duntake(flags)                          /* takepoll dunedt routine         */
int flags;
{
     setmbk(polmb);
     usrptr->state=polrmn;
     if (flags&ED_QUITEX) {
          polmsg(TAKEPOLL,1);
     }
     else {
          stzcpy(vdatmp,tp->adata.answer,ANSSIZ);
          if (tp->flags&ADDRESP) {
               setmem(tp->adata.answer,ANSSIZ,0);
               tp->flags&=~ADDRESP;
          }
          saveresp(vdatmp);
     }
     outprf(usrnum);
     return(1);
}

STATIC void
saveresp(ansstg)                        /* save response and process answer*/
char *ansstg;
{
     if (tp->qdata.qtype == MULTICHC || tp->qdata.qtype == TRUEFALSE
      || tp->qdata.qtype == YESNO) {
          if (!chk_answer(ansstg)) {
               polmsg(TAKEPOLL,1);
               rstbtv();
               return;
          }
     }
     setbtv(abb);
     if (strlen(tp->adata.answer) == 0
      || tp->pdata.answer == ACCUMULATE) {
          if (tp->pdata.data != DISCARD
           && tp->pdata.data != ASCII
           && !(tp->qdata.flags&EXMPT)) {
               tp->adata.qnum=tp->qdata.qnum;
               stzcpy(tp->adata.pollname,tp->pdata.pname,PNAMELEN);
               stzcpy(tp->adata.uid,usaptr->userid,UIDSIZ);
               stzcpy(tp->adata.answer,ansstg,ANSSIZ);
               invbtv(&tp->adata,sizeof(struct ansrdata)-ANSSIZ
                    +strlen(tp->adata.answer)+1);
          }
     }
     else {
          tp->ques=tp->qdata.qnum;
          if (remove_tally() == 0) {
               return;
          }
          if (tp->pdata.data != DISCARD && tp->pdata.data != ASCII
           && !(tp->qdata.flags&EXMPT)) {
               acomp.qnum=tp->qdata.qnum;
               stzcpy(qcomp.pollname,tp->pdata.pname,PNAMELEN);
               stzcpy(acomp.uid,usaptr->userid,UIDSIZ);
               if (acqbtv(&tp->adata,&acomp,0)) {
                    stzcpy(tp->adata.answer,ansstg,ANSSIZ);
                    upvbtv(&tp->adata,sizeof(struct ansrdata)
                         -ANSSIZ+strlen(tp->adata.answer)+1);
               }
          }
          else {
               stzcpy(tp->adata.answer,ansstg,ANSSIZ);
          }
     }
     rstbtv();
     if (tp->qdata.qtype == USERACCT) {           /* user account field    */
          upaccfld();
     }
     if (tp->pdata.data == ASCII || tp->pdata.data == BOTH) {
          apendasc();
     }
     if (tp->pdata.polltype != QUEST) {
          add_tally();
     }
     if (chknext()) {
          loadnext();
     }
     else {
          polmsg(COMPPOLL,0);
          condex();
          polmsg(GETTAKE,1);
     }
}
