/**********************************************************************
*       Swords of Chaos Offline Editor v1.7                           *
*       Origin Date: 08/23/95                                         *
*       Last Mod:    03/29/97                                         *
*                                                                     *
*       Programmer:  Mark Peterson                                    *
*                                                                     *
*       Copyright (C) 1997 by Mark Peterson, All Rights Reserved      *
***********************************************************************/

#define EDITOR
#include <header.h>

#define CR          13
#define BUF_MAX     10000

#define ROOM_NUM      1
#define ROOM_TYPE     2
#define TOWN_ROOM     3
#define ROOM_TRAP     4
#define ROOM_COVER    5
#define ROOM_DESC1    6
#define ROOM_DESC2    7
#define ROOM_DESC3    8
#define ROOM_DESC4    9
#define NORTH_EXIT   10
#define NORTH_VIS    11
#define SOUTH_EXIT   12
#define SOUTH_VIS    13
#define EAST_EXIT    14
#define EAST_VIS     15
#define WEST_EXIT    16
#define WEST_VIS     17
#define UP_EXIT      18
#define UP_VIS       19
#define DOWN_EXIT    20
#define DOWN_VIS     21
#define OUT_EXIT     22
#define OUT_VIS      23
#define SPEC_EXIT    24
#define SPEC_VIS     25
#define SPEC_ART     26
#define SPEC_ADJ     27
#define SPEC_NAME    28
#define SPEC_TYPE    29  
#define SPEC_FILTER  30
#define SPEC_KEY     31
#define ENCOUNTER    32
#define MON0         33
#define MON1         34
#define MON2         35
#define MON3         36
#define MON4         37
#define SPEC_CHANT   38
#define INVADERS     39
#define NO_TELEPORT  40
#define FILTER_ITEM  41
#define ROOM_DESC5   42
#define ROOM_DESC6   43
#define FILTER_RACE  44
#define FILTER_CLASS 45
#define FILTER_LEVEL 46

#define ITEM_NUM        1
#define ITEM_ARTICLE    2
#define ITEM_ADJECTIVE  3
#define ITEM_NAME       4
#define ITEM_WHAT       5
#define ITEM_WHICH      6
#define ITEM_LEVEL      7
#define ITEM_SPELL      8
#define ITEM_KEY        10
#define ITEM_ROOM       11
#define PUZZLE_INDEX    12
#define PUZZLE_SIZE     13
#define PUZZLE_ITEM     14
#define ITEM_PERMANANT  15 
#define ITEM_INSTILL    16

#define CRIT_NUM        1
#define CRIT_ARTICLE    2
#define CRIT_NAME       3
#define CRIT_PLURAL     4
#define CRIT_TYPE       5
#define CRIT_LEVEL      6
#define CRIT_GOOD       7
#define CRIT_CAST       8
#define CRIT_MAGIC      9
#define CRIT_BLOCK      10
#define CRIT_PERM       11
#define CRIT_ROVE       12
#define CRIT_LOC        13
#define CRIT_ATTACKED   14
#define CRIT_ATTACK     15
#define CRIT_TALK       16
#define CRIT_ITEM0      17
#define CRIT_ITEM1      18
#define CRIT_ITEM2      19
#define CRIT_ITEM3      20
#define CRIT_ITEM4      21
#define CRIT_REWARD     22
#define CRIT_MORPH      23
#define CRIT_IMMUNE     24
#define CRIT_QUESTS     25
#define CRIT_EVIL       26

#define START_ROOM      1
#define END_ROOM        2
#define EXPORT_MONS     3
#define EXPORT_ITEMS    4
#define EXPORT_FILE     5
#define EXPORT_DESC0    6
#define EXPORT_DESC1    7
#define EXPORT_DESC2    8
#define EXPORT_DESC3    9
#define EXPORT_DESC4    10
#define EXPORT_DESC5    11
#define EXPORT_DESC6    12
#define EXPORT_DESC7    13
#define EXPORT_DESC8    14
#define EXPORT_DESC9    15
#define EXPORT_DESC10   16
#define EXPORT_DESC11   17
#define EXPORT_DESC12   18
#define EXPORT_READY    19
#define EXPORT_CODE     20

#define IMPORT_FILE     1
#define IMPORT_ROOMS    2
#define IMPORT_ITEMS    3
#define IMPORT_CRITS    4
#define IMPORT_READY    5
#define IMPORT_CODE     6

#define MAX_EXPORT_DESC 13
#define ACT_CODE_SIZE   9

struct export_struct
{
    int     num_rooms;
    int     num_crits;
    int     num_items;
    char    desc[MAX_EXPORT_DESC][LINE_SIZE];
    char    act_code[ACT_CODE_SIZE];
    char    data3[7];
    char    misc[64];
};

#define EXPORT_SIZE     sizeof(struct export_struct)

extern int  Export_Area(void);
extern int  Import_Area(void);
extern void Notify(char *text);
extern void Write_Report_Item(int index);
extern void Write_Report_Monster(void);
extern void Sort_Spell_Info(void);
extern int  Display_Item(void);
extern void Display_Item_Type(int t);
extern void Display_Item_Subtype(int t);
extern void Display_Item_Spell(int s);
extern void Display_Trap(int trap);
extern void Display_Door(int d);
extern void Display_Filter(int f);
extern void Display_Room_Type(int rmtype);
extern int  Display_Room(void);
extern int  Display_Monster(void);
extern void Pad_Str(char *st, int len);
extern int  Validate_String(void);
extern int  Validate_Room_Num(int c, char *so_far);
extern int  Validate_Item_Num(int c, char *so_far);
extern int  Validate_Crit_Num(int c, char *so_far);
extern int  Validate_Room_Type(int c, char *so_far);
extern int  Validate_Filter(int c, char *so_far);
extern int  Validate_Item_What(int c, char *so_far);
extern int  Validate_Item_Spell(int c, char *so_far);
extern int  Validate_Item_Which(int c, char *so_far);
extern int  Validate_Trap_Type(int c, char *so_far);
extern int  Validate_Crit_Type(int c, char *so_far);
extern int  Validate_Attacked(int c, char *so_far);
extern int  Validate_Attack(int c, char *so_far);
extern int  Validate_Door_Type(int c, char *so_far);
extern void Edit_Room(void);
extern void Edit_Item(void);
extern void Edit_Monster(void);
extern void Write_Critter(struct crit_struct *crit);
extern int  Read_Critter(int c, struct crit_struct *crit);
extern int  Read_Room(int r, struct room_struct *room);
extern void Write_Room(struct room_struct *room);
extern int  Read_Item(int i, struct item_struct *item);
extern void Write_Item(struct item_struct *item);
extern void Display_Crit_Type(int t);
extern void Display_Attacked_Vector(int v);
extern void Display_Attack_Vector(int v);
extern int  Monster_Report(void);
extern int  Item_Report(void);
extern int  Room_Report(void);
extern int  Do_Export(void);
extern int  Import(void);

char    value[LINE_LEN];
char    scr_bin[4000];
char    str[LINE_LEN];
int     room_num = 0;
int     item_num = 0;
int     crit_num = 0;
int     field;

struct  room_struct a_room;
struct  room_struct room;
struct  item_struct an_item;
struct  item_struct item;
struct  crit_struct a_crit;
struct  crit_struct crit;

char    *mon_types[] =
{
        "?",
        "NPC", 
        "Monster", 
        "Animal", 
        "Weird", 
        "Humanoid", 
        "Oracle",
        "Huntress",
        "Awesome",
        "Loner"
};

char    *RoomTypes[] =
{
        "Guild #9",
        "Guild #8",
        "Guild #7",
        "Guild #6",
        "Guild #5",
        "Guild #4", 
        "Guild #3",
        "Guild #2",
        "Guild #1",
        "Nothing special",
        "Academy",
        "Player arena",
        "Armory",
        "Hall of Fame",
        "Water damage room",
        "Mercantile",
        "Bank",
        "Safe haven",
        "Boat",
        "Player storage closet",
        "Fire damage room",
        "One-shot damage room",
        "No casting allowed",
        "No magic allowed (cast or item)",
        "Weaponsmith",
        "Alchemist",
        "Sticky Items",
        "Solo Room"
};
        
char    *trap_types[] =
{
        "None",
        "Poison dart",
        "Bomb",
        "Teleport",
        "Langour",
        "Sleep",
        "Aggrivation",
        "Weakness",
        "Dispel Magic"
};

char    *attack_vectors[] =
{
        "No Special Attack Vector",
        "Poisoner",
        "Stealer",
        "Drainer",
        "Pest",
        NULL
};

char    *attacked_vectors[] =
{
        "No Special Vector",
        "Attacker jailed",
        "Give evil points",
        "Morph Level",
        "Always Flees",
        NULL
};

char    *crit_types[] =
{
        "Human", 
        "Monster", 
        "Animal", 
        "Weird Monster", 
        "Humanoid", 
        "Oracle",
        "Huntress",
        "Awesome",
        "Loner",
        NULL
};

char    *door_types[] =
{
        "Non-Door",
        "Regular",
        "Magic",
        "Special",
        "Chant",
        NULL
};

char    *filter_types[] =
{
        "No Filter",
        "Guild 1 members only",
        "Guild 2 members only",
        "Guild 3 members only",
        "Guild 4 members only",
        "Guild 5 members only",
        "Guild 6 members only",
        "Guild 7 members only",
        "Guild 8 members only",
        "Guild 9 members only",
        "Player Arena Filter",
        "Specific Item Filter",
        "Class Filter",
        "Race Filter",
        "Officers Only",
        "Governor Only",
        "Assassin Only",
        "Paladin Only",
        "Judge Only",
        "Level Filter",
        NULL
};

char    *item_whiches[] =
{
        "No Special Subtype",
        "Two-Handed Weapon",
        "Non-Metallic Armor",
        "Light Weapon",
        "Skeleton Key",
        "Scroll",
        "Undroppable Shield",
        "Light Shield",
        "Magic Ring",
        "Weightless Container",
        "Special Key",
        "Puzzle Piece",
        NULL
};

char    *item_whats[] =
{
        "Edged Weapon",
        "Blunt Weapon",
        "Magic Device",
        "Armor",
        "Shield",
        "Pole Weapon",
        "Cash",
        "Jewels",
        "Trinket",
        "Unarmed Combat Aid",
        "Storage Container",
        "Talisman",
        "Transporter",
        "Amulet",
        "Psychic Focus",
        NULL
};

char    *room_types[] =
{
        "Nothing special",
        "Academy",
        "Player arena",
        "Armory",
        "Hall of Fame",
        "Water damage room",
        "Mercantile",
        "Bank",
        "Safe haven",
        "Boat",
        "Player storage closet",
        "Fire damage room",
        "One-shot damage room",
        "No casting allowed",
        "No magic allowed (cast or item)",
        "Weaponsmith",
        "Alchemist",
        "Sticky Items",
        "Solo Room",
        "Guild #1",
        "Guild #2",
        "Guild #3",
        "Guild #4",
        "Guild #5",
        "Guild #6", 
        "Guild #7",
        "Guild #8",
        "Guild #9",
        NULL
};

FILE    *fp;
FILE    *fp_room;
FILE    *fp_item;
FILE    *fp_crit;

int     buf[BUF_MAX];
int     start_room;
int     end_room;
int     export_mons;
int     export_items;
int     start_item;
int     start_crit;
char    export_file[13];
struct  export_struct   export;

#include <spells.h>

/***************************************************************************/

void main(void)
{
    int     ok;
    char    c;

    ansion(TRUE);
    Sort_Spell_Info();
    iniscn("MUICHAOS.ED1", scr_bin);
    explode(scr_bin, 0, 0, 79, 24);
     
    ok = Read_Room(0, &a_room);

    if (!sameas(a_room.desc[0], DATA3))
    {
        catastro("Convert to Version 3 Data First!");
    }

    do
    {
        locate(37, 17);
        printf(" ");
        locate(37, 17);
        c = toupper(getchc());
        
        if (c == 'Q')
        {
            printf("%c", c);
            ok = FALSE;
        }
        else if (c >= '1' && c <= '8')
        {
            printf("%c", c);
            ok = TRUE;

            if (c == '1')
            {
                Edit_Room();
            }
            else if (c == '2')
            {
                Edit_Item();
            }
            else if (c == '3')
            {
                Edit_Monster();
            }
            else if (c == '4')
            {
                locate(0, 24);
                printf(CLEAR_RIGHT);
                locate(26, 24);
                printf("Writing room report...%s", CLEAR_RIGHT);
                Room_Report();
            }
            else if (c == '5')
            {
                locate(0, 24);
                printf(CLEAR_RIGHT);
                locate(26, 24);
                printf("Writing monster report...%s", CLEAR_RIGHT);
                Monster_Report();
            }
            else if (c == '6')
            {
                locate(0, 24);
                printf(CLEAR_RIGHT);
                locate(26, 24);
                printf("Writing item report...%s", CLEAR_RIGHT);
                Item_Report();
            }
            else if (c == '7')
            {
                Do_Export();
            }
            else if (c == '8')
            {
                Import();
            }

            iniscn("MUICHAOS.ED1", scr_bin);
            explode(scr_bin, 0, 0, 79, 24);

            if (c == '4')
            {
                locate(16, 24);
                printf
                (
                    "Report written to: %s%s", 
                    ROOM_REPORT_FILE, 
                    CLEAR_RIGHT
                );
            }
            else if (c == '5')
            {
                locate(16, 24);
                printf
                (
                    "Report written to: %s%s", 
                    MONSTER_REPORT_FILE,
                    CLEAR_RIGHT
                );
            }
            else if (c == '6')
            {
                locate(16, 24);
                printf
                (
                    "Report written to: %s%s", 
                    ITEM_REPORT_FILE,
                    CLEAR_RIGHT
                );
            }
        }
        else if (c == ESC)
        {
            ok = FALSE;
        }
        else 
        {
            belper(600);
            printf("\7");
        }
    }
    while (ok);
  
    cursact(1);
    locate(0, 24);
}
/****************************************************************************
    pop up notification
*/
void Notify(text)
char *text;
{
    int     spaces;
    
    iniscn("MUICHAOS.ED6", scr_bin);
    explodeto(scr_bin, 0, 0, 39, 4, 20, 10);

    spaces = ((38 - strlen(text)) / 2) - 1;
    if (spaces < 0)
    {
        spaces = 0;
    }

    locate(22 + spaces, 11);
    printf("%s%s", "\x1B[44m", text);
    value[0] = 0;
    edtval(53, 13, 1, value, validig, MULTIEX);
    printf("%s%s", "\x1B[40m", white);
}
/****************************************************************************
    perform an import
*/
int Import_Area(void)
{
    int     i;
    int     j;
    int     result;
    int     last_room;
    int     last_item;
    int     last_crit;
    long    lsk;
    FILE    *expfile;

    expfile = fopen(export_file, RWBC);
    fread(&export, EXPORT_SIZE, 1, expfile);

    /* Import the rooms ***************************************************/

    for (i = 0; i != export.num_rooms; ++i)
    {
        result = fread(&room, ROOMSIZE, 1, expfile);

        if (result != 1)
        {
            Notify("Import Failure!");
            fclose(expfile);
            BAD_EXIT;
        }

        room.id = i + start_room;
        
        for (j = 0; j != NUM_EXITS; ++j)
        {
            if (room.exit[j])
            {
                room.exit[j] = room.exit[j] + start_room - 1;
            }
        }

        if (room.spec_exit.leads_to)
        {
            room.spec_exit.leads_to += start_room;
            --room.spec_exit.leads_to;
        }

        if (room.enc_chance)
        {
            for (j = 0; j != POSSIBLE_MONS; ++j)
            {
                if (room.monster_here[j])
                {
                    room.monster_here[j] += start_crit;
                    --room.monster_here[j];
                }
            }
        }
        
        if
        (
            room.spec_exit.leads_to &&
            room.spec_exit.filter == ITEM_FILTER
        )
        {
            room.filter_spec += start_item - 1;
        }

        result = Read_Room(room.id, &a_room);

        if (result == 1)
        {
            fp_room = fopen(ROOM_FILE, RWBC);
            lsk = (long) room.id * ROOMSIZE;
            fseek(fp_room, lsk, TOP);
            fwrite(&room, ROOMSIZE, 1, fp_room);
        }
        else
        {
            fp_room = fopen(ROOM_FILE, "a+b");
            fwrite(&room, ROOMSIZE, 1, fp_room);
        }

        fclose(fp_room);
    }
    
    /* Import the monsters ************************************************/

    for (i = 0; i != export.num_crits; ++i)
    {
        result = fread(&crit, CRIT_SIZE, 1, expfile);

        if (result != 1)
        {
            Notify("Import Failure!");
            fclose(expfile);
            BAD_EXIT;
        }
    
        crit.which = i + start_crit;

        for (j = 0; j != POSSIBLE_MON_ITEM; ++j)
        {
            if (crit.Item[j])
            {
                crit.Item[j] += start_item - 1;
            }
        }
        
        if (crit.permanant)
        {
            crit.loc += start_room - 1;
        }

        if (crit.what == HUNTRESS && crit.huntress_item)
        {
            crit.huntress_item += start_item - 1;
        }
    
        result = Read_Critter(crit.which, &a_crit);

        if (result == 1)
        {
            fp_crit = fopen(MONSTER_FILE, RWBC);
            lsk = (long) crit.which * CRIT_SIZE;
            fseek(fp_crit, lsk, TOP);
            fwrite(&crit, CRIT_SIZE, 1, fp_crit);
        }
        else
        {
            fp_crit = fopen(MONSTER_FILE, "a+b");
            fwrite(&crit, CRIT_SIZE, 1, fp_crit);
        }

        fclose(fp_crit);
    }
    
    /* Import the items ****************************************************/

    for (i = 0; i != export.num_items; ++i)
    {
        result = fread(&item, ITEMSIZE, 1, expfile);

        if (result != 1)
        {
            Notify("Import Failure!");
            fclose(expfile);
            BAD_EXIT;
        }

        item.id = i + start_item;

        if (item.what == TRINKET && item.which == PUZZLE)
        {
            item.bonus += start_item - 1;
        }
        else if (item.what == TRANSPORTER)
        {
            item.room += start_room - 1; 
        }

        result = Read_Item(item.id, &an_item);

        if (result == 1)
        {
            fp_item = fopen(ITEM_FILE, RWBC);
            lsk = (long) item.id * ITEMSIZE;
            fseek(fp_item, lsk, TOP);
            fwrite(&item, ITEMSIZE, 1, fp_item);
        }
        else
        {
            fp_item = fopen(ITEM_FILE, "a+b");
            fwrite(&item, ITEMSIZE, 1, fp_item);
        }

        fclose(fp_item);
    }

    fclose(expfile);

    fp_room = fopen(ROOM_FILE, RWBC);
    lsk = (long) ROOMSIZE;
    fseek(fp_room, -lsk, BOTTOM);
    fread(&room, ROOMSIZE, 1, fp_room);
    fclose(fp_room);
    last_room = room.id;

    fp_crit = fopen(MONSTER_FILE, RWBC);
    lsk = (long) CRIT_SIZE;
    fseek(fp_crit, -lsk, BOTTOM);
    fread(&crit, CRIT_SIZE, 1, fp_crit);
    fclose(fp_crit);
    last_crit = crit.which;

    fp_item = fopen(ITEM_FILE, RWBC);
    lsk = (long) ITEMSIZE;
    fseek(fp_item, -lsk, BOTTOM);
    fread(&item, ITEMSIZE, 1, fp_item);
    fclose(fp_item);
    last_item = item.id;

    Notify("Area Imported!");
    sprintf
    (
        str,
        "Rooms:%d Mons:%d Items:%d",
        last_room,
        last_crit,
        last_item
    );
    Notify(str);
    DONE;
}
/****************************************************************************
    perform an export
*/
int Export_Area(void)
{
    int     done;
    int     count;
    int     index;
    int     i;
    int     j;
    int     k;
    int     fp;
    int     result;
    int     found;
    long    lsk;
    FILE    *expfile;
    FILE    *fp_temp;

    /* move the rooms into MUIROOM.TMP ***********************************/

    unlink("MUIROOM.TMP");
    fp = creatnew("MUIROOM.TMP", 0);
    if (fp != -1)
    {
        close(fp);
    }

    fp_temp = fopen("MUIROOM.TMP", "a+b");  
    
    if (fp_temp == NULL)
    {
        catastro("Cannot create MUIROOM.TMP");
    }
    
    fp_room = fopen(ROOM_FILE, RWBC);
    
    if (fp_room == NULL)
    {
        catastro("Cannot locate %s", ROOM_FILE);
    }

    for (i = start_room, index = count = 0; i <= end_room; ++i)
    {
        lsk = (long) i * ROOMSIZE;
        fseek(fp_room, lsk, TOP);
        result = fread(&room, ROOMSIZE, 1, fp_room);

        if (result != 1)
        {
            sprintf(str, "There is no room #%d", i);
            Notify(str);
            fclose(fp_room);
            fclose(fp_temp);
            BAD_EXIT;
        }

        ++index;
        room.id = index;
        
        for (j = 0; j != NUM_EXITS; ++j)
        {
            if (room.exit[j])
            {
                if (room.exit[j] < start_room || room.exit[j] > end_room)
                {
                    room.exit[j] = room.visible[j] = FALSE;
                }
                else
                {
                    room.exit[j] = room.exit[j] - start_room + 1;
                }
            }
        }

        if (room.spec_exit.leads_to)
        {
            if 
            (
                room.spec_exit.leads_to < start_room || 
                room.spec_exit.leads_to > end_room
            )
            {
                room.spec_exit.type = 0; 
                room.spec_exit.leads_to = 0;
            }
            else
            {
                room.spec_exit.leads_to -= start_room;
                ++room.spec_exit.leads_to;
            }
        }

        if (!export_mons)
        {
            room.enc_chance = 0;
            for (j = 0; j != POSSIBLE_MONS; ++j)
            {
                room.monster_here[j] = 0;
            }
        }

        fwrite(&room, ROOMSIZE, 1, fp_temp);

        if (room.enc_chance)
        {
            for (j = 0; j != POSSIBLE_MONS; ++j)
            {
                if (room.monster_here[j])
                {
                    for (k = found = 0; k != count; ++k)
                    {
                        if (buf[k] == room.monster_here[j])
                        {
                            found = TRUE;
                        }
                    }

                    if (!found)
                    {
                        buf[count] = room.monster_here[j];
                        ++count;
                    }
                }
            }
        }
    }

    fclose(fp_room);
    fclose(fp_temp);
    
    /* find any perms in the area ******************************************/

    if (export_mons)
    {
        fp_crit = fopen(MONSTER_FILE, RWBC);
    
        if (fp_crit == NULL)
        {
            catastro("Cannot locate %s", MONSTER_FILE);
        }

        do
        {
            result = fread(&crit, CRIT_SIZE, 1, fp_crit);

            if (crit.permanant)
            {
                if (crit.loc >= start_room && crit.loc <= end_room)
                {
                    buf[count] = crit.which;
                    ++count;
                }
            }
        }    
        while (result == 1);

        fclose(fp_crit);
    }

    /* Move the monsters into MUICRIT.TMP *********************************/

    unlink("MUICRIT.TMP");
    fp = creatnew("MUICRIT.TMP", 0);
    if (fp != -1)
    {
        close(fp);
    }

    fp_temp = fopen("MUICRIT.TMP", "a+b");  
    
    if (fp_temp == NULL)
    {
        catastro("Cannot create MUICRIT.TMP");
    }
    
    fp_crit = fopen(MONSTER_FILE, RWBC);
    
    if (fp_crit == NULL)
    {
        catastro("Cannot locate %s", MONSTER_FILE);
    }

    for (i = 0; i != count; ++i)
    {
        lsk = (long) buf[i] * CRIT_SIZE;
        fseek(fp_crit, lsk, TOP);
        result = fread(&crit, CRIT_SIZE, 1, fp_crit);

        if (result != 1)
        {
            sprintf(str, "There is no monster #%d", buf[i]);
            Notify(str);
            fclose(fp_crit);
            fclose(fp_temp);
            BAD_EXIT;
        }

        crit.which = i + 1;
        
        if (crit.permanant)
        {
            if (crit.loc < start_room || crit.loc > end_room)
            {
                crit.loc = 0;
            }
            else
            {
                crit.loc = crit.loc - start_room + 1;
            }
        }

        if (!export_items)
        {
            crit.huntress_item = 0 ;

            for (j = 0; j != POSSIBLE_MON_ITEM; ++j)
            {
                crit.Item[j] = 0;
            }
        }

        fwrite(&crit, CRIT_SIZE, 1, fp_temp);
    }

    fclose(fp_crit);
    fclose(fp_temp);

    /* Adjust the monster numbers in MUIROOM.TMP ***************************/

    fp_room = fopen("MUIROOM.TMP", RWBC);
    export.num_rooms = end_room - start_room + 1;
    export.num_crits = count;

    for (i = 0; i != export.num_rooms; ++i)
    {
        lsk = (long) i * ROOMSIZE;
        fseek(fp_room, lsk, TOP);
        fread(&room, ROOMSIZE, 1, fp_room);
        
        for (j = 0; j != POSSIBLE_MONS; ++j)
        {
            for (k = done = 0; k != export.num_crits && !done; ++k)
            {
                if (buf[k] == room.monster_here[j])
                {
                    room.monster_here[j] = k + 1;
                    done = TRUE;
                }
            }
        }

        fseek(fp_room, lsk, TOP);
        fwrite(&room, ROOMSIZE, 1, fp_room);
    }
    
    fclose(fp_room);
    
    /* get a list of items from the monsters *******************************/
    
    fp_crit = fopen("MUICRIT.TMP", RWBC);
    fp_item = fopen(ITEM_FILE, RWBC);

    for (i = count = 0; i != export.num_crits; ++i)
    {
        fread(&crit, CRIT_SIZE, 1, fp_crit);
    
        for (j = 0; j != POSSIBLE_MON_ITEM; ++j)
        {
            if (crit.Item[j])
            {
                for (k = found = 0; k != count && !found; ++k)
                {
                    if (buf[k] == crit.Item[j])
                    {
                        found = TRUE;
                    }
                }

                if (!found)
                {
                    buf[count] = crit.Item[j];
                    ++count;
        
                    lsk = (long) crit.Item[j] * ITEMSIZE;
                    fseek(fp_item, lsk, TOP);
                    result = fread(&item, ITEMSIZE, 1, fp_item);
                    
                    if (item.what == TRINKET && item.which == PUZZLE)
                    {
                        for (k = found = 0; k != count && !found; ++k)
                        {
                            if (buf[k] == item.bonus)
                            {
                                found = TRUE;
                            }
                        }

                        if (!found)
                        {
                            buf[count] = item.bonus;
                            ++count;
                        }
                    }
                }
            }
        }
            
        if (crit.what == HUNTRESS && crit.huntress_item)
        {
            for (k = found = 0; k != count && !found; ++k)
            {
                if (buf[k] == crit.huntress_item)
                {
                    found = TRUE;
                }
            }

            if (!found)
            {
                buf[count] = crit.huntress_item;
                ++count;

                lsk = (long) crit.huntress_item * ITEMSIZE;
                fseek(fp_item, lsk, TOP);
                result = fread(&item, ITEMSIZE, 1, fp_item);
                    
                if (item.what == TRINKET && item.which == PUZZLE)
                {
                    for (k = found = 0; k != count && !found; ++k)
                    {
                        if (buf[k] == item.bonus)
                        {
                            found = TRUE;
                        }
                    }

                    if (!found)
                    {
                        buf[count] = item.bonus;
                        ++count;
                    }
                }
            }
        }
    }

    fclose(fp_crit);
    fclose(fp_item);
    
    /* write the items to MUIITEM.TMP *************************************/

    export.num_items = count;

    fp_item = fopen(ITEM_FILE, RWBC);
    
    if (fp_item == NULL)
    {
        catastro("Cannot locate %s", ITEM_FILE);
    }
    
    unlink("MUIITEM.TMP");
    fp = creatnew("MUIITEM.TMP", 0);
    if (fp != -1)
    {
        close(fp);
    }
    
    fp_temp = fopen("MUIITEM.TMP", "a+b");  
    
    if (fp_temp == NULL)
    {
        catastro("Cannot create MUIITEM.TMP");
    }

    for (i = 0; i != export.num_items; ++i)
    {
        lsk = (long) buf[i] * ITEMSIZE;
        fseek(fp_item, lsk, TOP);
        result = fread(&item, ITEMSIZE, 1, fp_item);

        if (result != 1)
        {
            sprintf(str, "There is no item #%d", buf[i]);
            Notify(str);
            fclose(fp_item);
            fclose(fp_temp);
            BAD_EXIT;
        }

        item.id = i + 1;

        if (item.what == TRANSPORTER)
        {
            item.room = item.room - start_room + 1;
        }
        else if (item.what == TRINKET && item.which == PUZZLE)
        {
            for (k = found = 0; k != export.num_items && !found; ++k)
            {
                if (buf[k] == item.bonus)
                {
                    found = TRUE;
                    item.bonus = k + 1;
                }
            }
        }

        fwrite(&item, ITEMSIZE, 1, fp_temp);
    }

    fclose(fp_item);
    fclose(fp_temp);

    /* rewrite the new item indexes to MUICRIT.TMP *************************/
    
    fp_crit = fopen("MUICRIT.TMP", RWBC);

    for (i = 0; i != export.num_crits; ++i)
    {
        lsk = (long) i * CRIT_SIZE;
        fseek(fp_crit, lsk, TOP);
        fread(&crit, CRIT_SIZE, 1, fp_crit);
        
        for (j = 0; j != POSSIBLE_MON_ITEM; ++j)
        {
            for (k = done = 0; k != export.num_items && !done; ++k)
            {
                if (buf[k] == crit.Item[j])
                {
                    crit.Item[j] = k + 1;
                    done = TRUE;
                }
            }
        }

        if (crit.what == HUNTRESS && crit.huntress_item)
        {
            for (k = done = 0; k != export.num_items && !done; ++k)
            {
                if (buf[k] == crit.huntress_item)
                {
                    crit.huntress_item = k + 1;
                    done = TRUE;
                }
            }
        }

        fseek(fp_crit, lsk, TOP);
        fwrite(&crit, CRIT_SIZE, 1, fp_crit);
    }
    
    fclose(fp_crit);
    
    /* Adjust the filter items in MUIROOM.TMP ***************************/

    fp_room = fopen("MUIROOM.TMP", RWBC);

    for (i = 0; i != export.num_rooms; ++i)
    {
        lsk = (long) i * ROOMSIZE;
        fseek(fp_room, lsk, TOP);
        fread(&room, ROOMSIZE, 1, fp_room);
            
        if 
        (
            room.spec_exit.leads_to &&
            room.spec_exit.filter == ITEM_FILTER
        )
        {
            for (k = done = 0; k != export.num_items && !done; ++k)
            {
                if (buf[k] == room.filter_spec)
                {
                    room.filter_spec = k + 1;
                    done = TRUE;
                }
            }

            if (!done)
            {
                room.spec_exit.filter = 0;
                room.filter_spec = 0;
            }
        
            fseek(fp_room, lsk, TOP);
            fwrite(&room, ROOMSIZE, 1, fp_room);
        }
    }
    
    fclose(fp_room);
    
    /* write the export file ***********************************************/

    unlink(export_file);
    fp = creatnew(export_file, 0);
    if (fp != -1)
    {
        close(fp);
    }

    expfile = fopen(export_file, "a+b");
    
    if (expfile == NULL)
    {
        sprintf(str, "Cannot open %s", export_file);
        Notify(str);
        BAD_EXIT;
    }
    
    for (i = 0; i != strlen(export.act_code); ++i)
    {
        export.act_code[i] -= 32;
    }

    strcpy(export.data3, DATA3);

    fwrite(&export, EXPORT_SIZE, 1, expfile);

    fp_temp = fopen("MUIROOM.TMP", RWBC);
    for (i = 0; i != export.num_rooms; ++i)
    {
        fread(&room, ROOMSIZE, 1, fp_temp);
        fwrite(&room, ROOMSIZE, 1, expfile);
    }
    fclose(fp_temp);
    
    fp_temp = fopen("MUICRIT.TMP", RWBC);
    for (i = 0; i != export.num_crits; ++i)
    {
        fread(&crit, CRIT_SIZE, 1, fp_temp);
        fwrite(&crit, CRIT_SIZE, 1, expfile);
    }
    fclose(fp_temp);
    
    fp_temp = fopen("MUIITEM.TMP", RWBC);
    for (i = 0; i != export.num_items; ++i)
    {
        fread(&item, ITEMSIZE, 1, fp_temp);
        fwrite(&item, ITEMSIZE, 1, expfile);
    }
    fclose(fp_temp);

    unlink("MUIITEM.TMP");
    unlink("MUIROOM.TMP");
    unlink("MUICRIT.TMP");

    fclose(expfile);

    Notify("Export File Created");
    DONE;
}
/****************************************************************************
    export an area
*/
int Do_Export(void)
{
    int     i;
    int     do_it = FALSE;
    int     export_ready = FALSE;
    int     result;
    int     done = FALSE;
    
    start_room = 0;
    end_room = 0;
    export_mons = TRUE;
    export_items = TRUE;
    strcpy(export_file, "MUICHAOS.EXP"); 
    memset( (char *) &export, 0, EXPORT_SIZE);
    field = START_ROOM;
    iniscn("MUICHAOS.ED5", scr_bin);
    explode(scr_bin, 0, 0, 79, 24);

    do
    {
        locate(23, 2);
        sprintf(str, "%d", start_room);
        Pad_Str(str, 5);
        printf("%s", str);
        
        locate(23, 3);
        sprintf(str, "%d", end_room);
        Pad_Str(str, 5);
        printf("%s", str);

        locate(23, 4);
        strcpy(str, export.act_code);
        Pad_Str(str, ACT_CODE_SIZE - 1);
        printf("%s", str);
        
        locate(23, 5);
        if (export_mons)
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }

        locate(23, 6);
        if (export_items)
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }

        locate(23, 7);
        strcpy(str, export_file);
        Pad_Str(str, 12);
        printf("%s", str);
        
        for (i = 0; i != MAX_EXPORT_DESC; ++i)
        {
            locate(0, 10 + i);
            printf("%s%s", export.desc[i], CLEAR_RIGHT);
        }

        locate(23, 24);
        if (export_ready)
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }

        if (field == START_ROOM)
        {
            sprintf(value, "%d", start_room);
            result = edtval(23, 2, 6, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = END_ROOM;
            }
            else if (edtvalc == BAKTAB)
            {
                field = EXPORT_READY;
            }

            if (result == 0)
            {
                done = TRUE;
            }
            else
            {
                start_room = atoi(value);    
            }
        }
        else if (field == END_ROOM)
        {
            sprintf(value, "%d", end_room);
            result = edtval(23, 3, 6, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = EXPORT_CODE;
            }
            else if (edtvalc == BAKTAB)
            {
                field = START_ROOM;
            }

            if (result == 0)
            {
                field = START_ROOM;
            }
            else
            {
                end_room = atoi(value);    
            }
        }
        else if (field == EXPORT_CODE)
        {
            strcpy(value, export.act_code);
            result = edtval
            (
                23, 4, 
                ACT_CODE_SIZE, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = EXPORT_MONS;
            }
            else if (edtvalc == BAKTAB)
            {
                field = END_ROOM;
            }

            if (result == 0)
            {
                field = START_ROOM;
            }
            else
            {
                strcpy(export.act_code, value);

                for (i = 0; i != strlen(export.act_code); ++i)
                {
                    if 
                    (
                        export.act_code[i] >= 'a' && 
                        export.act_code[i] <= 'z'
                    )
                    {
                        export.act_code[i] -= 32;
                    }
                }
            }
        }

        else if (field == EXPORT_MONS)
        {
            if (export_mons)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(23, 5, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = EXPORT_ITEMS;
            }
            else if (edtvalc == BAKTAB)
            {
                field = EXPORT_CODE;
            }

            if (result == 0)
            {
                field = START_ROOM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    export_mons = TRUE;
                }
                else
                {
                    export_mons = FALSE;
                }
            }
        }
        else if (field == EXPORT_ITEMS)
        {
            if (export_items)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(23, 6, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = EXPORT_FILE;
            }
            else if (edtvalc == BAKTAB)
            {
                field = EXPORT_MONS;
            }

            if (result == 0)
            {
                field = START_ROOM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    export_items = TRUE;
                }
                else
                {
                    export_items = FALSE;
                }
            }
        }
        else if (field == EXPORT_FILE)
        {
            strcpy(value, export_file);
            result = edtval(23, 7, 13, value, Validate_String, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = EXPORT_DESC0;
            }
            else if (edtvalc == BAKTAB)
            {
                field = EXPORT_ITEMS;
            }

            if (result == 0)
            {
                field = START_ROOM;
            }
            else
            {
                strcpy(export_file, value);
            }
        }
        else if (field >= EXPORT_DESC0 && field <= EXPORT_DESC12)
        {
            strcpy(value, export.desc[field - EXPORT_DESC0]);
            result = edtval
            (
                0, 
                10 + field - EXPORT_DESC0, 
                LINE_SIZE, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (result == 0)
            {
                field = START_ROOM;
            }
            else
            {
                strcpy(export.desc[field - EXPORT_DESC0], value);

                if (edtvalc == TAB || edtvalc == CR)
                {
                    ++field;
                }
                else if (edtvalc == BAKTAB)
                {
                    --field;
                }
            }
        }
        else if (field == EXPORT_READY)
        {
            if (export_ready)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(23, 24, 4, value, validyn, MULTIEX);

            if (result == 0)
            {
                field = START_ROOM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    export_ready = TRUE;
                }
                else
                {
                    export_ready = FALSE;
                }

                if (edtvalc == TAB)
                {
                    field = START_ROOM;
                }
                else if (edtvalc == BAKTAB)
                {
                    field = EXPORT_DESC12;
                }
                else if (edtvalc == CR)
                {
                    if (export_ready)
                    {
                        if (start_room == 0)
                        {
                            Notify("Can't start with room 0");
                        }
                        else if (end_room == 0)
                        {
                            Notify("Can't end with room 0");
                        }
                        else if (end_room < start_room)
                        {
                            Notify("Last room is less than first room");
                        }
                        else
                        {
                            done = TRUE;
                            do_it = TRUE;
                        }

                        if (!do_it)
                        {
                            iniscn("MUICHAOS.ED5", scr_bin);
                            explode(scr_bin, 0, 0, 79, 24);
                        }
                    }
                    else
                    {
                        field = START_ROOM;
                    }
                }
            }
        }
    }
    while (!done);

    if (do_it)
    {
        Export_Area();
    }

    DONE;
}
/****************************************************************************
    import an area
*/
int Import(void)
{
    int     i;
    int     do_it = FALSE;
    int     import_ready = FALSE;
    int     result;
    int     done = FALSE;
    long    lsk;
    char    act_code[ACT_CODE_SIZE];
    FILE    *expfile;

    act_code[0] = 0;
    fp_room = fopen(ROOM_FILE, RWBC);
    lsk = (long) ROOMSIZE;
    fseek(fp_room, -lsk, BOTTOM);
    fread(&room, ROOMSIZE, 1, fp_room);
    fclose(fp_room);
    start_room = room.id + 1;

    fp_crit = fopen(MONSTER_FILE, RWBC);
    lsk = (long) CRIT_SIZE;
    fseek(fp_crit, -lsk, BOTTOM);
    fread(&crit, CRIT_SIZE, 1, fp_crit);
    fclose(fp_crit);
    start_crit = crit.which + 1;

    fp_item = fopen(ITEM_FILE, RWBC);
    lsk = (long) ITEMSIZE;
    fseek(fp_item, -lsk, BOTTOM);
    fread(&item, ITEMSIZE, 1, fp_item);
    fclose(fp_item);
    start_item = item.id + 1;

    strcpy(export_file, "MUICHAOS.EXP"); 
    memset( (char *) &export, 0, EXPORT_SIZE);
    field = IMPORT_FILE;
    iniscn("MUICHAOS.ED7", scr_bin);
    explode(scr_bin, 0, 0, 79, 24);

    do
    {
        locate(25, 0);
        strcpy(str, export_file);
        Pad_Str(str, 12);
        printf("%s", str);
        
        locate(11, 2);
        sprintf(str, "%d", export.num_rooms);
        Pad_Str(str, 5);
        printf("%s", str);
        
        locate(11, 3);
        sprintf(str, "%d", export.num_items);
        Pad_Str(str, 5);
        printf("%s", str);
        
        locate(11, 4);
        sprintf(str, "%d", export.num_crits);
        Pad_Str(str, 5);
        printf("%s", str);
        
        for (i = 0; i != MAX_EXPORT_DESC; ++i)
        {
            locate(0, 6 + i);
            printf("%s%s", export.desc[i], CLEAR_RIGHT);
        }
        
        locate(36, 20);
        sprintf(str, "%d", start_room);
        Pad_Str(str, 5);
        printf("%s", str);
        
        locate(36, 21);
        sprintf(str, "%d", start_item);
        Pad_Str(str, 5);
        printf("%s", str);
        
        locate(36, 22);
        sprintf(str, "%d", start_crit);
        Pad_Str(str, 5);
        printf("%s", str);
        
        locate(36, 23);
        strcpy(str, act_code);
        Pad_Str(str, ACT_CODE_SIZE - 1);
        printf("%s", str);
        
        locate(18, 24);
        if (import_ready)
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }

        if (field == IMPORT_FILE)
        {
            strcpy(value, export_file);
            result = edtval(25, 0, 13, value, Validate_String, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = IMPORT_ROOMS;
            }
            else if (edtvalc == BAKTAB)
            {
                field = IMPORT_READY;
            }

            if (result == 0)
            {
                done = TRUE;
            }
            else
            {
                strcpy(export_file, value);
                expfile = fopen(export_file, RWBC);
    
                if (expfile != NULL)
                {
                    fread(&export, EXPORT_SIZE, 1, expfile);

                    for (i = 0; i != strlen(export.act_code); ++i)
                    {
                        export.act_code[i] += 32;
                    }

                    fclose(expfile);
                }
            }
        }
        else if (field == IMPORT_ROOMS)
        {
            sprintf(value, "%d", start_room);
            result = edtval(36, 20, 6, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = IMPORT_ITEMS;
            }
            else if (edtvalc == BAKTAB)
            {
                field = IMPORT_FILE;
            }

            if (result == 0)
            {
                field = IMPORT_FILE;
            }
            else
            {
                start_room = atoi(value);    
            }
        }
        else if (field == IMPORT_ITEMS)
        {
            sprintf(value, "%d", start_item);
            result = edtval(36, 21, 6, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = IMPORT_CRITS;
            }
            else if (edtvalc == BAKTAB)
            {
                field = IMPORT_ROOMS;
            }

            if (result == 0)
            {
                field = IMPORT_FILE;
            }
            else
            {
                start_item = atoi(value);    
            }
        }
        else if (field == IMPORT_CRITS)
        {
            sprintf(value, "%d", start_crit);
            result = edtval(36, 22, 6, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                if (export.act_code[0])
                {
                    field = IMPORT_CODE;
                }
                else
                {
                    field = IMPORT_READY;
                }
            }
            else if (edtvalc == BAKTAB)
            {
                field = IMPORT_ITEMS;
            }

            if (result == 0)
            {
                field = IMPORT_FILE;
            }
            else
            {
                start_crit = atoi(value);    
            }
        }
        else if (field == IMPORT_CODE)
        {
            strcpy(value, act_code);
            result = edtval
            (
                36, 23, 
                ACT_CODE_SIZE, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = IMPORT_READY;
            }
            else if (edtvalc == BAKTAB)
            {
                field = IMPORT_CRITS;
            }

            if (result == 0)
            {
                field = IMPORT_FILE;
            }
            else
            {
                strcpy(act_code, value);

                for (i = 0; i != strlen(act_code); ++i)
                {
                    if (act_code[i] >= 'a' && act_code[i] <= 'z')
                    {
                        act_code[i] -= 32;
                    }
                }
            }
        }
        else if (field == IMPORT_READY)
        {
            if (import_ready)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(18, 24, 4, value, validyn, MULTIEX);

            if (result == 0)
            {
                field = IMPORT_FILE;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    import_ready = TRUE;
                }
                else
                {
                    import_ready = FALSE;
                }

                if (edtvalc == TAB)
                {
                    field = IMPORT_FILE;
                }
                else if (edtvalc == BAKTAB)
                {
                    if (export.act_code[0])
                    {
                        field = IMPORT_CODE;
                    }
                    else
                    {
                        field = IMPORT_CRITS;
                    }
                }
                else if (edtvalc == CR)
                {
                    if (import_ready)
                    {
                        if (export.act_code[0] && act_code[0] == 0)
                        {
                            Notify("This file requires an activation code");
                        }
                        else if 
                        (
                            export.act_code[0] && 
                            !sameas(export.act_code, act_code)
                        )
                        {
                            Notify("Incorrect activation code!");
                        }
                        else if (!sameas(export.data3, DATA3))
                        {
                            Notify("Not a Version 3 file!");
                        }
                        else if (start_room == 0)
                        {
                            Notify("Can't start with room 0");
                        }
                        else if (start_item == 0)
                        {
                            Notify("Can't start with item 0");
                        }
                        else if (start_crit == 0)
                        {
                            Notify("Can't start with monster 0");
                        }
                        else if (export.num_rooms == 0)
                        {
                            Notify("No rooms to import");
                        }
                        else if (Read_Room(start_room - 1, &room) != 1)
                        {
                            sprintf(str, "Room #%d doesn't exist", start_room);
                            Notify(str);
                        }
                        else if (Read_Item(start_item - 1, &item) != 1)
                        {
                            sprintf(str, "Item #%d doesn't exist", start_item);
                            Notify(str);
                        }
                        else if (Read_Critter(start_crit - 1, &crit) != 1)
                        {
                            sprintf(str, "Monster #%d doesn't exist", start_crit);
                            Notify(str);
                        }
                        else
                        {
                            done = TRUE;
                            do_it = TRUE;
                        }

                        if (!do_it)
                        {
                            iniscn("MUICHAOS.ED7", scr_bin);
                            explode(scr_bin, 0, 0, 79, 24);
                        }
                    }
                    else
                    {
                        field = IMPORT_FILE;
                    }
                }
            }
        }
    }
    while (!done);

    if (do_it)
    {
        Import_Area();
    }

    DONE;
}
/****************************************************************************
    display a room type
*/
void Display_Room_Type(rmtype)
int  rmtype;
{

    locate(6, 1);
    sprintf(str, "%d", rmtype);
    Pad_Str(str, 2);
    printf("%s", str);

    locate(9, 1);

    if (rmtype < 0 && rmtype > -NUM_SAVED_PLACES)
    {
        sprintf(str, "Guild #%d", abs(rmtype));
    }
    else if (rmtype >= 0 && rmtype <= SOLO_ROOM)
    {
        strcpy(str, room_types[rmtype]);
    }
    else
    {
        strcpy(str, "Unknown room type");
    }

    Pad_Str(str, 31);
    printf("%s", str);
}
/****************************************************************************
    display the trap type
*/
void Display_Trap(trap)
int  trap;
{
    
    locate(6, 3);
    printf("%d%s ", trap, CLEAR_RIGHT);

    if (trap == 0)
    {
        printf("None");
    }
    else if (trap == 1)
    {
        printf("Poison dart");
    }
    else if (trap == 2)
    {
        printf("Bomb");
    }
    else if (trap == 3)
    {
        printf("Teleport");
    }
    else if (trap == 4)
    {
        printf("Langour");
    }
    else if (trap == 5)
    {
        printf("Sleep");
    }
    else if (trap == 6)
    {
        printf("Aggrivation");
    }
    else if (trap == 7)
    {
        printf("Weakness");
    }
    else if (trap == 8)
    {
        printf("Dispel Magic");
    }
    else
    {
        printf("Unknown trap type");
    }
}
/****************************************************************************
    display door type
*/
void Display_Door(d)
int  d;
{

    locate(19, 15);
    printf("%d", d);
    
    if (d == 1)
    {
        strcpy(str, "Non-Door");
    }
    else if (d == 2) 
    {
        strcpy(str, "Regular");
    }
    else if (d == 3)
    {
        strcpy(str, "Magic");
    }
    else if (d == 4)
    {
        strcpy(str, "Special");
    }
    else if (d == 5)
    {
        strcpy(str, "Chant");
    }
    else
    {
        strcpy(str, "Unknown");
    }
        
    Pad_Str(str, 8);
    locate(21, 15);
    printf("%s", str);
}
/****************************************************************************
    display special exit filter
*/
void Display_Filter(f)
int  f;
{

    locate(39, 15);
    sprintf(str, "%d", f);
    Pad_Str(str, 2);
    printf(str);

    if (f == 0)
    {
        strcpy(str, "None");
    }
    else if (f < NUM_SAVED_PLACES)
    {
        sprintf(str, "Guild #%d", f);
    }
    else if (f == UNUSED_FILTER)
    {
        strcpy(str, "Unused");
    }
    else if (f == ITEM_FILTER)
    {
        strcpy(str, "Item");
    }
    else if (f == CLASS_FILTER)
    {
        strcpy(str, "Class");
    }
    else if (f == RACE_FILTER)
    {
        strcpy(str, "Race");
    }
    else if (f == OFFICER_FILTER)
    {
        strcpy(str, "Officer");
    }
    else if (f == GUV_FILTER)
    {
        strcpy(str, "Governor");
    }
    else if (f == ASSASSIN_FILTER)
    {
        strcpy(str, "Assassin");
    }
    else if (f == PALADIN_FILTER)
    {
        strcpy(str, "Paladin");
    }
    else if (f == JUDGE_FILTER)
    {
        strcpy(str, "Judge");
    }
    else if (f == LEVEL_FILTER)
    {
        strcpy(str, "Level");
    }
    else
    {
        strcpy(str, "Unknown");
    }
        
    Pad_Str(str, 8);
    locate(42, 15);
    printf("%s", str);
}
/****************************************************************************
    display an item's spell
*/
void Display_Item_Spell(s)
int  s;
{

    locate(11, 9);
    sprintf(str, "%d", s);
    Pad_Str(str, 2);
    printf("%s", str);

    locate(14, 9);

    if (s >= 0 && s < NUM_SPELLS)
    {
        strcpy(str, spell_info[s].name);
    }
    else
    {
        strcpy(str, "Unknown");
    }

    Pad_Str(str, 15);
    printf("%s", str);
}
/****************************************************************************
    display an item's sub-type
*/
void Display_Item_Subtype(t)
int  t;
{

    locate(11, 7);
    sprintf(str, "%d", t);
    Pad_Str(str, 2);
    printf("%s", str);

    locate(14, 7);

    if (t == 0)
    {
        strcpy(str, "No Special Subtype");
    }
    else if (t == TWOHAND)
    {
        strcpy(str, "Two-Handed Weapon");
    }
    else if (t == LITE_ARMOR)
    {
        strcpy(str, "Non-Metallic Armor");
    }
    else if (t == LITE_WEP)
    {
        strcpy(str, "Light Weapon");
    }
    else if (t == SKELETON_KEY)
    {
        strcpy(str, "Skeleton Key");
    }
    else if (t == SCROLL)
    {
        strcpy(str, "Scroll");
    }
    else if (t == NODROP)
    {
        strcpy(str, "Undroppable Shield");
    }
    else if (t == LITE_SHIELD)
    {
        strcpy(str, "Light Shield");
    }
    else if (t == MAGIC_RING)
    {
        strcpy(str, "Magic Ring");
    }
    else if (t == MAGIC_CONT)
    {
        strcpy(str, "Weightless Container");
    }
    else if (t == SPECIAL_KEY)
    {
        strcpy(str, "Special Key");
    }
    else if (t == PUZZLE)
    {
        strcpy(str, "Puzzle Piece");
    }
    else
    {
        strcpy(str, "Unknown");
    }

    Pad_Str(str, 20);
    printf("%s", str);
}
/****************************************************************************
    display a monster's type
*/
void Display_Crit_Type(t)
int  t;
{

    locate(13, 5);
    printf("%d", t);

    locate(15, 5);

    if (t == NPC)
    {
        strcpy(str, "Human");
    }
    else if (t == MONSTER)
    {
        strcpy(str, "Monster");
    }
    else if (t == ANIMAL)
    {
        strcpy(str, "Animal");
    }
    else if (t == WEIRD)
    {
        strcpy(str, "Weird Monster");
    }
    else if (t == HUMANOID)
    {
        strcpy(str, "Humanoid");
    }
    else if (t == ORACLE)
    {
        strcpy(str, "Oracle");
    }
    else if (t == HUNTRESS)
    {
        strcpy(str, "Huntress");
    }
    else if (t == AWESOME)
    {
        strcpy(str, "Awesome");
    }
    else if (t == LONER)
    {
        strcpy(str, "Loner");
    }
    else
    {
        strcpy(str, "Unknown");
    }

    Pad_Str(str, 13);
    printf("%s", str);
}
/****************************************************************************
    display a monster's attack vector
*/
void Display_Attack_Vector(v)
int  v;
{

    locate(18, 17);
    printf("%d", v);

    locate(20, 17);

    if (v == 0)
    {
        strcpy(str, "None");
    }
    else if (v == POISONER)
    {
        strcpy(str, "Poisoner");
    }
    else if (v == STEALER)
    {
        strcpy(str, "Stealer");
    }
    else if (v == DRAINER)
    {
        strcpy(str, "Drainer");
    }
    else if (v == PEST)
    {
        strcpy(str, "Pest");
    }
    else
    {
        strcpy(str, "Unknown");
    }

    Pad_Str(str, 8);
    printf("%s", str);
}
/****************************************************************************
    display a monster's attacked vector
*/
void Display_Attacked_Vector(v)
int  v;
{

    locate(18, 16);
    printf("%d", v);

    locate(20, 16);

    if (v == 0)
    {
        strcpy(str, "None");
    }
    else if (v == JAILED)
    {
        strcpy(str, "Attacker jailed");
    }
    else if (v == ADD_EVIL)
    {
        strcpy(str, "Give evil points");
    }
    else if (v == MORPH)
    {
        strcpy(str, "Morph Level");
    }
    else if (v == AUTO_FLEE)
    {
        strcpy(str, "Always Flees");
    }
    else
    {
        strcpy(str, "Unknown");
    }

    Pad_Str(str, 21);
    printf("%s", str);
}
/****************************************************************************
    display an item's type
*/
void Display_Item_Type(t)
int  t;
{

    locate(11, 6);
    sprintf(str, "%d", t);
    Pad_Str(str, 2);
    printf("%s", str);

    locate(14, 6);

    if (t == EDGED)
    {
        strcpy(str, "Edged Weapon");
    }
    else if (t == BLUNT)
    {
        strcpy(str, "Blunt Weapon");
    }
    else if (t == MAGIC_DEV)
    {
        strcpy(str, "Magic Device");
    }
    else if (t == ARMOR)
    {
        strcpy(str, "Armor");
    }
    else if (t == SHIELD)
    {
        strcpy(str, "Shield");
    }
    else if (t == POLE)
    {
        strcpy(str, "Pole Weapon");
    }
    else if (t == CASH)
    {
        strcpy(str, "Cash");
    }
    else if (t == JOOLS)
    {
        strcpy(str, "Jewels");
    }
    else if (t == TRINKET)
    {
        strcpy(str, "Trinket");
    }
    else if (t == NOHAND)
    {
        strcpy(str, "Unarmed Combat Aid");
    }
    else if (t == CONTAINER)
    {
        strcpy(str, "Storage Container");
    }
    else if (t == TALISMAN)
    {
        strcpy(str, "Talisman");
    }
    else if (t == TRANSPORTER)
    {
        strcpy(str, "Transporter");
    }
    else if (t == AMULET)
    {
        strcpy(str, "Amulet");
    }
    else if (t == PSY_FOCUS)
    {
        strcpy(str, "Psychic Focus");
    }
    else
    {
        strcpy(str, "Unknown");
    }

    Pad_Str(str, 18);
    printf("%s", str);
}
/****************************************************************************
    display the fields for a monster
*/
int Display_Monster(void)
{
    int     i;
    int     result;                

    result = Read_Critter(crit_num, &crit);
                    
    if (result != 1)
    {
        crit_num = 0;
        BAD_EXIT;
    }
    
    locate(16, 0);
    sprintf(str, "%d", crit_num);
    Pad_Str(str, 5);
    printf("%s", str);

    locate(14, 1);
    printf("%s%s", crit.article, CLEAR_RIGHT);

    locate(14, 2);
    printf("%s%s", crit.name, CLEAR_RIGHT);

    locate(14, 3);
    printf("%s%s", crit.plural_name, CLEAR_RIGHT);

    Display_Crit_Type(crit.what);
    
    locate(13, 6);
    sprintf(str, "%d", crit.Level);
    Pad_Str(str, 5);
    printf("%s", str);

    locate(13, 7);
    if (crit.alg)
    {
        printf("Yes");
    }
    else
    {
        printf("No ");
    }

    locate(13, 8);
    if (crit.spell_caster)
    {
        printf("Yes");
    }
    else
    {
        printf("No ");
    }

    locate(13, 9);
    if (crit.magical)
    {
        printf("Yes");
    }
    else
    {
        printf("No ");
    }

    locate(13, 10);
    if (crit.blocks)
    {
        printf("Yes");
    }
    else
    {
        printf("No ");
    }

    locate(13, 11);
    if (crit.magic_immune)
    {
        printf("Yes");
    }
    else
    {
        printf("No ");
    }

    locate(13, 12);
    if (crit.permanant)
    {
        printf("Yes");
    }
    else
    {
        printf("No ");
    }
            
    locate(13, 13); 
    if (crit.permanant)
    {
        if (crit.roving)
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }
    }
    else
    {
        printf("   ");
    }

    locate(13, 14);
    sprintf(str, "%d", crit.loc);
    Pad_Str(str, 5);

    if (crit.permanant)
    {
        printf("%s", str);
    }
    else
    {
        printf("     ");
    }

    Display_Attacked_Vector(crit.attacked_vector);
    Display_Attack_Vector(crit.hit_vector);

    locate(74, 16); 
    if (crit.attacked_vector == MORPH)
    {
        sprintf(str, "%d", crit.morph);
        Pad_Str(str, 3);
        printf("%s", str);
    }
    else
    {
        printf("   ");
    }

    locate(74, 17); 
    if (crit.attacked_vector == ADD_EVIL)
    {
        sprintf(str, "%d", crit.evil_pts);
        Pad_Str(str, 3);
        printf("%s", str);
    }
    else
    {
        printf("   ");
    }

    locate(6, 18);
    printf("%s%s", crit.talk, CLEAR_RIGHT);
    
    locate(9, 19);
    sprintf(str, "%d", crit.quests);
    Pad_Str(str, 3);

    if (crit.what == HUNTRESS)
    {
        printf("%s", str);
    }
    else
    {
        printf("   ");
    }
    
    locate(21, 19);

    if (crit.what == HUNTRESS && crit.huntress_item)
    {
        sprintf(str, "%d", crit.huntress_item);
        Pad_Str(str, 5);
        printf("%s", str);

        result = Read_Item(crit.huntress_item, &item);
        locate(28, 19);
        
        if (result == 1)
        {
            str[0] = 0;
            if (item.article[0])
            {
                strcat(str, item.article);
                strcat(str, " ");
            }

            if (item.adjective[0])
            {
                strcat(str, item.adjective);
                strcat(str, " ");
            }
                
            strcat(str, item.name);
        }
        else
        {
            strcpy(str, "(no such item)");
        }
 
        printf("%s", str);
    }

    printf("%s", CLEAR_RIGHT);

    for (i = 0; i != POSSIBLE_MON_ITEM; ++i)
    {
        locate(9, 20 + i);
    
        if (crit.Item[i])
        {
            sprintf(str, "%d", crit.Item[i]);
            Pad_Str(str, 5);
            printf("%s", str);

            result = Read_Item(crit.Item[i], &item);
            locate(16, 20 + i);
        
            if (result == 1)
            {
                str[0] = 0;
                if (item.article[0])
                {
                    strcat(str, item.article);
                    strcat(str, " ");
                }

                if (item.adjective[0])
                {
                    strcat(str, item.adjective);
                    strcat(str, " ");
                }
                
                strcat(str, item.name);
            }
            else
            {
                strcpy(str, "(no such item)");
            }
 
            printf("%s%s", str, CLEAR_RIGHT);
        }

        printf("%s", CLEAR_RIGHT);
    }

    DONE;
}
/****************************************************************************
    display the fields for an item
*/
int Display_Item(void)
{
    int     result;                

    result = Read_Item(item_num, &item);
                    
    if (result != 1)
    {
        item_num = 0;
        BAD_EXIT;
    }
    
    locate(13, 0);
    sprintf(str, "%d", item_num);
    Pad_Str(str, 5);
    printf("%s", str);

    locate(11, 2);
    printf("%s%s", item.article, CLEAR_RIGHT);

    locate(11, 3);
    printf("%s%s", item.adjective, CLEAR_RIGHT);

    locate(11, 4);
    printf("%s%s", item.name, CLEAR_RIGHT);

    locate(11, 5);
    if (item.permanant)
    {
        printf("Yes");
    }
    else
    {
        printf("No ");
    }

    Display_Item_Type(item.what);
    Display_Item_Subtype(item.which);

    locate(11, 8);
    sprintf(str, "%d", item.item_level);
    Pad_Str(str, 5);
    printf("%s", str);

    locate(32, 8);

    if (ARSH(item) || WEAPON(item))
    {
        if (item.ring_used)
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }
    }
    else
    {
        printf("   ");
    }

    if (item.what == MAGIC_DEV)
    {
        Display_Item_Spell(item.spell_cast);
    }
    else if (item.ring_used && (ARSH(item) || WEAPON(item)))
    {
        Display_Item_Spell(item.spell_cast);
    }
    else
    {
        locate(11, 9);
        printf("%s", CLEAR_RIGHT);
    }

    locate(39, 10);
    if (item.what == TRINKET && item.which == PUZZLE)
    {
        sprintf(str, "%d", item.holding);
        Pad_Str(str, 5);
        printf("%s", str);
    }
    else
    {
        printf("     ");
    }

    locate(11, 11);
    if (item.what == MAGIC_DEV && item.which == SPECIAL_KEY)
    {
        sprintf(str, "%d", item.holding);
        Pad_Str(str, 5);
        printf("%s", str);
    }
    else
    {
        printf("     ");
    }

    locate(39, 11);
    if (item.what == TRINKET && item.which == PUZZLE)
    {
        sprintf(str, "%d", item.ac);
        Pad_Str(str, 5);
        printf("%s", str);
    }
    else
    {
        printf("     ");
    }

    locate(11, 12);
    if (item.what == TRANSPORTER || item.permanant)
    {
        sprintf(str, "%d", item.room);
        Pad_Str(str, 5);
        printf("%s", str);
    }
    else
    {
        printf("     ");
    }

    locate(39, 12);
    if (item.what == TRINKET && item.which == PUZZLE)
    {
        sprintf(str, "%d", item.bonus);
        Pad_Str(str, 5);
        printf("%s", str);

        result = Read_Item(item.bonus, &an_item);
        locate(45, 12);
        
        if (result == 1)
        {
            str[0] = 0;
            if (an_item.article[0])
            {
                strcat(str, an_item.article);
                strcat(str, " ");
            }
            
            if (an_item.adjective[0])
            {
                strcat(str, an_item.adjective);
                strcat(str, " ");
            }
                
            strcat(str, an_item.name);
        }
        else
        {
            strcpy(str, "(no such item)");
        }
 
        printf("%s%s", str, CLEAR_RIGHT);
    }
    else
    {
        printf("%s", CLEAR_RIGHT);
    }

    DONE;
}
/****************************************************************************
    display the fields for a room
*/
int Display_Room(void)
{
    int     result;                
    int     i;

    result = Read_Room(room_num, &room);
                    
    if (result != 1)
    {
        room_num = 0;
        BAD_EXIT;
    }

    locate(13, 0);
    sprintf(str, "%d", room_num);
    Pad_Str(str, 5);
    printf("%s", str);

    Display_Room_Type(room.rmtype);

    locate(6, 2);
    if (room.town)
    {
        printf("Yes");
    }
    else
    {
        printf("No ");
    }

    locate(20, 2);
    if (room.invaders == 'Y')
    {
        printf("Yes");
    }
    else
    {
        printf("No ");
    }

    locate(37, 2);
    if (room.no_teleport == TRUE)
    {
        printf("No ");
    }
    else
    {
        printf("Yes");
    }
   
    Display_Trap(room.trap);

    locate(9, 4);
    printf("%d", room.cover);
    printf(CLEAR_RIGHT);

    for (i = 0; i != DESC_LINES; ++i)
    {
        locate(0, 5 + i);
        printf("%s%s", room.desc[i], CLEAR_RIGHT);
    }

    if (room.exit[0])
    {
        sprintf(str, "%d", room.exit[0]);
        Pad_Str(str, 5);
        locate(7, 11);
        printf("%s", str);
        locate(22, 11);
    
        if (room.visible[0])
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }   
    }
    else
    {
        locate(7, 11);
        printf("     ");
        locate(22, 11);
        printf("   ");
    }
    
    if (room.exit[1])
    {
        sprintf(str, "%d", room.exit[1]);
        Pad_Str(str, 5);
        locate(33, 11);
        printf("%s", str);
        locate(48, 11);
    
        if (room.visible[1])
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }   
    }
    else
    {
        locate(33, 11);
        printf("     ");
        locate(48, 11);
        printf("   ");
    }
    
    if (room.exit[2])
    {
        sprintf(str, "%d", room.exit[2]);
        Pad_Str(str, 5);
        locate(58, 11);
        printf("%s", str);
        locate(73, 11);
    
        if (room.visible[2])
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }   
    }
    else
    {
        locate(58, 11);
        printf("     ");
        locate(73, 11);
        printf("   ");
    }
    
    if (room.exit[3])
    {
        sprintf(str, "%d", room.exit[3]);
        Pad_Str(str, 5);
        locate(7, 12);
        printf("%s", str);
        locate(22, 12);
    
        if (room.visible[3])
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }   
    }
    else
    {
        locate(7, 12);
        printf("     ");
        locate(22, 12);
        printf("   ");
    }
    
    if (room.exit[4])
    {
        sprintf(str, "%d", room.exit[4]);
        Pad_Str(str, 5);
        locate(33, 12);
        printf("%s", str);
        locate(48, 12);
    
        if (room.visible[4])
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }   
    }
    else
    {
        locate(33, 12);
        printf("     ");
        locate(48, 12);
        printf("   ");
    }
    
    if (room.exit[5])
    {
        sprintf(str, "%d", room.exit[5]);
        Pad_Str(str, 5);
        locate(58, 12);
        printf("%s", str);
        locate(73, 12);
    
        if (room.visible[5])
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }   
    }
    else
    {
        locate(58, 12);
        printf("     ");
        locate(73, 12);
        printf("   ");
    }
    
    if (room.exit[6])
    {
        sprintf(str, "%d", room.exit[6]);
        Pad_Str(str, 5);
        locate(7, 13);
        printf("%s", str);
        locate(22, 13);
    
        if (room.visible[6])
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }   
    }
    else
    {
        locate(7, 13);
        printf("     ");
        locate(22, 13);
        printf("   ");
    }
    
    if (room.spec_exit.leads_to)
    {
        sprintf(str, "%d", room.spec_exit.leads_to);
        Pad_Str(str, 5);
        locate(7, 14);
        printf("%s", str);
                            
        locate(22, 14);
        if (room.spec_exit.visible)
        {
            printf("Yes");
        }
        else
        {
            printf("No ");
        }   

        strcpy(str, room.spec_exit.article);
        Pad_Str(str, 3);
        locate(35, 14);
        printf("%s", str);

        strcpy(str, room.spec_exit.adjective);
        Pad_Str(str, 9);
        locate(50, 14);
        printf("%s", str);

        strcpy(str, room.spec_exit.descriptor);
        Pad_Str(str, 14);
        locate(66, 14);
        printf("%s", str);

        Display_Door(room.spec_exit.type);
        Display_Filter(room.spec_exit.filter);

        locate(63, 15);
        if (room.spec_exit.type == SPECIAL_DOOR)
        {
            sprintf(str, "%ld", room.door_index);
        }
        else
        {
            str[0] = 0;
        }

        Pad_Str(str, 5);
        printf(str);

        printf(CLEAR_RIGHT);
        
        locate(51, 16); 
        if (room.spec_exit.filter != ITEM_FILTER)
        {
            printf(CLEAR_RIGHT);
        }
        else
        {
            sprintf(str, "%d", room.filter_spec);
            Pad_Str(str, 5);
            printf("%s", str);

            result = Read_Item(room.filter_spec, &item);
            locate(57, 16);
        
            if (result == 1)
            {
                str[0] = 0;
                if (item.article[0])
                {
                    strcat(str, item.article);
                    strcat(str, " ");
                }

                if (item.adjective[0])
                {
                    strcat(str, item.adjective);
                    strcat(str, " ");
                }
                
                strcat(str, item.name);
            }
            else
            {
                strcpy(str, "(no such item)");
            }
 
            printf("%s%s", str, CLEAR_RIGHT);
        }
        
        locate(19, 16); 
        if (room.spec_exit.filter != RACE_FILTER)
        {
            printf(" ");
        }
        else
        {
            printf("%c", room.filter_spec);
        }

        locate(29, 16); 
        if (room.spec_exit.filter != CLASS_FILTER)
        {
            printf(" ");
        }
        else
        {
            printf("%c", room.filter_spec);
        }

        locate(39, 16); 
        if (room.spec_exit.filter != LEVEL_FILTER)
        {
            printf("     ");
        }
        else
        {
            sprintf(str, "%+d", room.filter_spec);
            Pad_Str(str, 5);
            printf("%s", str);
        }

        locate(7, 17);
        if (room.spec_exit.type == CHANT_DOOR)
        {
            strcpy(str, room.chant);
            Pad_Str(str, CHANT_SIZE);
            printf(str);
        }
        printf(CLEAR_RIGHT);
    }
    else
    {
        locate(7, 14);
        printf("     ");
        locate(22, 14);
        printf("   ");
        locate(35, 14);
        printf("   ");
        locate(50, 14);
        printf("         ");
        locate(66, 14);
        printf("              ");
        locate(19, 15);
        printf("          ");
        locate(39, 15);
        printf("          ");
        locate(63, 15);
        printf("     ");
        locate(19, 16);
        printf(" ");
        locate(29, 16);
        printf(" ");
        locate(39, 16);
        printf("     ");
        locate(51, 16);
        printf(CLEAR_RIGHT);
        locate(7, 17);
        printf(CLEAR_RIGHT);
    }

    locate(13, 18);
    printf("%d", room.enc_chance);
    printf(CLEAR_RIGHT);

    for (i = 0; i != POSSIBLE_MONS; ++i)
    {
        locate(7, 19 + i);
    
        if (room.monster_here[i])
        {
            sprintf(str, "%d", room.monster_here[i]);
            Pad_Str(str, 5);
            printf("%s", str);
            result = Read_Critter(room.monster_here[i], &crit);
            locate(13, 19 + i);
        
            if (result == 1)
            {
                strcpy(str, crit.name);
            }
            else
            {
                strcpy(str, "(no such monster)");
            }
            Pad_Str(str, 30);
            printf("%s", str);
        }
        else
        {
            printf("                         ");
        }
    }

    DONE;
}
/****************************************************************************
    edit rooms
*/
void Edit_Room(void)
{
    int     old;
    long    lresult;
    int     i;
    int     result;
    int     done = FALSE;

    iniscn("MUICHAOS.ED2", scr_bin);
    explode(scr_bin, 0, 0, 79, 24);
    field = ROOM_NUM;

    if (room_num)
    {
        Display_Room();
    }

    do
    {
        if (field == ROOM_NUM)
        {
            if (room_num)
            {
                sprintf(value, "%d", room_num);
            }
            else
            {
                value[0] = 0;
            }

            result = edtval(13, 0, 6, value, Validate_Room_Num, MULTIEX);

            if ((edtvalc == TAB || edtvalc == CR) && room_num)
            {
                field = ROOM_TYPE;
            }
            else if (edtvalc == BAKTAB)
            {
                if (room.enc_chance)
                {
                    field = MON4;
                }
                else
                {
                    field = ENCOUNTER;
                }
            }

            if (result == 0)
            {
                done = TRUE;
            }
            else
            {
                room_num = atoi(value);    
                if (room_num > 0)
                {
                    Display_Room();
                }
            }
        }
        else if (field == ROOM_TYPE)
        {
            sprintf(value, "%d", room.rmtype);
            result = edtval(6, 1, 3, value, Validate_Room_Type, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = TOWN_ROOM;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ROOM_NUM;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= -9 && result <= SOLO_ROOM)
                {
                    room.rmtype = result;
                    Write_Room(&room);
                }
            }

            Display_Room();
        }
        else if (field == TOWN_ROOM)
        {
            if (room.town)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(6, 2, 4, value, validyn, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    room.town = TRUE;
                }
                else
                {
                    room.town = FALSE;
                }
                
                Write_Room(&room);

                if (edtvalc == TAB || edtvalc == CR)
                {
                    field = INVADERS;
                }
                else if (edtvalc == BAKTAB)
                {
                    field = ROOM_TYPE;
                }
            }

            Display_Room();
        }
        else if (field == INVADERS)
        {
            if (room.invaders == 'Y')
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(20, 2, 4, value, validyn, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    room.invaders = 'Y';
                }
                else
                {
                    room.invaders = 'N';
                }
                
                Write_Room(&room);

                if (edtvalc == TAB || edtvalc == CR)
                {
                    field = NO_TELEPORT;
                }
                else if (edtvalc == BAKTAB)
                {
                    field = TOWN_ROOM;
                }
            }

            Display_Room();
        }
        else if (field == NO_TELEPORT)
        {
            if (room.no_teleport == TRUE)
            {
                strcpy(value, "No");
            }
            else
            {
                strcpy(value, "Yes");
            }
            
            result = edtval(37, 2, 4, value, validyn, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    room.no_teleport = FALSE;
                }
                else
                {
                    room.no_teleport = TRUE;
                }
                
                Write_Room(&room);

                if (edtvalc == TAB || edtvalc == CR)
                {
                    field = ROOM_TRAP;
                }
                else if (edtvalc == BAKTAB)
                {
                    field = INVADERS;
                }
            }

            Display_Room();
        }
        else if (field == ROOM_TRAP)
        {
            sprintf(value, "%d", room.trap);
            result = edtval(6, 3, 2, value, Validate_Trap_Type, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ROOM_COVER;
            }
            else if (edtvalc == BAKTAB)
            {
                field = TOWN_ROOM;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0 && result <= 8)
                {
                    room.trap = result;
                    Write_Room(&room);
                }
            }
            
            Display_Room();
        }
        else if (field == ROOM_COVER)
        {
            sprintf(value, "%d", room.cover);
            result = edtval(9, 4, 4, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ROOM_DESC1;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ROOM_TRAP;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0 && result <= 100)
                {
                    room.cover = result;
                    Write_Room(&room);
                }
            }
            
            Display_Room();
        }
        else if (field == ROOM_DESC1)
        {
            strcpy(value, room.desc[0]);
            result = edtval(0, 5, DESC_SIZE, value, Validate_String, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ROOM_DESC2;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ROOM_COVER;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                strcpy(room.desc[0], value);
                Write_Room(&room);
            }
            
            Display_Room();
        }
        else if (field == ROOM_DESC2)
        {
            strcpy(value, room.desc[1]);
            result = edtval(0, 6, DESC_SIZE, value, Validate_String, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ROOM_DESC3;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ROOM_DESC1;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                strcpy(room.desc[1], value);
                Write_Room(&room);
            }
            
            Display_Room();
        }
        else if (field == ROOM_DESC3)
        {
            strcpy(value, room.desc[2]);
            result = edtval(0, 7, DESC_SIZE, value, Validate_String, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ROOM_DESC4;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ROOM_DESC2;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                strcpy(room.desc[2], value);
                Write_Room(&room);
            }
            
            Display_Room();
        }
        else if (field == ROOM_DESC4)
        {
            strcpy(value, room.desc[3]);
            result = edtval(0, 8, DESC_SIZE, value, Validate_String, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ROOM_DESC5;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ROOM_DESC3;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                strcpy(room.desc[3], value);
                Write_Room(&room);
            }
            
            Display_Room();
        }
        else if (field == ROOM_DESC5)
        {
            strcpy(value, room.desc[4]);
            result = edtval(0, 9, DESC_SIZE, value, Validate_String, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ROOM_DESC6;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ROOM_DESC4;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                strcpy(room.desc[4], value);
                Write_Room(&room);
            }
            
            Display_Room();
        }
        else if (field == ROOM_DESC6)
        {
            strcpy(value, room.desc[5]);
            result = edtval(0, 10, DESC_SIZE, value, Validate_String, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = NORTH_EXIT;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ROOM_DESC5;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                strcpy(room.desc[5], value);
                Write_Room(&room);
            }
            
            Display_Room();
        }
        else if (field == NORTH_EXIT)
        {
            old = room.exit[0];
            sprintf(value, "%d", room.exit[0]);
            result = edtval(7, 11, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                i = atoi(value);    
                
                if (i >= 0)
                {
                    result = Read_Room(i, &a_room);
                 
                    if (result == 1)
                    {
                        room.exit[0] = i;
                        if (old == 0)
                        {
                            room.visible[0] = TRUE;
                        }
                        Write_Room(&room);
                    }
                }

                if (edtvalc == TAB || edtvalc == CR)
                {
                    if (room.exit[0])
                    {
                        field = NORTH_VIS;
                    }
                    else
                    {
                        field = SOUTH_EXIT;
                    }
                }
                else if (edtvalc == BAKTAB)
                {
                    field = ROOM_DESC6;
                }
            }
            
            Display_Room();
        }
        else if (field == NORTH_VIS)
        {
            if (room.visible[0])
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(22, 11, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = SOUTH_EXIT;
            }
            else if (edtvalc == BAKTAB)
            {
                field = NORTH_EXIT;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    room.visible[0] = TRUE;
                }
                else
                {
                    room.visible[0] = FALSE;
                }
                
                Write_Room(&room);
            }

            Display_Room();
        }
        else if (field == SOUTH_EXIT)
        {
            old = room.exit[1];
            sprintf(value, "%d", room.exit[1]);
            result = edtval(33, 11, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                i = atoi(value);    
                
                if (i >= 0)
                {
                    result = Read_Room(i, &a_room);
                 
                    if (result == 1)
                    {
                        if (old == 0)
                        {
                            room.visible[1] = TRUE;
                        }

                        room.exit[1] = i;
                        Write_Room(&room);
                    }
                }

                if (edtvalc == TAB || edtvalc == CR)
                {
                    if (room.exit[1])
                    {
                        field = SOUTH_VIS;
                    }
                    else
                    {
                        field = EAST_EXIT;
                    }
                }
                else if (edtvalc == BAKTAB)
                {
                    field = NORTH_EXIT;
                }
            }
            
            Display_Room();
        }
        else if (field == SOUTH_VIS)
        {
            if (room.visible[1])
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(48, 11, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = EAST_EXIT;
            }
            else if (edtvalc == BAKTAB)
            {
                field = SOUTH_EXIT;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    room.visible[1] = TRUE;
                }
                else
                {
                    room.visible[1] = FALSE;
                }
                
                Write_Room(&room);
            }

            Display_Room();
        }
        else if (field == EAST_EXIT)
        {
            old = room.exit[2];
            sprintf(value, "%d", room.exit[2]);
            result = edtval(58, 11, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                i = atoi(value);    
                
                if (i >= 0)
                {
                    result = Read_Room(i, &a_room);
                 
                    if (result == 1)
                    {
                        if (old == 0)
                        {
                            room.visible[2] = TRUE;
                        }

                        room.exit[2] = i;
                        Write_Room(&room);
                    }
                }

                if (edtvalc == TAB || edtvalc == CR)
                {
                    if (room.exit[2])
                    {
                        field = EAST_VIS;
                    }
                    else
                    {
                        field = WEST_EXIT;
                    }
                }
                else if (edtvalc == BAKTAB)
                {
                    field = SOUTH_EXIT;
                }
            }
            
            Display_Room();
        }
        else if (field == EAST_VIS)
        {
            if (room.visible[2])
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(73, 11, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = WEST_EXIT;
            }
            else if (edtvalc == BAKTAB)
            {
                field = EAST_EXIT;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    room.visible[2] = TRUE;
                }
                else
                {
                    room.visible[2] = FALSE;
                }
                
                Write_Room(&room);
            }

            Display_Room();
        }
        else if (field == WEST_EXIT)
        {
            old = room.exit[3];
            sprintf(value, "%d", room.exit[3]);
            result = edtval(7, 12, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                i = atoi(value);    
                
                if (i >= 0)
                {
                    result = Read_Room(i, &a_room);
                 
                    if (result == 1)
                    {
                        if (old == 0)
                        {
                            room.visible[3] = TRUE;
                        }

                        room.exit[3] = i;
                        Write_Room(&room);
                    }
                }

                if (edtvalc == TAB || edtvalc == CR)
                {
                    if (room.exit[3])
                    {
                        field = WEST_VIS;
                    }
                    else
                    {
                        field = UP_EXIT;
                    }
                }
                else if (edtvalc == BAKTAB)
                {
                    field = EAST_EXIT;
                }
            }
            
            Display_Room();
        }
        else if (field == WEST_VIS)
        {
            if (room.visible[3])
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(22, 12, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = UP_EXIT;
            }
            else if (edtvalc == BAKTAB)
            {
                field = WEST_EXIT;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    room.visible[3] = TRUE;
                }
                else
                {
                    room.visible[3] = FALSE;
                }
                
                Write_Room(&room);
            }

            Display_Room();
        }
        else if (field == UP_EXIT)
        {
            old = room.exit[4];
            sprintf(value, "%d", room.exit[4]);
            result = edtval(33, 12, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                i = atoi(value);    
                
                if (i >= 0)
                {
                    result = Read_Room(i, &a_room);
                 
                    if (result == 1)
                    {
                        if (old == 0)
                        {
                            room.visible[4] = TRUE;
                        }

                        room.exit[4] = i;
                        Write_Room(&room);
                    }
                }

                if (edtvalc == TAB || edtvalc == CR)
                {
                    if (room.exit[4])
                    {
                        field = UP_VIS;
                    }
                    else
                    {
                        field = DOWN_EXIT;
                    }
                }
                else if (edtvalc == BAKTAB)
                {
                    field = WEST_EXIT;
                }
            }
            
            Display_Room();
        }
        else if (field == UP_VIS)
        {
            if (room.visible[4])
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(48, 12, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = DOWN_EXIT;
            }
            else if (edtvalc == BAKTAB)
            {
                field = UP_EXIT;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    room.visible[4] = TRUE;
                }
                else
                {
                    room.visible[4] = FALSE;
                }
                
                Write_Room(&room);
            }

            Display_Room();
        }
        else if (field == DOWN_EXIT)
        {
            old = room.exit[5];
            sprintf(value, "%d", room.exit[5]);
            result = edtval(58, 12, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                i = atoi(value);    
                
                if (i >= 0)
                {
                    result = Read_Room(i, &a_room);
                 
                    if (result == 1)
                    {
                        if (old == 0)
                        {
                            room.visible[5] = TRUE;
                        }

                        room.exit[5] = i;
                        Write_Room(&room);
                    }
                }

                if (edtvalc == TAB || edtvalc == CR)
                {
                    if (room.exit[5])
                    {
                        field = DOWN_VIS;
                    }
                    else
                    {
                        field = OUT_EXIT;
                    }
                }
                else if (edtvalc == BAKTAB)
                {
                    field = UP_EXIT;
                }
            }
            
            Display_Room();
        }
        else if (field == DOWN_VIS)
        {
            if (room.visible[5])
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(73, 12, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = OUT_EXIT;
            }
            else if (edtvalc == BAKTAB)
            {
                field = DOWN_EXIT;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    room.visible[5] = TRUE;
                }
                else
                {
                    room.visible[5] = FALSE;
                }
                
                Write_Room(&room);
            }

            Display_Room();
        }
        else if (field == OUT_EXIT)
        {
            old = room.exit[6];
            sprintf(value, "%d", room.exit[6]);
            result = edtval(7, 13, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                i = atoi(value);    
                
                if (i >= 0)
                {
                    result = Read_Room(i, &a_room);
                 
                    if (result == 1)
                    {
                        if (old == 0)
                        {
                            room.visible[6] = TRUE;
                        }

                        room.exit[6] = i;
                        Write_Room(&room);
                    }
                }

                if (edtvalc == TAB || edtvalc == CR)
                {
                    if (room.exit[6])
                    {
                        field = OUT_VIS;
                    }
                    else
                    {
                        field = SPEC_EXIT;
                    }
                }
                else if (edtvalc == BAKTAB)
                {
                    field = DOWN_EXIT;
                }
            }
            
            Display_Room();
        }
        else if (field == OUT_VIS)
        {
            if (room.visible[6])
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(22, 13, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = SPEC_EXIT;
            }
            else if (edtvalc == BAKTAB)
            {
                field = OUT_EXIT;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    room.visible[6] = TRUE;
                }
                else
                {
                    room.visible[6] = FALSE;
                }
                
                Write_Room(&room);
            }

            Display_Room();
        }
        else if (field == SPEC_EXIT)
        {
            old = room.spec_exit.leads_to;
            sprintf(value, "%d", room.spec_exit.leads_to);
            result = edtval(7, 14, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                i = atoi(value);    
                
                if (i >= 0)
                {
                    result = Read_Room(i, &a_room);
                 
                    if (result == 1)
                    {
                        if (old == 0)
                        {
                            room.spec_exit.visible = TRUE;
                        }

                        room.spec_exit.leads_to = i;
                        Write_Room(&room);
                    }
                }

                if (edtvalc == TAB || edtvalc == CR)
                {
                    if (room.spec_exit.leads_to)
                    {
                        field = SPEC_VIS;
                    }
                    else
                    {               
                        field = ENCOUNTER;
                    }
                }
                else if (edtvalc == BAKTAB)
                {
                    field = OUT_EXIT;
                }
            }
            
            Display_Room();
        }
        else if (field == SPEC_VIS)
        {
            if (room.spec_exit.visible)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(22, 14, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = SPEC_ART;
            }
            else if (edtvalc == BAKTAB)
            {
                field = SPEC_EXIT;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    room.spec_exit.visible = TRUE;
                }
                else
                {
                    room.spec_exit.visible = FALSE;
                }
                
                Write_Room(&room);
            }

            Display_Room();
        }
        else if (field == SPEC_ART)
        {
            strcpy(value, room.spec_exit.article);
            result = edtval
            (
                35, 
                14, 
                SPEC_ARTICLE_SIZE, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = SPEC_ADJ;
            }
            else if (edtvalc == BAKTAB)
            {
                field = SPEC_VIS;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                strcpy(room.spec_exit.article, value);
                Write_Room(&room);
            }
            
            Display_Room();
        }
        else if (field == SPEC_ADJ)
        {
            strcpy(value, room.spec_exit.adjective);
            result = edtval
            (
                50, 
                14, 
                LABEL_SIZE, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = SPEC_NAME;
            }
            else if (edtvalc == BAKTAB)
            {
                field = SPEC_ART;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                strcpy(room.spec_exit.adjective, value);
                Write_Room(&room);
            }
            
            Display_Room();
        }
        else if (field == SPEC_NAME)
        {
            strcpy(value, room.spec_exit.descriptor);
            result = edtval
            (
                66, 
                14, 
                DESCRIPTOR_SIZE, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = SPEC_TYPE;
            }
            else if (edtvalc == BAKTAB)
            {
                field = SPEC_ADJ;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                strcpy(room.spec_exit.descriptor, value);
                Write_Room(&room);
            }
            
            Display_Room();
        }
        else if (field == SPEC_TYPE)
        {
            sprintf(value, "%d", room.spec_exit.type);
            result = edtval(19, 15, 2, value, Validate_Door_Type, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = SPEC_FILTER;
            }
            else if (edtvalc == BAKTAB)
            {
                field = SPEC_NAME;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 1 && result <= 5)
                {
                    room.spec_exit.type = result;
                    Write_Room(&room);
                }
            }
            
            Display_Room();
        }
        else if (field == SPEC_FILTER)
        {
            sprintf(value, "%d", room.spec_exit.filter);
            result = edtval(39, 15, 3, value, Validate_Filter, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0 && result < MAX_FILTERS)
                {
                    room.spec_exit.filter = result;
                    Write_Room(&room);
                }

                if (edtvalc == TAB || edtvalc == CR)
                {
                    if (room.spec_exit.type == SPECIAL_DOOR)
                    {
                        field = SPEC_KEY;
                    }
                    else if (room.spec_exit.type == CHANT_DOOR)
                    {
                        field = SPEC_CHANT;
                    }
                    else if (room.spec_exit.filter == ITEM_FILTER)
                    {
                        field = FILTER_ITEM;
                    }
                    else if (room.spec_exit.filter == CLASS_FILTER)
                    {
                        field = FILTER_CLASS;
                    }
                    else if (room.spec_exit.filter == LEVEL_FILTER)
                    {
                        field = FILTER_LEVEL; 
                    }
                    else if (room.spec_exit.filter == RACE_FILTER)
                    {
                        field = FILTER_RACE;
                    }
                    else
                    {
                        field = ENCOUNTER;
                    }
                }
                else if (edtvalc == BAKTAB)
                {
                    field = SPEC_TYPE;
                }
            }
            
            Display_Room();
        }
        else if (field == SPEC_KEY)
        {
            sprintf(value, "%ld", room.door_index);
            result = edtval(63, 15, 6, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                if (room.spec_exit.filter == ITEM_FILTER)
                {
                    field = FILTER_ITEM;
                }
                else if (room.spec_exit.filter == CLASS_FILTER)
                {
                    field = FILTER_CLASS;
                }
                else if (room.spec_exit.filter == LEVEL_FILTER)
                {
                    field = FILTER_LEVEL;
                }
                else if (room.spec_exit.filter == RACE_FILTER)
                {
                    field = FILTER_RACE;
                }
                else
                {
                    field = ENCOUNTER;
                }
            }
            else if (edtvalc == BAKTAB)
            {
                field = SPEC_FILTER;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                lresult = atol(value);    
                
                if (lresult >= 0)
                {
                    room.door_index = lresult;
                    Write_Room(&room);
                }
            }
            
            Display_Room();
        }
        else if (field == FILTER_ITEM)
        {
            sprintf(value, "%d", room.filter_spec);
            result = edtval(51, 16, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result > 0)
                {
                    room.filter_spec = result;
                    Write_Room(&room);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ENCOUNTER;
            }
            else if (edtvalc == BAKTAB)
            {
                field = SPEC_EXIT;
            }
            
            Display_Room();
        }
        else if (field == FILTER_CLASS)
        {
            value[0] = room.filter_spec;
            value[1] = 0;

            result = edtval
            (
                29, 16, 
                2, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ENCOUNTER;
            }
            else if (edtvalc == BAKTAB)
            {
                field = SPEC_EXIT;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                room.filter_spec = toupper(value[0]);
                Write_Room(&room);
            }
            
            Display_Room();
        }
        else if (field == FILTER_LEVEL)
        {
            sprintf(value, "%d", room.filter_spec);

            result = edtval
            (
                39, 16, 
                5, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ENCOUNTER;
            }
            else if (edtvalc == BAKTAB)
            {
                field = SPEC_EXIT;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                room.filter_spec = atoi(value);
                Write_Room(&room);
            }
            
            Display_Room();
        }
        else if (field == FILTER_RACE)
        {
            value[0] = room.filter_spec;
            value[1] = 0;

            result = edtval
            (
                19, 16, 
                2, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ENCOUNTER;
            }
            else if (edtvalc == BAKTAB)
            {
                field = SPEC_EXIT;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                room.filter_spec = toupper(value[0]);
                Write_Room(&room);
            }
            
            Display_Room();
        }
        else if (field == SPEC_CHANT)
        {
            strcpy(value, room.chant);
            result = edtval
            (
                7, 17, 
                CHANT_SIZE, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                if (room.spec_exit.filter == ITEM_FILTER)
                {
                    field = FILTER_ITEM;
                }
                else if (room.spec_exit.filter == RACE_FILTER)
                {
                    field = FILTER_RACE;
                }
                else if (room.spec_exit.filter == CLASS_FILTER)
                {
                    field = FILTER_CLASS;
                }
                else
                {
                    field = ENCOUNTER;
                }
            }
            else if (edtvalc == BAKTAB)
            {
                field = SPEC_FILTER;
            }

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                strcpy(room.chant, value);
                Write_Room(&room);
            }
            
            Display_Room();
        }
        else if (field == ENCOUNTER)
        {
            sprintf(value, "%d", room.enc_chance);
            result = edtval(13, 18, 4, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0 && result <= 100)
                {
                    room.enc_chance = result;

                    if (room.enc_chance == 0)
                    {
                        for (i = 0; i != POSSIBLE_MONS; ++i)
                        {
                            room.monster_here[i] = 0;
                        }
                    }

                    Write_Room(&room);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                if (room.enc_chance)
                {
                    field = MON0;
                }
                else
                {
                    field = ROOM_NUM;
                }
            }
            else if (edtvalc == BAKTAB)
            {
                field = SPEC_EXIT;
            }
            
            Display_Room();
        }
        else if (field == MON0)
        {
            sprintf(value, "%d", room.monster_here[0]);
            result = edtval(7, 19, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    room.monster_here[0] = result;
                    Write_Room(&room);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = MON1;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ENCOUNTER;
            }
            
            Display_Room();
        }
        else if (field == MON1)
        {
            sprintf(value, "%d", room.monster_here[1]);
            result = edtval(7, 20, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    room.monster_here[1] = result;
                    Write_Room(&room);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = MON2;
            }
            else if (edtvalc == BAKTAB)
            {
                field = MON0;
            }
            
            Display_Room();
        }
        else if (field == MON2)
        {
            sprintf(value, "%d", room.monster_here[2]);
            result = edtval(7, 21, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    room.monster_here[2] = result;
                    Write_Room(&room);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = MON3;
            }
            else if (edtvalc == BAKTAB)
            {
                field = MON1;
            }
            
            Display_Room();
        }
        else if (field == MON3)
        {
            sprintf(value, "%d", room.monster_here[3]);
            result = edtval(7, 22, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    room.monster_here[3] = result;
                    Write_Room(&room);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = MON4;
            }
            else if (edtvalc == BAKTAB)
            {
                field = MON2;
            }
            
            Display_Room();
        }
        else if (field == MON4)
        {
            sprintf(value, "%d", room.monster_here[4]);
            result = edtval(7, 23, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = ROOM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    room.monster_here[4] = result;
                    Write_Room(&room);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ROOM_NUM;
            }
            else if (edtvalc == BAKTAB)
            {
                field = MON3;
            }
            
            Display_Room();
        }
    }
    while (!done);
}
/****************************************************************************
    validate room number
*/
int  Validate_Room_Num(c, so_far)
int  c;
char *so_far;
{

    if (c == PGDN)
    {
        ++room_num;
        Display_Room();
        sprintf(so_far, "%d", room_num);
        return (FALSE);
    }
    else if (c == PGUP)
    {
        if (room_num > 1)
        {
            --room_num;
            Display_Room();
            sprintf(so_far, "%d", room_num);
        }
        return (FALSE);
    }
    else if (c == ESC || (c >= '0' && c <= '9'))
    {
        return (TRUE);
    }
    else
    {
        belper(600);
        printf("\7");
        return (FALSE);
    }
}
/****************************************************************************
    validate item number
*/
int  Validate_Item_Num(c, so_far)
int  c;
char *so_far;
{

    if (c == PGDN)
    {
        ++item_num;
        Display_Item();
        sprintf(so_far, "%d", item_num);
        return (FALSE);
    }
    else if (c == PGUP)
    {
        if (item_num > 1)
        {
            --item_num;
            Display_Item();
            sprintf(so_far, "%d", item_num);
        }
        return (FALSE);
    }
    else if (c == ESC || (c >= '0' && c <= '9'))
    {
        return (TRUE);
    }
    else
    {
        belper(600);
        printf("\7");
        return (FALSE);
    }
}
/****************************************************************************
    validate monster number
*/
int  Validate_Crit_Num(c, so_far)
int  c;
char *so_far;
{

    if (c == PGDN)
    {
        ++crit_num;
        Display_Monster();
        sprintf(so_far, "%d", crit_num);
        return (FALSE);
    }
    else if (c == PGUP)
    {
        if (crit_num > 1)
        {
            --crit_num;
            Display_Monster();
            sprintf(so_far, "%d", crit_num);
        }
        return (FALSE);
    }
    else if (c == ESC || (c >= '0' && c <= '9'))
    {
        return (TRUE);
    }
    else
    {
        belper(600);
        printf("\7");
        return (FALSE);
    }
}
/****************************************************************************
    validate a string
*/
int  Validate_String(void)
{

    return (TRUE);
}
/****************************************************************************
    validate special exit filter
*/
int  Validate_Filter(c, so_far)
int  c;
char *so_far;
{
    int     f;
    char    *scnsav;

    if (c == ESC)
    {
        return (TRUE);
    }
    else if (c == F1)
    {
        f = atoi(so_far);

        movmem(frzseg(), scnsav=alcmem(SCNSIZ), SCNSIZ);

        f = choowd
        (
            filter_types,
            f,
            30, 9,
            50, 14,
            TRUE
        );

        movmem(scnsav, frzseg(), SCNSIZ);
        free(scnsav);

        if (f >= 0)
        {
            sprintf(so_far, "%d", f);
            Display_Filter(f);
        }

        return (FALSE);
    }
    else if (c >= '0' && c <= '9')
    {
        sprintf(str, "%c%c", so_far[0], c);
        f = atoi(str);
        Display_Filter(f);
        return (TRUE);
    }
    else
    {
        belper(700);
        printf("\7");
        return (FALSE);
    }
}
/****************************************************************************
    validate item type
*/
int  Validate_Item_What(c, so_far)
int  c;
char *so_far;
{
    int     t;
    char    *scnsav;

    if (c == ESC)
    {
        return (TRUE);
    }
    else if (c == F1)
    {
        t = atoi(so_far) - 1;

        movmem(frzseg(), scnsav=alcmem(SCNSIZ), SCNSIZ);

        t = choowd
        (
            item_whats,
            t,
            40, 2,
            60, 13,
            TRUE
        );

        movmem(scnsav, frzseg(), SCNSIZ);
        free(scnsav);

        if (t >= 0)
        {
            ++t;
            sprintf(so_far, "%d", t);
            Display_Item_Type(t);
        }

        return (FALSE);
    }
    else if (c >= '0' && c <= '9')
    {
        sprintf(str, "%c%c", so_far[0], c);
        t = atoi(str);
        Display_Item_Type(t);
        return (TRUE);
    }
    else
    {
        belper(700);
        printf("\7");
        return (FALSE);
    }
}
/****************************************************************************
    validate item spell
*/
int  Validate_Item_Spell(c, so_far)
int  c;
char *so_far;
{
    int     s;

    if (c == ESC)
    {
        return (TRUE);
    }
    else if (c >= '0' && c <= '9')
    {
        sprintf(str, "%c%c", so_far[0], c);
        s = atoi(str);
        Display_Item_Spell(s);
        return (TRUE);
    }
    else
    {
        belper(700);
        printf("\7");
        return (FALSE);
    }
}
/****************************************************************************
    validate item subtype
*/
int  Validate_Item_Which(c, so_far)
int  c;
char *so_far;
{
    int     t;
    char    *scnsav;

    if (c == ESC)
    {
        return (TRUE);
    }
    else if (c == F1)
    {
        t = atoi(so_far);

        movmem(frzseg(), scnsav=alcmem(SCNSIZ), SCNSIZ);

        t = choowd
        (
            item_whiches,
            t,
            40, 2,
            60, 12,
            TRUE
        );

        movmem(scnsav, frzseg(), SCNSIZ);
        free(scnsav);

        if (t >= 0)
        {
            sprintf(so_far, "%d", t);
            Display_Item_Subtype(t);
        }

        return (FALSE);
    }
    else if (c >= '0' && c <= '9')
    {
        sprintf(str, "%c%c", so_far[0], c);
        t = atoi(str);
        Display_Item_Subtype(t);
        return (TRUE);
    }
    else
    {
        belper(700);
        printf("\7");
        return (FALSE);
    }
}
/****************************************************************************
    validate room type
*/
int  Validate_Room_Type(c, so_far)
int  c;
char *so_far;
{
    int     rmtype;
    char    *scnsav;

    if (c == ESC)
    {
        return (TRUE);
    }
    else if (c == F1)
    {
        rmtype = atoi(so_far);
        
        if (rmtype < 0)
        {
            rmtype = abs(rmtype) + SOLO_ROOM;
        }

        movmem(frzseg(), scnsav=alcmem(SCNSIZ), SCNSIZ);

        rmtype = choowd
        (
            room_types,
            rmtype,
            30, 9,
            60, 14,
            TRUE
        );

        movmem(scnsav, frzseg(), SCNSIZ);
        free(scnsav);

        if (rmtype >= 0)
        {
            if (rmtype > SOLO_ROOM)
            {
                rmtype = -(rmtype - SOLO_ROOM);
            }
            
            sprintf(so_far, "%d", rmtype);
            Display_Room_Type(rmtype);
        }

        return (FALSE);
    }
    else if ((c >= '0' && c <= '9') || c == '-')
    {
        sprintf(str, "%c%c", so_far[0], c);
        rmtype = atoi(str);
        Display_Room_Type(rmtype);
        return (TRUE);
    }
    else
    {
        belper(700);
        printf("\7");
        return (FALSE);
    }
}
/****************************************************************************
    validate trap type
*/
int  Validate_Trap_Type(c, so_far)
int  c;
char *so_far;
{
    int     trap;

    if (c == ESC)
    {
        return (TRUE);
    }
    else if (c >= '0' && c <= '9' && so_far[0] == ' ')
    {
        trap = c - '0';
        Display_Trap(trap);
        return (TRUE);
    }
    else
    {
        belper(700);
        printf("\7");
        return (FALSE);
    }
}
/****************************************************************************
    validate monster type
*/
int  Validate_Crit_Type(c, so_far)
int  c;
char *so_far;
{
    int     t;
    char    *scnsav;

    if (c == ESC)
    {
        return (TRUE);
    }
    else if (c == F1)
    {
        t = atoi(so_far) - 1;

        movmem(frzseg(), scnsav=alcmem(SCNSIZ), SCNSIZ);

        t = choowd
        (
            crit_types,
            t,
            40, 6,
            55, 12,
            TRUE
        );

        movmem(scnsav, frzseg(), SCNSIZ);
        free(scnsav);

        if (t >= 0)
        {
            ++t;
            sprintf(so_far, "%d", t);
            Display_Crit_Type(t);
        }

        return (FALSE);
    }
    else if (c >= '0' && c <= '9' && so_far[0] == ' ')
    {
        t = c - '0';
        Display_Crit_Type(t);
        return (TRUE);
    }
    else
    {
        belper(700);
        printf("\7");
        return (FALSE);
    }
}
/****************************************************************************
    validate monster attacked vector
*/
int  Validate_Attacked(c, so_far)
int  c;
char *so_far;
{
    int     v;
    char    *scnsav;

    if (c == ESC)
    {
        return (TRUE);
    }
    else if (c == F1)
    {
        v = atoi(so_far);

        movmem(frzseg(), scnsav=alcmem(SCNSIZ), SCNSIZ);

        v = choowd
        (
            attacked_vectors,
            v,
            40, 6,
            60, 9,
            TRUE
        );

        movmem(scnsav, frzseg(), SCNSIZ);
        free(scnsav);

        if (v >= 0)
        {
            sprintf(so_far, "%d", v);
            Display_Attacked_Vector(v);
        }

        return (FALSE);
    }
    else if (c >= '0' && c <= '9' && so_far[0] == ' ')
    {
        v = c - '0';
        Display_Attacked_Vector(v);
        return (TRUE);
    }
    else
    {
        belper(700);
        printf("\7");
        return (FALSE);
    }
}
/****************************************************************************
    validate monster hit vector
*/
int  Validate_Attack(c, so_far)
int  c;
char *so_far;
{
    int     v;
    char    *scnsav;

    if (c == ESC)
    {
        return (TRUE);
    }
    else if (c == F1)
    {
        v = atoi(so_far);

        movmem(frzseg(), scnsav=alcmem(SCNSIZ), SCNSIZ);

        v = choowd
        (
            attack_vectors,
            v,
            40, 6,
            63, 10,
            TRUE
        );

        movmem(scnsav, frzseg(), SCNSIZ);
        free(scnsav);

        if (v >= 0)
        {
            sprintf(so_far, "%d", v);
            Display_Attack_Vector(v);
        }

        return (FALSE);
    }
    else if (c >= '0' && c <= '9' && so_far[0] == ' ')
    {
        v = c - '0';
        Display_Attack_Vector(v);
        return (TRUE);
    }
    else
    {
        belper(700);
        printf("\7");
        return (FALSE);
    }
}
/****************************************************************************
    validate door type
*/
int  Validate_Door_Type(c, so_far)
int  c;
char *so_far;
{
    int     d;
    char    *scnsav;

    if (c == ESC)
    {
        return (TRUE);
    }
    else if (c == F1)
    {
        d = atoi(so_far) - 1;

        movmem(frzseg(), scnsav=alcmem(SCNSIZ), SCNSIZ);

        d = choowd
        (
            door_types,
            d,
            30, 9,
            50, 13,
            TRUE
        );

        movmem(scnsav, frzseg(), SCNSIZ);
        free(scnsav);

        if (d >= 0)
        {
            ++d;
            sprintf(so_far, "%d", d);
            Display_Door(d);
        }

        return (FALSE);
    }
    else if (c >= '1' && c <= '5' && so_far[0] == ' ')
    {
        d = c - '0';
        Display_Door(d);
        return (TRUE);
    }
    else
    {
        belper(700);
        printf("\7");
        return (FALSE);
    }
}
/****************************************************************************
    edit monsters
*/
void Edit_Monster(void)
{
    int     result;
    int     done = FALSE;

    iniscn("MUICHAOS.ED4", scr_bin);
    explode(scr_bin, 0, 0, 79, 24);
    field = CRIT_NUM;

    if (crit_num)
    {
        Display_Monster();
    }

    do
    {
        if (field == CRIT_NUM)
        {
            if (crit_num)
            {
                sprintf(value, "%d", crit_num);
            }
            else
            {
                value[0] = 0;
            }
                        
            result = edtval(16, 0, 6, value, Validate_Crit_Num, MULTIEX);

            if ((edtvalc == TAB || edtvalc == CR) && crit_num)
            {
                field = CRIT_ARTICLE;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_ITEM4;
            }

            if (result == 0)
            {
                done = TRUE;
            }
            else
            {
                crit_num = atoi(value);    
                if (crit_num > 0)
                {
                    Display_Monster();
                }
            }
        }
        else if (field == CRIT_ARTICLE)
        {
            strcpy(value, crit.article);
            
            result = edtval
            (
                14, 1, 
                ARTICLE_SIZE, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_NAME;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_NUM;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                strcpy(crit.article, value);
                Write_Critter(&crit);
            }
            
            Display_Monster();
        }
        else if (field == CRIT_NAME)
        {
            strcpy(value, crit.name);
            
            result = edtval
            (
                14, 2, 
                NAME_LEN, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_PLURAL;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_ARTICLE;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                strcpy(crit.name, value);
                Write_Critter(&crit);
            }
            
            Display_Monster();
        }
        else if (field == CRIT_PLURAL)
        {
            strcpy(value, crit.plural_name);
            
            result = edtval
            (
                14, 3, 
                PLURAL_SIZE, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_TYPE;
            }
            else if (edtvalc == BAKTAB)
            {                    
                field = CRIT_NAME;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                strcpy(crit.plural_name, value);
                Write_Critter(&crit);
            }
            
            Display_Monster();
        }
        else if (field == CRIT_TYPE)
        {
            sprintf(value, "%d", crit.what);
            result = edtval(13, 5, 2, value, Validate_Crit_Type, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_LEVEL;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_PLURAL;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result > 0 && result < MAX_MON_WHAT)
                {
                    crit.what = result;
                    Write_Critter(&crit);
                }
            }
            
            Display_Monster();
        }
        else if (field == CRIT_LEVEL)
        {
            sprintf(value, "%d", crit.Level);
            result = edtval(13, 6, 5, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {                 
                field = CRIT_GOOD;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_TYPE;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result > 0)
                {
                    crit.Level = result;
                    Write_Critter(&crit);
                }
            }
            
            Display_Monster();
        }
        else if (field == CRIT_GOOD)
        {
            if (crit.alg)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(13, 7, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_CAST;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_LEVEL;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    crit.alg = TRUE;
                }
                else
                {
                    crit.alg = FALSE;
                }
                
                Write_Critter(&crit);
            }

            Display_Monster();
        }
        else if (field == CRIT_CAST)
        {
            if (crit.spell_caster)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(13, 8, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_MAGIC;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_GOOD;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    crit.spell_caster = TRUE;
                }
                else
                {
                    crit.spell_caster = FALSE;
                }
                
                Write_Critter(&crit);
            }

            Display_Monster();
        }
        else if (field == CRIT_MAGIC)
        {
            if (crit.magical)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(13, 9, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_BLOCK;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_CAST;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    crit.magical = TRUE;
                }
                else
                {
                    crit.magical = FALSE;
                }
                
                Write_Critter(&crit);
            }

            Display_Monster();
        }
        else if (field == CRIT_BLOCK)
        {
            if (crit.blocks)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(13, 10, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_IMMUNE;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_MAGIC;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    crit.blocks = TRUE;
                }
                else
                {
                    crit.blocks = FALSE;
                }
                
                Write_Critter(&crit);
            }

            Display_Monster();
        }
        else if (field == CRIT_IMMUNE)
        {
            if (crit.magic_immune)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(13, 11, 4, value, validyn, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_PERM;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_BLOCK;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    crit.magic_immune = TRUE;
                }
                else
                {
                    crit.magic_immune = FALSE;
                }
                
                Write_Critter(&crit);
            }

            Display_Monster();
        }
        else if (field == CRIT_PERM)
        {
            if (crit.permanant)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(13, 12, 4, value, validyn, MULTIEX);

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    crit.permanant = TRUE;
                }
                else
                {
                    crit.permanant = FALSE;
                }
                
                Write_Critter(&crit);

                if (edtvalc == TAB || edtvalc == CR)
                {
                    if (crit.permanant)
                    {
                        field = CRIT_ROVE;
                    }
                    else
                    {
                        field = CRIT_ATTACKED;
                    }
                }
                else if (edtvalc == BAKTAB)
                {
                    field = CRIT_IMMUNE;
                }
            }

            Display_Monster();
        }
        else if (field == CRIT_ROVE)
        {
            if (crit.roving)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(13, 13, 4, value, validyn, MULTIEX);

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    crit.roving = TRUE;
                }
                else
                {
                    crit.roving = FALSE;
                }
                
                Write_Critter(&crit);

                if (edtvalc == TAB || edtvalc == CR)
                {
                    field = CRIT_LOC;
                }
                else if (edtvalc == BAKTAB)
                {
                    field = CRIT_PERM;
                }
            }

            Display_Monster();
        }
        else if (field == CRIT_LOC)
        {
            sprintf(value, "%d", crit.loc);
            result = edtval(13, 14, 6, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {                 
                field = CRIT_ATTACKED;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_ROVE;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    crit.loc = result;
                    Write_Critter(&crit);
                }
            }
            
            Display_Monster();
        }
        else if (field == CRIT_ATTACKED)
        {
            sprintf(value, "%d", crit.attacked_vector);
            result = edtval(18, 16, 2, value, Validate_Attacked, MULTIEX);

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0 && result <= AUTO_FLEE)
                {
                    crit.attacked_vector = result;
                    Write_Critter(&crit);
                }

                if (edtvalc == TAB || edtvalc == CR)
                {
                    if (result == MORPH)
                    {
                        field = CRIT_MORPH;
                    }
                    else if (result == ADD_EVIL)
                    {
                        field = CRIT_EVIL;
                    }
                    else
                    {
                        field = CRIT_ATTACK;
                    }
                }
                else if (edtvalc == BAKTAB)
                {
                    field = CRIT_PERM;
                }
            }
            
            Display_Monster();
        }
        else if (field == CRIT_MORPH)
        {
            sprintf(value, "%d", crit.morph);
            result = edtval(74, 16, 3, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_ATTACK;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_ATTACKED;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result < 1)
                {
                    result = 1;
                }

                crit.morph = result;
                Write_Critter(&crit);
            }
            
            Display_Monster();
        }
        else if (field == CRIT_EVIL)
        {
            sprintf(value, "%d", crit.evil_pts);
            result = edtval(74, 17, 4, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_ATTACK;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_ATTACKED;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result < 0)
                {
                    result = 0;
                }

                crit.evil_pts = result;
                Write_Critter(&crit);
            }
            
            Display_Monster();
        }
        else if (field == CRIT_ATTACK)
        {
            sprintf(value, "%d", crit.hit_vector);
            result = edtval(18, 17, 2, value, Validate_Attack, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_TALK;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_ATTACKED;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0 && result <= PEST)
                {
                    crit.hit_vector = result;
                    Write_Critter(&crit);
                }
            }
            
            Display_Monster();
        }
        else if (field == CRIT_TALK)
        {
            strcpy(value, crit.talk);
            result = edtval
            (
                6, 18, 
                TALK_SIZE, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                if (crit.what == HUNTRESS)
                {
                    field = CRIT_QUESTS;
                }
                else
                {
                    field = CRIT_ITEM0;
                }
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_ATTACK;
            }

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                strcpy(crit.talk, value);
                Write_Critter(&crit);
            }
            
            Display_Monster();
        }
        else if (field == CRIT_QUESTS)
        {
            sprintf(value, "%d", crit.quests);
            result = edtval(9, 19, 4, value, validig, MULTIEX);

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    crit.quests = result;
                    Write_Critter(&crit);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_REWARD;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_TALK;
            }
            
            Display_Monster();
        }
        else if (field == CRIT_REWARD)
        {
            sprintf(value, "%d", crit.huntress_item);
            result = edtval(21, 19, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    crit.huntress_item = result;
                    Write_Critter(&crit);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_ITEM0;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_QUESTS;
            }
            
            Display_Monster();
        }
        else if (field == CRIT_ITEM0)
        {
            sprintf(value, "%d", crit.Item[0]);
            result = edtval(9, 20, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    crit.Item[0] = result;
                    Write_Critter(&crit);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_ITEM1;
            }
            else if (edtvalc == BAKTAB)
            {
                if (crit.what == HUNTRESS)
                {
                    field = CRIT_REWARD;
                }
                else
                {
                    field = CRIT_TALK;
                }
            }
            
            Display_Monster();
        }
        else if (field == CRIT_ITEM1)
        {
            sprintf(value, "%d", crit.Item[1]);
            result = edtval(9, 21, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    crit.Item[1] = result;
                    Write_Critter(&crit);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_ITEM2;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_ITEM0;
            }
            
            Display_Monster();
        }
        else if (field == CRIT_ITEM2)
        {
            sprintf(value, "%d", crit.Item[2]);
            result = edtval(9, 22, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    crit.Item[2] = result;
                    Write_Critter(&crit);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_ITEM3;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_ITEM1;
            }
            
            Display_Monster();
        }
        else if (field == CRIT_ITEM3)
        {
            sprintf(value, "%d", crit.Item[3]);
            result = edtval(9, 23, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    crit.Item[3] = result;
                    Write_Critter(&crit);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_ITEM4;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_ITEM2;
            }
            
            Display_Monster();
        }
        else if (field == CRIT_ITEM4)
        {
            sprintf(value, "%d", crit.Item[4]);
            result = edtval(9, 24, 6, value, validig, MULTIEX);

            if (result == 0)
            {
                field = CRIT_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    crit.Item[4] = result;
                    Write_Critter(&crit);
                }
            }

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = CRIT_NUM;
            }
            else if (edtvalc == BAKTAB)
            {
                field = CRIT_ITEM3;
            }
            
            Display_Monster();
        }
    }
    while (!done);
}
/****************************************************************************
    edit items
*/
void Edit_Item(void)
{
    int     result;
    int     done = FALSE;

    iniscn("MUICHAOS.ED3", scr_bin);
    explode(scr_bin, 0, 0, 79, 24);
    field = ITEM_NUM;

    if (item_num)
    {
        Display_Item();
    }

    do
    {
        if (field == ITEM_NUM)
        {
            if (item_num)
            {
                sprintf(value, "%d", item_num);
            }
            else
            {
                value[0] = 0;
            }
                        
            result = edtval(13, 0, 6, value, Validate_Item_Num, MULTIEX);

            if ((edtvalc == TAB || edtvalc == CR) && item_num)
            {
                field = ITEM_ARTICLE;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ITEM_NUM;
            }

            if (result == 0)
            {
                done = TRUE;
            }
            else
            {
                item_num = atoi(value);    
                if (item_num > 0)
                {
                    Display_Item();
                }
            }
        }
        else if (field == ITEM_ARTICLE)
        {
            strcpy(value, item.article);
            
            result = edtval
            (
                11, 2, 
                ARTICLE_SIZE, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ITEM_ADJECTIVE;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ITEM_NUM;
            }

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                strcpy(item.article, value);
                Write_Item(&item);
            }
            
            Display_Item();
        }
        else if (field == ITEM_ADJECTIVE)
        {
            strcpy(value, item.adjective);
            
            result = edtval
            (
                11, 3, 
                LABEL_SIZE, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ITEM_NAME;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ITEM_ARTICLE;
            }

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                strcpy(item.adjective, value);
                Write_Item(&item);
            }
            
            Display_Item();
        }
        else if (field == ITEM_NAME)
        {
            strcpy(value, item.name);
            
            result = edtval
            (
                11, 4, 
                ITEM_NOUN_SIZE, 
                value, 
                Validate_String, 
                MULTIEX
            );

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ITEM_PERMANANT;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ITEM_ADJECTIVE;
            }

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                strcpy(item.name, value);
                Write_Item(&item);
            }
            
            Display_Item();
        }
        else if (field == ITEM_PERMANANT)
        {
            if (item.permanant)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(11, 5, 4, value, validyn, MULTIEX);

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    item.permanant = TRUE;
                }
                else
                {
                    item.permanant = FALSE;
                }
                
                Write_Item(&item); 

                if (edtvalc == TAB || edtvalc == CR)
                {
                    field = ITEM_WHAT;
                }
                else if (edtvalc == BAKTAB)
                {
                    field = ITEM_NAME;
                }
            }

            Display_Item();
        }
        else if (field == ITEM_WHAT)
        {
            sprintf(value, "%d", item.what);
            result = edtval(11, 6, 3, value, Validate_Item_What, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ITEM_WHICH;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ITEM_PERMANANT;
            }

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result > 0 && result < MAX_ITEM_WHAT)
                {
                    item.what = result;
                    Write_Item(&item);
                }
            }
            
            Display_Item();
        }
        else if (field == ITEM_WHICH)
        {
            sprintf(value, "%d", item.which);
            result = edtval(11, 7, 3, value, Validate_Item_Which, MULTIEX);

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0 && result < MAX_ITEM_WHICH)
                {
                    item.which = result;
                    Write_Item(&item);
                }

                if (edtvalc == TAB || edtvalc == CR)
                {
                    field = ITEM_LEVEL;
                }
                else if (edtvalc == BAKTAB)
                {
                    field = ITEM_WHAT;
                }
            }
            
            Display_Item();
        }
        else if (field == ITEM_LEVEL)
        {
            sprintf(value, "%d", item.item_level);
            result = edtval(11, 8, 4, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                if (ARSH(item) || WEAPON(item))
                {
                    field = ITEM_INSTILL;
                }
                else if (item.what == MAGIC_DEV)
                {
                    field = ITEM_SPELL;
                }
                else if (item.what == TRANSPORTER || item.permanant)
                {
                    field = ITEM_ROOM;
                }
                else if (item.what == TRINKET && item.which == PUZZLE)
                {
                    field = PUZZLE_INDEX;
                }
                else
                {
                    field = ITEM_NUM;
                }
            }
            else if (edtvalc == BAKTAB)
            {
                field = ITEM_WHICH;
            }

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    item.item_level = result;
                    Write_Item(&item);
                }
            }
            
            Display_Item();
        }
        else if (field == ITEM_INSTILL)
        {
            if (item.ring_used)
            {
                strcpy(value, "Yes");
            }
            else
            {
                strcpy(value, "No");
            }
            
            result = edtval(32, 8, 4, value, validyn, MULTIEX);

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                if (value[0] == 'Y')
                {
                    item.ring_used = TRUE;
                }
                else
                {
                    item.ring_used = FALSE;
                }
                
                Write_Item(&item); 

                if (edtvalc == TAB || edtvalc == CR)
                {
                    if (item.ring_used)
                    {
                        field = ITEM_SPELL;
                    }
                    else if (item.permanant)
                    {
                        field = ITEM_ROOM;
                    }
                    else
                    {
                        field = ITEM_NUM;
                    }
                }
                else if (edtvalc == BAKTAB)
                {
                    field = ITEM_LEVEL;
                }
            }

            Display_Item();
        }
        else if (field == ITEM_SPELL)
        {
            sprintf(value, "%d", item.spell_cast);
            result = edtval(11, 9, 3, value, Validate_Item_Spell, MULTIEX);

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0 && result < NUM_SPELLS)
                {
                    item.spell_cast = result;
                    Write_Item(&item);
                }

                if (edtvalc == TAB || edtvalc == CR)
                {
                    if 
                    (
                        item.what == MAGIC_DEV && 
                        item.which == SPECIAL_KEY
                    )
                    {   
                        field = ITEM_KEY;
                    }
                    else
                    {
                        field = ITEM_NUM;
                    }
                }
                else if (edtvalc == BAKTAB)
                {
                    if (ARSH(item) || WEAPON(item))
                    {
                        field = ITEM_INSTILL;
                    }
                    else
                    {
                        field = ITEM_LEVEL;
                    }
                }
            }
            
            Display_Item();
        }
        else if (field == ITEM_KEY)
        {
            sprintf(value, "%d", item.holding);
            result = edtval(11, 11, 6, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                if (item.what == TRANSPORTER || item.permanant)
                {
                    field = ITEM_ROOM;
                }
                else
                {
                    field = ITEM_NUM;
                }
            }
            else if (edtvalc == BAKTAB)
            {
                field = ITEM_SPELL;
            }

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result >= 0)
                {
                    item.holding = result;
                    Write_Item(&item);
                }
            }
            
            Display_Item();
        }
        else if (field == PUZZLE_INDEX)
        {
            sprintf(value, "%d", item.holding);
            result = edtval(39, 10, 6, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = PUZZLE_SIZE;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ITEM_SPELL;
            }

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result > 0)
                {
                    item.holding = result;
                    Write_Item(&item);
                }
            }
            
            Display_Item();
        }
        else if (field == PUZZLE_SIZE)
        {
            sprintf(value, "%d", item.ac);
            result = edtval(39, 11, 3, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = PUZZLE_ITEM;
            }
            else if (edtvalc == BAKTAB)
            {
                field = PUZZLE_INDEX;
            }

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result > 0 && result < NUM_ITEMS)
                {
                    item.ac = result;
                    Write_Item(&item);
                }
            }
            
            Display_Item();
        }
        else if (field == PUZZLE_ITEM)
        {
            sprintf(value, "%d", item.bonus);
            result = edtval(39, 12, 6, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ITEM_NUM;
            }
            else if (edtvalc == BAKTAB)
            {
                field = PUZZLE_SIZE;
            }

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result > 0)
                {
                    item.bonus = result;
                    Write_Item(&item);
                }
            }
            
            Display_Item();
        }
        else if (field == ITEM_ROOM)
        {
            sprintf(value, "%d", item.room);
            result = edtval(11, 12, 6, value, validig, MULTIEX);

            if (edtvalc == TAB || edtvalc == CR)
            {
                field = ITEM_NUM;
            }
            else if (edtvalc == BAKTAB)
            {
                field = ITEM_SPELL;
            }

            if (result == 0)
            {
                field = ITEM_NUM;
            }
            else
            {
                result = atoi(value);    
                
                if (result > 0)
                {
                    item.room = result;
                    Write_Item(&item);
                }
                else if (result >= 0 && item.permanant)
                {
                    item.room = result;
                    Write_Item(&item);
                }
            }
            
            Display_Item();
        }
    }
    while (!done);
}
/****************************************************************************
    read a room
*/
int Read_Room(r, room)
int     r;
struct  room_struct *room;
{
    long    lsk;
    int     result;

    fp_room = fopen(ROOM_FILE, RWBC);
    
    if (fp_room == NULL)
    {
        catastro("Cannot locate %s", ROOM_FILE);
    }

    lsk = (long) r * ROOMSIZE;
    fseek(fp_room, lsk, TOP);
    result = fread(room, ROOMSIZE, 1, fp_room);
    fclose(fp_room);

    if (room->invaders != 'Y' && room->invaders != 'N')
    {
        room->invaders = 'Y';

        if (room->town == TRUE)
        {
            room->invaders = 'N';
        }
    }
        
    if (room->town == -1)
    {
        room->town = TRUE;
    }

    return (result);
}
/****************************************************************************
    write a room
*/
void Write_Room(room)
struct  room_struct *room;
{
    long    lsk;

    fp_room = fopen(ROOM_FILE, RWBC);

    lsk = (long) room->id * ROOMSIZE;
    fseek(fp_room, lsk, TOP);
    fwrite(room, ROOMSIZE, 1, fp_room);
    fclose(fp_room);
}
/****************************************************************************
    read an item
*/
int     Read_Item(i, item)
int     i;
struct  item_struct *item;
{
    long    lsk;
    int     result;

    fp_item = fopen(ITEM_FILE, RWBC);
    
    if (fp_item == NULL)
    {
        catastro("Cannot locate %s", ITEM_FILE);
    }

    lsk = (long) i * ITEMSIZE;
    fseek(fp_item, lsk, TOP);
    result = fread(item, ITEMSIZE, 1, fp_item);
    fclose(fp_item);

    return (result);
}
/****************************************************************************
    write an item
*/
void Write_Item(item)
struct  item_struct *item;
{
    long    lsk;

    fp_item = fopen(ITEM_FILE, RWBC);
    
    lsk = (long) item->id * ITEMSIZE;
    fseek(fp_item, lsk, TOP);
    fwrite(item, ITEMSIZE, 1, fp_item);
    fclose(fp_item);
}
/****************************************************************************
    read a monster
*/
int     Read_Critter(c, crit)
int     c;
struct  crit_struct *crit;
{
    long    lsk;
    int     result;

    fp_crit = fopen(MONSTER_FILE, RWBC);
    
    if (fp_crit == NULL)
    {
        catastro("Cannot locate %s", MONSTER_FILE);
    }

    lsk = (long) c * CRIT_SIZE;
    fseek(fp_crit, lsk, TOP);
    result = fread(crit, CRIT_SIZE, 1, fp_crit);
    fclose(fp_crit);

    return (result);
}
/****************************************************************************
    write a monster
*/
void Write_Critter(crit)
struct  crit_struct *crit;
{
    long    lsk;

    fp_crit = fopen(MONSTER_FILE, RWBC);
    
    lsk = (long) crit->which * CRIT_SIZE;
    fseek(fp_crit, lsk, TOP);
    fwrite(crit, CRIT_SIZE, 1, fp_crit);
    fclose(fp_crit);
}
/****************************************************************************
    pad string to the specified length
*/
void Pad_Str(st, len)
char *st;
int  len;
{
    while (strlen(st) < len)
    {
        strcat(str, " ");
    }
}
/****************************************************************************
    sort the spell_info structure (get the spells in the correct indexed
    order - they are listed in order of desireability in the header file.
*/
void Sort_Spell_Info(void)
{
    int     s1;
    int     s2;
    struct  spell_info_struct temp;

    for (s1 = 0; s1 != NUM_SPELLS; ++s1)
    {
        for (s2 = 0; s2 != NUM_SPELLS; ++s2)
        {
            if (spell_info[s1].index < spell_info[s2].index)
            {
                temp = spell_info[s1];
                spell_info[s1] = spell_info[s2];
                spell_info[s2] = temp;
            }
        }
    }
}
/****************************************************************************/
int Room_Report(void)
{
    int     i;
    int     j;
    int     n;
    long    lsk;

    fp_item = fopen(ITEM_FILE, RWBC);
    fp_crit = fopen(MONSTER_FILE, RWBC);
    fp_room = fopen(ROOM_FILE, RWBC);

    if (fp_room == NULL)
    {
        catastro("Cannot locate %s", ROOM_FILE);
    }

    lsk = ROOMSIZE;
    fseek(fp_room, lsk, TOP);
    
    unlink(ROOM_REPORT_FILE);
    fp = fopen(ROOM_REPORT_FILE, "w+");

    do
    {
        n = fread(&a_room, ROOMSIZE, 1, fp_room);

        if (n != 1)
        {
            fclose(fp_room);
            fclose(fp_crit);
            fclose(fp_item);
            fclose(fp);
            DONE;
        }

        fprintf
        (
            fp, 
            "%4d. Encounter Rate: %d Type: %s Trap: %s\n", 
            a_room.id, 
            a_room.enc_chance,
            RoomTypes[a_room.rmtype + 9],
            trap_types[a_room.trap]
        );

        for (i = 0; i != 4; ++i)
        {
            if (a_room.desc[i][0])
            {
                fprintf(fp, "      %s\n", a_room.desc[i]);
            }
        }

        fprintf(fp, "   ");

        if (a_room.exit[0])
        {
            fprintf(fp, "N: %d ", a_room.exit[0]);
        }
        if (a_room.exit[1])
        {
            fprintf(fp, "S: %d ", a_room.exit[1]);
        }
        if (a_room.exit[2])
        {
            fprintf(fp, "E: %d ", a_room.exit[2]);
        }
        if (a_room.exit[3])
        {
            fprintf(fp, "W: %d ", a_room.exit[3]);
        }
        if (a_room.exit[4])
        {
            fprintf(fp, "U: %d ", a_room.exit[4]);
        }
        if (a_room.exit[5])
        {
            fprintf(fp, "D: %d ", a_room.exit[5]);
        }
        if (a_room.exit[6])
        {
            fprintf(fp, "O: %d ", a_room.exit[6]);
        }
        if (a_room.spec_exit.leads_to)
        {
            fprintf(fp, "GO: %d ", a_room.spec_exit.leads_to);
        }
        fprintf(fp, "\n");

        if (a_room.spec_exit.leads_to && a_room.spec_exit.type == CHANT_DOOR)
        {
            fprintf(fp, "   Chant: %s\n", a_room.chant);
        }
        else if 
        (
            a_room.spec_exit.leads_to && 
            a_room.spec_exit.type == SPECIAL_DOOR
        )
        {
            fprintf(fp, "   Special Door Index: %ld\n", a_room.door_index);
        }

        for (i = 0; i != POSSIBLE_MONS; ++i)
        {
            if (a_room.monster_here[i])
            {
                lsk = (long) a_room.monster_here[i] * CRIT_SIZE;
                fseek(fp_crit, lsk, TOP);
                fread(&crit, CRIT_SIZE, 1, fp_crit);
                
                fprintf
                (
                    fp, 
                    "      %4d: %-14s (Lev: %d)\n", 
                    crit.which, 
                    crit.name,
                    crit.Level
                );

                for (j = 0; j != POSSIBLE_MON_ITEM; ++j)
                {
                    if (crit.Item[j])
                    {
                        lsk = (long) crit.Item[j] * ITEMSIZE;
                        fseek(fp_item, lsk, TOP);
                        fread(&item, ITEMSIZE, 1, fp_item);
                        
                        fprintf
                        (
                            fp,
                            "            %4d: ",
                            crit.Item[j]
                        );

                        if (item.adjective[0])
                        {
                            fprintf(fp, "%s ", item.adjective);
                        }

                        fprintf(fp, "%s", item.name);

                        if (item.what == MAGIC_DEV)
                        {
                            fprintf
                            (
                                fp, 
                                " (%s)", 
                                spell_info[item.spell_cast].name
                            );
                        }

                        fprintf(fp, "\n");
                    }
                }
            }
        }
        fprintf(fp, "\n");
    }
    while (n == 1);

    DONE;
}
/****************************************************************************/
int Item_Report(void)
{
    int     mon_result;
    int     result;
    int     n;
    long    lsk;

    fp_crit = fopen(MONSTER_FILE, RWBC);
    fp_item = fopen(ITEM_FILE, RWBC);
    
    if (fp_item == NULL)
    {
        catastro("Cannot locate %s", ITEM_FILE);
    }
    
    lsk = ITEMSIZE;
    fseek(fp_item, lsk, TOP);

    unlink(ITEM_REPORT_FILE);
    fp = fopen(ITEM_REPORT_FILE, "w+");

    do
    {
        result = fread(&item, ITEMSIZE, 1, fp_item);

        if (result != 1)
        {
            fclose(fp_crit);
            fclose(fp_item);
            fclose(fp);
            DONE;
        }

        Write_Report_Item(item.id);

        lsk = CRIT_SIZE;
        fseek(fp_crit, lsk, TOP);

        do
        {
            mon_result = fread(&crit, CRIT_SIZE, 1, fp_crit);

            if (mon_result == 1)
            {
                for (n = 0; n != POSSIBLE_MON_ITEM; ++n)
                {
                    if (crit.Item[n] == item.id)
                    {
                        fprintf(fp, "     ");
                        Write_Report_Monster();
                    }
                }
            }
        }
        while (mon_result == 1);

        fprintf(fp, "\n");
    }
    while (result == 1);

    DONE;
}
/****************************************************************************/
int Monster_Report(void)
{
    int     i;
    long    lsk;
    int     result;

    fp_item = fopen(ITEM_FILE, RWBC);
    fp_crit = fopen(MONSTER_FILE, RWBC);
    
    if (fp_crit == NULL)
    {
        catastro("Cannot locate %s", MONSTER_FILE);
    }
    
    lsk = CRIT_SIZE;
    fseek(fp_crit, lsk, TOP);

    unlink(MONSTER_REPORT_FILE);
    fp = fopen(MONSTER_REPORT_FILE, "w+");

    do
    {
        result = fread(&crit, CRIT_SIZE, 1, fp_crit);
        
        if (result != 1)
        {
            fclose(fp_item);
            fclose(fp_crit);
            fclose(fp);
            DONE;
        }

        Write_Report_Monster();

        if (crit.talk[0])
        {
            fprintf(fp, "     '%s'\n", crit.talk);
        }

        for (i = 0; i != POSSIBLE_MON_ITEM; ++i)
        {
            if (crit.Item[i])
            {
                lsk = (long) crit.Item[i] * ITEMSIZE;
                fseek(fp_item, lsk, TOP);
                fread(&item, ITEMSIZE, 1, fp_item);
                fprintf(fp, "     ");
                Write_Report_Item(crit.Item[i]);
            }
        }
        
        fprintf(fp, "\n");
    }
    while (result == 1);

    DONE;
}
/****************************************************************************
    write out a monster to the report file
*/
void Write_Report_Monster(void)
{

    fprintf
    (
        fp,
        "%4d %-14s %-8s Lev: %3d ", 
        crit.which, 
        crit.name,
        mon_types[crit.what], 
        crit.Level
    );

    if (crit.attacked_vector == JAILED)
    {
        fprintf(fp, "GUARDS ");
    }
    else if (crit.attacked_vector == ADD_EVIL)
    {
        fprintf(fp, "ADDEVIL%d ", crit.evil_pts);
    }
    else if (crit.attacked_vector == MORPH)
    {
        fprintf(fp, "MORPH%d ", crit.morph);
    }
    else if (crit.attacked_vector == AUTO_FLEE)
    {
        fprintf(fp, "FLEES ");
    }


    if (crit.hit_vector == POISONER)
    {
        fprintf(fp, "POISON ");
    }
    else if (crit.hit_vector == STEALER)
    {  
        fprintf(fp, "ROBS ");
    }
    else if (crit.hit_vector == DRAINER)
    {
        fprintf(fp, "DRAINS ");
    }
    else if (crit.hit_vector == PEST)
    {
        fprintf(fp, "PEST ");
    }

    if (crit.talk[0])
    {
        fprintf(fp, "TALKS ");
    }

    if (crit.alg)
    {
        fprintf(fp, "GOOD ");
    }
    else
    {
        fprintf(fp, "EVIL ");
    }

    if (crit.spell_caster)
    {
        fprintf(fp, "CASTS ");
    }

    if (crit.magical)
    {
        fprintf(fp, "MAGICAL ");
    }

    if (crit.blocks)
    {
        fprintf(fp, "BLOCKS ");
    }

    if (crit.magic_immune)
    {
        fprintf(fp, "IMMUNE ");
    }

    if (crit.permanant)
    {
        if (crit.roving)
        {
            fprintf(fp, "ROVER ");
        }
        else 
        {
            fprintf(fp, "PERM(%d) ", crit.loc);
        }
    }

    fprintf(fp, "\n");
}
/****************************************************************************
    Write an item out to the report file
*/
void Write_Report_Item(index)
int  index;
{

    fprintf(fp, "%4d ", index); 

    if (item.article[0])
    {
        fprintf(fp, "%s ", item.article);
    }

    if (item.adjective[0])
    {
        fprintf(fp, "%s ", item.adjective);
    }

    fprintf(fp, "%s", item.name);

    fprintf(fp, " (");

    if (item.item_level && item.what != CONTAINER)
    {
        fprintf(fp, "level %d ", item.item_level);
    }

    if (item.what == ARMOR)
    {
        if (item.which == LITE_ARMOR)
        {
            fprintf(fp, "Non-Metallic ");
        }
        else
        {
            fprintf(fp, "Metallic ");
        }

        fprintf(fp, "Armor");

        if (item.ring_used)
        {
            fprintf
            (
                fp, 
                ", Spell: %s", 
                spell_info[item.spell_cast].name
            );
        }
    }
    else if (item.what == SHIELD)
    {
        if (item.which == LITE_SHIELD)
        {
            fprintf(fp, "Light ");
        }
        else if (item.which == NODROP)
        {
            fprintf(fp, "Strapped ");
        }

        fprintf(fp, "Shield");
        
        if (item.ring_used)
        {
            fprintf
            (
                fp, 
                ", Spell: %s", 
                spell_info[item.spell_cast].name
            );
        }
    }
    else if (WEAPON(item))
    {
        if (item.which == TWOHAND)
        {
            fprintf(fp, "Two-Handed ");
        }
        else if (item.which == LITE_WEP)
        {
            fprintf(fp, "Light ");
        }
        
        if (item.what == BLUNT)
        {
            fprintf(fp, "Blunt Weapon");
        }
        else if (item.what == EDGED)
        {
            fprintf(fp, "Edged Weapon");
        }
        else if (item.what == POLE)
        {
            fprintf(fp, "Pole Weapon");
        }
        else if (item.what == NOHAND)
        {
            fprintf(fp, "Unarmed Combat Aid");
        }
        
        if (item.ring_used)
        {
            fprintf
            (
                fp, 
                ", Spell: %s", 
                spell_info[item.spell_cast].name
            );
        }
    }
    else if (item.what == MAGIC_DEV)
    {
        if (item.which == SKELETON_KEY)
        {
            fprintf(fp, "Key");
        }
        else if (item.which == SPECIAL_KEY)
        {
            fprintf(fp, "Special Key");
        }
        else
        {
            if (item.which == MAGIC_RING)
            {
                fprintf(fp, "Magic Ring");
            }
            else if (item.which == SCROLL)
            {
                fprintf(fp, "Scroll");
            }
            else
            {
                fprintf(fp, "Magic Device");
            }

            fprintf
            (
                fp, 
                ", Spell: %s", 
                spell_info[item.spell_cast].name
            );
        }
    }
    else if (item.what == CASH)
    {
        fprintf(fp, "Cash");
    }
    else if (item.what == JOOLS)
    {
        fprintf(fp, "Jools");
    }
    else if (item.what == TRINKET)
    {
        fprintf(fp, "Trinket");
    }
    else if (item.what == CONTAINER)
    {
        if (item.which == MAGIC_CONT)
        {
            fprintf(fp, "Magic Container");
        }
        else
        {
            fprintf(fp, "Container");
        }
    }
    else if (item.what == TALISMAN)
    {
        fprintf(fp, "Talisman");
    }
    else if (item.what == TRANSPORTER)
    {
        fprintf(fp, "Transporter");
    }
    else if (item.what == AMULET)
    {
        fprintf(fp, "Amulet");
    }
    else if (item.what == PSY_FOCUS)
    {
        fprintf(fp, "Psychic Focus");
    }

    fprintf(fp, ")\n");
}

