#include <header.h>
#include <globals.h>

FILE    *fp;

void EXPORT Reports(void)
{

	if (MY_PORT->status != REPORT_PROMPT)
	{
		prfmsg(MSG1275);
		Set_Prompt(getmsg(MSG1276), REPORT_PROMPT);
	}
	else
	{
		if (sameas(margv[0], "M"))
		{
			Monster_Report();
			prf("Report written to %s\r", MONSTER_REPORT_FILE); 
		}
		else if (sameas(margv[0], "I"))
		{
			Item_Report();
			prf("Report written to %s\r", ITEM_REPORT_FILE);
		}
		else if (sameas(margv[0], "R"))
		{
			Room_Report();
			prf("Report written to %s\r", ROOM_REPORT_FILE);
		}

		GameOp_Menu(0);
	} 
}
/****************************************************************************/
short Room_Report(void)
{
	short   i;
	short   j;
	short   r;

	unlink(ROOM_REPORT_FILE);
	fp = fopen(ROOM_REPORT_FILE, WRITEA);

	if (fp == NULL)
	{
		NOTIFY("ROOM REPORT FILE FAILURE");
		BAD_EXIT;
	}

	lsk = ROOMSIZE;
	fseek(fp_room, lsk, TOP);

	for (r = 1; r != MAX_ROOM; ++r)
	{
		fread(&a_room, ROOMSIZE, 1, fp_room);

		fprintf
		(
			fp,
			"%4d. Encounter Rate: %d Type: %s Trap: %s\n",
			a_room.id,
			a_room.enc_chance,
			room_types[a_room.rmtype + 9],
			trap_types[a_room.trap]
		);

		for (i = 0; i != DESC_LINES; ++i)
		{
			if (a_room.desc[i][0])
			{
				fprintf(fp, "      %s\n", a_room.desc[i]);
			}
		}

		fprintf(fp, "   ");

		if (a_room.exit[0])
		{
			fprintf(fp, "N: %d ", a_room.exit[0]);
		}
		if (a_room.exit[1])
		{
			fprintf(fp, "S: %d ", a_room.exit[1]);
		}
		if (a_room.exit[2])
		{
			fprintf(fp, "E: %d ", a_room.exit[2]);
		}
		if (a_room.exit[3])
		{
			fprintf(fp, "W: %d ", a_room.exit[3]);
		}
		if (a_room.exit[4])
		{
			fprintf(fp, "U: %d ", a_room.exit[4]);
		}
		if (a_room.exit[5])
		{
			fprintf(fp, "D: %d ", a_room.exit[5]);
		}
		if (a_room.exit[6])
		{
			fprintf(fp, "O: %d ", a_room.exit[6]);
		}
		if (a_room.spec_exit.leads_to)
		{
			fprintf
			(
				fp, 
				"GO: %d (FILTER %s)", 
				a_room.spec_exit.leads_to, 
				filters[a_room.spec_exit.filter]
			);
		}
		fprintf(fp, "\n");

		if (a_room.spec_exit.leads_to && a_room.spec_exit.type == CHANT_DOOR)
		{
			fprintf(fp, "   Chant: %s\n", a_room.chant);
		}
		else if 
		(
			a_room.spec_exit.leads_to && 
			a_room.spec_exit.type == SPECIAL_DOOR
		)
		{
			fprintf(fp, "   Special Door Index: %ld\n", a_room.door_index);
		}

		for (i = 0; i != NUM_EXITS; ++i)
		{
			if (a_room.exit[i] < 0 || a_room.exit[i] > globals->maxroom)
			{
				sprintf(str, "Room#%d Bad exit!", a_room.id);
				NOTIFY(str);
			}
		}
			
		if 
		(
			a_room.spec_exit.leads_to < 0 || 
			a_room.spec_exit.leads_to > globals->maxroom
		)
		{
			sprintf(str, "Room#%d Bad exit!", a_room.id);
			NOTIFY(str);
		}

		for (i = 0; i != POSSIBLE_MONS; ++i)
		{
			if (a_room.monster_here[i] > globals->maxmon)
			{
				sprintf
				(
					str, 
					"BAD MON %d IN ROOM %d",
					a_room.monster_here[i],
					a_room.id
				);
				NOTIFY(str);
			}
			else if (a_room.monster_here[i])
			{
				lsk = (MLONG) a_room.monster_here[i] * CRIT_SIZE;
				fseek(fp_crit, lsk, TOP);
				fread(&crit, CRIT_SIZE, 1, fp_crit);
				
				fprintf
				(
					fp, 
					"      %4d: %-14s (Lev: %d)\n", 
					crit.which, 
					crit.plural_name,
					crit.Level
				);

				for (j = 0; j != POSSIBLE_MON_ITEM; ++j)
				{
					if (crit.Item[j] > globals->maxitem || crit.Item[j] < 0)
					{
						sprintf
						(
							str,
							"BAD ITEM %d on MON %d",
							crit.Item[j],
							crit.which
						);
						NOTIFY(str);
					}
					else if (crit.Item[j])
					{
						lsk = (MLONG) crit.Item[j] * ITEMSIZE;
						fseek(fp_item, lsk, TOP);
						fread(&item, ITEMSIZE, 1, fp_item);
						
						fprintf
						(
							fp,
							"            %4d: ",
							crit.Item[j]
						);

						if (item.adjective[0])
						{
							fprintf(fp, "%s ", item.adjective);
						}

						fprintf(fp, "%s", item.name);

						if (item.what == MAGIC_DEV)
						{
							if 
							(
								item.spell_cast >= NUM_SPELLS ||
								item.spell_cast < 0
							)
							{
								sprintf
								(
									str,
									"ITEM %d BAD SPELL %d",
									item.id,
									item.spell_cast
								);
								NOTIFY(str);
							}
							else
							{
								fprintf
								(
									fp, 
									" (%s)", 
									spell_info[item.spell_cast].name
								);
							}
						}

						fprintf(fp, "\n");
					}
				}
			}
		}
		fprintf(fp, "\n");
	}

	fclose(fp);
	DONE;
}
/****************************************************************************/
short Item_Report(void)
{
	short   n;
	short   i;
	short   m;

	unlink(ITEM_REPORT_FILE);
	fp = fopen(ITEM_REPORT_FILE, WRITEA);

	if (fp == NULL)
	{
		NOTIFY("ITEM REPORT FILE FAILURE");
		BAD_EXIT;
	}

	lsk = ITEMSIZE;
	fseek(fp_item, lsk, TOP);

	for (i = 1; i != MAX_ITEM; ++i)
	{
		fread(&item, ITEMSIZE, 1, fp_item);

		Write_Report_Item(i);

		lsk = CRIT_SIZE;
		fseek(fp_crit, lsk, TOP);

		for (m = 1; m != MAX_MONSTER; ++m)
		{
			fread(&crit, CRIT_SIZE, 1, fp_crit);

			for (n = 0; n != POSSIBLE_MON_ITEM; ++n)
			{
				if (crit.Item[n] == item.id)
				{
					fprintf(fp, "     ");
					Write_Report_Monster();
				}
			}
		}
		fprintf(fp, "\n");
	}

	fclose(fp);
	DONE;
}
/****************************************************************************/
short Monster_Report(void)
{
	short   m;
	short   i;

	unlink(MONSTER_REPORT_FILE);
	fp = fopen(MONSTER_REPORT_FILE, WRITEA);
	
	if (fp == NULL)
	{
		NOTIFY("MONSTER REPORT FILE FAILURE");
		BAD_EXIT;
	}

	for (m = 1; m != MAX_MONSTER; ++m)
	{
		lsk = (MLONG) m * CRIT_SIZE;
		fseek(fp_crit, lsk, TOP);
		fread(&crit, CRIT_SIZE, 1, fp_crit);

		Write_Report_Monster();

		if (crit.talk[0])
		{
			fprintf(fp, "     '%s'\n", crit.talk);
		}

		for (i = 0; i != POSSIBLE_MON_ITEM; ++i)
		{
			if (crit.Item[i] > globals->maxitem || crit.Item[i] < 0)
			{
				sprintf
				(
					str,
					"BAD ITEM %d on MON %d",
					crit.Item[i],
					crit.which
				);
				NOTIFY(str);
			}
			else if (crit.Item[i])
			{
				lsk = (MLONG) crit.Item[i] * ITEMSIZE;
				fseek(fp_item, lsk, TOP);
				fread(&item, ITEMSIZE, 1, fp_item);
				fprintf(fp, "     ");
				Write_Report_Item(crit.Item[i]);
			}
		}
		
		fprintf(fp, "\n");
	}

	fclose(fp);
	DONE;
}
/****************************************************************************
	write out a monster to the report file
*/
void Write_Report_Monster(void)
{

	if (crit.what >= MAX_MON_WHAT || crit.what <= 0)
	{
		sprintf
		(
			str,
			"MON %d BAD TYPE %d",
			crit.which,
			crit.what
		);
		NOTIFY(str);
	}
	else
	{
		fprintf
		(
			fp,
			"%4d %-14s %-8s Lev: %3d ", 
			crit.which, 
			crit.plural_name,
			mon_types[crit.what], 
			crit.Level
		);
	}
	
	if (crit.Level < 1 || crit.Level > 10000)
	{
		sprintf
		(
			str,
			"MON %d BAD LEVEL %d?",
			crit.which,
			crit.Level
		);
		NOTIFY(str);
	}

	if (crit.attacked_vector == JAILED)
	{
		fprintf(fp, "GUARDS ");
	}
	else if (crit.attacked_vector == ADD_EVIL)
	{
		fprintf(fp, "EVPTS%d ", crit.evil_pts);
	}
	else if (crit.attacked_vector == MORPH)
	{
		fprintf(fp, "MRPH%d ", crit.morph);
	}
	else if (crit.attacked_vector == AUTO_FLEE)
	{
		fprintf(fp, "FLEE ");
	}
	else if (crit.attacked_vector != 0)
	{
		sprintf
		(
			str,
			"MON %d BAD ATT VECTOR %d",
			crit.which,
			crit.attacked_vector
		);
		NOTIFY(str);
	}

	if (crit.hit_vector == POISONER)
	{
		fprintf(fp, "POISN ");
	}
	else if (crit.hit_vector == STEALER)
	{  
		fprintf(fp, "ROB ");
	}
	else if (crit.hit_vector == DRAINER)
	{
		fprintf(fp, "DRN ");
	}
	else if (crit.hit_vector == PEST)
	{
		fprintf(fp, "PST ");
	}
	else if (crit.hit_vector != 0)
	{
		sprintf
		(
			str,
			"MON %d BAD HIT VECTOR %d",
			crit.which,
			crit.hit_vector
		);
		NOTIFY(str);
	}

	if (crit.talk[0])
	{
		fprintf(fp, "TALK ");
	}

	if (crit.alg)
	{
		fprintf(fp, "GD ");
	}
	else
	{
		fprintf(fp, "EVL ");
	}

	if (crit.spell_caster)
	{
		fprintf(fp, "CAST ");
	}

	if (crit.magical)
	{
		fprintf(fp, "MGIC ");
	}

	if (crit.blocks)
	{
		fprintf(fp, "BLK ");
	}

	if (crit.magic_immune)
	{
		fprintf(fp, "IMMUNE ");
	}

	if (crit.permanant)
	{
		if (crit.roving)
		{
			fprintf(fp, "ROVE ");
		}
		else 
		{
			fprintf(fp, "PERM%d ", crit.loc);
		}
	}

	fprintf(fp, "\n");
}
/****************************************************************************
	Write an item out to the report file
*/
void EXPORT Write_Report_Item(short index)
{

	fprintf(fp, "%4d ", index); 

	if (item.article[0])
	{
		fprintf(fp, "%s ", item.article);
	}

	if (item.adjective[0])
	{
		fprintf(fp, "%s ", item.adjective);
	}

	fprintf(fp, "%s", item.name);

	fprintf(fp, " (");

	if (item.item_level && item.what != CONTAINER)
	{
		fprintf(fp, "LEVEL#%d ", item.item_level);
	}

	if (item.static_item)
	{
		fprintf(fp, "STATIC ");
	}

	if (item.permanant)
	{
		fprintf(fp, "ROOM#%d ", item.room);
	}

	if (item.what == ARMOR)
	{
		if (item.which == LITE_ARMOR)
		{
			fprintf(fp, "Non-Metallic ");
		}
		else
		{
			fprintf(fp, "Metallic ");
		}

		fprintf(fp, "Armor");

		if (item.ring_used)
		{
			fprintf
			(
				fp, 
				", Spell: %s", 
				spell_info[item.spell_cast].name
			);
		}
	}
	else if (item.what == SHIELD)
	{
		if (item.which == LITE_SHIELD)
		{
			fprintf(fp, "Light ");
		}
		else if (item.which == NODROP)
		{
			fprintf(fp, "Strapped ");
		}

		fprintf(fp, "Shield");

		if (item.ring_used)
		{
			fprintf
			(
				fp, 
				", Spell: %s", 
				spell_info[item.spell_cast].name
			);
		}
	}
	else if (WEAPON(item))
	{
		if (item.which == TWOHAND)
		{
			fprintf(fp, "Two-Handed ");
		}
		else if (item.which == LITE_WEP)
		{
			fprintf(fp, "Light ");
		}
		
		if (item.what == BLUNT)
		{
			fprintf(fp, "Blunt Weapon");
		}
		else if (item.what == EDGED)
		{
			fprintf(fp, "Edged Weapon");
		}
		else if (item.what == POLE)
		{
			fprintf(fp, "Pole Weapon");
		}
		else if (item.what == NOHAND)
		{
			fprintf(fp, "Unarmed Combat Aid");
		}

		if (item.ring_used)
		{
			fprintf
			(
				fp, 
				", Spell: %s", 
				spell_info[item.spell_cast].name
			);
		}
	}
	else if (item.what == MAGIC_DEV)
	{
		if (item.which == SKELETON_KEY)
		{
			fprintf(fp, "Key");
		}
		else if (item.which == SPECIAL_KEY)
		{
			fprintf(fp, "Special Key");
		}
		else
		{
			if (item.which == MAGIC_RING)
			{
				fprintf(fp, "Magic Ring");
			}
			else if (item.which == SCROLL)
			{
				fprintf(fp, "Scroll");
			}
			else
			{
				fprintf(fp, "Magic Device");
			}

			fprintf
			(
				fp, 
				", Spell: %s", 
				spell_info[item.spell_cast].name
			);
		}
	}
	else if (item.what == CASH)
	{
		fprintf(fp, "Cash");
	}
	else if (item.what == JOOLS)
	{
		fprintf(fp, "Jools");
	}
	else if (item.what == TRINKET)
	{
		fprintf(fp, "Trinket");
	}
	else if (item.what == CONTAINER)
	{
		if (item.which == MAGIC_CONT)
		{
			fprintf(fp, "Magic Container");
		}
		else
		{
			fprintf(fp, "Container");
		}
	}
	else if (item.what == TALISMAN)
	{
		fprintf(fp, "Talisman");
	}
	else if (item.what == TRANSPORTER)
	{
		fprintf(fp, "Transporter");
	}
	else if (item.what == AMULET)
	{
		fprintf(fp, "Amulet");
	}
	else if (item.what == PSY_FOCUS)
	{
		fprintf(fp, "Psy Focus");
	}

	fprintf(fp, ")\n");
}

