#include <header.h>
#include <globals.h>

/****************************************************************************
	user is talking to the monsters
*/
short EXPORT monster_talk(short m)
{
	short   asleep = find_timer(SLEEP_TIME, MON);

	if (AMON->what == ORACLE)
	{
		Oracle(0);
		DONE;
	}
	
	if (AMON->what == HUNTRESS)
	{
		if (MY_PORT->questing)
		{
			prfmsg(MSG844, me.name);
			BAD_EXIT;
		}

		if (huntress_timer && !me.perm[GAMEOP_PERM])
		{
			prfmsg(MSG845, MY_PORT->quest_mon, huntress_timer);
			BAD_EXIT;
		}

		strcpy(MY_PORT->quest_mon, AMON->name);

		if (AMON->huntress_item)
		{
			MY_PORT->quest_reward = AMON->huntress_item;
		}
		else
		{
			MY_PORT->quest_reward = globals->talindex;
		}
	   
		Huntress(0);
		DONE;
	}
	
	Start_Mon_Name(str, m);

	if (asleep)
	{
		prfmsg(SLEEP1, str);
		DONE;
	}
	
	if (AMON->talk[0] == 0)
	{
		if (AMON->talk_text_file)
		{
			prfmsg(MSG1382, str);
			Print_Text_File("MT", AMON->which);
		}
		else if (RANDOM(3) == 1)
		{
			prfmsg(MSG836, str);
		}
		else if (AMON->alg == 0 || MY_PORT->enemy_mon == m)
		{
			hostile_msg(str);
		}
		else
		{
			friendly_msg(str);
		}
	}
	else
	{
		prfmsg(MSG1297, str, AMON->talk);
	}

	DONE;
}
/****************************************************************************
	user is about to receive a friendly message
*/
void friendly_msg(char *mon)
{
	short   msg;

	msg = RANDOM(24);
	prfmsg(msg + NICE1 - 1, mon, me.name);
}
/****************************************************************************
	user is about to receive a hostile message
*/
void hostile_msg(char *mon)
{
	short   msg;
	
	msg = RANDOM(24);
	prfmsg(msg + MEAN1 - 1, mon, me.name);
}
/****************************************************************************
	the oracle gives clues to item locations... for a price!
*/
short Oracle(short option)
{
	short   i;
	short   m;
	short   spell_num;
	short   count;
	short   tries = 0;
	short   done = FALSE;
	MLONG   cost = (MLONG) me.Psy * globals->oraclegd; 
	
	if (option == 0)
	{
		if (Money() < cost && !me.perm[SUPER_PERM])
		{
			prfmsg(MSSG837);
			BAD_EXIT;
		}

		sprintf(str, getmsg(MSSG838), cost);
		prf(str);
		Set_Prompt(getmsg(MSG839), ORACLE_PROMPT);
		BAD_EXIT;
	}

	if (margc == 0)
	{
		BAD_EXIT;
	}

	spell_num = INUM(margv[0]);

	if (spell_num < 1 || spell_num > NUM_SPELLS)
	{
		for (i = count = 0; i != NUM_SPELLS; ++i)
		{
			if (sameto(margv[0], spell_info[i].name))
			{
				++count;
				spell_num = i;
			}
		}
	}
	else
	{
		--spell_num;
		count = 1;
	}

	if (count > 1 || count == 0)
	{
		prfmsg(MSG840, margv[0]);
		BAD_EXIT;
	}

	do
	{
		++tries;
		m = RANDOM(MAX_MONSTER - 1);
		Read_Critter(m, &crit);

		for (i = 0; i != POSSIBLE_MON_ITEM; ++i)
		{
			if (crit.Item[i])
			{
				Read_Item(crit.Item[i], &item);

				if (item.what == MAGIC_DEV && item.spell_cast == spell_num)
				{
					done = TRUE;
				}
			}
		}
	}
	while (!done && tries < MAX_ORACLE_TRIES);

	if (!me.perm[SUPER_PERM])
	{
		me.gold -= cost;

		if (me.gold < 0)
		{
			me.bank += me.gold;
			me.gold = 0;
		}
	}

	prfmsg(MSG841);

	if (!done)
	{
		prfmsg(MSG842);
	}
	else
	{
		prfmsg(MSG843, spell_info[spell_num].name, crit.plural_name);
	}

	DONE;
}
/****************************************************************************
	the huntress will send you on a quest for a talisman
*/
short Huntress(short option)
{
	struct item_struct *talisman;

	if (option == 0)
	{
		talisman = Create_Item
		(
			MY_PORT->quest_reward, 
			NULL, 
			100, 
			1, 
			FALSE
		);

		prfmsg(MSG846, me.name, talisman->article, talisman->name);
		Set_Prompt(getmsg(MSG847), HUNTRESS_PROMPT);
		DONE;
	}
	
	if (!sameas(margv[0], "y"))
	{
		BAD_EXIT;
	}

	huntress_timer = numopt(NEXTHUNT, -32767, 32767) * 60;
	MY_PORT->questing = TRUE;
	MY_PORT->quests_left = -1;

	New_Huntress_Quest();
	DONE;
}
/****************************************************************************
	what does the huntress want from me?
*/
short Huntress_Quest(void)
{
	short   mins;

	if (!MY_PORT->questing)
	{
		BAD_EXIT;
	}

	if (MY_PORT->quest_type == 0)
	{
		prfmsg(MSG848, MY_PORT->quest_mon);
		return (TRUE);
	}
	else if (MY_PORT->quest_type == KILL_QUEST)
	{
		prfmsg(MSSG849, MY_PORT->quest_thing);
	}
	else
	{
		prf("%s%s\r", getmsg(MSG850), MY_PORT->quest_thing);
	}

	mins = MY_PORT->quest_timer / 60;

	if (mins > 1)
	{
		prfmsg(MSG851, mins);
	}
	else if (mins == 1)
	{
		prfmsg(MSG852);
	}
	else if (mins == 0)
	{
		prfmsg(MSG853);
	}

	return (TRUE);
}
/****************************************************************************
	determine my huntress quest
*/
short EXPORT New_Huntress_Quest(void)
{
	short   tries = 0;
	short   i;
	short   m;
	short   done = FALSE;
	short   huntress_level = 1;
	short   quests = globals->huntqsts;
	struct  item_struct *talisman;

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what == HUNTRESS)
		{
			if (AMON->quests)
			{
				quests = AMON->quests;
			}

			huntress_level = AMON->Level;
		}
	}

	MY_PORT->quest_timer = (globals->huntmins * 60);

	if (MY_PORT->quests_left < 0)
	{
		MY_PORT->quests_left = quests;
	}
	else if (MY_PORT->quests_left == 0)
	{
		talisman = Create_Item
		(
			MY_PORT->quest_reward, 
			NULL, 
			100, 
			huntress_level, 
			FALSE
		);
		talisman->finder = MY_PORT->index;
		
		Give_Me(talisman);
		prfmsg(MSG854, MY_PORT->quest_mon, talisman->article, talisman->name);
		MY_PORT->questing = FALSE;
		sprintf
		(
			str, 
			getmsg(MSG855),
			MY_PORT->quest_mon,
			talisman->article,
			talisman->name,
			me.name
		);
		Message(str, GLOBAL);
		++MY_PORT->quests;
		BAD_EXIT;
	}
	else
	{
		if (MY_PORT->quests_left == 1)
		{
			prfmsg(MSG856);
		}
		else
		{
			prfmsg(MSG857, MY_PORT->quests_left);
		}
	}

	if (RANDOM(2) == 1)
	{
		MY_PORT->quest_type = ITEM_QUEST;
	}
	else
	{
		MY_PORT->quest_type = KILL_QUEST;
	}

	do
	{
		++tries;
		m = RANDOM(MAX_MONSTER - 1);
		Read_Critter(m, &crit);

		if
		(
			crit.Level > Stat_Lev(me.Str) &&
			crit.Level < Stat_Lev(me.Str) * 3 &&
			!crit.permanant
		)
		{
			if (MY_PORT->quest_type == KILL_QUEST)
			{
				done = TRUE;
				Monster_Name(MY_PORT->quest_thing, crit.article, crit.name);
			}
			else
			{
				for (i = 0; i != POSSIBLE_MON_ITEM && !done; ++i)
				{
					if (crit.Item[i] && RANDOM(2) == 1)
					{
						done = TRUE;
						Read_Item(crit.Item[i], &item);

						if (item.what != CASH)
						{
							MY_PORT->quest_thing[0] = 0;
							Cat_Item(MY_PORT->quest_thing, &item);
						}
						else
						{
							MY_PORT->quest_type = KILL_QUEST;
							Monster_Name
							(
								MY_PORT->quest_thing, 
								crit.article, 
								crit.name
							);
						}
					}
				}
			}
		}
	}
	while (!done && tries < MAX_ORACLE_TRIES);

	if (!done)
	{
		prfmsg(MSG858, MY_PORT->quest_mon);
		MY_PORT->questing = FALSE;
		BAD_EXIT;
	}

	prfmsg(MSG859, MY_PORT->quest_mon);
	Huntress_Quest();
	DONE;
}
