#include <header.h>
#include <globals.h>

/****************************************************************************
	append a monster name to the message string
*/
void Monster_Name(char *str, char *article, char *name)
{

	str[0] = 0;

	if (article[0])
	{
		strcat(str, article);
		strcat(str, " ");
	}

	strcat(str, name);
}
/****************************************************************************
	tell me about any available menus
*/
void EXPORT Menu_Notice(void)
{

	if (TYPE == BANK)
	{
		if (me.gold)
		{
			sprintf(str, getmsg(MSG1522), l2as(me.gold));
			Set_Prompt(str, BANK_PROMPT5);
		}
		else
		{
			prfmsg(M1503);
		}
	}
	else if (IN_GUILD)
	{
		prfmsg(M1523);
	}
	else if (TYPE == ACADEMY)
	{
		if (me.Option[NOVICE])
		{
			prfmsg(MSG1585);
		}
		else
		{
			prfmsg(MSG1586);
		}
	}
	else if 
	(
		TYPE == ALCHEMIST ||
		TYPE == ARMORY ||
		TYPE == WEAPONSMITH ||
		TYPE == MERCANTILE
	)
	{
		prfmsg(M1525);
	}
	else if
	(
		ABUF(B)->rm.spec_exit.filter &&
		ABUF(B)->rm.spec_exit.filter <= NUM_SAVED_PLACES - 1 &&
		!sameas(guild->name[ABUF(B)->rm.spec_exit.filter], OPEN_GUILD)
	)
	{
		prfmsg(M1532);
	}
}
/****************************************************************************
	spell target could be guy or monster, find out which
*/
short EXPORT findguy_or_mon
(
	char    *word,
	short   which,
	short   target_type,
	short   *absolute_match
)
{
	short   i;
	short   j;
	short   invis_t;
	short   see_invis_t;

	if (word[0] == 0)
	{
		if (target_type != OFFENSIVE)
		{
			prfmsg(M687);
			BAD_EXIT;
		}

		if (MY_PORT->enemy_mon == -1)
		{
			prfmsg(M688);
			BAD_EXIT;
		}

		return (-(MY_PORT->enemy_mon + 1));
	}

	i = find_guy(word, 0, absolute_match);
	
	if (which == 0)
	{
		j = NOT_FOUND;
	}
	else
	{
		j = find_monster(word, which, 0, absolute_match);
	}

	if ((i == NOT_UNIQUE || j == NOT_UNIQUE) && *absolute_match == 0)
	{
		prfmsg(M167, word);
	}
	else if (i == NOT_FOUND && j == NOT_FOUND)
	{
		prfmsg(M168, word);
	}
	else if (i >= 0 && j >= 0 && *absolute_match == 0)
	{
		prfmsg(M167, word);
	}
	else if (j == NOT_THAT_MANY)
	{
		prfmsg(M169, word);
	}
	else if (i == P && which != 0 && (j < 0 || *absolute_match == ABS_GUY))
	{
		prfmsg(M406);
	}
	else if (j >= 0)
	{
		return(-(j + 1));
	}
	else if (i >= 0)
	{
		invis_t = find_timer(INVISIBLE_TIME, i, -1);

		if (invis_t)
		{
			see_invis_t = find_timer(SEE_INVIS_TIME, ME);
			if (!see_invis_t && !me.perm[SUPER_PERM])
			{
				prfmsg(M168, word);
				BAD_EXIT;
			}
		}

		return(i + 1);
	}

	BAD_EXIT;
}
/****************************************************************************
	targeting a player in a different room (bring and seek)
*/
short find_remote_guy(char *word)
{
	short   i;
	short   matches = 0;
	short   found = -1;
	short   abs_match = 0;

	if (word[0] == 0)
	{
		prfmsg(M588);
		BAD_EXIT;
	}

	for (i = 1; i != NTERMS && !abs_match; ++i)
	{
		if 
		(
			APORT(i)->status && 
			!APORT(i)->announce &&
			sameto(word, APORT(i)->chr.name)
		)
		{
			found = i;
			++matches;

			if (sameas(word, APORT(i)->chr.name))
			{
				matches = 1;
				abs_match = TRUE;
			}
		}
	}

	if (matches > 1)
	{
		prfmsg(M167, word);
	}
	else if (found < 0)
	{
		prfmsg(M689, word);
	}
	else if (found == P)
	{
		prfmsg(M690);
	}
	else
	{
		return (found);
	}

	BAD_EXIT;
}
/***************************************************************************
	return abs value of a non-zero number, or 1 if zero
*/
int POSNUM(char *x)
{
	int     n;

	n = INUM(x);

	if (n == 0)
	{
		n = 1;
	}

	return (n);
}
/***************************************************************************
	determine approximate "level", based on my stats
*/
short EXPORT Approximate_Level(short g)
{
	short   l;
	MLONG   stats = 0;
	short   avg;

	stats += (MLONG) AGUY->Psy;
	stats += (MLONG) AGUY->Int;
	stats += (MLONG) AGUY->Str;
	stats += (MLONG) AGUY->Dex;
	stats += (MLONG) AGUY->Con;

	stats = stats / 5L;
	avg = (short) stats;
	l = Stat_Lev(avg); 

	return (l);
}
/***************************************************************************
	see how many more stats I need for the next level
*/
short Next_Level(void)
{
	MLONG   stats1;
	MLONG   stats2;
	short   diff;

	stats1 = (MLONG) me.Psy;
	stats1 += (MLONG) me.Int;
	stats1 += (MLONG) me.Str;
	stats1 += (MLONG) me.Dex;
	stats1 += (MLONG) me.Con;

	a_mon.Level = Approximate_Level(P);
	Set_Mon_Stats(&a_mon, DO_MINIMUM);
	
	stats2 = a_mon.Psy;
	stats2 += a_mon.Int;
	stats2 += a_mon.Str;
	stats2 += a_mon.Dex;
	stats2 += a_mon.Con;

	diff = (short) stats2 - (short) stats1;

	return (diff);
}
/****************************************************************************
	my sameto()
*/
short same_to(char *sht, char *lng)
{
	short   i;

	for (i = 0; i < strlen(sht) && i < strlen(lng); ++i)
	{
		if (toupper(sht[i]) != toupper(lng[i]))
		{
			return (FALSE);
		}
	}

	return (TRUE);
}
/****************************************************************************
	determine how many votes this player casts
*/
short Voting_Power(short index)
{
	short   votes = 1;

	if 
	(
		index == big_warrior ||
		index == big_sorcerer ||
		index == big_barbarian ||
		index == big_thief ||
		index == big_duelist ||
		index == big_cleric ||
		index == big_mystic
	)
	{
		votes = globals->poobvote;
	}

	return (votes);
}
/****************************************************************************
	see if monster has a focus
*/
short Has_Focus(short m)
{
	short   i;

	if (!AMON->spell_caster)
	{
		BAD_EXIT;
	}

	for (i = 0; i != MAX_MON_ITEM; ++i)
	{
		if (AMON->item_has[i].what == PSY_FOCUS && AMON->item_used[i])
		{
			return (TRUE);
		}
	}

	BAD_EXIT;
}
/****************************************************************************
	determine how much cash I have available
*/
MLONG Money(void)
{
	MLONG   total;

	if (globals->autobank)
	{
		if ((double) me.gold + (double) me.bank <= GCMAXLONG)
		{
			total = me.gold + me.bank;
		}
		else
		{
			total = GCMAXLONG;
		}
	}
	else
	{
		total = me.gold;
	}

	if (total < 0)
	{
		total = 0;
	}

	return (total);
}
/****************************************************************************
	figure out someone's special titles
*/
void Titles(short index, char *greeting)
{
	short   i;
	char    position[LINE_SIZE];
	char    class[LINE_SIZE];
	char    *msg;

	position[0] = 0;
	class[0] = 0;

	for (i = 0; i != NUM_OFFICES; ++i)
	{
		if (index == globals->officers[i])
		{
			if 
			(
				(i == 0 && !ynopt(ACTGUV)) ||
				(i == 1 && !ynopt(ACTPAL)) ||
				(i == 2 && !ynopt(ACTASS)) ||
				(i == 3 && !ynopt(ACTJDG))
			)
			{
				if (index == MY_PORT->index)
				{
					Resign_Office(i);
				}
			}
			else
			{
				strcpy(position, globals->offices[i]);
			}
		}
	}

	if (index == big_warrior)
	{
		strcpy(class, getmsg(BIGWAR));
	}
	else if (index == big_sorcerer)
	{
		strcpy(class, getmsg(BIGSOR));
	}
	else if (index == big_barbarian)
	{
		strcpy(class, getmsg(BIGBAR));
	}
	else if (index == big_thief)
	{
		strcpy(class, getmsg(BIGTHI));
	}
	else if (index == big_duelist)
	{
		strcpy(class, getmsg(BIGDUE));
	}
	else if (index == big_cleric)
	{
		strcpy(class, getmsg(BIGCLE));
	}
	else if (index == big_mystic)
	{
		strcpy(class, getmsg(BIGMYS));
	}

	if (position[0] && class[0])
	{
		msg = getmsg(M392);
		sprintf(greeting, msg, position, class);
	}
	else if (position[0])
	{
		msg = getmsg(M393);
		sprintf(greeting, msg, position);
	}
	else if (class[0])
	{
		msg = getmsg(M394);
		sprintf(greeting, msg, class);
	}
	else
	{
		greeting[0] = 0;
	}
}
/****************************************************************************
	monster has left room for one reason or another, remove him
*/
short Remove_Mon(short m, short dead)
{
	short   old_b = B;
	short   old_p = P;
	short   i;
	short   total;
	short   g;
	short   num_exits = 0;
	short   location;
	short   exit;
	short   slots;
	char    kill_date[DATE_SIZE];
	struct  item_struct *talisman;
	char    *msg;
	MLONG   dmg = AMON->damage;

	ABUF(B)->crit_change = TRUE;

	if 
	(
		dead && 
		!sameas(AMON->plural_name, globals->bounty.plural_name) &&
		AMON->Level > 3
	)
	{
		Read_Critter(AMON->which, &crit);
		crit.last_kill = time(0);
		++crit.kills;
		Write_Critter(&crit);
	}

	if (!dead && invasion->active && AMON->which == invasion->crit)
	{
		for (i = 0; i != MAX_INVASION_ROOMS; ++i)
		{
			if (invasion->room[i] == ABUF(B)->rm.id)
			{
				if (invasion->count[i])
				{
					++invasion->num_left;
					--invasion->count[i];

					if (invasion->count[i] == 0 && i != 0)
					{
						invasion->room[i] = 0;
					}
				}
			}
		}
	}
	else if (dead && invasion->active && AMON->which == invasion->crit)
	{
		for (i = 0; i != MAX_INVASION_ROOMS; ++i)
		{
			if (invasion->room[i] == ABUF(B)->rm.id)
			{
				if (invasion->count[i])
				{
					invasion->duration += numopt(INVASADD, -32767, 32767);
					--invasion->count[i];
					++MY_PORT->invaders;
					++MY_PORT->invader_count;

					if (invasion->count[i] == 0 && i != 0)
					{
						invasion->room[i] = 0;
					}
				}
			}
		}

		if (invasion->num_left == 0)
		{
			for (i = total = 0; i != MAX_INVASION_ROOMS; ++i)
			{
				if (invasion->room[i])
				{
					total += invasion->count[i];
				}
			}

			if (total == 0)
			{
				Read_Critter(invasion->crit, &crit);
				prfmsg(MSG530, crit.name);
		
				TODAY(kill_date);
				msg = getmsg(MSG531);
				sprintf(str, msg, kill_date, me.name, crit.name);
				Write_News(str);

				msg = getmsg(M532);
				sprintf(str, msg, me.name, me.title, crit.name);
				Message(str, GLOBAL);
				invasion->active = FALSE;
				invasion->timer = numopt(BTWNINV, -32767, 32767) * 60;

				for (i = 0; i != NUM_ITEMS; ++i)
				{
					if (me.item[i].what == 0)
					{
						talisman = Create_Item
						(
							globals->talindex, 
							NULL, 
							100, 
							invasion->level, 
							FALSE
						);
						Give_Me(talisman);
						++total;
					}
				}
				
				talisman = Create_Item
				(
					globals->talindex, 
					NULL, 
					100, 
					invasion->level, 
					FALSE
				);
				prfmsg(MSG533, total, talisman->name);
				outprf(MY_PORT->usrnum);
				clrprf();

				i = Remove_Rover();

				if (i)
				{
					sprintf(str, getmsg(MSG827), globals->captive);
					Message(str, GLOBAL);
					prf(str);
				}
			}
		}
	}

	if (!dead && !globals->pursued)
	{
		for (i = 0; i != NUM_EXITS; ++i)
		{
			if (ABUF(B)->rm.exit[i])
			{
				slots = monsters_can_go_to(ABUF(B)->rm.exit[i]);

				if (slots > 0)
				{
					++num_exits;
				}
			}
		}

		if (num_exits)
		{
			do
			{
				exit = RANDOM(NUM_EXITS) - 1;
				location = ABUF(B)->rm.exit[exit];

				slots = monsters_can_go_to(location);

				if (slots <= 0)
				{
					location = 0;
				}
			}
			while (location == 0);
		
			if (AMON->permanant)
			{
				for (i = 0; i != MAX_PERM_MON; ++i)
				{
					if (globals->perm_mon_id[i] == AMON->which)
					{
						globals->perm_mon_loc[i] = location;
						globals->perm_mon_dmg[i] = dmg;
					}
				}
			}

			outprf(MY_PORT->usrnum);
			clrprf();
			Monster_Arrived(AMON->which, location, dmg);
			P = old_p;
			B = old_b;
		}
	}

	for (i = total = 0; i != MAX_ROOM_MON; ++i)
	{
		if (ABUF(B)->mon[i].what)
		{
			++total;
		}
	}

	AMON->what = 0;

	if (m != MAX_ROOM_MON - 1)
	{
		for (i = m + 1; i != MAX_ROOM_MON; ++i)
		{
			ABUF(B)->mon[i - 1] = ABUF(B)->mon[i];
		}
	}

	ABUF(B)->mon[total - 1].what = 0;

	for (g = 0; g != NTERMS; ++g)
	{
		if (ABUF(B)->guy[g])
		{
			if (APORT(g)->enemy_mon == m)
			{
				APORT(g)->enemy_mon = -1;
			}
			else if (APORT(g)->enemy_mon > m)
			{
				--APORT(g)->enemy_mon;
			}
		}
	}

	DONE;
}
/***************************************************************************
	set a monster's stats, given it's level
*/
void Set_Mon_Stats(struct mon_struct *mon, short option)
{
	
	short   i;
	short   done;
	MLONG   max;
	MLONG   lev    = (MLONG) mon->Level - 1L;
	MLONG   base   = 0;
	MLONG   factor = 0;
	MLONG   min    = 5L;
	MLONG   psy, strength, intel, con, dex;
				   
	if (lev > 0)
	{
		for (i = done = 0; i != STAT_LEVELS && !done; ++i)
		{
			if (lev >= stat_level[i].level)
			{
				done = TRUE;
				factor = stat_level[i].factor;
				base = stat_level[i].base;
			}
		}

		if (base == 0)
		{
			factor = lev;
			base = ((MLONG) globals->strtstat / 5L) + 1L;
		}

		if (lev > 2L)
		{
			factor += lev;
			base += lev;
		}

		min = base + factor + 1L;
	}

	base = 0;
	factor = 0;

	for (i = done = 0; i != STAT_LEVELS && !done; ++i)
	{
		if (mon->Level >= stat_level[i].level)
		{
			done = TRUE;
			factor = stat_level[i].factor;
			base = stat_level[i].base;
		}
	}

	if (base == 0)
	{
		factor = (MLONG) mon->Level;
		base = ((MLONG) globals->strtstat / 5L) + 1L;
	}

	if (mon->Level > 2)
	{
		factor += (MLONG) mon->Level;
		base += (MLONG) mon->Level;      
	}

	max = base + factor;

	if (option == DO_RANDOM)
	{
		max = max - min + 1L;

		psy      = min + LRAND(max) - 1L;
		con      = min + LRAND(max) - 1L;
		strength = min + LRAND(max) - 1L;
		dex      = min + LRAND(max) - 1L;
		intel    = min + LRAND(max) - 1L;
	}
	else if (option == NO_RANDOM)
	{
		psy      = max;
		con      = max;
		strength = max;
		dex      = max;
		intel    = max;
	}
	else
	{
		psy      = min;
		con      = min;
		strength = min;
		dex      = min;
		intel    = min;
	}

	if (psy > 32767L)
	{
		psy = 32767L;
	}

	if (con > 32767L)
	{
		con = 32767L;
	}

	if (strength > 32767L)
	{
		strength = 32767L;
	}

	if (dex > 32767L)
	{
		dex = 32767L;
	}

	if (intel > 32767L)
	{
		intel = 32767L;
	}

	mon->Psy = (short) psy;
	mon->Con = (short) con;
	mon->Str = (short) strength;
	mon->Dex = (short) dex;
	mon->Int = (short) intel;
}
/****************************************************************************
	figures a monster's hit and damage pluses based on stats
*/
void Calc_Mon_Bonus
(
	struct  mon_struct *mon,
	short   m,
	MLONG   *bonus,
	MLONG   *wep_hits
)
{
	short   maniac_t;
	short   strong_t;
	short   i;
	short   num_weps = 0;
	short   stat_bonus;
	MLONG   weapon_bonus = 0;
	
	maniac_t = find_timer(MANIA_TIME, MON);
	strong_t = find_timer(STRONG_TIME, MON);

	Compute_Bonus
	(
		&stat_bonus,
		mon->Str, mon->Int, mon->Dex,
		maniac_t, strong_t,
		'x'
	);

	*bonus = stat_bonus;
	*wep_hits = 0L;

	for (i = 0; i != MAX_MON_ITEM; ++i)
	{
		if (mon->item_used[i])
		{
			if (WEAPON(mon->item_has[i]))
			{
				++num_weps;
				weapon_bonus += (MLONG) mon->item_has[i].bonus;
				*wep_hits += (MLONG) mon->item_has[i].Hits;
			}
		}
	}

	if (num_weps)
	{
		weapon_bonus = weapon_bonus / (MLONG) num_weps;
	}

	*bonus += weapon_bonus + ((MLONG) mon->Level / 2L);

	if (mon->what == AWESOME)
	{
		*bonus += *bonus;
	}
}
/****************************************************************************
	figure a users armor class
*/
short Calc_Player_AC(struct charstruct *guy, short g, short option)
{
	short   his_ac = guy->defense;

	if (guy->class == BARBARIAN)
	{
		his_ac += 10;
	}

	if (guy->armor >= 0)
	{
		his_ac += guy->item[guy->armor].ac + guy->item[guy->armor].bonus;
	}

	if (guy->shld >= 0)
	{
		his_ac += guy->item[guy->shld].ac + guy->item[guy->shld].bonus;
		his_ac += guy->shield;
	}

	if (option == FULL_AC)
	{
		if (find_timer(INVULNERABLE_TIME, GUY))
		{
			his_ac += INVULNERABLE_BONUS;
		}
		
		if (find_timer(INVISIBLE_TIME, GUY))
		{
			his_ac += 5;
		}
		
		if (APORT(g)->next_hit == PARRIED)
		{
			his_ac += 10;
		}
		else if (APORT(g)->next_hit == VULNERABLE)
		{
			his_ac -= 20;
		}
	}

	if (his_ac < 0)
	{
		his_ac = 0;
	}

	return (his_ac);
}
/****************************************************************************
	create item and put it in the room or on a monster
*/
struct item_struct *Create_Item
(
	short   i,
	struct  mon_struct *mon,
	short   chance,
	short   destin,
	short   enhanced
)
{
	short   x;
	MLONG   gold;
	short   level;
	MLONG   ltemp;
	MLONG   min_val;
	MLONG   max_val;

	if (i > globals->maxitem)
	{
		sprintf(str, "BAD ITEM: %d on MON: %d", i, mon->which);
		NOTIFY(str);
		i = 1;
	}

	if (i)
	{
		Read_Item(i, &new_item);
		new_item.merc_item = FALSE;
		new_item.finder = -1;
		new_item.id = i;
	}
	else
	{
		if (mon->what != NPC || RANDOM(2) != 1 || mon->Level <= 3)
		{
			BAD_EXIT;
		}

		for (x = 0; x != MAX_MON_ITEM; ++x)
		{
			if (mon->item_has[x].what != 0)
			{
				if (WEAPON(mon->item_has[x]))
				{
					BAD_EXIT;
				}
			}
		}

		setmem(&new_item, ITEMSIZE, 0);
		strcpy(new_item.article, "a");

		if (RANDOM(2) == 1)
		{
			strcpy(new_item.adjective, "dueling");
			strcpy(new_item.name, "sword");
		}
		else
		{
			strcpy(new_item.adjective, "slim");
			strcpy(new_item.name, "dagger");
		}

		new_item.what = EDGED;
	}

	if (destin == TO_MONSTER)
	{
		new_item.permanant = FALSE;
		level = mon->Level;

		if (ABUF(B)->mon[0].permanant)
		{
			chance = 100;
		}

		if (RANDOM(100) > chance)
		{
			BAD_EXIT;
		}

		if (new_item.what == TALISMAN || new_item.which == MAGIC_RING)
		{
			if (RANDOM(100) > chance)
			{
				BAD_EXIT;
			}
		}

		if (enhanced)
		{
			ltemp = ((MLONG) level * (MLONG) globals->itmboost) / 10L; 

			if (ltemp > 32767)
			{
				level = 32767;
			}
			else
			{
				level = (short) ltemp;
			}
		}
		
		if 
		(
			invasion->active && 
			mon->which == invasion->crit &&
			globals->invdtuff <= 3
		)
		{
			new_item.static_item = FALSE;
		}
	}
	else
	{
		level = destin;
	}

	if (new_item.item_level)
	{
		level = new_item.item_level;
	}

	new_item.item_level = level;
	new_item.org_item_level = level;
	min_val = Max_Value(level - 1);
	max_val = Max_Value(level);

	if (new_item.static_item)
	{
		new_item.worth = Set_Value(&new_item);
	}
	else
	{
		if (new_item.what == MAGIC_DEV)
		{
			if (new_item.which == SCROLL || new_item.which == SPECIAL_KEY)
			{
				new_item.uses = 1;
			}
			else if (new_item.which == MAGIC_RING)
			{
				ltemp = ((MLONG) level / 10L) * (MLONG) globals->ringdur;
				ltemp += (60L * 5L);

				if (ltemp > 32767)
				{
					new_item.uses = 32767;
				}
				else
				{
					new_item.uses = (short) ltemp;
				}
			}
			else if (destin == TO_MONSTER && mon->permanant)
			{
				new_item.uses = 100;
			}
			else
			{
				if (level >= 99)
				{
					new_item.uses = 100;
				}
				else
				{
					new_item.uses = level + 1;
				}
			}
		}
		else if (new_item.what == CONTAINER)
		{
			ltemp = (((MLONG) level * 3L) / 4L) * (MLONG) globals->baguses;

			if (ltemp > 32767)
			{
				new_item.uses = 32767;
			}
			else
			{
				new_item.uses = (short) ltemp;
			}
		}
		else if (new_item.what == AMULET || new_item.what == PSY_FOCUS)
		{
			new_item.uses = (level / 2) + 1;
		}
		else if (new_item.what == TRANSPORTER)
		{
			new_item.uses = 1;
		}
		else if (new_item.what == ARMOR)
		{
			new_item.uses = 100;

			if (destin == TO_MONSTER && level < 32000)
			{
				new_item.uses += RANDOM(level);
			}

			new_item.ac = (level / globals->armfactr) + 1;

			if (destin == TO_MONSTER && RANDOM(3) == 1)
			{
				new_item.bonus = level / 10;

				if (new_item.bonus > 9)
				{ 
					new_item.bonus = 9;
				}

				new_item.ac -= new_item.bonus;
			}
			else
			{
				new_item.bonus = 0;
			}
		}
		else if (new_item.what == SHIELD)
		{
			new_item.uses = 100;

			if (destin == TO_MONSTER && level < 32000)
			{
				new_item.uses += RANDOM(level);
			}

			new_item.ac = (level / globals->shdfactr) + 1;

			if (destin == TO_MONSTER && RANDOM(3) == 1)
			{
				new_item.bonus = level / 20;

				if (new_item.bonus > 9)
				{
					new_item.bonus = 9;
				}

				new_item.ac -= new_item.bonus;
			}
			else
			{
				new_item.bonus = 0;
			}
		}
		else if (WEAPON(new_item))
		{
			new_item.uses = 100;

			if (destin == TO_MONSTER && level < 32000)
			{
				new_item.uses += RANDOM(level);
			}
		
			if (destin != TO_MONSTER || level != mon->Level)
			{
				a_mon.Level = level;
				Set_Mon_Stats(&a_mon, NO_RANDOM);
	   
				Set_Mon_Points
				(
					&a_mon.dpts, 
					&a_mon.mpts, 
					a_mon.Str, 
					a_mon.Con, 
					a_mon.Psy
				);
			
				ltemp = (a_mon.dpts / (MLONG) globals->wepfactr) + 1L; 

				if (ltemp > 32767)
				{
					new_item.Hits = 32767;
				}
				else
				{
					new_item.Hits = (short) ltemp;
				}
			}
			else
			{
				ltemp = (mon->dpts / (MLONG) globals->wepfactr) + 1L;
				
				if (ltemp > 32767)
				{
					new_item.Hits = 32767;
				}
				else
				{
					new_item.Hits = (short) ltemp;
				}
			}

			if (destin != TO_MONSTER && new_item.Hits < globals->wephits)
			{
				new_item.Hits = globals->wephits;
			}

			if (destin == TO_MONSTER && (RANDOM(3) == 1 || chance == 100))
			{
				new_item.bonus = level / 10;

				if (new_item.bonus > 9)
				{ 
					new_item.bonus = 9;
				}

				if (new_item.bonus && chance != 100)
				{
					new_item.bonus = RANDOM(new_item.bonus);
				}

				new_item.Hits -= new_item.bonus;
			}
			else
			{
				new_item.bonus = 0;
			}
		}

		if (destin == TO_MONSTER)
		{
			ltemp = (max_val - min_val);
			new_item.worth = min_val + LRAND(ltemp);
		}
		else
		{
			new_item.worth = max_val;
		}

		new_item.worth = Set_Value(&new_item);

		if (new_item.what == CASH)
		{
			gold = (MLONG) level * (MLONG) globals->goldfctr;
			new_item.worth = LRAND(gold) * 2;
		}
		else if
		(
			new_item.what == TRINKET ||
			new_item.what == JOOLS ||
			new_item.what == TALISMAN
		)
		{
			new_item.worth += (new_item.worth * (MLONG) LRAND(10L)) / 10L;
		}
		else if (new_item.what == MAGIC_DEV)
		{
			gold = new_item.worth * (MLONG) spell_info[new_item.spell_cast].pts;
			gold = gold / 10L;
			new_item.worth += gold;
		}
	}

	if (new_item.what == CONTAINER)
	{
		new_item.bag_index = 0;
		new_item.new_bag = FALSE;
	}

	if (destin == TO_MONSTER)
	{
		for (x = 0; x != MAX_MON_ITEM; ++x)
		{
			if (mon->item_has[x].what == 0)
			{
				mon->item_has[x] = new_item;

				if (ARSH(new_item) || WEAPON(new_item))
				{
					mon->item_used[x] = TRUE;
				}
				return(&new_item);
			}
		}
	}

	return(&new_item);
}
/***************************************************************************
	determine an item's weight
*/
MLONG Weight(struct item_struct *item)
{
	MLONG   weight = 0;
	MLONG   hits;
	MLONG   bonus;
	MLONG   ac;

	if (item->what == CASH)
	{
		weight = item->worth;
	}
	else if (item->what == JOOLS)
	{
		weight = item->worth / 10L;
	}
	else if (item->what == ARMOR)
	{
		ac = item->ac;
		bonus = item->bonus;

		weight = (ac + bonus) * globals->armorwgt;

		if (item->which == LITE_ARMOR)
		{
			weight = weight / 3L;
		}
	}
	else if (item->what == SHIELD)
	{
		ac = item->ac;
		bonus = item->bonus;

		weight = (ac + bonus) * globals->shldwgt;

		if (item->which == LITE_SHIELD)
		{
			weight = weight / 2L;
		}
	}
	else if
	(
		item->what == EDGED ||
		item->what == POLE ||
		item->what == BLUNT ||
		item->what == NOHAND
	)
	{
		hits = item->Hits;
		bonus = item->bonus;

		weight = (hits + bonus) * globals->wepwgt;

		if (item->bonus > 0)
		{
			weight = weight / 2L;
		}

		if (item->which != TWOHAND)
		{
			weight = weight / 2L;
		}

		if (item->which == LITE_WEP)
		{
			weight = weight / 2L;
		}
	}
	else if
	(
		item->what == MAGIC_DEV ||
		item->what == TRINKET ||
		item->what == TALISMAN ||
		item->what == TRANSPORTER ||
		item->what == AMULET ||
		item->what == PSY_FOCUS
	)
	{
		weight = globals->miscwgt;
	}
	else if (item->what == CONTAINER)
	{
		weight = globals->miscwgt;

		if (item->which != MAGIC_CONT)
		{
			weight += Weigh_Bag_Contents(item);
		}
	}

	if (weight <= 0)
	{
		weight = 1;
	}

	return (weight);
}
/*****************************************************************************
	set body and magic points
*/
void Set_Guy_Points
(
	short   *dpts,
	short   *mpts,
	short   Str,
	short   Con,
	short   Psy,
	char    class
)
{
	MLONG   temp;
	
	*mpts = globals->basempts + Stat_Lev(Psy) + Psy;

	if (class == SORCERER)
	{
		*mpts = *mpts * 2;

		if (mpts < 0)
		{
			*mpts = 32767;
		}
	}
	else if (class == CLERIC || class == MYSTIC)
	{
		temp = *mpts;
		temp = (temp * 15L) / 10L;

		if (temp > 32767)
		{
			temp = 32767;
		}

		*mpts = (short) temp;
	}

	if (class != BARBARIAN)
	{
		temp = ((MLONG) Str + ((MLONG) Con * 2L));
		temp = (temp * 15L) / 10L;

		if (temp > 32767)
		{
			temp = 32767;
		}

		*dpts = (short) temp;
	}
	else
	{
		temp = ((MLONG) Str + ((MLONG) Con * 2L)) * 2L; 

		if (temp > 32767)
		{
			temp = 32767;
		}

		*dpts = (short) temp;
	}
}
/*****************************************************************************
	set body and magic points
*/
void Set_Mon_Points(MLONG *dpts, MLONG *mpts, short Str, short Con, short Psy)
{
	MLONG   strength = Str;
	MLONG   constitution = Con;
	MLONG   dps;

	*mpts = (MLONG) globals->basempts + (MLONG) Stat_Lev(Psy) + (MLONG) Psy;
	dps = ((strength + (constitution * 2L)) * 15L) / 10L;
	*dpts = dps;
}
/****************************************************************************
	figures combat bonuses based on my attributes
*/
void Compute_Bonus
(
	short   *bonus,
	short   Str,
	short   Int,
	short   Dex,
	short   maniac_t,
	short   strong_t,
	char    class
)
{
	MLONG   bon;
	MLONG   str = Str;
	MLONG   dex = Dex;
	MLONG   intel = Int;
	
	if (strong_t)
	{
		str = str * 2;
	}

	bon = (str + (intel * 2) + dex) / (MLONG) globals->combat;

	if (maniac_t)
	{
		if (class == BARBARIAN)
		{
			bon = (bon * (MLONG) globals->barbbsk) / 10L;
		}
		else
		{
			bon = bon * 2;
		}
	}

	*bonus = (short) bon;
}
/****************************************************************************
	determine an item's max value, based on monster's level
*/
MLONG Max_Value(short l)
{
	MLONG   max;
	MLONG   level = l;

	if (level < 1)
	{
		max = 1;
	}
	else if (level < 5)
	{
		max = (16 * level) - 7;
	}
	else if (level < 30)
	{
		max = (100 * level) - 250;
	}
	else if (level < 60)
	{
		max = (200 * level) - 250;
	}
	else if (level < 90)
	{
		max = (225 * level) - 250;
	}
	else if (level < 120)
	{
		max = (250 * level) - 250;
	}
	else
	{
		max = (300 * level) - 250;
	}

	return (max);
}
/****************************************************************************
	append an item name to the message string
*/
void    Cat_Item(str, item)
char    *str;
struct  item_struct     *item;
{

	if (item->article[0])
	{
		strcat(str, item->article);
	}

	if (item->adjective[0])
	{
		if (item->article[0])
		{
			strcat(str, " ");
		}

		strcat(str, item->adjective);
	}

	if (item->article[0] || item->adjective[0])
	{
		strcat(str, " ");
	}

	strcat(str, item->name);
	strcat(str, "!");
}
/*****************************************************************************
	determine the experience needed based on the stat level
*/
MLONG Calc_Exp_Needed(short level, short is_level)
{
	MLONG   exp = globals->baseexp;
	MLONG   more_exp = globals->baseexp;
	MLONG   cutoff_exp = globals->baseexp;
	short   x;
	short   i;

	if (is_level)
	{
		level = level * globals->statcurv;
	}

	if (level < globals->curvecut)
	{
		for (i = 0; i != level / globals->statcurv; ++i)
		{
			exp = exp * 2;
		}
	}
	else
	{
		for (i = 0; i != globals->curvecut / globals->statcurv; ++i)
		{
			cutoff_exp = cutoff_exp * 2;
		}
		exp = cutoff_exp * (level / globals->curvecut);

		x = level;
		x -= (level / globals->curvecut) * globals->curvecut;

		for (i = 0; i != x / globals->statcurv; ++i)
		{
			more_exp = more_exp * 2;
		}

		exp += more_exp;
	}

	return (exp);
}
/***************************************************************************
	determine level based on a stat
*/
short Stat_Lev(short stat)
{
	short   done = FALSE;
			
	a_mon.Level = 0;

	do
	{
		++a_mon.Level;
		Set_Mon_Stats(&a_mon, DO_MINIMUM);

		if (a_mon.Int > stat || a_mon.Int == 32767)
		{
			done = TRUE;
		}
	}
	while (!done);

	return (a_mon.Level);
}
/****************************************************************************
	see if the user has the requested timer
*/
short find_timer(short t, short g, short m)
{
	short   i;
	short   r = -1;

	if (t == INVISIBLE_TIME)
	{
		r = INVISIBILITY;
	}
	else if (t == MANIA_TIME)
	{
		r = MANIA;
	}
	else if (t == PROTECTED_TIME)
	{
		r = PROTECT;
	}
	else if (t == FLOAT_TIME)
	{
		r = LEVITATE;
	}
	else if (t == INVULNERABLE_TIME)
	{
		r = INVULNERABILITY;
	}
	else if (t == STRONG_TIME)
	{
		r = STRENGTH;
	}
	else if (t == STURDY_TIME)
	{
		r = STURDINESS;
	}
	else if (t == SHIELD_TIME)
	{
		r = MAGIC_SHIELD;
	}
	else if (t == SEE_INVIS_TIME)
	{
		r = SEE_INVISIBLE;
	}
	else if (t == FAST_TIME)
	{
		r = HASTE;
	}
	else if (t == STEALTH_TIME)
	{
		r = STEALTH;
	}

	if (g >= 0)
	{
		if (t == SEE_INVIS_TIME && AGUY->race == ELF)
		{
			return (TRUE);
		}
		else if (t == STURDY_TIME && AGUY->race == DWARF)
		{
			return (TRUE);
		}
		else if 
		(
			t == MANIA_TIME && 
			AGUY->class == BARBARIAN && 
			APORT(g)->berserk
		)
		{
			return (TRUE);
		}

		for (i = 0; i != NUM_GUY_TIMERS; ++i)
		{
			if 
			(
				APORT(g)->misc_type[i] == t &&
				APORT(g)->timer[i]
			)
			{
				return (TRUE);
			}
		}

		return (Find_Ring(r, GUY));
	}
	else if (m >= 0)
	{
		for (i = 0; i != NUM_MON_TIMERS; ++i)
		{
			if (AMON->misc_type[i] == t)
			{
				return (TRUE);
			}
			else if (AMON->misc_type[i] == KO_TIME && t == SLEEP)
			{
				return (TRUE);
			}
		}

		return (Find_Ring(r, MON));
	}

	return (0);
}
/****************************************************************************
	see if the user wears the requested ring
*/
short Find_Ring(short r, short g, short m)
{
	short   i;
	short   count = 0;

	if (g >= 0)
	{
		if 
		(
			AGUY->armor >= 0 &&
			AGUY->item[AGUY->armor].ring_used &&
			AGUY->item[AGUY->armor].spell_cast == r
		)
		{
			++count;
		}

		if 
		(
			AGUY->shld >= 0 &&
			AGUY->item[AGUY->shld].ring_used &&
			AGUY->item[AGUY->shld].spell_cast == r
		)
		{
			++count;
		}

		for (i = 0; i != NUM_ITEMS; ++i)
		{
			if
			(
				AGUY->item[i].what == MAGIC_DEV &&
				AGUY->item[i].which == MAGIC_RING &&
				AGUY->item[i].spell_cast == r &&
				AGUY->item[i].ring_used
			)
			{
				++count;
			}
		}
	}
	else if (m >= 0)
	{
		for (i = 0; i != MAX_MON_ITEM; ++i)
		{
			if
			(
				AMON->item_has[i].what == MAGIC_DEV &&
				AMON->item_has[i].which == MAGIC_RING &&
				AMON->item_has[i].spell_cast == r
			)
			{
				++count;
			}
			else if
			(
				AMON->item_used[i] && 
				AMON->item_has[i].ring_used && 
				(WEAPON(AMON->item_has[i]) || ARSH(AMON->item_has[i])) &&
				AMON->item_has[i].spell_cast == r
			)
			{
				++count;
			}
		}
	}

	return(count);
}
/****************************************************************************
	make requested timer
*/
void Make_A_Timer(short t, short secs, short g, short m, short option)
{
	short   i;
	short   done = FALSE;

	if (g >= 0)
	{
		for (i = 0; i != NUM_GUY_TIMERS && !done; ++i)
		{
			if (APORT(g)->misc_type[i] == t)
			{
				if (option == ADD_ON)
				{
					APORT(g)->timer[i] += secs;
				}
				else
				{
					APORT(g)->timer[i] = secs;
				}

				done = TRUE;
			}
		}

		if (!done)
		{
			for (i = 0; i != NUM_GUY_TIMERS && !done; ++i)
			{
				if (APORT(g)->misc_type[i] == 0)
				{
					APORT(g)->misc_type[i] = t;
					APORT(g)->timer[i] = secs;
					done = TRUE;
				}
			}
		}
	}
	else
	{
		for (i = 0; i != NUM_MON_TIMERS && !done; ++i)
		{
			if (AMON->misc_type[i] == t)
			{
				if (option == ADD_ON)
				{
					AMON->timer[i] += secs;
				}
				else
				{
					AMON->timer[i] = secs;
				}
				done = TRUE;
			}
		}

		if (!done)
		{
			for (i = 0; i != NUM_MON_TIMERS && !done; ++i)
			{
				if (AMON->misc_type[i] == 0)
				{
					AMON->misc_type[i] = t;
					AMON->timer[i] = secs;
					done = TRUE;
				}
			}
		}
	}
}
/****************************************************************************
	calculate the local collective psy
*/
short Local_Psy(short p)
{   
	short   g;
	short   psy;

	psy = APORT(p)->chr.Psy;

	for (g = 0; g != NTERMS; ++g)
	{
		if (g != p && ABUF(B)->guy[g] && APORT(g)->trance)
		{
			psy += AGUY->Psy;
		}
	}

	return (psy);
}
/****************************************************************************
	see if a monster gets bigger
*/
short Morphed(short m, short g)
{
	short   old_level = AMON->Level;
	short   i;
	short   my_level = Approximate_Level(g);
	MLONG   level;

	if (AMON->Level > my_level)
	{
		BAD_EXIT;
	}

	if (AMON->enhanced)
	{
		level = ((MLONG) old_level * (MLONG) globals->itmboost) / 10L;

		if (level > 32767)
		{
			old_level = 32767;
		}
		else
		{
			old_level = (short) level;
		}
	}

	level = (MLONG) my_level * ((MLONG) AMON->morph + LRAND(2L) - 1L);

	if (level > 32767)
	{
		AMON->Level = 32767;
	}
	else
	{
		AMON->Level = (short) level;
	}
	
	if (AMON->Level < 1)
	{
		AMON->Level = 1;
	}
	
	Set_Mon_Stats(AMON, NO_RANDOM);
	Set_Mon_Points
	(
		&AMON->dpts,
		&AMON->mpts,
		AMON->Str,
		AMON->Con,
		AMON->Psy
	);

	for (i = 0; i != MAX_MON_ITEM; ++i)
	{
		if (AMON->item_has[i].what)
		{
			if (AMON->item_has[i].item_level == old_level)
			{
				AMON->item_has[i].what = FALSE;
				AMON->item_used[i] = FALSE;
			
				Create_Item
				(
					AMON->item_has[i].id, 
					AMON, 
					100, 
					TO_MONSTER, 
					AMON->enhanced
				);
			}
		}
	}

	if (bp_mons)
	{
		AMON->dpts = (AMON->dpts * 2L) / 3L;
	}

	return (TRUE);
}
/****************************************************************************
	I'm going to jail
*/
short Jailed(short m)
{
	char    *msg;

	if (AMON->attacked_vector == JAILED)
	{
		if (me.perm[GAMEOP_PERM])
		{
			BAD_EXIT;
		}

		Start_Mon_Name(name, m);
		prfmsg(MSG535, name);
		msg = getmsg(MSG536);
		sprintf(str, msg, me.name, AMON->article, AMON->name);

		if (me.rw >= 0)
		{
			Put_In_Room(&me.item[me.rw]);
			Lose_Item(me.rw);
			prfmsg(MSG537);
		}

		if (me.lw >= 0)
		{
			Put_In_Room(&me.item[me.lw]);
			Lose_Item(me.lw);
			prfmsg(MSG537);
		}

		if (me.shld >= 0)
		{
			Put_In_Room(&me.item[me.shld]);
			Lose_Item(me.shld);
			prfmsg(MSG538);
		}

		if (me.focus >= 0)
		{
			Put_In_Room(&me.item[me.focus]);
			Lose_Item(me.focus);
			prfmsg(MSG538A);
		}

		Message(str, GLOBAL);
		me.location = globals->prison;
		No_Follow();
		move_me_to(globals->prison, CLEAR_OLD);
	}

	DONE;
}
/****************************************************************************
	see if I can attack the specified other player
*/
short Can_Attack_Guy(short g)
{
	short   p;
	short   arena_time;
	short   my_level;
	short   his_level;
	short   diff;

	if (me.perm[GAMEOP_PERM])
	{
		return (TRUE);
	}

	if (TYPE == ARENA)
	{
		for (p = arena_time = 0; p != NTERMS; ++p)
		{
			if (ABUF(B)->guy[p])
			{
				if (APORT(p)->arena_timer > arena_time)
				{
					arena_time = APORT(p)->arena_timer;
				}
			}
		}

		if (arena_time)
		{
			prfmsg(MSG1309, arena_time);
			BAD_EXIT;
		}

		return (TRUE);
	}
   
	if (command == STEAL)
	{
		if (SAFE_AREA)
		{
			prfmsg(M539);
			BAD_EXIT;
		}
	}
	else
	{
		if (SAFE_AREA && !MY_PORT->assassin)
		{
			prfmsg(MSG255);
			BAD_EXIT;
		}
		
		if (SAFE_AREA && MY_PORT->assassin_timer)
		{
			prfmsg(M540, MY_PORT->assassin_timer);
			BAD_EXIT;
		}
	}

	if (globals->outlaws)
	{
		if (me.outlaw != 'Y')
		{
			prfmsg(MSG1286);
			BAD_EXIT;
		}

		if (AGUY->outlaw != 'Y')
		{
			prfmsg(MSG1287);
			BAD_EXIT;
		}
	}

	my_level = Approximate_Level(P);
	his_level = Approximate_Level(g);

	diff = abs(my_level - his_level);

	if (diff > globals->pvplevel || globals->pvplevel == 0)
	{
		if (!MY_PORT->assassin)
		{
			prfmsg(M541);
			BAD_EXIT;
		}
	}

	return (TRUE);
}
/****************************************************************************
	shorten a userid
*/
char *Really_Brief_Userid(userid)
char    *userid;
{

	strcpy(temp_userid, userid);
	temp_userid[9] = 0;
	return (temp_userid);
}
/****************************************************************************
	shorten a userid
*/
char *Brief_Userid(userid)
char    *userid;
{

	strcpy(temp_userid, userid);
	temp_userid[14] = 0;
	return (temp_userid);
}
/****************************************************************************
	append special exit name to string
*/
void cat_spec_ex(str)
char *str;
{

	if (ABUF(B)->rm.spec_exit.article[0])
	{
		strcat(str, ABUF(B)->rm.spec_exit.article);
	}

	if (ABUF(B)->rm.spec_exit.adjective[0])
	{
		if (ABUF(B)->rm.spec_exit.article[0])
		{
			strcat(str, " ");
		}
		strcat(str, ABUF(B)->rm.spec_exit.adjective);
	}

	if 
	(
		ABUF(B)->rm.spec_exit.article[0] || 
		ABUF(B)->rm.spec_exit.adjective[0]
	)
	{
		strcat(str, " ");
	}

	strcat(str, ABUF(B)->rm.spec_exit.descriptor);
	strcat(str, "!");
}
/****************************************************************************
	find the specified monster
*/
short find_monster
(
	char    *monster,
	short   which,
	short   inform,
	short   *absolute_match
)
{
	short   j;
	short   count;
	short   i;
	short   index     = NOT_FOUND;
	short   unique    = 1;
	short   m         = -1;
	short   local_abs = 0;
	char    name1[NAME_LEN];
	char    name2[NAME_LEN];

	for (i = count = 0; i != MAX_ROOM_MON; ++i)
	{
		if (ABUF(B)->mon[i].what && !ABUF(B)->mon[i].hidden)
		{
			setmem(name1, NAME_LEN, 0);
			setmem(name2, NAME_LEN, 0);

			for (j = 0; j != strlen(ABUF(B)->mon[i].name); ++j)
			{
				if (ABUF(B)->mon[i].name[j] == ' ')
				{
					strncpy(name1, ABUF(B)->mon[i].name, j);
					strcpy(name2, &ABUF(B)->mon[i].name[j + 1]);
				}
			}

			if (name1[0] == 0)
			{
				strcpy(name1, ABUF(B)->mon[i].name);
			}

			if (sameas(name1, monster) || sameas(name2, monster))
			{
				++count;
				if (count <= which)
				{
					index = i;
				}
				*absolute_match = ABS_MON;
				++local_abs;
			}
		}
	}

	if (!local_abs)
	{
		for (i = count = 0; i != MAX_ROOM_MON; ++i)
		{
			if (ABUF(B)->mon[i].what && !ABUF(B)->mon[i].hidden)
			{
				setmem(name1, NAME_LEN, 0);
				setmem(name2, NAME_LEN, 0);

				for (j = 0; j != strlen(ABUF(B)->mon[i].name); ++j)
				{
					if (ABUF(B)->mon[i].name[j] == ' ')
					{
						strncpy(name1, ABUF(B)->mon[i].name, j);
						strcpy(name2, &ABUF(B)->mon[i].name[j + 1]);
					}
				}

				if (name1[0] == 0)
				{
					strcpy(name1, ABUF(B)->mon[i].name);
				}

				if (sameto(monster, name1) || sameto(monster, name2))
				{
					if (m < 0)
					{
						m = i;
					}
					else
					{
						if (ABUF(B)->mon[i].which != AMON->which)
						{
							unique = 0;
						}
					}
					++count;
					if (count <= which)
					{
						index = i;
					}
				}
			}
		}
	}

	if (count == 0)
	{
		if (inform)
		{
			prfmsg(M542, monster);
		}
	}
	else if (!unique)
	{
		if (inform)
		{
			prfmsg(M167, monster);
		}
		index = NOT_UNIQUE;
	}
	else if (count < which)
	{
		index = NOT_THAT_MANY;
		if (inform)
		{
			prfmsg(M169, monster);
		}
	}

	return (index);
}
/****************************************************************************
	find the specified player
*/
short find_guy(char *word, short inform, short *absolute_match)
{
	short   g;
	short   found = NOT_FOUND;
	short   matches = 0;
	
	for (g = 0; g != NTERMS && !(*absolute_match); ++g)
	{                                            
		if (ABUF(B)->guy[g] && sameto(word, AGUY->name))
		{
			found = g;
			++matches;

			if (sameas(word, AGUY->name))
			{
				matches = 1;
				*absolute_match = ABS_GUY;
			}
		}
	}

	if (matches > 1)
	{
		if (inform)
		{
			prfmsg(M167, word);
		}

		return (NOT_UNIQUE);
	}

	if (found == NOT_FOUND)
	{
		if (inform)
		{
			prfmsg(M543, word);
		}
	}

	return (found);
}
/****************************************************************************
	guy did an action, increment his timer
*/
void Set_Action_Time(short t)
{
	short   slow_t;
	short   fast_t;

	slow_t = find_timer(SLOW_TIME, ME);
	fast_t = find_timer(FAST_TIME, ME);
	
	if (slow_t)
	{
		t = t * 2;
	}
	
	if (fast_t && t > 1)
	{
		t = t / 2;
	}

	if (MY_PORT->action_timer < t)
	{
		MY_PORT->action_timer = t;
	}
}
/****************************************************************************
	see if it's ok to do a real time action
*/
short action_ok(void)
{
	short   t;
	short   ok = TRUE;
	
	if (MY_PORT->action_timer && !me.perm[ACTION_PERM])
	{
		prfmsg(M544, MY_PORT->action_timer);
		ok = FALSE;
	}
	else
	{
		t = find_timer(SLEEP_TIME, ME);

		if (t)
		{
			prfmsg(MSG310);
			ok = FALSE;
		}
		else
		{
			t = find_timer(KO_TIME, ME);

			if (t)
			{
				prfmsg(MSG311);
				ok = FALSE;
			}
		}
	}

	if (!ok)
	{
		rstrin();
		strncpy(MY_PORT->next_input, input, LINE_LEN - 1);
		MY_PORT->next_input[LINE_LEN - 1] = 0;
	}
	else
	{
		MY_PORT->next_input[0] = 0;
	}

	return (ok);
}
/****************************************************************************
	see if a monster stops me from picking something up
*/
short Blocked(void)
{
	short   m;
	short   invis_t;
	short   see_invis_t;
	short   sleep_t;
	short   blocked;
	short   my_factor;
	short   his_factor;
	short   got_it;
	char    *msg;

	invis_t = find_timer(INVISIBLE_TIME, ME);

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		blocked = FALSE;

		if 
		(
			AMON->what && 
			(AMON->blocks || AMON->pursue_forever) && 
			!AMON->bashed
		)
		{
			see_invis_t = find_timer(SEE_INVIS_TIME, MON);
			sleep_t = find_timer(SLEEP_TIME, MON);

			if (AMON->sees[P] && (!invis_t || see_invis_t))
			{
				if (!sleep_t)
				{
					blocked = TRUE;
				}
			}

			Start_Mon_Name(name, m);

			if (me.perm[SUPER_PERM])
			{
				blocked = FALSE;
			}
			else if (AMON->permanant && !sleep_t)
			{
				blocked = TRUE;
			}
			else if (blocked)
			{
				his_factor = AMON->Dex + RANDOM(AMON->Level * 5);
				my_factor = me.Dex + RANDOM(me.thief * 5);
				got_it = my_factor > his_factor;

				if (got_it)
				{
					if (!AMON->alg && AMON->last_attacker == -1)
					{
						prfmsg(MSG545, name);
						msg = getmsg(MSG546);
						sprintf(str, msg, name, me.name);
						Message(str, LOUD_LOCAL);

						AMON->pursue_forever = TRUE;
						AMON->last_attacker = P;
					}
					
					blocked = FALSE;
				}
			}

			if (blocked)
			{
				if (!AMON->alg)
				{
					AMON->pursue_forever = TRUE;
					AMON->last_attacker = P;
				}

				prfmsg(MSG547, name);
				msg = getmsg(MSG548);
				sprintf(str, msg, name, me.name);
				Message(str, LOUD_LOCAL);

				Set_Action_Time(2);
				Reveal_Me(-1);
				return (TRUE);
			}
		}         
	}

	return (FALSE);
}
/****************************************************************************
	user did something that would cause others to notice him if hidden
*/
short Reveal_Me(short which)
{
	short   sleep_t;
	short   stealthy;
	short   m;
	short   not_seen;
	short   my_factor;
	short   their_factor;
	short   factor;
	short   start, end;

	if (which == -1)
	{
		start = 0;
		end = MAX_ROOM_MON;
	}
	else
	{
		start = which;
		end = which + 1;
	}

	for (m = start, not_seen = 0; m != end; ++m)
	{
		if (AMON->what && !AMON->sees[P])
		{
			++not_seen;
		}
	}

	if (not_seen == 0)
	{
		BAD_EXIT;
	}

	stealthy = find_timer(STEALTH_TIME, ME);

	if (MY_PORT->hidden && !stealthy)
	{
		if (me.thief >= globals->tstealth)
		{
			stealthy = TRUE;
		}
	}

	if (stealthy)
	{
		my_factor = ABUF(B)->rm.cover + me.Int + me.Dex;

		if (me.class == THIEF)
		{
			my_factor += me.thief * 2;
		}
	}
	else
	{
		my_factor = 1;
	}

	for (m = start, their_factor = 0; m != end; ++m)
	{
		sleep_t = find_timer(SLEEP_TIME, MON);
		
		if (AMON->what && !sleep_t)
		{
			their_factor += AMON->Int + AMON->Level;
		}
	}

	for (m = start; m != end; ++m)
	{
		sleep_t = find_timer(SLEEP_TIME, MON);
		
		if (AMON->what && !AMON->sees[P] && !sleep_t)
		{
			factor = their_factor;

			if (AMON->what == AWESOME)
			{
				factor = factor * 3;
			}

			if (RANDOM(factor) > RANDOM(my_factor) || AMON->permanant)
			{
				AMON->sees[P] = TRUE;

				if (stealthy)
				{
					Start_Mon_Name(name, m);
					prfmsg(MSG549, name);
				}
			}
		}
	}

	DONE;
}
/****************************************************************************
	a permanant monster's location has changed, write file
*/
short Update_Perm_Mon(short mon_num, short loc)
{
	short   i;
	short   which = -1;

	for (i = 0; i != MAX_PERM_MON; ++i)
	{
		if (globals->perm_mon_id[i] == mon_num)
		{
			which = i;
		}
	}

	if (which == -1)
	{
		for (i = 0; i != MAX_PERM_MON; ++i)
		{
			if (globals->perm_mon_id[i] == 0)
			{
				which = i;
			}
		}

		if (which == -1)
		{
			BAD_EXIT;
		}
	}

	if (globals->perm_mon_loc[which] == loc)
	{
		BAD_EXIT;
	}

	globals->perm_mon_loc[which] = loc;
	globals->perm_mon_id[which] = mon_num;

	Read_Critter(mon_num, &crit);
	crit.loc = loc;
	Write_Critter(&crit);
	DONE;
}
/****************************************************************************
	a permanant item's location has changed, write file
*/
short Update_Perm_Item(short item_num, short loc)
{
	short   i;
	short   which = -1;

	for (i = 0; i != MAX_PERM_ITEM; ++i)
	{
		if (globals->perm_item_id[i] == item_num)
		{
			which = i;
		}
	}

	if (which == -1)
	{
		for (i = 0; i != MAX_PERM_ITEM; ++i)
		{
			if (globals->perm_item_id[i] == 0)
			{
				which = i;
			}
		}

		if (which == -1)
		{
			BAD_EXIT;
		}
	}

	globals->perm_item_loc[which] = loc;
	globals->perm_item_id[which] = item_num;

	DONE;
}
/*****************************************************************************
	user is performing an attack
*/
short go_attack(short get_word)
{
	short   i;
	short   m;
	short   pts;
	short   index;
	short   action_time;
	short   revealed;
	short   melee = FALSE;
	short   last_spell = MY_PORT->last_spell;

	if (MY_PORT->last_attack == CAST)
	{
		if (me.armor >= 0)
		{
			if (me.item[me.armor].which != LITE_ARMOR)
			{
				BAD_EXIT;
			}
		}

		command = CAST;
		Start_Mon_Name(str, MY_PORT->enemy_mon);
		str[0] = tolower(str[0]);
		prfmsg(MSG1536, spell_info[last_spell].name, str);
		revealed = Make_Magic(last_spell, "finish", MY_PORT->enemy_mon, -1);

		if (revealed)
		{
			pts = spell_info[last_spell].pts;

			if (me.class == CLERIC)
			{
				pts = pts / 2;
			}

			me.magic_used += pts;

			if (me.focus >= 0 && me.item[me.focus].uses <= 0)
			{
				Lose_Item(me.focus);
			}
		}
	}
	else if (MY_PORT->last_attack == USE)
	{
		for (i = 0, index = -1; i != NUM_ITEMS; ++i)
		{
			if 
			(
				me.item[i].what == MAGIC_DEV &&
				me.item[i].spell_cast == last_spell
			)
			{
				if 
				(
					index < 0 || 
					me.item[i].item_level > me.item[index].item_level
				)
				{
					index = i;
				}
			}
		}

		if (index < 0)
		{
			MY_PORT->last_attack = HIT;
			melee = TRUE;
		}
		else
		{
			command = USE;
			Start_Mon_Name(str, MY_PORT->enemy_mon);
			str[0] = tolower(str[0]);
			prfmsg(MSG1537, spell_info[last_spell].name, str);

			revealed = Make_Magic
			(
				last_spell, 
				"finish", 
				MY_PORT->enemy_mon, 
				index
			);

			if (revealed)
			{
				if (!me.item[index].infinite_uses)
				{
					--me.item[index].uses;
	
					if (me.item[index].uses <= 0)
					{
						prfmsg(MSG1091, me.item[index].name);
						Lose_Item(index);
					}
				}

				if (me.focus >= 0 && me.item[me.focus].uses <= 0)
				{
					Lose_Item(me.focus);
				}
			}
		}
	}
	else
	{
		melee = TRUE;
	}

	if (melee)
	{
		if (!get_word)
		{
			Start_Mon_Name(str, MY_PORT->enemy_mon);
			str[0] = tolower(str[0]);
			prfmsg(MSG1535, commands[command], str);
		}

		revealed = attack(get_word);
	}

	if (revealed && MY_PORT->action_timer == 0)
	{
		if (MY_PORT->last_attack == CAST)
		{
			if 
			(
				me.class == SORCERER ||
				me.class == MYSTIC ||
				me.class == CLERIC
			)
			{
				Set_Action_Time(4);
			}
			else
			{
				Set_Action_Time(6);
			}
		}
		else
		{
			action_time = 4;

			if 
			(
				me.lw >= 0 && 
				me.rw >= 0 && 
				me.class != WARRIOR && 
				me.class != DUELIST
			)
			{
				action_time = 6;

				if (me.class == MYSTIC)
				{
					if 
					(
						me.item[me.lw].what == NOHAND && 
						me.item[me.rw].what == NOHAND
					)
					{
						action_time = 4;
					}
				}

				if (me.class == CLERIC)
				{
					if 
					(
						me.item[me.lw].what == BLUNT && 
						me.item[me.rw].what == BLUNT
					)
					{
						action_time = 4;
					}
				}
			}

			Set_Action_Time(action_time);
		}
	}
		
	if (revealed)
	{
		Reveal_Me(-1);
	}

	if (MY_PORT->enemy_mon >= 0)
	{
		m = MY_PORT->enemy_mon;
		
		if (AMON->sees[P])
		{
			AMON->last_attacker = P;
		}
	}

	return (revealed);
}
/****************************************************************************
	newday or just died, restore various stats
*/
void restore_stats(short option)
{
	short   i;

	if (option == TOTAL_RESTORE)
	{
		for (i = 0; i != NUM_GUY_TIMERS; ++i)
		{
			MY_PORT->misc_type[i] = 0;
			MY_PORT->timer[i] = 0;
		}

		me.damaged = 0;
		me.poison_timer = 0;
		me.magic_used = 0;
		me.ftg = 0;
	}

	MY_PORT->action_timer = 0;
	MY_PORT->enemy_mon = -1;
	MY_PORT->berserk = FALSE;

	for (i = 0; i != NTERMS; ++i)
	{
		MY_PORT->follower[i] = 0;
	}
}
/****************************************************************************
	set main prompt for health, hidden and poisoned values
*/
void Set_Main_Prompt(void)
{
	short   float_t;
	short   ftg;
	char    hidden[2];
	char    poisoned[2];

	if (me.poison_timer)
	{
		strcpy(poisoned, "P");
		prfmsg(M550);
	}
	else
	{
		poisoned[0] = 0;
	}

	if (MY_PORT->hidden)
	{
		strcpy(hidden, "H");
	}
	else
	{
		hidden[0] = 0;
	}

	if (ABUF(B)->rm.rmtype == WATER_ROOM && !me.perm[SUPER_PERM])
	{
		float_t = find_timer(FLOAT_TIME, ME);
		
		if (!float_t)
		{
			prfmsg(M551);
		}
	}

	if (ABUF(B)->rm.rmtype == FIRE_ROOM && !me.perm[SUPER_PERM])
	{
		prfmsg(M552);
	}

	if (MY_PORT->last_ftg != me.ftg && me.dpts - me.ftg < 10)
	{
		ftg = TRUE;
	}
	else
	{
		ftg = FALSE;
	}

	if 
	(
		!me.Option[HEALTH_STATUS] ||
		!MY_PORT->show_pts ||
		(MY_PORT->last_bp == me.damaged &&
		 !ftg &&
		 MY_PORT->last_mp == me.magic_used)
	)
	{
		sprintf
		(
			MY_PORT->prompt, 
			globals->main_prompt3, 
			poisoned,
			hidden
		);
	}
	else 
	{
		MY_PORT->last_bp = me.damaged;
		MY_PORT->last_ftg = me.ftg;
		MY_PORT->last_mp = me.magic_used;

		if (!me.damaged)
		{
			sprintf
			(
				MY_PORT->prompt, 
				globals->main_prompt1, 
				me.dpts - me.ftg, 
				me.mpts - me.magic_used, 
				poisoned,
				hidden
			);
		}
		else
		{
			sprintf
			(
				MY_PORT->prompt, 
				globals->main_prompt2, 
				me.dpts - me.damaged, 
				me.dpts - me.ftg, 
				me.mpts - me.magic_used, 
				poisoned,
				hidden
			);
		}
	}

	MY_PORT->status = DO_PROMPT;
	MY_PORT->show_pts = TRUE;
	prf("%s", MY_PORT->prompt);
}
/****************************************************************************
	set someone else's main prompt
*/
short Set_His_Prompt(short g)
{
	short   ftg;
	char    hidden[2];
	char    poisoned[2];

	if (APORT(g)->status != DO_PROMPT)
	{
		DONE;
	}
	
	if (AGUY->poison_timer)
	{
		strcpy(poisoned, "P");
	}
	else
	{
		poisoned[0] = 0;
	}

	if (APORT(g)->hidden)
	{
		strcpy(hidden, "H");
	}
	else
	{
		hidden[0] = 0;
	}

	if (APORT(g)->last_ftg != AGUY->ftg && AGUY->dpts - AGUY->ftg < 10)
	{
		ftg = TRUE;
	}
	else
	{
		ftg = FALSE;
	}

	if 
	(
		!AGUY->Option[HEALTH_STATUS] ||
		!APORT(g)->show_pts || 
		(APORT(g)->last_bp == AGUY->damaged &&
		 !ftg &&
		 APORT(g)->last_mp == AGUY->magic_used)
	)
	{
		sprintf
		(
			APORT(g)->prompt, 
			globals->main_prompt3, 
			poisoned,
			hidden
		);
	}
	else 
	{
		APORT(g)->last_bp = AGUY->damaged;
		APORT(g)->last_ftg = AGUY->ftg;
		APORT(g)->last_mp = AGUY->magic_used;

		if (!AGUY->damaged)
		{
			sprintf
			(
				APORT(g)->prompt, 
				globals->main_prompt1, 
				AGUY->dpts - AGUY->ftg, 
				AGUY->mpts - AGUY->magic_used, 
				poisoned,
				hidden
			);
		}
		else
		{
			sprintf
			(
				APORT(g)->prompt, 
				globals->main_prompt2, 
				AGUY->dpts - AGUY->damaged, 
				AGUY->dpts - AGUY->ftg, 
				AGUY->mpts - AGUY->magic_used, 
				poisoned,
				hidden
			);
		}
	}

	APORT(g)->show_pts = TRUE;
	DONE;
}
/****************************************************************************
	determine/add fatigue for an action;
*/
short Fatigue(short option)
{
	short   x;
	short   mania_t;
	short   float_t;
	short   two_weapons = 0;
	short   combat = 1;

	if (me.rw >= 0 && me.lw >= 0)
	{
		two_weapons = 1;
	}

	if (command == BASH || command == DRAG)
	{
		x = globals->bashftg;
	}
	else if (command == GREATBLOW)
	{
		x = globals->gbftg + two_weapons;
	}
	else if (command == HIT)
	{
		x = globals->hitftg + two_weapons;
	}
	else if (command == PARRY)
	{
		x = two_weapons;
	}
	else
	{
		float_t = find_timer(FLOAT_TIME, ME);
		if (float_t)
		{
			return (TRUE);
		}
		x = globals->moveftg;
		combat = 0;
	}

	mania_t = find_timer(MANIA_TIME, ME);
	if (mania_t)
	{
		x = (x + 1) * 2;
	}

	if (option == NEEDED)
	{
		if (me.dpts - me.ftg >= x || !combat)
		{
			return(TRUE);
		}
		else
		{
			BAD_EXIT;
		}
	}
	else
	{
		me.ftg += x;

		if (me.ftg > me.dpts)
		{
			me.ftg = me.dpts;
		}
	}

	DONE;
}
/***************************************************************************
	random numbers
*/
short RANDOM(short n)
{
	short   val;

	if (n <= 0)
	{
		return (1);
	}

	val = RAND(n) + 1;

	return (val);
}
/***************************************************************************
	long random numbers
*/
MLONG LRAND(MLONG n)
{
	short   x;
	MLONG   y;
	MLONG   val;
	long double  ld;
	long double  sq;

	if (n <= 0)
	{
		return (1L);
	}

	if (n <= 32767)
	{
		x = (short) n;
		val = RAND(x) + 1; 
		return (val);
	}

	ld = n;              
	sq = sqrtl(ld);      

	x = (short) sq;        
	val = RAND(x);       
	y = (MLONG) sq;       
	val = val * y;       
	y = RAND(x);         
	val += y;            
	++val;

	return (val);
}
/***************************************************************************
	display room cover
*/
void Room_Cover(short factor)
{

	if (factor == 0)
	{
		prf(globals->cover1);
	}
	else if (factor <= 25)
	{
		prf(globals->cover2);
	}
	else if (factor < 75)
	{
		prf(globals->cover3);
	}
	else
	{
		prf(globals->cover4);
	}
}
/****************************************************************************
	misc between-commands checking
*/
short Misc_Checks(void)
{
	short   m;
	short   my_level;
	short   changed;

	if (TYPE == ARENA)
	{
		if (MY_PORT->my_bet > Money())
		{
			MY_PORT->my_bet = Money();
		}
	}
	else
	{
		MY_PORT->my_bet = 0;
	}

	if (me.newbie == 3)
	{
		me.newbie = FALSE;
		my_level = Approximate_Level(P); 

		for (m = 1; m != 14; ++m)
		{
			changed = Auto_Quest(m, TRAININIT, my_level);

			if (changed)
			{
				my_level = Approximate_Level(P); 
			}
		}
	}
	else if (me.Option[NOVICE])
	{
		my_level = Approximate_Level(P); 

		for (m = 1; m != 14; ++m)
		{
			changed = Auto_Quest(m, AUTOTRAIN, my_level);
			
			if (changed)
			{
				my_level = Approximate_Level(P); 
			}
		}
	}

	Set_Guy_Points
	(
		&me.dpts,
		&me.mpts,
		me.Str,
		me.Con,
		me.Psy,
		me.class
	);

	if (globals->officers[0] == MY_PORT->index)
	{
		MY_PORT->guv = TRUE;
	}
	else
	{
		MY_PORT->guv = FALSE;
	}
			
	if (globals->officers[1] == MY_PORT->index)
	{
		MY_PORT->paladin = TRUE;
	}
	else
	{
		MY_PORT->paladin = FALSE;
	}

	if (globals->officers[2] == MY_PORT->index)
	{
		MY_PORT->assassin = TRUE;
	}
	else
	{
		MY_PORT->assassin = FALSE;
	}

	if (globals->officers[3] == MY_PORT->index)
	{
		MY_PORT->judge = TRUE;
	}
	else
	{
		MY_PORT->judge = FALSE;
	}

	if (MY_PORT->action_timer || MY_PORT->next_hit == NORMAL)
	{
		BAD_EXIT;
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what)
		{
			if (AMON->hurt_by[P] || AMON->I_hit[P])
			{
				BAD_EXIT;
			}
		}
	}

	MY_PORT->next_hit = NORMAL;
	DONE;
}
/****************************************************************************
	start a string with a monster's name
*/
void Start_Mon_Name(char *str, short m)
{
	short   i;
	short   total;
	short   which;

	for (i = which = total = 0; i != MAX_ROOM_MON; ++i)
	{
		if 
		(
			AMON->which == ABUF(B)->mon[i].which && 
			ABUF(B)->mon[i].what &&
			!AMON->hidden
		)
		{
			if (i <= m)
			{
				++which;
			}
			++total;
		}
	}

	str[0] = 0; 

	if (total > 1)
	{
		sprintf(str, "%s #%d", AMON->name, which);
	}
	else
	{
		if (AMON->article[0])
		{
			strcat(str, "the ");
		}
		strcat(str, AMON->name);
	}

	str[0] = toupper(str[0]);
}
/****************************************************************************
	start a string with a monster's name
*/
void Set_Mon_Name(char *str, short m)
{
	short   i;
	short   total;
	short   which;
	char    temp[LINE_LEN];

	for (i = which = total = 0; i != MAX_ROOM_MON; ++i)
	{
		if 
		(
			AMON->which == ABUF(B)->mon[i].which && 
			ABUF(B)->mon[i].what &&
			!AMON->hidden
		)
		{
			if (i <= m)
			{
				++which;
			}
			++total;
		}
	}

	if (total > 1)
	{
		sprintf(temp, "%s #%d", AMON->name, which);
		strcpy(str, temp);
	}
	else
	{
		if (AMON->article[0])
		{
			strcpy(str, "the ");
		}
		else
		{
			str[0] = 0;
		}

		strcat(str, AMON->name);
	}
}
/****************************************************************************
	brief monster name
*/
void Brief_Mon_Name(char *str, short m)
{
	short   i;
	short   total = 0;
	short   which = 0;

	for (i = 0; i != MAX_ROOM_MON; ++i)
	{
		if 
		(
			AMON->which == ABUF(B)->mon[i].which && 
			ABUF(B)->mon[i].what &&
			!AMON->hidden
		)
		{
			if (i <= m)
			{
				++which;
			}

			++total;
		}
	}

	if (total > 1)
	{
		sprintf(str, "%s #%d", AMON->name, which);
	}
	else
	{
		strcpy(str, AMON->name);
	}
}
/****************************************************************************
	parse the input line for objects, targets, verbs, etc
*/
short Parse_Input(void)
{
	short   i = 2;

	word1[0] = 0;
	which1 = 0;
	word2[0] = 0;
	which2 = 0;
	real_which1 = 0;
	real_which2 = 0;

	if (margc == 1)
	{
		BAD_EXIT;
	}

	strcpy(word1, margv[1]);

	if (margc == 2)
	{
		which1 = 1;
		BAD_EXIT;
	}
	else if (margv[2][0] >= '0' && margv[2][0] <= '9')
	{
		which1 = INUM(margv[2]);
		real_which1 = which1;
		i = 3;
	}
	else
	{
		which1 = 1;
	}

	if (margc <= i)
	{
		BAD_EXIT;
	}

	if
	(
		sameas(margv[i], "from") ||
		sameas(margv[i], "on") ||
		sameas(margv[i], "in") ||
		sameas(margv[i], "into") ||
		sameas(margv[i], "to") ||
		sameas(margv[i], "with") ||
		sameas(margv[i], "at")
	)
	{
		++i;

		if (margc <= i)
		{
			BAD_EXIT;
		}

		strcpy(word2, margv[i]);
		++i;

		if (margc <= i)
		{
			which2 = 1;
		}
		else if (margv[i][0] >= '0' && margv[i][0] <= '9')
		{
			which2 = INUM(margv[i]);
			real_which2 = which2;
		}
		else
		{
			which2 = 1;
		}
	}
	else if (command == DRAG)
	{
		strcpy(word2, margv[i]);
	}

	DONE;
}
/****************************************************************************
	set my non-Do? prompt
*/
void Set_Prompt(char *prompt, short p)
{

	MY_PORT->status = p;
	sprintf(MY_PORT->prompt, "%s%s%s", green, prompt, cyan);
	prf(MY_PORT->prompt);
}
/****************************************************************************
	process an edit input line (numeric short)
*/
void Set_Int(short *field)
{
	if (margc != 0)
	{
		*field = INUM(margv[0]);
		if (margv[0][0] == '-')
		{
			*field = *field * -1;
		}
	}
}
/****************************************************************************
	process an edit input line (numeric long)
*/
void Set_Long(MLONG *field)
{
	if (margc != 0)
	{
		*field = LNUM(margv[0]);
		if (margv[0][0] == '-')
		{
			*field = *field * -1;
		}
	}
}
/****************************************************************************
	process an edit input line (string)
*/
short EXPORT Set_Str(char *field, short max)
{

	if (margc != 0)
	{
		rstrin();
		strncpy(field, input, max);
		field[max - 1] = 0;
	}
	DONE;
}
