#include <header.h>
#include <globals.h>

/****************************************************************************/
void EXPORT Chaos_Server(void)
{
	short   b;
	short   busy = FALSE;
	MLONG   cur_tick;

	usrnum = -1;
	setmbk(mui_cfg);

	ELAPSE(huntress_timer);
	ELAPSE(file_timer);
		
	if (file_timer == 0)
	{
		file_timer = 15 * 60;
		Close_Data_Files();
		Open_Data_Files();
		Check_Validus(FALSE);
	}
	
	ELAPSE(globals->perm_regen_timer);
 
	if (globals->perm_regen_timer == 0)
	{
		globals->perm_regen_timer = numopt(PRMREGEN, -32767, 32767);
		globals->perm_regen_timer = globals->perm_regen_timer * 60;
		Init_Perm_Mon();
	}
	
	ELAPSE(globals->item_regen_timer);
 
	if (globals->item_regen_timer == 0)
	{
		globals->item_regen_timer = numopt(ITMREGEN, -32767, 32767);
		globals->item_regen_timer = globals->item_regen_timer * 60L;
		Init_Items();
	}
	
	Port_Check();
	
	cur_tick = (MLONG) hrtval();

	if (globals->slowtics > 1 && cur_tick - last_tick < globals->slowtics)
	{
		busy = TRUE;
	}

	if (!busy)
	{
		Random_Occurances();
		Check_Rovers();
		Invasion_Check();
		Elapse_Timers();
		
		for (b = 0; b != NTERMS; ++b)
		{
			B = b;

			if (ABUF(B)->in_use)
			{
				if (!SAFE_AREA)
				{
					Monster_Attack();

					if (ABUF(B)->in_use && ABUF(B)->room_timer == 0)
					{
						Encounter(FALSE);

						if (ABUF(B)->rm.id != globals->prison)
						{
							ABUF(B)->room_timer = RANDOM(ABUF(B)->enc_speed);

							if (ABUF(B)->room_timer < 3)
							{
								ABUF(B)->room_timer = 3;
							}
						}
						else
						{
							ABUF(B)->room_timer = 1;
						}
					}
				}
			}
		}
	}

	rtkick(1, Chaos_Server);
	rstmbk();
	last_tick = (MLONG) hrtval();
}
/***************************************************************************
	advance the invasion
*/
void Advance_Invasion(void)
{
	short   captive_room;
	short   move_ok;
	short   mons;
	short   m;
	short   j;
	short   i;
	short   ok;
	short   new_r;
	short   new_r_index;
	short   asleep;
	MLONG   dmg = 0;

	if (invasion->num_left && invasion->count[0] < MAX_ROOM_MON)
	{
		for (j = 0, ok = TRUE; j != NTERMS; ++j)
		{
			if (ABUF(j)->in_use && ABUF(j)->rm.id == invasion->origin)
			{
				ok = FALSE;
			}
		}

		if (ok)
		{
			--invasion->num_left;
			++invasion->count[0];
		}
	}

	for (i = 0; i != MAX_PERM_MON; ++i)
	{
		if (globals->perm_mon_id[i] == globals->rover)
		{
			captive_room = globals->perm_mon_loc[i];
		}
	}

	for (i = 0; i != MAX_INVASION_ROOMS; ++i)
	{
		move_ok = FALSE;

		if (invasion->room[i]) 
		{
			if (i == 0 && invasion->count[0])
			{
				move_ok = TRUE;
			}
			else if (i != 0)
			{
				move_ok = TRUE;
			}

			if (invasion->room[i] == captive_room && invasion->count[i] < 3)
			{
				move_ok = FALSE;
			}
		}

		if (move_ok)
		{
			new_r = Find_Exit(invasion->room[i]);
			new_r_index = -1;

			for (j = 0; j != MAX_INVASION_ROOMS; ++j)
			{
				if (invasion->room[j] == new_r)
				{
					new_r_index = j;
				}
			}

			if (new_r_index == -1)
			{
				for (j = 0; j != MAX_INVASION_ROOMS && new_r_index < 0; ++j)
				{
					if (invasion->room[j] == 0)
					{
						new_r_index = j;
					}
				}
			}
			else if (invasion->count[new_r_index] == MAX_ROOM_MON)
			{
				new_r_index = -1;
			}
			else if (invasion->count[new_r_index] > invasion->count[i])
			{
				new_r_index = -1;
			}
			
			if (new_r_index >= 0 && new_r_index != i)
			{
				for (j = 0; j != NTERMS; ++j)
				{
					if (ABUF(j)->in_use && ABUF(j)->rm.id == new_r)
					{
						B = j;

						for (m = mons = 0; m != MAX_ROOM_MON; ++m)
						{
							if (AMON->what)
							{
								++mons;
							}
						}
					}
				}

				if (mons == MAX_ROOM_MON)
				{
					new_r_index = -1;
				}
			}

			if (new_r_index >= 0 && new_r_index != i)
			{
				for (j = 0, ok = TRUE; j != NTERMS; ++j)
				{
					if 
					(
						ABUF(j)->in_use && 
						ABUF(j)->rm.id == invasion->room[i]
					)
					{
						ok = FALSE;
						B = j;
					}
				}

				if (!ok)
				{
					for (m = 0, ok = FALSE; m != MAX_ROOM_MON && !ok; ++m)
					{
						asleep = find_timer(SLEEP_TIME, MON);

						if 
						(
							AMON->what && 
							!AMON->bashed &&
							AMON->last_attacker == -1 &&
							!asleep && 
							AMON->which == invasion->crit
						)
						{
							dmg = AMON->damage;
							Perm_Left(m);
							ok = TRUE;
						}
					}
				}

				if (ok)
				{
					Monster_Arrived(invasion->crit, new_r, dmg);
					++invasion->count[new_r_index];
					invasion->room[new_r_index] = new_r;

					--invasion->count[i];
					if (invasion->count[i] == 0 && i != 0)
					{
						invasion->room[i] = 0;
					}
				}
			}
		}
	}
}
/***************************************************************************
	start a new invasion
*/
short Start_Invasion(void)
{
	short   manual_invasion = FALSE;
	short   done = FALSE;
	short   i;
	short   tries = 0;
	short   count = 0;
	short   levs = 0;
	short   min_secs;
	short   max_secs;
	short   invdrmin;
	short   invdrmax;
	short   joeodds = numopt(JOEODDS, -32767, 32767);

	do
	{
		invasion->crit = RANDOM(MAX_MONSTER - 1);

		if (globals->next_invader)
		{
			manual_invasion = TRUE;
			invasion->crit = globals->next_invader;
			globals->next_invader = 0;
			tries = 50;
		}

		Read_Critter(invasion->crit, &crit);
		++tries;
	}
	while 
	(
		tries < 50 &&
		(crit.permanant || crit.alg || crit.kills >= globals->extmon)
	);

	if (tries == 50)
	{
		BAD_EXIT;
	}
	
	invasion->origin = Find_Non_Town_Room();

	if (globals->next_invasion_room)
	{
		invasion->origin = globals->next_invasion_room;
		globals->next_invasion_room = 0;
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->status && !APORT(i)->chr.perm[GAMEOP_PERM])
		{                                   
			++count;
			levs += Approximate_Level(i);
		}
	}

	if (count == 0 && globals->invdtuff <= 3 && !manual_invasion)
	{
		BAD_EXIT;
	}

	if (globals->next_invasion_level)
	{
		invasion->level = globals->next_invasion_level;
		globals->next_invasion_level = 0;
	}
	else if (globals->invdtuff == 4 || (manual_invasion && count == 0))
	{
		invasion->level = crit.Level;
	}
	else if (globals->invdtuff == 1)
	{
		levs = levs / count;
		invasion->level = (levs / 2) + RANDOM(levs / 2);
	}
	else if (globals->invdtuff == 2)
	{
		levs = levs / count;
		invasion->level = levs + RANDOM(levs);
	}
	else if (globals->invdtuff == 3)
	{
		levs = levs / count;
		invasion->level = levs + RANDOM(levs) + count;
	}

	invasion->active = TRUE;

	invdrmin = numopt(INVDRMIN, -32767, 32767);
	invdrmax = numopt(INVDRMAX, -32767, 32767);

	if (invdrmax <= invdrmin)
	{
		invdrmax = invdrmin + 1;
	}

	invasion->num_left = RANDOM(invdrmax - invdrmin) + invdrmin;

	if (globals->next_invasion_size)
	{
		invasion->num_left = globals->next_invasion_size;
		globals->next_invasion_size = 0;
	}

	prfmsg(M1, invasion->num_left, crit.plural_name);
	Server_Message(GLOBAL);

	for (i = 0; i != MAX_INVASION_ROOMS; ++i)
	{
		invasion->room[i] = 0;
		invasion->count[i] = 0;
	}

	invasion->room[0] = invasion->origin;
	invasion->count[0] = MAX_ROOM_MON;
	invasion->num_left -= MAX_ROOM_MON;

	min_secs = globals->invasmin * 60;
	max_secs = globals->invasmax * 60;

	if (min_secs > max_secs)
	{
		max_secs = min_secs + 1;
	}

	invasion->timer = globals->invdsecs;
	invasion->duration = min_secs + RANDOM(max_secs - min_secs);

	if (globals->next_invasion_mins)
	{
		invasion->duration = globals->next_invasion_mins * 60;
		globals->next_invasion_mins = 0;
	}

	Remove_Rover();
	
	crit.what = NPC;
	crit.which = globals->rover;

	if (RANDOM(100) < joeodds)
	{
		crit.loc = invasion->origin;
	}
	else
	{
		crit.loc = 0;
	}

	if (globals->next_invasion_heir == 'Y')
	{
		crit.loc = invasion->origin;
	}
	else if (globals->next_invasion_heir == 'N')
	{
		crit.loc = 0;
	}
	globals->next_invasion_heir = 0;

	for (i = 0; i != MAX_PERM_MON; ++i)
	{
		if (globals->perm_mon_id[i] == globals->rover)
		{
			globals->perm_mon_loc[i] = 0;
			globals->perm_mon_id[i] = 0;
			globals->perm_mon_dmg[i] = 0;
		}
	}

	for (i = 0; i != MAX_PERM_MON && !done; ++i)
	{
		if (crit.loc && globals->perm_mon_id[i] == 0)
		{
			globals->perm_mon_loc[i] = crit.loc;
			globals->perm_mon_id[i] = globals->rover;
			globals->perm_mon_dmg[i] = 0; 
			done = TRUE;
		}
	}

	crit.article[0] = 0;
	strcpy(crit.name, globals->captive);
	strcpy(crit.plural_name, crit.name);
	strcat(crit.plural_name, "s");
	crit.Level = RANDOM(300);
	crit.alg = TRUE;
	crit.spell_caster = FALSE;
	crit.magical = FALSE;
	crit.blocks = FALSE;
	crit.permanant = TRUE;
	crit.roving = FALSE;
	crit.attacked_vector = 0;
	strcpy(crit.talk, "Help me!");
	crit.hit_vector = 0;

	for (i = 0; i != POSSIBLE_MON_ITEM; ++i)
	{
		crit.Item[i] = 0;
	}

	Write_Critter(&crit);

	if (crit.loc)
	{
		prfmsg(MSG826, globals->captive);
		Server_Message(GLOBAL);
		globals->captive_safe = FALSE; 
	}
	else
	{
		globals->captive_safe = TRUE;
	}

	globals->captive_timer = 0;
	globals->captive_next_room = 0;

	for (i = 0; i != NUM_CAPTIVE_MOVES; ++i)
	{
		globals->captive_moves[i] = 0;
	}

	for (P = 0; P != NTERMS; ++P)
	{
		MY_PORT->invader_count = 0;
	}

	DONE;
}
/***************************************************************************
	find a room that isn't a town room
*/
short Find_Non_Town_Room(void)
{
	short   n;
	short   i;
	short   exits;
	short   tries = 0;
	short   done;
	short   room_num;

	do
	{
		room_num = RANDOM(globals->maxroom);
		Read_Room(room_num, &a_room, &a_room2);
		
		done = TRUE;
		++tries;
				
		if 
		(
			a_room.invaders == 'N' || 
			a_room.rmtype == DAMAGE_ROOM ||
			a_room.rmtype < 0 || 
			a_room.exit[6] == globals->townsq
		)
		{
			done = FALSE;
		}
		else if 
		(
			room_num == globals->prison || 
			room_num == globals->sanctum || 
			room_num == globals->limboloc ||
			room_num == globals->townsq
		)
		{
			done = FALSE;
		}

		exits = 0;

		if (a_room.spec_exit.leads_to)
		{
			++exits;
		}

		for (i = 0; i != NUM_EXITS; ++i)
		{
			if (a_room.exit[i])
			{
				++exits;
			}
		}

		if (exits < 2)
		{
			done = FALSE;
		}

		for (n = 0; n != MAX_PERM_MON; ++n)
		{
			if (globals->perm_mon_loc[n] == room_num)
			{
				done = FALSE;
			}
		}
	} 
	while (!done && tries < 400);

	if (!done)
	{
		if (globals->last_invasion_room != 0)
		{
			room_num = globals->last_invasion_room;
		}
	}
	else
	{
		globals->last_invasion_room = room_num;
	}

	return (room_num);
}
/***************************************************************************
	see if any weird things happen in the realm
*/
short Random_Occurances(void)
{
	short   bounty;
	short   i;
	short   done = FALSE;
	short   tries = 0;

	ELAPSE(global_timer);

	if (global_timer == 0)
	{
		global_timer = RANDOM(6 * 60) + (6 * 60);
		
		if (!slow_mons && !exp_mons && !bp_mons && RANDOM(3) == 1)
		{
			if (RANDOM(10) == 1)
			{
				slow_mons = TRUE;
				prfmsg(M3);
				Server_Message(GLOBAL);
			}
			else if (RANDOM(10) == 1)
			{
				bp_mons = TRUE;
				prfmsg(M4);
				Server_Message(GLOBAL);
			}
			else if (RANDOM(10) == 1)
			{   
				exp_mons = TRUE;
				prfmsg(M5);
				Server_Message(GLOBAL);
			}
		}
		else if (slow_mons)
		{
			slow_mons = FALSE;
			prfmsg(M6);
			Server_Message(GLOBAL);
		}
		else if (bp_mons)
		{
			bp_mons = FALSE;
			prfmsg(M7);
			Server_Message(GLOBAL);
		}
		else if (exp_mons)
		{
			exp_mons = FALSE;
			prfmsg(M8);
			Server_Message(GLOBAL);
		}
	}

	ELAPSE(globals->bounty_timer);
	
	if (globals->bounty_timer)
	{
		BAD_EXIT;
	}

	globals->bounty_timer = (globals->bntymins * 60);

	if (globals->next_bounty_mins)
	{
		globals->bounty_timer = (globals->next_bounty_mins * 60);
		globals->next_bounty_mins = 0;
	}

	do
	{
		bounty = RANDOM(MAX_MONSTER - 1);

		if (globals->next_bounty)
		{
			bounty = globals->next_bounty;
			globals->next_bounty = 0;
			tries = 50;
		}

		Read_Critter(bounty, &crit);
		++tries;
	}
	while 
	(
		tries < 50 &&
		(crit.permanant || crit.alg)
	);
	
	crit.kills = 0;
	Write_Critter(&crit); 

	globals->bounty = crit;
	prfmsg(M2, crit.plural_name);
	Server_Message(GLOBAL);

	if (!invasion->active)
	{
		crit.which = globals->rover;
		crit.loc = -(Find_Non_Town_Room());

		for (i = 0; i != MAX_PERM_MON; ++i)
		{   
			if (globals->perm_mon_id[i] == globals->rover)
			{
				globals->perm_mon_loc[i] = 0;
				globals->perm_mon_id[i] = 0;
				globals->perm_mon_dmg[i] = 0;
			}
		}

		for (i = 0; i != MAX_PERM_MON && !done; ++i)
		{
			if (globals->perm_mon_id[i] == 0)
			{
				globals->perm_mon_loc[i] = crit.loc;
				globals->perm_mon_id[i] = globals->rover;
				globals->perm_mon_dmg[i] = 0;
				done = TRUE;
			}
		}

		strcpy(crit.article, "the");
		crit.permanant = TRUE;
		crit.roving = TRUE;
		Write_Critter(&crit);
	}

	DONE;
}
/***************************************************************************
	elapse timers
*/
void Elapse_Timers()
{
	short   b;

	for (b = 0; b != NTERMS; ++b)
	{
		B = b;

		if (ABUF(B)->in_use)
		{
			ELAPSE(ABUF(B)->room_timer);
			timers();
		}
	}
}
/******************************************************************************
	move the invasion along
*/
short Invasion_Check(void)
{
	short   i;

	if (!invasion->active)
	{
		ELAPSE(invasion->timer);
		
		if (invasion->timer == 0)
		{
			invasion->timer = numopt(BTWNINV, -32767, 32767) * 60;

			if 
			(
				(globals->invasmax && globals->invasmin) ||
				globals->next_invader
			)
			{
				Start_Invasion();
			}
		}

		BAD_EXIT;
	}

	if (invasion->duration)
	{
		ELAPSE(invasion->duration);
	}
	else
	{
		invasion->active = FALSE;
		invasion->timer = numopt(BTWNINV, -32767, 32767) * 60;

		Read_Critter(invasion->crit, &crit);
		prfmsg(M9, crit.name);
		Server_Message(GLOBAL);
		
		i = Remove_Rover();
		
		if (i)
		{
			prfmsg(MSG827, globals->captive);
			Server_Message(GLOBAL);
		}
		BAD_EXIT;
	}

	if (invasion->timer)
	{
		ELAPSE(invasion->timer);
	}
	else
	{
		Advance_Invasion();
		invasion->timer = globals->invdsecs;
	}

	Move_Captive();

	DONE;
}
/******************************************************************************
	move roving monsters around wrecking havoc and upsetting the populace
*/
short Check_Rovers(void)
{
	short   i;
	short   j;
	short   ok;
	short   m;
	short   mons;
	short   new_loc;
	short   sleep_t;
	short   moved;

	if (globals->rover_timer)
	{
		ELAPSE(globals->rover_timer);
		BAD_EXIT;
	}
		
	globals->rover_timer = globals->rovrsecs;
  
	for (i = 0; i != MAX_PERM_MON; ++i)
	{
		if (globals->perm_mon_loc[i] < 0)
		{
			new_loc = Find_Exit(abs(globals->perm_mon_loc[i])); 
				
			for (j = mons = 0; j != NTERMS; ++j)
			{
				if (ABUF(j)->in_use && ABUF(j)->rm.id == new_loc)
				{
					B = j;
	
					for (m = 0; m != MAX_ROOM_MON; ++m)
					{
						if (AMON->what)
						{
							++mons;
						}
					}
				}
			}

			if 
			(
				mons < MAX_ROOM_MON && 
				new_loc != abs(globals->perm_mon_loc[i])
			)
			{
				for (j = 0, ok = TRUE; j != NTERMS; ++j)
				{
					if 
					(
						ABUF(j)->in_use && 
						ABUF(j)->rm.id == abs(globals->perm_mon_loc[i])
					)
					{
						ok = FALSE;
						B = j;
					}
				}

				if (!ok)
				{
					for (m = 0, ok = FALSE; m != MAX_ROOM_MON && !ok; ++m)
					{
						if 
						(
							AMON->what && 
							AMON->which == globals->perm_mon_id[i]
						)
						{
							sleep_t = find_timer(SLEEP_TIME, MON);
							globals->perm_mon_dmg[i] = AMON->damage;

							if (!AMON->bashed_time && !sleep_t)
							{
								moved = TRUE;
								Perm_Left(m);
								ok = TRUE;
							}
							else
							{
								moved = FALSE;
							}
						}
					}
				}

				if (moved)
				{
					globals->perm_mon_loc[i] = -new_loc; 

					Monster_Arrived
					(
						globals->perm_mon_id[i], 
						abs(globals->perm_mon_loc[i]),
						globals->perm_mon_dmg[i]
					);
				}
			}
		}
	}

	DONE;
}
/******************************************************************************
	the captive tries to follow a player
*/
short Move_Captive(void)
{
	short   move_index = -1;
	short   i;
	short   j;
	short   ok;
	short   m;
	short   mons;

	if (globals->captive_safe)
	{
		BAD_EXIT;
	}

	if (globals->captive_timer)
	{
		ELAPSE(globals->captive_timer);
		BAD_EXIT;
	}

	if (globals->captive_next_room == 0)
	{
		BAD_EXIT;
	}

	for (j = mons = 0; j != NTERMS; ++j)
	{
		if (ABUF(j)->in_use && ABUF(j)->rm.id == globals->captive_next_room)
		{
			B = j;
	
			for (m = 0; m != MAX_ROOM_MON; ++m)
			{
				if (AMON->what)
				{
					++mons;
				}
			}
		}
	}

	if (mons == MAX_ROOM_MON)
	{
		globals->captive_next_room = 0;
		BAD_EXIT;
	}

	for (i = 0; i != MAX_PERM_MON; ++i)
	{
		if 
		(
			globals->perm_mon_id[i] == globals->rover && 
			globals->perm_mon_loc[i]
		)
		{
			for (j = 0; j != MAX_INVASION_ROOMS; ++j)
			{
				if 
				(
					invasion->room[j] == globals->perm_mon_loc[i] &&
					invasion->count[j]
				) 
				{
					globals->captive_next_room = 0;
					BAD_EXIT;
				}
			}

			for (j = 0, ok = TRUE; j != NTERMS; ++j)
			{
				if 
				(
					ABUF(j)->in_use && 
					ABUF(j)->rm.id == globals->perm_mon_loc[i]
				)
				{
					ok = FALSE;
					B = j;
				}
			}

			if (!ok)
			{
				for (m = 0, ok = FALSE; m != MAX_ROOM_MON && !ok; ++m)
				{
					if (AMON->what && AMON->which == globals->perm_mon_id[i])
					{
						globals->perm_mon_dmg[i] = AMON->damage;
						Perm_Left(m);
						ok = TRUE;
					}
				}
			}

			globals->perm_mon_loc[i] = globals->captive_next_room;
			Monster_Arrived
			(
				globals->perm_mon_id[i], 
				globals->perm_mon_loc[i],
				globals->perm_mon_dmg[i]
			);
			globals->captive_timer = globals->captive_speed;
			globals->captive_next_room = 0;

			for (j = ok = 0; j != NUM_CAPTIVE_MOVES && !ok; ++j)
			{
				if 
				(
					globals->captive_moves[j] == globals->perm_mon_loc[i] ||
					globals->captive_moves[j] == 0
				)
				{
					move_index = j;
					ok = TRUE;
				}
			}

			if (move_index != -1)
			{
				globals->captive_moves[move_index] = globals->perm_mon_loc[i];
				
				for (j = move_index + 1; j < NUM_CAPTIVE_MOVES; ++j)
				{
					globals->captive_moves[j] = 0;
				}
			}

			DONE;
		}
	}
	
	for (j = 0; j != NUM_CAPTIVE_MOVES; ++j)
	{
		globals->captive_moves[j] = 0;
	}

	DONE;
}
/****************************************************************************
	find an exit for a roving monster
*/
short Find_Exit(short r)
{
	short   i;
	short   j;
	short   old_r_index = -1;
	short   dir;
	short   room_num;
	short   done = FALSE;
	short   tries = 0;
	short   captive_index;
	
	for (i = 0; i != MAX_INVASION_ROOMS && old_r_index < 0; ++i)
	{
		if (invasion->old_rooms[i].room_num == r)
		{
			old_r_index = i;
		}
	}

	if (old_r_index < 0)
	{
		Read_Room(r, &a_room, &a_room2);
		
		for (i = 1; i != MAX_INVASION_ROOMS; ++i)
		{
			invasion->old_rooms[i - 1] = invasion->old_rooms[i];
		}
			
		invasion->old_rooms[MAX_INVASION_ROOMS - 1].room_num = r;

		for (i = 0; i != NUM_EXITS; ++i)
		{
			invasion->old_rooms[MAX_INVASION_ROOMS - 1].exit[i] =
				a_room.exit[i];
		}

		invasion->old_rooms[MAX_INVASION_ROOMS - 1].exit[NUM_EXITS] =
			a_room.spec_exit.leads_to;
	}
	else
	{
		for (i = 0; i != NUM_EXITS; ++i)
		{
			a_room.exit[i] = invasion->old_rooms[old_r_index].exit[i];
		}

		a_room.spec_exit.leads_to = 
			invasion->old_rooms[old_r_index].exit[NUM_EXITS];
	}
		
	room_num = -1;
	captive_index = -1;

	if (invasion->active && !globals->captive_safe)
	{
		for (i = 0; i != NUM_CAPTIVE_MOVES; ++i)
		{
			if (globals->captive_moves[i])
			{
				if (a_room.spec_exit.leads_to == globals->captive_moves[i])
				{
					captive_index = i;
				}
				else
				{
					for (j = 0; j != NUM_EXITS; ++j)
					{
						if (a_room.exit[j] == globals->captive_moves[i])
						{
							captive_index = i;
						}
					}
				}
			}
		}
	}

	if (captive_index >= 0)
	{
		Read_Room
		(
			globals->captive_moves[captive_index], 
			&globals->next_room, 
			&a_room2
		);

		if (!SAFE_HAVEN)
		{
			return (globals->captive_moves[captive_index]);
		}
	}

	if (a_room.spec_exit.leads_to == 0)
	{
		for (i = dir = 0; i != NUM_EXITS; ++i)
		{
			if (a_room.exit[i])
			{
				++dir;
			}
		}

		if (dir == 0)
		{
			return (r);
		}
	}

	do
	{
		dir = RANDOM(8) - 1;

		if (dir == 7)
		{
			if (a_room.spec_exit.leads_to)
			{
				++tries;
				done = TRUE;
				room_num = a_room.spec_exit.leads_to;

				Read_Room(room_num, &globals->next_room, &a_room2);
				if 
				(
					SAFE_HAVEN || 
					globals->next_room.rmtype == DAMAGE_ROOM ||
					globals->next_room.invaders == 'N'
				)
				{
					done = FALSE;
				}
			}
		}
		else if (a_room.exit[dir])
		{
			++tries;
			done = TRUE;
			room_num = a_room.exit[dir];

			Read_Room(room_num, &globals->next_room, &a_room2);
			if 
			(
				SAFE_HAVEN || 
				globals->next_room.rmtype == DAMAGE_ROOM ||
				globals->next_room.invaders == 'N'
			)
			{
				done = FALSE;
			}
		}
	} 
	while (!done && tries < 20);

	if (!done)
	{
		room_num = r;
	}

	return (room_num);
}
/****************************************************************************
	put roving monster into a room, inform any players therein
*/
short Monster_Arrived(short which, short where, MLONG dmg)
{ 
	short   guys = 0;
	short   i;
	short   t;
	short   m = 0;
	char    rescue_date[DATE_SIZE];

	for (B = 0; B != NTERMS; ++B)
	{
		if (ABUF(B)->in_use && ABUF(B)->rm.id == where)
		{
			while (m != MAX_ROOM_MON && AMON->what)
			{
				++m;
			}

			if (m == MAX_ROOM_MON)
			{
				BAD_EXIT;
			}
			else
			{
				Read_Critter(which, &crit);

				if (invasion->active && which == invasion->crit)
				{
					crit.Level = invasion->level;
					
					if (crit.hit_vector == 0 || crit.hit_vector == PEST)
					{
						crit.hit_vector = STEALER;
					}

					if 
					(
						crit.attacked_vector == JAILED || 
						crit.attacked_vector == ADD_EVIL
					)
					{
						crit.attacked_vector = 0;
					}
				}

				setmem(AMON, MON_SIZE, 0);
				memcpy(AMON, &crit, CRIT_SIZE);

				AMON->last_attacker = -1;
				AMON->summoned_by = -1;
				AMON->damage = dmg; 

				for (i = 1; i != NTERMS; ++i)
				{
					t = find_timer(INVISIBLE_TIME, i, -1);

					if (AMON->permanant)
					{
						AMON->sees[i] = TRUE;
					}
					else if (!APORT(i)->hidden && !t)
					{
						AMON->sees[i] = TRUE;
					}
				}

				Set_Mon_Stats(AMON, NO_RANDOM);

				Set_Mon_Points
				(
					&AMON->dpts,
					&AMON->mpts,
					AMON->Str,
					AMON->Con,
					AMON->Psy
				);

				for (i = 0; i != NUM_SPELLS; ++i)
				{
					if (AMON->spell_caster)
					{
						AMON->spell[i] = TRUE;
					}
				}

				for (i = 0; i != POSSIBLE_MON_ITEM; ++i)
				{
					if (AMON->Item[i])
					{
						Create_Item
						(
							AMON->Item[i], 
							AMON, 
							100, 
							TO_MONSTER, 
							TRUE
						);
					}
				}

				if (bp_mons)
				{
					AMON->dpts = (AMON->dpts * 2L) / 3L;
				}

				Monster_Name(name, AMON->article, AMON->name);
				name[0] = toupper(name[0]);
				prfmsg(MSG10, name);
				Server_Message(LOUD_LOCAL);

				AMON->action_timer = 2;
				AMON->enhanced = TRUE;

				if 
				(
					AMON->which == globals->rover && 
					invasion->active &&
					SAFE_AREA
				)
				{
					globals->captive_safe = TRUE;

					for (i = 0; i != NTERMS; ++i)
					{   
						if 
						(
							ABUF(B)->guy[i] &&
							APORT(i)->invader_count >= globals->joekill2  
						)
						{
							++guys;
						}
					}

					P = -1;
					prfmsg(MSG831, globals->captive);
					Server_Message(GLOBAL);

					for (i = 0; i != NTERMS; ++i)
					{
						if 
						(
							ABUF(B)->guy[i] && 
							APORT(i)->invader_count >= globals->joekill2
						)
						{
							Give_Experience_From_Kill(m, i, guys);

							if 
							(
								!APORT(i)->chr.perm[GAMEOP_PERM] || 
								ynopt(SYSNEWS)
							)
							{
								TODAY(rescue_date);
								sprintf
								(
									str, 
									getmsg(MSG1346), 
									rescue_date, 
									APORT(i)->chr.name, 
									APORT(i)->chr.title,
									globals->captive
								);
								Write_News(str);
							}
						}
					}
				}
			}
		}
	}

	return (TRUE);
}
/****************************************************************************
	check ports to see if anyone has fallen asleep
*/
void Port_Check(void)
{
	short   i;
	MLONG   mins;
	MLONG   secs;

	for (P = 0; P != NTERMS; ++P)
	{
		if (MY_PORT->status)
		{
			ELAPSE(MY_PORT->arena_timer);
			++MY_PORT->secs_on;
			++me.secs_today;
			++secs_today;

			if (globals->daymins && !me.perm[GAMEOP_PERM])
			{
				secs = globals->daymins * 60;
				secs -= me.secs_today;

				if (secs <= 60 && !MY_PORT->warn_1)
				{
					prfmsg(MSG1302);
					Server_Message(P);
					MY_PORT->warn_1 = TRUE;
					MY_PORT->warn_5 = TRUE;
				}
				else if (secs <= (60 * 5) && !MY_PORT->warn_5)
				{
					prfmsg(MSG1301);
					Server_Message(P);
					MY_PORT->warn_5 = TRUE;
				}
			}
		}

		if (MY_PORT->hung_up && MY_PORT->status)
		{
			Day_Out();
			
			for (B = 0; B != NTERMS; ++B)
			{
				if (ABUF(B)->guy[P])
				{
					lose_player();
				}
			}

			if (!MY_PORT->zapped)
			{
				for (i = 0; i != NUM_OFFICES; ++i)
				{
					mins = MY_PORT->secs_on / 60;
					me.vote_mins[i] += (short) mins;
				}

				if (MY_PORT->limbo_return)
				{
					me.location = MY_PORT->limbo_return;
				}

				Write_Him(P);
			}

			if (P)
			{
				prfmsg
				(
					MSG11,
					P,
					Brief_Userid(MY_PORT->chr.Userid),
					MY_PORT->chr.name
				);

				Server_Message(GLOBAL);
			}

			MY_PORT->status = 0;
		}
		else if (MY_PORT->status && MY_PORT->questing)
		{
			ELAPSE(MY_PORT->quest_timer);

			if (MY_PORT->quest_timer == 0)
			{
				MY_PORT->questing = FALSE;
				prfmsg(MSSG12, MY_PORT->quest_mon);
				Server_Message(P);
			}
		}
	}
}
/****************************************************************************
	user is gone, clean up after guy
*/
void lose_player(void)
{
	short   m;
	short   g;
	short   i;
	short   in_use = FALSE;
	short   mad_mon[MAX_ROOM_MON];

	ABUF(B)->guy[P] = FALSE;

	for (g = 0; g != NTERMS; ++g)
	{
		if (ABUF(B)->guy[g])
		{
			in_use = TRUE;
		}
	}

	if (in_use)
	{
		for (m = MAX_ROOM_MON - 1; m >= 0; --m)
		{
			mad_mon[m] = FALSE;
			
			if (AMON->what)
			{
				if (AMON->summoned_by == MY_PORT->index)
				{
					Start_Mon_Name(name, m);
					prfmsg(MSG1318, name);
					prf("\r");
					Server_Message(LOUD_LOCAL);
					Remove_Mon(m, FALSE);
				}
				else
				{
					AMON->hurt_by[P] = FALSE;
					
					if (AMON->last_attacker == P)
					{
						mad_mon[m] = TRUE;
						AMON->last_attacker = -1;
					}
				}
			}
		}

		for (g = 0; g != NTERMS; ++g)
		{
			if (ABUF(B)->guy[g])
			{
				for (m = 0; m != MAX_ROOM_MON; ++m)
				{
					if (mad_mon[m])
					{
						AMON->last_attacker = g;
						AMON->sees[g] = TRUE;
					}
					mad_mon[m] = FALSE;
				}
			}
		}
	}
	else
	{
		ABUF(B)->rm2.last_kill = today();
		Write_Room2(&ABUF(B)->rm2, ABUF(B)->rm.id);
		
		if (ABUF(B)->rm.rmtype == CLOSET)
		{
			Write_Closet
			(
				MY_PORT->index, 
				(struct closet_struct *) ABUF(B)->item
			);
		}
		else
		{
			ABUF(B)->rm.items_or_mons = FALSE;

			for (i = 0; i != NUM_ITEMS; ++i)
			{
				if (ABUF(B)->item[i].what)
				{
					ABUF(B)->rm.items_or_mons = TRUE;
				}
			}

			for (m = 0; m != MAX_ROOM_MON; ++m)
			{
				if (AMON->what)
				{
					ABUF(B)->rm.items_or_mons = TRUE;
				}
			}

			if (ABUF(B)->item_change || ABUF(B)->crit_change)
			{
				Write_Sticky();
			}
		}

		if (ABUF(B)->item_change || ABUF(B)->crit_change)
		{
			Write_Room(&ABUF(B)->rm);
		}
	}

	No_Follow();
	Write_Coward(P);
	ABUF(B)->in_use = in_use;
}
/****************************************************************************
	heal a monster
*/
void heal_mon(short m)
{
	short   i;
	short   sturdy_t;

	if (AMON->damage || AMON->Tired)
	{
		if (AMON->heal_time == 0)
		{
			sturdy_t = find_timer(STURDY_TIME, MON);

			if (sturdy_t)
			{
				i = 1;
			}
			else
			{
				i = 2;
			}

			AMON->heal_time = i;
		}
	}
}
/****************************************************************************
	regenerate magic points on a monster
*/
void regen_mon_magic(short m)
{

	if (AMON->magic_used)
	{
		if (AMON->magic_time == 0)
		{
			AMON->magic_time = 1;
		}
	}
}
/****************************************************************************
	regenerate magic points on a guy
*/
void regen_guy_magic(short g)
{

	if (AGUY->magic_used > 0)
	{
		if (APORT(g)->magic_time == 0)
		{
			APORT(g)->magic_time = 1;
		}
	}
}
/****************************************************************************
	heal a user
*/
void heal_guy(short g)
{
	short   i;
	short   sturdy_t;

	if (AGUY->damaged > 0 || AGUY->ftg)
	{
		if (APORT(g)->heal_time == 0)
		{
			sturdy_t = find_timer(STURDY_TIME, GUY);  

			if (sturdy_t)
			{
				i = 1;
			}
			else
			{
				i = 2;
			}

			APORT(g)->heal_time = i;
		}
	}
}
/****************************************************************************
	advance all monster, character timers. Take appropriate action.
*/
void timers(void)
{
	short   g;
	short   m;
	short   t;
	short   i;
	short   x;
	short   float_t;
	short   weak_t;
	short   mania_t;
	char    name[20];

	for (g = 0; g != NTERMS && ABUF(B)->in_use; ++g)
	{
		if (ABUF(B)->guy[g])
		{
			if (APORT(g)->assassin_timer)
			{
				ELAPSE(APORT(g)->assassin_timer);
			}
			
			if (APORT(g)->arrest_timer)
			{
				ELAPSE(APORT(g)->arrest_timer);
			}

			if (APORT(g)->action_timer)
			{
				ELAPSE(APORT(g)->action_timer);

				if (APORT(g)->action_timer == 0)
				{
					APORT(g)->next_hit = NORMAL;
				}
			}

			if (APORT(g)->bashed_time)
			{
				ELAPSE(APORT(g)->bashed_time);

				if (APORT(g)->bashed_time == 0)
				{
					APORT(g)->bashed = 0;
					APORT(g)->next_hit = NORMAL;
					prfmsg(MSG17);
					Server_Message(g);
				}
			}

			weak_t = find_timer(WEAK_TIME, GUY);
			mania_t = find_timer(MANIA_TIME, GUY);

			if (APORT(g)->heal_time)
			{
				ELAPSE(APORT(g)->heal_time);

				if (APORT(g)->heal_time == 0 && !weak_t && !mania_t)
				{
					if (AGUY->ftg)
					{
						x = 1 + (Find_Ring(VIGOR, GUY) * 5);
						x += (Find_Ring(RESTORE, GUY) * 5);
						AGUY->ftg -= x;

						if (AGUY->ftg < 0)
						{
							AGUY->ftg = 0;
						}
					}
					else if (AGUY->damaged)
					{
						x = 1 + (Find_Ring(HEAL, GUY) * 5);
						x += (Find_Ring(RESTORE, GUY) * 5);
						AGUY->damaged -= x;

						if (AGUY->damaged < 0)
						{
							AGUY->damaged = 0;
						}
					}
				}
			}

			if (APORT(g)->magic_time)
			{
				ELAPSE(APORT(g)->magic_time);

				if (APORT(g)->magic_time == 0)
				{
					--AGUY->magic_used;

					if 
					(
						AGUY->class == CLERIC ||
						AGUY->class == MYSTIC ||
						AGUY->class == SORCERER
					)
					{
						--AGUY->magic_used;
					}

					if (AGUY->magic_used < 0)
					{
						AGUY->magic_used = 0;
					}
				}
			}

			if (APORT(g)->damage_timer)
			{
				ELAPSE(APORT(g)->damage_timer);
				
				if (APORT(g)->damage_timer == 0)
				{
					AGUY->ftg += (AGUY->dpts / 100) + 1;
					AGUY->damaged += (AGUY->dpts / 100) + 1;
					
					if (AGUY->damaged > AGUY->dpts)
					{
						if (ABUF(B)->rm.rmtype == WATER_ROOM)
						{
							prfmsg(MSG18);
							Server_Message(g);
							prfmsg(M19, AGUY->name, AGUY->title);
						}
						else
						{
							prfmsg(MSG20);
							Server_Message(g);
							prfmsg(M21, AGUY->name, AGUY->title);
						}

						Server_Message(GLOBAL);
						guy_died(g, -1);
					}
				}
			}
			else if 
			(
				ABUF(B)->rm.rmtype == WATER_ROOM && 
				!AGUY->perm[SUPER_PERM]
			)
			{
				float_t = find_timer(FLOAT_TIME, GUY);

				if (!float_t)
				{
					APORT(g)->damage_timer = 1;
				}
			}
			else if 
			(
				ABUF(B)->rm.rmtype == FIRE_ROOM &&
				!AGUY->perm[SUPER_PERM]
			)
			{
				APORT(g)->damage_timer = 1;
			}

			APORT(g)->can_quit = TRUE;
			
			for (m = 0; m != MAX_ROOM_MON; ++m)
			{
				if 
				(
					AMON->what && 
					(AMON->last_attacker == g || !AMON->alg)
				)
				{
					APORT(g)->can_quit = FALSE;
				}
			}

			for (t = 0; t != NUM_GUY_TIMERS; ++t)
			{
				if (APORT(g)->misc_type[t])
				{
					ELAPSE(APORT(g)->timer[t]);
					i = APORT(g)->misc_type[t];
					
					if (APORT(g)->timer[t] == 0)
					{
						APORT(g)->misc_type[t] = 0; 
						guy_time_expired(g, i);
					}
					else if
					(
						i == SLOW_TIME ||
						i == SLEEP_TIME ||
						i == MES_TIME ||
						i == MAGNET_TIME ||
						i == WEAK_TIME ||
						i == KO_TIME 
					)
					{
						APORT(g)->can_quit = FALSE;
					}
				}
			}
		
			if (SAFE_AREA)
			{
				APORT(g)->can_quit = TRUE;
			}

			for (i = 0; i != NUM_ITEMS; ++i)
			{
				if
				(
					AGUY->item[i].what == MAGIC_DEV &&
					AGUY->item[i].which == MAGIC_RING &&
					AGUY->item[i].ring_used
				)
				{
					if (!AGUY->item[i].infinite_uses)
					{
						ELAPSE(AGUY->item[i].uses);
					}

					if (AGUY->item[i].uses == 0)
					{
						Guy_Ring_Expired(g, i);
					}
				}
			}

			regen_guy_magic(g);
			heal_guy(g);

			if (AGUY->ftg > AGUY->dpts)
			{
				if (AGUY->ftg - AGUY->dpts > 3)
				{
					AGUY->ftg = AGUY->dpts + 3;
				}

				t = find_timer(KO_TIME, GUY);

				if (t == 0)
				{
					prfmsg(M280);
					Server_Message(g);
				}

				Make_A_Timer(KO_TIME, AGUY->ftg - AGUY->dpts, GUY, RESET);
			}

			if               
			(
				APORT(g)->next_input[0] &&
				!APORT(g)->action_timer &&
				!find_timer(SLEEP_TIME, GUY) &&
				!find_timer(KO_TIME, GUY)
			)
			{
				P = g;
				prfmsg(MSSG397, MY_PORT->next_input);
				strcpy(input, MY_PORT->next_input);
				parsin();
				Unique_Check();
				do_command();
				Send_Buf(MY_PORT->usrnum); 
				MY_PORT->next_input[0] = 0;
			}
			else if 
			(
				!AGUY->Option[NO_AUTO_COMBAT] &&
				APORT(g)->enemy_mon >= 0 &&
				!APORT(g)->action_timer &&
				!find_timer(SLEEP_TIME, GUY) &&
				!find_timer(KO_TIME, GUY)
			)
			{
				P = g;

				if (MY_PORT->last_attack == 0)
				{
					MY_PORT->last_attack = HIT;
				}

				command = MY_PORT->last_attack;

				if (command == GREATBLOW && !Fatigue(NEEDED))
				{
					command = HIT;
				}
							
				if (command == HIT && !Fatigue(NEEDED))
				{
					command = PARRY;
				}

				go_attack(!GET_WORD);
				Send_Buf(MY_PORT->usrnum);
			}

			if (AGUY->poison_timer)
			{
				ELAPSE(AGUY->poison_timer);

				if (AGUY->poison_timer == 0)
				{
					prfmsg(MSG35);
					Server_Message(g);
					prfmsg(M36, AGUY->name, AGUY->title);
					Server_Message(GLOBAL);
					guy_died(g, -1);
				}
			}

			if (AGUY->damaged > AGUY->dpts)
			{
				prfmsg(M278);
				Server_Message(g);
				prfmsg(M279, AGUY->name, AGUY->title);
				Server_Message(GLOBAL);
				guy_died(g, -1);
			}
		}
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what)
		{
			if (AMON->action_timer)
			{
				ELAPSE(AMON->action_timer);

				if (AMON->action_timer == 0)
				{
					AMON->next_hit = NORMAL;
				}
			}

			if (AMON->bashed_time)
			{
				ELAPSE(AMON->bashed_time);
				if (AMON->bashed_time == 0)
				{
					AMON->bashed = 0;
					AMON->next_hit = NORMAL;
					Start_Mon_Name(name, m);
					prfmsg(MSG22, name);
					Server_Message(LOUD_LOCAL);
				}
			}

			if (AMON->heal_time)
			{
				ELAPSE(AMON->heal_time);

				if (AMON->heal_time == 0)
				{
					mania_t = find_timer(MANIA_TIME, MON);
					weak_t = find_timer(WEAK_TIME, MON);      

					if (AMON->Tired)
					{
						if (!mania_t && !weak_t)
						{
							x = 1 + (Find_Ring(VIGOR, MON) * 5);
							x += (Find_Ring(RESTORE, MON) * 5);
							AMON->Tired -= x;
						}

						if (AMON->Tired < 0)
						{
							AMON->Tired = 0;
						}
						else if (AMON->Tired > AMON->dpts)
						{
							if (AMON->Tired - AMON->dpts > 3)
							{
								AMON->Tired = AMON->dpts + 3;
							}

							t = find_timer(KO_TIME, MON);

							if (t == 0)
							{
								Start_Mon_Name(name, m);
								prfmsg(MSG1358, name);
								Server_Message(LOUD_LOCAL);
							}

							Make_A_Timer
							(
								KO_TIME, 
								(short) (AMON->Tired - AMON->dpts), 
								MON, 
								RESET
							);
						}
					}
					else if (AMON->damage && !weak_t && !mania_t)
					{
						x = 1 + (Find_Ring(HEAL, MON) * 5);
						x += (Find_Ring(RESTORE, MON) * 5);
						AMON->damage -= x;

						if (AMON->damage < 0)
						{
							AMON->damage = 0;
						}
					}
				}
			}

			if (AMON->magic_time)
			{
				ELAPSE(AMON->magic_time);

				if (AMON->magic_time == 0 && AMON->magic_used)
				{
					--AMON->magic_used;
				}
			}

			regen_mon_magic(m);
			heal_mon(m);

			for (t = 0; t != NUM_MON_TIMERS; ++t)
			{
				if (AMON->misc_type[t])
				{
					ELAPSE(AMON->timer[t]);
					if (AMON->timer[t] == 0)
					{
						i = AMON->misc_type[t];
						AMON->misc_type[t] = 0;
						mon_time_expired(m, i);
					}
				}
			}
		}
	}
}
/****************************************************************************
	a player's timer has expired - take appropriate action
*/
void guy_time_expired(short g, short t)
{

	switch(t)
	{
		case MAGNET_TIME:
			prfmsg(MSG23);
			Server_Message(g);
			break;

		case SLOW_TIME:
			prfmsg(MSG24);
			Server_Message(g);
			break;
		
		case FAST_TIME:
			prfmsg(M25);
			Server_Message(g);
			break;

		case WEAK_TIME:
			prfmsg(MSG26);
			Server_Message(g);
			break;

		case FLOAT_TIME:
			prfmsg(MSG27);
			Server_Message(g);
			break;

		case SLEEP_TIME:
			prfmsg(MSG28);
			Server_Message(g);
			break;

		case KO_TIME:
			prfmsg(MSG29);
			Server_Message(g);
			if (AGUY->ftg > AGUY->dpts)
			{
				AGUY->ftg = AGUY->dpts;
			}
			break;

		case CIRCLE_TIME:
			prfmsg(M30);
			Server_Message(g);
			break;

		case PROTECTED_TIME:
			prfmsg(M31);
			Server_Message(g);
			break;

		case SHIELD_TIME:
			prfmsg(M32);
			Server_Message(g);
			break;

		case SEE_INVIS_TIME:
			prfmsg(M33);
			Server_Message(g);
			break;

		case STEALTH_TIME:
			prfmsg(M34);
			Server_Message(g);
			break;

		case INVISIBLE_TIME:
			Guy_Becomes_Visible(g);
			break;

		case INVULNERABLE_TIME:
			prfmsg(M37);
			Server_Message(g);
			break;

		case STURDY_TIME:
			prfmsg(M38);
			Server_Message(g);
			break;

		case STRONG_TIME:
			prfmsg(M39);
			Server_Message(g);
			Got_Weak(g);
			break;

		case MANIA_TIME:
			prfmsg(M40);
			Server_Message(g);
			break;
	}
}
/****************************************************************************
	a monster's timer has expired - take appropriate action
*/
void mon_time_expired(short m, short t)
{
	char    name[20];

	Start_Mon_Name(name, m);

	switch(t)
	{
		case INVULNERABLE_TIME:
			prfmsg(MSG41, name);
			Server_Message(LOUD_LOCAL);
			break;
		
		case STRONG_TIME:
			prfmsg(MSSG41, name);
			Server_Message(LOUD_LOCAL);
			break;

		case MANIA_TIME:
			prfmsg(MSG42, name);
			Server_Message(LOUD_LOCAL);
			break;

		case STURDY_TIME:
			prfmsg(MSG43, name);
			Server_Message(LOUD_LOCAL);
			break;

		case INVISIBLE_TIME:
			prfmsg(MSG44, name);
			Server_Message(LOUD_LOCAL);
			break;

		case SHIELD_TIME:
			prfmsg(MSG45, name);
			Server_Message(LOUD_LOCAL);
			break;

		case SEE_INVIS_TIME:
			prfmsg(MSG46, name);
			Server_Message(LOUD_LOCAL);
			break;

		case SLOW_TIME:
			prfmsg(M47, name);
			Server_Message(LOUD_LOCAL);
			break;

		case FAST_TIME:
			prfmsg(MSG48, name);
			Server_Message(LOUD_LOCAL);
			break;

		case WEAK_TIME:
			prfmsg(M49, name);
			Server_Message(LOUD_LOCAL);
			break;

		case SLEEP_TIME:
		case KO_TIME:
			prfmsg(M50, name);
			Server_Message(LOUD_LOCAL);

			if (AMON->Tired > AMON->dpts)
			{
				AMON->Tired = AMON->dpts;
			}

			break;

		case MES_TIME:
			prfmsg(M51, name);
			Server_Message(LOUD_LOCAL);
			break;
	}
}
/****************************************************************************
	have monsters fight
*/
void Monster_Attack(void)
{
	short   b = B;
	short   m;
	short   sleep;
	short   kod;
	short   g;
	short   started;

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		B = b;

		if (ABUF(B)->in_use && AMON->what)
		{
			Scroll_Cheat_Check(m);
			sleep = find_timer(SLEEP_TIME, MON);
			kod = find_timer(KO_TIME, MON);
			
			if (!sleep && !kod)
			{
				wield_weps(m);

				if (AMON->action_timer == 0)
				{
					g = AMON->last_attacker;

					if (g >= 0 && !AMON->sees[g])
					{
						g = AMON->last_attacker = -1;
					}

					if (g < 0)
					{
						if (!AMON->alg && AMON->hit_vector != PEST)
						{
							started = Start_Attacks(m, FALSE);

							if (!started)
							{
								started = turf_fury_check(m);
							}

							if 
							(
								!started && 
								AMON->hit_vector == STEALER &&
								!AMON->hidden
							)
							{
								Pick_It_Up(m, TRUE);
							}
						}
						else
						{
							started = turf_fury_check(m);

							if 
							(
								!AMON->hidden &&
								!started && 
								(AMON->hit_vector == STEALER ||
								AMON->hit_vector == PEST)
							)
							{
								Pick_It_Up(m, TRUE);
							}
						}
					}

					g = AMON->last_attacker;

					if
					(
						g >= 0 &&
						AMON->action_timer == 0 &&
						AMON->damage <= AMON->dpts
					)
					{
						for (sleep = 0; sleep != NUM_GUY_TIMERS; ++sleep)
						{
							if (APORT(g)->misc_type[sleep] == SLEEP_TIME)
							{
								if (RANDOM(globals->wakeup) == 1)
								{
									APORT(g)->timer[sleep] = 1;
								}
							}
						}

						select_attack(m);
					}
					else if (g < 0) 
					{
						if (AMON->hidden || AMON->action_timer == 0)
						{
							if (Monster_Casts(m) && !AMON->hidden)
							{
								Set_Monster_Action(m, 4);
							}
						}
					}
				}
			}
		}
	}
}
/****************************************************************************
	see if monster wants to attack somebody
*/
short Start_Attacks(short m, short pest)
{
	short   ko_t;
	short   circle_t;
	short   g = -1;
	short   guys = 0;

	for (P = 0; P != NTERMS; ++P)
	{
		if (ABUF(B)->guy[P] && AMON->sees[P])
		{
			if 
			(
				ABUF(B)->rm.id == globals->prison &&
				(MY_PORT->paladin || MY_PORT->arrest_timer)
			)
			{
				BAD_EXIT;
			}

			ko_t = find_timer(KO_TIME, ME);

			if (ko_t)
			{
				g = P;
			}

			if (P != 0)
			{
				++guys;
			}
		}
	}

	if (!guys)
	{
		BAD_EXIT;
	}

	if (g < 0)      
	{
		do
		{
			g = RANDOM(NTERMS - 1);
		}
		while (!ABUF(B)->guy[g] || !AMON->sees[g]);
	}

	circle_t = find_timer(CIRCLE_TIME, GUY);

	if (!circle_t)
	{
		if (pest)
		{
			return (g);
		}
		else
		{
			if (AMON->attacked_vector == MORPH && RANDOM(3) == 1)
			{
				if (Morphed(m, g))
				{
					Start_Mon_Name(name, m);
					prfmsg(MSG1305, name, AMON->Level);
					Server_Message(LOUD_LOCAL);
				}
			}

			start_an_attack(m, g);
			return (TRUE);
		}
	}

	BAD_EXIT;
}
/****************************************************************************
	see if there are players around that I don't know about
*/
short Find_Unknown_Enemies(short m)
{
	short   g;

	for (g = 0; g != NTERMS; ++g)
	{
		if (ABUF(B)->guy[g] && !AMON->sees[g])
		{
			return (TRUE);
		}
	}

	BAD_EXIT;
}
/****************************************************************************
	monster has decided to attack someone
*/
void start_an_attack(short m, short g)
{

	if (AMON->hidden)
	{
		AMON->hidden = FALSE;
		prfmsg(MSG1347);
		print_mon(m);
		prfmsg(MSG1348);
		Server_Message(LOUD_LOCAL);
	}
	
	Start_Mon_Name(name, m);
	prfmsg(MSG52, name, AGUY->name);
	Server_Message(-(g + 1));
	prfmsg(MSSG53, name);
	Server_Message(g);
	AMON->last_attacker = g;
}
/****************************************************************************
	monster decides how it will press the attack
*/
short select_attack(short m)
{
	short   g;
	short   did_spell;
	short   did_steal;

	command = 0;
	g = AMON->last_attacker;
	AMON->hidden = FALSE;

	if (AGUY->damaged > AGUY->dpts)
	{
		BAD_EXIT;
	}

	if 
	(
		AMON->spell_caster &&
		RANDOM(globals->monspell) == 1 && 
		AMON->what != ANIMAL
	)
	{
		command = SPELLS;
	}
	else if
	(
		(AMON->hit_vector == STEALER || AMON->hit_vector == PEST) &&
		RANDOM(globals->monrob) == 1 &&
		AMON->what != ANIMAL
	)
	{
		command = STEAL;
	}
	else if
	(
		AMON->dpts - AMON->Tired >= globals->gbftg &&
		(
			RANDOM(globals->mongb) == 1 ||
			APORT(g)->bashed ||
			APORT(g)->action_timer > 4
		)
	)
	{
		command = GREATBLOW;
	}
	else if
	(
		APORT(g)->action_timer < 4 &&
		RANDOM(globals->monbash) == 1 &&
		AMON->dpts - AMON->Tired >= globals->bashftg
	)
	{
		command = BASH;
	}
	else if (AMON->what != ANIMAL && RANDOM(globals->monparry) == 1)
	{
		command = PARRY;
	}
	else
	{
		if (AMON->dpts - AMON->Tired < globals->hitftg)
		{
			command = PARRY;
		}
		else if (AMON->dpts - AMON->Tired < globals->gbftg)
		{
			command = HIT;
		}
		else if (RANDOM(globals->mongb) == 1)
		{
			command = GREATBLOW;
		}
		else
		{
			command = HIT;
		}
	}

	if (command == BASH)
	{
		Mon_Bashes_Guy(m);
		Set_Monster_Action(m, 4);
	}
	else if (command == STEAL)
	{
		if (ABUF(B)->item[0].what && RANDOM(globals->monrob) == 1)
		{
			did_steal = Pick_It_Up(m, FALSE);
		}
		else
		{
			did_steal = Steal(m, g);
		}

		if (!did_steal)
		{
			command = PARRY;
			Hit_Guy(m);
		}
	}
	else if (command == SPELLS)
	{
		did_spell = Monster_Casts(m);

		if (did_spell)
		{
			Set_Monster_Action(m, 4);
		}
		else
		{
			if (AMON->dpts - AMON->Tired < globals->hitftg)
			{
				command = PARRY;
			}
			else if (AMON->dpts - AMON->Tired < globals->gbftg)
			{
				command = HIT;
			}
			else
			{
				command = GREATBLOW;
			}

			Hit_Guy(m);
		}
	}
	else if (command)
	{
		Hit_Guy(m);
	}

	if (command == PARRY)
	{
		AMON->next_hit = PARRIED;
	}
	else if (command == HIT)
	{
		AMON->Tired += globals->hitftg;
	}
	else if (command == GREATBLOW)
	{
		AMON->Tired += globals->gbftg;
		AMON->next_hit = VULNERABLE;
	}
	else if (command == BASH)
	{
		AMON->Tired += globals->bashftg;
	}

	DONE;
}
/****************************************************************************
	monster wants to bash his enemy
*/
void Mon_Bashes_Guy(short m)
{
	long    his_strength;
	long    my_strength;
	long    my_roll;
	long    his_roll;
	short   g;
	short   next_hit;
	short   success = 0;
	short   floating;

	Start_Mon_Name(name, m);
	g                   = AMON->last_attacker;
	floating            = find_timer(FLOAT_TIME, GUY);
	next_hit            = APORT(g)->next_hit;
	APORT(g)->next_hit  = NORMAL;

	his_strength = (long) AGUY->Str + (long) AGUY->Dex;
	my_strength = ((long) AMON->Str + (long) AMON->Dex) * 2L;

	if (next_hit == VULNERABLE)
	{
		his_strength = his_strength / 2L;
	}

	if (his_strength <= 0)
	{
		his_strength = 1;
	}

	if (my_strength <= 0)
	{
		my_strength = 1;
	}

	my_roll = LRAND(my_strength);
	his_roll = LRAND(his_strength);

	if (AGUY->race == OGRE)
	{
		his_roll += (long) his_strength;
	}

	if (my_roll > his_roll && !AGUY->perm[NOHIT_PERM])
	{
		APORT(g)->next_hit = VULNERABLE;
		if (APORT(g)->action_timer < globals->bashtime)
		{
			APORT(g)->action_timer = globals->bashtime;
		}
		success = 1;

		my_roll = LRAND(my_strength / 3L);
		his_roll = LRAND(his_strength);

		if (my_roll > his_roll && !floating)
		{
			success = 2;
			APORT(g)->bashed = 1;
			APORT(g)->bashed_time = globals->bashtime;
		}
	}

	if (success == 1)
	{
		if (!floating)
		{
			prfmsg(MSSG54, name);
			Server_Message(g);

			prfmsg(MSG55, name, AGUY->name);
			Server_Message(-(g + 1));
		}
		else
		{
			prfmsg(MSSG56, name);
			Server_Message(g);

			prfmsg(MSG57, name, AGUY->name);
			Server_Message(-(g + 1));
		}
	}
	else if (success == 2)
	{
		prfmsg(MSSG58, name);
		Server_Message(g);

		prfmsg(MSG59, name, AGUY->name);
		Server_Message(-(g + 1));
	}
	else
	{
		prfmsg(MSSG60, name);
		Server_Message(g);
	}

	AGUY->ftg += globals->bashftg / 2;
}
/****************************************************************************
	monster knows who it wants to get and how it wants to get guy
*/
short Hit_Guy(short m)
{
	short   i;
	short   weps;
	short   armor_ac;
	short   invis_t;
	short   see_invis_t;
	MLONG   damage;
	short   dmg;
	MLONG   roll;
	short   g;
	short   his_ac;
	short   shield_hit = 0;
	short   armor_hit = 0;
	short   clean_miss = 0;
	short   hit = TRUE;
	MLONG   bonus;
	MLONG   wep_hits;
	short   first_hit;

	g = AMON->last_attacker;

	if (AGUY->damaged)
	{
		first_hit = FALSE;
	}
	else
	{
		first_hit = TRUE;
	}

	for (i = weps = 0; i != MAX_MON_ITEM; ++i)
	{
		if (WEAPON(AMON->item_has[i]) && AMON->item_used[i])
		{
			++weps;
		}
	}

	if (weps <= 1 || AMON->what == AWESOME)
	{
		weps = 0;
	}

	Set_Monster_Action(m, 4 + weps);

	Calc_Mon_Bonus(AMON, m, &bonus, &wep_hits);

	invis_t = find_timer(INVISIBLE_TIME, MON);
	see_invis_t = find_timer(SEE_INVIS_TIME, GUY);

	if (invis_t && !see_invis_t)
	{
		bonus += 5L;
	}

	his_ac = Calc_Player_AC(AGUY, g, FULL_AC);
	Start_Mon_Name(name, m);

	if (flub_check(m))
	{
		AMON->next_hit = NORMAL;
		BAD_EXIT;
	}
	
	roll = (MLONG) RANDOM(40) - (MLONG) his_ac + bonus;

	if (wep_hits)
	{
		damage = wep_hits;
	}
	else if (AMON->what == AWESOME)
	{
		damage = ((MLONG) AMON->Level / 2L) + 1L;
	}
	else
	{
		damage = ((MLONG) AMON->Level / 3L) + 1L;
	}

	damage = LRAND(damage) + bonus;

	if (command == GREATBLOW)
	{
		damage = damage * 2L;
	}
	else if (command == PARRY)
	{
		damage = damage / 2L;
	}

	if (roll < 20 || AGUY->perm[NOHIT_PERM])
	{
		hit = FALSE;

		if (RANDOM(3) != 1 && AGUY->shld >= 0)
		{
			shield_hit = Armor_Entropy(g, AGUY->shld);
		}

		if (RANDOM(3) != 1 && AGUY->armor >= 0 && !shield_hit)
		{
			armor_hit = Armor_Entropy(g, AGUY->armor);
		}
	
		if (RANDOM(2) == 1)
		{
			if (command == GREATBLOW)
			{
				AGUY->ftg += globals->gbftg / 2;
			}
			else if (command == HIT)
			{
				AGUY->ftg += globals->hitftg / 2;
			}
		}
		else if (!armor_hit && !shield_hit)
		{
			clean_miss = TRUE;
		}
	}
	else
	{
		if (RANDOM(100) <= globals->mondd)
		{
			prf(globals->msg62);
			Server_Message(g);
			damage = damage * 2L;
		}
		
		if (APORT(g)->next_hit == PARRIED)
		{
			damage = damage / 2L;
		}

		if (AGUY->armor >= 0)
		{
			armor_ac = AGUY->item[AGUY->armor].ac; 
			armor_ac += AGUY->item[AGUY->armor].bonus;

			if (AGUY->item[AGUY->armor].which == LITE_ARMOR)
			{
				armor_ac = armor_ac / LEATHER_FACTOR;
			}
			else
			{
				armor_ac = armor_ac / METAL_FACTOR;
			}

			damage -= (MLONG) armor_ac;
		}
	
		if (damage <= 0)
		{
			damage = 1L;
		}
		else if (damage > 32767)
		{
			damage = 32767;
		}

		dmg = (short) damage;

		if (dmg > AGUY->dpts && AGUY->dpts > 4 && !AGUY->damaged)
		{
			if (!AMON->permanant || AMON->which == globals->rover)
			{
				dmg = AGUY->dpts;
			}
		}

		APORT(g)->next_hit = NORMAL;
		AGUY->damaged += dmg;
		AMON->I_hit[g] = TRUE;

		prf
		(
			globals->msg61, 
			name, 
			AGUY->name, 
			AGUY->dpts - AGUY->damaged,
			AGUY->dpts - AGUY->ftg
		);
		Server_Message(-(g + 1));
	}

	combat_message(name, g, hit, shield_hit, armor_hit, clean_miss, dmg);

	if (hit && AGUY->damaged <= AGUY->dpts)
	{
		for (i = 0; i != MAX_MON_ITEM; ++i)
		{
			if (WEAPON(AMON->item_has[i]) && AMON->item_used[i])
			{
				Instilled_Monster_Weapons(g, m, i, first_hit);
			}
		}
	}

	if (AGUY->damaged > AGUY->dpts)
	{
		guy_died(g, m);
	}
	else if (hit && AMON->hit_vector)
	{
		do_hit_vector(m, g, dmg);
	}

	DONE;
}
/****************************************************************************
	user got drained
*/
void got_drained(short m, short g, short dmg)
{

	Start_Mon_Name(name, m);
	prfmsg(M63, name);
	Server_Message(g);

	AMON->damage -= dmg;

	if (AMON->damage < 0)
	{
		AMON->damage = 0;
	}
}
/****************************************************************************
	something special happens when this monster hits
*/
void do_hit_vector(short m, short g, short dmg)
{
	short   sturdy;
	short   pure;

	if (AMON->hit_vector == POISONER)
	{
		sturdy = find_timer(STURDY_TIME, GUY);
		pure = Find_Ring(PURIFY, GUY);

		if (!sturdy && !pure && RANDOM(2) == 1)
		{
			got_poisoned(g);
		}
	}
	else if (AMON->hit_vector == DRAINER)
	{
		got_drained(m, g, dmg);
	}
}
/****************************************************************************
	monster is going to steal something
*/
short Steal(short m, short g)
{
	short   index;
	short   failed;
	short   j;
	short   avail = -1;
	short   my_factor;
	short   his_factor;
	struct  item_struct an_item;

	index = RANDOM(NUM_ITEMS) - 1;
	an_item = AGUY->item[index];

	if 
	(
		an_item.what == 0 ||
		an_item.what == CONTAINER ||
		an_item.what == ARMOR ||
		(an_item.what == MAGIC_DEV && an_item.which == SCROLL) ||
		(AGUY->class == THIEF && !globals->robthfs)
	)
	{
		BAD_EXIT;
	}

	for (j = 0; j != MAX_MON_ITEM; ++j)
	{
		if (AMON->item_has[j].what == 0 && avail < 0)
		{
			avail = j;
		}
	}

	if (avail < 0)
	{
		BAD_EXIT;
	}

	my_factor = AMON->Level * 7;

	if (AMON->hit_vector == PEST)
	{
		my_factor = my_factor * 2;
	}

	if (AGUY->class == THIEF)
	{
		his_factor = AGUY->thief * 7;
	}
	else
	{
		his_factor = AGUY->thief * 5;
	}

	failed = AGUY->Int + RANDOM(his_factor) > AMON->Dex + RANDOM(my_factor);

	if (AGUY->perm[SUPER_PERM])
	{
		failed = TRUE;
	}
	else if (AMON->permanant)
	{
		failed = FALSE;
	}

	if (!failed)
	{
		if (an_item.what == MAGIC_DEV && an_item.which == MAGIC_RING)
		{
			an_item.ring_used = FALSE;
		}

		AMON->item_has[avail] = an_item;
		P = g;
		Lose_Item(index);

		Start_Mon_Name(name, m);
		prfmsg(MSG64, name);
		Display_Item(&an_item);
		prf(NL);
		Server_Message(g);
	}
	else
	{
		Start_Mon_Name(name, m);
		prfmsg(MSG65, name);
		Server_Message(g);
	}
	
	Set_Monster_Action(m, 4);
	return (TRUE);
}
/****************************************************************************
	monster wants to cast a spell
*/
short Monster_Casts(short m)
{
	short   spell_num;
	short   tries = 3;
	short   magic_points;

	do
	{
		spell_num = select_spell(m, &magic_points);
		--tries;
	}
	while (spell_num < 0 && tries);

	if (tries == 0)
	{
		BAD_EXIT;
	}

	if (spell_type == DEFENSIVE)
	{
		Defensive_Spell(spell_num, m);
	}
	else
	{
		Offensive_Spell(spell_num, m);
	}

	AMON->magic_used += magic_points;

	return (TRUE);
}
/****************************************************************************
	set monster's reaction time
*/
void Set_Monster_Action(short m, short t)
{

	if (find_timer(SLOW_TIME, MON) || AMON->Level <= 5)
	{
		t = t * 2;
	}
	
	if (find_timer(FAST_TIME, MON))
	{
		t = t / 2;
	}

	if (slow_mons)
	{
		++t;
	}

	if (AMON->action_timer < t)
	{
		AMON->action_timer = t;
	}
}
/****************************************************************************
	determine what spell a monster is casting
*/
short select_spell(short m, short *magic_points)
{
	short   g;
	short   t1;

	g = AMON->last_attacker;

	t1 = find_timer(FAST_TIME, MON);

	if (!t1)
	{
		if (Spell_OK(HASTE, m, magic_points))
		{
			spell_type = DEFENSIVE;
			return (HASTE);
		}
	}

	t1 = find_timer(SHIELD_TIME, MON);
	if (!t1)
	{
		if (Spell_OK(MAGIC_SHIELD, m, magic_points))
		{
			spell_type = DEFENSIVE;
			return (MAGIC_SHIELD);
		}
	}

	t1 = find_timer(SEE_INVIS_TIME, MON);
	if (!t1)
	{
		if (Spell_OK(SEE_INVISIBLE, m, magic_points))
		{
			spell_type = DEFENSIVE;
			return (SEE_INVISIBLE);
		}
	}
	else
	{
		t1 = Find_Unknown_Enemies(m);

		if (t1)
		{
			if (Spell_OK(REVEAL, m, magic_points))
			{
				spell_type = DEFENSIVE;
				return (REVEAL);
			}
		}
	}

	if (RANDOM(4) == 1 || g < 0)
	{
		spell_type = DEFENSIVE;
	}
	else if
	(
		AMON->Psy > Local_Psy(g) ||
		AMON->Level > Stat_Lev(Local_Psy(g)) ||
		RANDOM(5) == 1
	)
	{
		spell_type = OFFENSIVE;

		if (APORT(g)->action_timer < spell_info[MESMERIZE].dur / 2)
		{
			if (Spell_OK(MESMERIZE, m, magic_points))
			{
				return (MESMERIZE);
			}
		}

		if (Spell_OK(SHOCKWAVE, m, magic_points))
		{
			return (SHOCKWAVE);
		}

		if (Spell_OK(FIREBALL, m, magic_points))
		{
			return (FIREBALL);
		}

		if (Spell_OK(BLAST, m, magic_points))
		{
			return (BLAST);
		}

		if (Spell_OK(LIGHTNING, m, magic_points))
		{
			return (LIGHTNING);
		}

		if (Spell_OK(DISPEL_MAGIC, m, magic_points))
		{
			if (Stat_Lev(Local_Psy(g)) >= 10)
			{
				return (DISPEL_MAGIC);
			}
		}

		if (Spell_OK(EXHAUSTION, m, magic_points))
		{
			return (EXHAUSTION);
		}

		if (Spell_OK(WEAKNESS, m, magic_points))
		{
			t1 = find_timer(WEAK_TIME, GUY);
			if (!t1)
			{
				return (WEAKNESS);
			}
		}

		if (Spell_OK(LANGOUR, m, magic_points))
		{
			t1 = find_timer(SLOW_TIME, GUY);
			if (!t1)
			{
				return (LANGOUR);
			}
		}

		if (Spell_OK(CURSE, m, magic_points))
		{
			return (CURSE);
		}

		if (Spell_OK(SLEEP, m, magic_points))
		{
			return (SLEEP);
		}

		if (AMON->what == AWESOME)
		{
			if (Spell_OK(FEAR, m, magic_points))
			{
				return (FEAR);
			}

			if (Spell_OK(TELEPORT, m, magic_points))
			{   
				return (TELEPORT);
			}
		}
	}

	spell_type = DEFENSIVE;

	t1 = find_timer(SHIELD_TIME, MON);
	if (!t1)
	{
		if (Spell_OK(MAGIC_SHIELD, m, magic_points))
		{
			return (MAGIC_SHIELD);
		}
	}

	t1 = find_timer(STRONG_TIME, MON);
	if (!t1)
	{
		if (Spell_OK(STRENGTH, m, magic_points))
		{
			return (STRENGTH);
		}
	}

	t1 = find_timer(MANIA_TIME, MON);
	if (!t1)
	{
		if (Spell_OK(MANIA, m, magic_points))
		{
			return (MANIA);
		}
	}

	if (AMON->damage)
	{
		if (Spell_OK(RESTORE, m, magic_points))
		{
			return (RESTORE);
		}
	}

	if (AMON->damage)
	{
		if (Spell_OK(HEAL, m, magic_points))
		{
			return (HEAL);
		}
	}

	if (AMON->Tired)
	{
		if (Spell_OK(VIGOR, m, magic_points))
		{
			return (VIGOR);
		}
	}

	t1 = find_timer(INVULNERABLE_TIME, MON);
	if (!t1)
	{
		if (Spell_OK(INVULNERABILITY, m, magic_points))
		{
			return (INVULNERABILITY);
		}
	}

	t1 = find_timer(STURDY_TIME, MON);
	if (!t1)
	{
		if (Spell_OK(STURDINESS, m, magic_points))
		{
			return (STURDINESS);
		}
	}

	t1 = find_timer(INVISIBLE_TIME, MON);

	if (!t1)
	{
		if (Spell_OK(INVISIBILITY, m, magic_points))
		{
			return (INVISIBILITY);
		}
	}

	if (g >= 0)
	{
		if (Spell_OK(DISPEL_MAGIC, m, magic_points))
		{
			spell_type = OFFENSIVE;
			return (DISPEL_MAGIC);
		}
	}

	return (-1);
}
/****************************************************************************
	monster has teleported a player
*/
void teleport_guy(short g)
{
	short   i;

	for (i = 0; i != NTERMS; ++i)
	{
		APORT(g)->follower[i] = 0;
		APORT(i)->follower[g] = 0;
	}

	prfmsg(MSG66, AGUY->name);
	Server_Message(-(g + 1));

	prfmsg(MSG67);
	Server_Message(g);

	Force_Guy_Move(g, Find_Teleport_Room());
	Send_Buf(APORT(g)->usrnum);
}
/****************************************************************************
	monster has cast a defensive spell
*/
void Defensive_Spell(short s, short m)
{
	MLONG   ldur = spell_info[s].dur;
	MLONG   i;
	short   stealthy;
	short   g;
	short   dur;

	if (AMON->spell_caster)
	{
		ldur = (ldur * 15L) / 10L;
		
		if 
		(
			s == INVISIBILITY || 
			s == PROTECT || 
			s == STURDINESS ||
			s == STRENGTH || 
			s == INVULNERABILITY ||
			s == MAGIC_SHIELD ||
			s == SEE_INVISIBLE ||
			s == STEALTH ||
			s == LEVITATE ||
			s == HASTE
		)
		{
			ldur += (MLONG) AMON->Psy;
		}
		else if (s == MANIA)
		{
			ldur += (MLONG) Stat_Lev(AMON->Psy);
		}
	}

	if (Has_Focus(m))
	{
		ldur = (ldur * (MLONG) globals->focus1) / 10L;
	}

	if (ldur > 32767)
	{
		ldur = 32767;
	}

	dur = (short) ldur;

	if (!AMON->hidden)
	{
		inform_defensive(s, m);
	}

	if (s == HEAL || s == RESTORE || s == VIGOR)
	{
		i = RANDOM(dur) * RANDOM(dur);
		i += dur + AMON->Level;

		if ((s == HEAL || s == RESTORE) && AMON->damage)
		{
			AMON->damage -= i;

			if (AMON->damage < 0)
			{
				i = -AMON->damage;
				AMON->damage = 0;
			}
			else
			{
				i = 0;
			}
		}

		if ((s == VIGOR || s == RESTORE) && i && AMON->Tired)
		{
			AMON->Tired -= i;
			if (AMON->Tired < 0)
			{
				AMON->Tired = 0;
			}
		}
	}
	else if (s == HASTE)
	{
		Make_A_Timer(FAST_TIME, dur, MON, RESET);
	}
	else if (s == STURDINESS)
	{
		Make_A_Timer(STURDY_TIME, dur, MON, RESET);
	}
	else if (s == INVULNERABILITY)
	{
		Make_A_Timer(INVULNERABLE_TIME, dur, MON, RESET);
	}
	else if (s == STRENGTH)
	{
		Make_A_Timer(STRONG_TIME, dur, MON, RESET);
	}
	else if (s == MANIA)
	{
		Make_A_Timer(MANIA_TIME, dur, MON, RESET);
	}
	else if (s == INVISIBILITY)
	{
		Make_A_Timer(INVISIBLE_TIME, dur, MON, RESET);
	}
	else if (s == MAGIC_SHIELD)
	{
		Make_A_Timer(SHIELD_TIME, dur, MON, RESET);
	}
	else if (s == REVEAL)
	{
		for (g = 1; g != NTERMS; ++g)
		{
			if (ABUF(B)->guy[g])
			{
				if (!AMON->sees[g])
				{
					Start_Mon_Name(name, m);
					prfmsg(MSG969, name);
					prf("\r");
					Server_Message(g);
					AMON->sees[g] = TRUE;
				}
			}
		}
	}
	else if (s == SEE_INVISIBLE)
	{
		Make_A_Timer(SEE_INVIS_TIME, dur, MON, RESET);

		for (g = 1; g != NTERMS; ++g)
		{
			if (ABUF(B)->guy[g] && !AMON->sees[g])
			{
				stealthy = find_timer(STEALTH_TIME, GUY);
					
				if (AGUY->thief >= globals->tstealth)
				{
					stealthy = TRUE;
				}
				else if (APORT(g)->hidden)
				{
					stealthy = TRUE;
				}

				if (!stealthy)
				{
					Start_Mon_Name(name, m);
					prfmsg(MSG969, name);
					prf("\r");
					Server_Message(g);
					AMON->sees[g] = TRUE;
				}
			}
		}
	}
}
/****************************************************************************
	monster has cast the sleep spell
*/
void Sandman(short m)
{
	short   g;
	short   dodged;
	short   dur = spell_info[SLEEP].dur;

	for (g = 1; g != NTERMS; ++g)
	{
		if (ABUF(B)->guy[g] && !(find_timer(SLEEP_TIME, GUY)))
		{
			Monster_Cast_Inform(SLEEP, g, m);
			dodged = Guy_Dodged(g, m, SLEEP, FALSE);

			if (!dodged || dodged == PARTIAL_DODGE)
			{
				if (dodged != PARTIAL_DODGE)
				{
					dodged = 1;
				}

				prfmsg(MSG68);
				Server_Message(g);
				prfmsg(MSG69, AGUY->name);
				Server_Message(-(g + 1));

				Make_A_Timer(SLEEP_TIME, dur / dodged, GUY, RESET);
			}
		}
	}
}
/****************************************************************************
	monster has cast the shockwave
*/
void Shockwaver(short m, short dur)
{
	short   g;
	short   dodged;
	short   room_num = ABUF(B)->rm.id;
	MLONG   dmg;

	Start_Mon_Name(name, m);
	prfmsg(MSG1563, name);
	prf(NL);
	Server_Message(LOUD_LOCAL);

	for (g = 1; g != NTERMS; ++g)
	{
		if (ABUF(B)->guy[g] && ABUF(B)->in_use && ABUF(B)->rm.id == room_num)
		{
			dodged = Guy_Dodged(g, m, SHOCKWAVE, FALSE);

			if (!dodged || dodged == PARTIAL_DODGE)
			{
				if (dodged != PARTIAL_DODGE)
				{
					dodged = 1;
				}

				dmg = (MLONG) AMON->Level * (MLONG) dur;
				dmg += RANDOM(AMON->Level);
				dmg = dmg / (MLONG) dodged;

				if (dmg > AGUY->dpts && AGUY->dpts > 4 && !AGUY->damaged)
				{
					if (!AMON->permanant || AMON->which == globals->rover)
					{
						dmg = AGUY->dpts;
					}
				}

				if (dmg > AGUY->dpts - AGUY->damaged)
				{
					dmg = (AGUY->dpts - AGUY->damaged) + 1;
				}
				else if (dmg < 1)
				{
					dmg = 1;
				}

				AGUY->damaged += (short) dmg;
				AMON->I_hit[g] = TRUE;

				prfmsg(MSG1363, (short) dmg, AGUY->dpts - AGUY->damaged);
				Server_Message(g);
		
				if (AGUY->shld >= 0)
				{
					Armor_Entropy(g, AGUY->shld);
				}

				if (AGUY->armor >= 0)
				{
					Armor_Entropy(g, AGUY->armor);
				}

				if (AGUY->damaged > AGUY->dpts)
				{
					guy_died(g, m);
				}
			}
		}
	}
}
/****************************************************************************
	monster casts dispel magic
*/
void Monster_Dispels_Magic(short g, short dodged)
{
	short   t;
	short   shield_t = -1;

	for (t = 0; t != NUM_GUY_TIMERS; ++t)
	{
		if (APORT(g)->misc_type[t] == SHIELD_TIME)
		{
			shield_t = t;
		}
	}

	if (shield_t >= 0)
	{
		if (dodged == PARTIAL_DODGE)
		{
			if (APORT(g)->timer[shield_t] > 1)
			{
				APORT(g)->timer[shield_t] = APORT(g)->timer[shield_t] / 2;
			}
		}
		else
		{
			APORT(g)->timer[shield_t] = 1;
		}
	}
	else
	{
		prfmsg(MSG72);
		Server_Message(g);

		if (dodged == PARTIAL_DODGE)
		{
			if (AGUY->magic_used < AGUY->mpts / 2)
			{
				AGUY->magic_used = AGUY->mpts / 2;
			}
					
			for (t = 0; t != NUM_GUY_TIMERS; ++t)
			{
				if 
				(
					APORT(g)->timer[t] > 1 &&
					APORT(g)->misc_type[t] != KO_TIME
				)
				{
					APORT(g)->timer[t] = APORT(g)->timer[t] / 2;

					if (APORT(g)->misc_type[t] == MES_TIME)
					{
						APORT(g)->action_timer = APORT(g)->action_timer / 2;
					}
				}
			}
		}
		else
		{
			AGUY->magic_used = AGUY->mpts;
				
			for (t = 0; t != NUM_GUY_TIMERS; ++t)
			{
				if (APORT(g)->misc_type[t] != KO_TIME)
				{
					APORT(g)->timer[t] = 1;

					if (APORT(g)->misc_type[t] == MES_TIME)
					{
						APORT(g)->action_timer = 1;
					}
				}
			}
		}
	}
}
/****************************************************************************
	monster is casting a spell
*/
short Offensive_Spell(short s, short m)
{
	short   tal_index;
	short   i;
	short   g;
	short   dodged;
	MLONG   e;
	MLONG   dmg;
	MLONG   ldur = spell_info[s].dur;
	short   dur;

	if (s == CURSE)
	{
		ldur = 1;
	}

	if (AMON->spell_caster)
	{
		ldur = (ldur * 15L) / 10L;
		
		if (s == AGGRAVATE || s == LANGOUR || s == WEAKNESS)
		{
			ldur += (MLONG) AMON->Psy;
		}
		else if (s == MESMERIZE)
		{
			ldur += (MLONG) Stat_Lev(AMON->Psy);
		}
	}

	if (Has_Focus(m))
	{
		ldur = (ldur * (MLONG) globals->focus1) / 10L;
	}

	if (ldur > 32767)
	{
		ldur = 32767;
	}

	dur = (short) ldur;

	if (s == SLEEP)
	{
		Sandman(m);
		BAD_EXIT;
	}

	if (s == SHOCKWAVE)
	{
		Shockwaver(m, dur);
		BAD_EXIT;
	}

	g = AMON->last_attacker;

	Monster_Cast_Inform(s, g, m);
	dodged = Guy_Dodged(g, m, s, FALSE);

	if (dodged && dodged != PARTIAL_DODGE)
	{
		BAD_EXIT;
	}

	if (dodged != PARTIAL_DODGE)
	{
		dodged = 1;
	}

	if (s == LANGOUR)
	{
		prfmsg(MSG70);
		Server_Message(g);
		Make_A_Timer(SLOW_TIME, dur / dodged, GUY, RESET);
		BAD_EXIT;
	}
	else if (s == WEAKNESS)
	{
		prfmsg(MSG71);
		Server_Message(g);
		Make_A_Timer(WEAK_TIME, dur / dodged, GUY, RESET);
		BAD_EXIT;
	}
	else if (s == FEAR)
	{
		P = g;
		Flee();
		Send_Buf(APORT(g)->usrnum);
	}
	else if (s == DISPEL_MAGIC)
	{
		Monster_Dispels_Magic(g, dodged);
	}
	else if (s == MESMERIZE)
	{
		prfmsg(MSG73);
		Server_Message(g);

		if (APORT(g)->action_timer < dur / dodged)
		{
			APORT(g)->action_timer = dur / dodged;
		}

		Make_A_Timer(MES_TIME, APORT(g)->action_timer, GUY, RESET);
	}
	else if (s == TELEPORT)
	{
		teleport_guy(g);
	}
	else if (s == LIGHTNING || s == BLAST || s == FIREBALL)
	{
		dmg = (MLONG) AMON->Level * (MLONG) dur;
		dmg += RANDOM(AMON->Level);
		dmg = dmg / (MLONG) dodged;

		if (dmg > AGUY->dpts && AGUY->dpts > 4 && !AGUY->damaged)
		{
			if (!AMON->permanant || AMON->which == globals->rover)
			{
				dmg = AGUY->dpts;
			}
		}

		if (dmg > AGUY->dpts - AGUY->damaged)
		{
			dmg = (AGUY->dpts - AGUY->damaged) + 1;
		}
		else if (dmg < 1)
		{
			dmg = 1;
		}

		AGUY->damaged += (short) dmg;
		AMON->I_hit[g] = TRUE;

		prfmsg(MSG1363, (short) dmg, AGUY->dpts - AGUY->damaged);
		Server_Message(g);
		
		if (AGUY->shld >= 0)
		{
			Armor_Entropy(g, AGUY->shld);
		}

		if (AGUY->armor >= 0)
		{
			Armor_Entropy(g, AGUY->armor);
		}

		if (AGUY->damaged > AGUY->dpts)
		{
			guy_died(g, m);
			BAD_EXIT;
		}
	}
	else if (s == EXHAUSTION)
	{
		dmg = (MLONG) AMON->Level * (MLONG) dur;
		dmg += RANDOM(AMON->Level);
		dmg = dmg / (MLONG) dodged;

		if (dmg > AGUY->dpts - AGUY->ftg)
		{
			dmg = (AGUY->dpts - AGUY->ftg) + 1;
		}
		else if (dmg < 1)
		{
			dmg = 1;
		}

		AGUY->ftg += (short) dmg;
		AMON->I_hit[g] = TRUE;

		prfmsg(MSSG74);
		Server_Message(g);
	}
	else if (s == CURSE)
	{
		for (i = 0, tal_index = -1; i != NUM_ITEMS; ++i)
		{
			if (AGUY->item[i].what == TALISMAN)
			{
				tal_index = i;
			}
		}

		if (tal_index != -1)
		{
			prfmsg(MSG1091, AGUY->item[tal_index].name);
			Server_Message(g);
			P = g;
			Lose_Item(tal_index);
			DONE;
		}

		i = RANDOM(5);

		if (i == 1)
		{
			prfmsg(MSG75);

			if (AGUY->Int > dur)
			{
				AGUY->Int -= dur;
				e = Calc_Exp_Needed(AGUY->Int, FALSE);

				if (AGUY->int_exp > e)
				{
					AGUY->int_exp = e;
				}
			}
		}
		else if (i == 2)
		{
			prfmsg(MSG76);

			if (AGUY->Str > dur)
			{
				AGUY->Str -= dur;
				e = Calc_Exp_Needed(AGUY->Str, FALSE);

				if (AGUY->str_exp > e)
				{
					AGUY->str_exp = e;
				}
			}
		}
		else if (i == 3)
		{
			prfmsg(MSG77);

			if (AGUY->Psy > dur)
			{
				AGUY->Psy -= dur;
				e = Calc_Exp_Needed(AGUY->Psy, FALSE);

				if (AGUY->psy_exp > e)
				{
					AGUY->psy_exp = e;
				}
			}
		}
		else if (i == 4)
		{
			prfmsg(MSG78);

			if (AGUY->Dex > dur)
			{
				AGUY->Dex -= dur;
				e = Calc_Exp_Needed(AGUY->Dex, FALSE);

				if (AGUY->dex_exp > e)
				{
					AGUY->dex_exp = e;
				}
			}
		}
		else if (i == 5)
		{
			prfmsg(MSG79);

			if (AGUY->Con > dur)
			{
				AGUY->Con -= dur;
				e = Calc_Exp_Needed(AGUY->Con, FALSE);

				if (AGUY->con_exp > e)
				{
					AGUY->con_exp = e;
				}
			}
		}

		Server_Message(g);

		Set_Guy_Points
		(
			&AGUY->dpts,
			&AGUY->mpts,
			AGUY->Str,
			AGUY->Con,
			AGUY->Psy,
			AGUY->class
		);
	}
	DONE;
}
/****************************************************************************
	inform the room that monster cast a defensive spell.
*/
void inform_defensive(short s, short m)
{
	char    name[20];

	Start_Mon_Name(name, m);
	prfmsg(MSG80, name, spell_info[s].name);
	Server_Message(LOUD_LOCAL);
}
/****************************************************************************
	inform the room that monster cast a spell at a guy.
*/
void Monster_Cast_Inform(short s, short g, short m)
{
	char    name[20];

	Start_Mon_Name(name, m);
	prfmsg(MSG81, name, spell_info[s].name);
	Server_Message(g);
	prfmsg(MSG82, name, spell_info[s].name, AGUY->name);
	Server_Message(-(g + 1));
}
/****************************************************************************
	see if guy dodges an offensive spell aimed their way
*/
short Guy_Dodged(short g, short m, short s, short instilled)
{
	short   i;
	short   amulet_index;
	MLONG   his_dex = AGUY->Dex;
	MLONG   my_dex = AMON->Dex;
	short   sleep_t;
	short   mshield_t;
	MLONG   his_factor;
	MLONG   my_factor;
	short   dodged;
		
	for (i = 0, amulet_index = -1; i != NUM_ITEMS; ++i)
	{
		if (AGUY->item[i].what == AMULET)
		{
			amulet_index = i;
		}
	}

	if (amulet_index != -1)
	{
		prfmsg(MSG1314, AGUY->item[amulet_index].name);
		prf("\r");
		Server_Message(g);
		prfmsg(MSG1313, AGUY->name, AGUY->item[amulet_index].name);
		prf("\r");
		Server_Message(-(g + 1));
	
		if (!AGUY->item[amulet_index].infinite_uses)
		{
			AGUY->item[amulet_index].uses -= spell_info[s].pts;
		}

		if (!instilled && Has_Focus(m))
		{
			AGUY->item[amulet_index].uses = 0;
		}

		if (AGUY->item[amulet_index].uses <= 0)
		{
			prfmsg(MSG1091, AGUY->item[amulet_index].name);
			Server_Message(g);
			P = g;
			Lose_Item(amulet_index);
		}

		return (TRUE);
	}

	his_factor = Local_Psy(g);
	sleep_t = find_timer(SLEEP_TIME, GUY);
	mshield_t = find_timer(SHIELD_TIME, GUY);

	if (mshield_t && s != DISPEL_MAGIC)
	{
		his_factor = his_factor * 3;
	}

	if (AGUY->race == HALFLING)
	{
		his_dex = his_dex * 3;
	}

	my_factor = AMON->Psy;
	if (Has_Focus(m))
	{
		my_factor = (my_factor * globals->focus2) / 10L;
	}

	dodged = LRAND(his_dex) + his_factor > LRAND(my_dex) + my_factor;

	if (dodged)
	{
		dodged = LRAND(his_dex + his_factor) > LRAND(my_dex + my_factor);

		if (!dodged)
		{
			dodged = PARTIAL_DODGE;
		}
	}

	if (!mshield_t && (sleep_t || APORT(g)->bashed))
	{
		dodged = FALSE;
	}
	
	if (AGUY->perm[NOHIT_PERM])
	{
		dodged = TRUE;
	}

	if (dodged == PARTIAL_DODGE)
	{
		if (!instilled)
		{
			prfmsg(MSG83, AGUY->name);
			Server_Message(-(g + 1));
			prfmsg(MSG84);
			Server_Message(g);
		}
	}
	else if (dodged)
	{
		if (!instilled)
		{
			prfmsg(MSG85, AGUY->name);
			Server_Message(-(g + 1));
			prfmsg(MSG86);
			Server_Message(g);
		}
	}
	else
	{
		if (!instilled)
		{
			prfmsg(MSG87, AGUY->name);
			Server_Message(-(g + 1));
		}
	}
		 
	return (dodged);
}
/****************************************************************************
	user has been killed by a monster
*/
void guy_died(short g, short m)
{
	char    *msg;
	char    dead_date[DATE_SIZE];

	if (m < 0)
	{
		Next_User(g);
		Got_Killed(SERVER_DEATH);
		Previous_User();
	}
	else
	{
		Monster_Name(name, AMON->article, AMON->name);
		if (AMON->last_attacker == g) 
		{
			AMON->last_attacker = -1;
		}

		if
		(
			AGUY->Str >= globals->noteable &&
			AGUY->Int >= globals->noteable &&
			AGUY->Con >= globals->noteable &&
			AGUY->Psy >= globals->noteable &&
			AGUY->Dex >= globals->noteable
		)
		{
			TODAY(dead_date);
			msg = getmsg(MSG630);
			sprintf
			(
				APORT(g)->death,
				msg,
				dead_date,
				AGUY->name,
				AGUY->title,
				name
			);
		}

		prfmsg(M88, AGUY->name, AGUY->title, name);
		Server_Message(GLOBAL);
		Next_User(g);
		Got_Killed(SERVER_DEATH);
		Previous_User();
	}
}
/****************************************************************************
	user was hit, drain his armor or shield
*/
short Armor_Entropy(short g, short i)
{
	short   x = 1;
	short   hits = 1;

	if (command == GREATBLOW)
	{   
		hits = 2;
	}

	item = AGUY->item[i];

	if (item.bonus > 0)
	{
		x = item.bonus / 2;
		if (x == 0)
		{
			x = 1;
		}
	}

	if (item.uses >= 0 && RANDOM(x) == 1 && !item.infinite_uses)
	{
		AGUY->item[i].uses -= hits;
		item.uses -= hits;
	}
	else
	{
		BAD_EXIT;
	}

	if (item.uses <= 0)
	{
		if (item.what == ARMOR)
		{
			prfmsg(MSG89, item.name);
		}
		else
		{
			prfmsg(MSG90, item.name);
		}

		Server_Message(g);
		P = g;
		Lose_Item(i);
		if (prfbuf[0])
		{
			Server_Message(g);
		}
	}
	else if (item.uses == 10)
	{
		prfmsg(M91, item.name);
		Server_Message(g);
	}
	else if (item.uses < 10)
	{
		prfmsg(M92, item.name);
		Server_Message(g);
	}

	return (TRUE);
}
/****************************************************************************
	see if any cursed characters are around
*/
short magnet_check(void)
{
	short   g;
	short   t;
	short   magnet = 0;

	for (g = 1; g != NTERMS; ++g)
	{
		if (ABUF(B)->guy[g])
		{
			t = find_timer(MAGNET_TIME, GUY);

			if (t)
			{
				magnet = 50;
			}
		}
	}

	return (magnet);
}
/****************************************************************************
	see if a monster needs to get rid of it's scrolls
*/
short Scroll_Cheat_Check(short m)
{
	short   i;
	short   g;
	short   guys = 0;
			  
	for (g = 1; g != NTERMS; ++g)
	{
		if (ABUF(B)->guy[g])
		{
			++guys;
		}
	}

	if (guys <= 1)
	{
		DONE;
	}

	for (i = 0; i != MAX_MON_ITEM; ++i)
	{
		if (AMON->item_has[i].what && AMON->item_has[i].which == SCROLL)
		{
			AMON->item_has[i].what = 0;
		}
	}

	DONE;
}
/****************************************************************************
	see if any monsters are encountered
*/
short Encounter(short ambush)
{
	short   which;
	short   invis_t;
	short   possibles;
	short   g;
	short   m;
	short   roll;
	short   avail = -1;
	short   guys = 0;
	short   vis_guys = 0;
	short   prisoner = -1;
	short   invaders = FALSE;
			  
	for (m = 0; avail < 0 && m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what == 0)
		{
			avail = m;
		}
	}

	if (avail < 0)
	{
		BAD_EXIT;
	}

	for (g = 1; g != NTERMS; ++g)
	{
		if (ABUF(B)->guy[g])
		{
			if (APORT(g)->fine)
			{
				prisoner = g;
			}

			++guys;
			invis_t = find_timer(INVISIBLE_TIME, GUY);
			
			if (!invis_t && !APORT(g)->hidden)
			{
				++vis_guys;
			}
		}
	}

	if (guys == 0)
	{
		BAD_EXIT;
	}

	if 
	(
		!ambush &&
		invasion->active && 
		ABUF(B)->rm.id == invasion->origin &&
		invasion->num_left
	)
	{
		invaders = TRUE;
		--invasion->num_left;
		++invasion->count[0];
	}
	else
	{
		roll = RANDOM(100) + magnet_check();

		if (roll > ABUF(B)->rm.enc_chance + (guys * 3) + ABUF(B)->yell)
		{
			BAD_EXIT;
		}
	}

	if (invaders)
	{
		Make_Monster(invasion->crit, avail, vis_guys, TRUE, ambush);
	}
	else if (ABUF(B)->rm.id == globals->prison && prisoner >= 0)
	{
		Make_Monster(-1, avail, prisoner, FALSE, ambush);
	}
	else
	{
		for (m = possibles = 0; m != POSSIBLE_MONS; ++m)
		{
			if 
			(
				ABUF(B)->rm.monster_here[m] &&   
				ABUF(B)->rm.monster_here[m] <= globals->maxmon
			)
			{
				++possibles;
			}
		}

		if (possibles == 0)
		{
			BAD_EXIT;
		}
	
		which = 0;
		while (which == 0)
		{
			which = ABUF(B)->rm.monster_here[RANDOM(POSSIBLE_MONS) - 1];
		}

		Make_Monster(which, avail, vis_guys, FALSE, ambush);
	}

	DONE;
}
/****************************************************************************
	roll up a monster
*/
short Make_Monster
(
	short   which,
	short   m,
	short   vis_guys,
	short   enhanced,
	short   ambush
)
{
	short   i;
	short   invis;
	short   tries = 0;
	short   tandem_ok = TRUE;
	short   prison_mon = FALSE;

	if (which == -1)
	{
		prison_mon = TRUE;

		do
		{
			which = RANDOM(MAX_MONSTER - 1);
			Read_Critter(which, &crit);
			++tries;
		}
		while 
		(
			tries != 50 &&
			(crit.permanant || crit.alg || crit.kills >= globals->extmon)
		);

		if (tries == 50)
		{
			which = globals->rover;
		}
	}

	Read_Critter(which, &crit);
	
	if 
	(
		time(0) - crit.last_kill > globals->monregen &&
		crit.kills >= globals->extmon
	)
	{
		crit.kills = 0;
		Write_Critter(&crit); 
	}        
	else if (crit.kills >= globals->extmon && !enhanced)
	{
		ABUF(B)->room_timer = 1;
		BAD_EXIT;
	}

	if (ambush && crit.alg)
	{
		BAD_EXIT;
	}

	if (prison_mon)
	{
		crit.Level = Approximate_Level(vis_guys) * RANDOM(3);
	}
	
	if (enhanced)
	{
		crit.Level = invasion->level;
		
		if (crit.hit_vector == 0 || crit.hit_vector == PEST)
		{
			crit.hit_vector = STEALER;
		}

		if 
		(
			crit.attacked_vector == JAILED || 
			crit.attacked_vector == ADD_EVIL
		)
		{
			crit.attacked_vector = 0;
		}
	}

	if (RANDOM(2) == 1)
	{
		++crit.Level;
	}

	setmem(AMON, MON_SIZE, 0);
	memcpy(AMON, &crit, CRIT_SIZE);

	for (i = 1; i != NTERMS; ++i)
	{
		if (ABUF(B)->guy[i])
		{
			invis = find_timer(INVISIBLE_TIME, i, -1);

			if ((!APORT(i)->hidden && !invis) || prison_mon || ambush)
			{
				AMON->sees[i] = TRUE;
			}
		}
	}

	Set_Mon_Stats(AMON, DO_RANDOM);
	Set_Mon_Points
	(
		&AMON->dpts,
		&AMON->mpts,
		AMON->Str,
		AMON->Con,
		AMON->Psy
	);

	AMON->last_attacker = -1;
	AMON->summoned_by = -1;

	for (i = 0; i != NUM_SPELLS; ++i)
	{
		if (RANDOM(3) != 1 && AMON->spell_caster)
		{
			AMON->spell[i] = TRUE;
		}
	}

	if 
	(
		sameas(AMON->plural_name, globals->bounty.plural_name) && 
		RANDOM(100) <= globals->bntyitem
	)
	{                         
		enhanced = TRUE;
	}
	else if (AMON->what == AWESOME)
	{
		enhanced = TRUE;
	}
	else if (AMON->attacked_vector == MORPH)
	{
		enhanced = TRUE;
	}

	for (i = 0; i != POSSIBLE_MON_ITEM; ++i)
	{
		if (AMON->Item[i])
		{
			Create_Item
			(
				AMON->Item[i], 
				AMON, 
				globals->treasure, 
				TO_MONSTER,
				enhanced
			);
			
			if (enhanced || ambush)
			{
				tandem_ok = FALSE;
			}
		}
	}

	Create_Item(0, AMON, 100, TO_MONSTER, enhanced);

	if 
	(
		prison_mon || 
		(invasion->active && AMON->which == invasion->crit)
	)
	{
		for (i = 0; i != MAX_MON_ITEM; ++i)
		{
			if (AMON->item_has[i].what && AMON->item_has[i].which == SCROLL)
			{
				AMON->item_has[i].what = 0;
			}
		}
	}

	if (bp_mons)
	{
		AMON->dpts = (AMON->dpts * 2L) / 3L;
	}

	Monster_Name(name, AMON->article, AMON->name);
	AMON->action_timer = globals->monreact;
	AMON->enhanced = enhanced;

	if (ambush)
	{
		AMON->hidden = TRUE;
		AMON->action_timer = 10;
	}
	else
	{
		if (vis_guys <= 1 || prison_mon)
		{
			prfmsg(MSG93); 
		}
		else
		{
			prfmsg(MSG94);
		}

		if 
		(
			m != MAX_ROOM_MON - 1 && 
			(RANDOM(100) < 20 || (globals->yell2 && ABUF(B)->yell == 100)) && 
			tandem_ok
		)
		{
			memcpy(&ABUF(B)->mon[m + 1], AMON, (size_t) MON_SIZE);
			prfmsg(MSG95, AMON->plural_name);
		}
		else
		{
			prfmsg(MSG96, name);
		}

		Server_Message(LOUD_LOCAL);
	}

	ABUF(B)->crit_change = TRUE;
	DONE;
}
/****************************************************************************
	send text to other port
*/
void Server_Send(short p)
{

	if (!APORT(p)->editing && !APORT(p)->announce)
	{
		if (APORT(p)->need_lf)
		{
			prf(NL);
			APORT(p)->need_lf = FALSE;
		}
	
		prf(globals->temp_buf);
		btuoes(APORT(p)->usrnum, 1);
		outprf(APORT(p)->usrnum);
	}

	clrprf();
}
/****************************************************************************
	send message to specified user(s)
*/
void Server_Message(short send_to)
{
	short   i;

	strcpy(globals->temp_buf, prfbuf);
	clrprf();

	if (send_to == GLOBAL)
	{
		for (i = 0; i != NTERMS; ++i)
		{
			if (APORT(i)->status)
			{
				Server_Send(i);
			}
		}
	}
	else if (send_to == LOUD_LOCAL)
	{
		for (i = 0; i != NTERMS; ++i)
		{ 
			if (APORT(i)->status && ABUF(B)->guy[i])
			{
				Server_Send(i);
			}
		}
	}
	else if (send_to < 0)
	{
		send_to = abs(send_to) - 1;

		for (i = 0; i != NTERMS; ++i)
		{
			if (APORT(i)->status && i != send_to && ABUF(B)->guy[i])
			{
				Server_Send(i);
			}
		}
	}
	else if (APORT(send_to)->status)
	{
		Server_Send(send_to);
	}

	clrprf();
}
/****************************************************************************
	see if monster flubbed
*/
short flub_check(short m)
{
	MLONG   dex;
	short   roll;

	dex = (MLONG) AMON->Dex * (MLONG) globals->flubfctr;

	if (LRAND(dex) != 1)
	{
		BAD_EXIT;
	}

	roll = RANDOM(MAX_MON_ITEM) - 1;

	if (AMON->item_used[roll] == 0 || AMON->item_has[roll].what == ARMOR)
	{
		Start_Mon_Name(name, m);
		prfmsg(MSG97, name);
		Server_Message(LOUD_LOCAL);
		AMON->action_timer = 10;
		return(TRUE);
	}

	Put_In_Room(&AMON->item_has[roll]);
	Start_Mon_Name(name, m);
	prfmsg(MSG98, name);
	Display_Item(&AMON->item_has[roll]);
	prf(NL);
	Server_Message(LOUD_LOCAL);
	AMON->item_used[roll] = 0;
	AMON->item_has[roll].what = 0;
	return(TRUE);
}
/****************************************************************************
	see if a monster attacks because of turf war
*/
short turf_fury_check(short m)
{
	MLONG   hi = globals->turfmin;
	short   hi_guild = -1;
	short   i;
	short   guy_guild;
	short   g;
	short   t;
	short   skip;

	for (P = 0; P != NTERMS; ++P)
	{
		if (ABUF(B)->guy[P])
		{
			if 
			(
				ABUF(B)->rm.id == globals->prison &&
				(MY_PORT->paladin || MY_PORT->arrest_timer)
			)
			{
				BAD_EXIT;
			}
		}
	}

	for (i = 0; i != NUM_SAVED_PLACES; ++i)
	{
		if (ABUF(B)->rm2.Turf_Kills[i] >= hi)
		{
			hi_guild = i;
			hi = ABUF(B)->rm2.Turf_Kills[i];
		}
	}

	if (hi_guild >= 0)
	{
		for (g = 1; g != NTERMS; ++g)
		{
			if (ABUF(B)->guy[g] && AMON->sees[g])
			{
				if (AMON->permanant && AMON->alg)
				{
					skip = TRUE;
				}
				else
				{
					skip = FALSE;
				}

				guy_guild = AGUY->in_guild;

				if (guy_guild && !skip)
				{
					if (guild->status[hi_guild][guy_guild] == -1)
					{
						start_an_attack(m, g);
						return (TRUE);
					}
				}
			}
		}
	}

	for (g = 1; g != NTERMS; ++g)
	{
		if (ABUF(B)->guy[g] && AMON->sees[g])
		{
			t = find_timer(MAGNET_TIME, GUY);

			if (AGUY->evil >= globals->evilness)
			{
				t = TRUE; 
			}
			
			if 
			(
				AMON->permanant && 
				AMON->alg && 
				AGUY->evil < globals->evilness
			)
			{
				skip = TRUE;
			}
			else
			{
				skip = FALSE;
			}
			
			if (t && !skip)
			{
				start_an_attack(m, g);
				return (TRUE);
			}
		}
	}

	BAD_EXIT;
}
/***************************************************************************
	Remove the rover if it's in an active room
*/
short Remove_Rover(void)
{
	short   old_b = B;
	short   removed = FALSE;
	short   i;
	short   j;
	short   ok;
	short   m;
		
	for (i = 0; i != MAX_PERM_MON; ++i)
	{
		if (globals->perm_mon_id[i] == globals->rover)
		{
			for (j = 0, ok = TRUE; j != NTERMS; ++j)
			{
				if 
				(
					ABUF(j)->in_use && 
					ABUF(j)->rm.id == abs(globals->perm_mon_loc[i])
				)
				{
					ok = FALSE;
					B = j;
				}
			}

			if (!ok)
			{
				for (m = 0, ok = FALSE; m != MAX_ROOM_MON && !ok; ++m)
				{
					if (AMON->what && AMON->which == globals->perm_mon_id[i])
					{
						Perm_Left(m);
						ok = TRUE;
					}
				}
			}
		}
	}

	for (i = 0; i != MAX_PERM_MON; ++i)
	{
		if (globals->perm_mon_id[i] == globals->rover)
		{
			removed = TRUE;
			globals->perm_mon_loc[i] = 0;
			globals->perm_mon_id[i] = 0;
			globals->perm_mon_dmg[i] = 0;
		}
	}

	B = old_b;

	return (removed);
}
/****************************************************************************
	monster has left room for one reason or another, remove him
*/
void Perm_Left(short m)
{
	short   i;
	short   total;
	char    name[20];

	for (i = 0; i != MAX_MON_ITEM; ++i)
	{
		if (AMON->item_has[i].what == CONTAINER)
		{
			Kill_Container(&AMON->item_has[i]);
		}
	}

	Monster_Name(name, AMON->article, AMON->name);
	name[0] = toupper(name[0]);

	for (i = total = 0; i != MAX_ROOM_MON; ++i)
	{
		if (ABUF(B)->mon[i].what)
		{
			++total;
		}
	}

	AMON->what = 0;

	if (m != MAX_ROOM_MON - 1)
	{
		for (i = m + 1; i != MAX_ROOM_MON; ++i)
		{
			ABUF(B)->mon[i - 1] = ABUF(B)->mon[i];
		}
	}

	ABUF(B)->mon[total - 1].what = 0;

	for (i = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->B == B && APORT(i)->enemy_mon == m)
		{
			APORT(i)->enemy_mon = -1;
		}
		else if (APORT(i)->B == B && APORT(i)->enemy_mon > m)
		{
			--APORT(i)->enemy_mon;
		}
	}

	prfmsg(MSG99, name);
	Server_Message(LOUD_LOCAL);
}
/****************************************************************************
	a pest will rob try to rob someone
*/
void Pesterize(short m)
{
	short   g;

	if (AMON->hit_vector == PEST)
	{
		g = Start_Attacks(m, TRUE);
		if (g)
		{
			Steal(m, g);
		}
	}
}
/****************************************************************************
	monster is going to steal something from the ground
*/
short Pick_It_Up(short m, short pest)
{
	short   i;
	short   j;
	short   num_items;
	short   avail = -1;

	for (i = num_items = 0; i != NUM_ITEMS; ++i)
	{
		if (ABUF(B)->item[i].what)
		{
			++num_items;
		}
	}

	if (num_items == 0)
	{
		if (pest)
		{
			Pesterize(m);
		}

		DONE;
	}

	for (j = 0; j != MAX_MON_ITEM; ++j)
	{
		if (AMON->item_has[j].what == 0 && avail < 0)
		{
			avail = j;
		}
	}

	if (avail < 0)
	{
		if (pest)
		{
			Pesterize(m);
		}

		DONE;
	}

	i = RANDOM(num_items) - 1;

	if (ABUF(B)->item[i].which != SCROLL)
	{
		item = ABUF(B)->item[i];

		if (item.what == MAGIC_DEV && item.which == MAGIC_RING)
		{
			item.ring_used = FALSE;
		}

		AMON->item_has[avail] = item;
		AMON->item_has[avail].permanant = FALSE;
		Lose_Ground_Item(i);

		Start_Mon_Name(name, m);
		prfmsg(M100, name);
		Display_Item(&item);
		prf(NL);
		Server_Message(LOUD_LOCAL);
		Set_Monster_Action(m, 2);
		return (TRUE);
	}
	
	if (pest)
	{
		Pesterize(m);
	}

	DONE;
}
/****************************************************************************
	guy has been poisoned
*/
void got_poisoned(short g)
{

	if (AGUY->poison_timer > 2)
	{
		prfmsg(MSG101);
		Server_Message(g);
		AGUY->poison_timer = AGUY->poison_timer / 2;
	}
	else
	{
		prfmsg(MSG102);
		Server_Message(g);
		AGUY->poison_timer = 60;
	}
}
/***************************************************************************
	determine and send the combat message
*/
void combat_message
(
	char    *name,
	short   g,
	short   hit,
	short   shield_hit,
	short   armor_hit,
	short   clean_miss,
	short   dmg
)
{

	if (!hit)
	{
		if (command == GREATBLOW)
		{
			if (shield_hit)
			{
				prf(globals->msg103, name);
			}
			else if (armor_hit)
			{
				prf(globals->msg104, name);
			}
			else if (!clean_miss)
			{
				prf(globals->msg105, name);
			}
			else
			{
				prf(globals->msg106, name);
			}
		}
		else if (command == PARRY)
		{
			if (shield_hit)
			{
				prf(globals->msg107, name);
			}
			else if (armor_hit)
			{
				prf(globals->msg108, name);
			}
			else if (!clean_miss)
			{
				prf(globals->msg109, name);
			}
			else
			{
				prf(globals->msg110, name);
			}
		}
		else
		{
			if (shield_hit)
			{
				prf(globals->msg111, name);
			}
			else if (armor_hit)
			{
				prf(globals->msg112, name);
			}
			else if (!clean_miss)
			{
				prf(globals->msg113, name);
			}
			else
			{
				prf(globals->msg114, name);
			}
		}
	}
	else
	{
		if (command == GREATBLOW)
		{
			prf(globals->msg1364, name, dmg, AGUY->dpts - AGUY->damaged);
		}
		else if (command == PARRY)
		{
			prf(globals->msg1365, name, dmg, AGUY->dpts - AGUY->damaged);
		}
		else
		{
			prf(globals->msg1366, name, dmg, AGUY->dpts - AGUY->damaged);
		}
	}

	Server_Message(g);
}
/****************************************************************************
	get monster wielding the best item combination possible
*/
short wield_weps(short m)
{
	short   i;
	short   hands;
	short   focus = FALSE;
	short   shield = FALSE;
	char    name[20];
	short   skip_it;
	short   best_armor = -1;
	short   best_ac = 0;
	short   ac;

	for (i = 0; i != MAX_MON_ITEM; ++i)
	{
		if (AMON->item_has[i].what == ARMOR)
		{
			AMON->item_used[i] = FALSE;
			ac = AMON->item_has[i].ac + AMON->item_has[i].bonus;
			
			if (ac > best_ac)
			{
				best_armor = i;
				best_ac = ac;
			}
		}
	}
			
	if (best_armor != -1)
	{
		AMON->item_used[best_armor] = TRUE;
	}

	if (AMON->action_timer != 0)
	{
		BAD_EXIT;
	}

	if 
	(
		AMON->what != WEIRD && 
		AMON->what != AWESOME && 
		AMON->what != LONER
	)
	{
		do
		{
			for (i = hands = 0; i != MAX_MON_ITEM; ++i)
			{
				if (WEAPON(AMON->item_has[i]) && AMON->item_used[i])
				{
					if
					(
						AMON->item_has[i].which == TWOHAND &&
						AMON->Str < globals->twohndst
					)
					{
						hands += 2;
					}
					else
					{
						++hands;
					}
				}
				else if (AMON->item_has[i].what == SHIELD && AMON->item_used[i])
				{
					++hands;
					shield = TRUE;
				}
				else if (AMON->item_has[i].what == PSY_FOCUS && AMON->item_used[i])
				{
					++hands;
					focus = TRUE;
				}
			}

			if (hands > 2)
			{
				hands = 0;
				shield = FALSE;
				focus = FALSE;

				for (i = 0; i != MAX_MON_ITEM; ++i)
				{
					if
					(
						AMON->item_has[i].what == SHIELD ||
						AMON->item_has[i].what == PSY_FOCUS ||
						WEAPON(AMON->item_has[i])
					)
					{
						AMON->item_used[i] = 0;
					}
				}
			}
		}
		while (hands > 2);

		if (hands == 2)
		{
			BAD_EXIT;
		}
	}
	else
	{
		for (i = focus = shield = 0; i != MAX_MON_ITEM; ++i)
		{
			if (AMON->item_has[i].what == PSY_FOCUS && AMON->item_used[i])
			{
				focus = TRUE;
			}
			else if (AMON->item_has[i].what == SHIELD && AMON->item_used[i])
			{
				shield = TRUE;
			}
		}
	}

	for (i = 0; i != MAX_MON_ITEM; ++i)
	{
		if 
		(
			AMON->item_has[i].what == PSY_FOCUS && 
			!focus && 
			AMON->spell_caster
		)
		{
			if (!AMON->hidden)
			{
				Start_Mon_Name(name, m);
				prfmsg(M119, name);
				Display_Item(&AMON->item_has[i]);
				prf(NL);
				Server_Message(LOUD_LOCAL);
			}

			Set_Monster_Action(m, 4);
			AMON->item_used[i] = TRUE;
			BAD_EXIT;
		}

		if (WEAPON(AMON->item_has[i]) && !AMON->item_used[i])
		{
			skip_it = FALSE;

			if (AMON->item_has[i].which == TWOHAND && hands != 0)
			{
				if 
				(
					AMON->Str < globals->twohndst && 
					AMON->what != WEIRD &&
					AMON->what != AWESOME &&
					AMON->what != LONER
				)
				{
					skip_it = TRUE;
				}
			}

			if (!skip_it)
			{
				if (!AMON->hidden)
				{
					Start_Mon_Name(name, m);
					prfmsg(M118, name);
					Display_Item(&AMON->item_has[i]);
					prf(NL);
					Server_Message(LOUD_LOCAL);
				}

				Set_Monster_Action(m, 4);
				AMON->item_used[i] = TRUE;
				BAD_EXIT;
			}
		}

		if (AMON->item_has[i].what == SHIELD && !shield)
		{
			if (!AMON->hidden)
			{
				Start_Mon_Name(name, m);
				prfmsg(M119, name);
				Display_Item(&AMON->item_has[i]);
				prf(NL);
				Server_Message(LOUD_LOCAL);
			}

			Set_Monster_Action(m, 4);
			AMON->item_used[i] = TRUE;
			BAD_EXIT;
		}
	}

	DONE;
}
/****************************************************************************
	see if a monster can/wants to cast the given spell
*/
short Spell_OK(short spell_num, short m, short *magic_points)
{
	short   i;

	*magic_points = 0;

	if (RANDOM(4) == 1 && !AMON->hidden)
	{
		return (FALSE);
	}

	if (AMON->last_attacker < 0 && RANDOM(25) != 1 && !AMON->hidden)
	{
		return (FALSE);
	}

	for (i = 0; i != MAX_MON_ITEM; ++i)
	{
		if
		(
			AMON->item_has[i].what == MAGIC_DEV &&
			AMON->item_has[i].which != MAGIC_RING &&
			AMON->item_has[i].spell_cast == spell_num
		)
		{
			return (TRUE);
		}
	}

	if (!AMON->spell_caster || !AMON->spell[spell_num])
	{
		return (FALSE);
	}

	if (AMON->mpts - AMON->magic_used < spell_info[spell_num].pts)
	{
		return (FALSE);
	}

	*magic_points = spell_info[spell_num].pts;

	if (AMON->Psy < spell_info[spell_num].power)
	{
		return (FALSE);
	}
	else
	{
		return (TRUE);
	}
}
/****************************************************************************
	a players ring has run out of time
*/
void Guy_Ring_Expired(short g, short i)
{
	struct item_struct an_item;

	an_item = AGUY->item[i];
	P = g;
	Lose_Item(i);

	prfmsg(MSG120);
	Display_Item(&an_item);
	prf(NL);
	Server_Message(g);
	Affect_Expired(an_item.spell_cast, g);
	if (prfbuf[0])
	{
		Server_Message(g);
	}
}
/****************************************************************************
	guy just became visible
*/
short Guy_Becomes_Visible(short g)
{
	short   m;

	if (find_timer(INVISIBLE_TIME, GUY))
	{
		BAD_EXIT;
	}

	if (APORT(g)->hidden)
	{
		prfmsg(M138);
	}
	else
	{
		prfmsg(MSG139);
	}

	Server_Message(g);

	if (!APORT(g)->hidden)
	{
		prfmsg(MSG140, AGUY->name);
		Server_Message(-(g + 1));

		for (m = 0; m != MAX_ROOM_MON; ++m)
		{
			if (AMON->what)
			{
				AMON->sees[g] = TRUE;
			}
		}
	}
	DONE;
}
/*******************************************************************************
	user got weak all of a sudden
*/
short EXPORT Got_Weak(short g)
{
	short   i;
	short   x;
	short   num_items;
	MLONG   carrying;
	MLONG   carry_max;

	P = g;

	if (find_timer(STRONG_TIME, GUY) || me.perm[SUPER_PERM])
	{
		BAD_EXIT;
	}

	if (me.Str < globals->twohndst)
	{
		if
		(
			me.lw >= 0 && me.item[me.lw].which == TWOHAND ||
			me.rw >= 0 && me.item[me.rw].which == TWOHAND
		)
		{
			if (me.shld >= 0)
			{
				prfmsg(M141);
				Put_In_Room(&me.item[me.shld]);
				prfmsg(MSG142);
				Display_Item(&me.item[me.shld]);
				prf(NL);
				Lose_Item(me.shld);
			}
		}

		if
		(
			me.lw >= 0 && me.item[me.lw].which == TWOHAND &&
			me.rw >= 0 && me.item[me.rw].which == TWOHAND
		)
		{
			prfmsg(M143);
			Put_In_Room(&me.item[me.lw]);
			prfmsg(MSG142);
			Display_Item(&me.item[me.lw]);
			prf(NL);
			Lose_Item(me.lw);
		}

		if (me.lw >= 0 && me.item[me.lw].which == TWOHAND && me.rw >= 0)
		{
			prfmsg(M144);
			Put_In_Room(&me.item[me.lw]);
			prfmsg(MSG142);
			Display_Item(&me.item[me.lw]);
			prf(NL);
			Lose_Item(me.lw);
		}

		if (me.rw >= 0 && me.item[me.rw].which == TWOHAND && me.lw >= 0)
		{
			prfmsg(M144);
			Put_In_Room(&me.item[me.rw]);
			prfmsg(MSG142);
			Display_Item(&me.item[me.rw]);
			prf(NL);
			Lose_Item(me.rw);
		}
	}

	Calc_Weight(&num_items, &carrying, &carry_max);

	if (carrying <= carry_max)
	{
		Send_Buf(MY_PORT->usrnum);
		BAD_EXIT;
	}

	prfmsg(M145);

	for (i = NUM_ITEMS - 1, x = 1; x && i >= 0 && carry_max < carrying; --i)
	{
		if (me.item[i].what)
		{
			Put_In_Room(&me.item[i]);
			prfmsg(MSG142);
			Display_Item(&me.item[i]);
			prf(NL);
			Lose_Item(i);
			Calc_Weight(&num_items, &carrying, &carry_max);
		}
	}
	
	Send_Buf(MY_PORT->usrnum);

	DONE;
}
