#include <header.h>
#include <globals.h>

MLONG   exp_awarded;

/****************************************************************************
	parse selected quests and train/untrain
*/
void EXPORT Train(void)
{
	short   i;
	short   j;
	short   n;
	short   lo;
	short   hi;
	short   range;
	short   quests[13];

	for (i = 0; i != 13; ++i)
	{
		quests[i] = FALSE;
	}

	for (i = 0; i != margc; ++i)
	{
		for (j = range = 0; j != strlen(margv[i]); ++j)
		{
			if (margv[i][j] == '-')
			{
				str[j] = 0;
				lo = INUM(str) - 1;
				hi = lo;
				
				if (margv[i][j + 1] != 0)
				{
					strcpy(str, &margv[i][j + 1]);
					hi = INUM(str) - 1;
				}
				
				range = TRUE;
			}
			else
			{
				str[j] = margv[i][j];
				str[j + 1] = 0;
			}
		}

		if (!range)
		{
			lo = INUM(str) - 1;
			hi = lo;
		}

		for (n = lo; n < hi + 1; ++n)
		{
			if (n >= 0 && n <= 12)
			{
				quests[n] = TRUE;
			}
		}
	}

	for (i = 0; i != 13; ++i)
	{
		if (quests[i])
		{
			prfmsg(MSG1304, i + 1);
			Select_Quest(i + 1);
		}
	}

	prf(NL);
}
/****************************************************************************
	give experience to local trancers
*/
void EXPORT Award_Trancers(short m)
{   
	short   g;

	for (g = 0; g != NTERMS; ++g)
	{
		if (ABUF(B)->guy[g] && APORT(g)->trance)
		{
			AMON->tranced_by[g] = TRUE;
			AMON->hurt_by[g] = TRUE;
			AMON->hurters[g] = TRUE; 
		}
	}
}
/*****************************************************************************
	Display list of quests (either current or available)
*/
void Display_Quests(short option)
{   
	MLONG   exp;
	float   level;
	short   my_level = Approximate_Level(P);
	short   stats_needed = Next_Level();
	
	if (my_level > globals->xplev15)
	{
		level = .66;
	}
	else if (my_level > globals->fexplev)
	{
		level = 1;
	}
	else
	{
		level = 2;
	}

	if (me.shield < globals->startshd) 
	{
		me.shield = globals->startshd;
	}

	if (me.two_wep < globals->start2wp) 
	{
		me.two_wep = globals->start2wp;
	}

	if (option == ACTIVE_QUESTS)
	{
		sprintf(str, getmsg(MSG343), Money());
		prf(str);
		prfmsg(MSG1374, stats_needed, my_level + 1);
	
		if (me.generic_exp)
		{
			sprintf(str, getmsg(MSG344), me.generic_exp);
			prf(str);
		}

		prf(NL);
		Huntress_Quest();
	}
	else
	{
		prf(NL);
	}

	if 
	(
		(option == ACTIVE_QUESTS && me.str_exp > 0) ||
		(option == INACTIVE_QUESTS && me.str_exp <= 0)
	)
	{
		prfmsg(MSG346);

		if (me.str_exp > 0)
		{
			sprintf(str, getmsg(MSG347), me.str_exp);
			prf(str);  
		}
		else
		{
			exp = Calc_Exp_Needed(me.Str, FALSE);

			if (me.race == OGRE)
			{
				exp = exp / 2;
			}

			sprintf(str, getmsg(MSG348), exp, (MLONG) (exp / level));
			prf(str);
		}
	}

	if 
	(
		(option == ACTIVE_QUESTS && me.dex_exp > 0) ||
		(option == INACTIVE_QUESTS && me.dex_exp <= 0)
	)
	{
		prfmsg(MSG349);

		if (me.dex_exp > 0)
		{
			sprintf(str, getmsg(MSG347), me.dex_exp);
			prf(str);
		}
		else
		{
			exp = Calc_Exp_Needed(me.Dex, FALSE);

			if (me.race == HALFLING)
			{
				exp = exp / 2;
			}
			
			sprintf(str, getmsg(MSG348), exp, (MLONG) (exp / level));
			prf(str);
		}
	}

	if 
	(
		(option == ACTIVE_QUESTS && me.con_exp > 0) ||
		(option == INACTIVE_QUESTS && me.con_exp <= 0)
	)
	{
		prfmsg(MSG350);

		if (me.con_exp > 0)
		{
			sprintf(str, getmsg(MSG347), me.con_exp);
			prf(str);
		}
		else
		{
			exp = Calc_Exp_Needed(me.Con, FALSE);

			if (me.race == DWARF)
			{
				exp = exp / 2;
			}
			
			sprintf(str, getmsg(MSG348), exp, (MLONG) (exp / level));
			prf(str);
		}
	}

	if 
	(
		(option == ACTIVE_QUESTS && me.psy_exp > 0) ||
		(option == INACTIVE_QUESTS && me.psy_exp <= 0)
	)
	{
		prfmsg(MSG351);

		if (me.psy_exp > 0)
		{
			sprintf(str, getmsg(MSG347), me.psy_exp);
			prf(str);
		}
		else
		{
			exp = Calc_Exp_Needed(me.Psy, FALSE);
			
			if (me.race == ELF && me.class == CLERIC)
			{
				exp = exp / 3;
			}
			else if (me.race == ELF)
			{
				exp = exp / 2;
			}
			else if (me.class == CLERIC)
			{
				exp = exp / 2;
			}

			if 
			(
				me.class != MYSTIC && 
				me.class != SORCERER && 
				me.class != CLERIC
			)
			{
				exp = exp * 2;
			}
			
			sprintf(str, getmsg(MSG348), exp, (MLONG) (exp / level));
			prf(str);
		}
	}

	if 
	(
		(option == ACTIVE_QUESTS && me.int_exp > 0) ||
		(option == INACTIVE_QUESTS && me.int_exp <= 0)
	)
	{
		prfmsg(MSG352);
	
		if (me.int_exp > 0)
		{
			sprintf(str, getmsg(MSG347), me.int_exp);
			prf(str);
		}
		else
		{
			exp = Calc_Exp_Needed(me.Int, FALSE);

			if (me.race == HUMAN)
			{
				exp = exp / 2;
			}
			
			sprintf(str, getmsg(MSG348), exp, (MLONG) (exp / level));
			prf(str);
		}
	}

	if 
	(
		(option == ACTIVE_QUESTS && me.thief_exp > 0) ||
		(option == INACTIVE_QUESTS && me.thief_exp <= 0)
	)
	{
		prfmsg(MSG353, me.thief + 1);

		if (me.thief_exp > 0)
		{
			sprintf(str, getmsg(MSG347), me.thief_exp);
			prf(str);
		}
		else
		{
			if (me.class != THIEF)
			{
				exp = Calc_Exp_Needed(me.thief + 1, TRUE) * 2;
			}
			else
			{
				exp = Calc_Exp_Needed(me.thief - START_THIEF + 1, TRUE);
			}
			
			sprintf(str, getmsg(MSG348), exp, (MLONG) (exp / level));
			prf(str);
		}

		if (me.thief + 1 == globals->ttrack)
		{
			prfmsg(MSG354);
		}
		else if (me.thief + 1 == globals->tfollow)
		{
			prfmsg(MSG355);
		}
		else if (me.thief + 1 == globals->thide)
		{
			prfmsg(MSG356);
		}
		else if (me.thief + 1 == globals->tlose)
		{
			prfmsg(MSG357);
		}
		else if (me.thief + 1 == globals->tstealth)
		{
			prfmsg(MSG358);
		}
		else if (me.thief + 1 == globals->tlock)
		{
			prfmsg(MSSG358);
		}
	}

	if 
	(
		(option == ACTIVE_QUESTS && me.defense_exp > 0) ||
		(option == INACTIVE_QUESTS && me.defense_exp <= 0)
	)
	{
		prfmsg(MSG359);

		if (me.defense_exp > 0)
		{
			sprintf(str, getmsg(MSG347), me.defense_exp);
			prf(str);
		}
		else
		{
			exp = Calc_Exp_Needed(me.defense + 1, TRUE);

			if (me.class == WARRIOR)
			{
				exp = exp / 2;
			}

			sprintf(str, getmsg(MSG348), exp, (MLONG) (exp / level));
			prf(str);
		}
	}

	if 
	(
		(option == ACTIVE_QUESTS && me.wep_exp[BLUNT_IND] > 0) ||
		(option == INACTIVE_QUESTS && me.wep_exp[BLUNT_IND] <= 0)
	)
	{
		prfmsg(MSG360);

		if (me.wep_exp[BLUNT_IND] > 0)
		{
			sprintf(str, getmsg(MSG347), me.wep_exp[BLUNT_IND]);
			prf(str);
		}
		else
		{
			exp = Calc_Exp_Needed(me.wep_plus[BLUNT_IND] + 1, TRUE);

			if (me.class == MYSTIC || me.class == SORCERER)
			{
				exp = exp * 2;
			}
			else if (me.class == DUELIST || me.class == CLERIC)
			{
				exp = exp / 2;
			}

			sprintf(str, getmsg(MSG348), exp, (MLONG) (exp / level));
			prf(str);
		}
	}

	if 
	(
		(option == ACTIVE_QUESTS && me.wep_exp[HAND_IND] > 0) ||
		(option == INACTIVE_QUESTS && me.wep_exp[HAND_IND] <= 0)
	)
	{
		prfmsg(MSG361);

		if (me.wep_exp[HAND_IND] > 0)
		{
			sprintf(str, getmsg(MSG347), me.wep_exp[HAND_IND]);
			prf(str);
		}
		else
		{
			exp = Calc_Exp_Needed(me.wep_plus[HAND_IND] + 1, TRUE);

			if (me.class == CLERIC || me.class == SORCERER)
			{
				exp = exp * 2;
			}
			
			sprintf(str, getmsg(MSG348), exp, (MLONG) (exp / level));
			prf(str);
		}
	}

	if 
	(
		(option == ACTIVE_QUESTS && me.wep_exp[EDGED_IND] > 0) ||
		(option == INACTIVE_QUESTS && me.wep_exp[EDGED_IND] <= 0)
	)
	{
		prfmsg(MSG362);

		if (me.wep_exp[EDGED_IND] > 0)
		{
			sprintf(str, getmsg(MSG347), me.wep_exp[EDGED_IND]);
			prf(str);
		}
		else
		{
			exp = Calc_Exp_Needed(me.wep_plus[EDGED_IND] + 1, TRUE);

			if
			(
				me.class == CLERIC ||
				me.class == MYSTIC ||
				me.class == SORCERER
			)
			{
				exp = exp * 2;
			}
			else if (me.class == DUELIST)
			{
				exp = exp / 2;
			}

			sprintf(str, getmsg(MSG348), exp, (MLONG) (exp / level));
			prf(str);
		}
	}

	if 
	(
		(option == ACTIVE_QUESTS && me.wep_exp[POLE_IND] > 0) ||
		(option == INACTIVE_QUESTS && me.wep_exp[POLE_IND] <= 0)
	)
	{
		prfmsg(MSG363);

		if (me.wep_exp[POLE_IND] > 0)
		{
			sprintf(str, getmsg(MSG347), me.wep_exp[POLE_IND]);
			prf(str);
		}
		else
		{
			exp = Calc_Exp_Needed(me.wep_plus[POLE_IND] + 1, TRUE);

			if
			(
				me.class == CLERIC ||
				me.class == MYSTIC ||
				me.class == SORCERER
			)
			{
				exp = exp * 2;
			}
			else if (me.class == DUELIST)
			{
				exp = exp / 2;
			}

			sprintf(str, getmsg(MSG348), exp, (MLONG) (exp / level));
			prf(str);
		}
	}

	if 
	(
		(option == ACTIVE_QUESTS && me.shield_exp > 0) ||
		(option == INACTIVE_QUESTS && me.shield_exp <= 0)
	)
	{
		prfmsg(MSG364);

		if (me.shield_exp > 0)
		{
			sprintf(str, getmsg(MSG347), me.shield_exp);
			prf(str);
		}
		else
		{
			exp = Calc_Exp_Needed
			(
				me.shield + 1 + abs(globals->startshd),
				TRUE
			);

			if (me.class == WARRIOR)
			{
				exp = exp / 2;
			}
			
			sprintf(str, getmsg(MSG348), exp, (MLONG) (exp / level));
			prf(str);
		}
	}

	if 
	(
		(option == ACTIVE_QUESTS && me.two_wep_exp > 0) ||
		(option == INACTIVE_QUESTS && me.two_wep_exp <= 0)
	)
	{
		prfmsg(MSG365);

		if (me.two_wep_exp > 0)
		{
			sprintf(str, getmsg(MSG347), me.two_wep_exp);
			prf(str);
		}
		else
		{
			exp = Calc_Exp_Needed
			(
				me.two_wep + 1 + abs(globals->start2wp),
				TRUE
			);

			if
			(
				me.class == CLERIC ||
				me.class == MYSTIC ||
				me.class == SORCERER
			)
			{
				exp = exp * 2;
			}
			else if (me.class == WARRIOR)
			{
				exp = exp / 2;
			}
			
			sprintf(str, getmsg(MSG348), exp, (MLONG) (exp / level));
			prf(str);
		}
	}

	if (option == INACTIVE_QUESTS)
	{
		prf(NL);
	}
}
/*****************************************************************************
	If in academy, select a quest.
*/
short Select_Quest(short quest_num)
{
	MLONG   exp;
	short   index;
	float   level;
	short   old_level = Approximate_Level(P);
	
	if (Approximate_Level(P) > globals->xplev15)
	{
		level = .66;
	}
	else if (Approximate_Level(P) > globals->fexplev)
	{
		level = 1;
	}
	else
	{
		level = 2;
	}

	if (quest_num == 1)
	{
		if (me.str_exp > 0)
		{
			if (MY_PORT->status == ACADEMY_PROMPT2)
			{
				me.str_exp = -1;
				prf("OK\r");
				BAD_EXIT;
			}

			prfmsg(M369);
			BAD_EXIT;
		}
		else if (MY_PORT->status != ACADEMY_PROMPT1)
		{
			prfmsg(MSG1342);
			BAD_EXIT;
		}
		else
		{
			exp = Calc_Exp_Needed(me.Str, FALSE);

			if (me.race == OGRE)
			{
				exp = exp / 2;
			}

			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				Not_Enough_Gold((MLONG) (exp / level));
				BAD_EXIT;
			}
			else
			{
				me.gold -= (MLONG) (exp / level);
				if (me.gold < 0)
				{
					me.bank += me.gold;
					me.gold = 0;
				}
				me.str_exp = exp;

				if (me.generic_exp)
				{
					prfmsg(MSG370);
					me.str_exp -= me.generic_exp;

					if (me.str_exp > 0)
					{
						me.generic_exp = 0;
					}
					else
					{
						me.generic_exp = labs(me.str_exp);
						me.str_exp = -1;
						++me.Str;
						++MY_PORT->quests;
						prfmsg(MSG371);

						Set_Guy_Points
						(
							&me.dpts,
							&me.mpts,
							me.Str,
							me.Con,
							me.Psy,
							me.class
						);
	
						if 
						(
							Approximate_Level(P) > old_level &&
							!me.perm[INVIS_PORT_PERM]
						)
						{
							sprintf
							(
								str, 
								getmsg(MSG1355), 
								me.name, 
								me.title, 
								Approximate_Level(P)
							);
							Message(str, GLOBAL);
							prf("%s\r", str);
						}

						BAD_EXIT;
					}
				}
			}
		}
	}
	else if (quest_num == 2)
	{
		if (me.dex_exp > 0)
		{
			if (MY_PORT->status == ACADEMY_PROMPT2)
			{
				me.dex_exp = -1;
				prf("OK\r");
				BAD_EXIT;
			}

			prfmsg(M369);
			BAD_EXIT;
		}
		else if (MY_PORT->status != ACADEMY_PROMPT1)
		{
			prfmsg(MSG1342);
			BAD_EXIT;
		}
		else
		{
			exp = Calc_Exp_Needed(me.Dex, FALSE);

			if (me.race == HALFLING)
			{
				exp = exp / 2;
			}

			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				Not_Enough_Gold((MLONG) (exp / level));
				BAD_EXIT;
			}
			else
			{
				me.gold -= (MLONG) (exp / level);
				if (me.gold < 0)
				{
					me.bank += me.gold;
					me.gold = 0;
				}
				me.dex_exp = exp;

				if (me.generic_exp)
				{
					prfmsg(MSG370);
					me.dex_exp -= me.generic_exp;

					if (me.dex_exp > 0)
					{
						me.generic_exp = 0;
					}
					else
					{
						me.generic_exp = labs(me.dex_exp);
						me.dex_exp = -1;
						++me.Dex;
						++MY_PORT->quests;
						prfmsg(MSG372);

						if 
						(
							Approximate_Level(P) > old_level &&
							!me.perm[INVIS_PORT_PERM]
						)
						{
							sprintf
							(
								str, 
								getmsg(MSG1355), 
								me.name, 
								me.title, 
								Approximate_Level(P)
							);
							Message(str, GLOBAL);
							prf("%s\r", str);
						}

						BAD_EXIT;
					}
				}
			}
		}
	}
	else if (quest_num == 3)
	{
		if (me.con_exp > 0)
		{
			if (MY_PORT->status == ACADEMY_PROMPT2)
			{
				me.con_exp = -1;
				prf("OK\r");
				BAD_EXIT;
			}

			prfmsg(M369);
			BAD_EXIT;
		}
		else if (MY_PORT->status != ACADEMY_PROMPT1)
		{
			prfmsg(MSG1342);
			BAD_EXIT;
		}
		else
		{
			exp = Calc_Exp_Needed(me.Con, FALSE);

			if (me.race == DWARF)
			{
				exp = exp / 2;
			}

			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				Not_Enough_Gold((MLONG) (exp / level));
				BAD_EXIT;
			}
			else
			{
				me.gold -= (MLONG) (exp / level);
				if (me.gold < 0)
				{
					me.bank += me.gold;
					me.gold = 0;
				}
				me.con_exp = exp;

				if (me.generic_exp)
				{
					prfmsg(MSG370);
					me.con_exp -= me.generic_exp;

					if (me.con_exp > 0)
					{
						me.generic_exp = 0;
					}
					else
					{
						me.generic_exp = labs(me.con_exp);
						me.con_exp = -1;
						++me.Con;
						++MY_PORT->quests;
						prfmsg(MSG373);

						Set_Guy_Points
						(
							&me.dpts,
							&me.mpts,
							me.Str,
							me.Con,
							me.Psy,
							me.class
						);
						
						if 
						(
							Approximate_Level(P) > old_level &&
							!me.perm[INVIS_PORT_PERM]
						)
						{
							sprintf
							(
								str, 
								getmsg(MSG1355), 
								me.name, 
								me.title, 
								Approximate_Level(P)
							);
							Message(str, GLOBAL);
							prf("%s\r", str);
						}

						BAD_EXIT;
					}
				}
			}
		}
	}
	else if (quest_num == 4)
	{
		if (me.psy_exp > 0)
		{
			if (MY_PORT->status == ACADEMY_PROMPT2)
			{
				me.psy_exp = -1;
				prf("OK\r");
				BAD_EXIT;
			}

			prfmsg(M369);
			BAD_EXIT;
		}
		else if (MY_PORT->status != ACADEMY_PROMPT1)
		{
			prfmsg(MSG1342);
			BAD_EXIT;
		}
		else
		{
			exp = Calc_Exp_Needed(me.Psy, FALSE);
			
			if (me.race == ELF && me.class == CLERIC)
			{
				exp = exp / 3;
			}
			else if (me.race == ELF)
			{
				exp = exp / 2;
			}
			else if (me.class == CLERIC)
			{
				exp = exp / 2;
			}

			if
			(
				me.class != MYSTIC &&
				me.class != CLERIC &&
				me.class != SORCERER
			)
			{
				exp = exp * 2;
			}

			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				Not_Enough_Gold((MLONG) (exp / level));
				BAD_EXIT;
			}
			else
			{
				me.gold -= (MLONG) (exp / level);
				if (me.gold < 0)
				{
					me.bank += me.gold;
					me.gold = 0;
				}
				me.psy_exp = exp;
			}
		}
	}
	else if (quest_num == 5)
	{
		if (me.int_exp > 0)
		{
			if (MY_PORT->status == ACADEMY_PROMPT2)
			{
				me.int_exp = -1;
				prf("OK\r");
				BAD_EXIT;
			}

			prfmsg(M369);
			BAD_EXIT;
		}
		else if (MY_PORT->status != ACADEMY_PROMPT1)
		{
			prfmsg(MSG1342);
			BAD_EXIT;
		}
		else
		{
			exp = Calc_Exp_Needed(me.Int, FALSE);

			if (me.race == HUMAN)
			{
				exp = exp / 2;
			}

			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				Not_Enough_Gold((MLONG) (exp / level));
				BAD_EXIT;
			}
			else
			{
				me.gold -= (MLONG) (exp / level);
				if (me.gold < 0)
				{
					me.bank += me.gold;
					me.gold = 0;
				}
				me.int_exp = exp;

				if (me.generic_exp)
				{
					prfmsg(MSG370);
					me.int_exp -= me.generic_exp;

					if (me.int_exp > 0)
					{
						me.generic_exp = 0;
					}
					else
					{
						me.generic_exp = labs(me.int_exp);
						me.int_exp = -1;
						++me.Int;
						++MY_PORT->quests;
						prfmsg(MSG374);

						if 
						(
							Approximate_Level(P) > old_level &&
							!me.perm[INVIS_PORT_PERM]
						)
						{
							sprintf
							(
								str, 
								getmsg(MSG1355), 
								me.name, 
								me.title, 
								Approximate_Level(P)
							);
							Message(str, GLOBAL);
							prf("%s\r", str);
						}

						BAD_EXIT;
					}
				}
			}
		}
	}
	else if (quest_num == 6)
	{
		if (me.thief_exp > 0)
		{
			if (MY_PORT->status == ACADEMY_PROMPT2)
			{
				me.thief_exp = -1;
				prf("OK\r");
				BAD_EXIT;
			}

			prfmsg(M369);
			BAD_EXIT;
		}
		else if (MY_PORT->status != ACADEMY_PROMPT1)
		{
			prfmsg(MSG1342);
			BAD_EXIT;
		}
		else
		{
			if (me.class != THIEF)
			{
				exp = Calc_Exp_Needed(me.thief + 1, TRUE) * 2;
			}
			else
			{
				exp = Calc_Exp_Needed(me.thief - START_THIEF + 1, TRUE);
			}

			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				Not_Enough_Gold((MLONG) (exp / level));
				BAD_EXIT;
			}
			else
			{
				me.gold -= (MLONG) (exp / level);
				if (me.gold < 0)
				{
					me.bank += me.gold;
					me.gold = 0;
				}
				me.thief_exp = exp;
			}
		}
	}
	else if (quest_num == 7)
	{
		if (me.defense_exp > 0)
		{
			if (MY_PORT->status == ACADEMY_PROMPT2)
			{
				me.defense_exp = -1;
				prf("OK\r");
				BAD_EXIT;
			}

			prfmsg(M369);
			BAD_EXIT;
		}
		else if (MY_PORT->status != ACADEMY_PROMPT1)
		{
			prfmsg(MSG1342);
			BAD_EXIT;
		}
		else
		{
			exp = Calc_Exp_Needed(me.defense + 1, TRUE);

			if (me.class == WARRIOR)
			{
				exp = exp / 2;
			}

			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				Not_Enough_Gold((MLONG) (exp / level));
				BAD_EXIT;
			}
			else
			{
				me.gold -= (MLONG) (exp / level);
				if (me.gold < 0)
				{
					me.bank += me.gold;
					me.gold = 0;
				}
				me.defense_exp = exp;
			}
		}
	}
	else if (quest_num >= 8 && quest_num <= 11)
	{
		if (quest_num == 8)
		{
			index = BLUNT_IND;
		}
		else if (quest_num == 9)
		{
			index = HAND_IND;
		}
		else if (quest_num == 10)
		{
			index = EDGED_IND;
		}
		else if (quest_num == 11)
		{
			index = POLE_IND;
		}

		if (me.wep_exp[index] > 0)
		{
			if (MY_PORT->status == ACADEMY_PROMPT2)
			{
				me.wep_exp[index] = -1;
				prf("OK\r");
				BAD_EXIT;
			}

			prfmsg(M369);
			BAD_EXIT;
		}
		else if (MY_PORT->status != ACADEMY_PROMPT1)
		{
			prfmsg(MSG1342);
			BAD_EXIT;
		}
		else
		{
			exp = Calc_Exp_Needed(me.wep_plus[index] + 1, TRUE);

			if
			(
				(me.class == CLERIC && index != BLUNT_IND) ||
				(me.class == MYSTIC && index != HAND_IND) ||
				me.class == SORCERER
			)
			{
				exp = exp * 2;
			}
			else if (me.class == DUELIST && index != HAND_IND)
			{
				exp = exp / 2;
			}
			else if (me.class == CLERIC && index == BLUNT_IND)
			{
				exp = exp / 2;
			}

			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				Not_Enough_Gold((MLONG) (exp / level));
				BAD_EXIT;
			}
			else
			{
				me.gold -= (MLONG) (exp / level);
				if (me.gold < 0)
				{
					me.bank += me.gold;
					me.gold = 0;
				}
				me.wep_exp[index] = exp;
			}
		}
	}
	else if (quest_num == 12)
	{
		if (me.shield_exp > 0)
		{
			if (MY_PORT->status == ACADEMY_PROMPT2)
			{
				me.shield_exp = -1;
				prf("OK\r");
				BAD_EXIT;
			}

			prfmsg(M369);
			BAD_EXIT;
		}
		else if (MY_PORT->status != ACADEMY_PROMPT1)
		{
			prfmsg(MSG1342);
			BAD_EXIT;
		}
		else
		{
			exp = Calc_Exp_Needed
			(
				me.shield + 1 + abs(globals->startshd),
				TRUE
			);

			if (me.class == WARRIOR)
			{
				exp = exp / 2;
			}

			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				Not_Enough_Gold((MLONG) (exp / level));
				BAD_EXIT;
			}
			else
			{
				me.gold -= (MLONG) (exp / level);
				
				if (me.gold < 0)
				{
					me.bank += me.gold;
					me.gold = 0;
				}

				me.shield_exp = exp;
			}
		}
	}
	else if (quest_num == 13)
	{
		if (me.two_wep_exp > 0)
		{
			if (MY_PORT->status == ACADEMY_PROMPT2)
			{
				me.two_wep_exp = -1;
				prf("OK\r");
				BAD_EXIT;
			}

			prfmsg(M369);
			BAD_EXIT;
		}
		else if (MY_PORT->status != ACADEMY_PROMPT1)
		{
			prfmsg(MSG1342);
			BAD_EXIT;
		}
		else
		{
			exp = Calc_Exp_Needed
			(
				me.two_wep + 1 + abs(globals->start2wp),
				TRUE
			);

			if
			(
				me.class == CLERIC ||
				me.class == MYSTIC ||
				me.class == SORCERER
			)
			{
				exp = exp * 2;
			}
			else if (me.class == WARRIOR)
			{
				exp = exp / 2;
			}

			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				Not_Enough_Gold((MLONG) (exp / level));
				BAD_EXIT;
			}
			else
			{
				me.gold -= (MLONG) (exp / level);
				if (me.gold < 0)
				{
					me.bank += me.gold;
					me.gold = 0;
				}
				me.two_wep_exp = exp;
			}
		}
	}

	prfmsg(MSG375);
	DONE;
}
/*****************************************************************************
	set up my quests (after death or novice mode).
*/
short Auto_Quest(short quest_num, short option, short lev)
{
	MLONG   exp;
	short   index;
	float   level;
	short   old_level = lev;
	
	if (lev > globals->xplev15)
	{
		level = .66;
	}
	else if (lev > globals->fexplev)
	{
		level = 1;
	}
	else
	{
		level = 2;
	}

	if (quest_num == 1)
	{
		if (me.str_exp < 0 && option == DEATH)
		{
			DONE;
		}
		
		if (me.str_exp > 0 && option != DEATH)
		{
			DONE;
		}

		exp = Calc_Exp_Needed(me.Str, FALSE);

		if (me.race == OGRE)
		{
			exp = exp / 2;
		}

		if (option == AUTOTRAIN)
		{
			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				BAD_EXIT;
			}
			
			me.gold -= (MLONG) (exp / level);
			
			if (me.gold < 0)
			{
				me.bank += me.gold;
				me.gold = 0;
			}
		}

		me.str_exp = exp;

		if (me.generic_exp)
		{
			me.str_exp -= me.generic_exp;

			if (me.str_exp > 0)
			{
				me.generic_exp = 0;
			}
			else
			{
				me.generic_exp = labs(me.str_exp);
				me.str_exp = -1;
				++me.Str;
				++MY_PORT->quests;
				prfmsg(MSG371);

				Set_Guy_Points
				(
					&me.dpts,
					&me.mpts,
					me.Str,
					me.Con,
					me.Psy,
					me.class
				);
			}
		}
	}
	
	if (quest_num == 2)
	{
		if (me.dex_exp < 0 && option == DEATH)
		{
			DONE;
		}
		
		if (me.dex_exp > 0 && option != DEATH)
		{
			DONE;
		}

		exp = Calc_Exp_Needed(me.Dex, FALSE);

		if (me.race == HALFLING)
		{
			exp = exp / 2;
		}

		if (option == AUTOTRAIN)
		{
			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				BAD_EXIT;
			}
			
			me.gold -= (MLONG) (exp / level);
			if (me.gold < 0)
			{
				me.bank += me.gold;
				me.gold = 0;
			}
		}

		me.dex_exp = exp;

		if (me.generic_exp)
		{
			me.dex_exp -= me.generic_exp;

			if (me.dex_exp > 0)
			{
				me.generic_exp = 0;
			}
			else
			{
				me.generic_exp = labs(me.dex_exp);
				me.dex_exp = -1;
				++me.Dex;
				++MY_PORT->quests;
				prfmsg(MSG372);
			}
		}
	}
	
	if (quest_num == 3)
	{
		if (me.con_exp < 0 && option == DEATH)
		{
			DONE;
		}
		
		if (me.con_exp > 0 && option != DEATH)
		{
			DONE;
		}

		exp = Calc_Exp_Needed(me.Con, FALSE);

		if (me.race == DWARF)
		{
			exp = exp / 2;
		}

		if (option == AUTOTRAIN)
		{
			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				BAD_EXIT;
			}
			
			me.gold -= (MLONG) (exp / level);
			if (me.gold < 0)
			{
				me.bank += me.gold;
				me.gold = 0;
			}
		}

		me.con_exp = exp;

		if (me.generic_exp)
		{
			me.con_exp -= me.generic_exp;

			if (me.con_exp > 0)
			{
				me.generic_exp = 0;
			}
			else
			{
				me.generic_exp = labs(me.con_exp);
				me.con_exp = -1;
				++me.Con;
				++MY_PORT->quests;
				prfmsg(MSG373);

				Set_Guy_Points
				(
					&me.dpts,
					&me.mpts,
					me.Str,
					me.Con,
					me.Psy,
					me.class
				);
			}
		}
	}

	if (quest_num == 4)
	{
		if (me.psy_exp < 0 && option == DEATH)
		{
			DONE;
		}
		
		if (me.psy_exp > 0 && option != DEATH)
		{
			DONE;
		}

		exp = Calc_Exp_Needed(me.Psy, FALSE);
			
		if (me.race == ELF && me.class == CLERIC)
		{
			exp = exp / 3;
		}
		else if (me.race == ELF)
		{
			exp = exp / 2;
		}
		else if (me.class == CLERIC)
		{
			exp = exp / 2;
		}

		if
		(
			me.class != MYSTIC &&
			me.class != CLERIC &&
			me.class != SORCERER
		)
		{
			exp = exp * 2;
		}

		if (option == AUTOTRAIN)
		{
			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				BAD_EXIT;
			}
			
			me.gold -= (MLONG) (exp / level);
			if (me.gold < 0)
			{
				me.bank += me.gold;
				me.gold = 0;
			}
		}
				
		me.psy_exp = exp;
		DONE;
	}

	if (quest_num == 5)
	{
		if (me.int_exp < 0 && option == DEATH)
		{
			DONE;
		}
		
		if (me.int_exp > 0 && option != DEATH)
		{
			DONE;
		}

		exp = Calc_Exp_Needed(me.Int, FALSE);

		if (me.race == HUMAN)
		{
			exp = exp / 2;
		}

		if (option == AUTOTRAIN)
		{
			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				BAD_EXIT;
			}
			
			me.gold -= (MLONG) (exp / level);
			if (me.gold < 0)
			{
				me.bank += me.gold;
				me.gold = 0;
			}
		}

		me.int_exp = exp;

		if (me.generic_exp)
		{
			me.int_exp -= me.generic_exp;

			if (me.int_exp > 0)
			{
				me.generic_exp = 0;
			}
			else
			{
				me.generic_exp = labs(me.int_exp);
				me.int_exp = -1;
				++me.Int;
				++MY_PORT->quests;
				prfmsg(MSG374);
			}
		}
	}

	if (quest_num == 6)
	{
		if (me.thief_exp < 0 && option == DEATH)
		{
			DONE;
		}
		
		if (me.thief_exp > 0 && option != DEATH)
		{
			DONE;
		}

		if (me.class != THIEF)
		{
			exp = Calc_Exp_Needed(me.thief + 1, TRUE) * 2;
		}
		else
		{
			exp = Calc_Exp_Needed(me.thief - START_THIEF + 1, TRUE);
		}

		if (option == AUTOTRAIN)
		{
			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				BAD_EXIT;
			}
			
			me.gold -= (MLONG) (exp / level);
			if (me.gold < 0)
			{
				me.bank += me.gold;
				me.gold = 0;
			}
		}

		me.thief_exp = exp;
		DONE;
	}

	if (quest_num == 7)
	{
		if (me.defense_exp < 0 && option == DEATH)
		{
			DONE;
		}
		
		if (me.defense_exp > 0 && option != DEATH)
		{
			DONE;
		}

		exp = Calc_Exp_Needed(me.defense + 1, TRUE);
			
		if (me.class == WARRIOR)
		{
			exp = exp / 2;
		}

		if (option == AUTOTRAIN)
		{
			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				BAD_EXIT;
			}
			
			me.gold -= (MLONG) (exp / level);
			if (me.gold < 0)
			{
				me.bank += me.gold;
				me.gold = 0;
			}
		}

		me.defense_exp = exp;
		DONE;
	}

	if (quest_num >= 8 && quest_num <= 11)
	{
		if (quest_num == 8)
		{
			index = BLUNT_IND;
		}
		else if (quest_num == 9)
		{
			index = HAND_IND;
		}
		else if (quest_num == 10)
		{
			index = EDGED_IND;
		}
		else if (quest_num == 11)
		{
			index = POLE_IND;
		}
		
		if (me.wep_exp[index] < 0 && option == DEATH)
		{
			DONE;
		}
		
		if (me.wep_exp[index] > 0 && option != DEATH)
		{
			DONE;
		}

		exp = Calc_Exp_Needed(me.wep_plus[index] + 1, TRUE);

		if
		(
			(me.class == CLERIC && index != BLUNT_IND) ||
			(me.class == MYSTIC && index != HAND_IND) ||
			me.class == SORCERER
		)
		{
			exp = exp * 2;
		}
		else if (me.class == DUELIST && index != HAND_IND)
		{
			exp = exp / 2;
		}
		else if (me.class == CLERIC && index == BLUNT_IND)
		{
			exp = exp / 2;
		}

		if (option == AUTOTRAIN)
		{
			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				BAD_EXIT;
			}
			
			me.gold -= (MLONG) (exp / level);
			if (me.gold < 0)
			{
				me.bank += me.gold;
				me.gold = 0;
			}
		}

		me.wep_exp[index] = exp;
		DONE;
	}

	if (quest_num == 12)
	{
		if (me.shield_exp < 0 && option == DEATH)
		{
			DONE;
		}
		
		if (me.shield_exp > 0 && option != DEATH)
		{
			DONE;
		}
		
		exp = Calc_Exp_Needed
		(
			me.shield + 1 + abs(globals->startshd),
			TRUE
		);

		if (me.class == WARRIOR)
		{
			exp = exp / 2;
		}

		if (option == AUTOTRAIN)
		{
			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				BAD_EXIT;
			}
			
			me.gold -= (MLONG) (exp / level);
				
			if (me.gold < 0)
			{
				me.bank += me.gold;
				me.gold = 0;
			}
		}

		me.shield_exp = exp;
		DONE;
	}

	if (quest_num == 13)
	{
		if (me.two_wep_exp < 0 && option == DEATH)
		{
			DONE;
		}
		
		if (me.two_wep_exp > 0 && option != DEATH)
		{
			DONE;
		}

		exp = Calc_Exp_Needed
		(
			me.two_wep + 1 + abs(globals->start2wp),
			TRUE
		);

		if (me.class == CLERIC || me.class == MYSTIC || me.class == SORCERER)
		{
			exp = exp * 2;
		}
		else if (me.class == WARRIOR)
		{
			exp = exp / 2;
		}

		if (option == AUTOTRAIN)
		{
			if (Money() < (MLONG) (exp / level) && !me.perm[SUPER_PERM])
			{
				BAD_EXIT;
			}
			
			me.gold -= (MLONG) (exp / level);
			if (me.gold < 0)
			{
				me.bank += me.gold;
				me.gold = 0;
			}
		}

		me.two_wep_exp = exp;
		DONE;
	}

	if 
	(
		Approximate_Level(P) > old_level &&
		!me.perm[INVIS_PORT_PERM]
	)
	{
		sprintf
		(
			str, 
			getmsg(MSG1355), 
			me.name, 
			me.title, 
			Approximate_Level(P)
		);
		Message(str, GLOBAL);
		prf("%s\r", str);
		return (TRUE);
	}

	DONE;
}
/*****************************************************************************
	give thief experience for stealing something
*/
short Thief_Robbing_Experience(short level)
{
	MLONG   exp;

	if (me.thief_exp <= 0)
	{
		BAD_EXIT;
	}

	exp = Calc_Experience(level);
	exp = (exp * globals->thiefexp) / (globals->thiefexp + 1);

	if (level < me.thief)
	{
		exp = exp / globals->cheapexp;
	}
	else
	{
		exp += (MLONG) (level - me.thief) * globals->bonusexp;
	}

	if (exp <= 0)
	{
		exp = 1;
	}

	sprintf(str, getmsg(MSG376), exp);
	prf(str);
	
	me.thief_exp -= exp;
	MY_PORT->theft_exp += exp;

	if (me.thief_exp <= 0)
	{
		me.thief_exp = -1;
		++me.thief;
		++MY_PORT->quests;

		prfmsg(M377, me.thief);
	}

	DONE;
}
/*****************************************************************************
	reset my experience quests (new character or just died)
*/
void No_Quests(struct charstruct *guy)
{
	short   w;

	guy->str_exp = guy->dex_exp = guy->con_exp = -1;
	guy->psy_exp = guy->int_exp = -1;
	guy->thief_exp = guy->shield_exp = guy->two_wep_exp = -1;
	guy->defense_exp = -1;

	for (w = 0; w != NUM_WEAPONS; ++w)
	{
		guy->wep_exp[w] = -1;
	}
}
/******************************************************************************
	Count number of quests affected by a kill
*/
MLONG Quest_Ops(short option, short m, short g, MLONG exp)
{
	short   trancer = FALSE;
	short   captive = FALSE;
	MLONG   quests = 0;
	MLONG   extra_exp = 0;
	MLONG   extra;

	if (AMON->tranced_by[g])
	{
		trancer = TRUE;
	}
	
	if (invasion->active && AMON->which == globals->rover && SAFE_AREA)
	{
		captive = TRUE;
	}

	if (AGUY->defense_exp > 0 && !trancer)
	{
		++quests;

		if (option == DISTRIBUTE_EXPERIENCE)
		{
			if (AMON->my_ac_was_lower[P] == FALSE || captive)
			{
				AGUY->defense_exp -= exp;
				exp_awarded += exp;
			}
			else
			{
				AGUY->defense_exp -= (exp / globals->cheapexp);
				exp_awarded += (exp / globals->cheapexp);
			}

			if (AGUY->defense_exp <= 0)
			{
				++APORT(g)->quests;
				Message(getmsg(M378), g);
				extra_exp += labs(AGUY->defense_exp);
				exp_awarded += AGUY->defense_exp;
				AGUY->defense_exp = -1;
				++AGUY->defense;
			}
		}
	}

	if (AGUY->str_exp > 0 && !trancer)
	{
		++quests;

		if (option == DISTRIBUTE_EXPERIENCE)
		{
			if (captive)
			{
				AGUY->str_exp -= exp;
				exp_awarded += exp;
			}
			else if (AMON->Str > AGUY->Str)
			{
				extra = (MLONG) (AMON->Str - AGUY->Str) * globals->bonusexp;
				AGUY->str_exp -= exp + extra;
				exp_awarded += exp + extra;
			}
			else
			{
				AGUY->str_exp -= (exp / globals->cheapexp);
				exp_awarded += (exp / globals->cheapexp);
			}

			if (AGUY->str_exp <= 0)
			{
				++APORT(g)->quests;
				Message(getmsg(M379), g);
				extra_exp += labs(AGUY->str_exp);
				exp_awarded += AGUY->str_exp;
				AGUY->str_exp = -1;
				++AGUY->Str;

				Set_Guy_Points
				(
					&AGUY->dpts,
					&AGUY->mpts,
					AGUY->Str,
					AGUY->Con,
					AGUY->Psy,
					AGUY->class
				);
			}
		}
	}

	if (AGUY->int_exp > 0 && !trancer)
	{
		++quests;

		if (option == DISTRIBUTE_EXPERIENCE)
		{
			if (captive)
			{
				AGUY->int_exp -= exp;
				exp_awarded += exp;
			}
			else if (AMON->Int > AGUY->Int)
			{
				extra = (MLONG) (AMON->Int - AGUY->Int) * globals->bonusexp;
				AGUY->int_exp -= exp + extra;
				exp_awarded += exp + extra;
			}
			else
			{
				AGUY->int_exp -= exp / globals->cheapexp;
				exp_awarded += exp / globals->cheapexp;
			}

			if (AGUY->int_exp <= 0)
			{
				++APORT(g)->quests;
				Message(getmsg(M380), g);
				extra_exp += labs(AGUY->int_exp);
				exp_awarded += AGUY->int_exp;
				AGUY->int_exp = -1;
				++AGUY->Int;
			}
		}
	}

	if (AGUY->dex_exp > 0 && !trancer)
	{
		++quests;

		if (option == DISTRIBUTE_EXPERIENCE)
		{
			if (captive)
			{
				AGUY->dex_exp -= exp;
				exp_awarded += exp;
			}
			else if (AMON->Dex > AGUY->Dex)
			{
				extra = (MLONG) (AMON->Dex - AGUY->Dex) * globals->bonusexp;
				AGUY->dex_exp -= exp + extra;
				exp_awarded += exp + extra;
			}
			else
			{
				AGUY->dex_exp -= exp / globals->cheapexp;
				exp_awarded += exp / globals->cheapexp;
			}

			if (AGUY->dex_exp <= 0)
			{
				++APORT(g)->quests;
				Message(getmsg(M381), g);
				extra_exp += labs(AGUY->dex_exp);
				exp_awarded += AGUY->dex_exp;
				AGUY->dex_exp = -1;
				++AGUY->Dex;
			}
		}
	}

	if (AGUY->con_exp > 0 && !trancer)
	{
		++quests;

		if (option == DISTRIBUTE_EXPERIENCE)
		{
			if (captive)
			{
				AGUY->con_exp -= exp;
				exp_awarded += exp;
			}
			else if (AMON->Con > AGUY->Con && AMON->dpts > AGUY->dpts)
			{
				extra = (MLONG) (AMON->Con - AGUY->Con) * globals->bonusexp;
				AGUY->con_exp -= exp + extra;
				exp_awarded += exp + extra;
			}
			else
			{
				AGUY->con_exp -= exp / globals->cheapexp;
				exp_awarded += exp / globals->cheapexp;
			}

			if (AGUY->con_exp <= 0)
			{
				++APORT(g)->quests;
				Message(getmsg(M382), g);
				extra_exp += labs(AGUY->con_exp);
				exp_awarded += AGUY->con_exp;
				AGUY->con_exp = -1;
				++AGUY->Con;
				Set_Guy_Points
				(
					&AGUY->dpts,
					&AGUY->mpts,
					AGUY->Str,
					AGUY->Con,
					AGUY->Psy,
					AGUY->class
				);
			}
		}
	}

	if 
	(
		AGUY->psy_exp > 0 && 
		(AMON->spelled_by[g] || captive || trancer)
	)
	{
		++quests;

		if (option == DISTRIBUTE_EXPERIENCE)
		{
			if (captive)
			{
				AGUY->psy_exp -= exp;
				exp_awarded += exp;
			}
			else if (AMON->Psy > AGUY->Psy && !trancer)
			{
				extra = (MLONG) (AMON->Psy - AGUY->Psy) * globals->bonusexp;
				AGUY->psy_exp -= exp + extra;
				exp_awarded += exp + extra;
			}
			else if (trancer)
			{
				AGUY->psy_exp -= exp / (globals->cheapexp * 2);
				exp_awarded += exp / (globals->cheapexp * 2);
			}
			else
			{
				AGUY->psy_exp -= exp / globals->cheapexp;
				exp_awarded += exp / globals->cheapexp;
			}

			if (AGUY->psy_exp <= 0)
			{
				++APORT(g)->quests;
				Message(getmsg(M383), g);
				extra_exp += labs(AGUY->psy_exp);
				exp_awarded += AGUY->psy_exp;
				AGUY->psy_exp = -1;
				++AGUY->Psy;
				Set_Guy_Points
				(
					&AGUY->dpts,
					&AGUY->mpts,
					AGUY->Str,
					AGUY->Con,
					AGUY->Psy,
					AGUY->class
				);
			}
		}
	}

	if (AGUY->shield_exp > 0 && !trancer)
	{
		if (AGUY->shld >= 0 || captive)
		{
			++quests;

			if (option == DISTRIBUTE_EXPERIENCE)
			{
				if (!AMON->easy_hit[g] || captive)
				{
					AGUY->shield_exp -= exp;
					exp_awarded += exp;
				}
				else
				{
					AGUY->shield_exp -= exp / globals->cheapexp;
					exp_awarded += exp / globals->cheapexp;
				}

				if (AGUY->shield_exp <= 0)
				{
					++APORT(g)->quests;
					++AGUY->shield;
					extra_exp += labs(AGUY->shield_exp);
					exp_awarded += AGUY->shield_exp;
					AGUY->shield_exp = -1;
					Message(getmsg(M388), g);
				}
			}
		}
	}

	if (AMON->struck_by[g] || captive)
	{
		if (AGUY->wep_exp[BLUNT_IND] > 0)
		{
			if
			(
				(AGUY->lw >= 0 && AGUY->item[AGUY->lw].what == BLUNT) ||
				(AGUY->rw >= 0 && AGUY->item[AGUY->rw].what == BLUNT) ||
				captive
			)
			{
				++quests;

				if (option == DISTRIBUTE_EXPERIENCE)
				{
					if (!AMON->easy_hit[g] || captive)
					{
						AGUY->wep_exp[BLUNT_IND] -= exp;
						exp_awarded += exp;
					}
					else
					{
						AGUY->wep_exp[BLUNT_IND] -= exp / globals->cheapexp;
						exp_awarded += exp / globals->cheapexp;
					}

					if (AGUY->wep_exp[BLUNT_IND] <= 0)
					{
						++APORT(g)->quests;
						++AGUY->wep_plus[BLUNT_IND];
						extra_exp += labs(AGUY->wep_exp[BLUNT_IND]);
						exp_awarded += AGUY->wep_exp[BLUNT_IND];
						AGUY->wep_exp[BLUNT_IND] = -1;
						Message(getmsg(M384), g);
					}
				}
			}
		}

		if (AGUY->wep_exp[HAND_IND] > 0)
		{
			if
			(
				(AGUY->lw >= 0 && AGUY->item[AGUY->lw].what == NOHAND) ||
				(AGUY->rw >= 0 && AGUY->item[AGUY->rw].what == NOHAND) ||
				(AGUY->rw < 0 && AGUY->lw < 0) ||
				captive
			)
			{
				++quests;

				if (option == DISTRIBUTE_EXPERIENCE)
				{
					if (!AMON->easy_hit[g] || captive)
					{
						AGUY->wep_exp[HAND_IND] -= exp;
						exp_awarded += exp;
					}
					else
					{
						AGUY->wep_exp[HAND_IND] -= exp / globals->cheapexp;
						exp_awarded += exp / globals->cheapexp;
					}

					if (AGUY->wep_exp[HAND_IND] <= 0)
					{
						++APORT(g)->quests;
						++AGUY->wep_plus[HAND_IND];
						extra_exp += labs(AGUY->wep_exp[HAND_IND]);
						exp_awarded += AGUY->wep_exp[HAND_IND];
						AGUY->wep_exp[HAND_IND] = -1;
						Message(getmsg(M385), g);
					}
				}
			}
		}

		if (AGUY->wep_exp[EDGED_IND] > 0)
		{
			if
			(
				(AGUY->lw >= 0 && AGUY->item[AGUY->lw].what == EDGED) ||
				(AGUY->rw >= 0 && AGUY->item[AGUY->rw].what == EDGED) ||
				captive
			)
			{
				++quests;

				if (option == DISTRIBUTE_EXPERIENCE)
				{
					if (!AMON->easy_hit[g] || captive)
					{
						AGUY->wep_exp[EDGED_IND] -= exp;
						exp_awarded += exp;
					}
					else
					{
						AGUY->wep_exp[EDGED_IND] -= exp / globals->cheapexp;
						exp_awarded += exp / globals->cheapexp;
					}

					if (AGUY->wep_exp[EDGED_IND] <= 0)
					{
						++APORT(g)->quests;
						++AGUY->wep_plus[EDGED_IND];
						extra_exp += labs(AGUY->wep_exp[EDGED_IND]);
						exp_awarded += AGUY->wep_exp[EDGED_IND];
						AGUY->wep_exp[EDGED_IND] = -1;
						Message(getmsg(M386), g);
					}
				}
			}
		}

		if (AGUY->wep_exp[POLE_IND] > 0)
		{
			if
			(
				(AGUY->lw >= 0 && AGUY->item[AGUY->lw].what == POLE) ||
				(AGUY->rw >= 0 && AGUY->item[AGUY->rw].what == POLE) ||
				captive
			)
			{
				++quests;

				if (option == DISTRIBUTE_EXPERIENCE)
				{
					if (!AMON->easy_hit[g] || captive)
					{
						AGUY->wep_exp[POLE_IND] -= exp;
						exp_awarded += exp;
					}
					else
					{
						AGUY->wep_exp[POLE_IND] -= exp / globals->cheapexp;
						exp_awarded += exp / globals->cheapexp;
					}

					if (AGUY->wep_exp[POLE_IND] <= 0)
					{
						++APORT(g)->quests;
						++AGUY->wep_plus[POLE_IND];
						extra_exp += labs(AGUY->wep_exp[POLE_IND]);
						exp_awarded += AGUY->wep_exp[POLE_IND];
						AGUY->wep_exp[POLE_IND] = -1;
						Message(getmsg(M387), g);
					}
				}
			}
		}

		if (AGUY->two_wep_exp > 0)
		{
			if ((AGUY->lw >= 0 && AGUY->rw >= 0) || captive)
			{
				++quests;

				if (option == DISTRIBUTE_EXPERIENCE)
				{
					if (!AMON->easy_hit[g] || captive)
					{
						AGUY->two_wep_exp -= exp;
						exp_awarded += exp;
					}
					else
					{
						AGUY->two_wep_exp -= exp / globals->cheapexp;
						exp_awarded += exp / globals->cheapexp;
					}

					if (AGUY->two_wep_exp <= 0)
					{
						++APORT(g)->quests;
						++AGUY->two_wep;
						extra_exp += labs(AGUY->two_wep_exp);
						exp_awarded += AGUY->two_wep_exp;
						AGUY->two_wep_exp = -1;
						Message(getmsg(M389), g);
					}
				}
			}
		}
	}

	if (option == DISTRIBUTE_EXPERIENCE)
	{
		return (extra_exp);
	}
	else
	{
		return (quests);
	}
}
/******************************************************************************
	distribute experience from a kill
*/
void Give_Experience_From_Kill(short m, short g, short guys)
{
	MLONG   exp;
	MLONG   quests;
	MLONG   g_total;
	MLONG   m_total;
	MLONG   generic_exp;
	short   old_level = Approximate_Level(g);

	if (invasion->active && AMON->which == globals->rover && SAFE_AREA)
	{
		exp = lngopt(RESCEXP, 1, GCMAXLONG) / (MLONG) guys;
	}
	else
	{
		exp = Calc_Experience(AMON->Level) / (MLONG) guys;

		if (exp <= 0)
		{
			exp = 1;
		}

		if 
		(
			sameas(AMON->plural_name, globals->bounty.plural_name) || 
			AMON->which == globals->rover ||
			AMON->enhanced
		)
		{
			exp = exp * 2L;
		}
	}

	quests = Quest_Ops(COUNT_ACTUALS, m, g, NULL);
	exp_awarded = 0;

	if (quests == 0 && !AMON->tranced_by[g])
	{
		exp = exp / 2;
		g_total = (AGUY->Str + AGUY->Int + AGUY->Con + AGUY->Dex) / 4;
		m_total = (AMON->Str + AMON->Int + AMON->Con + AMON->Dex) / 4;

		if (m_total > g_total)
		{
			exp += (m_total - g_total) * globals->bonusexp;
		}
		else
		{
			exp = exp / globals->cheapexp;
		}
			
		generic_exp = globals->maxgenxp - AGUY->generic_exp;

		if (exp > generic_exp)
		{
			exp = generic_exp;
		}
			
		AGUY->generic_exp += exp;
		exp_awarded += exp;
	}
	else
	{
		while (quests && exp)
		{
			exp = exp / quests;

			if (exp <= 0)
			{
				exp = 1;
			}

			exp = Quest_Ops(DISTRIBUTE_EXPERIENCE, m, g, exp);
			quests = Quest_Ops(COUNT_ACTUALS, m, g, NULL);
		}

		if 
		(
			quests == 0 && 
			exp > 1 && 
			AGUY->generic_exp < globals->maxgenxp &&
			!AMON->tranced_by[g]
		)
		{
			exp = exp / 2;
			generic_exp = globals->maxgenxp - AGUY->generic_exp;
			
			if (exp > generic_exp)
			{
				exp = generic_exp;
			}

			AGUY->generic_exp += exp;
			exp_awarded += exp;
		}
	}

	if (exp_awarded)
	{
		sprintf(str, getmsg(MSG390), exp_awarded);
		APORT(g)->experience += exp_awarded;
		Message(str, g);
	}

	if 
	(
		Approximate_Level(g) > old_level &&
		!AGUY->perm[INVIS_PORT_PERM]
	)
	{
		sprintf
		(
			str, 
			getmsg(MSG1355), 
			AGUY->name, 
			AGUY->title, 
			Approximate_Level(g)
		);
		Message(str, GLOBAL);

		if (P >= 0)
		{
			prf("%s\r", str);
		}
	}
}
/******************************************************************************
	determine how much experience a monster is worth
*/
MLONG Calc_Experience(short level)
{
	MLONG   exp;
	MLONG   mod = globals->monexp;

	if (exp_mons)
	{
		mod += 25;
	}

	exp = level;
	exp = exp * mod;
	exp += (level / 2) + level;

	return (exp);
}
/****************************************************************************
	tell them they are poor
*/
void EXPORT Not_Enough_Gold(MLONG gold)
{

	sprintf(str, getmsg(M391), gold - Money());
	prf(str);
}
