#include <header.h>
#include <globals.h>

/****************************************************************************
    government functions
*/
short EXPORT Office_Menu(short option)
{

    if (option == 0)
    {
        prfmsg(MSG1407);
        Set_Prompt(getmsg(MSG1408), OFFICE_PROMPT); 
    }
    else if (option == 1)
    {
        if (MY_PORT->hot_menu)
        {
            MY_PORT->hot_menu = FALSE;
            MY_PORT->status = DO_PROMPT;
        }
        else
        {
            Set_Prompt(getmsg(MSG1408), OFFICE_PROMPT); 
        }
    }
    else if (sameas(margv[0], "A"))
    {
        Display_Offices();
        prf(NL);
        Office_Menu(1);
    }
    else if (sameas(margv[0], "B"))
    {
        Display_My_Votes(); 
        prf(NL);
        Office_Menu(1);
    }
    else if (sameas(margv[0], "C"))
    {
        if 
        (
            globals->socvote[0] && 
            !haskey(globals->socvote) && 
            !me.perm[GAMEOP_PERM]
        )
        {
            prfmsg(MSG1189);
            Office_Menu(1);
        }
        if 
        (
            (MLONG) me.Str + (MLONG) me.Int + 
            (MLONG) me.Psy + (MLONG) me.Dex + 
            (MLONG) me.Con < globals->votestat &&
            !me.perm[GAMEOP_PERM]
        )
        {
            prfmsg(MSG1190, globals->votestat);
            Office_Menu(1);
        }
        else if (globals->outlaws && me.outlaw != 'Y' && !me.perm[GAMEOP_PERM])
        {
            prfmsg(MSG1352);
            Office_Menu(1);
        }
        else
        {
            Set_Prompt(getmsg(MSG1409), VOTE_NAME_PROMPT); 
        }
    }
    else if (sameas(margv[0], "D"))
    {
        Abdicate(0);
    }
    else if (sameas(margv[0], "E"))
    {
        if (!MY_PORT->guv && !me.perm[GAMEOP_PERM])
        {
            prfmsg(MSG876, globals->offices[0]);
            Office_Menu(1);
        }
        else
        {
            Set_Prompt(getmsg(MSG1410), IMPEACH_PROMPT);
        }
    }
    else if (sameas(margv[0], "F"))
    {
        if (!MY_PORT->paladin && !me.perm[GAMEOP_PERM])
        {
            prfmsg(MSG877, globals->offices[1]);
            Office_Menu(1);
        }
        else
        {
            Set_Prompt(getmsg(MSG1412), ARREST_PROMPT2);
        }
    }
    else if (sameas(margv[0], "G"))
    {
        if (!MY_PORT->judge && !me.perm[GAMEOP_PERM])
        {
            prfmsg(MSG905, globals->offices[3]);
            Office_Menu(1);
        }
        else
        {
            Set_Prompt(getmsg(MSG1416), PAROLE_PROMPT);
        }
    }
    else if (sameas(margv[0], "H"))
    {
        if (!MY_PORT->judge && !me.perm[GAMEOP_PERM])
        {
            prfmsg(MSG905, globals->offices[3]);
            Office_Menu(1);
        }
        else if (!ynopt(PARDEVIL) && !me.perm[GAMEOP_PERM])
        {
            prfmsg(MSG907);
            Office_Menu(1);
        }
        else
        {
            Set_Prompt(getmsg(MSG1418), PARDON_PROMPT2);
        }
    }
    else if (sameas(margv[0], "I"))
    {
        if (!MY_PORT->judge && !me.perm[GAMEOP_PERM])
        {
            prfmsg(MSG927, globals->offices[3]);
            Office_Menu(1);
        }
        else if (!ynopt(GIVEEVIL) && !me.perm[GAMEOP_PERM])
        {
            prfmsg(MSG930);
            Office_Menu(1);
        }
        else
        {
            Set_Prompt(getmsg(MSG1420), PENALIZE_PROMPT2);
        }
    }
    else
    {
        prfmsg(MSG1407);
        Set_Prompt(getmsg(MSG1408), OFFICE_PROMPT);
    }
    
    DONE;
}
/****************************************************************************
    reset everyone's vote mins
*/
void Reset_Vote_Minutes(short o)
{
    short   i;
    short   n;
    short   index = 0;
    FILE    *fp_user;
                
    for (i = 0; i != NTERMS; ++i)
    {
        if (APORT(i)->status) 
        {
            APORT(i)->chr.vote_mins[o] = 0;
        }
    }

    fp_user = fopen(CHAOS_USER_FILE, RDWR);

    do
    {
        lsk = (MLONG) index * CHAR_SIZE;
        fseek(fp_user, lsk, TOP);
        n = fread(&a_char, CHAR_SIZE, 1, fp_user);

        if (n == 1 && !sameas(a_char.name, BLANK_RECORD)) 
        {
            fseek(fp_user, lsk, TOP);
            a_char.vote_mins[o] = 0;  
            fwrite(&a_char, CHAR_SIZE, 1, fp_user);
        }

        ++index;
    }
    while (n == 1);

    fclose(fp_user);
}
/***************************************************************************
    governor is going to impeach someone
*/
short Impeach(void)
{
    FILE    *fp;
    short   n;
    short   index;    
    short   held = 0;
    short   done = FALSE;
    char    today_date[DATE_SIZE];
    char    now_time[TIME_SIZE];
    struct  public_post_struct *msg;    
    
    msg = (struct public_post_struct *) vdaptr;                          
    setmem(msg, PUBLIC_MSG_SIZE, 0);
    msg->from = me.in_guild;
    msg->to = 0;
    
    TODAY(today_date);
    NOW(now_time);

    sprintf
    (
        msg->header, 
        getmsg(MSG1164),
        me.name,
        Brief_Userid(me.Userid),
        today_date,
        now_time
    );

    index = Find_A_Char(&a_char, margv[0]);
    
    if (index < 0)
    {
        prfmsg(M920, margv[0]);
        BAD_EXIT;
    }
            
    fp = fopen(VOTE_FILE, RDWR);
    
    if (fp == NULL)
    {
        NOTIFY("VOTE FILE OPEN FAILED!");
        BAD_EXIT;
    }

    for (n = 0; n != NUM_OFFICES && !done; ++n)
    {
        if (globals->officers[n] == index)
        {
            lsk = (MLONG) n * OFFICE_SIZE;
            fseek(fp, lsk, TOP);
            fread(&vote, OFFICE_SIZE, 1, fp);
            
            if (vote.index == index)            
            {
                ++held;
                prfmsg(MSG1166, a_char.name, globals->offices[n]);

                sprintf
                (
                    msg->body[0], 
                    getmsg(MSG1167),
                    globals->offices[n],
                    a_char.name
                );

                vote.index = -1;
                globals->officers[n] = -1;

                if (!vote.active)
                {
                    vote.last_vote = 0;
                    Reset_Vote_Minutes(n);
                }
                
                lsk = (MLONG) n * OFFICE_SIZE; 
                fseek(fp, lsk, TOP);
                fwrite(&vote, OFFICE_SIZE, 1, fp);

                Put_Public_Message(msg);
                done = TRUE;
            }
        }
    }

    fclose(fp);

    if (!held)
    {
        prfmsg(MSG1168, a_char.name);
    }
    DONE;
}
/*****************************************************************************
    user wants to quit an office
*/
short Abdicate(short option)
{
    short   i;
    short   held = 0;

    if (option == 0)
    {
        for (i = 0; i != NUM_OFFICES; ++i)
        {
            if (globals->officers[i] == MY_PORT->index)
            {
                prfmsg(MSG1169, i + 1, globals->offices[i]);
                ++held;
            }
        }
        prf(NL);

        if (held == 0)
        {
            prfmsg(MSG1170);
            Office_Menu(1);
            DONE;
        }

        sprintf(str, getmsg(MSG1171), NUM_OFFICES);
        Set_Prompt(str, ABDICATE_PROMPT);
    }
    else
    {
        i = INUM(margv[0]) - 1;

        if (i == 0 && MY_PORT->guv) 
        {
            Resign_Office(0);
            MY_PORT->guv = FALSE;
        }
        else if (i == 1 && MY_PORT->paladin)
        {
            Resign_Office(1);
            MY_PORT->paladin = FALSE;
        }
        else if (i == 2 && MY_PORT->assassin)
        {
            Resign_Office(2);
            MY_PORT->assassin = FALSE;
        }
        else if (i == 3 && MY_PORT->judge)
        {
            Resign_Office(3);
            MY_PORT->judge = FALSE;
        }
        else
        {
            prfmsg(MSG1172);
        }
    }

    DONE;
}
/****************************************************************************
    I abidcated from office
*/
short Resign_Office(short office)
{
    FILE    *fp;
    char    today_date[DATE_SIZE];
    char    now_time[TIME_SIZE];
    struct  public_post_struct *msg;    
    
    msg = (struct public_post_struct *) vdaptr;                          
    setmem(msg, PUBLIC_MSG_SIZE, 0);
    msg->from = me.in_guild;
    msg->to = 0;
    
    TODAY(today_date);
    NOW(now_time);

    sprintf
    (
        msg->header, 
        getmsg(MSG1173),
        me.name,
        Brief_Userid(me.Userid),
        today_date,
        now_time
    );

    fp = fopen(VOTE_FILE, RDWR);
    
    if (fp == NULL)
    {
        NOTIFY("VOTE FILE OPEN FAILED!");
        BAD_EXIT;
    }
    
    lsk = (MLONG) office * OFFICE_SIZE;
    fseek(fp, lsk, TOP);
    fread(&vote, OFFICE_SIZE, 1, fp);
            
    if (vote.index == MY_PORT->index)            
    {
        vote.index = -1;

        sprintf
        (
            msg->body[0], 
            getmsg(MSG1174),
            me.name,
            me.title,
            globals->offices[office]
        );
        
        if (!vote.active)
        {
            vote.last_vote = 0;
            Reset_Vote_Minutes(office);
        }
        globals->officers[office] = -1;
        
        lsk = (MLONG) office * OFFICE_SIZE; 
        fseek(fp, lsk, TOP);
        fwrite(&vote, OFFICE_SIZE, 1, fp);
        fclose(fp);

        Put_Public_Message(msg);
    }
    else
    {
        fclose(fp);
    }

    DONE;
}
/****************************************************************************
    remove any vote records related to user
*/
short Erase_Votes(short index)
{
    short   i;
    short   n;
    FILE    *fp;

    fp = fopen(VOTE_FILE, RDWR);
    
    if (fp == NULL)
    {
        NOTIFY("VOTE FILE OPEN FAILED!");
        BAD_EXIT;
    }
    
    for (n = 0; n != NUM_OFFICES; ++n)
    {
        lsk = (MLONG) n * OFFICE_SIZE;
        fseek(fp, lsk, TOP);
        fread(&vote, OFFICE_SIZE, 1, fp);
            
        if (vote.index == index)            
        {
            vote.index = -1;
            globals->officers[n] = -1;

            if (!vote.active)
            {
                vote.last_vote = 0;
                Reset_Vote_Minutes(n);
            }
        }

        for (i = 0; i != MAX_VOTES; ++i)
        {
            if (vote.votes_by[i] == index || vote.votes_for[i] == index)
            {
                vote.votes_for[i] = -1;
                vote.votes_by[i] = -1;
            }
        }
        
        lsk = (MLONG) n * OFFICE_SIZE; 
        fseek(fp, lsk, TOP);
        fwrite(&vote, OFFICE_SIZE, 1, fp);
    }

    fclose(fp);
    DONE;
}
/****************************************************************************
    display current office status as relates to me
*/
short Display_My_Votes(void)
{
    short   cur_days = cofdat(today());
    short   i;
    short   n;
    short   my_votes;
    short   my_vote;
    FILE    *fp;

    fp = fopen(VOTE_FILE, RDWR);
    
    if (fp == NULL)
    {
        NOTIFY("VOTE FILE OPEN FAILED!");
        BAD_EXIT;
    }
    
    for (n = 0; n != NUM_OFFICES; ++n)
    {
        my_votes = 0;
        my_vote = -1;
        prf(NL);

        i = fread(&vote, OFFICE_SIZE, 1, fp);
            
        if (i != 1 || !vote.active)
        {
            prfmsg(MSG1175, globals->offices[n]);
        }
        else
        {
            prfmsg
            (
                MSG1176, 
                globals->offices[n], 
                globals->votedays - (cur_days - cofdat(vote.last_vote))
            );
            
            for (i = 0; i != MAX_VOTES; ++i)
            {
                if (vote.votes_by[i] == MY_PORT->index)
                {
                    my_vote = vote.votes_for[i];
                }

                if (vote.votes_for[i] == MY_PORT->index)
                {
                    my_votes += Voting_Power(vote.votes_by[i]);
                }
            }

            if (my_vote != -1)
            {
                Read_A_Char(my_vote, &a_char);
                prfmsg(MSG1177, a_char.name, a_char.title);
            }
            else
            {
                prfmsg(MSG1178);
            }
            
            prfmsg(MSG1179, my_votes);
        }
    }

    fclose(fp);
    DONE;
}
/****************************************************************************
    the vote was cast, tally it
*/
short Cast_Vote(void)
{
    short   cur_days = cofdat(today());
    MLONG   mins_today;
    short   mins_needed;
    short   i;
    short   n;
    short   done;
    char    today_date[DATE_SIZE];
    char    now_time[TIME_SIZE];
    FILE    *fp;
    struct  public_post_struct *msg;    

    i = INUM(margv[0]) - 1;

    if 
    (
        (i == 0 && !ynopt(ACTGUV)) ||
        (i == 1 && !ynopt(ACTPAL)) ||
        (i == 2 && !ynopt(ACTASS)) ||
        (i == 3 && !ynopt(ACTJDG))
    )
    {
        prfmsg(MSG1180, globals->offices[i]);
        BAD_EXIT;
    }
    
    msg = (struct public_post_struct *) vdaptr;                          
    setmem(msg, PUBLIC_MSG_SIZE, 0);
    msg->from = me.in_guild;
    msg->to = 0;
    
    TODAY(today_date);
    NOW(now_time);

    sprintf
    (
        msg->header, 
        getmsg(MSG1181),
        me.name,
        Brief_Userid(me.Userid),
        today_date,
        now_time
    );

    mins_needed = globals->votemins;
    mins_needed -= me.vote_mins[i];
    mins_today = MY_PORT->secs_on / 60;
    mins_needed -= (short) mins_today;

    if (mins_needed > 0 && !me.perm[GAMEOP_PERM])
    {
        prfmsg(MSG1182, mins_needed);
        BAD_EXIT;
    }

    fp = fopen(VOTE_FILE, RDWR);

    if (fp == NULL)
    {
        NOTIFY("VOTE FILE OPEN FAILED!");
        BAD_EXIT;
    }
    
    lsk = (MLONG) i * OFFICE_SIZE;
    fseek(fp, lsk, TOP);
    fread(&vote, OFFICE_SIZE, 1, fp);
        
    if (!vote.active)
    {
        if 
        (
            vote.last_vote && 
            cur_days - cofdat(vote.last_vote) < globals->voteterm && 
            !me.perm[GAMEOP_PERM]
        )
        {
            prfmsg
            (
                MSG1183,          
                globals->voteterm - (cur_days - cofdat(vote.last_vote)), 
                globals->offices[i]
            );
            fclose(fp);
            BAD_EXIT;
        }
        
        prfmsg(MSG1184);
        for (n = 0; n != MAX_VOTES; ++n)
        {
            vote.votes_for[n] = -1;
            vote.votes_by[n] = -1;
        }

        vote.active = TRUE;
        vote.votes_by[0] = MY_PORT->index;
        vote.votes_for[0] = MY_PORT->misc;
        vote.last_vote = today();

        lsk = (MLONG) i * OFFICE_SIZE; 
        fseek(fp, lsk, TOP);
        fwrite(&vote, OFFICE_SIZE, 1, fp);

        sprintf(msg->body[0], getmsg(MSG1185), globals->offices[i]);
        sprintf(msg->body[1], getmsg(MSG1186), globals->votedays);

        Put_Public_Message(msg);
        Read_A_Char(MY_PORT->misc, &a_char);
        prfmsg(MSG1187, globals->offices[i], a_char.name);
    }
    else
    {
        for (n = 0; n != MAX_VOTES; ++n)
        {
            if (vote.votes_by[n] == MY_PORT->index)
            {
                vote.votes_by[n] = -1;
                vote.votes_for[n] = -1;
            }
        }
        
        for (n = done = 0; n != MAX_VOTES && !done; ++n)
        {
            if (vote.votes_for[n] == -1)
            {
                vote.votes_by[n] = MY_PORT->index;
                vote.votes_for[n] = MY_PORT->misc;
                done = TRUE;
            }
        }

        if (!done)
        {
            prfmsg(MSG1188);
        }
        else
        {
            lsk = (MLONG) i * OFFICE_SIZE; 
            fseek(fp, lsk, TOP);
            fwrite(&vote, OFFICE_SIZE, 1, fp);
            Read_A_Char(MY_PORT->misc, &a_char);
            prfmsg(MSG1187, globals->offices[i], a_char.name);
        }
    }

    fclose(fp);
    DONE;
}
/****************************************************************************
    display current office status
*/
short Display_Offices(void)
{
    short   cur_days = cofdat(today());
    short   activated;
    short   i, j;
    short   n;
    short   temp;
    short   index, high_index, second_index;
    short   count, high_count, second_count;
    char    last_date[DATE_SIZE];
    FILE    *fp;

    fp = fopen(VOTE_FILE, RDWR);
    
    if (fp == NULL)
    {
        NOTIFY("VOTE FILE OPEN FAILED!");
        BAD_EXIT;
    }
    
    for (n = 0; n != NUM_OFFICES; ++n)
    {
        prf(NL);
        i = fread(&vote, OFFICE_SIZE, 1, fp);

        if (i != 1)
        {
            fclose(fp);
            NOTIFY("VOTE FILE READ FAILED!");
            Init_Offices();
            BAD_EXIT;
        }
    
        if 
        (
            (n == 0 && !ynopt(ACTGUV)) ||
            (n == 1 && !ynopt(ACTPAL)) ||
            (n == 2 && !ynopt(ACTASS)) ||
            (n == 3 && !ynopt(ACTJDG))
        )
        {
            activated = FALSE;
        }
        else
        {
            activated = TRUE;
        }
        
        if (!activated)
        {
            prfmsg(MSG1192, globals->offices[n]);
        }
        else if (vote.index == -1)
        {
            prfmsg(MSG1193, globals->offices[n]);
        }
        else
        {
            Read_A_Char(vote.index, &a_char);

            CONV_DATE(last_date, a_char.last_date);
            prfmsg(MSG1194, globals->offices[n], a_char.name, a_char.title);
        }
        
        if (!vote.active && activated)
        {
            if (vote.last_vote == 0)
            {
                prfmsg(MSG1195);
            }
            else if (cur_days - cofdat(vote.last_vote) < globals->voteterm)
            {
                prfmsg
                (
                    MSG1196, 
                    globals->voteterm - (cur_days - cofdat(vote.last_vote))
                );
            }
            else
            {
                prfmsg(MSG1195);
            }
        }
        else if (activated)
        {
            prfmsg
            (
                MSG1197, 
                globals->votedays - (cur_days - cofdat(vote.last_vote))
            );
            
            for (i = 0; i != MAX_VOTES; ++i)
            {
                for (j = 0; j != MAX_VOTES; ++j)
                {
                    if (vote.votes_for[j] > vote.votes_for[i])
                    {
                        temp = vote.votes_for[j];
                        vote.votes_for[j] = vote.votes_for[i];
                        vote.votes_for[i] = temp;

                        temp = vote.votes_by[j];
                        vote.votes_by[j] = vote.votes_by[i];
                        vote.votes_by[i] = temp;
                    }
                }
            }

            count = 0;
            index = -1;
            high_index = -1;
            high_count = 0;
            second_index = -1;
            second_count = 0;

            for (i = 0; i != MAX_VOTES; ++i)
            {
                if (vote.votes_for[i] != -1)
                {
                    if (vote.votes_for[i] != index)
                    {
                        index = vote.votes_for[i];
                        count = Voting_Power(vote.votes_by[i]);
                    }
                    else
                    {
                        count += Voting_Power(vote.votes_by[i]);
                    }
                }

                if (count >= high_count && index != -1)
                {
                    if (index != high_index)
                    {
                        second_count = high_count;
                        second_index = high_index;
                    }

                    high_count = count;
                    high_index = index;
                }
                else if (count >= second_count && index != -1)
                {
                    second_count = count;
                    second_index = index;
                }
            }

            if (high_index != -1)
            {
                Read_A_Char(high_index, &a_char);
                prfmsg(MSG1198, high_count, a_char.name, a_char.title);
            }
            
            if (second_index != -1)
            {
                Read_A_Char(second_index, &a_char);
                prfmsg(MSG1198, second_count, a_char.name, a_char.title);
            }
        }
    }

    fclose(fp);

    DONE;
}
/****************************************************************************
    init the office file
*/
void Init_Offices(void)
{
    short   i;
    short   n;
    FILE    *fp;
    
    NOTIFY("OFFICE FILE INITTED");
    fp = fopen(VOTE_FILE, APPEND);

    for (i = 0; i != NUM_OFFICES; ++i)
    {
        globals->officers[i] = -1;
        vote.office = i;
        vote.index = -1;
        vote.last_vote = 0;
        vote.active = FALSE;
        Reset_Vote_Minutes(i);
            
        for (n = 0; n != MAX_VOTES; ++n)
        {
            vote.votes_for[n] = -1;
            vote.votes_by[n] = -1;
        }

        fwrite(&vote, OFFICE_SIZE, 1, fp);
    }

    fclose(fp);
}
/****************************************************************************
    check voting results
*/
short Vote_Check(void)
{
    short   cur_days = cofdat(today());
    short   days;
    short   i, j;
    short   n;
    short   temp;
    short   index, high_index, second_index;
    short   count, high_count, second_count;
    char    today_date[DATE_SIZE];
    char    now_time[TIME_SIZE];
    FILE    *fp;
    struct  public_post_struct msg;    
    
    setmem(&msg, PUBLIC_MSG_SIZE, 0);
    msg.from = 0;
    msg.to = 0;
    
    TODAY(today_date);
    NOW(now_time);

    sprintf
    (
        msg.header, 
        getmsg(MSG1199),
        today_date,
        now_time
    );

    fp = fopen(VOTE_FILE, RDWR);
    
    if (fp == NULL)
    {
        NOTIFY("VOTE FILE OPEN FAILED!");
        BAD_EXIT;
    }

    n = fread(&vote, OFFICE_SIZE, 1, fp);
    fclose(fp);
    
    if (n != 1)
    {
        Init_Offices();
        DONE;
    }
    
    fp = fopen(VOTE_FILE, RDWR); 

    if (fp == NULL)
    {
        NOTIFY("VOTE FILE OPEN FAILED!");
        BAD_EXIT;
    }

    for (n = 0; n != NUM_OFFICES; ++n)
    {
        lsk = (MLONG) n * OFFICE_SIZE;
        fseek(fp, lsk, TOP);
        i = fread(&vote, OFFICE_SIZE, 1, fp);

        if (i != 1)
        {
            fclose(fp);
            NOTIFY("VOTE FILE READ FAILED!");
            Init_Offices();
            BAD_EXIT;
        }

        globals->officers[n] = vote.index;
        
        if (vote.active)
        {
            days = cur_days - cofdat(vote.last_vote);

            if (days >= globals->votedays)
            {
                for (i = 0; i != MAX_VOTES; ++i)
                {
                    for (j = 0; j != MAX_VOTES; ++j)
                    {
                        if (vote.votes_for[j] > vote.votes_for[i])
                        {
                            temp = vote.votes_for[j];
                            vote.votes_for[j] = vote.votes_for[i];
                            vote.votes_for[i] = temp;

                            temp = vote.votes_by[j];
                            vote.votes_by[j] = vote.votes_by[i];
                            vote.votes_by[i] = temp;
                        }
                    }
                }

                count = 0;
                index = -1;
                high_index = -1;
                high_count = 0;
                second_index = -1;
                second_count = 0;

                for (i = 0; i != MAX_VOTES; ++i)
                {
                    if (vote.votes_for[i] != -1)
                    {
                        if (vote.votes_for[i] != index)
                        {
                            index = vote.votes_for[i];
                            count = Voting_Power(vote.votes_by[i]);
                        }
                        else
                        {
                            count += Voting_Power(vote.votes_by[i]);
                        }
                    }

                    if (count >= high_count && index != -1)
                    {
                        if (index != high_index)
                        {
                            second_count = high_count;
                            second_index = high_index;
                        }

                        high_count = count;
                        high_index = index;
                    }
                    else if (count >= second_count && index != -1)
                    {
                        second_count = count;
                        second_index = index;
                    }
                }

                if 
                (
                    high_index != -1 &&
                    second_index != -1 &&
                    high_count == second_count
                )
                {
                    ++vote.last_vote;
                    lsk = (MLONG) n * OFFICE_SIZE; 
                    fseek(fp, lsk, TOP);
                    fwrite(&vote, OFFICE_SIZE, 1, fp);

                    sprintf(msg.body[0], getmsg(MSG1200), globals->offices[n]);
                    Put_Public_Message(&msg);
                }
                else if (high_index != -1)
                {
                    vote.index = high_index;
                    globals->officers[n] = high_index;
                    vote.last_vote = today();
                    vote.active = FALSE;
                    Reset_Vote_Minutes(n);
                    
                    lsk = (MLONG) n * OFFICE_SIZE; 
                    fseek(fp, lsk, TOP);
                    fwrite(&vote, OFFICE_SIZE, 1, fp);

                    Read_A_Char(high_index, &a_char);

                    sprintf
                    (
                        msg.body[0], 
                        getmsg(MSG1201),
                        a_char.name,
                        a_char.title,
                        globals->offices[n]
                    );

                    Put_Public_Message(&msg);
                }
                else
                {
                    vote.last_vote = 0;
                    vote.active = FALSE;
                    Reset_Vote_Minutes(n);
                    
                    lsk = (MLONG) n * OFFICE_SIZE; 
                    fseek(fp, lsk, TOP);
                    fwrite(&vote, OFFICE_SIZE, 1, fp);

                    sprintf(msg.body[0], getmsg(MSG1202), globals->offices[n]);
                    Put_Public_Message(&msg);
                }
            }
        }
    }

    fclose(fp);
    DONE;
}
/***************************************************************************
    the high judge wants to free someone from jail
*/
short Parole(void)
{
    short   g;
    short   i;
    short   online = -1;

    for (g = 0; g != NTERMS; ++g)
    {
        if (APORT(g)->status && sameas(AGUY->name, margv[0]))
        {
            online = g;
        }
    }

    if (online < 0)
    {
        prfmsg(M920, margv[0]);
        BAD_EXIT;
    }

    g = online;

    if (APORT(g)->fine == 0)
    {
        prfmsg(MSG911, AGUY->name);
        BAD_EXIT;
    }

    sprintf(str, getmsg(MSG912), globals->offices[3], me.name, AGUY->name);
    Message(str, GLOBAL);
    prf("%s\r", str);
    
    APORT(g)->fine = 0;

    if (g == P)
    {
        teleport_to(globals->townsq);
    }
    else
    {
        for (i = 0; i != NTERMS; ++i)
        {
            APORT(i)->follower[g] = 0;
            APORT(g)->follower[i] = 0;
        }

        outprf(MY_PORT->usrnum);
        clrprf();
        Force_Guy_Move(g, globals->townsq);
        Send_Buf(APORT(g)->usrnum);
    }

    DONE;
}
/***************************************************************************
    the high judge wants to forgive some evil points
*/
short Pardon(void)
{
    short   g;
    short   index;
    short   online = -1;
    short   pts = MY_PORT->misc;

    index = Find_A_Char(&a_char, margv[0]);
    
    if (index < 0)
    {
        prfmsg(M920, margv[0]);
        BAD_EXIT;
    }
    
    for (g = 0; g != NTERMS; ++g)
    {
        if (APORT(g)->status && sameas(AGUY->name, a_char.name))
        {
            online = g;
        }
    }

    if (pts > a_char.evil)
    {
        pts = a_char.evil;
    }

    if (pts == 0)
    {
        prfmsg(MSG908, a_char.name);
        BAD_EXIT;
    }

    a_char.evil -= pts;
    prfmsg(MSG909, pts);

    if (online != P)
    {
        sprintf(str, getmsg(MSG910), me.name, pts);
        Message(str, online);
    }

    if (online >= 0)
    {
        APORT(online)->chr.evil -= pts;
        Write_Him(online);
    }
    else
    {
        Write_A_Char(index, &a_char);
    }

    DONE;
}
/***************************************************************************
    the high judge wants to assign evil points to someone
*/
short EXPORT Penalize(void)
{
    short   online = -1;
    short   g;
    short   index;
    short   pts = MY_PORT->misc;

    index = Find_A_Char(&a_char, margv[0]);
    
    if (index < 0)
    {
        prfmsg(M920, margv[0]);
        BAD_EXIT;
    }

    if (globals->outlaws && a_char.outlaw != 'Y' && !me.perm[GAMEOP_PERM])
    {
        prfmsg(MSG1316, a_char.name);
        BAD_EXIT;
    }

    prfmsg(MSG931, pts);
    
    for (g = 0; g != NTERMS; ++g)
    {
        if (APORT(g)->status && sameas(AGUY->name, a_char.name))
        {
            APORT(g)->chr.evil += pts;
            online = g;

            if (g != P)
            {
                sprintf(str, getmsg(MSG932), me.name, pts);
                Message(str, g);
            }
        }
    }

    if (online >= 0)
    {
        Write_Him(online);
    }
    else
    {
        a_char.evil += pts;
        Write_A_Char(index, &a_char);
    }

    DONE;
}
/****************************************************************************
    the paladin is going to arrest someone
*/
short EXPORT Arrest(void)
{
    short   palevil = numopt(PALEVIL, -32767, 32767);
    short   i;
    short   g;
    
    g = find_remote_guy(margv[0]);

    if (g <= 0)
    {
        BAD_EXIT;
    }

    if (g == P)
    {
        prfmsg(M468);
        BAD_EXIT;
    }

    if 
    (
        AGUY->perm[INVIS_PORT_PERM] || 
        AGUY->perm[GAMEOP_PERM] ||
        APORT(g)->judge
    )
    {
        prfmsg(M469, AGUY->name);
        BAD_EXIT;
    }

    if (AGUY->evil < palevil)
    {
        prfmsg(M470, AGUY->name);
        BAD_EXIT;
    }

    if (globals->outlaws && AGUY->outlaw != 'Y' && !me.perm[GAMEOP_PERM])
    {
        prfmsg(MSG1372, AGUY->name);
        BAD_EXIT;
    }

    APORT(g)->fine = MY_PORT->misc3;   
    APORT(g)->arrest_timer = 60;

    sprintf(str, getmsg(MSG472), me.name, MY_PORT->misc3);
    Message(str, g);

    sprintf(str, getmsg(M473), globals->offices[1], me.name, AGUY->name);
    Message(str, GLOBAL);

    teleport_to(globals->prison);

    sprintf(str, getmsg(MSG474), AGUY->name);
    Message(str, -(g + 1));

    for (i = 0; i != NTERMS; ++i)
    {
        APORT(i)->follower[g] = 0;
        APORT(g)->follower[i] = 0;
    }
    
    outprf(MY_PORT->usrnum);
    clrprf();
    Force_Guy_Move(g, globals->prison);
    Send_Buf(APORT(g)->usrnum);
    ABUF(B)->yell = 100;

    for (i = 0; i != 4; ++i)
    {
        if (ABUF(B)->mon[MAX_ROOM_MON - 1].what == 0)
        {
            Encounter(TRUE);
        }
    }

    ABUF(B)->yell = -1000;
    return (TRUE);
}
/**************************************************************************
    user wants to pay his fine
*/
short Pay_Fine(void)
{

    if (MY_PORT->fine == 0)
    {  
        prfmsg(MSG913);
        BAD_EXIT;
    }

    if (Money() < MY_PORT->fine)
    {
        sprintf(str, getmsg(MSG914), MY_PORT->fine);
        prf(str);
        BAD_EXIT;
    }

    me.gold -= MY_PORT->fine;
    if (me.gold < 0)
    {
        me.bank += me.gold;
        me.gold = 0;      
    }
    
    sprintf(str, getmsg(MSG915), me.name);
    Message(str, LOUD_LOCAL);

    teleport_to(globals->townsq);
    MY_PORT->fine = 0;

    DONE;
}
