#include <header.h>
#include <globals.h>

/****************************************************************************
	force a guy to change rooms
*/
void EXPORT Force_Guy_Move(short g, short i)
{

	Next_User(g);
	prf(NL);
	me.location = i;
	MY_PORT->hidden = FALSE;
	if (me.location < 1 || me.location > MAX_ROOM - 1)
	{
		me.location = globals->townsq;
	}
	Reveal_Me(-1);
	me.location = Closet_Check(me.location);
	move_me_to(me.location, CLEAR_OLD);
	Previous_User();
}
/****************************************************************************
	see if there are monsters where I want to go
*/
short EXPORT Danger_Move(short room_num)
{
	short   m;
	short   i;
	
	if (me.Option[NO_DANGER])
	{
		BAD_EXIT;
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (ABUF(i)->in_use && ABUF(i)->rm.id == room_num)
		{
			for (m = 0; m != MAX_ROOM_MON; ++m)
			{
				if (ABUF(i)->mon[m].what && !ABUF(i)->mon[m].alg)
				{
					return (TRUE);
				}
			}
		}
	}
	
	for (i = 0; i != MAX_PERM_MON; ++i)
	{
		if (abs(globals->perm_mon_loc[i]) == room_num)
		{
			Read_Critter(globals->perm_mon_id[i], &crit);

			if (!crit.alg)
			{
				return (TRUE);
			}
		}
	}

	if (invasion->active)
	{
		for (i = 0; i != MAX_INVASION_ROOMS; ++i)
		{
			if (invasion->room[i] == room_num && invasion->count[i])
			{
				return (TRUE);
			}
		}
	}

	Read_Room(room_num, &globals->next_room, &a_room2);

	if (globals->next_room.evil_mons)
	{
		return (TRUE);
	}

	return (FALSE);
}
/****************************************************************************
	put any following monsters into my new room
*/
void was_pursued(void)
{
	short   m;
	short   index;
	short   i;
	short   invis_t;
	short   see_invis_t;

	for (index = -1, m = MAX_ROOM_MON - 1; m >= 0; --m)
	{
		if (AMON->what == 0)
		{
			index = m;
		}
	}

	if (index < 0)
	{
		return; /* shouldn't happen? */
	}

	for (m = 0; m != MAX_ROOM_MON && index != MAX_ROOM_MON; ++m)
	{
		if (pursuers->mon[m].what)
		{
			ABUF(B)->mon[index] = pursuers->mon[m];
			ABUF(B)->mon[index].hidden = FALSE;

			if (command != DRAG)
			{
				sprintf
				(
					str,
					getmsg(M480),
					pursuers->mon[m].article,
					pursuers->mon[m].name,
					me.name
				);
			}
			else
			{
				sprintf
				(
					str,
					getmsg(MSG1544),
					me.name,
					pursuers->mon[m].article,
					pursuers->mon[m].name
				);
			}

			str[0] = toupper(str[0]);
			Message(str, LOUD_LOCAL);

			for (i = 1; i != NTERMS; ++i)
			{
				invis_t = find_timer(INVISIBLE_TIME, i, -1);
				see_invis_t = find_timer(SEE_INVIS_TIME, MON);

				if ((invis_t && !see_invis_t) || APORT(i)->hidden)
				{
					ABUF(B)->mon[index].sees[i] = FALSE;
				}
				else
				{
					ABUF(B)->mon[index].sees[i] = TRUE;
				}
			}

			if (command != DRAG)
			{
				MY_PORT->enemy_mon = index;
			}

			ABUF(B)->mon[index].last_attacker = P;
			ABUF(B)->mon[index].sees[P] = TRUE;
			++index;
		}
	}
}
/****************************************************************************
	see if any monsters want to chase me
*/
short Pursuit_Check(void)
{
	short   g;
	short   i;
	short   m;
	short   sleep_t;
	short   pursued;
	short   index = -1;
	short   slots;
	short   good_guys = FALSE;

	slots = monsters_can_go_to(me.location);

	if (slots <= 0)
	{
		return (-1);
	}
	
	for (i = 0; i != NTERMS; ++i)
	{
		if (ABUF(i)->in_use && ABUF(i)->rm.id == me.location)
		{
			for (g = 0; g != NTERMS; ++g)
			{
				if (ABUF(i)->guy[g] && APORT(g)->chr.outlaw != 'Y')
				{
					good_guys = TRUE;
				}
			}
		}
	}

	for (m = MAX_ROOM_MON - 1; m >= 0 && slots; --m) 
	{
		if (AMON->what)
		{
			sleep_t = find_timer(SLEEP_TIME, MON);
			pursued = FALSE;

			if 
			(
				RANDOM(100) < globals->folchnc || 
				(MY_PORT->action_timer && RANDOM(MY_PORT->action_timer) != 1)
			)
			{
				pursued = TRUE;
			}
			else if (AMON->pursue_forever && RANDOM(globals->escape) != 1)
			{
				pursued = TRUE;
			}

			if (AMON->permanant)
			{
				pursued = FALSE;
			}
			else if (invasion->active && AMON->which == invasion->crit)
			{
				pursued = FALSE;
			}
			else if (MY_PORT->drag_mon >= 0)
			{
				if (m == MY_PORT->drag_mon)
				{
					pursued = TRUE;
				}
				else
				{
					pursued = FALSE;
				}
			}
			else if (AMON->last_attacker != P)
			{
				pursued = FALSE;
			}
			else if (!AMON->sees[P] || AMON->bashed || sleep_t)
			{
				pursued = FALSE;
			}

			if (globals->outlaws && good_guys && !AMON->alg)
			{
				pursued = FALSE;
			}

			if (pursued)
			{
				++index;
				--slots;

				if (index == 0)
				{
					for (i = 0; i != MAX_ROOM_MON; ++i)
					{
						pursuers->mon[i].what = 0;
					}
				}
			 
				if (command != DRAG || m != MY_PORT->drag_mon)
				{
					Start_Mon_Name(name, m);
					prfmsg(M481, name);

					sprintf(str, getmsg(MSG482), name, me.name);
					Message(str, QUIET_LOCAL);
				}
				else
				{
					MY_PORT->dragged = TRUE;
					prfmsg(MSG1541, name, MY_PORT->str);
					sprintf(str, getmsg(MSG1542), me.name, name, MY_PORT->str);
					Message(str, LOUD_LOCAL);
				}

				memcpy(&pursuers->mon[index], AMON, MON_SIZE);
				globals->pursued = TRUE;
				Remove_Mon(m, FALSE);
				globals->pursued = FALSE;
				--m;
			}
		}
	}

	return (index);
}
/*****************************************************************************
	zero followers and following
*/
void No_Follow(void)
{
	short   g;

	for (g = 0; g != NTERMS; ++g)
	{
		MY_PORT->follower[g] = 0;
		APORT(g)->follower[P] = 0;
	}
}
/****************************************************************************
	see if user is suitable to enter a special place
*/
short Filter_Check(void)
{
	short   i;
  
	if (ABUF(B)->rm.spec_exit.filter == 0)
	{
		return (TRUE);
	}

	if (ABUF(B)->rm.spec_exit.filter < NUM_SAVED_PLACES)
	{
		if
		(
			me.in_guild != ABUF(B)->rm.spec_exit.filter &&
			!me.perm[GAMEOP_PERM]
		)
		{
			prfmsg(MSG484);
			BAD_EXIT;
		}

		return (TRUE);
	}
	else if (ABUF(B)->rm.spec_exit.filter == UNUSED_FILTER)
	{
		ABUF(B)->rm.spec_exit.filter = 0;
		lsk = (MLONG) ABUF(B)->rm.id * ROOMSIZE;
		fseek(fp_room, lsk, TOP);
		fwrite(&ABUF(B)->rm, ROOMSIZE, 1, fp_room);
		return (TRUE);
	}
	else if (ABUF(B)->rm.spec_exit.filter == ITEM_FILTER)
	{
		for (i = 0; i != NUM_ITEMS; ++i)
		{
			if (me.item[i].what && me.item[i].id == ABUF(B)->rm.filter_spec)
			{
				return (TRUE);
			}
		}
		
		prfmsg(MSG484);
		return (FALSE);
	}
	else if (ABUF(B)->rm.spec_exit.filter == CLASS_FILTER)
	{
		if (toupper(me.class) == toupper(ABUF(B)->rm.filter_spec))
		{
			return (TRUE);
		}
		
		prfmsg(MSG484);
		return (FALSE);
	}
	else if (ABUF(B)->rm.spec_exit.filter == RACE_FILTER)
	{
		if (toupper(me.race) == toupper(ABUF(B)->rm.filter_spec))
		{
			return (TRUE);
		}
		
		prfmsg(MSG484);
		return (FALSE);
	}
	else if (ABUF(B)->rm.spec_exit.filter == OFFICER_FILTER)
	{
		if 
		(
			MY_PORT->guv || 
			MY_PORT->assassin || 
			MY_PORT->judge ||
			MY_PORT->paladin
		)
		{
			return (TRUE);
		}
		
		prfmsg(MSG484);
		return (FALSE);
	}
	else if (ABUF(B)->rm.spec_exit.filter == GUV_FILTER)
	{
		if (MY_PORT->guv)
		{
			return (TRUE);
		}
		
		prfmsg(MSG484);
		return (FALSE);
	}
	else if (ABUF(B)->rm.spec_exit.filter == ASSASSIN_FILTER)
	{
		if (MY_PORT->assassin)
		{
			return (TRUE);
		}
		
		prfmsg(MSG484);
		return (FALSE);
	}
	else if (ABUF(B)->rm.spec_exit.filter == PALADIN_FILTER)
	{
		if (MY_PORT->paladin)
		{
			return (TRUE);
		}
		
		prfmsg(MSG484);
		return (FALSE);
	}
	else if (ABUF(B)->rm.spec_exit.filter == JUDGE_FILTER)
	{
		if (MY_PORT->judge)
		{
			return (TRUE);
		}
		
		prfmsg(MSG484);
		return (FALSE);
	}
	else if (ABUF(B)->rm.spec_exit.filter == LEVEL_FILTER)
	{
		if (ABUF(B)->rm.filter_spec < 0)
		{
			if (Approximate_Level(P) > abs(ABUF(B)->rm.filter_spec))
			{
				prfmsg(MSG1370, abs(ABUF(B)->rm.filter_spec));
				return (FALSE);
			}
		}
		else if (ABUF(B)->rm.filter_spec > 0)
		{
			if (Approximate_Level(P) < ABUF(B)->rm.filter_spec)
			{
				prfmsg(MSG1369, ABUF(B)->rm.filter_spec);
				return (FALSE);
			}
		}

		return (TRUE);
	}

	DONE;
}
/****************************************************************************
	user is leaving room, clean it up after him
*/
short clear_old_room(void)
{
	short   m;
	short   g;
	short   i;
	short   in_use = FALSE;

	MY_PORT->enemy_mon = -1;
	ABUF(B)->guy[P] = FALSE;

	for (m = MAX_ROOM_MON - 1; m >= 0; --m)
	{
		if (AMON->what)
		{
			AMON->sees[P] = FALSE;
			AMON->hurt_by[P] = FALSE;
			AMON->spelled_by[P] = FALSE;
			AMON->tranced_by[P] = FALSE;
			AMON->struck_by[P] = FALSE;
			AMON->my_ac_was_lower[P] = FALSE;
			AMON->easy_hit[P] = FALSE;
			AMON->I_hit[P] = FALSE;

			if (AMON->summoned_by == MY_PORT->index)
			{
				Start_Mon_Name(name, m);
				sprintf(str, getmsg(MSG1318), name);
				Message(str, LOUD_LOCAL);
				globals->pursued = TRUE;
				Remove_Mon(m, FALSE);
				globals->pursued = FALSE;
			}
			else if (AMON->last_attacker == P)
			{
				AMON->last_attacker = -1;
			}
		}
	}

	for (g = 0; g != NTERMS; ++g)
	{
		if (ABUF(B)->guy[g])
		{
			in_use = TRUE;
		}
	}

	if (!in_use)
	{
		if (SAFE_AREA)
		{
			for (i = 0; i != NUM_SAVED_PLACES; ++i)
			{
				if (ABUF(B)->rm2.Turf_Kills[i])
				{
					ABUF(B)->rm2.Turf_Kills[i] = 0;
					ABUF(B)->turf_change = TRUE;
				}
			}
		}

		if (ABUF(B)->turf_change)
		{
			Write_Room2(&ABUF(B)->rm2, ABUF(B)->rm.id);
		}
		
		if (ABUF(B)->rm.rmtype == CLOSET)
		{
			Write_Closet
			(
				MY_PORT->index, 
				(struct closet_struct *) ABUF(B)->item
			);
		}
		else
		{
			ABUF(B)->rm.items_or_mons = FALSE;

			for (i = 0; i != NUM_ITEMS; ++i)
			{
				if (ABUF(B)->item[i].what)
				{
					ABUF(B)->rm.items_or_mons = TRUE;
				}
			}

			for (m = 0; m != MAX_ROOM_MON; ++m)
			{
				if (AMON->what)
				{
					ABUF(B)->rm.items_or_mons = TRUE;

					if (AMON->permanant)
					{
						for (i = 0; i != MAX_PERM_MON; ++i)
						{
							if (globals->perm_mon_id[i] == AMON->which)
							{
								globals->perm_mon_dmg[i] = AMON->damage;
							}
						}
					}
				}
			}

			if (ABUF(B)->item_change || ABUF(B)->crit_change)
			{
				Write_Sticky();
			}
		}

		if (ABUF(B)->item_change || ABUF(B)->crit_change)
		{
			Write_Room(&ABUF(B)->rm);
		}
	}

	ABUF(B)->in_use = in_use;
	DONE;
}
/****************************************************************************
	see if monsters are too fond of me to allow me to leave
*/
short Stop_Me_Check(short r)
{
	short   invis_t;
	short   m;
	short   sleep_t;
	short   see_invis_t;
	short   slots;

	slots = monsters_can_go_to(r);
	invis_t = find_timer(INVISIBLE_TIME, ME);

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		sleep_t = find_timer(SLEEP_TIME, MON);

		if
		(
			AMON->what &&
			(AMON->last_attacker == P || MY_PORT->fine) &&
			(AMON->blocks || AMON->pursue_forever) &&
			!AMON->bashed &&
			!sleep_t
		)
		{
			see_invis_t = find_timer(SEE_INVIS_TIME, MON);
			   
			if (ABUF(B)->rm.id == globals->prison && MY_PORT->fine)
			{
				return (m);
			}

			if 
			(
				!me.perm[SUPER_PERM] && 
				me.class != THIEF && 
				(!invis_t || see_invis_t)
			)
			{
				if
				(
					RANDOM(me.Dex * 2) < RANDOM(AMON->Dex) ||
					(
						AMON->pursue_forever && 
						RANDOM(globals->escape) != 1 &&
						slots == 0
					)
				)
				{
					return(m);
				}
			}
		}
	}

	return (-1);
}
/****************************************************************************
	move me into a new or existing room
*/
short move_me_to(short rm, short option)
{
	short   room;
	short   i;
	short   t;
	short   dragged_by = -1;
	short   see_t;
	short   invis_t;
	short   m;
	short   watched         = FALSE;
	short   pursued         = FALSE;
	short   avail           = -1;
	short   found_one       = FALSE;
	short   was_arena       = FALSE;

	MY_PORT->next_hit       = NORMAL;
	MY_PORT->show_pts       = FALSE;
	MY_PORT->damage_timer   = 0;
	
	if (rm < 0)
	{
		pursued = TRUE;
	}
	room = abs(rm);

	if (room > globals->maxroom)
	{
		me.location = globals->townsq;
		room = globals->townsq;
	}

	for (t = 0; t != NUM_GUY_TIMERS; ++t)
	{
		if (MY_PORT->misc_type[t] == CIRCLE_TIME)
		{
			MY_PORT->timer[t] = 0;
		}
	}

	if (option)
	{
		if (TYPE == ARENA)
		{
			was_arena = TRUE;
		}

		clear_old_room();
	}

	if (room == 0)
	{
		BAD_EXIT;
	}

	for (i = 0, B = MY_PORT->B = -1; i != NTERMS; ++i)
	{
		ABUF(i)->guy[P] = FALSE;

		if (ABUF(i)->in_use && ABUF(i)->rm.id == room)
		{
			found_one = TRUE;
			B = i;
			MY_PORT->B = i;
		}
		else if (!ABUF(i)->in_use)
		{
			avail = i;
		}
	}

	if (!found_one)
	{
		MY_PORT->B = avail;
		B = avail;

		Read_Room(room, &ABUF(B)->rm, &ABUF(B)->rm2);

		if
		(
			ABUF(B)->rm.spec_exit.type == DOOR ||
			ABUF(B)->rm.spec_exit.type == MAGIC_DOOR ||
			ABUF(B)->rm.spec_exit.type == CHANT_DOOR ||
			ABUF(B)->rm.spec_exit.type == SPECIAL_DOOR
		)
		{
			ABUF(B)->rm.spec_exit.locked = TRUE;
		}

		for (i = 0; i != NUM_EXITS; ++i)
		{
			ABUF(B)->visible[i] = ABUF(B)->rm.Visible[i];
		}

		ABUF(B)->visible[NUM_EXITS] = ABUF(B)->rm.spec_exit.Visible;

		ABUF(B)->in_use = TRUE;
		ABUF(B)->turf_change = FALSE;
		ABUF(B)->item_change = FALSE;
		ABUF(B)->crit_change = FALSE;
		ABUF(B)->death_room = FALSE;
		ABUF(B)->yell = 0;
		ABUF(B)->room_timer = 2;
		ABUF(B)->enc_speed = globals->encrate;

		for (m = 0; m != MAX_ROOM_MON; ++m)
		{
			AMON->what = 0;
		}
		for (i = 0; i != NUM_ITEMS; ++i)
		{
			ABUF(B)->item[i].what = 0;
		}
	}

	ABUF(B)->guy[P] = TRUE;

	if (!found_one)
	{
		Put_Perms_In(ABUF(B)->rm.id, pursued);
	}

	invis_t = find_timer(INVISIBLE_TIME, ME);
	
	if (TYPE == ARENA && !was_arena)
	{
		MY_PORT->arena_timer = ARENA_TIME;
	}

	if (ABUF(B)->rm.cover < 25)
	{
		MY_PORT->hidden = FALSE;
	}
	else if (me.thief < globals->thide || me.class != THIEF) 
	{
		MY_PORT->hidden = FALSE;
	}
	else
	{
		MY_PORT->hidden = TRUE;
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what)
		{
			if
			(
				AMON->what == HUNTRESS &&
				MY_PORT->questing &&
				MY_PORT->quest_type == 0 &&
				sameas(AMON->name, MY_PORT->quest_mon)
			)
			{
				--MY_PORT->quests_left;
				prfmsg(MSG677, me.name);
				New_Huntress_Quest();
			}

			if (MY_PORT->hidden)
			{
				see_t = FALSE;
			}
			else
			{
				see_t = find_timer(SEE_INVIS_TIME, -1, m);
			}

			if (AMON->hidden)
			{
				AMON->sees[P] = TRUE;
			}
			else if 
			(
				!see_t && 
				(invis_t || MY_PORT->hidden) && 
				!AMON->permanant
			)
			{
				AMON->sees[P] = FALSE;
			}
			else
			{
				AMON->sees[P] = TRUE;
			}

			if (!watched && AMON->sees[P] && !AMON->hidden)
			{
				prfmsg(M487);
				++watched;
			}
		}
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (ABUF(B)->guy[i] && i != P && APORT(i)->drag_guy == P)
		{
			dragged_by = i;
		}
	}

	if (!me.perm[INVIS_PORT_PERM] && !MY_PORT->hidden && found_one)
	{
		if (dragged_by < 0)
		{
			sprintf(str, getmsg(MSG488), me.name);
			Message(str, QUIET_LOCAL);
		}
		else
		{
			sprintf(str, getmsg(MSG1546), APORT(dragged_by)->chr.name, me.name);
			Message(str, -(dragged_by + 1));
			sprintf(str, getmsg(MSG1547), me.name);
			Message(str, dragged_by);
		}
	}

	if (pursued)
	{
		was_pursued();
	}

	print_room();
	
	if (Find_Ring(REVEAL, ME))
	{
		for (i = 1; i != NTERMS; ++i)
		{
			if (ABUF(B)->guy[i] && i != P)
			{
				if (APORT(i)->hidden)
				{
					prfmsg(MSG790, APORT(i)->chr.name);
				}
			}
		}

		for (m = 0; m != MAX_ROOM_MON; ++m)
		{
			if (AMON->what && AMON->hidden)
			{
				Monster_Name(name, AMON->article, AMON->name);
				sprintf(str, getmsg(MSG1350), me.name, name);
				Message(str, LOUD_LOCAL);
				prfmsg(MSG1351, name);
				AMON->hidden = FALSE;
				AMON->action_timer = AMON->action_timer / 3;
			}
		}
	}

	if (!sameas(MY_PORT->command, "login"))
	{
		Do_Trap(ABUF(B)->rm.trap);

		if (MY_PORT->big_sleep)
		{
			DONE;
		}
	}

	if (ABUF(B)->rm.rmtype == DAMAGE_ROOM)
	{
		One_Shot_Damage();
		if (MY_PORT->big_sleep)
		{
			DONE;
		}
	}

	if (IN_GUILD)
	{
		if (GUILD_NUM != me.in_guild && !me.perm[GAMEOP_PERM])
		{
			teleport_to(globals->townsq);
		}
	}

	if (ABUF(B)->rm.id == globals->townsq)
	{
		me.ftg = 0;
		me.damaged = 0;
		me.magic_used = 0;
	}

	if (ABUF(B)->rm.rmtype == ARENA && MY_PORT->my_bet == 0 && Money() != 0)
	{
		Set_Prompt(getmsg(MSG1483), BET_PROMPT);
	}
	
	Menu_Notice();
	DONE;
}
/****************************************************************************
	see if I stumble into a trap
*/
short Do_Trap(short which)
{
	short   i;
	short   t;
	short   sturdy;
	short   pure;
	short   protected_t;
	short   dmg;

	if (ABUF(B)->rm.rmtype == NO_MAGIC && !me.perm[SUPER_PERM])
	{
		prfmsg(MSG72);
		me.magic_used = me.mpts;
					
		for (t = 0; t != NUM_GUY_TIMERS; ++t)
		{
			if (MY_PORT->misc_type[t] != KO_TIME)
			{
				i = MY_PORT->misc_type[t];
				MY_PORT->misc_type[t] = 0;

				if (i == MES_TIME)
				{
					MY_PORT->action_timer = 1;
				}

				guy_time_expired(P, i); 
			}
		}
	}

	if (which <= 0)
	{
		BAD_EXIT;
	}
	
	protected_t = find_timer(PROTECTED_TIME, ME);

	if 
	(
		me.perm[SUPER_PERM] || 
		RANDOM(100) < me.Int || 
		protected_t ||
		me.race == HUMAN
	)
	{
		prfmsg(MSG490);
		BAD_EXIT;
	}

	sprintf(str, getmsg(MSG491), me.name);
	Message(str, LOUD_LOCAL);
	prfmsg(M492);

	switch (which)
	{
		case POISON_TRAP:
			sturdy = find_timer(STURDY_TIME, ME);
			pure = Find_Ring(PURIFY, ME);
			prfmsg(MSG493);
			
			if (!sturdy && !pure)
			{
				prfmsg(MSG102);

				if (me.poison_timer < 60)
				{
					me.poison_timer = 60;
				}
			}
			break;

		case BOMB_TRAP:
			dmg = RANDOM(me.dpts) * 2;
			prfmsg(M495, dmg);
			me.damaged += dmg;

			if (me.damaged > me.dpts)
			{
				sprintf(str, getmsg(MSG496), me.name, me.title);
				Message(str, GLOBAL);
				Got_Killed(USER_DEATH);
			}
			break;

		case TELEPORT_TRAP:
			teleport_to(Find_Teleport_Room());
			break;

		case LANGOUR_TRAP:
			Make_A_Timer(SLOW_TIME, 180, ME, RESET);
			prfmsg(MSG497);
			break;

		case SLEEP_TRAP:
			Make_A_Timer(SLEEP_TIME, 60, ME, RESET);
			prfmsg(MSG498);
			break;

		case AGGRIVATION_TRAP:
			Make_A_Timer(MAGNET_TIME, 120, ME, RESET);
			prfmsg(MSG499);
			break;

		case WEAKNESS_TRAP:
			Make_A_Timer(WEAK_TIME, 120, ME, RESET);
			prfmsg(MSG71);
			break;

		case DISPEL_TRAP:
			prfmsg(MSG72);
			me.magic_used = me.mpts;
					
			for (t = 0; t != NUM_GUY_TIMERS; ++t)
			{
				if (MY_PORT->misc_type[t] != KO_TIME)
				{
					MY_PORT->timer[t] = 1;

					if (MY_PORT->misc_type[t] == MES_TIME)
					{
						MY_PORT->action_timer = 1;
					}
				}
			}
	}

	DONE;
}
/****************************************************************************
	one-shot damage type room
*/
short One_Shot_Damage(void)
{
	short   dmg;

	if (me.perm[SUPER_PERM])
	{
		prfmsg(MSG500);
		BAD_EXIT;
	}

	sprintf(str, getmsg(MSG501), me.name);
	Message(str, LOUD_LOCAL);

	dmg = RANDOM(me.dpts);
	prfmsg(M502, dmg);
	me.damaged += dmg;

	if (me.damaged > me.dpts)
	{
		sprintf(str, getmsg(MSG503), me.name, me.title);
		Message(str, GLOBAL);
		Got_Killed(USER_DEATH);
	}
	DONE;
}
/****************************************************************************
	put permamant monsters and items into new room
*/
void Put_Perms_In(short loc, short pursued)
{
	short   i;
	short   j;
	short   found;

	if (!ABUF(B)->rm.sticky_fix)
	{
		if (SAVED_AREA)
		{
			Read_Guild_Storage
			(
				abs(TYPE),
				(struct closet_struct *) ABUF(B)->item
			);
		}
		else if (ABUF(B)->rm.rmtype == UNUSED_RMTYPE)
		{
			Old_Read_Sticky
			(
				ABUF(B)->rm.id, 
				(struct closet_struct *) ABUF(B)->item
			);
			ABUF(B)->rm.rmtype = 0;
		}
		else if (ABUF(B)->rm.rmtype == CLOSET)
		{
			Read_Closet
			(
				MY_PORT->index, 
				(struct closet_struct *) ABUF(B)->item
			);
		}

		ABUF(B)->rm.sticky_fix = TRUE;
		ABUF(B)->item_change = TRUE;

		if (ABUF(B)->item[0].what == 0)
		{
			Read_Sticky();
		}
	}
	else
	{
		if (ABUF(B)->rm.rmtype == CLOSET)
		{
			Read_Closet
			(
				MY_PORT->index, 
				(struct closet_struct *) ABUF(B)->item
			);
		}
		else if (ABUF(B)->rm.items_or_mons)
		{
			Read_Sticky();
		}
	}

	for (i = 0; i != MAX_PERM_MON; ++i)
	{
		if (abs(globals->perm_mon_loc[i]) == loc && loc)
		{
			if (ABUF(B)->mon[MAX_ROOM_MON - 1].what != 0)
			{
				Remove_Mon(0, FALSE);
			}

			Summon
			(
				globals->perm_mon_id[i], 
				SUMMON_PERM,
				globals->perm_mon_dmg[i]
			);
		}
	}

	if (invasion->active)
	{
		for (i = 0; i != MAX_INVASION_ROOMS; ++i)
		{
			if (loc && invasion->room[i] == loc)
			{
				for (j = 0; j != invasion->count[i]; ++j)
				{
					if (ABUF(B)->mon[MAX_ROOM_MON - 1].what == 0)
					{
						Summon(invasion->crit, SUMMON_INVADER, 0L);
					}
				}
			}
		}
	}

	if (globals->ambush && ABUF(B)->rm.cover && !pursued)
	{
		for (i = 0; i < globals->ambushm; ++i)
		{
			if (ABUF(B)->mon[MAX_ROOM_MON - 1].what == 0)
			{
				Encounter(TRUE);
			}
		}
	}

	for (i = 0; i != MAX_PERM_ITEM; ++i)
	{
		if 
		(
			globals->perm_item_loc[i] == loc && 
			loc && 
			globals->perm_item_id[i]
		)
		{
			for (j = found = 0; j != NUM_ITEMS; ++j)
			{
				if 
				(
					ABUF(B)->item[j].what &&
					ABUF(B)->item[j].id == globals->perm_item_id[i]
				)
				{
					found = TRUE;
				}
			}

			if (!found)
			{
				Read_Item(globals->perm_item_id[i], &item);

				if (item.item_level == 0)
				{
					item.item_level = Approximate_Level(P);
				}

				Create_Item
				(
					item.id, 
					NULL, 
					100, 
					item.item_level, 
					FALSE
				);
				   
				Put_In_Room(&new_item);
			}
		}
	}
}
/****************************************************************************
	user wants to lose someone
*/
short lose(void)
{
	short   g;
	short   invis_t;
	short   see_invis_t;
	short   absolute_match = 0;

	if (word1[0] == 0)
	{
		prfmsg(M504);
		BAD_EXIT;
	}

	if ((g = find_guy(word1, 1, &absolute_match)) >= 0)
	{
		invis_t = find_timer(INVISIBLE_TIME, GUY);
		see_invis_t = find_timer(SEE_INVIS_TIME, ME);

		if (g == P)
		{
			prfmsg(M505);
			BAD_EXIT;
		}

		if ((invis_t && !see_invis_t) || !MY_PORT->follower[g])
		{
			prfmsg(M506, word1);
			BAD_EXIT;
		}

		if (RANDOM(AGUY->Dex) < RANDOM(me.Dex) && AGUY->thief < globals->tlose)
		{
			prfmsg(MSG507, AGUY->name);
			sprintf(str, getmsg(M508), me.name);
			MY_PORT->follower[g] = FALSE;
		}
		else
		{
			prfmsg(M509, AGUY->name);
			sprintf(str, getmsg(M510), me.name);
		}

		Message(str, g);
	}
	DONE;
}
/****************************************************************************
	user wants to stop following someone
*/
void stop_following(void)
{
	short   g;
	short   invis_t;
	short   see_invis_t;

	sprintf(str, getmsg(MSG511), me.name);

	for (g = 0; g != NTERMS; ++g)
	{
		if (APORT(g)->follower[P] && ABUF(B)->guy[g])
		{
			prfmsg(MSG512, AGUY->name);

			APORT(g)->follower[P] = 0;

			invis_t = find_timer(INVISIBLE_TIME, ME);
			see_invis_t = find_timer(SEE_INVIS_TIME, GUY);

			if ((!invis_t || see_invis_t) && !me.perm[INVIS_PORT_PERM])
			{
				Message(str, g);
			}
		}
	}
}
/****************************************************************************
	user wants to follow someone
*/
short follow(void)
{
	short   g;
	short   invis_t;
	short   see_invis_t;
	short   absolute_match = 0;

	for (g = 0; g != NTERMS; ++g)
	{
		if (MY_PORT->follower[g])
		{
			prfmsg(M513);
			BAD_EXIT;
		}
	}

	if (word1[0] == 0)
	{
		stop_following();
		BAD_EXIT;
	}

	if (me.perm[GAMEOP_PERM])
	{
		g = find_remote_guy(word1);

		if (g <= 0)
		{
			BAD_EXIT;
		}

		if (AGUY->location != me.location)
		{
			teleport_to(AGUY->location);
		}
	}

	g = find_guy(word1, 1, &absolute_match);

	if (g < 0) 
	{
		BAD_EXIT;
	}

	if (g == P)
	{
		prfmsg(M514);
		BAD_EXIT;
	}
	
	if (APORT(g)->follower[P])
	{
		prfmsg(M515);
		BAD_EXIT;
	}

	No_Follow();
	APORT(g)->follower[P] = TRUE;
	prfmsg(MSG516, AGUY->name);
	sprintf(str, getmsg(M517), me.name);
	invis_t = find_timer(INVISIBLE_TIME, ME);
	see_invis_t = find_timer(SEE_INVIS_TIME, GUY);
	
	if
	(
		(!invis_t || see_invis_t) &&
		!me.perm[INVIS_PORT_PERM] &&
		me.thief < globals->tfollow
	)
	{
		Message(str, g);
	}
	DONE;
}
/****************************************************************************
	user wants to run away in a panic
*/
void Flee(void)
{
	short   exit;

	prfmsg(MSG518);
	sprintf(str, getmsg(MSG519), me.name);
	Message(str, QUIET_LOCAL);

	if (me.rw >= 0)
	{
		Put_In_Room(&me.item[me.rw]);
		Lose_Item(me.rw);
	}

	if (me.lw >= 0)
	{
		Put_In_Room(&me.item[me.lw]);
		Lose_Item(me.lw);
	}

	if (me.shld >= 0)
	{
		Put_In_Room(&me.item[me.shld]);
		Lose_Item(me.shld);
	}

	if (me.focus >= 0)
	{
		Put_In_Room(&me.item[me.focus]);
		Lose_Item(me.focus);
	}

	No_Follow();

	do
	{
		exit = RANDOM(NUM_EXITS + 1) - 1;

		if (exit == NUM_EXITS)
		{
			if 
			(
				!ABUF(B)->rm.spec_exit.locked &&
				ABUF(B)->visible[NUM_EXITS] &&
				!ABUF(B)->rm.spec_exit.filter
			)
			{
				me.location = ABUF(B)->rm.spec_exit.leads_to;
			}
			else
			{
				me.location = 0;
			}
		}
		else
		{
			if (ABUF(B)->visible[exit])
			{
				me.location = ABUF(B)->rm.exit[exit];
			}
			else
			{
				me.location = 0;
			}
		}
	}
	while (me.location == 0);

	me.location = Closet_Check(me.location);
	move_me_to(me.location, CLEAR_OLD);
}
/****************************************************************************
	user wants to go to a special exit.
*/
short Go_Special(short option)
{
	short   asleep = find_timer(SLEEP_TIME, ME);
	short   ko_d = find_timer(KO_TIME, ME);
	short   i;

	if (option == 0)
	{
		if (word1[0] == 0)
		{
			prfmsg(MSG882);
			BAD_EXIT;
		}
		
		if 
		(
			ABUF(B)->rm.spec_exit.type == 0 || 
			ABUF(B)->rm.spec_exit.leads_to == 0
		)
		{
			prfmsg(M542, word1);
			BAD_EXIT;
		}
		
		if 
		(
			!sameto(word1, ABUF(B)->rm.spec_exit.descriptor) &&
			!sameto(word1, ABUF(B)->rm.spec_exit.adjective)
		)
		{
			prfmsg(M542, word1);
			BAD_EXIT;
		}
	}

	if (MY_PORT->bashed)
	{
		prfmsg(MSG881);
		BAD_EXIT;
	}

	if (asleep)
	{
		prfmsg(MSG310);
		BAD_EXIT;
	}
			
	if (ko_d)
	{
		prfmsg(MSG311);
		BAD_EXIT;
	}

	if 
	(
		ABUF(B)->rm.spec_exit.type == CHANT_DOOR &&
		ABUF(B)->rm.spec_exit.locked
	)   
	{
		Set_Prompt(getmsg(MSG1482), CHANT_PROMPT);
		BAD_EXIT;
	}

	if 
	(
		ABUF(B)->rm.spec_exit.type == SPECIAL_DOOR &&
		ABUF(B)->rm.spec_exit.locked
	)   
	{
		prfmsg(MSG883);
		BAD_EXIT;
	}

	if (ABUF(B)->rm.spec_exit.locked && !Find_Ring(PASS_DOOR, ME))
	{
		if (ABUF(B)->rm.spec_exit.type == DOOR)
		{
			if (me.thief < globals->tlock)
			{
				prfmsg(MSG883);
				BAD_EXIT;
			}
		}
		else if (ABUF(B)->rm.spec_exit.type == MAGIC_DOOR)
		{
			if 
			(
				me.thief < globals->tlock ||
				me.class != THIEF
			)
			{
				prfmsg(MSG883);
				BAD_EXIT;
			}
		}
	}

	if 
	(
		ABUF(B)->rm.spec_exit.type == 0 || 
		ABUF(B)->rm.spec_exit.leads_to == 0
	)
	{
		prfmsg(M520);
		BAD_EXIT;
	}

	if (option == 0 && Danger_Move(ABUF(B)->rm.spec_exit.leads_to))
	{
		Set_Prompt(getmsg(MSG521), DANGER_GO_PROMPT);
		DONE;
	}

	i = Stop_Me_Check(ABUF(B)->rm.spec_exit.leads_to);

	if (i >= 0)
	{
		if (option == 0 && MY_PORT->fine)
		{
			sprintf(str, getmsg(MSG1413), MY_PORT->fine);
			prf(str);
			Set_Prompt(getmsg(MSG1414), FINE_GO_PROMPT);
			DONE;
		}

		Start_Mon_Name(name, i);
		prfmsg(M522, name);
		sprintf(str, getmsg(MSG523), name, me.name);
		Message(str, LOUD_LOCAL);
	}
	else if (Filter_Check())
	{
		Went_Spec();
	}

	DONE;
}
/****************************************************************************
	set my tracks on the way out
*/
short Set_Tracks(short dir)
{
	short   index = -1;
	short   i;

	for (i = 0; i != MAX_TRACKS; ++i)
	{
		if 
		(
			globals->track_room[i] == ABUF(B)->rm.id && 
			globals->track_dir[i] == dir
		)
		{
			BAD_EXIT;
		}
		else if (globals->track_room[i] == 0 && index < 0)
		{
			index = i;
		}
	}

	if (index == -1)
	{
		for (i = 1; i != MAX_TRACKS; ++i)
		{
			globals->track_room[i - 1] = globals->track_room[i];
			globals->track_dir[i - 1] = globals->track_dir[i];
			index = MAX_TRACKS - 1;
		}
	}

	globals->track_room[index] = ABUF(B)->rm.id;
	globals->track_dir[index] = dir;
	DONE;
}
/****************************************************************************
	user went through a special exit
*/
short Went_Spec(void)
{
	short   g;
	short   i;
	short   ok;
	short   pursued;
	short   followers;

	if (!Go_Closet(ABUF(B)->rm.spec_exit.leads_to))
	{
		prfmsg(M524);
		BAD_EXIT;
	}

	if (MY_PORT->drag_mon >= 0)
	{
		i = me.location;
		me.location = ABUF(B)->rm.spec_exit.leads_to;
		pursued = Pursuit_Check();
		me.location = i;

		if (!MY_PORT->dragged)
		{
			BAD_EXIT;
		}
	}
	else if (MY_PORT->drag_guy >= 0)
	{
		MY_PORT->dragged = TRUE;
		prfmsg(MSG1541, APORT(MY_PORT->drag_guy)->chr.name, MY_PORT->str);
		sprintf(str, getmsg(MSG1542), me.name, "you", MY_PORT->str);
		Message(str, MY_PORT->drag_guy);
		sprintf
		(
			str, 
			getmsg(MSG1542), 
			me.name, 
			APORT(MY_PORT->drag_guy)->chr.name,
			MY_PORT->str
		);
		Message(str, -(MY_PORT->drag_guy + 1));
	}

	for (g = 1, followers = 0; g != NTERMS; ++g)
	{
		if (MY_PORT->follower[g])
		{
			if (ABUF(B)->rm.spec_exit.filter)
			{
				if (ABUF(B)->rm.spec_exit.filter < NUM_SAVED_PLACES)
				{
					if (AGUY->in_guild != ABUF(B)->rm.spec_exit.filter)
					{
						MY_PORT->follower[g] = FALSE;
					}
				}
				else if (ABUF(B)->rm.spec_exit.filter == ITEM_FILTER)
				{
					for (i = ok = 0; i != NUM_ITEMS; ++i)
					{
						if 
						(
							AGUY->item[i].what && 
							AGUY->item[i].id == ABUF(B)->rm.filter_spec
						)
						{
							ok = TRUE;
						}
					}

					if (!ok)
					{
						MY_PORT->follower[g] = FALSE;
					}
				}
				else if (ABUF(B)->rm.spec_exit.filter == CLASS_FILTER)
				{
					if (toupper(AGUY->class) != toupper(ABUF(B)->rm.filter_spec))
					{
						MY_PORT->follower[g] = FALSE;
					}
				}
				else if (ABUF(B)->rm.spec_exit.filter == RACE_FILTER)
				{
					if (toupper(AGUY->race) != toupper(ABUF(B)->rm.filter_spec))
					{
						MY_PORT->follower[g] = FALSE;
					}
				}
				else if (ABUF(B)->rm.spec_exit.filter == OFFICER_FILTER)
				{
					if 
					(
						!APORT(g)->guv &&
						!APORT(g)->assassin &&
						!APORT(g)->judge &&
						!APORT(g)->paladin
					)
					{
						MY_PORT->follower[g] = FALSE;
					}
				}
				else if (ABUF(B)->rm.spec_exit.filter == GUV_FILTER)
				{
					if (!APORT(g)->guv)
					{
						MY_PORT->follower[g] = FALSE;
					}
				}
				else if (ABUF(B)->rm.spec_exit.filter == ASSASSIN_FILTER)
				{
					if (!APORT(g)->assassin)
					{
						MY_PORT->follower[g] = FALSE;
					}
				}
				else if (ABUF(B)->rm.spec_exit.filter == PALADIN_FILTER)
				{
					if (!APORT(g)->paladin)
					{
						MY_PORT->follower[g] = FALSE;
					}
				}
				else if (ABUF(B)->rm.spec_exit.filter == JUDGE_FILTER)
				{
					if (!APORT(g)->judge)
					{
						MY_PORT->follower[g] = FALSE;
					}
				}
				else if (ABUF(B)->rm.spec_exit.filter == LEVEL_FILTER)
				{
					if (ABUF(B)->rm.filter_spec < 0)
					{
						if (Approximate_Level(g) > abs(ABUF(B)->rm.filter_spec))
						{
							MY_PORT->follower[g] = FALSE;
						}
					}
					else if (ABUF(B)->rm.filter_spec > 0)
					{
						if (Approximate_Level(g) < ABUF(B)->rm.filter_spec)
						{
							MY_PORT->follower[g] = FALSE;
						}
					}
				}
			}
		}

		if (MY_PORT->follower[g])
		{
			++followers;
		}
	}

	if (followers)
	{
		sprintf(globals->who, getmsg(MSG525), me.name);
	}
	else
	{
		sprintf(globals->who, "%s", me.name);
	}

	sprintf(str, getmsg(MSG526), globals->who);
	cat_spec_ex(str);

	if (!me.perm[INVIS_PORT_PERM] && command != DRAG)
	{
		Message(str, QUIET_LOCAL);
	}

	Set_Tracks(NUM_EXITS);

	for (i = 0; i != NTERMS; ++i)
	{
		if (ABUF(B)->guy[i])
		{
			APORT(i)->follower[P] = FALSE;
		}
	}

	me.location = ABUF(B)->rm.spec_exit.leads_to;

	if (MY_PORT->drag_mon < 0)
	{
		pursued = Pursuit_Check();
	}

	Captive_Check(me.location);

	if (pursued < 0)
	{
		move_me_to(me.location, CLEAR_OLD);
	}
	else
	{
		move_me_to(-me.location, CLEAR_OLD);
	}

	Do_Followers();
	Fatigue(ADD); 
	DONE;
}
/****************************************************************************
	move a user in the direction indicated by 'command'
*/
short Moving(short option)
{
	short   i;
	short   followers;
	short   dir;
	short   pursued;

	if (option == 0)
	{
		dir = MY_PORT->misc = command - NORTH;

		if (ABUF(B)->rm.exit[dir] == 0)
		{
			prfmsg(M527);
			BAD_EXIT;
		}

		if (MY_PORT->limbo_return)
		{
			if (Danger_Move(MY_PORT->limbo_return))
			{
				Set_Prompt(getmsg(MSG521), DANGER_MOVE_PROMPT);
				DONE;
			}
		}
		else
		{
			if (Danger_Move(ABUF(B)->rm.exit[dir]))
			{
				Set_Prompt(getmsg(MSG521), DANGER_MOVE_PROMPT);
				DONE;
			}
		}
	}

	dir = MY_PORT->misc;

	if (ABUF(B)->rm.exit[dir] == 0)
	{
		prfmsg(M527);
		BAD_EXIT;
	}

	i = Stop_Me_Check(ABUF(B)->rm.exit[dir]);
	
	if (i >= 0)
	{
		if (option == 0 && MY_PORT->fine)
		{
			sprintf(str, getmsg(MSG1413), MY_PORT->fine);
			prf(str);
			Set_Prompt(getmsg(MSG1414), FINE_MOVE_PROMPT);
			DONE;
		}

		Start_Mon_Name(name, i);
		prfmsg(M522, name);
		sprintf(str, getmsg(MSG523), name, me.name);
		Message(str, LOUD_LOCAL);
		BAD_EXIT;
	}

	if (MY_PORT->drag_mon >= 0)
	{
		i = me.location;
		me.location = ABUF(B)->rm.exit[dir];
		pursued = Pursuit_Check();
		me.location = i;

		if (!MY_PORT->dragged)
		{
			BAD_EXIT;
		}
	}
	else if (MY_PORT->drag_guy >= 0)
	{
		MY_PORT->dragged = TRUE;
		prfmsg(MSG1541, APORT(MY_PORT->drag_guy)->chr.name, MY_PORT->str);
		sprintf(str, getmsg(MSG1542), me.name, "you", MY_PORT->str);
		Message(str, MY_PORT->drag_guy);
		sprintf
		(
			str, 
			getmsg(MSG1542), 
			me.name, 
			APORT(MY_PORT->drag_guy)->chr.name,
			MY_PORT->str
		);
		Message(str, -(MY_PORT->drag_guy + 1));
	}

	for (i = 0; i != NTERMS; ++i)
	{
		APORT(i)->follower[P] = FALSE;
	}

	Set_Tracks(dir);

	if (MY_PORT->limbo_return)
	{
		No_Follow();
	}

	for (i = 1, followers = 0; i != NTERMS; ++i)
	{
		if (APORT(i)->status && i != P && ABUF(B)->guy[i])
		{
			++followers;
		}
	}

	if (followers && !me.perm[INVIS_PORT_PERM] && command != DRAG)
	{
		for (i = followers = 0; i != NTERMS; ++i)
		{
			if (MY_PORT->follower[i])
			{   
				++followers;
			}
		}

		if (followers)
		{
			sprintf(globals->who, getmsg(MSG525), me.name);
		}
		else
		{
			sprintf(globals->who, "%s", me.name);
		}

		sprintf(str, getmsg(MSG528), globals->who, MY_PORT->command);
		Message(str, QUIET_LOCAL);
	}

	if (MY_PORT->limbo_return)
	{
		me.location = MY_PORT->limbo_return;
		MY_PORT->limbo_return = 0;
	}
	else
	{
		if (me.location == globals->limboloc)
		{
			me.location = RANDOM(globals->maxroom);
		}
		else
		{
			me.location = ABUF(B)->rm.exit[dir];
		}
	}

	me.location = Closet_Check(me.location);

	if (MY_PORT->drag_mon < 0)
	{
		pursued = Pursuit_Check();
	}

	Captive_Check(me.location);

	if (pursued < 0)
	{
		move_me_to(me.location, CLEAR_OLD);
	}
	else
	{
		move_me_to(-me.location, CLEAR_OLD);
	}

	Do_Followers();
	Fatigue(ADD); 
	return (TRUE);
}
/****************************************************************************
	see if the captive is around and going to follow me
*/
short Captive_Check(short r)
{
	short   m;
	short   invaders = 0;
	short   sleep_t;

	if (!invasion->active || SAFE_AREA)
	{
		BAD_EXIT;
	}
	
	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		if (AMON->what && AMON->which == invasion->crit)
		{
			++invaders;
		}
	}

	for (m = 0; m != MAX_ROOM_MON; ++m)
	{
		sleep_t = find_timer(SLEEP_TIME, MON);

		if 
		(
			!sleep_t &&
			AMON->what && 
			AMON->which == globals->rover && 
			AMON->sees[P]
		)
		{
			if (globals->captive_timer || invaders)
			{
				prfmsg(MSG829, globals->captive, me.name);
				BAD_EXIT;
			}

			if (MY_PORT->invader_count < globals->joekill2)
			{
				prfmsg
				(
					MSG1017, 
					globals->joekill2 - MY_PORT->invader_count,
					globals->captive
				);
				BAD_EXIT;
			}

			globals->captive_next_room = r;
			prfmsg(MSG828, globals->captive);
			DONE;
		}
	}

	DONE;
}
/****************************************************************************
	have my followers follow me
*/
void Do_Followers(void)
{
	short   i;

	outprf(MY_PORT->usrnum);
	clrprf();

	for (i = 0; i != NTERMS; ++i)
	{
		if (MY_PORT->follower[i] || i == MY_PORT->drag_guy)
		{
			Force_Guy_Move(i, me.location);
			Send_Buf(APORT(i)->usrnum);
		}
	}
}
/****************************************************************************
	check destination to see if monsters can go there
*/
short monsters_can_go_to(short r)
{
	short   i;
	short   m;
	short   mons;

	Read_Room(r, &globals->next_room, &a_room2);

	if (SAFE_HAVEN)
	{
		return (0);
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (ABUF(i)->in_use && ABUF(i)->rm.id == r)
		{
			for (m = mons = 0; m != MAX_ROOM_MON; ++m)
			{
				if (ABUF(i)->mon[m].what)
				{
					++mons;
				}
			}

			return (MAX_ROOM_MON - mons);
		}
	}

	for (i = mons = 0; i != MAX_PERM_MON; ++i)
	{
		if (abs(globals->perm_mon_loc[i]) == r && r)
		{                                  
			++mons;
		}
	}

	if (invasion->active)
	{
		for (i = 0; i != MAX_INVASION_ROOMS; ++i)
		{
			if (r && invasion->room[i] == r)
			{
				mons += invasion->count[i];
			}
		}
	}

	mons += globals->next_room.mons;
	mons = MAX_ROOM_MON - mons;
	
	if (mons < 0)
	{
		mons = 0;
	}

	return (mons);
}
/****************************************************************************
	see if I'm entering an occupied closet or solo room
*/
short Go_Closet(short r)
{
	short   i;

	Read_Room(r, &a_room, &a_room2);

	if (a_room.rmtype != CLOSET && a_room.rmtype != SOLO_ROOM)
	{
		return (TRUE);
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (ABUF(i)->in_use && ABUF(i)->rm.id == r)
		{
			BAD_EXIT;
		}
	}

	return (TRUE);
}
/****************************************************************************
	see if I'm entering an occupied closet
*/
short EXPORT Closet_Check(short r)
{
	short   i;

	Read_Room(r, &a_room, &a_room2);

	if (a_room.rmtype != CLOSET && a_room.rmtype != SOLO_ROOM)
	{
		return (r);
	}

	for (i = 0; i != NTERMS; ++i)
	{
		if (ABUF(i)->in_use && ABUF(i)->rm.id == r)
		{
			prfmsg(M529);
			return (globals->townsq);
		}
	}

	return (r);
}
