#include <header.h>
#include <globals.h>

/****************************************************************************
    user wants to sell something at the mercantile
*/
void EXPORT Sell(void)
{
    short   i;
    short   j;
    short   n;
    short   lo;
    short   hi;
    short   basement;
    short   keep_container;
    short   range;
    MLONG   offer;
    MLONG   total = 0;

    if (MY_PORT->status == MERC_PROMPT2 || MY_PORT->status == DO_PROMPT)
    {
        if
        (
            ABUF(B)->rm.spec_exit.filter &&
            ABUF(B)->rm.spec_exit.filter <= NUM_SAVED_PLACES - 1
        )
        {
            Guild_Sell(0);
            return;
        }

        for (i = 0; i != NUM_ITEMS; ++i)
        {
            MY_PORT->selling[i] = FALSE;
        }

        if (MY_PORT->status == DO_PROMPT)
        {
            j = 2;
        }
        else
        {
            j = 0;
        }

        for (i = j; i != margc; ++i)
        {
            for (j = range = 0; j != strlen(margv[i]); ++j)
            {
                if (margv[i][j] == '-')
                {
                    str[j] = 0;
                    lo = INUM(str) - 1;
                    hi = lo;
                    if (margv[i][j + 1] != 0)
                    {
                        strcpy(str, &margv[i][j + 1]);
                        hi = INUM(str) - 1;
                    }
                    range = TRUE;
                }
                else
                {
                    str[j] = margv[i][j];
                    str[j + 1] = 0;
                }
            }

            if (!range)
            {
                lo = INUM(str) - 1;
                hi = lo;
            }

            for (n = lo; n < hi + 1; ++n)
            {
                if (n >= 0 && n < NUM_ITEMS && me.item[n].what)
                {
                    if (TYPE == ARMORY && !ARSH(me.item[n]))
                    {
                        prfmsg(MSG1044);

                        if (MY_PORT->hot_menu)
                        {
                            MY_PORT->hot_menu = FALSE;
                            MY_PORT->status = DO_PROMPT;
                        }
                        else
                        {
                            Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
                        }

                        return;
                    }
                    
                    if (TYPE == WEAPONSMITH && !WEAPON(me.item[n]))
                    {
                        prfmsg(MSG1045);

                        if (MY_PORT->hot_menu)
                        {
                            MY_PORT->hot_menu = FALSE;
                            MY_PORT->status = DO_PROMPT;
                        }
                        else
                        {
                            Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
                        }

                        return;
                    }
                    
                    if 
                    (
                        TYPE == ALCHEMIST && 
                        me.item[n].what != MAGIC_DEV &&
                        me.item[n].what != TRANSPORTER &&
                        me.item[n].what != AMULET &&
                        me.item[n].what != PSY_FOCUS
                    )
                    {
                        prfmsg(MSG1046);

                        if (MY_PORT->hot_menu)
                        {
                            MY_PORT->hot_menu = FALSE;
                            MY_PORT->status = DO_PROMPT;
                        }
                        else
                        {
                            Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
                        }

                        return;
                    }
                    
                    MY_PORT->selling[n] = TRUE;
                }
            }
        }
    }

    if (MY_PORT->status == MERC_PROMPT2 || MY_PORT->status == DO_PROMPT)
    {
        for (n = NUM_ITEMS - 1, total = 0; n >= 0; --n)
        {
            if (MY_PORT->selling[n] && me.item[n].what)
            {
                ++total;
                offer = Calc_Val(&me.item[n]);

                if (offer <= 0)
                {
                    offer = 1;
                }

                if (me.item[n].what == CONTAINER && me.item[n].holding)
                {
                    offer = Bag_Value(&me.item[n]);
                }
           
                if (TYPE != MERCANTILE)
                {
                    offer = (offer * (100 + globals->selldisc)) / 100;
                }

                sprintf(str, getmsg(MSG1558), offer);
                prf(str);
                Display_Item(&me.item[n]);
                prf("!\r");
            }
        }

        if (total == 0)
        {
            if (MY_PORT->hot_menu)
            {
                MY_PORT->hot_menu = FALSE;
                MY_PORT->status = DO_PROMPT;
            }
            else
            {
                Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
            }
        }
        else
        {
            Set_Prompt(getmsg(MSG1559), CONFIRM_SELL_PROMPT);
        }

        return;
    }

    Read_Catalog(&globals->a_store, ABUF(B)->rm.id, TYPE);

    for (n = NUM_ITEMS - 1; n >= 0; --n)
    {
        if (MY_PORT->selling[n])
        {
            offer = Calc_Val(&me.item[n]);

            if (offer <= 0)
            {
                offer = 1;
            }

            if (me.item[n].what == CONTAINER && me.item[n].holding)
            {
                offer = Bag_Value(&me.item[n]);
                keep_container = TRUE;
            }
            else
            {
                keep_container = FALSE;
            }
           
            if (TYPE != MERCANTILE)
            {
                offer = (offer * (100 + globals->selldisc)) / 100;
            }

            total += offer;

            if (globals->autobank)
            {
                if ((double) me.bank + (double) offer < GCMAXLONG)
                {
                    me.bank += offer;
                }
            }
            else
            {
                if ((double) me.gold + (double) offer < GCMAXLONG)
                {   
                    me.gold += offer;
                }
            }

            basement = FALSE;

            if (keep_container)
            {
                basement = TRUE;
            }
            else if (ARSH(me.item[n]) && me.item[n].uses < globals->minarmor)
            {
                basement = TRUE;
            }
            else if (WEAPON(me.item[n]) && me.item[n].uses < globals->minwep)
            {
                basement = TRUE;
            }
            else if 
            (
                me.item[n].what == MAGIC_DEV && 
                me.item[n].uses < globals->minmagic
            )
            {
                basement = TRUE;
            }

            if (me.item[n].what == CONTAINER)
            {
                Kill_Container(&me.item[n]);
            }

            if (!basement)
            {
                for (i = NUM_ITEMS - 2; i >= 0; --i)
                {
                    globals->a_store.old[i + 1] = globals->a_store.old[i];
                }
                globals->a_store.old[0] = me.item[n];
            }
        
            if (!keep_container)
            {
                Lose_Item(n); 
            }
        }
    }

    Write_Catalog(&globals->a_store, ABUF(B)->rm.id);

    if (total)
    {
        prfmsg(MSG1531, l2as(total));
    }

    if (MY_PORT->hot_menu)
    {
        MY_PORT->hot_menu = FALSE;
        MY_PORT->status = DO_PROMPT;
    }
    else
    {
        Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
    }
}
/****************************************************************************
    user wants to sell something at a guild
*/
void EXPORT Guild_Sell(short option)
{
    short   i;
    short   g;
    short   avail = -1;
    MLONG   offer;

    g = ABUF(B)->rm.spec_exit.filter;

    if (me.in_guild != g)
    {
        prfmsg(M1058, g);

        if (MY_PORT->hot_menu)
        {
            MY_PORT->hot_menu = FALSE;
            MY_PORT->status = DO_PROMPT;
        }
        else
        {
            Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
        }

        return;
    }

    if (option == 0)
    {
        Read_Guild_Catalog(g, a_closet);
        for (i = 0; i != NUM_ITEMS && avail < 0; ++i)
        {
            if (a_closet->item[i].what == 0)
            {
                avail = i;
            }
        }

        if (avail < 0)
        {
            prfmsg(M1059);

            if (MY_PORT->hot_menu)
            {
                MY_PORT->hot_menu = FALSE;
                MY_PORT->status = DO_PROMPT;
            }
            else
            {
                Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
            }
            
            return;
        }

        if (MY_PORT->status == DO_PROMPT)
        {
            MY_PORT->misc = INUM(margv[2]) - 1;
        }
        else
        {
            MY_PORT->misc = INUM(margv[0]) - 1;
        }

        if 
        (
            MY_PORT->misc < 0 || 
            MY_PORT->misc >= NUM_ITEMS || 
            me.item[MY_PORT->misc].what == 0
        )
        {
            if (MY_PORT->hot_menu)
            {
                MY_PORT->hot_menu = FALSE;
                MY_PORT->status = DO_PROMPT;
            }
            else
            {
                Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
            }

            return;
        }

        prfmsg(MSG1060);
        Display_Item(&me.item[MY_PORT->misc]);
        prf(NL);

        if 
        (
            me.item[MY_PORT->misc].what == CONTAINER && 
            me.item[MY_PORT->misc].holding
        )
        {
            prfmsg(M1061, me.name);

            if (MY_PORT->hot_menu)
            {
                MY_PORT->hot_menu = FALSE;
                MY_PORT->status = DO_PROMPT;
            }
            else
            {
                Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
            }

            return;
        }

        Set_Prompt(getmsg(MSG1062), GUILD_SELL_PROMPT);
    }
    else    
    {
        if (!me.item[MY_PORT->misc].what)
        {
            if (MY_PORT->hot_menu)
            {
                MY_PORT->hot_menu = FALSE;
                MY_PORT->status = DO_PROMPT;
            }
            else
            {
                Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
            }

            return;
        }
       
        if
        (
            ABUF(B)->rm.spec_exit.filter < 1 ||
            ABUF(B)->rm.spec_exit.filter > NUM_SAVED_PLACES - 1
        )
        {
            if (MY_PORT->hot_menu)
            {
                MY_PORT->hot_menu = FALSE;
                MY_PORT->status = DO_PROMPT;
            }
            else
            {
                Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
            }

            return;
        }

        if (margc == 0)
        {
            prfmsg(MSG1063);

            if (MY_PORT->hot_menu)
            {
                MY_PORT->hot_menu = FALSE;
                MY_PORT->status = DO_PROMPT;
            }
            else
            {
                Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
            }
        }
        else
        {
            Read_Guild_Catalog(g, a_closet);
            for (i = 0; i != NUM_ITEMS && avail < 0; ++i)
            {
                if (a_closet->item[i].what == 0)
                {
                    avail = i;
                }
            }

            if (avail < 0)
            {
                prfmsg(M1059);

                if (MY_PORT->hot_menu)
                {
                    MY_PORT->hot_menu = FALSE;
                    MY_PORT->status = DO_PROMPT;
                }
                else
                {
                    Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
                }

                return;
            }

            Set_Long(&offer); 

            if (offer < 1L)
            {
                offer = 1L;
            }
            else if (offer > 99999999L)
            {
                offer = 99999999L;
            }
            
            prfmsg(MSG1064, me.name);
            a_closet->item[avail] = me.item[MY_PORT->misc];
            a_closet->item[avail].old_worth = a_closet->item[avail].worth;
            a_closet->item[avail].worth = offer;

            Lose_Item(MY_PORT->misc); 
            Write_Guild_Catalog(g, a_closet);

            if (MY_PORT->hot_menu)
            {
                MY_PORT->hot_menu = FALSE;
                MY_PORT->status = DO_PROMPT;
            }
            else
            {
                Set_Prompt(getmsg(MSG1527), MERC_PROMPT);
            }
        }
    }
}
/****************************************************************************
    user wants to buy something
*/
void EXPORT Buy(void)
{
    short   which;
    short   i;
    MLONG   price;
    short   item_num;
    short   pawned  = 0;
    short   num_items;
    MLONG   carrying;
    MLONG   max;
    struct  item_struct item;

    if (MY_PORT->status == DO_PROMPT)
    {
        which = INUM(margv[2]);
    }
    else
    {
        which = INUM(margv[0]);
    }

    if
    (
        ABUF(B)->rm.spec_exit.filter &&
        ABUF(B)->rm.spec_exit.filter <= NUM_SAVED_PLACES - 1
    )
    {
        Guild_Buy(ABUF(B)->rm.spec_exit.filter);
        return;
    }

    Calc_Weight(&num_items, &carrying, &max);

    if (num_items == NUM_ITEMS)
    {
        prfmsg(M1022, NUM_ITEMS);
        return;
    }

    Read_Catalog(&globals->a_store, ABUF(B)->rm.id, TYPE);

    for (i = 0; i != MAX_PAWNED && globals->a_store.old[i].what; ++i)
    {
        if (globals->a_store.old[i].what)
        {
            ++pawned;
        }
    }

    if (which > MAX_MERC_ITEM + pawned || which == 0)
    {
        return;
    }

    if (which > MAX_MERC_ITEM)
    {
        item = globals->a_store.old[which - MAX_MERC_ITEM - 1];
    }
    else
    {
        item_num = globals->a_store.new[which - 1];
        memcpy
        (
            (char *) &item,
            Create_Item(item_num, NULL, 100, globals->shoplevl, FALSE),
            (size_t) ITEMSIZE
        );
        item.merc_item = TRUE;
    }

    item.new_bag = FALSE;
    price = Calc_Val(&item) * 2;

    if (TYPE != MERCANTILE)
    {
        price = (price * (100 - globals->buydisc)) / 100;
    }

    if (price > Money() && !me.perm[SUPER_PERM])
    {
        prfmsg(M1115);
        return;
    }

    if (carrying + Weight(&item) > max && !me.perm[SUPER_PERM])
    {
        prfmsg(M1023);
        return;
    }

    me.gold -= price;

    if (me.gold < 0)
    {
        me.bank += me.gold;
        me.gold = 0;
    }

    if (me.bank < 0 && me.perm[SUPER_PERM])
    {
        me.bank = 0;
    }

    Give_Me(&item);
    prfmsg(MSG1116, item.name);
    sprintf(str, getmsg(MSG1117), me.name);
    Cat_Item(str, &item);
    Message(str, LOUD_LOCAL);

    if (which > MAX_MERC_ITEM)
    {
        which = which - MAX_MERC_ITEM - 1;
        globals->a_store.old[which].what = 0;

        if (which + 1 != NUM_ITEMS)
        {
            for (i = which + 1; i != NUM_ITEMS; ++i)
            {
                globals->a_store.old[i - 1] = globals->a_store.old[i];
            }
        }
        globals->a_store.old[NUM_ITEMS - 1].what = 0;
        Write_Catalog(&globals->a_store, ABUF(B)->rm.id); 
    }
}
/****************************************************************************
    user wants to buy something from a guild store
*/
void EXPORT Guild_Buy(short g)
{
    short   which;
    short   i;
    MLONG   price;
    short   pawned  = 0;
    short   num_items;
    MLONG   carrying, max;
    struct  item_struct item;
    char    today_date[DATE_SIZE];
    char    now_time[TIME_SIZE];
    struct  public_post_struct *msg;    

    if (MY_PORT->status == DO_PROMPT)
    {
        which = INUM(margv[2]) - 1;
    }
    else
    {
        which = INUM(margv[0]) - 1;
    }

    Calc_Weight(&num_items, &carrying, &max);

    if (num_items == NUM_ITEMS)
    {
        prfmsg(M1022, NUM_ITEMS);
        return;
    }

    Read_Guild_Catalog(g, a_closet);

    for (i = 0; i != NUM_ITEMS && a_closet->item[i].what; ++i)
    {
        if (a_closet->item[i].what)
        {
            ++pawned;
        }
    }

    if (pawned == 0)
    {
        return;
    }

    if (which >= pawned || which < 0)
    {
        return;
    }

    item = a_closet->item[which];
    price = item.worth;
    
    if (!me.perm[SUPER_PERM] && me.in_guild != g) 
    {
        if (price > Money())
        {
            prfmsg(M1115);
            return;
        }
    }

    if (carrying + Weight(&item) > max && !me.perm[SUPER_PERM])
    {
        prfmsg(M1023);
        return;
    }

    if (!me.perm[SUPER_PERM] && me.in_guild != g)
    {
        me.gold -= price;
        if (me.gold < 0)
        {
            me.bank += me.gold;
            me.gold = 0;
        }
        change_treasury(g, price);
    }

    if (item.old_worth)
    {
        item.worth = item.old_worth;
    }
    else
    {
        item.worth = 1;
    }

    item.new_bag = FALSE;

    Give_Me(&item);
    prfmsg(MSG1116, item.name);
    sprintf(str, getmsg(MSG1117), me.name);
    Cat_Item(str, &item);
    Message(str, LOUD_LOCAL);

    msg = (struct public_post_struct *) vdaptr;                          
    setmem(msg, PUBLIC_MSG_SIZE, 0);
    msg->from = me.in_guild;
    msg->to = g;
    
    TODAY(today_date);
    NOW(now_time);

    sprintf
    (
        msg->header, 
        getmsg(MSG1357),
        g,
        me.name,
        Brief_Userid(me.Userid),
        today_date,
        now_time
    );

    sprintf(msg->body[0], "%s purchased ", me.name);
    Cat_Item(msg->body[0], &item);
    sprintf(msg->body[1], "Price: %ld", price);
    Put_Public_Message(msg);

    a_closet->item[which].what = 0;

    if (which + 1 != NUM_ITEMS)
    {
        for (i = which + 1; i != NUM_ITEMS; ++i)
        {
            a_closet->item[i - 1] = a_closet->item[i];
        }
    }
    a_closet->item[NUM_ITEMS - 1].what = 0;
    Write_Guild_Catalog(g, a_closet);
}
/****************************************************************************
    display items available in the mercantile
*/
short EXPORT Catalog(void)
{
    MLONG   misc;
    MLONG   price;
    short   i;
    short   n;
    struct  item_struct *item;

    if
    (
        ABUF(B)->rm.spec_exit.filter &&
        ABUF(B)->rm.spec_exit.filter <= NUM_SAVED_PLACES - 1
    )
    {
        return (Guild_Catalog(ABUF(B)->rm.spec_exit.filter));
    }

    Read_Catalog
    (
        &globals->a_store,
        ABUF(B)->rm.id,
        TYPE
    );
    prfmsg(STOREH);

    for (i = 0; i != MAX_MERC_ITEM; ++i)
    {
        n = globals->a_store.new[i];

        if (n)
        {
            item = Create_Item(n, NULL, 100, globals->shoplevl, FALSE),
            price = Calc_Val(item);
            price = price * 2;

            if (TYPE != MERCANTILE)
            {
                price = (price * (100 - globals->buydisc)) / 100;
            }

            if (ARSH_P(item))
            {
                misc = item->ac;
            }
            else
            {
                misc = item->Hits;
            }

            sprintf
            (
                str, 
                getmsg(STOREI), 
                i + 1, 
                price, 
                Weight(item),
                item->uses,
                item->item_level,
                misc
            );
            prf(str);

            Color_Display_Item(item);
            prf("\r");
        }
    }

    for (i = 0; i != MAX_PAWNED && globals->a_store.old[i].what; ++i)
    {
        if (globals->a_store.old[i].what)
        {
            price = Calc_Val(&globals->a_store.old[i]);
            price = price * 2;

            if (TYPE != MERCANTILE)
            {
                price = (price * (100 - globals->buydisc)) / 100;
            }

            if (ARSH(globals->a_store.old[i]))
            {
                misc = globals->a_store.old[i].ac;
            }
            else
            {
                misc = globals->a_store.old[i].Hits;
            }

            sprintf
            (
                str,
                getmsg(STOREI), 
                i + MAX_MERC_ITEM + 1, 
                price, 
                Weight(&globals->a_store.old[i]),
                globals->a_store.old[i].uses,
                globals->a_store.old[i].item_level,
                misc
            );
            prf(str);

            Color_Display_Item(&globals->a_store.old[i]);
            prf("\r");
        }
    }

    return (TRUE);
}
/****************************************************************************
    display items available in a guild store
*/
short EXPORT Guild_Catalog(short g)
{
    MLONG   misc;
    short   i;
    short   did_one = FALSE;

    if (sameas(guild->name[g], OPEN_GUILD))
    {
        prfmsg(M1003, g);
        BAD_EXIT;
    }

    Read_Guild_Catalog(g, a_closet);

    for (i = 0; i != NUM_ITEMS && a_closet->item[i].what; ++i)
    {
        if (a_closet->item[i].what)
        {
            if (!did_one)
            {
                prfmsg(MSG1004, guild->name[g]);
                prfmsg(STOREH);
                did_one = TRUE;
            }

            if (ARSH(a_closet->item[i]))
            {
                misc = a_closet->item[i].ac;
            }
            else
            {
                misc = a_closet->item[i].Hits;
            }

            sprintf
            (
                str,
                getmsg(STOREI), 
                i + 1, 
                a_closet->item[i].worth, 
                Weight(&a_closet->item[i]),
                a_closet->item[i].uses,
                a_closet->item[i].item_level,
                misc
            );
            prf(str);

            Color_Display_Item(&a_closet->item[i]);
            prf("\r");
        }
    }

    if (!did_one)
    {
        prfmsg(M1005, g);
        BAD_EXIT;
    }

    return (TRUE);
}
/****************************************************************************
    read a store's catalog
*/
void EXPORT Read_Catalog(struct store_struct *store, short r, short store_type)
{
    short   i;
    FILE    *fp;

    sprintf(globals->path, CATALOG_PATH, r);

    Create_New(globals->path);
    fp = fopen(globals->path, RDWR);

    if (fp == NULL)
    {
        NOTIFY("STORE READ FAILED!");
    }
    else
    {
        i = fread(store, STORE_SIZE, 1, fp);
        fclose(fp);

        if (i != 1)
        {
            setmem(store, STORE_SIZE, 0);

            if (store_type == MERCANTILE)
            {
                for (i = 0; i != MAX_MERC_ITEM; ++i)
                {
                    store->new[i] = numopt(MERCI1 + i, -32767, 32767);
                }    
            }
            else if (store_type == ARMORY)
            {
                for (i = 0; i != MAX_MERC_ITEM; ++i)
                {
                    store->new[i] = numopt(ARMOR1 + i, -32767, 32767);
                }    
            }
            else if (store_type == WEAPONSMITH)
            {
                for (i = 0; i != MAX_MERC_ITEM; ++i)
                {
                    store->new[i] = numopt(WEP1 + i, -32767, 32767);
                }    
            }
            else if (store_type == ALCHEMIST)
            {
                for (i = 0; i != MAX_MERC_ITEM; ++i)
                {
                    store->new[i] = numopt(ALCHEM1 + i, -32767, 32767);
                }    
            }

            Write_Catalog(store, r);
        }
    }
}
/****************************************************************************
    write a store's catalog
*/
void EXPORT Write_Catalog(struct store_struct *store, short r)
{
    FILE    *fp;

    sprintf(globals->path, CATALOG_PATH, r);

    Create_New(globals->path);
    fp = fopen(globals->path, RDWR);

    if (fp == NULL)
    {
        NOTIFY("STORE WRITE FAILED!");
    }
    else
    {
        fwrite(store, STORE_SIZE, 1, fp);
        fclose(fp);
    }
}
/****************************************************************************
    read a guild store
*/
void EXPORT Read_Guild_Catalog(short g, struct closet_struct *closet)
{
    short   i;
    FILE    *fp;

    sprintf(globals->path, "%s\\GSTORE%d.DAT", DATA_PATH, g);

    Create_New(globals->path);
    fp = fopen(globals->path, RDWR);

    if (fp == NULL)
    {
        NOTIFY("GUILD STORE READ FAILED!");
    }
    else
    {
        i = fread(closet, CLOSET_SIZE, 1, fp);
        fclose(fp);

        if (i == 0)
        {
            setmem(closet, CLOSET_SIZE, 0);
        }
    }
}
/****************************************************************************
    write a guild store catalog
*/
void EXPORT Write_Guild_Catalog(short g, struct closet_struct *closet)
{
    FILE    *fp;

    sprintf(globals->path, "%s\\GSTORE%d.DAT", DATA_PATH, g);

    Create_New(globals->path);
    fp = fopen(globals->path, RDWR);

    if (fp == NULL)
    {
        NOTIFY("GUILD STORE WRITE FAILED!");
    }
    else
    {
        fwrite(closet, CLOSET_SIZE, 1, fp);
        fclose(fp);
    }
}

